import pandas as pd

gams_maps = {}

bea_all = [
    ("111CA", "agr", "goods", "Farms"),
    ("113FF", "fof", "goods", "Forestry, fishing, and related activities"),
    ("211", "oil", "goods", "Oil and gas extraction"),
    ("212", "min", "goods", "Mining, except oil and gas"),
    ("213", "smn", "goods", "Support activities for mining"),
    ("22", "uti", "goods", "Utilities"),
    ("23", "con", "goods", "Construction"),
    ("321", "wpd", "goods", "Wood products"),
    ("327", "nmp", "goods", "Nonmetallic mineral products"),
    ("331", "pmt", "goods", "Primary metals"),
    ("332", "fmt", "goods", "Fabricated metal products"),
    ("333", "mch", "goods", "Machinery"),
    ("334", "cep", "goods", "Computer and electronic products"),
    ("335", "eec", "goods", "Electrical equipment, appliances, and components"),
    ("3361MV", "mot", "goods", "Motor vehicles, bodies and trailers, and parts"),
    ("3364OT", "ote", "goods", "Other transportation equipment"),
    ("337", "fpd", "goods", "Furniture and related products"),
    ("339", "mmf", "goods", "Miscellaneous manufacturing"),
    ("311FT", "fbp", "goods", "Food and beverage and tobacco products"),
    ("313TT", "tex", "goods", "Textile mills and textile product mills"),
    ("315AL", "alt", "goods", "Apparel and leather and allied products"),
    ("322", "ppd", "goods", "Paper products"),
    ("323", "pri", "goods", "Printing and related support activities"),
    ("324", "pet", "goods", "Petroleum and coal products"),
    ("325", "che", "goods", "Chemical products"),
    ("326", "pla", "goods", "Plastics and rubber products"),
    ("42", "wht", "goods", "Wholesale trade"),
    ("441", "mvt", "goods", "Motor vehicle and parts dealers"),
    ("445", "fbt", "goods", "Food and beverage stores"),
    ("452", "gmt", "goods", "General merchandise stores"),
    ("4A0", "ott", "goods", "Other retail"),
    ("481", "air", "goods", "Air transportation"),
    ("482", "trn", "goods", "Rail transportation"),
    ("483", "wtt", "goods", "Water transportation"),
    ("484", "trk", "goods", "Truck transportation"),
    ("485", "grd", "goods", "Transit and ground passenger transportation"),
    ("486", "pip", "goods", "Pipeline transportation"),
    ("487OS", "otr", "goods", "Other transportation and support activities"),
    ("493", "wrh", "goods", "Warehousing and storage"),
    (
        "511",
        "pub",
        "goods",
        "Publishing industries, except internet (includes software)",
    ),
    ("512", "mov", "goods", "Motion picture and sound recording industries"),
    ("513", "brd", "goods", "Broadcasting and telecommunications"),
    (
        "514",
        "dat",
        "goods",
        "Data processing, internet publishing, and other information services",
    ),
    (
        "521CI",
        "bnk",
        "goods",
        "Federal Reserve banks, credit intermediation, and related activities",
    ),
    ("523", "sec", "goods", "Securities, commodity contracts, and investments"),
    ("524", "ins", "goods", "Insurance carriers and related activities"),
    ("525", "fin", "goods", "Funds, trusts, and other financial vehicles"),
    ("HS", "hou", "goods", "Housing"),
    ("ORE", "ore", "goods", "Other real estate"),
    (
        "532RL",
        "rnt",
        "goods",
        "Rental and leasing services and lessors of intangible assets",
    ),
    ("5411", "leg", "goods", "Legal services"),
    ("5415", "com", "goods", "Computer systems design and related services"),
    (
        "5412OP",
        "tsv",
        "goods",
        "Miscellaneous professional, scientific, and technical services",
    ),
    ("55", "man", "goods", "Management of companies and enterprises"),
    ("561", "adm", "goods", "Administrative and support services"),
    ("562", "wst", "goods", "Waste management and remediation services"),
    ("61", "edu", "goods", "Educational services"),
    ("621", "amb", "goods", "Ambulatory health care services"),
    ("622", "hos", "goods", "Hospitals"),
    ("623", "nrs", "goods", "Nursing and residential care facilities"),
    ("624", "soc", "goods", "Social assistance"),
    (
        "711AS",
        "art",
        "goods",
        "Performing arts, spectator sports, museums, and related activities",
    ),
    ("713", "rec", "goods", "Amusements, gambling, and recreation industries"),
    ("721", "amd", "goods", "Accommodation"),
    ("722", "res", "goods", "Food services and drinking places"),
    ("81", "osv", "goods", "Other services, except government"),
    ("GFGD", "fdd", "goods", "Federal general government (defense)"),
    ("GFGN", "fnd", "goods", "Federal general government (nondefense)"),
    ("GFE", "fen", "goods", "Federal government enterprises"),
    ("GSLG", "slg", "goods", "State and local general government"),
    ("GSLE", "sle", "goods", "State and local government enterprises"),
    ("Other", "oth", "goods", "Noncomparable imports and rest-of-the-world adjustment"),
    ("Used", "use", "goods", "Scrap, used and secondhand goods"),
    ("T005", "interm", "", "Total Intermediate"),
    ("V001", "compen", "valueadded", "Compensation of employees"),
    ("V003", "surplus", "valueadded", "Gross operating surplus"),
    ("T00OTOP", "othtax", "valueadded", "Other taxes on production"),
    ("VABAS", "basicvalueadded", "", "Value Added (basic prices)"),
    ("T018", "industryoutput", "", "Total industry output (basic prices)"),
    ("T00TOP", "taxes", "taxessubsidies", "Taxes on products and imports"),
    ("T00SUB", "subsidies", "taxessubsidies", "Less: Subsidies"),
    ("VAPRO", "valueadded", "", "Value Added (producer prices)"),
    ("T001", "totint", "", "Total Intermediate"),
    ("F010", "pce", "finaldemand", "Personal consumption expenditures"),
    (
        "F02E",
        "equipment",
        "finaldemand",
        "Nonresidential private fixed investment in equipment",
    ),
    (
        "F02N",
        "intelprop",
        "finaldemand",
        "Nonresidential private fixed investment in intellectual property products",
    ),
    ("F02R", "residential", "finaldemand", "Residential private fixed investment"),
    (
        "F02S",
        "structures",
        "finaldemand",
        "Nonresidential private fixed investment in structures",
    ),
    ("F030", "changinv", "finaldemand", "Change in private inventories"),
    ("F040", "exports", "", "Exports of goods and services"),
    ("F06C", "defense", "finaldemand", "National defense: Consumption expenditures"),
    (
        "F06E",
        "def_equipment",
        "finaldemand",
        "Federal national defense: Gross investment in equipment",
    ),
    (
        "F06N",
        "def_intelprop",
        "finaldemand",
        "Federal national defense: Gross investment in intellectual property products",
    ),
    (
        "F06S",
        "def_structures",
        "finaldemand",
        "Federal national defense: Gross investment in structures",
    ),
    ("F07C", "nondefense", "finaldemand", "Nondefense: Consumption expenditures"),
    (
        "F07E",
        "fed_equipment",
        "finaldemand",
        "Federal nondefense: Gross investment in equipment",
    ),
    (
        "F07N",
        "fed_intelprop",
        "finaldemand",
        "Federal nondefense: Gross investment in intellectual property products",
    ),
    (
        "F07S",
        "fed_structures",
        "finaldemand",
        "Federal nondefense: Gross investment in structures",
    ),
    (
        "F10C",
        "state_consume",
        "finaldemand",
        "State and local government consumption expenditures",
    ),
    (
        "F10E",
        "state_equipment",
        "finaldemand",
        "State and local: Gross investment in equipment",
    ),
    (
        "F10N",
        "state_intelprop",
        "finaldemand",
        "State and local: Gross investment in intellectual property products",
    ),
    (
        "F10S",
        "state_invest",
        "finaldemand",
        "State and local: Gross investment in structures",
    ),
    ("T019", "totaluse", "", "Total use of products"),
    ("T017", "TotalBasic", "", "Total industry supply"),
    ("T007", "Output", "", "Total Commodity Output"),
    ("MCIF", "imports", "", "Imports"),
    ("MADJ", "ciffob", "", "CIF/FOB Adjustments on Imports"),
    ("T013", "BasicSupply", "", "Total product supply (basic prices)"),
    ("Trade", "Margins", "", "Trade margins"),
    ("Trans", "TrnCost", "", "Transport margins"),
    ("T014", "TrdTrn", "", "Total trade and transportation margins"),
    ("MDTY", "Duties", "", "Import duties"),
    ("TOP", "Tax", "", "Tax on products"),
    ("SUB", "Subsidies", "", "Subsidies"),
    ("T015", "TaxLesSubsidies", "", "Total tax less subsidies on products"),
    ("T016", "Supply", "", "Total product supply (purchaser prices)"),
]


gams_maps["bea_all"] = pd.DataFrame(
    bea_all, columns=["bea_code", "windc_label", "category", "description"]
)


bea_all_det = [
    ("1111A0", "oil_agr", "agr", "goods", "Oilseed farming"),
    ("1111B0", "grn_agr", "agr", "goods", "Grain farming"),
    ("111200", "veg_agr", "agr", "goods", "Vegetable and melon farming"),
    ("111300", "nut_agr", "agr", "goods", "Fruit and tree nut farming"),
    (
        "111400",
        "flo_agr",
        "agr",
        "goods",
        "Greenhouse, nursery, and floriculture production",
    ),
    ("111900", "oth_agr", "agr", "goods", "Other crop farming"),
    ("112120", "dry_agr", "agr", "goods", "Dairy cattle and milk production"),
    (
        "1121A0",
        "bef_agr",
        "agr",
        "goods",
        "Beef cattle ranching and farming, including feedlots and dual-purpose ranching and farming",
    ),
    ("112300", "egg_agr", "agr", "goods", "Poultry and egg production"),
    (
        "112A00",
        "ota_agr",
        "agr",
        "goods",
        "Animal production, except cattle and poultry and eggs",
    ),
    ("113000", "log_fof", "fof", "goods", "Forestry and logging"),
    ("114000", "fht_fof", "fof", "goods", "Fishing, hunting and trapping"),
    (
        "115000",
        "saf_fof",
        "fof",
        "goods",
        "Support activities for agriculture and forestry",
    ),
    ("211000", "oil_oil", "oil", "goods", "Oil and gas extraction"),
    ("212100", "col_min", "min", "goods", "Coal mining"),
    ("212230", "led_min", "min", "goods", "Copper, nickel, lead, and zinc mining"),
    (
        "2122A0",
        "ore_min",
        "min",
        "goods",
        "Iron, gold, silver, and other metal ore mining",
    ),
    ("212310", "stn_min", "min", "goods", "Stone mining and quarrying"),
    (
        "2123A0",
        "oth_min",
        "min",
        "goods",
        "Other nonmetallic mineral mining and quarrying",
    ),
    ("213111", "drl_smn", "smn", "goods", "Drilling oil and gas wells"),
    ("21311A", "oth_smn", "smn", "goods", "Other support activities for mining"),
    (
        "221100",
        "ele_uti",
        "uti",
        "goods",
        "Electric power generation, transmission, and distribution",
    ),
    ("221200", "gas_uti", "uti", "goods", "Natural gas distribution"),
    ("221300", "wat_uti", "uti", "goods", "Water, sewage and other systems"),
    ("233210", "hcs_con", "con", "goods", "Health care structures"),
    ("233262", "edu_con", "con", "goods", "Educational and vocational structures"),
    ("230301", "nmr_con", "con", "goods", "Nonresidential maintenance and repair"),
    ("230302", "rmr_con", "con", "goods", "Residential maintenance and repair"),
    ("2332A0", "off_con", "con", "goods", "Office and commercial structures"),
    ("233412", "mrs_con", "con", "goods", "Multifamily residential structures"),
    ("2334A0", "ors_con", "con", "goods", "Other residential structures"),
    ("233230", "mfs_con", "con", "goods", "Manufacturing structures"),
    ("2332D0", "ons_con", "con", "goods", "Other nonresidential structures"),
    ("233240", "pwr_con", "con", "goods", "Power and communication structures"),
    ("233411", "srs_con", "con", "goods", "Single-family residential structures"),
    (
        "2332C0",
        "trn_con",
        "con",
        "goods",
        "Transportation structures and highways and streets",
    ),
    ("321100", "saw_wpd", "wpd", "goods", "Sawmills and wood preservation"),
    (
        "321200",
        "ven_wpd",
        "wpd",
        "goods",
        "Veneer, plywood, and engineered wood product manufacturing",
    ),
    ("321910", "mil_wpd", "wpd", "goods", "Millwork"),
    ("3219A0", "owp_wpd", "wpd", "goods", "All other wood product manufacturing"),
    ("327100", "cly_nmp", "nmp", "goods", "Clay product and refractory manufacturing"),
    ("327200", "gla_nmp", "nmp", "goods", "Glass and glass product manufacturing"),
    ("327310", "cmt_nmp", "nmp", "goods", "Cement manufacturing"),
    ("327320", "cnc_nmp", "nmp", "goods", "Ready-mix concrete manufacturing"),
    (
        "327330",
        "cpb_nmp",
        "nmp",
        "goods",
        "Concrete pipe, brick, and block manufacturing",
    ),
    ("327390", "ocp_nmp", "nmp", "goods", "Other concrete product manufacturing"),
    ("327400", "lme_nmp", "nmp", "goods", "Lime and gypsum product manufacturing"),
    ("327910", "abr_nmp", "nmp", "goods", "Abrasive product manufacturing"),
    ("327991", "cut_nmp", "nmp", "goods", "Cut stone and stone product manufacturing"),
    (
        "327992",
        "tmn_nmp",
        "nmp",
        "goods",
        "Ground or treated mineral and earth manufacturing",
    ),
    ("327993", "wol_nmp", "nmp", "goods", "Mineral wool manufacturing"),
    ("327999", "mnm_nmp", "nmp", "goods", "Miscellaneous nonmetallic mineral products"),
    (
        "331110",
        "irn_pmt",
        "pmt",
        "goods",
        "Iron and steel mills and ferroalloy manufacturing",
    ),
    (
        "331200",
        "stl_pmt",
        "pmt",
        "goods",
        "Steel product manufacturing from purchased steel",
    ),
    (
        "331313",
        "ala_pmt",
        "pmt",
        "goods",
        "Alumina refining and primary aluminum production",
    ),
    ("326210", "tir_pla", "pla", "goods", "Tire manufacturing"),
    (
        "33131B",
        "alu_pmt",
        "pmt",
        "goods",
        "Aluminum product manufacturing from purchased aluminum",
    ),
    (
        "331410",
        "nms_pmt",
        "pmt",
        "goods",
        "Nonferrous Metal (except Aluminum) Smelting and Refining",
    ),
    (
        "331420",
        "cop_pmt",
        "pmt",
        "goods",
        "Copper rolling, drawing, extruding and alloying",
    ),
    (
        "331490",
        "nfm_pmt",
        "pmt",
        "goods",
        "Nonferrous metal (except copper and aluminum) rolling, drawing, extruding and alloying",
    ),
    ("331510", "fmf_pmt", "pmt", "goods", "Ferrous metal foundries"),
    ("331520", "nff_pmt", "pmt", "goods", "Nonferrous metal foundries"),
    ("332114", "rol_fmt", "fmt", "goods", "Custom roll forming"),
    ("33211A", "fss_fmt", "fmt", "goods", "All other forging, stamping, and sintering"),
    (
        "332119",
        "crn_fmt",
        "fmt",
        "goods",
        "Metal crown, closure, and other metal stamping (except automotive)",
    ),
    ("332200", "cut_fmt", "fmt", "goods", "Cutlery and handtool manufacturing"),
    (
        "332310",
        "plt_fmt",
        "fmt",
        "goods",
        "Plate work and fabricated structural product manufacturing",
    ),
    (
        "332320",
        "orn_fmt",
        "fmt",
        "goods",
        "Ornamental and architectural metal products manufacturing",
    ),
    (
        "332410",
        "pwr_fmt",
        "fmt",
        "goods",
        "Power boiler and heat exchanger manufacturing",
    ),
    ("332420", "mtt_fmt", "fmt", "goods", "Metal tank (heavy gauge) manufacturing"),
    (
        "332430",
        "mtc_fmt",
        "fmt",
        "goods",
        "Metal can, box, and other metal container (light gauge) manufacturing",
    ),
    ("332500", "hdw_fmt", "fmt", "goods", "Hardware manufacturing"),
    ("332600", "spr_fmt", "fmt", "goods", "Spring and wire product manufacturing"),
    ("332710", "mch_fmt", "fmt", "goods", "Machine shops"),
    (
        "332720",
        "tps_fmt",
        "fmt",
        "goods",
        "Turned product and screw, nut, and bolt manufacturing",
    ),
    (
        "332800",
        "ceh_fmt",
        "fmt",
        "goods",
        "Coating, engraving, heat treating and allied activities",
    ),
    (
        "332913",
        "plb_fmt",
        "fmt",
        "goods",
        "Plumbing fixture fitting and trim manufacturing",
    ),
    ("33291A", "vlv_fmt", "fmt", "goods", "Valve and fittings other than plumbing"),
    ("332991", "bbr_fmt", "fmt", "goods", "Ball and roller bearing manufacturing"),
    (
        "332996",
        "fab_fmt",
        "fmt",
        "goods",
        "Fabricated pipe and pipe fitting manufacturing",
    ),
    (
        "33299A",
        "amn_fmt",
        "fmt",
        "goods",
        "Ammunition, arms, ordnance, and accessories manufacturing",
    ),
    ("332999", "omf_fmt", "fmt", "goods", "Other fabricated metal manufacturing"),
    ("333111", "frm_mch", "mch", "goods", "Farm machinery and equipment manufacturing"),
    ("333112", "lwn_mch", "mch", "goods", "Lawn and garden equipment manufacturing"),
    ("333120", "con_mch", "mch", "goods", "Construction machinery manufacturing"),
    (
        "333130",
        "min_mch",
        "mch",
        "goods",
        "Mining and oil and gas field machinery manufacturing",
    ),
    ("333242", "smc_mch", "mch", "goods", "Semiconductor machinery manufacturing"),
    ("33329A", "oti_mch", "mch", "goods", "Other industrial machinery manufacturing"),
    ("333314", "opt_mch", "mch", "goods", "Optical instrument and lens manufacturing"),
    (
        "333316",
        "pht_mch",
        "mch",
        "goods",
        "Photographic and photocopying equipment manufacturing",
    ),
    (
        "333318",
        "oci_mch",
        "mch",
        "goods",
        "Other commercial and service industry machinery manufacturing",
    ),
    (
        "333414",
        "hea_mch",
        "mch",
        "goods",
        "Heating equipment (except warm air furnaces) manufacturing",
    ),
    (
        "333415",
        "acn_mch",
        "mch",
        "goods",
        "Air conditioning, refrigeration, and warm air heating equipment manufacturing",
    ),
    (
        "333413",
        "air_mch",
        "mch",
        "goods",
        "Industrial and commercial fan and blower and air purification equipment manufacturing",
    ),
    ("333511", "imm_mch", "mch", "goods", "Industrial mold manufacturing"),
    (
        "333514",
        "spt_mch",
        "mch",
        "goods",
        "Special tool, die, jig, and fixture manufacturing",
    ),
    ("333517", "mct_mch", "mch", "goods", "Machine tool manufacturing"),
    (
        "33351B",
        "cut_mch",
        "mch",
        "goods",
        "Cutting and machine tool accessory, rolling mill, and other metalworking machinery manufacturing",
    ),
    (
        "333611",
        "tbn_mch",
        "mch",
        "goods",
        "Turbine and turbine generator set units manufacturing",
    ),
    (
        "333612",
        "spd_mch",
        "mch",
        "goods",
        "Speed changer, industrial high-speed drive, and gear manufacturing",
    ),
    (
        "333613",
        "mch_mch",
        "mch",
        "goods",
        "Mechanical power transmission equipment manufacturing",
    ),
    ("333618", "oee_mch", "mch", "goods", "Other engine equipment manufacturing"),
    ("333912", "agc_mch", "mch", "goods", "Air and gas compressor manufacturing"),
    ("33391A", "ppe_mch", "mch", "goods", "Pump and pumping equipment manufacturing"),
    ("333920", "mat_mch", "mch", "goods", "Material handling equipment manufacturing"),
    ("333991", "pwr_mch", "mch", "goods", "Power-driven handtool manufacturing"),
    ("333993", "pkg_mch", "mch", "goods", "Packaging machinery manufacturing"),
    ("531HST", "rnt_hou", "hou", "goods", "Tenant-occupied housing"),
    (
        "333994",
        "ipf_mch",
        "mch",
        "goods",
        "Industrial process furnace and oven manufacturing",
    ),
    (
        "33399A",
        "ogp_mch",
        "mch",
        "goods",
        "Other general purpose machinery manufacturing",
    ),
    ("33399B", "fld_mch", "mch", "goods", "Fluid power process machinery"),
    ("334111", "ecm_cep", "cep", "goods", "Electronic computer manufacturing"),
    ("334112", "csd_cep", "cep", "goods", "Computer storage device manufacturing"),
    (
        "334118",
        "ctm_cep",
        "cep",
        "goods",
        "Computer terminals and other computer peripheral equipment manufacturing",
    ),
    ("334210", "tel_cep", "cep", "goods", "Telephone apparatus manufacturing"),
    (
        "334220",
        "brd_cep",
        "cep",
        "goods",
        "Broadcast and wireless communications equipment",
    ),
    (
        "334290",
        "oce_cep",
        "cep",
        "goods",
        "Other communications equipment manufacturing",
    ),
    (
        "334413",
        "sem_cep",
        "cep",
        "goods",
        "Semiconductor and related device manufacturing",
    ),
    (
        "334418",
        "prc_cep",
        "cep",
        "goods",
        "Printed circuit assembly (electronic assembly) manufacturing",
    ),
    ("33441A", "oec_cep", "cep", "goods", "Other electronic component manufacturing"),
    (
        "334510",
        "eea_cep",
        "cep",
        "goods",
        "Electromedical and electrotherapeutic apparatus manufacturing",
    ),
    (
        "334511",
        "sdn_cep",
        "cep",
        "goods",
        "Search, detection, and navigation instruments manufacturing",
    ),
    (
        "334512",
        "aec_cep",
        "cep",
        "goods",
        "Automatic environmental control manufacturing",
    ),
    (
        "334513",
        "ipv_cep",
        "cep",
        "goods",
        "Industrial process variable instruments manufacturing",
    ),
    (
        "334514",
        "tfl_cep",
        "cep",
        "goods",
        "Totalizing fluid meter and counting device manufacturing",
    ),
    (
        "334515",
        "els_cep",
        "cep",
        "goods",
        "Electricity and signal testing instruments manufacturing",
    ),
    (
        "334516",
        "ali_cep",
        "cep",
        "goods",
        "Analytical laboratory instrument manufacturing",
    ),
    ("334517", "irr_cep", "cep", "goods", "Irradiation apparatus manufacturing"),
    (
        "33451A",
        "wcm_cep",
        "cep",
        "goods",
        "Watch, clock, and other measuring and controlling device manufacturing",
    ),
    ("334300", "aud_cep", "cep", "goods", "Audio and video equipment manufacturing"),
    (
        "334610",
        "mmo_cep",
        "cep",
        "goods",
        "Manufacturing and reproducing magnetic and optical media",
    ),
    ("335110", "elb_eec", "eec", "goods", "Electric lamp bulb and part manufacturing"),
    ("335120", "ltf_eec", "eec", "goods", "Lighting fixture manufacturing"),
    ("335210", "sea_eec", "eec", "goods", "Small electrical appliance manufacturing"),
    ("335221", "hca_eec", "eec", "goods", "Household cooking appliance manufacturing"),
    (
        "335222",
        "hrf_eec",
        "eec",
        "goods",
        "Household refrigerator and home freezer manufacturing",
    ),
    ("335224", "hle_eec", "eec", "goods", "Household laundry equipment manufacturing"),
    (
        "335228",
        "omh_eec",
        "eec",
        "goods",
        "Other major household appliance manufacturing",
    ),
    (
        "335311",
        "pwr_eec",
        "eec",
        "goods",
        "Power, distribution, and specialty transformer manufacturing",
    ),
    ("335312", "mtg_eec", "eec", "goods", "Motor and generator manufacturing"),
    (
        "335313",
        "swt_eec",
        "eec",
        "goods",
        "Switchgear and switchboard apparatus manufacturing",
    ),
    ("335314", "ric_eec", "eec", "goods", "Relay and industrial control manufacturing"),
    ("335911", "sbt_eec", "eec", "goods", "Storage battery manufacturing"),
    ("335912", "pbt_eec", "eec", "goods", "Primary battery manufacturing"),
    (
        "335920",
        "cme_eec",
        "eec",
        "goods",
        "Communication and energy wire and cable manufacturing",
    ),
    ("335930", "wdv_eec", "eec", "goods", "Wiring device manufacturing"),
    ("335991", "cbn_eec", "eec", "goods", "Carbon and graphite product manufacturing"),
    (
        "335999",
        "oee_eec",
        "eec",
        "goods",
        "All other miscellaneous electrical equipment and component manufacturing",
    ),
    ("336111", "atm_mot", "mot", "goods", "Automobile manufacturing"),
    (
        "336112",
        "ltr_mot",
        "mot",
        "goods",
        "Light truck and utility vehicle manufacturing",
    ),
    ("336120", "htr_mot", "mot", "goods", "Heavy duty truck manufacturing"),
    ("336211", "mbd_mot", "mot", "goods", "Motor vehicle body manufacturing"),
    ("336212", "trl_mot", "mot", "goods", "Truck trailer manufacturing"),
    ("336213", "hom_mot", "mot", "goods", "Motor home manufacturing"),
    ("336214", "cam_mot", "mot", "goods", "Travel trailer and camper manufacturing"),
    (
        "336310",
        "gas_mot",
        "mot",
        "goods",
        "Motor vehicle gasoline engine and engine parts manufacturing",
    ),
    (
        "336320",
        "eee_mot",
        "mot",
        "goods",
        "Motor vehicle electrical and electronic equipment manufacturing",
    ),
    (
        "336350",
        "tpw_mot",
        "mot",
        "goods",
        "Motor vehicle transmission and power train parts manufacturing",
    ),
    (
        "336360",
        "trm_mot",
        "mot",
        "goods",
        "Motor vehicle seating and interior trim manufacturing",
    ),
    ("336370", "stm_mot", "mot", "goods", "Motor vehicle metal stamping"),
    ("336390", "omv_mot", "mot", "goods", "Other Motor Vehicle Parts Manufacturing"),
    (
        "3363A0",
        "brk_mot",
        "mot",
        "goods",
        "Motor vehicle steering, suspension component (except spring), and brake systems manufacturing",
    ),
    ("336411", "air_ote", "ote", "goods", "Aircraft manufacturing"),
    (
        "336412",
        "aen_ote",
        "ote",
        "goods",
        "Aircraft engine and engine parts manufacturing",
    ),
    (
        "336413",
        "oar_ote",
        "ote",
        "goods",
        "Other aircraft parts and auxiliary equipment manufacturing",
    ),
    (
        "336414",
        "mis_ote",
        "ote",
        "goods",
        "Guided missile and space vehicle manufacturing",
    ),
    (
        "33641A",
        "pro_ote",
        "ote",
        "goods",
        "Propulsion units and parts for space vehicles and guided missiles",
    ),
    ("336500", "rrd_ote", "ote", "goods", "Railroad rolling stock manufacturing"),
    ("336611", "shp_ote", "ote", "goods", "Ship building and repairing"),
    ("336612", "bot_ote", "ote", "goods", "Boat building"),
    (
        "336991",
        "mcl_ote",
        "ote",
        "goods",
        "Motorcycle, bicycle, and parts manufacturing",
    ),
    (
        "336992",
        "mlt_ote",
        "ote",
        "goods",
        "Military armored vehicle, tank, and tank component manufacturing",
    ),
    (
        "336999",
        "otm_ote",
        "ote",
        "goods",
        "All other transportation equipment manufacturing",
    ),
    (
        "337110",
        "cab_fpd",
        "fpd",
        "goods",
        "Wood kitchen cabinet and countertop manufacturing",
    ),
    (
        "337121",
        "uph_fpd",
        "fpd",
        "goods",
        "Upholstered household furniture manufacturing",
    ),
    (
        "337122",
        "nup_fpd",
        "fpd",
        "goods",
        "Nonupholstered wood household furniture manufacturing",
    ),
    ("337127", "ifm_fpd", "fpd", "goods", "Institutional furniture manufacturing"),
    ("33712N", "ohn_fpd", "fpd", "goods", "Other household nonupholstered furniture"),
    (
        "337215",
        "shv_fpd",
        "fpd",
        "goods",
        "Showcase, partition, shelving, and locker manufacturing",
    ),
    (
        "33721A",
        "off_fpd",
        "fpd",
        "goods",
        "Office furniture and custom architectural woodwork and millwork manufacturing",
    ),
    (
        "337900",
        "ofp_fpd",
        "fpd",
        "goods",
        "Other furniture related product manufacturing",
    ),
    (
        "339112",
        "smi_mmf",
        "mmf",
        "goods",
        "Surgical and medical instrument manufacturing",
    ),
    (
        "339113",
        "sas_mmf",
        "mmf",
        "goods",
        "Surgical appliance and supplies manufacturing",
    ),
    (
        "339114",
        "dnt_mmf",
        "mmf",
        "goods",
        "Dental equipment and supplies manufacturing",
    ),
    ("339115", "oph_mmf", "mmf", "goods", "Ophthalmic goods manufacturing"),
    ("339116", "dlb_mmf", "mmf", "goods", "Dental laboratories"),
    ("339910", "jwl_mmf", "mmf", "goods", "Jewelry and silverware manufacturing"),
    ("339920", "ath_mmf", "mmf", "goods", "Sporting and athletic goods manufacturing"),
    ("339930", "toy_mmf", "mmf", "goods", "Doll, toy, and game manufacturing"),
    (
        "339940",
        "ofm_mmf",
        "mmf",
        "goods",
        "Office supplies (except paper) manufacturing",
    ),
    ("339950", "sgn_mmf", "mmf", "goods", "Sign manufacturing"),
    ("339990", "omm_mmf", "mmf", "goods", "All other miscellaneous manufacturing"),
    ("311111", "dog_fbp", "fbp", "goods", "Dog and cat food manufacturing"),
    ("311119", "oaf_fbp", "fbp", "goods", "Other animal food manufacturing"),
    ("311210", "flr_fbp", "fbp", "goods", "Flour milling and malt manufacturing"),
    ("311221", "wet_fbp", "fbp", "goods", "Wet corn milling"),
    ("311225", "fat_fbp", "fbp", "goods", "Fats and oils refining and blending"),
    ("311224", "soy_fbp", "fbp", "goods", "Soybean and other oilseed processing"),
    ("311230", "brk_fbp", "fbp", "goods", "Breakfast cereal manufacturing"),
    (
        "311300",
        "sug_fbp",
        "fbp",
        "goods",
        "Sugar and confectionery product manufacturing",
    ),
    ("311410", "fzn_fbp", "fbp", "goods", "Frozen food manufacturing"),
    (
        "311420",
        "can_fbp",
        "fbp",
        "goods",
        "Fruit and vegetable canning, pickling, and drying",
    ),
    ("311513", "chs_fbp", "fbp", "goods", "Cheese manufacturing"),
    (
        "311514",
        "dry_fbp",
        "fbp",
        "goods",
        "Dry, condensed, and evaporated dairy product manufacturing",
    ),
    ("31151A", "mlk_fbp", "fbp", "goods", "Fluid milk and butter manufacturing"),
    ("311520", "ice_fbp", "fbp", "goods", "Ice cream and frozen dessert manufacturing"),
    ("311615", "chk_fbp", "fbp", "goods", "Poultry processing"),
    (
        "31161A",
        "asp_fbp",
        "fbp",
        "goods",
        "Animal (except poultry) slaughtering, rendering, and processing",
    ),
    ("311700", "sea_fbp", "fbp", "goods", "Seafood product preparation and packaging"),
    ("311810", "brd_fbp", "fbp", "goods", "Bread and bakery product manufacturing"),
    (
        "3118A0",
        "cok_fbp",
        "fbp",
        "goods",
        "Cookie, cracker, pasta, and tortilla manufacturing",
    ),
    ("311910", "snk_fbp", "fbp", "goods", "Snack food manufacturing"),
    ("311920", "tea_fbp", "fbp", "goods", "Coffee and tea manufacturing"),
    (
        "311930",
        "syr_fbp",
        "fbp",
        "goods",
        "Flavoring syrup and concentrate manufacturing",
    ),
    ("311940", "spc_fbp", "fbp", "goods", "Seasoning and dressing manufacturing"),
    ("311990", "ofm_fbp", "fbp", "goods", "All other food manufacturing"),
    ("312110", "pop_fbp", "fbp", "goods", "Soft drink and ice manufacturing"),
    ("312120", "ber_fbp", "fbp", "goods", "Breweries"),
    ("312130", "wne_fbp", "fbp", "goods", "Wineries"),
    ("312140", "why_fbp", "fbp", "goods", "Distilleries"),
    ("312200", "cig_fbp", "fbp", "goods", "Tobacco product manufacturing"),
    ("313100", "fyt_tex", "tex", "goods", "Fiber, yarn, and thread mills"),
    ("313200", "fml_tex", "tex", "goods", "Fabric mills"),
    (
        "313300",
        "txf_tex",
        "tex",
        "goods",
        "Textile and fabric finishing and fabric coating mills",
    ),
    ("314110", "rug_tex", "tex", "goods", "Carpet and rug mills"),
    ("314120", "lin_tex", "tex", "goods", "Curtain and linen mills"),
    ("314900", "otp_tex", "tex", "goods", "Other textile product mills"),
    ("315000", "app_alt", "alt", "goods", "Apparel manufacturing"),
    ("316000", "lea_alt", "alt", "goods", "Leather and allied product manufacturing"),
    ("322110", "plp_ppd", "ppd", "goods", "Pulp mills"),
    ("322120", "ppm_ppd", "ppd", "goods", "Paper mills"),
    ("322130", "pbm_ppd", "ppd", "goods", "Paperboard mills"),
    ("322210", "pbc_ppd", "ppd", "goods", "Paperboard container manufacturing"),
    (
        "322220",
        "ppb_ppd",
        "ppd",
        "goods",
        "Paper Bag and Coated and Treated Paper Manufacturing",
    ),
    ("322230", "sta_ppd", "ppd", "goods", "Stationery product manufacturing"),
    ("322291", "toi_ppd", "ppd", "goods", "Sanitary paper product manufacturing"),
    (
        "322299",
        "opp_ppd",
        "ppd",
        "goods",
        "All other converted paper product manufacturing",
    ),
    ("323110", "pri_pri", "pri", "goods", "Printing"),
    ("323120", "sap_pri", "pri", "goods", "Support activities for printing"),
    ("324110", "ref_pet", "pet", "goods", "Petroleum refineries"),
    (
        "324121",
        "pav_pet",
        "pet",
        "goods",
        "Asphalt paving mixture and block manufacturing",
    ),
    (
        "324122",
        "shn_pet",
        "pet",
        "goods",
        "Asphalt shingle and coating materials manufacturing",
    ),
    (
        "324190",
        "oth_pet",
        "pet",
        "goods",
        "Other petroleum and coal products manufacturing",
    ),
    ("325110", "ptr_che", "che", "goods", "Petrochemical manufacturing"),
    ("325120", "igm_che", "che", "goods", "Industrial gas manufacturing"),
    ("325130", "sdp_che", "che", "goods", "Synthetic dye and pigment manufacturing"),
    (
        "325180",
        "obi_che",
        "che",
        "goods",
        "Other Basic Inorganic Chemical Manufacturing",
    ),
    ("325190", "obo_che", "che", "goods", "Other basic organic chemical manufacturing"),
    ("325211", "pmr_che", "che", "goods", "Plastics material and resin manufacturing"),
    (
        "3252A0",
        "srf_che",
        "che",
        "goods",
        "Synthetic rubber and artificial and synthetic fibers and filaments manufacturing",
    ),
    ("325411", "mbm_che", "che", "goods", "Medicinal and botanical manufacturing"),
    ("325412", "phm_che", "che", "goods", "Pharmaceutical preparation manufacturing"),
    (
        "325413",
        "inv_che",
        "che",
        "goods",
        "In-vitro diagnostic substance manufacturing",
    ),
    (
        "325414",
        "bio_che",
        "che",
        "goods",
        "Biological product (except diagnostic) manufacturing",
    ),
    ("325310", "fmf_che", "che", "goods", "Fertilizer manufacturing"),
    (
        "325320",
        "pag_che",
        "che",
        "goods",
        "Pesticide and other agricultural chemical manufacturing",
    ),
    ("325510", "pnt_che", "che", "goods", "Paint and coating manufacturing"),
    ("325520", "adh_che", "che", "goods", "Adhesive manufacturing"),
    ("325610", "sop_che", "che", "goods", "Soap and cleaning compound manufacturing"),
    ("325620", "toi_che", "che", "goods", "Toilet preparation manufacturing"),
    ("325910", "pri_che", "che", "goods", "Printing ink manufacturing"),
    (
        "3259A0",
        "och_che",
        "che",
        "goods",
        "All other chemical product and preparation manufacturing",
    ),
    (
        "326110",
        "plm_pla",
        "pla",
        "goods",
        "Plastics packaging materials and unlaminated film and sheet manufacturing",
    ),
    (
        "326120",
        "ppp_pla",
        "pla",
        "goods",
        "Plastics pipe, pipe fitting, and unlaminated profile shape manufacturing",
    ),
    (
        "326130",
        "lam_pla",
        "pla",
        "goods",
        "Laminated plastics plate, sheet (except packaging), and shape manufacturing",
    ),
    ("326140", "fom_pla", "pla", "goods", "Polystyrene foam product manufacturing"),
    (
        "326150",
        "ure_pla",
        "pla",
        "goods",
        "Urethane and other foam product (except polystyrene) manufacturing",
    ),
    ("326160", "bot_pla", "pla", "goods", "Plastics bottle manufacturing"),
    ("326190", "opm_pla", "pla", "goods", "Other plastics product manufacturing"),
    (
        "326220",
        "rbr_pla",
        "pla",
        "goods",
        "Rubber and plastics hoses and belting manufacturing",
    ),
    ("326290", "orb_pla", "pla", "goods", "Other rubber product manufacturing"),
    (
        "423100",
        "mtv_wht",
        "wht",
        "goods",
        "Motor vehicle and motor vehicle parts and supplies",
    ),
    (
        "423400",
        "pce_wht",
        "wht",
        "goods",
        "Professional and commercial equipment and supplies",
    ),
    (
        "423600",
        "hha_wht",
        "wht",
        "goods",
        "Household appliances and electrical and electronic goods",
    ),
    ("423800", "mch_wht", "wht", "goods", "Machinery, equipment, and supplies"),
    ("423A00", "odg_wht", "wht", "goods", "Other durable goods merchant wholesalers"),
    ("424200", "dru_wht", "wht", "goods", "Drugs and druggists‚Äô sundries"),
    ("424400", "gro_wht", "wht", "goods", "Grocery and related product wholesalers"),
    ("424700", "pet_wht", "wht", "goods", "Petroleum and petroleum products"),
    (
        "424A00",
        "ndg_wht",
        "wht",
        "goods",
        "Other nondurable goods merchant wholesalers",
    ),
    (
        "425000",
        "ele_wht",
        "wht",
        "goods",
        "Wholesale electronic markets and agents and brokers",
    ),
    ("4200ID", "dut_wht", "wht", "goods", "Customs duties"),
    ("441000", "mvt_mvt", "mvt", "goods", "Motor vehicle and parts dealers"),
    ("445000", "fbt_fbt", "fbt", "goods", "Food and beverage stores"),
    ("452000", "gmt_gmt", "gmt", "goods", "General merchandise stores"),
    (
        "444000",
        "bui_ott",
        "ott",
        "goods",
        "Building material and garden equipment and supplies dealers",
    ),
    ("446000", "hea_ott", "ott", "goods", "Health and personal care stores"),
    ("447000", "gas_ott", "ott", "goods", "Gasoline stations"),
    ("448000", "clo_ott", "ott", "goods", "Clothing and clothing accessories stores"),
    ("454000", "non_ott", "ott", "goods", "Nonstore retailers"),
    ("4B0000", "oth_ott", "ott", "goods", "All other retail"),
    ("481000", "air_air", "air", "goods", "Air transportation"),
    ("482000", "trn_trn", "trn", "goods", "Rail transportation"),
    ("483000", "wtt_wtt", "wtt", "goods", "Water transportation"),
    ("484000", "trk_trk", "trk", "goods", "Truck transportation"),
    (
        "485000",
        "grd_grd",
        "grd",
        "goods",
        "Transit and ground passenger transportation",
    ),
    ("486000", "pip_pip", "pip", "goods", "Pipeline transportation"),
    (
        "48A000",
        "sce_otr",
        "otr",
        "goods",
        "Scenic and sightseeing transportation and support activities for transportation",
    ),
    ("492000", "mes_otr", "otr", "goods", "Couriers and messengers"),
    ("493000", "wrh_wrh", "wrh", "goods", "Warehousing and storage"),
    ("511110", "new_pub", "pub", "goods", "Newspaper publishers"),
    ("511120", "pdl_pub", "pub", "goods", "Periodical Publishers"),
    ("511130", "bok_pub", "pub", "goods", "Book publishers"),
    (
        "5111A0",
        "mal_pub",
        "pub",
        "goods",
        "Directory, mailing list, and other publishers",
    ),
    ("511200", "sfw_pub", "pub", "goods", "Software publishers"),
    ("512100", "pic_mov", "mov", "goods", "Motion picture and video industries"),
    ("512200", "snd_mov", "mov", "goods", "Sound recording industries"),
    ("515100", "rad_brd", "brd", "goods", "Radio and television broadcasting"),
    ("515200", "cbl_brd", "brd", "goods", "Cable and other subscription programming"),
    ("517110", "wtl_brd", "brd", "goods", "Wired telecommunications carriers"),
    (
        "517210",
        "wls_brd",
        "brd",
        "goods",
        "Wireless telecommunications carriers (except satellite)",
    ),
    (
        "517A00",
        "sat_brd",
        "brd",
        "goods",
        "Satellite, telecommunications resellers, and all other telecommunications",
    ),
    (
        "518200",
        "dpr_dat",
        "dat",
        "goods",
        "Data processing, hosting, and related services",
    ),
    (
        "519130",
        "int_dat",
        "dat",
        "goods",
        "Internet publishing and broadcasting and Web search portals",
    ),
    (
        "5191A0",
        "new_dat",
        "dat",
        "goods",
        "News syndicates, libraries, archives and all other information services",
    ),
    (
        "522A00",
        "cre_bnk",
        "bnk",
        "goods",
        "Nondepository credit intermediation and related activities",
    ),
    (
        "52A000",
        "mon_bnk",
        "bnk",
        "goods",
        "Monetary authorities and depository credit intermediation",
    ),
    ("523900", "ofi_sec", "sec", "goods", "Other financial investment activities"),
    (
        "523A00",
        "com_sec",
        "sec",
        "goods",
        "Securities and commodity contracts intermediation and brokerage",
    ),
    ("524113", "dir_ins", "ins", "goods", "Direct life insurance carriers"),
    ("5241XX", "car_ins", "ins", "goods", "Insurance carriers, except direct life"),
    (
        "524200",
        "agn_ins",
        "ins",
        "goods",
        "Insurance agencies, brokerages, and related activities",
    ),
    (
        "525000",
        "fin_fin",
        "fin",
        "goods",
        "Funds, trusts, and other financial vehicles",
    ),
    ("531HSO", "own_hou", "hou", "goods", "Owner-occupied housing"),
    ("531ORE", "ore_ore", "ore", "goods", "Other real estate"),
    ("532100", "aut_rnt", "rnt", "goods", "Automotive equipment rental and leasing"),
    (
        "532400",
        "com_rnt",
        "rnt",
        "goods",
        "Commercial and industrial machinery and equipment rental and leasing",
    ),
    ("532A00", "cmg_rnt", "rnt", "goods", "General and consumer goods rental"),
    ("533000", "int_rnt", "rnt", "goods", "Lessors of nonfinancial intangible assets"),
    ("541100", "leg_leg", "leg", "goods", "Legal services"),
    ("541511", "cus_com", "com", "goods", "Custom computer programming services"),
    ("541512", "sys_com", "com", "goods", "Computer systems design services"),
    (
        "54151A",
        "ocs_com",
        "com",
        "goods",
        "Other computer related services, including facilities management",
    ),
    (
        "541200",
        "acc_tsv",
        "tsv",
        "goods",
        "Accounting, tax preparation, bookkeeping, and payroll services",
    ),
    (
        "541300",
        "arc_tsv",
        "tsv",
        "goods",
        "Architectural, engineering, and related services",
    ),
    ("541610", "mgt_tsv", "tsv", "goods", "Management consulting services"),
    (
        "5416A0",
        "env_tsv",
        "tsv",
        "goods",
        "Environmental and other technical consulting services",
    ),
    (
        "541700",
        "sci_tsv",
        "tsv",
        "goods",
        "Scientific research and development services",
    ),
    (
        "541800",
        "adv_tsv",
        "tsv",
        "goods",
        "Advertising, public relations, and related services",
    ),
    ("541400", "des_tsv", "tsv", "goods", "Specialized design services"),
    ("541920", "pht_tsv", "tsv", "goods", "Photographic services"),
    ("541940", "vet_tsv", "tsv", "goods", "Veterinary services"),
    (
        "5419A0",
        "mkt_tsv",
        "tsv",
        "goods",
        "All other miscellaneous professional, scientific, and technical services",
    ),
    ("550000", "man_man", "man", "goods", "Management of companies and enterprises"),
    ("561300", "emp_adm", "adm", "goods", "Employment services"),
    ("561700", "dwe_adm", "adm", "goods", "Services to buildings and dwellings"),
    ("561100", "off_adm", "adm", "goods", "Office administrative services"),
    ("561200", "fac_adm", "adm", "goods", "Facilities support services"),
    ("561400", "bsp_adm", "adm", "goods", "Business support services"),
    (
        "561500",
        "trv_adm",
        "adm",
        "goods",
        "Travel arrangement and reservation services",
    ),
    ("561600", "inv_adm", "adm", "goods", "Investigation and security services"),
    ("561900", "oss_adm", "adm", "goods", "Other support services"),
    ("562000", "wst_wst", "wst", "goods", "Waste management and remediation services"),
    ("611100", "sec_edu", "edu", "goods", "Elementary and secondary schools"),
    (
        "611A00",
        "uni_edu",
        "edu",
        "goods",
        "Junior colleges, colleges, universities, and professional schools",
    ),
    ("611B00", "oes_edu", "edu", "goods", "Other educational services"),
    ("621100", "phy_amb", "amb", "goods", "Offices of physicians"),
    ("621200", "dnt_amb", "amb", "goods", "Offices of dentists"),
    ("621300", "ohp_amb", "amb", "goods", "Offices of other health practitioners"),
    ("621400", "out_amb", "amb", "goods", "Outpatient care centers"),
    ("621500", "lab_amb", "amb", "goods", "Medical and diagnostic laboratories"),
    ("621600", "hom_amb", "amb", "goods", "Home health care services"),
    ("621900", "oas_amb", "amb", "goods", "Other ambulatory health care services"),
    ("622000", "hos_hos", "hos", "goods", "Hospitals"),
    ("623A00", "ncc_nrs", "nrs", "goods", "Nursing and community care facilities"),
    (
        "623B00",
        "res_nrs",
        "nrs",
        "goods",
        "Residential mental health, substance abuse, and other residential care facilities",
    ),
    ("624100", "ifs_soc", "soc", "goods", "Individual and family services"),
    ("624400", "day_soc", "soc", "goods", "Child day care services"),
    (
        "624A00",
        "cmf_soc",
        "soc",
        "goods",
        "Community food, housing, and other relief services, including rehabilitation services",
    ),
    ("711100", "pfm_art", "art", "goods", "Performing arts companies"),
    ("711200", "spr_art", "art", "goods", "Spectator sports"),
    (
        "711500",
        "ind_art",
        "art",
        "goods",
        "Independent artists, writers, and performers",
    ),
    (
        "711A00",
        "agt_art",
        "art",
        "goods",
        "Promoters of performing arts and sports and agents for public figures",
    ),
    ("712000", "mus_art", "art", "goods", "Museums, historical sites, zoos, and parks"),
    ("713100", "amu_rec", "rec", "goods", "Amusement parks and arcades"),
    ("713200", "cas_rec", "rec", "goods", "Gambling industries (except casino hotels)"),
    ("713900", "ori_rec", "rec", "goods", "Other amusement and recreation industries"),
    ("721000", "amd_amd", "amd", "goods", "Accommodation"),
    ("722110", "ful_res", "res", "goods", "Full-service restaurants"),
    ("722211", "lim_res", "res", "goods", "Limited-service restaurants"),
    ("722A00", "ofd_res", "res", "goods", "All other food and drinking places"),
    ("811100", "atr_osv", "osv", "goods", "Automotive repair and maintenance"),
    (
        "811200",
        "eqr_osv",
        "osv",
        "goods",
        "Electronic and precision equipment repair and maintenance",
    ),
    (
        "811300",
        "imr_osv",
        "osv",
        "goods",
        "Commercial and industrial machinery and equipment repair and maintenance",
    ),
    (
        "811400",
        "hgr_osv",
        "osv",
        "goods",
        "Personal and household goods repair and maintenance",
    ),
    ("812100", "pcs_osv", "osv", "goods", "Personal care services"),
    ("812200", "fun_osv", "osv", "goods", "Death care services"),
    ("812300", "dry_osv", "osv", "goods", "Dry-cleaning and laundry services"),
    ("812900", "ops_osv", "osv", "goods", "Other personal services"),
    ("813100", "rel_osv", "osv", "goods", "Religious organizations"),
    (
        "813A00",
        "grt_osv",
        "osv",
        "goods",
        "Grantmaking, giving, and social advocacy organizations",
    ),
    (
        "813B00",
        "civ_osv",
        "osv",
        "goods",
        "Civic, social, professional, and similar organizations",
    ),
    ("814000", "prv_osv", "osv", "goods", "Private households"),
    ("S00500", "fdd_fdd", "fdd", "goods", "Federal general government (defense)"),
    ("S00600", "fnd_fnd", "fnd", "goods", "Federal general government (nondefense)"),
    ("491000", "pst_fen", "fen", "goods", "Postal service"),
    ("S00102", "ofg_fen", "fen", "goods", "Other federal government enterprises"),
    (
        "GSLGE",
        "edu_slg",
        "slg",
        "goods",
        "State and local government educational services",
    ),
    (
        "GSLGH",
        "hea_slg",
        "slg",
        "goods",
        "State and local government hospitals and health services",
    ),
    ("GSLGO", "oth_slg", "slg", "goods", "State and local government other services"),
    (
        "S00203",
        "ent_sle",
        "sle",
        "goods",
        "Other state and local government enterprises",
    ),
    ("S00401", "srp_use", "use", "goods", "Scrap"),
    ("S00402", "sec_use", "use", "goods", "Used and secondhand goods"),
    ("S00300", "imp_oth", "oth", "goods", "Noncomparable imports"),
    ("S00900", "rwa_oth", "oth", "goods", "Rest of the world adjustment"),
    ("T017", "TotalBasic", "TotalBasic", "", "Total industry supply"),
    (
        "331314",
        "sme_pmt",
        "pmt",
        "goods",
        "Secondary smelting and alloying of aluminum",
    ),
    ("MDTY", "Duties", "Duties", "", "Import duties"),
    ("TOP", "Tax", "Tax", "", "Tax on products"),
    ("SUB", "Subsidies", "Subsidies", "", "Subsidies"),
    ("S00101", "ele_fen", "fen", "goods", "Federal electric utilities"),
    (
        "S00201",
        "trn_sle",
        "sle",
        "goods",
        "State and local government passenger transit",
    ),
    (
        "S00202",
        "ele_sle",
        "sle",
        "goods",
        "State and local government electric utilities",
    ),
    ("T007", "Output", "Output", "", "Total Commodity Output"),
    ("MCIF", "imports", "imports", "", "Imports"),
    ("TRADE", "Margins", "Margins", "", "Trade margins"),
    ("MADJ", "ciffob", "ciffob", "", "CIF/FOB Adjustments on Imports"),
    ("TRANS", "TrnCost", "TrnCost", "", "Transportation costs"),
    ("T013", "BasicSupply", "BasicSupply", "", "Total product supply (basic prices)"),
    ("T014", "TrdTrn", "TrdTrn", "", "Total trade and transportation margins"),
    (
        "T015",
        "TaxLesSubsidies",
        "TaxLesSubsidies",
        "",
        "Total tax less subsidies on products",
    ),
    ("T016", "Supply", "Supply", "", "Total product supply (purchaser prices)"),
    ("T005", "interm", "interm", "", "Total intermediate inputs"),
    ("V00100", "compen", "compen", "valueadded", "Compensation of employees"),
    ("T00OTOP", "othtax", "othtax", "valueadded", "Other taxes on production"),
    ("V00300", "surplus", "surplus", "valueadded", "Gross operating surplus"),
    ("VABAS", "basicvalueadded", "basicvalueadded", "", "Value added (basic value)"),
    (
        "T018",
        "industryoutput",
        "industryoutput",
        "",
        "Total industry output (basic value)",
    ),
    ("T00TOP", "taxes", "taxes", "", "Plus: Taxes on products and imports"),
    ("T00SUB", "subsidies", "subsidies", "", "Less: Subsidies"),
    ("VAPRO", "valueadded", "valueadded", "", "Value added (producer value)"),
    ("T001", "totint", "totint", "", "Total Intermediate"),
    ("F01000", "pce", "pce", "finaldemand", "Personal consumption expenditures"),
    (
        "F02E00",
        "equipment",
        "equipment",
        "finaldemand",
        "Nonresidential private fixed investment in equipment",
    ),
    (
        "F02N00",
        "intelprop",
        "intelprop",
        "finaldemand",
        "Nonresidential private fixed investment in intellectual property products",
    ),
    (
        "F02R00",
        "residential",
        "residential",
        "finaldemand",
        "Residential private fixed investment",
    ),
    (
        "F02S00",
        "structures",
        "structures",
        "finaldemand",
        "Nonresidential private fixed investment in structures",
    ),
    ("F03000", "changinv", "changinv", "finaldemand", "Change in private inventories"),
    ("F04000", "exports", "exports", "", "Exports of goods and services"),
    (
        "F06C00",
        "defense",
        "defense",
        "finaldemand",
        "Federal Government defense: Consumption expenditures",
    ),
    (
        "F06E00",
        "def_equipment",
        "def_equipment",
        "finaldemand",
        "Federal national defense: Gross investment in equipment",
    ),
    (
        "F07C00",
        "nondefense",
        "nondefense",
        "finaldemand",
        "Federal Government nondefense: Consumption expenditures",
    ),
    (
        "F06N00",
        "def_intelprop",
        "def_intelprop",
        "finaldemand",
        "Federal national defense: Gross investment in intellectual property products",
    ),
    (
        "F06S00",
        "def_structures",
        "def_structures",
        "finaldemand",
        "Federal national defense: Gross investment in structures",
    ),
    (
        "F07E00",
        "fed_equipment",
        "fed_equipment",
        "finaldemand",
        "Federal nondefense: Gross investment in equipment",
    ),
    (
        "F07S00",
        "fed_structures",
        "fed_structures",
        "finaldemand",
        "Federal nondefense: Gross investment in structures",
    ),
    (
        "F07N00",
        "fed_intelprop",
        "fed_intelprop",
        "finaldemand",
        "Federal nondefense: Gross investment in intellectual property products",
    ),
    (
        "F10C00",
        "state_consume",
        "state_consume",
        "finaldemand",
        "State and local government consumption expenditures",
    ),
    (
        "F10E00",
        "state_equipment",
        "state_equipment",
        "finaldemand",
        "State and local: Gross investment in equipment",
    ),
    (
        "F10N00",
        "state_intelprop",
        "state_intelprop",
        "finaldemand",
        "State and local: Gross investment in intellectual property products",
    ),
    (
        "F10S00",
        "state_invest",
        "state_invest",
        "finaldemand",
        "State and local: Gross investment in structures",
    ),
    ("T019", "totaluse", "totaluse", "", "Total use of products"),
]


gams_maps["bea_all_det"] = pd.DataFrame(
    bea_all_det,
    columns=["bea_code", "windc_label", "windc_aggr_label", "category", "description"],
)


# bea gsp
gsp = [
    ("Gross domestic product (GDP) by state", "gdp"),
    ("Taxes on production and imports less subsidies", "taxsbd"),
    ("Compensation of employees", "cmp"),
    ("Subsidies", "sbd"),
    ("Taxes on production and imports", "tax"),
    ("Gross operating surplus", "gos"),
    ("Quantity indexes for real GDP by state (2012=100.0)", "qty"),
    ("Real GDP by state", "rgdp"),
]

gams_maps["bea_gsp"] = pd.DataFrame(gsp, columns=["bea_code", "windc_label"])


#
#
# eia generators
eia_gen = [
    ("coal", "col"),
    ("petroleum", "oil"),
    ("nat_gas", "gas"),
    ("nuclear", "nu"),
    ("hydro", "hy"),
    ("geothermal", "ge"),
    ("solar", "so"),
    ("wind", "wy"),
]

gams_maps["eia_gen"] = pd.DataFrame(
    eia_gen, columns=["eia_technologies", "windc_label"]
)

#
#
# eia emissions
eia_emiss = [
    ("coal", "col"),
    ("natural_gas", "gas"),
    ("petroleum", "oil"),
    ("industrial", "ind"),
    ("commercial", "com"),
    ("residential", "res"),
    ("electricity", "ele"),
    ("transport", "trn"),
]

gams_maps["eia_emissions"] = pd.DataFrame(
    eia_emiss, columns=["eia_sector", "windc_label"]
)


#
#
# bea pce
pce = [
    ("Personal consumption expenditures", "pce"),
    ("Goods", "gds"),
    ("Durable goods", "dur"),
    ("Motor vehicles and parts", "mvp"),
    ("Furnishings and durable household equipment", "hdr"),
    ("Recreational goods and vehicles", "rec"),
    ("Other durable goods", "odg"),
    ("Nondurable goods", "ndr"),
    ("Food and beverages purchased for off-premises consumption", "foo"),
    ("Clothing and footwear", "clo"),
    ("Gasoline and other energy goods", "enr"),
    ("Other nondurable goods", "ong"),
    ("Services", "ser"),
    ("Household consumption expenditures (for services)", "hce"),
    ("Housing and utilities", "utl"),
    ("Health care", "hea"),
    ("Transportation services", "trn"),
    ("Recreation services", "rsr"),
    ("Food services and accommodations", "htl"),
    ("Financial services and insurance", "fsr"),
    ("Other services", "osr"),
    (
        "Final consumption expenditures of nonprofit institutions serving households (NPISHs)",
        "npish",
    ),
    ("Gross output of nonprofit institutions", "npi"),
    (
        "Less: Receipts from sales of goods and services by nonprofit institutions",
        "nps",
    ),
]

gams_maps["bea_pce"] = pd.DataFrame(pce, columns=["pce_description", "windc_label"])


#
#
# census sgf
sgf = [
    ("Assistance and subsidies", "subsid"),
    ("Capital outlay", "capout"),
    ("Cash and security holdings", "cashsh"),
    ("Corporate income tax", "cortax"),
    ("Correction", "correc"),
    ("Current charge", "curchg"),
    ("Current operation", "curopr"),
    ("Debt at end of fiscal year", "debtfy"),
    ("Direct expenditure", "direxp"),
    ("Direct general expenditure", "dirgex"),
    ("Education", "educat"),
    ("Exhibit: Salaries and wages", "salary"),
    ("General expenditure", "genexp"),
    ("General revenue", "genrev"),
    ("General sales", "gsales"),
    ("Governmental administration", "govadm"),
    ("Health", "health"),
    ("Highways", "hghway"),
    ("Hospitals", "hosptl"),
    ("Individual income tax", "indtax"),
    ("Insurance benefits and repayments", "insben"),
    ("Insurance trust expenditure", "insexp"),
    ("Insurance trust revenue", "insrev"),
    ("Interest on debt", "intrst"),
    ("Interest on general debt", "intgen"),
    ("Intergovernmental expenditure", "intexp"),
    ("Intergovernmental revenue", "intrev"),
    ("License taxes", "lictax"),
    ("Liquor stores expenditure", "liqexp"),
    ("Liquor stores revenue", "liqrev"),
    ("Miscellaneous general revenue", "mscrev"),
    ("Natural resources", "natres"),
    ("Other and unallocable", "othuna"),
    ("Other taxes", "othtax"),
    ("Parks and recreation", "parkrc"),
    ("Police protection", "police"),
    ("Public welfare", "pubwel"),
    ("Selective sales", "ssales"),
    ("Taxes", "taxrev"),
    ("Total expenditure", "totexp"),
    ("Total revenue", "totrev"),
    ("Utility expenditure", "utlexp"),
    ("Utility revenue", "utlrev"),
]

gams_maps["census_sgf"] = pd.DataFrame(sgf, columns=["sgf_category", "windc_label"])
