# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2016-06-15 18:30
from __future__ import unicode_literals

from django.db import migrations, models
from test_app.models import TestModel


def migrate_testmodel(apps, schema_editor):
    TestModel = apps.get_model('test_app', 'TestModel')
    for test_model in TestModel.objects.all():
        # Have to do this by hand because we asked for the model at this state
        # opposed to the "full" model
        test_model.test3 = test_model.test2
        test_model.save()


def unmigrate_testmodel(apps, schema_editor):
    TestModel = apps.get_model('test_app', 'TestModel')
    for test_model in TestModel.objects.all():
        test_model.test2 = test_model.test3
        test_model.save()


def handle_testmodel(inst, apps):
    if not hasattr(inst, 'test3'):
        old_inst = apps.get_model('test_app',
                                  'TestModel').objects.get(pk=inst.pk)
        inst.test3 = old_inst.test2


class Migration(migrations.Migration):
    model_handlers = [
        (TestModel, handle_testmodel),
    ]

    dependencies = [
        ('test_app', '0003_move_model_add_test3'),
    ]

    operations = [
        migrations.RunPython(migrate_testmodel, unmigrate_testmodel),
    ]
