#######################################################
#
# EmergencyFacade.py
# Python implementation of the Class Emergency
# part of Component:
# Component Version: 1.0
# Generated by ComponentNameFacade
# Generated on: 2022-11-18   13:57:53.712997600
# Author: (Future feature of EA-Bridge)
#######################################################

from digitalpy.core.component_management.impl.default_facade import DefaultFacade
from FreeTAKServer.core.configuration.MainConfig import MainConfig
from FreeTAKServer.components.extended.emergency.configuration.emergency_constants import (
    ACTION_MAPPING_PATH,
    TYPE_MAPPINGS,
    LOGGING_CONFIGURATION_PATH,
    INTERNAL_ACTION_MAPPING_PATH,
    MANIFEST_PATH,
    CONFIGURATION_PATH_TEMPLATE,
)
from . import base

config = MainConfig.instance()


class Emergency(DefaultFacade):
    """Facade class for the Component Emergency.
    Responsible for handling all public routing.
    Forwards all requests to the internal router.
    """

    def __init__(
        self,
        emergency_action_mapper,
        request,
        response,
        configuration,
        tracing_provider_instance=None,
    ):
        super().__init__(
            # the path to the external action mapping
            action_mapping_path=ACTION_MAPPING_PATH,
            # the path to the internal action mapping
            internal_action_mapping_path=INTERNAL_ACTION_MAPPING_PATH,
            # the type mapping in dictionary form
            type_mapping=TYPE_MAPPINGS,
            # the path to the logger configuration
            logger_configuration=LOGGING_CONFIGURATION_PATH,
            # the package containing the base classes
            base=base,
            # the component specific action mapper (passed by constructor)
            action_mapper=emergency_action_mapper,
            # the request object (passed by constructor)
            request=request,
            # the response object (passed by constructor)
            response=response,
            # the configuration object (passed by constructor)
            configuration=configuration,
            # log file path
            log_file_path=config.LogFilePath,
            # the tracing provider used
            tracing_provider_instance=tracing_provider_instance,
            # the template for the absolute path to the model object definitions
            configuration_path_template=CONFIGURATION_PATH_TEMPLATE,
            # the path to the manifest file
            manifest_path=MANIFEST_PATH,
        )
