#  Python UT generator
This tools generate automatically Python pytest Unit test code.  
This project uses ast module to generate.  
Easy to make coverage test. And Easy to customize test code.

### Feature

* Generate unit test python file in tests package.
* Generate pytest test function from each function.
* Generate mock patch syntax code.
* Generate argument syntax code to call.
* If function has return value, create assert return.

## Installation

### Install pip

```
pip install pyutgenerator
```
https://pypi.org/project/pyutgenerator/


## Run tool.

### Genarete test code


```
pyutgen "Input File Name"
```

or

```
python -m pyutgenerator.run "Input File Name"
```


### Sample input file

```
import os


def aaaaa():
    """
    call and return
    """
    return os.path.exists('')

```

### Sample out put

```

import pytest
from unittest.mock import patch
from unittest.mock import MagicMock

from tests.pyutgenerator.data import pattern01

def test_aaaaa():
    # plan

    # do
    with\
            patch('tests.pyutgenerator.data.pattern01.os.path') as m1:
        m1.return_value = None
        m1.exists = MagicMock(return_value=None)
        ret = pattern01.aaaaa()

        # check
        assert ret

```
### For the future

* For Code
    * Genarete various parameters for test.
    * Write return check value.
    * 'exception' check.
    * 'with' description mock.
    * Generate test data.
    * Assertion for method call for count, parameter, throw.
    * parameter type for str,list, obj ...
    * Simple code analyst report. like no None check or Parameter 
    * For django
* Customize parameter options or setting file.
    * Exclude function mock.
    * Source directory path. 
    * tab space num.
* Get test data from debug. 
* able to run default generated code and pass test.
* Full coverage.
* web ui for test.

### Prerequisites

not yet

```
not yet
```


## License

This project is licensed under the MIT License - see the [LICENSE.md](LICENSE.md) file for details

## Acknowledgments

* Hat tip to anyone whose code was used
* Inspiration
* etc
