from arkdata import models


def backup_seed():
    models.Tool.new(id=37, name='Torch', stack_size=1, class_name='PrimalItem_WeaponTorch_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponTorch.PrimalItem_WeaponTorch\'"',
                    url='https://ark.fandom.com/wiki/Torch',
                    description='Provides light, and some warmth. Doubles as a melee weapon in a pinch, and can be applied to various saddles for a mobile light source.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b2/Torch.png')
    models.Tool.new(id=33, name='Stone Pick', stack_size=1, class_name='PrimalItem_WeaponStonePick_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponStonePick.PrimalItem_WeaponStonePick\'"',
                    url='https://ark.fandom.com/wiki/Stone_Pick',
                    description='A large stone pick for harvesting primarily flint from rocks, thatch from trees, and raw meat from bodies.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Stone_Pick.png')
    models.Tool.new(id=34, name='Stone Hatchet', stack_size=1, class_name='PrimalItem_WeaponStoneHatchet_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponStoneHatchet.PrimalItem_WeaponStoneHatchet\'"',
                    url='https://ark.fandom.com/wiki/Stone_Hatchet',
                    description='A sharp flint hatchet for harvesting wood from trees, stone from rocks, and skin from bodies.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d6/Stone_Hatchet.png')
    models.Tool.new(id=279, name='Spyglass', stack_size=1, class_name='PrimalItem_WeaponSpyglass_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_WeaponSpyglass.PrimalItem_WeaponSpyglass\'"',
                    url='https://ark.fandom.com/wiki/Spyglass',
                    description='This instrument, while primitive, is quite effective at long-range reconnaissance.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Spyglass.png')
    models.Tool.new(id=140, name='Radio', stack_size=1, class_name='PrimalItemRadio_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemRadio.PrimalItemRadio\'"',
                    url='https://ark.fandom.com/wiki/Radio',
                    description='Use this to communicate securely over great distances.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Radio.png')
    models.Tool.new(id=38, name='Paintbrush', stack_size=1, class_name='PrimalItem_WeaponPaintbrush_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponPaintbrush.PrimalItem_WeaponPaintbrush\'"',
                    url='https://ark.fandom.com/wiki/Paintbrush',
                    description='Apply a dye to this, then swing it at structures to paint them.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c4/Paintbrush.png')
    models.Tool.new(id=376, name='Metal Sickle', stack_size=1, class_name='PrimalItem_WeaponSickle_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponSickle.PrimalItem_WeaponSickle\'"',
                    url='https://ark.fandom.com/wiki/Metal_Sickle',
                    description='A curved tool ideal for harvesting fiber from seed plants. Also useful for delicately shearing off slices of Prime Fish!',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e0/Metal_Sickle.png')
    models.Tool.new(id=35, name='Metal Pick', stack_size=1, class_name='PrimalItem_WeaponMetalPick_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponMetalPick.PrimalItem_WeaponMetalPick\'"',
                    url='https://ark.fandom.com/wiki/Metal_Pick',
                    description='A sharp metal pick for harvesting metal from mountain rocks, flint from rocks, and meat from bodies.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9f/Metal_Pick.png')
    models.Tool.new(id=36, name='Metal Hatchet', stack_size=1, class_name='PrimalItem_WeaponMetalHatchet_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponMetalHatchet.PrimalItem_WeaponMetalHatchet\'"',
                    url='https://ark.fandom.com/wiki/Metal_Hatchet',
                    description='A sharp metal hatchet for harvesting wood from trees, stone from rocks, and skin from bodies.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a6/Metal_Hatchet.png')
    models.Tool.new(id=71, name='GPS', stack_size=1, class_name='PrimalItem_WeaponGPS_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_WeaponGPS.PrimalItem_WeaponGPS\'"',
                    url='https://ark.fandom.com/wiki/GPS',
                    description='Detects strange energy from the three Obelisks to triangulate your exact location on the island.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/72/GPS.png')
    models.Tool.new(id=136, name='Compass', stack_size=1, class_name='PrimalItem_WeaponCompass_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_WeaponCompass.PrimalItem_WeaponCompass\'"',
                    url='https://ark.fandom.com/wiki/Compass',
                    description='Use this to find which direction you are traveling.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Compass.png')
    models.Tool.new(id=44, name='Blood Extraction Syringe', stack_size=1, class_name='PrimalItem_BloodExtractor_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_BloodExtractor.PrimalItem_BloodExtractor\'"',
                    url='https://ark.fandom.com/wiki/Blood_Extraction_Syringe',
                    description='Use this on a human to extract their blood for transfusion.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Blood_Extraction_Syringe.png')
    models.Tool.new(name='Camera', stack_size=1, class_name='PrimalItem_Camera_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_Camera.PrimalItem_Camera\'"',
                    url='https://ark.fandom.com/wiki/Camera', description='Equip, target, and take a shot!.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/80/Camera.png')
    models.Tool.new(name='Chainsaw', stack_size=1, class_name='PrimalItem_ChainSaw_C',
                    blueprint='"Blueprint\'/Game/ScorchedEarth/WeaponChainsaw/PrimalItem_ChainSaw.PrimalItem_ChainSaw\'"',
                    url='https://ark.fandom.com/wiki/Chainsaw_(Scorched_Earth)',
                    description='The fastest way to cut a tree.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Chainsaw_%28Scorched_Earth%29.png')
    models.Tool.new(name='Electronic Binoculars', stack_size=1, class_name='PrimalItem_WeaponElectronicBinoculars_C',
                    blueprint='"Blueprint\'/Game/ScorchedEarth/WeaponElectronicBinoculars/PrimalItem_WeaponElectronicBinoculars.PrimalItem_WeaponElectronicBinoculars\'"',
                    url='https://ark.fandom.com/wiki/Electronic_Binoculars_(Genesis:_Part_1)',
                    description='The ultimate long-range reconnaissance tool.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/69/Electronic_Binoculars_%28Genesis_Part_1%29.png')
    models.Tool.new(name='Empty Cryopod', stack_size=1, class_name='PrimalItem_WeaponEmptyCryopod_C',
                    blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Weapons/PrimalItem_WeaponEmptyCryopod.PrimalItem_WeaponEmptyCryopod\'"',
                    url='https://ark.fandom.com/wiki/Empty_Cryopod_(Extinction)',
                    description='Hold up to a creature to capture it. Throw to deploy a captured creature.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3e/Cryopod.png')
    models.Tool.new(name='Fish Net', stack_size=1, class_name='PrimalItem_WeaponFishingNet_C',
                    blueprint='"Blueprint\'/Game/Genesis/Weapons/FishingNet/PrimalItem_WeaponFishingNet.PrimalItem_WeaponFishingNet\'"',
                    url='https://ark.fandom.com/wiki/Fish_Net_(Genesis:_Part_1)',
                    description='Wind up and throw it to catch nearby fish.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Fish_Net_%28Genesis_Part_1%29.png')
    models.Tool.new(name='Fishing Rod', stack_size=1, class_name='PrimalItem_WeaponFishingRod_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponFishingRod.PrimalItem_WeaponFishingRod\'"',
                    url='https://ark.fandom.com/wiki/Fishing_Rod',
                    description='Apply various bait to this, and then use when sitting on a chair or bench to catch some fish!',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c7/Fishing_Rod.png')
    models.Tool.new(name='Magnifying Glass', stack_size=1, class_name='PrimalItem_WeaponMagnifyingGlass_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_WeaponMagnifyingGlass.PrimalItem_WeaponMagnifyingGlass\'"',
                    url='https://ark.fandom.com/wiki/Magnifying_Glass',
                    description='This instrument, while primitive, is effective as short-range analysis of both flora and fauna.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Magnifying_Glass.png')
    models.Tool.new(name='Mining Drill', stack_size=1, class_name='PrimalItem_WeaponMiningDrill_C',
                    blueprint='"Blueprint\'/Game/Genesis/Weapons/MiningDrill/PrimalItem_WeaponMiningDrill.PrimalItem_WeaponMiningDrill\'"',
                    url='https://ark.fandom.com/wiki/Mining_Drill_(Genesis:_Part_1)',
                    description='An incredibly effective gasoline-powered harvesting tool that utilizes an energy beam to collect valuable resources at distance.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/30/Mining_Drill_%28Genesis_Part_1%29.png')
    models.Tool.new(name='Pliers', stack_size=1, class_name='PrimalItem_Pliers_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/PrimalItem_Pliers.PrimalItem_Pliers\'"',
                    url='https://ark.fandom.com/wiki/Pliers_(Aberration)',
                    description='Use on a Smithy-crafted item in need of repairing and you can repair it on the go within any inventory, at a higher cost of resources.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c8/Pliers_%28Aberration%29.png')
    models.Tool.new(name='Scissors', stack_size=1, class_name='PrimalItem_WeaponScissors_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponScissors.PrimalItem_WeaponScissors\'"',
                    url='https://ark.fandom.com/wiki/Scissors', description='Used for cutting hair & other materials!',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Scissors.png')
    models.Tool.new(name='Taxidermy Tool', stack_size=1, class_name='PrimalItem_WeaponTaxidermyTool_C',
                    blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Weapons/PrimalItem_WeaponTaxidermyTool.PrimalItem_WeaponTaxidermyTool\'"',
                    url='https://ark.fandom.com/wiki/Taxidermy_Tool_(Extinction)',
                    description='Used to capture the Dermis of a dead creature.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0b/Taxidermy_Tool_%28Extinction%29.png')
    models.Tool.new(name='Tier 1 Lootcrate', stack_size=1, class_name='PrimalItemConsumable_Lootcrate_lvl1_C',
                    blueprint='"Blueprint\'/Game/Genesis/CoreBlueprints/Items/PrimalItemConsumable_Lootcrate_lvl1.PrimalItemConsumable_Lootcrate_lvl1\'"',
                    url='https://ark.fandom.com/wiki/Lootcrate_(Genesis)',
                    description='Drops a random assortment of gear',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Lootcrate_%28Genesis_Part_1%29.png')
    models.Tool.new(name='Tier 2 Lootcrate', stack_size=1, class_name='PrimalItemConsumable_Lootcrate_lvl2_C',
                    blueprint='"Blueprint\'/Game/Genesis/CoreBlueprints/Items/PrimalItemConsumable_Lootcrate_lvl2.PrimalItemConsumable_Lootcrate_lvl2\'"',
                    url='https://ark.fandom.com/wiki/Lootcrate_(Genesis)',
                    description='Drops a random assortment of gear',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Lootcrate_%28Genesis_Part_1%29.png')
    models.Tool.new(name='Tier 3 Lootcrate', stack_size=1, class_name='PrimalItemConsumable_Lootcrate_lvl3_C',
                    blueprint='"Blueprint\'/Game/Genesis/CoreBlueprints/Items/PrimalItemConsumable_Lootcrate_lvl3.PrimalItemConsumable_Lootcrate_lvl3\'"',
                    url='https://ark.fandom.com/wiki/Lootcrate_(Genesis)',
                    description='Drops a random assortment of gear',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Lootcrate_%28Genesis_Part_1%29.png')
    models.Tool.new(name='Whip', stack_size=1, class_name='PrimalItem_WeaponWhip_C',
                    blueprint='"Blueprint\'/Game/ScorchedEarth/WeaponWhip/PrimalItem_WeaponWhip.PrimalItem_WeaponWhip\'"',
                    url='https://ark.fandom.com/wiki/Whip_(Scorched_Earth)',
                    description='Keeps your foes at bay, keeps your herd moving.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b9/Whip_%28Scorched_Earth%29.png')
    items = [item.to_json() for item in models.Tool.all()]
    print(items)


def seed():
    items = [
        {
            'class_name': 'PrimalItem_WeaponStonePick_C', 'id': 33,
            'description': 'A large stone pick for harvesting primarily flint from rocks, thatch from trees, and raw meat from bodies.',
            'url': 'https://ark.fandom.com/wiki/Stone_Pick',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponStonePick.PrimalItem_WeaponStonePick\'"',
            'name': 'Stone Pick', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Stone_Pick.png'
        },
        {
            'class_name': 'PrimalItem_WeaponStoneHatchet_C', 'id': 34,
            'description': 'A sharp flint hatchet for harvesting wood from trees, stone from rocks, and skin from bodies.',
            'url': 'https://ark.fandom.com/wiki/Stone_Hatchet',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponStoneHatchet.PrimalItem_WeaponStoneHatchet\'"',
            'name': 'Stone Hatchet', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d6/Stone_Hatchet.png'
        },
        {
            'class_name': 'PrimalItem_WeaponMetalPick_C', 'id': 35,
            'description': 'A sharp metal pick for harvesting metal from mountain rocks, flint from rocks, and meat from bodies.',
            'url': 'https://ark.fandom.com/wiki/Metal_Pick',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponMetalPick.PrimalItem_WeaponMetalPick\'"',
            'name': 'Metal Pick', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9f/Metal_Pick.png'
        },
        {
            'class_name': 'PrimalItem_WeaponMetalHatchet_C', 'id': 36,
            'description': 'A sharp metal hatchet for harvesting wood from trees, stone from rocks, and skin from bodies.',
            'url': 'https://ark.fandom.com/wiki/Metal_Hatchet',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponMetalHatchet.PrimalItem_WeaponMetalHatchet\'"',
            'name': 'Metal Hatchet', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a6/Metal_Hatchet.png'
        },
        {
            'class_name': 'PrimalItem_WeaponTorch_C', 'id': 37,
            'description': 'Provides light, and some warmth. Doubles as a melee weapon in a pinch, and can be applied to various saddles for a mobile light source.',
            'url': 'https://ark.fandom.com/wiki/Torch',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponTorch.PrimalItem_WeaponTorch\'"',
            'name': 'Torch', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b2/Torch.png'
        },
        {
            'class_name': 'PrimalItem_WeaponPaintbrush_C', 'id': 38,
            'description': 'Apply a dye to this, then swing it at structures to paint them.',
            'url': 'https://ark.fandom.com/wiki/Paintbrush',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponPaintbrush.PrimalItem_WeaponPaintbrush\'"',
            'name': 'Paintbrush', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c4/Paintbrush.png'
        },
        {
            'class_name': 'PrimalItem_BloodExtractor_C', 'id': 44,
            'description': 'Use this on a human to extract their blood for transfusion.',
            'url': 'https://ark.fandom.com/wiki/Blood_Extraction_Syringe',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_BloodExtractor.PrimalItem_BloodExtractor\'"',
            'name': 'Blood Extraction Syringe', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Blood_Extraction_Syringe.png'
        },
        {
            'class_name': 'PrimalItem_WeaponGPS_C', 'id': 71,
            'description': 'Detects strange energy from the three Obelisks to triangulate your exact location on the island.',
            'url': 'https://ark.fandom.com/wiki/GPS',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_WeaponGPS.PrimalItem_WeaponGPS\'"',
            'name': 'GPS', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/72/GPS.png'
        },
        {
            'class_name': 'PrimalItem_WeaponCompass_C', 'id': 136,
            'description': 'Use this to find which direction you are traveling.',
            'url': 'https://ark.fandom.com/wiki/Compass',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_WeaponCompass.PrimalItem_WeaponCompass\'"',
            'name': 'Compass', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Compass.png'
        },
        {
            'class_name': 'PrimalItemRadio_C', 'id': 140,
            'description': 'Use this to communicate securely over great distances.',
            'url': 'https://ark.fandom.com/wiki/Radio',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemRadio.PrimalItemRadio\'"',
            'name': 'Radio', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Radio.png'
        },
        {
            'class_name': 'PrimalItem_WeaponSpyglass_C', 'id': 279,
            'description': 'This instrument, while primitive, is quite effective at long-range reconnaissance.',
            'url': 'https://ark.fandom.com/wiki/Spyglass',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_WeaponSpyglass.PrimalItem_WeaponSpyglass\'"',
            'name': 'Spyglass', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Spyglass.png'
        },
        {
            'class_name': 'PrimalItem_WeaponSickle_C', 'id': 376,
            'description': 'A curved tool ideal for harvesting fiber from seed plants. Also useful for delicately shearing off slices of Prime Fish!',
            'url': 'https://ark.fandom.com/wiki/Metal_Sickle',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponSickle.PrimalItem_WeaponSickle\'"',
            'name': 'Metal Sickle', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e0/Metal_Sickle.png'
        },
        {
            'class_name': 'PrimalItem_Camera_C', 'id': 377, 'description': 'Equip, target, and take a shot!.',
            'url': 'https://ark.fandom.com/wiki/Camera',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_Camera.PrimalItem_Camera\'"', 'name': 'Camera',
            'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/80/Camera.png'
        },
        {
            'class_name': 'PrimalItem_ChainSaw_C', 'id': 378, 'description': 'The fastest way to cut a tree.',
            'url': 'https://ark.fandom.com/wiki/Chainsaw_(Scorched_Earth)',
            'blueprint': '"Blueprint\'/Game/ScorchedEarth/WeaponChainsaw/PrimalItem_ChainSaw.PrimalItem_ChainSaw\'"',
            'name': 'Chainsaw', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Chainsaw_%28Scorched_Earth%29.png'
        },
        {
            'class_name': 'PrimalItem_WeaponElectronicBinoculars_C', 'id': 379,
            'description': 'The ultimate long-range reconnaissance tool.',
            'url': 'https://ark.fandom.com/wiki/Electronic_Binoculars_(Genesis:_Part_1)',
            'blueprint': '"Blueprint\'/Game/ScorchedEarth/WeaponElectronicBinoculars/PrimalItem_WeaponElectronicBinoculars.PrimalItem_WeaponElectronicBinoculars\'"',
            'name': 'Electronic Binoculars', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/69/Electronic_Binoculars_%28Genesis_Part_1%29.png'
        },
        {
            'class_name': 'PrimalItem_WeaponEmptyCryopod_C', 'id': 380,
            'description': 'Hold up to a creature to capture it. Throw to deploy a captured creature.',
            'url': 'https://ark.fandom.com/wiki/Empty_Cryopod_(Extinction)',
            'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Weapons/PrimalItem_WeaponEmptyCryopod.PrimalItem_WeaponEmptyCryopod\'"',
            'name': 'Empty Cryopod', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3e/Cryopod.png'
        },
        {
            'class_name': 'PrimalItem_WeaponFishingNet_C', 'id': 381,
            'description': 'Wind up and throw it to catch nearby fish.',
            'url': 'https://ark.fandom.com/wiki/Fish_Net_(Genesis:_Part_1)',
            'blueprint': '"Blueprint\'/Game/Genesis/Weapons/FishingNet/PrimalItem_WeaponFishingNet.PrimalItem_WeaponFishingNet\'"',
            'name': 'Fish Net', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Fish_Net_%28Genesis_Part_1%29.png'
        },
        {
            'class_name': 'PrimalItem_WeaponFishingRod_C', 'id': 382,
            'description': 'Apply various bait to this, and then use when sitting on a chair or bench to catch some fish!',
            'url': 'https://ark.fandom.com/wiki/Fishing_Rod',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponFishingRod.PrimalItem_WeaponFishingRod\'"',
            'name': 'Fishing Rod', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c7/Fishing_Rod.png'
        },
        {
            'class_name': 'PrimalItem_WeaponMagnifyingGlass_C', 'id': 383,
            'description': 'This instrument, while primitive, is effective as short-range analysis of both flora and fauna.',
            'url': 'https://ark.fandom.com/wiki/Magnifying_Glass',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Test/PrimalItem_WeaponMagnifyingGlass.PrimalItem_WeaponMagnifyingGlass\'"',
            'name': 'Magnifying Glass', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Magnifying_Glass.png'
        },
        {
            'class_name': 'PrimalItem_WeaponMiningDrill_C', 'id': 384,
            'description': 'An incredibly effective gasoline-powered harvesting tool that utilizes an energy beam to collect valuable resources at distance.',
            'url': 'https://ark.fandom.com/wiki/Mining_Drill_(Genesis:_Part_1)',
            'blueprint': '"Blueprint\'/Game/Genesis/Weapons/MiningDrill/PrimalItem_WeaponMiningDrill.PrimalItem_WeaponMiningDrill\'"',
            'name': 'Mining Drill', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/30/Mining_Drill_%28Genesis_Part_1%29.png'
        },
        {
            'class_name': 'PrimalItem_Pliers_C', 'id': 385,
            'description': 'Use on a Smithy-crafted item in need of repairing and you can repair it on the go within any inventory, at a higher cost of resources.',
            'url': 'https://ark.fandom.com/wiki/Pliers_(Aberration)',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/PrimalItem_Pliers.PrimalItem_Pliers\'"',
            'name': 'Pliers', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c8/Pliers_%28Aberration%29.png'
        },
        {
            'class_name': 'PrimalItem_WeaponScissors_C', 'id': 386,
            'description': 'Used for cutting hair & other materials!', 'url': 'https://ark.fandom.com/wiki/Scissors',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItem_WeaponScissors.PrimalItem_WeaponScissors\'"',
            'name': 'Scissors', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Scissors.png'
        },
        {
            'class_name': 'PrimalItem_WeaponTaxidermyTool_C', 'id': 387,
            'description': 'Used to capture the Dermis of a dead creature.',
            'url': 'https://ark.fandom.com/wiki/Taxidermy_Tool_(Extinction)',
            'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Weapons/PrimalItem_WeaponTaxidermyTool.PrimalItem_WeaponTaxidermyTool\'"',
            'name': 'Taxidermy Tool', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0b/Taxidermy_Tool_%28Extinction%29.png'
        },
        {
            'class_name': 'PrimalItemConsumable_Lootcrate_lvl1_C', 'id': 388,
            'description': 'Drops a random assortment of gear',
            'url': 'https://ark.fandom.com/wiki/Lootcrate_(Genesis)',
            'blueprint': '"Blueprint\'/Game/Genesis/CoreBlueprints/Items/PrimalItemConsumable_Lootcrate_lvl1.PrimalItemConsumable_Lootcrate_lvl1\'"',
            'name': 'Tier 1 Lootcrate', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Lootcrate_%28Genesis_Part_1%29.png'
        },
        {
            'class_name': 'PrimalItemConsumable_Lootcrate_lvl2_C', 'id': 389,
            'description': 'Drops a random assortment of gear',
            'url': 'https://ark.fandom.com/wiki/Lootcrate_(Genesis)',
            'blueprint': '"Blueprint\'/Game/Genesis/CoreBlueprints/Items/PrimalItemConsumable_Lootcrate_lvl2.PrimalItemConsumable_Lootcrate_lvl2\'"',
            'name': 'Tier 2 Lootcrate', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Lootcrate_%28Genesis_Part_1%29.png'
        },
        {
            'class_name': 'PrimalItemConsumable_Lootcrate_lvl3_C', 'id': 390,
            'description': 'Drops a random assortment of gear',
            'url': 'https://ark.fandom.com/wiki/Lootcrate_(Genesis)',
            'blueprint': '"Blueprint\'/Game/Genesis/CoreBlueprints/Items/PrimalItemConsumable_Lootcrate_lvl3.PrimalItemConsumable_Lootcrate_lvl3\'"',
            'name': 'Tier 3 Lootcrate', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Lootcrate_%28Genesis_Part_1%29.png'
        },
        {
            'class_name': 'PrimalItem_WeaponWhip_C', 'id': 391,
            'description': 'Keeps your foes at bay, keeps your herd moving.',
            'url': 'https://ark.fandom.com/wiki/Whip_(Scorched_Earth)',
            'blueprint': '"Blueprint\'/Game/ScorchedEarth/WeaponWhip/PrimalItem_WeaponWhip.PrimalItem_WeaponWhip\'"',
            'name': 'Whip', 'stack_size': 1,
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b9/Whip_%28Scorched_Earth%29.png'
        }
    ]
    models.Tool.bulk_insert(items)
