from arkdata import models


def backup_seed():
    models.Seed.new(id=268, name='Tintoberry Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_Tintoberry_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Tintoberry_SpeedHack.PrimalItemConsumable_Seed_Tintoberry_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Tintoberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own tintoberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Tintoberry_Seed.png')
    models.Seed.new(id=270, name='Stimberry Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_Stimberry_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Stimberry_SpeedHack.PrimalItemConsumable_Seed_Stimberry_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Stimberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own stimberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/70/Stimberry_Seed.png')
    models.Seed.new(id=273, name='Savoroot Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_Savoroot_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Savoroot_SpeedHack.PrimalItemConsumable_Seed_Savoroot_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Savoroot_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own savoroot bush. Can be planted in Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b9/Savoroot_Seed.png')
    models.Seed.new(id=275, name='Rockarrot Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_Rockarrot_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Rockarrot_SpeedHack.PrimalItemConsumable_Seed_Rockarrot_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Rockarrot_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own rockarrot crop. Can be planted in Medium or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Rockarrot_Seed.png')
    models.Seed.new(id=387, name='Plant Species X Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_DefensePlant_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_DefensePlant_SpeedHack.PrimalItemConsumable_Seed_DefensePlant_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Plant_Species_X_Seed',
                    description='Plant this in a viable Large Crop Plot to grow a frightening-looking defensive plant, which will shoot poisonous spores at any interlopers!',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f4/Plant_Species_X_Seed.png')
    models.Seed.new(id=269, name='Narcoberry Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_Narcoberry_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Narcoberry_SpeedHack.PrimalItemConsumable_Seed_Narcoberry_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Narcoberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own narcoberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Narcoberry_Seed.png')
    models.Seed.new(id=271, name='Mejoberry Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_Mejoberry_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Mejoberry_SpeedHack.PrimalItemConsumable_Seed_Mejoberry_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Mejoberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own mejoberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Mejoberry_Seed.png')
    models.Seed.new(id=274, name='Longrass Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_Longrass_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Longrass_SpeedHack.PrimalItemConsumable_Seed_Longrass_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Longrass_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own longrass crop. Can be planted in Medium or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Longrass_Seed.png')
    models.Seed.new(id=272, name='Citronal Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_Citronal_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Citronal_SpeedHack.PrimalItemConsumable_Seed_Citronal_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Citronal_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own citronal crop. Can be planted in Medium or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/95/Citronal_Seed.png')
    models.Seed.new(id=49, name='Berrybush Seeds', stack_size=100, class_name='PrimalItemConsumable_Seed_Test_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Test.PrimalItemConsumable_Seed_Test\'"',
                    url='https://ark.fandom.com/wiki/Berrybush_Seeds',
                    description='Eat it to gain small nourishment, or plant it to grow your own Berrybush! (supports Small, Medium, or Large crop plots)',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1f/Berrybush_Seeds.png')
    models.Seed.new(id=267, name='Azulberry Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_Azulberry_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Azulberry_SpeedHack.PrimalItemConsumable_Seed_Azulberry_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Azulberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own azulberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Azulberry_Seed.png')
    models.Seed.new(id=266, name='Amarberry Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_Amarberry_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Amarberry_SpeedHack.PrimalItemConsumable_Seed_Amarberry_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Amarberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own amarberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/af/Amarberry_Seed.png')
    models.Seed.new(id=232, name='Tintoberry Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_Tintoberry_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Tintoberry.PrimalItemConsumable_Seed_Tintoberry\'"',
                    url='https://ark.fandom.com/wiki/Tintoberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own tintoberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Tintoberry_Seed.png')
    models.Seed.new(id=235, name='Stimberry Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_Stimberry_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Stimberry.PrimalItemConsumable_Seed_Stimberry\'"',
                    url='https://ark.fandom.com/wiki/Stimberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own stimberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/70/Stimberry_Seed.png')
    models.Seed.new(id=236, name='Savoroot Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_Savoroot_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Savoroot.PrimalItemConsumable_Seed_Savoroot\'"',
                    url='https://ark.fandom.com/wiki/Savoroot_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own savoroot bush. Can be planted in Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b9/Savoroot_Seed.png')
    models.Seed.new(id=238, name='Rockarrot Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_Rockarrot_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Rockarrot.PrimalItemConsumable_Seed_Rockarrot\'"',
                    url='https://ark.fandom.com/wiki/Rockarrot_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own rockarrot crop. Can be planted in Medium or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Rockarrot_Seed.png')
    models.Seed.new(id=386, name='Plant Species X Seed', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_DefensePlant_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_DefensePlant.PrimalItemConsumable_Seed_DefensePlant\'"',
                    url='https://ark.fandom.com/wiki/Plant_Species_X_Seed',
                    description='Plant this in a viable Large Crop Plot to grow a frightening-looking defensive plant, which will shoot poisonous spores at any interlopers!',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f4/Plant_Species_X_Seed.png')
    models.Seed.new(id=234, name='Narcoberry Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_Narcoberry_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Narcoberry.PrimalItemConsumable_Seed_Narcoberry\'"',
                    url='https://ark.fandom.com/wiki/Narcoberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own narcoberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Narcoberry_Seed.png')
    models.Seed.new(id=233, name='Mejoberry Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_Mejoberry_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Mejoberry.PrimalItemConsumable_Seed_Mejoberry\'"',
                    url='https://ark.fandom.com/wiki/Mejoberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own mejoberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Mejoberry_Seed.png')
    models.Seed.new(id=237, name='Longrass Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_Longrass_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Longrass.PrimalItemConsumable_Seed_Longrass\'"',
                    url='https://ark.fandom.com/wiki/Longrass_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own longrass crop. Can be planted in Medium or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Longrass_Seed.png')
    models.Seed.new(id=132, name='Citronal Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_Citronal_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Citronal.PrimalItemConsumable_Seed_Citronal\'"',
                    url='https://ark.fandom.com/wiki/Citronal_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own citronal crop. Can be planted in Medium or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/95/Citronal_Seed.png')
    models.Seed.new(id=231, name='Azulberry Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_Azulberry_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Azulberry.PrimalItemConsumable_Seed_Azulberry\'"',
                    url='https://ark.fandom.com/wiki/Azulberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own azulberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Azulberry_Seed.png')
    models.Seed.new(id=115, name='Amarberry Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_Amarberry_C',
                    blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Amarberry.PrimalItemConsumable_Seed_Amarberry\'"',
                    url='https://ark.fandom.com/wiki/Amarberry_Seed',
                    description='Eat it to gain a tiny amount of nourishment, or plant it to grow your own amarberry bush. Can be planted in Small, Medium, or Large crop plots.',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/af/Amarberry_Seed.png')
    models.Seed.new(name='Plant Species Y Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_PlantSpeciesY_C',
                    blueprint='"Blueprint\'/Game/ScorchedEarth/WeaponPlantSpeciesY/PrimalItemConsumable_Seed_PlantSpeciesY.PrimalItemConsumable_Seed_PlantSpeciesY\'"',
                    url='https://ark.fandom.com/wiki/Plant_Species_Y_Seed',
                    description='Plant this in a viable large crop plot to grow a frightening-looking defensive plant, which will shoot poisonous spores at any interlopers!',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/Plant_Species_Y_Seed_%28Scorched_Earth%29.png')
    models.Seed.new(name='Plant Species Z Seed', stack_size=100, class_name='PrimalItemConsumable_Seed_PlantSpeciesZ_C',
                    blueprint='"Blueprint\'/Game/Aberration/WeaponPlantSpeciesZ/PrimalItemConsumable_Seed_PlantSpeciesZ.PrimalItemConsumable_Seed_PlantSpeciesZ\'"',
                    url='https://ark.fandom.com/wiki/Plant_Species_Z_Seed_(Aberration)',
                    description='Plant this in a viable large crop plot to grow a charge-infused plant, that will protect you against enemies and provide you with fruits!',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/71/Plant_Species_Z_Seed_%28Aberration%29.png')
    models.Seed.new(name='Plant Species Y Seed (instant grow)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_PlantSpeciesY_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/ScorchedEarth/WeaponPlantSpeciesY/PrimalItemConsumable_Seed_PlantSpeciesY_SpeedHack.PrimalItemConsumable_Seed_PlantSpeciesY_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Plant_Species_Y_Seed',
                    description='Plant this in a viable large crop plot to grow a frightening-looking defensive plant, which will shoot poisonous spores at any interlopers!',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/Plant_Species_Y_Seed_%28Scorched_Earth%29.png')
    models.Seed.new(name='Plant Species Z Seed (SpeedHack)', stack_size=100,
                    class_name='PrimalItemConsumable_Seed_PlantSpeciesZ_SpeedHack_C',
                    blueprint='"Blueprint\'/Game/Aberration/WeaponPlantSpeciesZ/PrimalItemConsumable_Seed_PlantSpeciesZ_SpeedHack.PrimalItemConsumable_Seed_PlantSpeciesZ_SpeedHack\'"',
                    url='https://ark.fandom.com/wiki/Plant_Species_Z_Seed_(Aberration)',
                    description='Plant this in a viable large crop plot to grow a charge-infused plant, that will protect you against enemies and provide you with fruits!',
                    image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/71/Plant_Species_Z_Seed_%28Aberration%29.png')

    items = [item.to_json() for item in models.Seed.all()]
    print(items)


def seed():
    items = [
        {
            'name': 'Berrybush Seeds', 'class_name': 'PrimalItemConsumable_Seed_Test_C',
            'description': 'Eat it to gain small nourishment, or plant it to grow your own Berrybush! (supports Small, Medium, or Large crop plots)',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1f/Berrybush_Seeds.png',
            'id': 49, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Test.PrimalItemConsumable_Seed_Test\'"',
            'url': 'https://ark.fandom.com/wiki/Berrybush_Seeds'
        },
        {
            'name': 'Amarberry Seed', 'class_name': 'PrimalItemConsumable_Seed_Amarberry_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own amarberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/af/Amarberry_Seed.png',
            'id': 115, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Amarberry.PrimalItemConsumable_Seed_Amarberry\'"',
            'url': 'https://ark.fandom.com/wiki/Amarberry_Seed'
        },
        {
            'name': 'Citronal Seed', 'class_name': 'PrimalItemConsumable_Seed_Citronal_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own citronal crop. Can be planted in Medium or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/95/Citronal_Seed.png',
            'id': 132, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Citronal.PrimalItemConsumable_Seed_Citronal\'"',
            'url': 'https://ark.fandom.com/wiki/Citronal_Seed'
        },
        {
            'name': 'Azulberry Seed', 'class_name': 'PrimalItemConsumable_Seed_Azulberry_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own azulberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Azulberry_Seed.png',
            'id': 231, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Azulberry.PrimalItemConsumable_Seed_Azulberry\'"',
            'url': 'https://ark.fandom.com/wiki/Azulberry_Seed'
        },
        {
            'name': 'Tintoberry Seed', 'class_name': 'PrimalItemConsumable_Seed_Tintoberry_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own tintoberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Tintoberry_Seed.png',
            'id': 232, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Tintoberry.PrimalItemConsumable_Seed_Tintoberry\'"',
            'url': 'https://ark.fandom.com/wiki/Tintoberry_Seed'
        },
        {
            'name': 'Mejoberry Seed', 'class_name': 'PrimalItemConsumable_Seed_Mejoberry_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own mejoberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Mejoberry_Seed.png',
            'id': 233, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Mejoberry.PrimalItemConsumable_Seed_Mejoberry\'"',
            'url': 'https://ark.fandom.com/wiki/Mejoberry_Seed'
        },
        {
            'name': 'Narcoberry Seed', 'class_name': 'PrimalItemConsumable_Seed_Narcoberry_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own narcoberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Narcoberry_Seed.png',
            'id': 234, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Narcoberry.PrimalItemConsumable_Seed_Narcoberry\'"',
            'url': 'https://ark.fandom.com/wiki/Narcoberry_Seed'
        },
        {
            'name': 'Stimberry Seed', 'class_name': 'PrimalItemConsumable_Seed_Stimberry_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own stimberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/70/Stimberry_Seed.png',
            'id': 235, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Stimberry.PrimalItemConsumable_Seed_Stimberry\'"',
            'url': 'https://ark.fandom.com/wiki/Stimberry_Seed'
        },
        {
            'name': 'Savoroot Seed', 'class_name': 'PrimalItemConsumable_Seed_Savoroot_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own savoroot bush. Can be planted in Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b9/Savoroot_Seed.png',
            'id': 236, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Savoroot.PrimalItemConsumable_Seed_Savoroot\'"',
            'url': 'https://ark.fandom.com/wiki/Savoroot_Seed'
        },
        {
            'name': 'Longrass Seed', 'class_name': 'PrimalItemConsumable_Seed_Longrass_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own longrass crop. Can be planted in Medium or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Longrass_Seed.png',
            'id': 237, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Longrass.PrimalItemConsumable_Seed_Longrass\'"',
            'url': 'https://ark.fandom.com/wiki/Longrass_Seed'
        },
        {
            'name': 'Rockarrot Seed', 'class_name': 'PrimalItemConsumable_Seed_Rockarrot_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own rockarrot crop. Can be planted in Medium or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Rockarrot_Seed.png',
            'id': 238, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Rockarrot.PrimalItemConsumable_Seed_Rockarrot\'"',
            'url': 'https://ark.fandom.com/wiki/Rockarrot_Seed'
        },
        {
            'name': 'Amarberry Seed (instant grow)', 'class_name': 'PrimalItemConsumable_Seed_Amarberry_SpeedHack_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own amarberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/af/Amarberry_Seed.png',
            'id': 266, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Amarberry_SpeedHack.PrimalItemConsumable_Seed_Amarberry_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Amarberry_Seed'
        },
        {
            'name': 'Azulberry Seed (instant grow)', 'class_name': 'PrimalItemConsumable_Seed_Azulberry_SpeedHack_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own azulberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Azulberry_Seed.png',
            'id': 267, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Azulberry_SpeedHack.PrimalItemConsumable_Seed_Azulberry_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Azulberry_Seed'
        },
        {
            'name': 'Tintoberry Seed (instant grow)', 'class_name': 'PrimalItemConsumable_Seed_Tintoberry_SpeedHack_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own tintoberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Tintoberry_Seed.png',
            'id': 268, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Tintoberry_SpeedHack.PrimalItemConsumable_Seed_Tintoberry_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Tintoberry_Seed'
        },
        {
            'name': 'Narcoberry Seed (instant grow)', 'class_name': 'PrimalItemConsumable_Seed_Narcoberry_SpeedHack_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own narcoberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Narcoberry_Seed.png',
            'id': 269, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Narcoberry_SpeedHack.PrimalItemConsumable_Seed_Narcoberry_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Narcoberry_Seed'
        },
        {
            'name': 'Stimberry Seed (instant grow)', 'class_name': 'PrimalItemConsumable_Seed_Stimberry_SpeedHack_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own stimberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/70/Stimberry_Seed.png',
            'id': 270, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Stimberry_SpeedHack.PrimalItemConsumable_Seed_Stimberry_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Stimberry_Seed'
        },
        {
            'name': 'Mejoberry Seed (instant grow)', 'class_name': 'PrimalItemConsumable_Seed_Mejoberry_SpeedHack_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own mejoberry bush. Can be planted in Small, Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Mejoberry_Seed.png',
            'id': 271, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Mejoberry_SpeedHack.PrimalItemConsumable_Seed_Mejoberry_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Mejoberry_Seed'
        },
        {
            'name': 'Citronal Seed (instant grow)', 'class_name': 'PrimalItemConsumable_Seed_Citronal_SpeedHack_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own citronal crop. Can be planted in Medium or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/95/Citronal_Seed.png',
            'id': 272, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Citronal_SpeedHack.PrimalItemConsumable_Seed_Citronal_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Citronal_Seed'
        },
        {
            'name': 'Savoroot Seed (instant grow)', 'class_name': 'PrimalItemConsumable_Seed_Savoroot_SpeedHack_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own savoroot bush. Can be planted in Medium, or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b9/Savoroot_Seed.png',
            'id': 273, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Savoroot_SpeedHack.PrimalItemConsumable_Seed_Savoroot_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Savoroot_Seed'
        },
        {
            'name': 'Longrass Seed (instant grow)', 'class_name': 'PrimalItemConsumable_Seed_Longrass_SpeedHack_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own longrass crop. Can be planted in Medium or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Longrass_Seed.png',
            'id': 274, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Longrass_SpeedHack.PrimalItemConsumable_Seed_Longrass_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Longrass_Seed'
        },
        {
            'name': 'Rockarrot Seed (instant grow)', 'class_name': 'PrimalItemConsumable_Seed_Rockarrot_SpeedHack_C',
            'description': 'Eat it to gain a tiny amount of nourishment, or plant it to grow your own rockarrot crop. Can be planted in Medium or Large crop plots.',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Rockarrot_Seed.png',
            'id': 275, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_Rockarrot_SpeedHack.PrimalItemConsumable_Seed_Rockarrot_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Rockarrot_Seed'
        },
        {
            'name': 'Plant Species X Seed', 'class_name': 'PrimalItemConsumable_Seed_DefensePlant_C',
            'description': 'Plant this in a viable Large Crop Plot to grow a frightening-looking defensive plant, which will shoot poisonous spores at any interlopers!',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f4/Plant_Species_X_Seed.png',
            'id': 386, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_DefensePlant.PrimalItemConsumable_Seed_DefensePlant\'"',
            'url': 'https://ark.fandom.com/wiki/Plant_Species_X_Seed'
        },
        {
            'name': 'Plant Species X Seed (instant grow)',
            'class_name': 'PrimalItemConsumable_Seed_DefensePlant_SpeedHack_C',
            'description': 'Plant this in a viable Large Crop Plot to grow a frightening-looking defensive plant, which will shoot poisonous spores at any interlopers!',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f4/Plant_Species_X_Seed.png',
            'id': 387, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/Seeds/PrimalItemConsumable_Seed_DefensePlant_SpeedHack.PrimalItemConsumable_Seed_DefensePlant_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Plant_Species_X_Seed'
        },
        {
            'name': 'Plant Species Y Seed', 'class_name': 'PrimalItemConsumable_Seed_PlantSpeciesY_C',
            'description': 'Plant this in a viable large crop plot to grow a frightening-looking defensive plant, which will shoot poisonous spores at any interlopers!',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/Plant_Species_Y_Seed_%28Scorched_Earth%29.png',
            'id': 388, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/ScorchedEarth/WeaponPlantSpeciesY/PrimalItemConsumable_Seed_PlantSpeciesY.PrimalItemConsumable_Seed_PlantSpeciesY\'"',
            'url': 'https://ark.fandom.com/wiki/Plant_Species_Y_Seed'
        },
        {
            'name': 'Plant Species Z Seed', 'class_name': 'PrimalItemConsumable_Seed_PlantSpeciesZ_C',
            'description': 'Plant this in a viable large crop plot to grow a charge-infused plant, that will protect you against enemies and provide you with fruits!',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/71/Plant_Species_Z_Seed_%28Aberration%29.png',
            'id': 389, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/Aberration/WeaponPlantSpeciesZ/PrimalItemConsumable_Seed_PlantSpeciesZ.PrimalItemConsumable_Seed_PlantSpeciesZ\'"',
            'url': 'https://ark.fandom.com/wiki/Plant_Species_Z_Seed_(Aberration)'
        },
        {
            'name': 'Plant Species Y Seed (instant grow)',
            'class_name': 'PrimalItemConsumable_Seed_PlantSpeciesY_SpeedHack_C',
            'description': 'Plant this in a viable large crop plot to grow a frightening-looking defensive plant, which will shoot poisonous spores at any interlopers!',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/Plant_Species_Y_Seed_%28Scorched_Earth%29.png',
            'id': 390, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/ScorchedEarth/WeaponPlantSpeciesY/PrimalItemConsumable_Seed_PlantSpeciesY_SpeedHack.PrimalItemConsumable_Seed_PlantSpeciesY_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Plant_Species_Y_Seed'
        },
        {
            'name': 'Plant Species Z Seed (SpeedHack)',
            'class_name': 'PrimalItemConsumable_Seed_PlantSpeciesZ_SpeedHack_C',
            'description': 'Plant this in a viable large crop plot to grow a charge-infused plant, that will protect you against enemies and provide you with fruits!',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/71/Plant_Species_Z_Seed_%28Aberration%29.png',
            'id': 391, 'stack_size': 100,
            'blueprint': '"Blueprint\'/Game/Aberration/WeaponPlantSpeciesZ/PrimalItemConsumable_Seed_PlantSpeciesZ_SpeedHack.PrimalItemConsumable_Seed_PlantSpeciesZ_SpeedHack\'"',
            'url': 'https://ark.fandom.com/wiki/Plant_Species_Z_Seed_(Aberration)'
        }
    ]
    models.Seed.bulk_insert(items)
