from arkdata import models


def backup_seed():
    models.Creature.new(name='Aberrant Achatina', name_tag='Achatina', category='Invertebrates',
                        entity_id='Achatina_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/18/Achatina.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Achatina',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Achatina/Achatina_Character_BP_Aberrant.Achatina_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bc/Dossier_Achatina.png',
                        description='“\nSpecies\nAchatina limusegnis\nTime\nHolocene\nDiet\nHerbivore\nTemperament\nPassive\nWild\nFound mostly in marshes and jungles, Achatina limusegnis is a very slow, very non-threatening land mollusk. It might be the simplest creature on the Island to hunt, and while it only provides a small amount of meat and chitin, an easy meal is always of value on the Island. Unlike nearly every other creature on the Island, Achatina does not defecate normally. Instead, it secretes a thick, sticky substance. Achatina leaves trails of this slime, but the trails are so thin that they crumble to dust quickly.\nDomesticated\nThere is a very disgusting, but useful fact about Achatina that causes tribes to seek to tame them: its secretions are chemically similar to the "Cementing Paste" and "Organic Polymer" used by many tribes for building materials. Tamed Achatina naturally accumulates this slime over time, which can then be collected at the tribe\'s convenience. Legend has it that Achatina can be tamed with a special "cake" made from harvested crops & resources.\n„\n~ Helena')
    models.Creature.new(name='Aberrant Anglerfish', name_tag='Angler', category='Fish',
                        entity_id='Angler_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Anglerfish.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Anglerfish',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Anglerfish/Angler_Character_BP_Aberrant.Angler_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0d/Dossier_Angler.png',
                        description="“\nSpecies\nMelanocetus anglerpescum\nTime\nEarly Cretaceous - Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWhether its size is caused by adaptation to the Island's other inhabitants, or by cross-breeding with another larger species, Melanocetus angerlpescum is the largest form of Anglerfish I've ever heard of. Typically found among the deepest, darkest expanses of the ocean, this creature preys on smaller fish while being an excellent source of food for larger predators. Melanocetus has an array of bioluminescent light pods at the end of stalks on its head. Like typical Anglerfish, it primarily uses these to attract smaller creatures and trick them into coming close enough for Melanocetus to consume the prey. This often makes wild Melanocetus itself relatively easy to spot among the briny depths.\nDomesticated\nExploring the depths of the ocean can be difficult. The cold, the lack of air, and the shocking absence of light combine to make travel very dangerous. A tamed Anglerfish can use the natural light at the end of its stalks to illuminate the depths, making exploration not only safer but more lucrative, as I've heard some survivors use this creature to harvest the silica pearls found throughout the ocean's depths!\n„\n~ Helena")
    models.Creature.new(name='Aberrant Ankylosaurus', name_tag='Anky', category='Dinosaurs',
                        entity_id='Ankylo_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a7/Ankylosaurus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Ankylosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Ankylo/Ankylo_Character_BP_Aberrant.Ankylo_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8e/Dossier_Ankylosaurus.png',
                        description="“\nSpecies\nAnkylosaurus crassacutis\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nDocile\nWild\nUnlike many of the herd animals on the Island, Ankylosaurus crassacutis tends to live in small family units. I believe they can afford to stick with smaller groups because of their incredibly thick skin, for which they're named. Despite not being among the largest of the Island's herbivores, Ankylosaurus is one of the more difficult creatures to take down. Its thick, armored skin seems to make it more than a match for several of the mid-sized predators that would otherwise hunt it. Reckless carnivores are just as likely to hurt themselves on Ankylosaurus' spikes, as they are to get hit by its tail.\nDomesticated\nWithout a doubt, the best trait of a trained Ankylosaurus is its enormously dense tail. This tail is powerful enough to quickly shatter the resource-laden rocks of the Island. One of the wealthier human tribes on the island utilizes a squad of Ankylosaurs in its mines and quarries. The creature's affinity for metal enables it to carry raw ore at an effectively reduced weight.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Araneo', name_tag='Spider', category='Invertebrates',
                        entity_id='SpiderS_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Spider.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Araneo',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Spider-Small/SpiderS_Character_BP_Aberrant.SpiderS_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Dossier_Araneo.png',
                        description="“\nSpecies\nAraneomorphus amalgotantibus\nTime\nNo equivalent, traits begin as far as Mesozoic Era\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nI don't know where to start with Araneomorphus amalgotantibus. It has so many of the nightmare inducing traits of spiders from among many family and genus. It fires webbing like a bola spider, it spits venom like a lynx spider. It has a poisonous bite like a myriad of spiders, and can see in the dark by sensing vibrations. And to top it off, Araneomorphus is larger than an adult human! If that wasn't enough, I'm convinced that some of the caves on the island have actually been dug by Araneomorphus, but this worries me. Either Araneomorphus is a colony-spider (like ants), or there is a much larger Araneomorphus somewhere on the island.\nDomesticated\nAs long as it is kept far from arachnophobics, domesticated Araneomorphus makes an excellent guardian creature for anyone wanting to avoid killing. Their strange web-spraying behavior is also quite helpful while hunting fast, fleeing prey. They are too small to be used as mounts, however...\n„\n~ Helena")
    models.Creature.new(name='Aberrant Arthropluera', name_tag='Arthro', category='Invertebrates',
                        entity_id='Arthro_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Arthropluera.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Arthropluera',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Arthropluera/Arthro_Character_BP_Aberrant.Arthro_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Dossier_Arthropluera.png',
                        description="“\nSpecies\nArthropluera felsanguis\nTime\nEarly Permian\nDiet\nCarrion-Feeder\nTemperament\nAggressive\nWild\nThe fact that this creature exists is enough to give me nightmares. Like the island's other Arthropods, Arthropluera Felsanguis has become much larger than I might have believed possible. It's a very aggressive hunter, but prefers to eat meat after it has rotted for some time, and will voraciously seek out such delicacies.\nKnown Information\nArthropluera's blood has a very low pH, to the point that it can dissolve many materials. This acidic blood splashes back on anything that directly attacks it, weakening the durability of weapons and hurting attackers. Many creatures thusly refuse to prey on Arthropluera, fearing this unique defense. If that wasn't enough, Arthropluera also keeps a small reservoir of blood ready to spit at its prey.\nDomesticated\nLike most of the arthropods on the island, Arthropluera is simple minded and relatively easy to tame. It is an almost entirely military mount, useful mostly for attacking at a distance. Thanks to its unique defenses, whether hunting or warring, Arthropluera is generally safe from all but the largest of creatures.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Baryonyx', name_tag='Baryonyx', category='Dinosaurs',
                        entity_id='Baryonyx_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c0/Baryonyx.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Baryonyx',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Baryonyx/Baryonyx_Character_BP_Aberrant.Baryonyx_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Baryonyx.png',
                        description="“\nSpecies\nBaryonyx aquafulgur\nTime\nEarly Cretaceous\nDiet\nPiscivore\nTemperament\nPassive to land creatures, but aggressive to water-dwellers\nWild\nLike the Carnotaurus, Baryonyx aquafulguar is a large carnivore, but not large enough to rival the Island's apex predators. While not as powerful as some deep-sea predators or Spinosaurus, Baryonyx is an extremely fast swimmer who is still sufficiently nimble enough to threaten most creatures on the Island. And yet despite being a fast, dangerous dinosaur, Baryonyx almost exclusively consumes fish and other water-dwellers. The highly specific metabolism of Baryonyx seems to allow it to heal wounds almost preternaturally fast after feeding on nutritious fish meat. Perhaps this is why Baryonyx rarely attacks land animals?\nDomesticated\nBaryonyx's natural affinity for aquatic predation means that once tamed; it learns to kill ocean-dwellers even more efficiently. Between its speed and its power, Baryonyx makes an ideal choice for anyone interested in frequently moving between water and land travel, and who values speed and agility over raw strength.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Beelzebufo', name_tag='Toad', category='Reptiles',
                        entity_id='Toad_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f6/Beelzebufo.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Beelzebufo',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Toad/Toad_Character_BP_Aberrant.Toad_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Dossier_Beelzebufo.png',
                        description="“\nSpecies\nBeelzebufo palucocus\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nLanguorous\nWild\nBeelzebufo palucocus is the largest frog I've ever seen. Almost impossibly large, it can actually fit a fully-grown human adult on its back, though just barely. This is a dangerous prospect, though, as secretions from Beelzebufo's skin and saliva have a narcotic effect on most creatures. Not surprisingly, Beelzebufo is adept at killing insects. Its lengthy tongue allows it to quickly grab prey from afar, killing most insects near instantly and quickly digesting them. It even combines the narcotic chemicals in its mouth with the insects' chitin to create a specialized sticky substance.\nDomesticated\nTamed Beelzebufo make for strange mounts. Strange mounts for strange people. Many tribes don't believe there's any reason to ride them, but some enjoy the ability to take large vertical hops up huge walls and cliffs. Regardless of how it is ridden, Beelzebufo is also employed for its ability to quickly cull insects, and convert them into always-useful cementing paste.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Carbonemys', name_tag='Turtle', category='Reptiles',
                        entity_id='Turtle_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4c/Carbonemys.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Carbonemys',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Turtle/Turtle_Character_BP_Aberrant.Turtle_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Carbonemys.png',
                        description="“\nSpecies\nCarbonemys obibimus\nTime\nDanian\nDiet\nHerbivore\nTemperament\nDefensive\nWild\nCarbonemys obibimus is one of the least aggressive creatures on the Island. Were it not for the plethora of predators on the Island, I'm quite certain that it would spend its days basking in the sun, eating, or sleeping. Carbonemys leads a simple, solitary life. Nevertheless, it seems to be one of the most peaceful animals I have yet encountered. With its slow walking speed, the only things that keep it safe are its surprisingly fast swim speed, and its incredibly thick shell, which can absorb tremendous damage.\nDomesticated\nCarbonemys' swift swim rate, fairly high strength, superior shell defenses, and lack of real threat makes it an ideal armored mount for many survivors who shy away from violence. It can carry its rider to the ocean's resources at fairly high speed, and is not particularly dangerous to tame.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Carnotaurus', name_tag='Carno', category='Dinosaurs',
                        entity_id='Carno_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Carnotaurus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Carnotaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Carno/Carno_Character_BP_Aberrant.Carno_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Carnotaurus.png',
                        description="“\nSpecies\nCarnotaurus pressor\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nCarnotaurus pressor is a distinctive creature that falls between a medium and large predator. It lives primarily on flat, clear ground, where it can capitalize on its speed. Additionally, it seems to have no qualms about running away from larger predators instead of fighting. The horns of the Carnotaurus seem to be used more for fighting rivals than actual hunting. This doesn't mean the horns aren't dangerous, though. They can still eviscerate larger prey. Carnotaurus is one of the smaller and more compact of the large predators. If Tyrannosaurus is the “lion” of the Island, Carnotaurus would certainly be the “cheetah.” The real threat of a Carnotaurus is not being able to escape it once it has spotted you.\nDomesticated\nCarnotaurus fills a very specific role. Larger and almost as fast as a Raptor, smaller but much faster than a Rex. Were it not for the creature's extremely long down-time after sprinting, it might be among the most capably balanced mounts.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Cnidaria', name_tag='Cnidaria', category='Invertebrates',
                        entity_id='Cnidaria_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Cnidaria.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Cnidaria',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Cnidaria/Cnidaria_Character_BP_Aberrant.Cnidaria_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Cnidaria.png',
                        description="“\nSpecies\nCnidaria omnimorph\nTime\nCambrian - Holocene\nDiet\nHerbivore\nTemperament\nPassive, but aggressive at close range\nWild\nCnidaria omnimorph is another example of a creature which should not exist. It has traits that seem derived from many types of jellyfish. It possesses the size and shape of large egg-yolk jellies, the powerful sting of certain box jellies, and the bioluminescence of deep-sea jellies. This all combines to make a dangerous creature that lights up the deepest reaches of the ocean. Cnidaria is not generally aggressive, because it lacks normal perceptive senses. It generally just floats along on the current until something gets close enough to sense, at which point it attacks. While its attacks are not directly powerful, its sting injects an incredibly strong and fast-acting sedative.\nDomesticated\nAs Cnidaria is barely more intelligent than a plant, there's no effective method to tame one. Most tribes kill Cnidaria on sight, then collect its reserve of powerful sedative, to use in technically advanced long-distance tranquilizers.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Coelacanth', name_tag='Coel', category='Fish',
                        entity_id='Coel_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ef/Abberant_Coelacanth.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Coelacanth',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Coelacanth/Coel_Character_BP_Aberrant.Coel_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1b/Dossier_Coelacanth.png',
                        description=None)
    models.Creature.new(name='Aberrant Dimetrodon', name_tag='Dimetro', category='Dinosaurs',
                        entity_id='Dimetro_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Dimetrodon.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Dimetrodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dimetrodon/Dimetro_Character_BP_Aberrant.Dimetro_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8d/Dossier_Dimetrodon.png',
                        description="“\nSpecies\nDimetrodon calorector\nTime\nEarly Permian\nDiet\nCarnivore\nTemperament\nReactive\nWild\nDimetrodon calorector is a much calmer predator than most on the Island. Because it lives off smaller prey than humans, it generally ignores anything much larger than a Coelacanth. Dimetrodon is one of the few carnivores on the Island that could be classified as reasonably friendly in the wild. The sail on Dimetrodon's back is an especially fascinating thing. It can be angled to provide shade from the sun and allows Dimetrodon to disperse heat more quickly. The inner workings of the sail can also restrict blood flow in the creature to hold in excessive heat. Together, these two traits allow Dimetrodon to comfortably survive in any climate, though they are most commonly found in the swamplands which are rich in prey.\nDomesticated\nIf Dimetrodon was a bit larger, or didn't have that massive sail, it would make a decent mount. However, its main use to survivors is to utilize the sail's insulating capabilities. Just being near Dimetrodon gives excellent protection from both heat and cold, which has saved my life through more than one ice blizzard in the frozen northlands.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Dimorphodon', name_tag='Dimorph', category='Dinosaurs',
                        entity_id='Dimorph_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Dimorphodon.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Dimorphodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dimorphodon/Dimorph_Character_BP_Aberrant.Dimorph_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/Dossier_Dimorphodon.png',
                        description="“\nSpecies\nDimorphodon equesica\nTime\nEarly Jurassic\nDiet\nCarnivore\nTemperament\nReactive\nWild\nDimorphodon equesica is another of the Island's Jekyll-and-Hyde creatures. It is normally passive, sometimes even friendly. When provoked, it becomes very aggressive, even against larger creatures it has no business fighting...often to its own fatal end. Dimorphodon can make short work of smaller opponents, however, due to its large (but lightweight) skull and teeth. Barely over a meter tall, Dimorphodon should be low on the food chain, but its incredible speed and surprisingly strong bite make it fairly dangerous, especially en masse as they tend to attack in groups. A flock of angry or hungry Dimorphodon can take down prey several times their size, so survivors should take care not to hunt near where a flock is gathered.\nDomesticated\nDimorphodon is one of the creatures on the Island that is easily domesticated for companionship, but its use in combat is also quite clear: It will hunt in large groups to seek out enemy dino riders directly, harassing them to no end, regardless of the might of their mount!\n„\n~ Helena")
    models.Creature.new(name='Aberrant Diplocaulus', name_tag='Diplocaulus', category='Amphibians',
                        entity_id='Diplocaulus_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Diplocaulus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Diplocaulus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Diplocaulus/Diplocaulus_Character_BP_Aberrant.Diplocaulus_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/af/Dossier_Diplocaulus.png',
                        description="“\nSpecies\nDiplocaulus natatorinutrix\nTime\nPermian\nDiet\nPiscivore\nTemperament\nSkittish\nWild\nPresiding almost solely within the Island's swamps, Diplocaulus natatorinutrix is a small amphibian that primarily eats minor fish. It rounds out what I consider to be the middle-bottom of the ecosystem, feeding on the tinier non-insect creatures of the Island while itself being a common snack for the larger carnivores. Because so many creatures prey on it, Diplocaulus has become very skittish and often flees at the first sign of trouble. It uses its amphibious nature to escape into whichever environment its predator isn't native to. Diplocaulus' unique capability to retain vast quantities of oxygen allows it to effectively remain submerged for hours at a time, usually outlasting even other amphibious creatures that might otherwise prey upon it.\nDomesticated\nThere are only a few uses for tamed Diplocaulus. It is primarily kept for the (rather disgusting) practice of employing a Diplocaulus as an oxygen bag. Diplocaulus stores air in the bladders of its head, and divers can suck from these bladders to take deep breaths while submerged, supporting long-term underwater exploration without the use of external gear. Surprisingly, Diplocaulus is also extremely efficient when it comes to hunting Trilobites.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Diplodocus', name_tag='Diplo', category='Dinosaurs',
                        entity_id='Diplodocus_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e6/Diplodocus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Diplodocus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Diplodocus/Diplodocus_Character_BP_Aberrant.Diplodocus_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Dossier_Diplodocus.png',
                        description='“\nSpecies\nDiplodocus insulaprincep\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nNaive\nWild\nDespite being one of the Island\'s largest creatures, Diplodocus insulaprincep is among the Island\'s smaller sauropods. Instead of size and intelligence, Diplodocus developed faster maximum speed and greater endurance. When fully matured, it generally only reaches about half the size of the rather enormous Brontosaurus. Diplodocus is another creature whose continued survival on the Island confuses me. It\'s a very thick-headed and trusting animal, often to its fatal detriment. It never flees from predators until after they\'ve attacked it repeatedly, preferring instead to make numerous fruitless attempts at friendship. For some strange reason, Diplodocus trusts humans so much that it doesn\'t seem to fight back against them…ever!\nDomesticated\nDue to Diplodocus\' smaller frame, it cannot support the type of "platform" saddle that other large creatures can. To make up for this, many tribes instead use an eleven-seater passenger saddle which enables Diplodocus to safely transport ten additional riders. These passengers often use ranged weapons to protect the creature, or to attack nearby enemies while on the move!\n„\n~ Helena')
    models.Creature.new(name='Aberrant Dire Bear', name_tag='Direbear', category='Mammals',
                        entity_id='Direbear_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6f/Dire_Bear.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Dire_Bear',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Direbear/Direbear_Character_BP_Aberrant.Direbear_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/20/Dossier_Dire_Bear.png',
                        description="“\nSpecies\nArctodus dirus\nTime\nMid Pleistocene - Early Holocene\nDiet\nOmnivore\nTemperament\nTerritorial\nWild\nFound primarily among the Island's redwood regions, Arctodus dirus is an imposing creature. Many on the island have started calling it a Direbear, a name which is appropriate, both due to its enormity and its territorial nature. The Direbear ignores most non-hostile creatures while going about its daily routine of scavenging for meat and edible plant life... ...that is, until intruders enter the territory it considers its own, at which point the creature ferociously attacks. Most often, it is smartest to just run from an angry Direbear.\nDomesticated\nOnce tamed, the Direbear is a strong and reliable mount. It can carry vast quantities of goods, and can sprint for extremely long, nearly infinite periods. It is not the fastest creature from a hard stop, but after building up momentum, its sustained overland speed builds to among the best of the island. Of course, being able to feed a direbear both meat and plant life makes keeping one fairly convenient regardless of the environment. Arctodus has a fondness for honey and can harvest it without getting stung or destroying the hive. Perhaps more rewarding while you are riding it, those pesky bees will completely ignore you.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Dodo', name_tag='Dodo', category='Birds',
                        entity_id='Dodo_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fc/Dodo.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Dodo',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dodo/Dodo_Character_BP_Aberrant.Dodo_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Dossier_Dodo.png',
                        description='“\nSpecies\nRaphus replicare\nTime\nLate Holocene\nDiet\nHerbivore\nTemperament\nOblivious\nWild\nRaphus replicare (more commonly known as the Dodo Bird) is quite possibly the dumbest creature I\'ve ever seen in my life. It wanders around the beaches of the Island, pecking berries off bushes, and being eaten by all manner of carnivore. Without the Dodo, the whole Island\'s food chain would disintegrate. This subspecies of the Dodo has developed an unbelievably clever way to sustain itself: they mate constantly. I\'m fairly convinced that they reach full maturity within a week of being born. This is the only trait keeping them populous on the island.\nDomesticated\nWhile it can be done, there is almost no reason to domesticate a Raphus replicare. It cannot carry enough to be a beast of burden, it does not provide much food, and it\'s too stupid to show companionship. It could work as a last-ditch food source, though, so I suppose keeping some around for "lean times" has a certain logic.\n„\n~ Helena')
    models.Creature.new(name='Aberrant Doedicurus', name_tag='Doed', category='Dinosaurs',
                        entity_id='Doed_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8b/Doedicurus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Doedicurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Doedicurus/Doed_Character_BP_Aberrant.Doed_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d1/Dossier_Doedicurus.png',
                        description='“\nSpecies\nDoedicurus custosaxum\nTime\nPlestiocene – Holocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nDoedicurus custosaxum is one of the Island\'s non-aggressive herbivores, generally found in the mountains and grasslands. Large and well-armored, it has a supply of fat under its plates to keep it warm and fed in the cold. Doedicurus has adapted well to the dangers of the Island, perhaps even better than the Ankylosaurus. Doedicurus has two very different reactions to predators. Against smaller foes, it generally uses its spiked tail to inflict as much damage as possible. Against larger predators, however, it pulls its tail underneath itself to form a solid armored ball that is nearly impossible for creatures to pierce, from which it can actually "roll" away to relative safety!\nDomesticated\nDoedicurus is a highly prized work animal on the island. Its spiked tail is ideal for quickly shattering the large rocks, so Doedicurus is a very efficient quarry worker. In addition, its affinity for rocks has allowed it to carry stone at a reduced weight. In case their quarry gets raided, Doedicurus-riders have a very difficult-to-kill mount!\n„\n~ Helena')
    models.Creature.new(name='Aberrant Dung Beetle', name_tag='Beetle', category='Invertebrates',
                        entity_id='DungBeetle_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b4/Dung_Beetle.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Dung_Beetle',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/DungBeetle/DungBeetle_Character_BP_Aberrant.DungBeetle_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Dossier_Dung_Beetle.png',
                        description="“\nSpecies\nScarabidae gigas\nTime\nHolocene\nDiet\nCoprophagic\nTemperament\nPassive\nWild\nWhat magic created the Scarabidae gigas, I cannot say. What I can say is that this creature is a perfect symbiont for advanced human tribes. Coprophagic, it eats mostly useless waste (feces). It metabolizes this waste into a more refined waste product, along with an oily byproduct. The oily byproduct is chemically the same as the oil found in the oceans around the island. Somehow, Scarabidae converts feces into oil. If that wasn't reason enough to worship the Scarabidae, the refined waste product is almost identical to fertilizer from a compost bin.\nDomesticated\nScarabidae makes me think humans have been on the island for a long time. Why else would a creature evolve to be such a perfect pet? Most tribes jealously protect their Scarabidae, whom are handily tamed with the skilled use of some well-handled feces. These wondrous little organic biofactories are truly a sustainable, green, eco-friendly source of resources for living off the land. Oil becomes gas, which is generator fuel. Fertilizer means crops, which is human fuel. The Scarabidae can power all aspects of island life!\n„\n~ Helena")
    models.Creature.new(name='Aberrant Electrophorus', name_tag='Eel', category='Fish',
                        entity_id='Eel_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a0/Electrophorus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Electrophorus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Eel/Eel_Character_BP_Aberrant.Eel_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Dossier_Electrophorus.png',
                        description='“\nSpecies\nElectrophorus beluadomito\nTime\nHolocene\nDiet\nCarnivore\nTemperament\nReactive\nWild\nOccupying a space in the low-to-middle end of the food chain, Electrophorus beluadomito is a carnivorous swimmer that feeds mostly off of shellfish and small fish. Despite its common name, it is actually a very long Knifefish, and not an Eel. It does not provide much meat, so many predators simply leave it be. Unlike most predators, it does not use brute strength to bring down its prey, but instead releases an electrical charge around itself to knock its prey unconscious. Alone, this can take out a small creature. When attacking together, Electrophorus can even bring down the larger ocean lifeforms, and then feed as a group.\nDomesticated\nBy far, the most common use of Electrophorus is to subdue large ocean creatures. Knocking out a Plesiosaur or other giant deep-sea leviathan can be incredibly difficult... ...thus many tribes employ small schools of Electrophorus to shock them into submission!\n„\n~ Helena')
    models.Creature.new(name='Aberrant Equus', name_tag='Equus', category='Mammals',
                        entity_id='Equus_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Equus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Equus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Equus/Equus_Character_BP_Aberrant.Equus_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Dossier_Equus.png',
                        description="“\nSpecies\nEquus magnus\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nLoyal\nWild\nEquus magnus appears to be an ancestor of the modern horse. Based on its stripes, it may be the African variant of Equus giganteus, which appeared in North America during the Ice Age, but that is pure conjecture. Its behavior in the wild is similar to that of other wild members of the Equus genus - it sustains itself by grazing, while keeping safe from predators by living in herds and outrunning its attackers via superior speed and stamina.\nDomesticated\nHorse and man have long been partners in survival, and this remains true on the Island. In Equus, survivors will find a trusty steed or pack animal that can carry them swiftly across land. Taming an Equus has proven interesting, requiring carefully approaching the creature in the wild, mounting it, and then carefully soothing over time by feeding it vegetables. In fact, Equus' reliability has lead some survivors to construct special saddles for them. I even encountered a man who added extra saddle-pouches that doubled as mobile crafting stations for chemical supplies, foodstuffs, and other items. Although not as robust as what you might find within a village, this utility helped him live a nomadic, solitary lifestyle. Some survivors employ Equus to herd and wrangle other creatures with a specialized lasso. This tool is sometimes effective for self-defense as well, as Equus is limited in battle on its own...at least compared to aggressive prehistoric carnivores.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Gigantopithecus', name_tag='Bigfoot', category='Mammals',
                        entity_id='Bigfoot_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Gigantopithecus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Gigantopithecus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Bigfoot/Bigfoot_Character_BP_Aberrant.Bigfoot_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Dossier_Gigantopithecus.png',
                        description="“\nSpecies\nGigantopithecus fibrarator\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nTerritorial\nWild\nGigantopithecus fibrarator is a strange creature. It is usually quite passive, but it has a very short temper when it comes to its own personal space. Once another creature gets close, this gentle giant quickly becomes a rampaging beast. Best to give them a wide berth. I have occasionally seen Gigantopithecus jumping to grab vines that it can traverse and swing on, but otherwise, it seems most happy to lay about, picking berries from plants lazily.\nDomesticated\nIn addition to being at home picking berries, a tamed Gigantopithecus can be taught to harvest the fibers found on many Island plants as well. It appears to be entirely content to pick at plants all day, eat the berries, and carrying fiber resources for its tribe. Playful once tamed, Gigantopithecus seems to enjoy throwing the creatures or riders it's carrying into the air. It probably feels that this activity is a game, but clever brigands can use this ‘game' to vault over walls and small cliffs.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Iguanodon', name_tag='Iguanodon', category='Dinosaurs',
                        entity_id='Iguanodon_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/94/Iguanodon.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Iguanodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Iguanodon/Iguanodon_Character_BP_Aberrant.Iguanodon_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/54/Dossier_Iguanodon.png',
                        description="“\nSpecies\nIguanodon vicissitudinis\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nReactive\nWild\nOf the many creatures I've yet encountered on the Island, the Iguanodon vicissitudinis has the distinctly versatile capability of switching its primary method of locomotion according to its momentary needs. Primarily a rather lethargic bipedal herbivore native to the Island's many grasslands and forests, in situations where increased speed or maneuverability is called for, it will quickly shift its posture into quadrupedal stance and behave like a very different creature! While bipedal, it can employ rapid, stabbing attacks with its distinctive thumb spikes. In quadrupedal stance, conversely, it seems to have an endless supply of stamina, even while sprinting!\nDomesticated\nInterestingly, the Iguanodon's thumb spikes also provide it with the capability to pick seeds out of fruits, allowing a farmer to easily convert stacks of fruits into stacks of seed for planting. Combined with its highly effective fruit harvesting and substantial carry weight, the Iguanodon's excellent mobility in bipedal stance makes it an ideal field-hand that can also pull off a quick get-away or an agile defense when needed.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Lystrosaurus', name_tag='Lystro', category='Dinosaurs',
                        entity_id='Lystro_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/93/Lystrosaurus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Lystrosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Lystrosaurus/Lystro_Character_BP_Aberrant.Lystro_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d1/Dossier_Lystrosaurus.png',
                        description="“\nSpecies\nLystrosaurus amicifidelis\nTime\nLate Permian - Early Triassic\nDiet\nHerbivore\nTemperament\nLoyal\nWild\nLystrosaurus amicifidelis is a small herbivore, common to much of the Island. Only about two feet long, it is not high on the food chain, and eats small plant life. The Island's poisonous insects seem to have little effect on Lystrosaurus. Despite being among the Island's tinier herbivores, Lystrosaurus is an incredibly resilient survivor. It recovers its torpor and health much faster than most creatures, which makes rendering a Lystrosaurus unconscious a rather difficult affair.\nDomesticated\nNot surprisingly, Lystrosaurus is an extremely loyal pet once tamed. It's a very fast learner, so it gains experience much more quickly than most other creatures. Additionally, its presence nearby appears to inspire allies, making them learn more rapidly as well. Thusly, Lystrosaurus is an excellent addition to any tribe's hunting party.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Manta', name_tag='Manta', category='Fish',
                        entity_id='Manta_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Manta.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Manta',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Manta/Manta_Character_BP_Aberrant.Manta_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Manta.png',
                        description="“\nSpecies\nManta mobula\nTime\nEarly Oligocene - Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nHere is another example of a creature that seems to have evolved beyond its historical traits. Everything points to this being a saltwater ray, but Manta mobula has developed the ability to swim into the island's rivers and shallows, as well as through the open ocean. Perhaps there were originally two types of ray on the island before, but years of interbreeding combined their lineage. Normally docile, Manta mobula is a carnivore only in that it naturally consumes plankton. Fortunately, Manta mobula is usually not aggressive, unless encroached. Its tail is incredibly sharp, and can pierce through thick hide and armor with ease.\nDomesticated\nWhile not the fastest swimmer around the island, Manta mobula is among the deadliest of small ocean mounts. Tribes who value striking power over speed often keep large schools of Manta to ride. Its capability to briefly leap out of water provides it a showy tactic for avoiding combat as well. A quick jab through the heart of an unsuspecting survivor can easily take them by surprise! Thusly, many tribes use it as an escort for their slower cargo-carrying swimmers.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Megalania', name_tag='Megalania', category='Reptiles',
                        entity_id='Megalania_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/58/Megalania.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Megalania',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Megalania/Megalania_Character_BP_Aberrant.Megalania_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c6/Dossier_Megalania.png',
                        description="“\nSpecies\nMegalania muruspede\nTime\nLate Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMegalania muruspede is among the largest creatures found throughout the Island's complicated cave networks. Reaching up to three meters long, it can traverse vertically up cave walls with little difficulty thanks to its powerful claws. Fortunately, Megalania's size means it is unlikely to sneak up on anyone. Unfortunately for spelunkers, it is an aggressive and dangerous creature nonetheless. Like other Varanidae, Megalania is a venomous creature. Its poison is slow-acting, but will drain the victim's effective strength and health until death unless cured by a rare antidote. That said, the Megalania's prey are usually ripped apart well before they succumb to the poison's long-term effects.\nDomesticated\nThe rare ability of Megalania to effortlessly climb sheer environmental walls makes it a highly sought-after mount. While it is by no means the fastest, strongest, or toughest mount, the manner in which it can effortlessly scale mountains, clamber up barricades, hide in trees or upside-down, ensures it will always have place in any tribe's stables!\n„\n~ Helena")
    models.Creature.new(name='Aberrant Megalosaurus', name_tag='Megalosaurus', category='Dinosaurs',
                        entity_id='Megalosaurus_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7e/Megalosaurus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Megalosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Megalosaurus/Megalosaurus_Character_BP_Aberrant.Megalosaurus_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/19/Dossier_Megalosaurus.png',
                        description="“\nSpecies\nMegalosaurus noctedominus\nTime\nMid Jurassic\nDiet\nCarnivore\nTemperament\nNocturnally Aggressive\nWild\nMuch like the Island's other large theropods, Megalosaurus noctedominus is an aggressive cave carnivore that should not be taken lightly. Unlike most of the other theropods, it is a primarily nocturnal creature. As dawn approaches, Megalosaurus begins looking for a secluded place to spend the day sleeping in relative safety. Conversely, if disturbed during the day, Megalosaurus is significantly more sluggish. Either way, however, its primary combat tactic is to bite onto its target, then lock its jaw shut in an iron grip. Only larger creatures can hope to break free once Megalosaurus locks its jaw. The creature then proceeds to gnaw on its prey until death. It's a terrifying, grisly spectacle to watch, and a formidable tactic for a tribe to employ against more nimble opponents.\nDomesticated\nWhile Megalosaurus is not the most powerful theropod, it is still highly sought after by night-raiders. Due to its nocturnal nature, Megalosaurus becomes much more formidable at night, dodging attacks, conserving stamina, and attacking more accurately, to name a few of its enhanced talents.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Meganeura', name_tag='Dragonfly', category='Invertebrates',
                        entity_id='Dragonfly_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/81/Meganeura.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Meganeura',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dragonfly/Dragonfly_Character_BP_Aberrant.Dragonfly_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c5/Dossier_Meganeura.png',
                        description="“\nSpecies\nMeganeura quatpenna\nTime\nLate Carboniferous\nDiet\nCarnivore\nTemperament\nReactive\nWild\nMeganeura quatpenna is an especially large species of dragonfly. Actually, it is a type of griffinfly, an extinct species of invertebrate that looked similar to dragonflies. Like most griffinflies, Meganeura is carnivorous, but it is typically not aggressive towards humans unless provoked or challenged for food. It lives primarily in the wetter, heavily wooded areas, such as the jungles. Meganeura is a natural predator of most of the smaller insects on the island. Though not often aggressive, Meganeura will not turn down a free meal. They quickly appear in large numbers to scavenge off the victims of Pulmonoscorpius, rendered unconscious and unable to defend themselves. Of course the insects do have to avoid the Pulmonoscorpius itself. I have noticed it is unwise to disturb a flock of feeding Meganeura.\nDomesticated\nThe size of the insects on the island confounds me. The way these creatures diffuse oxygen should limit their size but Meganeura (and other bugs) seem to be able to advance beyond this restraint. If there is more oxygen in the air this could explain Meganeura's growth.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Moschops', name_tag='Moschops', category='Synapsids',
                        entity_id='Moschops_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e6/Moschops.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Moschops',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Moschops/Moschops_Character_BP_Aberrant.Moschops_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dc/Dossier_Moschops.png',
                        description="“\nSpecies\nMoschops cibumutante\nTime\nMid Permian\nDiet\nOmnivore\nTemperament\nCowardly\nWild\nMoschops Cibumutante in the wild is a lazy, cowardly creature that typically lives in the Island's forests, primarily making its home among the great redwoods of the western regions. It survives by being extremely flexible in its eating habits and completely averse to fighting. It never starves, since it can eat just about anything. It runs at the slightest provocation but is still often preyed upon.\nDomesticated\nWhat makes Moschops particularly interesting is what it can be trained to do with its eating habits. With a versatile palate and tough teeth, Moschops can be tamed for a unique ability: over time it can be accurately taught exactly which things to gnaw, increasing the likelihood of harvesting the specific resource its master desires. For example, teach it to prioritize chewing Prime Meat, and Prime Meat will be easier to harvest from the flesh it consumes. Likewise for rare plants materials, and so forth! Just don't expect Moschops to protect you, though! Even after taming, it will quickly flee when enemies are nearby. Regardless of being fed well, increasing its strength, or how much affection, you shower on it, Moschops retains its inherent cowardly nature! Its lack of combat might deter the use of this companion but the ability to ride Moschops while making use of its diverse harvesting is a rare treat.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Otter', name_tag='Otter', category='Mammals',
                        entity_id='Otter_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9f/Otter.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Otter',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Otter/Otter_Character_BP_Aberrant.Otter_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Dossier_Otter.png',
                        description='“\nSpecies\nLutra peloso\nTime\nEarly Miocene\nDiet\nOmnivore\nTemperament\nFriendly\nWild\nFound along the Island’s many inland waterways, Lutra Peloso have become exceptionally adept at hunting and foraging. This species of Otter has to be particularly cunning because of its diminutive size, and fierce competition for its preferred food source: fish. It is not a creature that excels at combat, and would not naturally pose an intimidating threat to any predators. Finding packs of river Otters is simple enough: They are distinguished by their elongated bodies, bushy tails, and webbed feet. Their trusting and inquisitive nature ensures they are often hunted for their lustrous fur, but many prefer to tame them to become trusted companions.\nDomesticated\nThere are few creatures which provide the companionship that Lutra Peloso does. Rather than traveling beside you, it would prefer to comfortably rest on your back, providing insulation. Once domesticated, it can be told to harvest fish on demand, with a specific goal in mind from the fish that it consumes, the otter has a knack for foraging silica pearls, and can even yield a slight chance at finding black pearls within!\n„\n~ Helena')
    models.Creature.new(name='Aberrant Ovis', name_tag='Sheep', category='Mammals',
                        entity_id='Sheep_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Ovis.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Ovis',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Sheep/Sheep_Character_BP_Aberrant.Sheep_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b7/Dossier_Ovis.png',
                        description='“\nSpecies\nOvis arcam\nTime\nCenozoic\nDiet\nHerbivore\nTemperament\nStupid\nWild\nSince arriving on the Island, I have encountered dozens of fascinating creatures whose behavior has never been studied or documented...and also sheep. Granted, Ovis arcam is quite different from the modern domesticated sheep - and even from wild sheep species such as Ovis orientalis. The unique markings on its face give it a striking appearance, and the males\' horns possess a unique shape that is unlike any other species in the Ovis genus. As one might expect, Ovis stands little chance against this Island\'s many predators. Like the Dodo, its continued survival in the face of these challenges is a mystery.\nDomesticated\nSome survivors have found herds of Ovis to be useful in farm life. Their wool can be repeatedly safely shorn with the proper tools, and cooked lamb chops are a popular dish among some tribes, as is their hyper-nutritious mutton. Every now and then, a survivor with a sense of humor will attempt to utilize Ovis as a mount, although the joke becomes significantly less funny once their slow Ovis is run-down by a pack of Raptors. One tribe has grown particularly attached to Ovis, perhaps uncomfortably so. I don\'t know the tribe\'s actual name, but I refer to them as "Sheep Lovers."\n„\n~ Helena')
    models.Creature.new(name='Aberrant Paraceratherium', name_tag='Paracer', category='Mammals',
                        entity_id='Paracer_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e1/Paraceratherium.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Paraceratherium',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Paraceratherium/Paracer_Character_BP_Aberrant.Paracer_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Paraceratherium.png',
                        description='“\nSpecies\nParaceratherium gigamicus\nTime\nOligocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nParaceratherium gigamicus is a massive, long-necked herbivore that inhabits some of the Island\'s grasslands. It resembles a gigantic horse/rhinoceros hybrid, but is over twice the size of either. Paraceratherium is a very peaceful and friendly creature. Barring some surprises yet in store for me, I can safely say that Paraceratherium is among the largest mammals on the Island. While its size means that Paraceratherium can provide an incredible amount of food, it also makes it dangerous when hunted.\nDomesticated\nA beast of burden second to the Brontosaurus, Paraceratherium is an excellent worker, and is sufficient in size to support a "platform" saddle upon which structures can be built. It is a naturally friendly animal, and is not afraid of humans. However, despite its normally calm demeanor, when it or its owner is provoked by aggression, the Paraceratherium can quickly become a real threat to the attacker and will use its girth to its advantage in combat.\n„\n~ Helena')
    models.Creature.new(name='Aberrant Parasaur', name_tag='Para', category='Dinosaurs',
                        entity_id='Para_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Parasaur.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Parasaur',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Para/Para_Character_BP_Aberrant.Para_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Dossier_Parasaur.png',
                        description="“\nSpecies\nParasaurolophus amphibio\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nParasaurolophus amphibio has one of the more interesting adaptations of any creature I've seen on the Island. Like all Parasaur, it has a signature crest on its head. Very docile at first, I've been able to approach the creature without disturbing it. If startled, however, the creature can vocalize a distress call to the surrounding area that warns of danger. Parasaurolophus appears to be low on the food chain and is hunted by everything, creatures and humans alike, which explains its skittish nature. It is a good source of meat and hide, if you can manage to keep up with it long enough to kill it.\nDomesticated\nDespite being what most tribes consider a relatively useless creature to tame, I once met an interesting woman who had tamed an entire herd of them. She informed me that many overlooked the creature's potential. She even graciously gifted me a fancy saddle to put on my own Parasaurolophus one day. As a relatively simple creature to domesticate, Parasaurolophus is commonly one of the first mounts a tribe will be able to acquire. Its ability to run relatively fast for lengthy intervals makes it a solid mode of medium-range transportation, though it has almost no ability to defend itself or its rider in a traditional sense. Smaller creatures, however, appear to be frightened by the horn of Parasaurolophus although it doesn't do much damage. It also has decent weight-bearing capabilities, which could prove useful for nomadic tribes as they work to establish a presence on the Island.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Piranha', name_tag='Piranha', category='Fish',
                        entity_id='Piranha_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/43/Piranha.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Piranha',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Piranha/Piranha_Character_BP_Aberrant.Piranha_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b2/Dossier_Piranha.png',
                        description="“\nSpecies\nMegapiranha magnadmorsus\nTime\nLate Miocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMegapiranha magnadmorsus is carnivorous fish found fairly commonly in the rivers and ponds of the island. Its bite is incredibly powerful; I've even seen them break through the armored turtles of the island. Megapiranha has one of the strongest bites, pound-for-pound, of any creature on the island. When encountering a Megapiranha, be on the lookout for the rest of the school. No one Megapiranha is an overwhelming threat, but their tendency to swarm prey can make short work of much larger and stronger creatures. Any given Megapiranha is easy to kill, but killing the entire school can be a daunting task.\nDomesticated\nThe Megapiranha is highly territorial and does not respond favorably to visitors. Many have tried to pacify the hostile Megapiranha by herding them into a group with various lures. Unfortunately, none of this proved to be successful in attempting to domesticate the creature.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Pulmonoscorpius', name_tag='Scorpion', category='Invertebrates',
                        entity_id='Scorpion_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ab/Scorpion.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Pulmonoscorpius',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Scorpion/Scorpion_Character_BP_Aberrant.Scorpion_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Pulmonoscorpius.png',
                        description="“\nSpecies\nPulmonoscorpius gigantus\nTime\nLate Silurian\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nI'm not sure why, but the giant scorpions I've seen on the Island are far more disturbing than most of the dinosaurs. Rather than simply kill its prey, Pulmonoscorpius gigantus injects its victims with a tranquilizing poison, then eats its unconscious prey alive. This subspecies has a large pair of pincers that seem connected to the same toxin sacs as the tail. I've never seen another scorpion that has this adaptation, but I've never seen another scorpion that's larger than I am, either.\nDomesticated\nTrying to tame a monster like Pulmonoscorpius gigantus sounds like a crazy idea, but I suppose the ability to knock out a foe could come in handy. It could certainly make incapacitating some of the Island's other creatures much easier.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Purlovia', name_tag='Purlovia', category='Synapsids',
                        entity_id='Purlovia_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c2/Purlovia.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Purlovia',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Purlovia/Purlovia_Character_BP_Aberrant.Purlovia_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/df/Dossier_Purlovia.png',
                        description='“\nSpecies\nPurlovia maxima\nTime\nLate Permian\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nPurlovia Maxima perfectly embodies the element of surprise. Though Nanictidopids such as Purlovia were once thought to be herbivores, I discovered that this creature is, in fact, a patient hunter of the most intelligent sort. After burrowing beneath the jungle floor, Purlovia enters a state of hibernation and can go extended periods without any food. When some unfortunate creature eventually wanders by, Purlovia bursts forth from the ground, tearing into its prey with its large canines before the victim can react!\nDomesticated\nThough Purlovia is ill-suited to the life of a mount, its usefulness in staging an ambush or as a village guardian cannot be understated. With a tamed pack of Purlovia, one could assemble a literal organic minefield of deadly claws and teeth! However, any ambushes using Purlovia must be planned well in advance, as it will refuse to hibernate if it senses any threat nearby.\n„\n~ Helena')
    models.Creature.new(name='Aberrant Raptor', name_tag='Raptor', category='Dinosaurs',
                        entity_id='Raptor_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/08/Raptor.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Raptor',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Raptor/Raptor_Character_BP_Aberrant.Raptor_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
                        description='“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena')
    models.Creature.new(name='Aberrant Sabertooth Salmon', name_tag='Salmon', category='Fish',
                        entity_id='Salmon_Character_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e0/Salmon.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Sabertooth_Salmon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Salmon/Salmon_Character_Aberrant.Salmon_Character_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0c/Dossier_Sabertooth_Salmon.png',
                        description='“\nSpecies\nOncorhynchus grexlamia\nTime\nLate Miocene - Mid Pleistocene\nDiet\nCarnivore\nTemperament\nEvasive, Aggressive when attacked\nWild\nFairly unremarkable by the Island\'s standards, Oncorhynchus grexlamia is a generally passive fish. Its main form of protection is swimming in a large school. Oncorhynchus does not like conflict, and generally swims away from anything larger than itself at very high speeds. Once provoked, however, Oncorhynchus becomes quite aggressive, along with its nearby brethren. It locks onto its prey with its long "saberteeth" and begins draining that creature\'s blood. This loss of blood is not too dangerous alone, but when a school of Oncorhynchus attack at once, their target quickly loses speed and stamina from blood loss, drowning if it cannot breath underwater.\nDomesticated\nLike many of the smaller fish found on or around the Island, Oncorhynchus cannot be tamed, but it is often herded and harvested for its resources. In particular, certain cuts of Oncorhynchus meat are considered to have superb quality, and are often referred to as "Prime Fish" used for specific high-end concoctions and taming the Island\'s many piscivorous creatures.\n„\n~ Helena')
    models.Creature.new(name='Aberrant Sarco', name_tag='Sarco', category='Reptiles',
                        entity_id='Sarco_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Sarco.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Sarco',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Sarco/Sarco_Character_BP_Aberrant.Sarco_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/70/Dossier_Sarco.png',
                        description="“\nSpecies\nSarcosuchus excubitor\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nPatient\nWild\nAmong the Island's swamp-based threats, Sarcosuchus excubitor is a lot like what you might expect from a giant crocodile: a patient killing machine. It spends much of its days lazily waiting in the water for prey to walk near. That said, it is not opposed to scurrying onto land and pressing the issue when hungry. A good tactic for escaping many predators is to jump into the water, as most are slow swimmers. This is a bad tactic for escaping a Sarcosuchus, obviously, as they are actually faster in the water than they are on land. Whether in land or water, it utilizes a well-rounded arsenal of attacks to display its prowess as a hunter. If it desires to grab a predator and spin into a death roll, quickly lunge forward for a surprise attack, target a foe directly behind it, its able to do so with extreme ease.\nDomesticated\nSarcosuchus is a ferocious creature that even causes the fearless piranha to flee at the sight of it. Despite being river-dwelling creatures, Sarcosuchus seem quite at ease in the oceans. More than a few fishing communities use them as mounts simply to help fight off megaladons, or to gain better access to the resources found within the reefs.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Spino', name_tag='Spino', category='Dinosaurs',
                        entity_id='Spino_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/03/Spino.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Spino',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Spino/Spino_Character_BP_Aberrant.Spino_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Spino.png',
                        description="“\nSpecies\nSpinosaurus aquareliga\nTime\nEarly-Late Cretaceous\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nAmong the few carnivores on the Island that can match Tyrannosaurs in size, Spinosaurus aquareliga does not match its ferocity. Spinosaurus' four legs and large sail make it fairly swift on land and incredibly fast in the water. Its marvel is, arguably, the ability to change stances by going from quadruped to biped. The creature is visually distinguished by its spectacular sail. In my travels I have seen many different and brightly coloured sails, as every Spinosaurus appears to have a slightly different palette. The one comforting fact about Spinosaurus is that it seems more at home near water than away from it. Although the creature is more powerful, faster, agile, and insatiable while in water, it tends to become less hostile as it gets farther from it. On one occasion, I only escaped a Spinosaurus by getting far enough from its lake home to make it simply lose interest.\nDomesticated\nSpinosaurus is an incredibly well-rounded apex carnivore. Faster than a Tyrannosaurus in water and able to travel on land unlike a Megalodon, its all-terrain versatility may be unrivaled. Although its movement speed is slower in a biped stance, it gains considerable attacking strength and mobility in this form. For hunters who wish to have a well-rounded mount, Spinosaurus may be the ideal choice -- if they can acquire one.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Stegosaurus', name_tag='Stego', category='Dinosaurs',
                        entity_id='Stego_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Stegosaurus.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Stegosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Stego/Stego_Character_BP_Aberrant.Stego_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Dossier_Stegosaurus.png',
                        description="“\nSpecies\nStegosaurus regium\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nDocile\nWild\nStegosaurus regium has approximately 16 paired rows of plates along its back, flanked by another, smaller pair of 6 plates. This is contrary to the alternating rows on Stegosaurus fossils I've seen in museums. Not surprisingly, Stegosaurus uses the spines on its tail to defend itself. While not aggressive, Stegosaurus will come to the aid of another nearby Stegosaurus. This implies it to be a herd animal.\nDomesticated\nStegosaurus is commonly used as a safe way to transport large quantities of goods. And once you saddle one up, not even an Argentavis could knock you off that perch. A stegosaurus can be trained to flex its back plates for different purposes: hardened to shield it from attack, in a heavier alignment that deals crippling blows, or oriented more sharply to pierce armor. These various plate configurations also come in handy for stripping wood from trees, gathering thatch, or foraging for wild berries, respectively. Stegosaurus can knock back or impale with a whip of its spiky tail, keeping predators at bay or pinning them in place. Its spiked appendage also helps for gathering berries—go figure.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Titanoboa', name_tag='Titanboa', category='Reptiles',
                        entity_id='BoaFrill_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b6/Titanoboa.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Titanoboa',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/BoaFrill/BoaFrill_Character_BP_Aberrant.BoaFrill_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/47/Dossier_Titanoboa.png',
                        description="“\nSpecies\nTitanoboa exornantur\nTime\nPaleocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nTypically found within the Island's caves, Titanoboa exornantur is an aggressive creature that prefers dark, rocky areas. This extremely large snake, while being a member of the Titanoboa family, does not constrict its prey as most boas do. I believe this adaptation comes from coexisting with giant insects. However, the Titanoboa's venomous bite is so potent that it is known to paralyze far larger creatures. Titanoboa has developed a strange coexistence with other creatures of the Island's caves. Being immune to knockout poisons, and being unable to pierce the thick chitin of the insects, the species have learned to coexist. They often hunt large prey together.\nDomesticated\nAs they appear immune to knockout poisons, Titanoboa exornantur is basically impossible to render unconscious. Because this crucial step can't be done, I'm convinced that Titanoboa are not tameable.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Triceratops', name_tag='Trike', category='Dinosaurs',
                        entity_id='Trike_Character_BP_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Triceratops',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Trike/Trike_Character_BP_Aberrant.Trike_Character_BP_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Triceratops.png',
                        description="“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena")
    models.Creature.new(name='Aberrant Trilobite', name_tag='Trilobite', category='Invertebrates',
                        entity_id='Trilobite_Character_Aberrant_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2b/Trilobite.png',
                        url='https://ark.fandom.com/wiki/Aberrant_Trilobite',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Trilobite/Trilobite_Character_Aberrant.Trilobite_Character_Aberrant\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Dossier_Trilobite.png',
                        description="“\nSpecies\nTrilobite conchadurus\nTime\nEarly Cambrian-Late Permian\nDiet\nCarnivore\nTemperament\nDefensive\nWild\nLike most Trilobites, Trilobite conchadurus is an opportunistic carnivore that feeds on anything smaller than itself which it can get a hold of. A sluggish creature, the Trilobite's best defense is its incredibly hard shell. This seems to be a common adaptation for the slower creatures of the Island. Trilobite is not a very good source of food. The creature seems to be made mostly out of internal organs and its protective carapace. This is good for the trilobite, as both river and ocean predators are less likely to prey on it if there are better options around.\nDomesticated\nThe Trilobite does not seem to have enough intelligence to be tamed. This doesn't mean it has no use among resourceful survivors, however. Found along beaches and in the ocean's shallows, Trilobites are easily one of the best sources of oil, pearl and chitin on the Island, presuming one doesn't wish to venture into the dangerous caves.\n„\n~ Helena")
    models.Creature.new(name='Alpha Basilisk', name_tag='Elite Basilisk', category='Alpha Creatures',
                        entity_id='MegaBasilisk_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Basilisk.png',
                        url='https://ark.fandom.com/wiki/Alpha_Basilisk',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Basilisk/MegaBasilisk_Character_BP.MegaBasilisk_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Dossier_Basilisk.png',
                        description="“\nSpecies\nSerpens regulus\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMore than twice the size of wild Titanoboa exonantur, Serpens regulus is the largest and most lethal snake I've encountered. With a skull that's more draconic than serpentine, it possesses a powerful bite, made even deadlier by the potent venom dripping from its fangs. The unique shape of its skull allows Serpens to hunt in a way that other snakes cannot: by burrowing. Once underground, it simply waits for its victims to approach. Fortunately its forked tail is usually still visible, poking just aboveground.\nDomesticated\nMiraculously, survivors have not only managed to tame Serpens regulus, but ride it. Some can even stay seated while it lies in wait belowground, though I doubt it's a pleasant experience. While a wild Serpens can only be forced out of hiding by fire or explosives, once domesticated, it is easily trained to burrow or surface on command.\n„\n~ Helena")
    models.Creature.new(name='Alpha Karkinos', name_tag='Elite CaveCrab', category='Alpha Creatures',
                        entity_id='MegaCrab_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/40/Karkinos.png',
                        url='https://ark.fandom.com/wiki/Alpha_Karkinos',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Crab/MegaCrab_Character_BP.MegaCrab_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/25/Dossier_Karkinos.png',
                        description='“\nSpecies\nKarkinos versatus\nTime\nUnknown\nDiet\nOmnivore\nTemperament\nAggressive\nWild\nKarkinos Versatus is the giant cousin of modern crab species, with long, spindly limbs that remind me of the Japanese Spider Crab and a hard, stony shell. It is much more agile than its smaller brethren, but even more noticeable are its pincer claws. In an extraordinary display of dexterity, Karkinos is able to wield each claw independently and precisely. This allows it to trap multiple targets in its vice like grip, or hold an enemy in one claw while it smashes a second foe with the other.\nDomesticated\nMany survivors have found Karkinos to be an excellent war steed, as it can snatch enemy riders from their mounts, or grab and throw smaller creatures. However, its ability to leap to great heights and its swiftness relative to its size also make it useful in caravans.\n„\n~ Helena')
    models.Creature.new(name='Alpha Surface Reaper King', name_tag='Elite Xenomorph', category='Alpha Creatures',
                        entity_id='MegaXenomorph_Character_BP_Male_Surface_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
                        url='https://ark.fandom.com/wiki/Alpha_Surface_Reaper_King',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Nameless/MegaXenomorph_Character_BP_Male_Surface.MegaXenomorph_Character_BP_Male_Surface\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description="“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena")
    models.Creature.new(name='Basilisk', name_tag='Basilisk', category='Fantasy Creatures',
                        entity_id='Basilisk_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Basilisk.png',
                        url='https://ark.fandom.com/wiki/Basilisk',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Basilisk/Basilisk_Character_BP.Basilisk_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Dossier_Basilisk.png',
                        description="“\nSpecies\nSerpens regulus\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMore than twice the size of wild Titanoboa exonantur, Serpens regulus is the largest and most lethal snake I've encountered. With a skull that's more draconic than serpentine, it possesses a powerful bite, made even deadlier by the potent venom dripping from its fangs. The unique shape of its skull allows Serpens to hunt in a way that other snakes cannot: by burrowing. Once underground, it simply waits for its victims to approach. Fortunately its forked tail is usually still visible, poking just aboveground.\nDomesticated\nMiraculously, survivors have not only managed to tame Serpens regulus, but ride it. Some can even stay seated while it lies in wait belowground, though I doubt it's a pleasant experience. While a wild Serpens can only be forced out of hiding by fire or explosives, once domesticated, it is easily trained to burrow or surface on command.\n„\n~ Helena")
    models.Creature.new(name='Basilisk Ghost', name_tag='Basilisk', category='Event Creatures',
                        entity_id='Ghost_Basilisk_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1c/Basilisk_Ghost.png',
                        url='https://ark.fandom.com/wiki/Basilisk_Ghost',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Basilisk/Ghost_Basilisk_Character_BP.Ghost_Basilisk_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7f/Basilisk_Ghost_Image.jpg',
                        description=None)
    models.Creature.new(name='Bulbdog', name_tag='Pug', category='Fantasy Creatures',
                        entity_id='LanternPug_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1c/Bulbdog.png',
                        url='https://ark.fandom.com/wiki/Bulbdog',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/LanternPug/LanternPug_Character_BP.LanternPug_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Dossier_Bulbdog.png',
                        description="“\nSpecies\nMicroluminis globulus\nTime\nUnknown\nDiet\nHerbivore\nTemperament\nPassive\nWild\nMicroluminis globulus is best described as a slobbering, roly-poly ball of affection. Just like its kin, it is completely harmless, despite its pronounced fangs. So if a survivor sees one running towards them, they should prepare to be licked, not bitten. Unfortunately, being so ugly that you're cute is not an effective means of self-defense, which lands it near the bottom of the food chain. Its Charge Light may intimidate some predators, but it attracts just as many.\nDomesticated\nWhile Microluminis globulus has skin reminiscent of lizards or amphibians, its behavior is incredibly similar to a common canine. This has made it a particularly popular choice as a companion and source of Charge Light, but remember - whatever shoulder you rest it on will be covered in drool within minutes.\n„\n~ Helena")
    models.Creature.new(name='Bulbdog Ghost', name_tag='Pug', category='Event Creatures',
                        entity_id='Ghost_LanternPug_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Bulbdog_Ghost.png',
                        url='https://ark.fandom.com/wiki/Bulbdog_Ghost',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/LanternPug/Ghost_LanternPug_Character_BP.Ghost_LanternPug_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Bulbdog_Ghost_Image.jpg',
                        description=None)
    models.Creature.new(name='Featherlight', name_tag='Lantern Bird', category='Fantasy Creatures',
                        entity_id='LanternBird_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c9/Featherlight.png',
                        url='https://ark.fandom.com/wiki/Featherlight',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/LanternBird/LanternBird_Character_BP.LanternBird_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Dossier_Featherlight.png',
                        description="“\nSpecies\nMicroluminis alectryon\nTime\nUnknown\nDiet\nHerbivore\nTemperament\nPassive\nWild\nA floating beacon of light often found in the deepest pits of these caverns, Microluminis alectryon's appearance can seem almost heavenly. Its colorful plumage doesn't hurt either. Even without the charged light it emits, it would give any modern bird on Earth a run for its money in terms of pure spectacle. Although its feathery eyebrows might give one of the impression that it is related to owls, it is not a bird of prey. It is entirely docile, and shows no aggression towards survivors or other creatures.\nDomesticated\nMicroluminis alectryon's ability to fly and the ease with which it perches upon a survivor's shoulder has made it a favored pet among many. Some consider it the most refined of its glowing brethren, but I think they just want to look like a pirate. Not that I blame them...\n„\n~ Helena")
    models.Creature.new(name='Glowbug', name_tag='Lightbug', category='Fantasy Creatures',
                        entity_id='Lightbug_Character_BaseBP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b3/Glowbug.png',
                        url='https://ark.fandom.com/wiki/Glowbug',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Lightbug/Lightbug_Character_BaseBP.Lightbug_Character_BaseBP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Dossier_Glowbug.png',
                        description='“\nSpecies\nLampyridae sublimis\nTime\nMiocene\nDiet\nUnknown\nTemperament\nPassive\nWild\nThe Light Bug is believed to be a descendant of the Lampyridae insect family. Typically, an insect with its characteristics will flourish in areas with no known natural predators. However, I believe the Light Bug population is moderated by the amount of creatures that vie for its charged light source. Despite being the source of a prized resource, many tribes believe the Light Bug to be sacred and admire it for its illuminance and elegant patterns.\nDomesticated\nDomesticating a Light bug would be a complete waste of time. It is not known to have any useful utility or function. I imagine you could save on fuel by using them to light a settlement.\n„\n~ Helena')
    models.Creature.new(name='Glowtail', name_tag='Lantern Lizard', category='Fantasy Creatures',
                        entity_id='LanternLizard_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c6/Glowtail.png',
                        url='https://ark.fandom.com/wiki/Glowtail',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/LanternLizard/LanternLizard_Character_BP.LanternLizard_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Dossier_Glowtail.png',
                        description="“\nSpecies\nMicroluminis psykhe\nTime\nUnknown\nDiet\nHerbivore\nTemperament\nPassive\nWild\nWith a body reminiscent of a gecko, fluttery wings and a natural stockpile of charge light, Microluminis psykhe has an unearthly, if oddly charming appearance. A curious creature by nature, it always gave me the impression that it was studying me as much as I was studying it. A favorite snack of many predators, this small lizard has no natural poisons, or any means of defending itself at all save for a swift retreat and its charge light. Survivors can approach it without fear.\nDomesticated\nAs a pet, Microluminis psykhe is happy to clamber up a survivor's shoulder and cling to it as though it never wants to leave. Evenly tempered and easy to care for after being tamed, it is a stalwart companion and an excellent source of charge light.\n„\n~ Helena")
    models.Creature.new(name='Karkinos', name_tag='CaveCrab', category='Fantasy Creatures',
                        entity_id='Crab_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/40/Karkinos.png',
                        url='https://ark.fandom.com/wiki/Karkinos',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Crab/Crab_Character_BP.Crab_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/25/Dossier_Karkinos.png',
                        description='“\nSpecies\nKarkinos versatus\nTime\nUnknown\nDiet\nOmnivore\nTemperament\nAggressive\nWild\nKarkinos Versatus is the giant cousin of modern crab species, with long, spindly limbs that remind me of the Japanese Spider Crab and a hard, stony shell. It is much more agile than its smaller brethren, but even more noticeable are its pincer claws. In an extraordinary display of dexterity, Karkinos is able to wield each claw independently and precisely. This allows it to trap multiple targets in its vice like grip, or hold an enemy in one claw while it smashes a second foe with the other.\nDomesticated\nMany survivors have found Karkinos to be an excellent war steed, as it can snatch enemy riders from their mounts, or grab and throw smaller creatures. However, its ability to leap to great heights and its swiftness relative to its size also make it useful in caravans.\n„\n~ Helena')
    models.Creature.new(name='Lamprey', name_tag='Lamprey', category='Fish', entity_id='Lamprey_Character_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2c/Lamprey.png',
                        url='https://ark.fandom.com/wiki/Lamprey',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Lamprey/Lamprey_Character.Lamprey_Character\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1d/Dossier_Lamprey.png',
                        description="“\nSpecies\nXenomyzon luminosus\nTime\nHolocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nXenomyzon luminosus is one of the most poisonous aquatic species I've ever encountered. While its trademark glowing tail makes it easy to spot and identify, those luminescent glands are also where it produces and stores a debilitating poison. Xenomyzon has developed a particular fondness for blood, and whenever possible, it will attempt to latch onto human subjects. Once it does, it injects a poison for which there are only two cures: A specialized antidote or time. I would not recommend the latter.\nDomesticated\nWhile Xenomyzon cannot be brought to heel, some survivors have stored them in fish baskets for other uses. This keeps the subject alive and contained, but not properly tamed.\n„\n~ Helena")
    models.Creature.new(name='Nameless', name_tag='Chupacabra', category='Fantasy Creatures',
                        entity_id='ChupaCabra_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Nameless.png',
                        url='https://ark.fandom.com/wiki/Nameless',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/ChupaCabra/ChupaCabra_Character_BP.ChupaCabra_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a2/Dossier_Nameless.png',
                        description="“\nWild\nThe origins of the Nameless remain a mystery, but wherever they came from, these vicious creatures are nothing to scoff at, as they are rarely found alone. Common Nameless act in a subservient role to their pack's alpha, and will quickly heed its call to battle. Though savage in nature, the Nameless are deceptively intelligent. When hurt, they burrow underground to recover and protect themselves from further damage. Fortunately, they are highly susceptible to damage and burns from charge based light sources, and exploiting this weakness can save a survivor's life.\nDomesticated\nAll attempts to pacify a Nameless have failed. Each one has an extremely powerful bond with its pack leader, and for survivors, it might as well be unbreakable.\n„\n~ Helena")
    models.Creature.new(name='Ravager', name_tag='CaveWolf', category='Fantasy Creatures',
                        entity_id='CaveWolf_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/ca/Ravager.png',
                        url='https://ark.fandom.com/wiki/Ravager',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/CaveWolf/CaveWolf_Character_BP.CaveWolf_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ae/Dossier_Ravager.png',
                        description="“\nSpecies\nCanis barghest\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAnywhere else, Canis barghest's powerful muscles, wicked claws, and fearsome countenance would put it near the top of the food chain. Yet in these caves, this common, lupine predator resides somewhere in the middle. That said, it is an intelligent hunter with an exceptional ability to adapt. For example, it has learned to utilize the zip lines that survivors have built as a means of travel, all on its own. Remarkable!\nDomesticated\nThe strong legs of the Canis barghest make it an effective mount for many survivors, particularly for long distance travel. While other creatures outshine it when it comes to bursts of speed, its stamina and ability to climb across both natural vines and artificial zip lines makes it a highly versatile travelling companion.\n„\n~ Helena")
    models.Creature.new(name='Reaper King', name_tag='Xenomorph', category='Fantasy Creatures',
                        entity_id='Xenomorph_Character_BP_Male_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
                        url='https://ark.fandom.com/wiki/Reaper_King',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Nameless/Xenomorph_Character_BP_Male.Xenomorph_Character_BP_Male\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description="“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena")
    models.Creature.new(name='Reaper King (Tamed)', name_tag='Xenomorph', category='Fantasy Creatures',
                        entity_id='Xenomorph_Character_BP_Male_Tamed_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
                        url='https://ark.fandom.com/wiki/Reaper_King_(Tamed)',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Nameless/Xenomorph_Character_BP_Male_Tamed.Xenomorph_Character_BP_Male_Tamed\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description="“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena")
    models.Creature.new(name='Reaper Queen', name_tag='Xenomorph', category='Fantasy Creatures',
                        entity_id='Xenomorph_Character_BP_Female_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
                        url='https://ark.fandom.com/wiki/Reaper_Queen',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Nameless/Xenomorph_Character_BP_Female.Xenomorph_Character_BP_Female\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description="“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena")
    models.Creature.new(name='Rock Drake', name_tag='RockDrake', category='Fantasy Creatures',
                        entity_id='RockDrake_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e5/Rock_Drake.png',
                        url='https://ark.fandom.com/wiki/Rock_Drake',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/RockDrake/RockDrake_Character_BP.RockDrake_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/26/Dossier_Rock_Drake.png',
                        description="“\nSpecies\nDraconis obscurum\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nDraconis obscurum is a magnificent example of a predator that has flawlessly adapted to its environment. It is surrounded by cavern walls, so it developed powerful claws with which to scale them and colorful plumage on its anterior limbs that let it glide from perch to perch. But most dangerous of all? Its active camouflage, which lets it fade into the shadows and stalk its prey undetected. It has even adapted to the Nameless and The Reapers. Draconis' feathers will raise in warning when they are near, and this massive elegant lizard seems to be the Reaper's only natural enemy.\nDomesticated\nWith its unparalleled mobility and undeniable power, Draconis obscurum is a highly sought after mount. Survivors who successfully bring one back from its nesting grounds will suddenly find these caverns much easier to traverse, and that their enemies have become their unsuspecting prey. Even its saddle and rider are affected by its active camouflage, so a Survivor's enemies will never see them coming.\n„\n~ Helena")
    models.Creature.new(name='Rockwell', name_tag='Rockwell', category='Fantasy Creatures',
                        entity_id='Rockwell_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
                        url='https://ark.fandom.com/wiki/Rockwell',
                        blueprint='"Blueprint\'/Game/Aberration/Boss/Rockwell/Rockwell_Character_BP.Rockwell_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
                        description=None)
    models.Creature.new(name='Rockwell (Alpha)', name_tag='Rockwell', category='Fantasy Creatures',
                        entity_id='Rockwell_Character_BP_Hard_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
                        url='https://ark.fandom.com/wiki/Rockwell_(Alpha)',
                        blueprint='"Blueprint\'/Game/Aberration/Boss/Rockwell/Rockwell_Character_BP_Hard.Rockwell_Character_BP_Hard\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
                        description=None)
    models.Creature.new(name='Rockwell (Beta)', name_tag='Rockwell', category='Fantasy Creatures',
                        entity_id='Rockwell_Character_BP_Medium_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
                        url='https://ark.fandom.com/wiki/Rockwell_(Beta)',
                        blueprint='"Blueprint\'/Game/Aberration/Boss/Rockwell/Rockwell_Character_BP_Medium.Rockwell_Character_BP_Medium\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
                        description=None)
    models.Creature.new(name='Rockwell (Gamma)', name_tag='Rockwell', category='Fantasy Creatures',
                        entity_id='Rockwell_Character_BP_Easy_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
                        url='https://ark.fandom.com/wiki/Rockwell_(Gamma)',
                        blueprint='"Blueprint\'/Game/Aberration/Boss/Rockwell/Rockwell_Character_BP_Easy.Rockwell_Character_BP_Easy\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
                        description=None)
    models.Creature.new(name='Rockwell Tentacle', name_tag='RockwellTentacle', category='Fantasy Creatures',
                        entity_id='RockwellTentacle_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Tentacle',
                        blueprint='"Blueprint\'/Game/Aberration/Boss/RockwellTentacle/RockwellTentacle_Character_BP.RockwellTentacle_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
                        description=None)
    models.Creature.new(name='Rockwell Tentacle (Alpha)', name_tag='RockwellTentacle', category='Fantasy Creatures',
                        entity_id='RockwellTentacle_Character_BP_Alpha_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Tentacle_(Alpha)',
                        blueprint='"Blueprint\'/Game/Aberration/Boss/RockwellTentacle/RockwellTentacle_Character_BP_Alpha.RockwellTentacle_Character_BP_Alpha\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
                        description=None)
    models.Creature.new(name='Rockwell Tentacle (Beta)', name_tag='RockwellTentacle', category='Fantasy Creatures',
                        entity_id='RockwellTentacle_Character_BP_Beta_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Tentacle_(Beta)',
                        blueprint='"Blueprint\'/Game/Aberration/Boss/RockwellTentacle/RockwellTentacle_Character_BP_Beta.RockwellTentacle_Character_BP_Beta\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
                        description=None)
    models.Creature.new(name='Rockwell Tentacle (Gamma)', name_tag='RockwellTentacle', category='Fantasy Creatures',
                        entity_id='RockwellTentacle_Character_BP_Gamma_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Tentacle_(Gamma)',
                        blueprint='"Blueprint\'/Game/Aberration/Boss/RockwellTentacle/RockwellTentacle_Character_BP_Gamma.RockwellTentacle_Character_BP_Gamma\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
                        description=None)
    models.Creature.new(name='Roll Rat', name_tag='MoleRat', category='Fantasy Creatures',
                        entity_id='MoleRat_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d9/Roll_Rat.png',
                        url='https://ark.fandom.com/wiki/Roll_Rat',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/MoleRat/MoleRat_Character_BP.MoleRat_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c2/Dossier_Roll_Rat.png',
                        description='“\nSpecies\nHeterocephalus magnus\nTime\nHolocene\nDiet\nHerbivore\nTemperament\nPassive\nWild\nBearing a strong resemblance to its relative, the Naked Mole Rat, Heterocephalus magnus is a gentle giant that digs for plants and fungi with its imposing front teeth. While foraging, it often uncovers precious resources inadvertently, but survivors should claim them with caution, as this triggers an aggressive response. When threatened, Heterocephalus rolls up into a ball to shield itself with the armored plates on its back, much like an armadillo. It then rolls around like an oversized bowling ball, smashing through rocks, walls, and hopefully its aggressor.\nDomesticated\nWhile hardly a ferocious war beast, Heterocephalus is an effective transport that can carry up to three passengers. In theory, it could also be siege weapon, as its rolling attack can dent even metal. Fortunately, most survivors use a special saddle that deploys a protective canopy when it starts spinning, which not only keeps them from getting squished, but provides extra protection to the rider and mount alike.\n„\n~ Helena')
    models.Creature.new(name='Seeker', name_tag='Seeker', category='Fantasy Creatures',
                        entity_id='Pteroteuthis_Char_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/54/Seeker.png',
                        url='https://ark.fandom.com/wiki/Seeker',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Pteroteuthis/Pteroteuthis_Char_BP.Pteroteuthis_Char_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/71/Dossier_Seeker.png',
                        description="“\nSpecies\nChimaeram odiosus\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nA highly hostile predator with a pack mentality, Chimaeram Odiosus has a voracious appetite, and will quickly swarm anything that possesses its favorite delicacy: Charge. Fact, Charge light seems to be crucial to its survival. When in its presence, they are strong and aggressive, but without it, they are weaker and quicker to flee. Though distinct from any known species, Chimaeram's appearance is a hideous pastiche of bats and cephalopods, and as an unbiased professional, I have to say: I really hate these bloody things. Honestly.\nDomesticated\nFor better or worse, there is no known method of taming Chimaeram Odiosus. If one must confront these creatures, remember to do so away from any charged light sources, as an empowered Chimaeram swarm can punch well above its weight class.\n„\n~ Helena")
    models.Creature.new(name='Shinehorn', name_tag='Lantern Goat', category='Fantasy Creatures',
                        entity_id='LanternGoat_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/21/Shinehorn.png',
                        url='https://ark.fandom.com/wiki/Shinehorn',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/LanternGoat/LanternGoat_Character_BP.LanternGoat_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/20/Dossier_Shinehorn.png',
                        description="“\nSpecies\nMicroluminis cerynitis\nTime\nUnknown\nDiet\nHerbivore\nTemperament\nPassive\nWild\nMost commonly found in the upper chambers of the caverns, Microluminis cerynitis is at once elegant and adorable. As with its relatives, it is entirely peaceful, and no threat to survivors. After closer study, by which I mean very scientific bouts of cuddling, I've found that it shares traits with both bovids and cervids. However in the soft glow of its charge light, Microluminis cerynitis always gave me the impression that were it larger, it would be right at home pulling Artemis' chariot.\nDomesticated\nAn exceptionally well-mannered and huggable companion, Microluminis cerynitis is an excellent choice of pet for any survivor. Whether it is providing a source of charged light from your shoulder or playfully bounding up beside you, its presence is sure to brighten up your day.\n„\n~ Helena")
    models.Creature.new(name='Surface Reaper King Ghost', name_tag='Xenomorph', category='Event Creatures',
                        entity_id='Ghost_Xenomorph_Character_BP_Male_Surface_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b5/Surface_Reaper_King_Ghost.png',
                        url='https://ark.fandom.com/wiki/Surface_Reaper_King_Ghost',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Nameless/Ghost_Xenomorph_Character_BP_Male_Surface.Ghost_Xenomorph_Character_BP_Male_Surface\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e2/Surface_Reaper_King_Ghost_Image.jpg',
                        description=None)
    models.Creature.new(name='Alpha Blood Crystal Wyvern', name_tag='Wyvern', category='Alpha Creatures',
                        entity_id='CrystalWyvern_Character_BP_Mega_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/11/Crystal_Wyvern.png',
                        url='https://ark.fandom.com/wiki/Alpha_Blood_Crystal_Wyvern',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/CrystalWyvern_Character_BP_Mega.CrystalWyvern_Character_BP_Mega\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Crystal_Wyvern_Image.jpg',
                        description=None)
    models.Creature.new(name='Blood Crystal Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='CrystalWyvern_Character_BP_Blood_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/11/Crystal_Wyvern.png',
                        url='https://ark.fandom.com/wiki/Blood_Crystal_Wyvern',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/CrystalWyvern_Character_BP_Blood.CrystalWyvern_Character_BP_Blood\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Crystal_Wyvern_Image.jpg',
                        description=None)
    models.Creature.new(name='Crystal Wyvern Queen (Gamma)', name_tag='Wyvern', category='Bosses',
                        entity_id='CrystalWyvern_Character_BP_Boss_Easy_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Crystal_Wyvern_Queen.png',
                        url='https://ark.fandom.com/wiki/Crystal_Wyvern_Queen_(Gamma)',
                        blueprint='"Blueprint\'/Game/Mods/CrystalIsles/Assets/Dinos/CIBoss/CrystalWyvern_Character_BP_Boss_Easy.CrystalWyvern_Character_BP_Boss_Easy\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ad/Crystal_Wyvern_Queen_Image.jpg',
                        description=None)
    models.Creature.new(name='Crystal Wyvern Queen (Beta)', name_tag='Wyvern', category='Bosses',
                        entity_id='CrystalWyvern_Character_BP_Boss_Medium_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Crystal_Wyvern_Queen.png',
                        url='https://ark.fandom.com/wiki/Crystal_Wyvern_Queen_(Beta)',
                        blueprint='"Blueprint\'/Game/Mods/CrystalIsles/Assets/Dinos/CIBoss/CrystalWyvern_Character_BP_Boss_Medium.CrystalWyvern_Character_BP_Boss_Medium\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ad/Crystal_Wyvern_Queen_Image.jpg',
                        description=None)
    models.Creature.new(name='Crystal Wyvern Queen (Alpha)', name_tag='Wyvern', category='Bosses',
                        entity_id='CrystalWyvern_Character_BP_Boss_Hard_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Crystal_Wyvern_Queen.png',
                        url='https://ark.fandom.com/wiki/Crystal_Wyvern_Queen_(Alpha)',
                        blueprint='"Blueprint\'/Game/Mods/CrystalIsles/Assets/Dinos/CIBoss/CrystalWyvern_Character_BP_Boss_Hard.CrystalWyvern_Character_BP_Boss_Hard\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ad/Crystal_Wyvern_Queen_Image.jpg',
                        description=None)
    models.Creature.new(name='Ember Crystal Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='CrystalWyvern_Character_BP_Ember_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/11/Crystal_Wyvern.png',
                        url='https://ark.fandom.com/wiki/Ember_Crystal_Wyvern',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/CrystalWyvern_Character_BP_Ember.CrystalWyvern_Character_BP_Ember\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Crystal_Wyvern_Image.jpg',
                        description=None)
    models.Creature.new(name='Giant Worker Bee', name_tag='Bee', category='Invertebrates',
                        entity_id='HoneyBee_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/45/Giant_Bee.png',
                        url='https://ark.fandom.com/wiki/Giant_Worker_Bee',
                        blueprint='"Blueprint\'/Game/Mods/CrystalIsles/Assets/Dinos/HoneyBee/HoneyBee_Character_BP.HoneyBee_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Dossier_Giant_Bee.png',
                        description='“\nSpecies\nApis lithohermaea\nTime\nMiddle Miocene\nDiet\nHerbivore\nTemperament\nTerritorial\nWild\nIn the wild, Apis lithohermaea Drones never stray far from their nests, which they build high in the Island’s Redwood trees or on rocky cliffsides. Apis Drones can be seen swarming around the nest in groups, but to get a look at the Queen Apis, one would need to crack open the nest itself. Speaking from experience, this is not a pleasant task, as the untameable Apis Drones are quite territorial. I probably should have seen that one coming, in hindsight. Take caution: Apis stings will significantly weaken any creature which suffers them, and because its stinger is not barbed, Apis can sting multiple times without its stinger being ripped away.\nDomesticated\nA tamed Apis Queen will lay new drone eggs, and construct a nest that survivors can farm for honey, so long as they remember to wear specialized bee-keeping gear. Said honey is not only sweet and delicious, but laced with scents that land mammals find irresistible. Many hunters use it to bait their traps. Apis Drones will also follow their Queen into battle, so they can be used for self-defense in a pinch.\n„\n~ Helena')
    models.Creature.new(name='Tropeognathus', name_tag='Tropeognathus', category='Reptiles',
                        entity_id='Tropeognathus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/94/Tropeognathus.png',
                        url='https://ark.fandom.com/wiki/Tropeognathus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Tropeognathus/Tropeognathus_Character_BP.Tropeognathus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8f/Dossier_Tropeognathus.png',
                        description="“\nSpecies\nTropeognathus mesembrinus\nTime\nCretaceous\nDiet\nPiscivore\nTemperament\nNeutral\nWild\nUp close, Tropeognathus mesembrinus is easily recognized by the keeled crests on its snout, but with wingspans of up to twenty-seven feet, you’re sure to spot it before then. These large wings are not only ideal for catching air currents over its ocean hunting grounds, but they also let Tropeognathus draft off of other flying creatures by flying behind them. While not the fastest flyer on the Isles, when combined with its remarkable stamina, this makes Tropeognathus well suited for long distance flight. Because it’s on the wing so much, Tropeognathus is best snared by those riding another flier. I've noticed the more clever tribespeople using chain bolas to capture them while airborne.\nDomesticated\nOnce tamed, Tropeognathus has proven quite useful to the people of the Isles beyond mere transportation. For example, its toothed beak can grind down many common goods to their base components, which is a great way to recycle items and gear! Well, so long as you have a rag handy to wipe off the spit... That bite is punishing enough to crack armor and grind through it over time, and Tropeognathus can blow away flora and fauna alike with a gust from its wings. Air-to-air combat is where this creature really shines, though. And with the right tools, some survivors have managed to fit them with a saddle-mounted flak cannon and jet engine for maximum lethality. Trust me, you haven't lived until you've ridden a jet-powered pterosaur into a dogfight. Saddle one up and see for yourself - you can be my wingman anytime!\n„\n~ Helena")
    models.Creature.new(name='Tropical Crystal Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='CrystalWyvern_Character_BP_WS_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/11/Crystal_Wyvern.png',
                        url='https://ark.fandom.com/wiki/Tropical_Crystal_Wyvern',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/CrystalWyvern_Character_BP_WS.CrystalWyvern_Character_BP_WS\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Crystal_Wyvern_Image.jpg',
                        description=None)
    models.Creature.new(name='Alpha King Titan', name_tag='KingTitanAlpha', category='Fantasy Creatures',
                        entity_id='KingKaiju_Character_BP_Alpha_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/King_Titan.png',
                        url='https://ark.fandom.com/wiki/Alpha_King_Titan',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/KingKaiju/KingKaiju_Character_BP_Alpha.KingKaiju_Character_BP_Alpha\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Dossier_King_Titan.png',
                        description='“\nThough he could scatter his foes with a single charge, roar or swipe of his tail, and call fire down from the sky itself, In the end you banished the King of Shadows. No matter how many corrupted beasts he summoned or how many weapons he rendered useless, he could not snuff you out - for you fought with the hopes of the human race on your shoulders, and its tenacity at your back.\n„')
    models.Creature.new(name='Beta King Titan', name_tag='King Titan', category='Fantasy Creatures',
                        entity_id='KingKaiju_Character_BP_Beta_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/King_Titan.png',
                        url='https://ark.fandom.com/wiki/Beta_King_Titan',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/KingKaiju/KingKaiju_Character_BP_Beta.KingKaiju_Character_BP_Beta\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Dossier_King_Titan.png',
                        description='“\nThough he could scatter his foes with a single charge, roar or swipe of his tail, and call fire down from the sky itself, In the end you banished the King of Shadows. No matter how many corrupted beasts he summoned or how many weapons he rendered useless, he could not snuff you out - for you fought with the hopes of the human race on your shoulders, and its tenacity at your back.\n„')
    models.Creature.new(name='Corrupted Arthropluera', name_tag='Arthro Corrupt', category='Invertebrates',
                        entity_id='Arthro_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Arthropluera.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Arthropluera',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Arthropluera/Arthro_Character_BP_Corrupt.Arthro_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Dossier_Arthropluera.png',
                        description="“\nSpecies\nArthropluera felsanguis\nTime\nEarly Permian\nDiet\nCarrion-Feeder\nTemperament\nAggressive\nWild\nThe fact that this creature exists is enough to give me nightmares. Like the island's other Arthropods, Arthropluera Felsanguis has become much larger than I might have believed possible. It's a very aggressive hunter, but prefers to eat meat after it has rotted for some time, and will voraciously seek out such delicacies.\nKnown Information\nArthropluera's blood has a very low pH, to the point that it can dissolve many materials. This acidic blood splashes back on anything that directly attacks it, weakening the durability of weapons and hurting attackers. Many creatures thusly refuse to prey on Arthropluera, fearing this unique defense. If that wasn't enough, Arthropluera also keeps a small reservoir of blood ready to spit at its prey.\nDomesticated\nLike most of the arthropods on the island, Arthropluera is simple minded and relatively easy to tame. It is an almost entirely military mount, useful mostly for attacking at a distance. Thanks to its unique defenses, whether hunting or warring, Arthropluera is generally safe from all but the largest of creatures.\n„\n~ Helena")
    models.Creature.new(name='Corrupted Carnotaurus', name_tag='Carno Corrupt', category='Dinosaurs',
                        entity_id='Carno_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Carnotaurus.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Carnotaurus',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Carno/Carno_Character_BP_Corrupt.Carno_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Carnotaurus.png',
                        description="“\nSpecies\nCarnotaurus pressor\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nCarnotaurus pressor is a distinctive creature that falls between a medium and large predator. It lives primarily on flat, clear ground, where it can capitalize on its speed. Additionally, it seems to have no qualms about running away from larger predators instead of fighting. The horns of the Carnotaurus seem to be used more for fighting rivals than actual hunting. This doesn't mean the horns aren't dangerous, though. They can still eviscerate larger prey. Carnotaurus is one of the smaller and more compact of the large predators. If Tyrannosaurus is the “lion” of the Island, Carnotaurus would certainly be the “cheetah.” The real threat of a Carnotaurus is not being able to escape it once it has spotted you.\nDomesticated\nCarnotaurus fills a very specific role. Larger and almost as fast as a Raptor, smaller but much faster than a Rex. Were it not for the creature's extremely long down-time after sprinting, it might be among the most capably balanced mounts.\n„\n~ Helena")
    models.Creature.new(name='Corrupted Chalicotherium', name_tag='Chalico', category='Mammals',
                        entity_id='Chalico_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Chalicotherium.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Chalicotherium',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Chalicotherium/Chalico_Character_BP_Corrupt.Chalico_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/28/Dossier_Chalicotherium.png',
                        description='“\nSpecies\nChalicotherium obsidioequus\nTime\nLate Oligocene - Early Pliocene\nDiet\nHerbivore\nTemperament\nTerritorial\nWild\nFound in small numbers within the Island\'s colder regions, Chalicotherium obsidioequus is normally a peaceful herbivore that prefers to spend its days lazing about or playing with its family. It is very territorial, however, and the entire family, young and old, will turn against an encroaching creature at just the slightest provocation. A memorable scene to stumble upon is a group of Chalicotherium playing. One odd playtime activity for Chalicotherium is hurling large balls of snow or.. mud-rocks(?).. at each other. Smaller creatures in the area shy away from Chalicotherium during this exertion, for fear of being buried in snow or "gravel."\nDomesticated\nWhile many creatures are useful while attacking a fortress, Chalicotherium can be trained as mobile artillery. Its unique playtime habit becomes a rather devastating long-range assault tactic when it is given boulders to throw, rather than snowballs!\n„\n~ Helena')
    models.Creature.new(name='Corrupted Dilophosaur', name_tag='Dilo Corrupt', category='Dinosaurs',
                        entity_id='Dilo_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c9/Dilophosaur.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Dilophosaur',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Dilo/Dilo_Character_BP_Corrupt.Dilo_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6c/Dossier_Dilophosaur.png',
                        description='“\nSpecies\nDilophosaurus sputatrix\nTime\nEarly Jurassic\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nDilophosaurus sputatrix is a strange creature. It stands at just over half the size of known Dilophosaurs and runs from aggressors as often as it fights them. Dilophosaurus sputatrix has a few traits not common in the Dilophosaurus genus. It has a very shrill call, and a decorative ridge of skin on its neck. I believe these are used to attract mates, as well as intimidate prey and would-be predators. Instead of attacking its prey outright, Dilophosaurus sputatrix spits venom to weaken and paralyze it before moving in for the kill.\nDomesticated\nBecause of their shrill cry and their ability to attack intruders from range, Dilophosaurus seem most suited as "guard dogs." Due to their small size, they are not suitable as mounts.\n„\n~ Helena')
    models.Creature.new(name='Corrupted Dimorphodon', name_tag='Dimorph Corrupt', category='Dinosaurs',
                        entity_id='Dimorph_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Dimorphodon.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Dimorphodon',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Dimorphodon/Dimorph_Character_BP_Corrupt.Dimorph_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/Dossier_Dimorphodon.png',
                        description="“\nSpecies\nDimorphodon equesica\nTime\nEarly Jurassic\nDiet\nCarnivore\nTemperament\nReactive\nWild\nDimorphodon equesica is another of the Island's Jekyll-and-Hyde creatures. It is normally passive, sometimes even friendly. When provoked, it becomes very aggressive, even against larger creatures it has no business fighting...often to its own fatal end. Dimorphodon can make short work of smaller opponents, however, due to its large (but lightweight) skull and teeth. Barely over a meter tall, Dimorphodon should be low on the food chain, but its incredible speed and surprisingly strong bite make it fairly dangerous, especially en masse as they tend to attack in groups. A flock of angry or hungry Dimorphodon can take down prey several times their size, so survivors should take care not to hunt near where a flock is gathered.\nDomesticated\nDimorphodon is one of the creatures on the Island that is easily domesticated for companionship, but its use in combat is also quite clear: It will hunt in large groups to seek out enemy dino riders directly, harassing them to no end, regardless of the might of their mount!\n„\n~ Helena")
    models.Creature.new(name='Corrupted Giganotosaurus', name_tag='Gigant Corrupt', category='Dinosaurs',
                        entity_id='Gigant_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Giganotosaurus.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Giganotosaurus',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Giganotosaurus/Gigant_Character_BP_Corrupt.Gigant_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
                        description='“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena')
    models.Creature.new(name='Corrupted Paraceratherium', name_tag='Paracer', category='Mammals',
                        entity_id='Paracer_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e1/Paraceratherium.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Paraceratherium',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Paraceratherium/Paracer_Character_BP_Corrupt.Paracer_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Paraceratherium.png',
                        description='“\nSpecies\nParaceratherium gigamicus\nTime\nOligocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nParaceratherium gigamicus is a massive, long-necked herbivore that inhabits some of the Island\'s grasslands. It resembles a gigantic horse/rhinoceros hybrid, but is over twice the size of either. Paraceratherium is a very peaceful and friendly creature. Barring some surprises yet in store for me, I can safely say that Paraceratherium is among the largest mammals on the Island. While its size means that Paraceratherium can provide an incredible amount of food, it also makes it dangerous when hunted.\nDomesticated\nA beast of burden second to the Brontosaurus, Paraceratherium is an excellent worker, and is sufficient in size to support a "platform" saddle upon which structures can be built. It is a naturally friendly animal, and is not afraid of humans. However, despite its normally calm demeanor, when it or its owner is provoked by aggression, the Paraceratherium can quickly become a real threat to the attacker and will use its girth to its advantage in combat.\n„\n~ Helena')
    models.Creature.new(name='Corrupted Pteranodon', name_tag='Ptera Corrupt', category='Dinosaurs',
                        entity_id='Ptero_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/22/Pteranodon.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Pteranodon',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Ptero/Ptero_Character_BP_Corrupt.Ptero_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6e/Dossier_Pteranodon.png',
                        description="“\nSpecies\nPteranodon wyvernus\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nPteranodon wyvernus is a large pterosaur, capable of flying more quickly than any creature I have witnessed on this Island thus far. It seems to have relatively poor stamina in comparison to its quick speed, however, making frequent pit stops on the beaches before taking off again. While other humans I've seen on the Island still insist on calling it a Pterodactyl, this is inaccurate. Pteranodon wyvernus's poor fighting and defensive skills mean they are likely to scavenge any number of dead animals rather than engage in dangerous combat with other creatures. They also flee at the slightest sign of trouble. Because of this, they are one of the most common creatures to be found darting across the Island's skies.\nDomesticated\nPteranodons seem to be among most popular flying companions from what I have witnessed, possibly because they are relatively easy to tame with a slingshot or bow. Mounting a Pteranodon must be among the fastest and safest ways to get around the Island, but it doesn't provide any measure of secrecy in comparison to travel on land through the dense foliage.\n„\n~ Helena")
    models.Creature.new(name='Corrupted Raptor', name_tag='Raptor Corrupt', category='Dinosaurs',
                        entity_id='Raptor_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/08/Raptor.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Raptor',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Raptor/Raptor_Character_BP_Corrupt.Raptor_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
                        description='“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena')
    models.Creature.new(name='Corrupted Reaper King', name_tag='Xenomorph Corrupt', category='Fantasy Creatures',
                        entity_id='Xenomorph_Character_BP_Male_Tamed_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Reaper_King',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Nameless/Xenomorph_Character_BP_Male_Tamed_Corrupt.Xenomorph_Character_BP_Male_Tamed_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description="“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena")
    models.Creature.new(name='Corrupted Rex', name_tag='Rex Corrupt', category='Dinosaurs',
                        entity_id='Rex_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Rex.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Rex',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Rex/Rex_Character_BP_Corrupt.Rex_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
                        description='“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena')
    models.Creature.new(name='Corrupted Rock Drake', name_tag='RockDrake Corrupt', category='Fantasy Creatures',
                        entity_id='RockDrake_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e5/Rock_Drake.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Rock_Drake',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/RockDrake/RockDrake_Character_BP_Corrupt.RockDrake_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/26/Dossier_Rock_Drake.png',
                        description="“\nSpecies\nDraconis obscurum\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nDraconis obscurum is a magnificent example of a predator that has flawlessly adapted to its environment. It is surrounded by cavern walls, so it developed powerful claws with which to scale them and colorful plumage on its anterior limbs that let it glide from perch to perch. But most dangerous of all? Its active camouflage, which lets it fade into the shadows and stalk its prey undetected. It has even adapted to the Nameless and The Reapers. Draconis' feathers will raise in warning when they are near, and this massive elegant lizard seems to be the Reaper's only natural enemy.\nDomesticated\nWith its unparalleled mobility and undeniable power, Draconis obscurum is a highly sought after mount. Survivors who successfully bring one back from its nesting grounds will suddenly find these caverns much easier to traverse, and that their enemies have become their unsuspecting prey. Even its saddle and rider are affected by its active camouflage, so a Survivor's enemies will never see them coming.\n„\n~ Helena")
    models.Creature.new(name='Corrupted Spino', name_tag='Spino Corrupt', category='Dinosaurs',
                        entity_id='Spino_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/03/Spino.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Spino',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Spino/Spino_Character_BP_Corrupt.Spino_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Spino.png',
                        description="“\nSpecies\nSpinosaurus aquareliga\nTime\nEarly-Late Cretaceous\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nAmong the few carnivores on the Island that can match Tyrannosaurs in size, Spinosaurus aquareliga does not match its ferocity. Spinosaurus' four legs and large sail make it fairly swift on land and incredibly fast in the water. Its marvel is, arguably, the ability to change stances by going from quadruped to biped. The creature is visually distinguished by its spectacular sail. In my travels I have seen many different and brightly coloured sails, as every Spinosaurus appears to have a slightly different palette. The one comforting fact about Spinosaurus is that it seems more at home near water than away from it. Although the creature is more powerful, faster, agile, and insatiable while in water, it tends to become less hostile as it gets farther from it. On one occasion, I only escaped a Spinosaurus by getting far enough from its lake home to make it simply lose interest.\nDomesticated\nSpinosaurus is an incredibly well-rounded apex carnivore. Faster than a Tyrannosaurus in water and able to travel on land unlike a Megalodon, its all-terrain versatility may be unrivaled. Although its movement speed is slower in a biped stance, it gains considerable attacking strength and mobility in this form. For hunters who wish to have a well-rounded mount, Spinosaurus may be the ideal choice -- if they can acquire one.\n„\n~ Helena")
    models.Creature.new(name='Corrupted Stegosaurus', name_tag='Stego Corrupt', category='Dinosaurs',
                        entity_id='Stego_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Stegosaurus.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Stegosaurus',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Stego/Stego_Character_BP_Corrupt.Stego_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Dossier_Stegosaurus.png',
                        description="“\nSpecies\nStegosaurus regium\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nDocile\nWild\nStegosaurus regium has approximately 16 paired rows of plates along its back, flanked by another, smaller pair of 6 plates. This is contrary to the alternating rows on Stegosaurus fossils I've seen in museums. Not surprisingly, Stegosaurus uses the spines on its tail to defend itself. While not aggressive, Stegosaurus will come to the aid of another nearby Stegosaurus. This implies it to be a herd animal.\nDomesticated\nStegosaurus is commonly used as a safe way to transport large quantities of goods. And once you saddle one up, not even an Argentavis could knock you off that perch. A stegosaurus can be trained to flex its back plates for different purposes: hardened to shield it from attack, in a heavier alignment that deals crippling blows, or oriented more sharply to pierce armor. These various plate configurations also come in handy for stripping wood from trees, gathering thatch, or foraging for wild berries, respectively. Stegosaurus can knock back or impale with a whip of its spiky tail, keeping predators at bay or pinning them in place. Its spiked appendage also helps for gathering berries—go figure.\n„\n~ Helena")
    models.Creature.new(name='Corrupted Triceratops', name_tag='Trike', category='Dinosaurs',
                        entity_id='Trike_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Triceratops',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Trike/Trike_Character_BP_Corrupt.Trike_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Triceratops.png',
                        description="“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena")
    models.Creature.new(name='Corrupted Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='Wyvern_Character_BP_Fire_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Wyvern',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Wyvern/Wyvern_Character_BP_Fire_Corrupt.Wyvern_Character_BP_Fire_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
                        description="“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena")
    models.Creature.new(name='Defense Unit', name_tag='EndTank', category='Fantasy Creatures',
                        entity_id='Defender_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/78/Defense_Unit.png',
                        url='https://ark.fandom.com/wiki/Defense_Unit',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Tank/Defender_Character_BP.Defender_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6e/Defense_Unit_Promo_Image.png',
                        description=None)
    models.Creature.new(name='Desert Titan', name_tag='DesertTitan', category='Fantasy Creatures',
                        entity_id='DesertKaiju_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/49/Desert_Titan.png',
                        url='https://ark.fandom.com/wiki/Desert_Titan',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/DesertKaiju/DesertKaiju_Character_BP.DesertKaiju_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1a/Dossier_Desert_Titan.png',
                        description='“\nThe Lord of Sand and Sky has fallen, despite its swarms of protectors, the powerful swings of its mighty tail or the lightning it called from the sky. The soaring leviathan could not match the ingenuity of humanity, and especially not yours.\n„')
    models.Creature.new(name='Desert Titan Flock', name_tag='Flock', category='Fantasy Creatures',
                        entity_id='DesertKaiju_FirstFlockChar_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/49/Desert_Titan.png',
                        url='https://ark.fandom.com/wiki/Desert_Titan_Flock',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/DesertKaiju/DesertKaiju_FirstFlockChar_BP.DesertKaiju_FirstFlockChar_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1a/Dossier_Desert_Titan.png',
                        description='“\nThe Lord of Sand and Sky has fallen, despite its swarms of protectors, the powerful swings of its mighty tail or the lightning it called from the sky. The soaring leviathan could not match the ingenuity of humanity, and especially not yours.\n„')
    models.Creature.new(name='Enforcer', name_tag='Enforcer', category='Fantasy Creatures',
                        entity_id='Enforcer_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e4/Enforcer.png',
                        url='https://ark.fandom.com/wiki/Enforcer',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Enforcer/Enforcer_Character_BP.Enforcer_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Enforcer.png',
                        description="“\nModel Number\nAGV MQ-9X\nThreat Level\nHigh\nPrimary Function\nDirect combat\nField Manual 31-582\nField Observations\nWith its speed and teleportation capabilities, Autonomous Ground Vehicle MQ-9X is built to close gaps quickly and engage its targets in close quarters. Once in range, it uses refined Element claws with lethal force.\nMQ-9X was clearly designed for urban combat. Its claws and shock absorbers let it scale walls and drop down to street level from significant heights, and we've only seen it patrolling within the city limits. Possibly the remnant of an automated police force or defensive army.\nRecommendations: Isolate, and engage at range in wide open spaces. I've calculated its maximum teleportation distance as roughly 15 meters, so maintain that gap as long as possible\nPersonal Use\nEvery MQ-9X I've encountered is stuck on a defensive loop, and overriding its primary directive is impossible. However, if we're able to acquire an intact processing core from a hostile unit, with enough parts I could reverse engineer our own, more loyal model. Could be useful - the grooves on its back are suited for a rider, so we wouldn't even need to build saddles.\n„\n~ Santiago")
    models.Creature.new(name='Enraged Corrupted Rex', name_tag='Elite Rex Corrupt', category='Dinosaurs',
                        entity_id='MegaRex_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e6/Enraged_Corrupted_Rex.png',
                        url='https://ark.fandom.com/wiki/Enraged_Corrupted_Rex',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Rex/MegaRex_Character_BP_Corrupt.MegaRex_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3f/Enraged_Corrupted_Rex_1.jpg',
                        description=None)
    models.Creature.new(name='Enraged Triceratops', name_tag='Trike', category='Dinosaurs',
                        entity_id='MegaTrike_Character_BP_Corrupt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Enraged_Triceratops.png',
                        url='https://ark.fandom.com/wiki/Enraged_Triceratops',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Corrupt/Trike/MegaTrike_Character_BP_Corrupt.MegaTrike_Character_BP_Corrupt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/78/Enraged_Triceratops_1.jpg',
                        description=None)
    models.Creature.new(name='Forest Titan', name_tag='ForestTitan', category='Fantasy Creatures',
                        entity_id='ForestKaiju_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/28/Forest_Titan.png',
                        url='https://ark.fandom.com/wiki/Forest_Titan',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/ForestKaiju/ForestKaiju_Character_BP.ForestKaiju_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1e/Dossier_Forest_Titan.png',
                        description='“\nSo succumbs the Lord of the Forest, the titan wreathed in green, who lashed out with root and vine to pin its foes to the ground or drag them to their doom. The forest itself rose to shield it, but even that could not save it. Not from you.\n„')
    models.Creature.new(name='Forest Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='Wyvern_Character_BP_Fire_Minion_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
                        url='https://ark.fandom.com/wiki/Forest_Wyvern',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/ForestKaiju/Minion/Wyvern_Character_BP_Fire_Minion.Wyvern_Character_BP_Fire_Minion\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
                        description="“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena")
    models.Creature.new(name='Gacha', name_tag='Gacha', category='Fantasy Creatures', entity_id='Gacha_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Gacha.png',
                        url='https://ark.fandom.com/wiki/Gacha',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Gacha/Gacha_Character_BP.Gacha_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Dossier_Gacha.png',
                        description="“\nSpecies\nMacrodryadis crystallinus\nTime\nPost-Holocene\nDiet\nOmnivore\nTemperament\nDocile\nWild\nA gentle giant, Macrodryadis crystallinus spends its days foraging for food in the dense forest it calls home, though it rarely has to look very far. Thanks to its extraordinary digestive system, not only can Macrodryadis eat just about anything, but it can also turn a diet of scraps into a mountain of precious resources.\n\nInstead of producing excrement, Macrodryadis grows glittering crystals upon its back, which fall off when they reach their full size. Shattering these crystals can yield precious resources, as Macrodryadis is somehow able to transmute the materials it eats into something entirely different.\n\nOne of our pilots likened the process to the gachapon machines from his memories of growing up in Japan, and I guess the name stuck.\nDomesticated\nThough its crystals prevent Macrodryadis from wearing a traditional saddle, if its rider is willing to sit in a basket that hangs from Macrodryadis' neck, then they'll find its long claws are well suited for mining resources. Personally though, I'd keep one around just for the crystals. The free presents, the way they glow at night...totally worth the potential nausea from the basket saddle.\n„\n~ Helena")
    models.Creature.new(name='GachaClaus', name_tag='Gacha', category='Fantasy Creatures',
                        entity_id='Gacha_Claus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/86/GachaClaus.png',
                        url='https://ark.fandom.com/wiki/GachaClaus',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Gacha/Gacha_Claus_Character_BP.Gacha_Claus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/GachaClaus_Image.jpg',
                        description=None)
    models.Creature.new(name='Gamma King Titan', name_tag='King Titan', category='Fantasy Creatures',
                        entity_id='KingKaiju_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/King_Titan.png',
                        url='https://ark.fandom.com/wiki/Gamma_King_Titan',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/KingKaiju/KingKaiju_Character_BP.KingKaiju_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Dossier_King_Titan.png',
                        description='“\nThough he could scatter his foes with a single charge, roar or swipe of his tail, and call fire down from the sky itself, In the end you banished the King of Shadows. No matter how many corrupted beasts he summoned or how many weapons he rendered useless, he could not snuff you out - for you fought with the hopes of the human race on your shoulders, and its tenacity at your back.\n„')
    models.Creature.new(name='Gasbags', name_tag='GasBags', category='Fantasy Creatures',
                        entity_id='GasBags_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Gasbags.png',
                        url='https://ark.fandom.com/wiki/Gasbags',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/GasBag/GasBags_Character_BP.GasBags_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8c/Dossier_Gasbags.png',
                        description="“\nSpecies\nMopsechiniscus fluitobesus\nTime\nPost-Holocene\nDiet\nOmnivore\nTemperament\nPassive\nWild\nIt was always hypothesized that a member of the Tardigrada phylum would be the last species on Earth in the event of a global apocalypse, so in some ways, the existence of Mopsechiniscus fluitobesus is completely expected. Its size and method of travel, however? Less so.\n\nMopsechiniscus is slow and ineffective in a fight, so to survive, it tends to choose flight - literally. First, it inflates itself like a balloon, briefly slowing down and gaining durability. Then it launches itself into the air by expelling gas through a series of sphincters in its underbelly, which it also uses to slow its descent.\n\nYes, it's as...unusual as it sounds, but Mopsechiniscus makes the most of its inflatable nature. In addition to jumping, it can use its stored up gases to push back aggressors, or even float on water.\nDomesticated\nWhile a poor steed in battle, Mopsechiniscus is a fantastic beast of burden. The hairs on its back let a single rider steer it without a saddle, and it carries an incredible amount of cargo for its size. A small caravan of these could see us swimming in resources in no time.\n„\n~ Helena")
    models.Creature.new(name='Ice Titan', name_tag='IceTitan', category='Fantasy Creatures',
                        entity_id='IceKaiju_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dc/Ice_Titan.png',
                        url='https://ark.fandom.com/wiki/Ice_Titan',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/IceKaiju/IceKaiju_Character_BP.IceKaiju_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Dossier_Ice_Titan.png',
                        description='“\nThus ends the reign of the Lord of Winter. Its freezing breath, icy spears, and colossal leaps had felled so many, but on this day, the giant of wind and rime was brought low - all by your hand.\n„')
    models.Creature.new(name='Managarmr', name_tag='Managarmr', category='Fantasy Creatures',
                        entity_id='IceJumper_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e7/Managarmr.png',
                        url='https://ark.fandom.com/wiki/Managarmr',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/IceJumper/IceJumper_Character_BP.IceJumper_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/72/Dossier_Managarmr.png',
                        description='“\nSpecies\nDraconis auragelus\nTime\nPost-Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nDraconis auragelus appears to be directly related to the stealthy Draconis obscurum. Their stature, gait and ability to dive through the air are all similar. However, where Draconis obscurum scaled cavern walls to gain the high ground, Draconis auragelus takes a more bombastic approach.\n\nIn the middle of its hind feet, Draconis auragelus\' bones form a hollowed out cylindrical shape that acts as a combustion chamber, which it fills with an explosive gas. When ignited, this gas propels it upwards, letting it "jump" in the air multiple times. From there, it can create a smaller burn in said chambers to hover in place, or dive at its prey.\n\nLike the icy variant of Draconis vipera, Draconis auragelus can slow down its foes with its frigid breath - though it\'s able to take this one step further and freeze its prey solid. Perhaps that\'s because it\'s used to living in the tundra environment on the surface, as opposed to a desert.\nDomesticated\nAs a mount, Draconis auragelus can carry multiple adult humans without losing any of its impressive mobility, and its freezing breath makes it a good choice in combat. Whether you\'re looking to hunt, do battle or just travel with ease, it makes for an excellent companion.\n„\n~ Helena')
    models.Creature.new(name='Mega Mek', name_tag='MegaMek', category='Fantasy Creatures',
                        entity_id='MegaMek_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Mek.png',
                        url='https://ark.fandom.com/wiki/Mega_Mek',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Mek/MegaMek_Character_BP.MegaMek_Character_BP\'"',
                        large_image_url='https://cdnb.artstation.com/p/assets/covers/images/013/959/563/large/nathan-lange-mm-0007-layer-10.jpg',
                        description="“\nModel Number\nRX-103 MEK\nHeight\n10.5 meters\nWeight\n48.3 tons\nTechnical Manual 9-978\nStandard Equipment\nOZ-13NV TEK Saber: Designed as the primary weapon, to better suit the skills of our top pilot candidates. Built more for cuts than stabs. Ideal for attacking in combinations.\nXBR-M-93R Plasma Pistol: Secondary weapon. Fires in three shot bursts.\nMS-06BR Boosters: Installed under the unit's feet. On activation, they let the unit hover in the air and move rapidly over short distances. Combine with ranged attacks for maximum effectiveness.\nHeat Gauge: Pilots should always monitor their unit's heat levels. Overheating will result in your unit being slow, vulnerable and soon after that? Scrap.\nCustom Equipment\nEach RX-103-MEK has a module slot for a specially designed weapon or tool that can be swapped out with ease. These are...\nG-01W Mek Siege Cannon Module: A high yield artillery cannon mounted on the unit's back. To handle the recoil, the unit must temporarily anchor itself to the ground, rendering it immobile while firing.\nG-02H Mek Rocket Launcher Module: An oversized missile battery that fires in sixteen round salvos, which spread out and then converge on the unit’s target. Especially effective against large, isolated targets.\nG-01S Mek Deployable Shield Module: Deploys a dome shaped energy barrier that protects the unit from incoming ranged attacks, while boosting its speed. Good for team or melee oriented pilots.\n„\n~ Santiago")
    models.Creature.new(name='Mek', name_tag='Mek', category='Fantasy Creatures', entity_id='Mek_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Mek.png',
                        url='https://ark.fandom.com/wiki/Mek',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Mek/Mek_Character_BP.Mek_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1e/Dossier_Mek.png',
                        description="“\nModel Number\nRX-103 MEK\nHeight\n10.5 meters\nWeight\n48.3 tons\nTechnical Manual 9-978\nStandard Equipment\nOZ-13NV TEK Saber: Designed as the primary weapon, to better suit the skills of our top pilot candidates. Built more for cuts than stabs. Ideal for attacking in combinations.\nXBR-M-93R Plasma Pistol: Secondary weapon. Fires in three shot bursts.\nMS-06BR Boosters: Installed under the unit's feet. On activation, they let the unit hover in the air and move rapidly over short distances. Combine with ranged attacks for maximum effectiveness.\nHeat Gauge: Pilots should always monitor their unit's heat levels. Overheating will result in your unit being slow, vulnerable and soon after that? Scrap.\nCustom Equipment\nEach RX-103-MEK has a module slot for a specially designed weapon or tool that can be swapped out with ease. These are...\nG-01W Mek Siege Cannon Module: A high yield artillery cannon mounted on the unit's back. To handle the recoil, the unit must temporarily anchor itself to the ground, rendering it immobile while firing.\nG-02H Mek Rocket Launcher Module: An oversized missile battery that fires in sixteen round salvos, which spread out and then converge on the unit’s target. Especially effective against large, isolated targets.\nG-01S Mek Deployable Shield Module: Deploys a dome shaped energy barrier that protects the unit from incoming ranged attacks, while boosting its speed. Good for team or melee oriented pilots.\n„\n~ Santiago")
    models.Creature.new(name='Scout', name_tag='Scout', category='Fantasy Creatures', entity_id='Scout_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/69/Scout.png',
                        url='https://ark.fandom.com/wiki/Scout',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Scout/Scout_Character_BP.Scout_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0d/Dossier_Scout.png',
                        description="“\nModel Number\nUAV RQ-7Y\nThreat Level\nLow\nPrimary Function\nReconnaissance\nField Manual 31-581\nField Observations\nBy itself, Unmanned Aerial Vehicle RQ-7Y is hardly a concern. Though many of them can be found monitoring the empty streets the abandoned city, they're not aggressive, and their offensive capabilities are limited. If attacked, they rely on bursts from their thrusters to either take evasive maneuvers or ram the aggressor, and they have no real armaments to speak of. This makes obtaining intact processing cores and spare parts a trivial matter, and as a result we've constructed a number of our own.\nPersonal Use\nShifting some of our resources to focus on RQ-7Y construction has been more than worth the investment. I managed to turn our TEK binoculars into a remote control system for them, and as a result our scouting teams have been able to cover more ground with far less risk. They simply deploy the RQ-7Y with a specialized grenade, then use its enhanced vision to scout ahead, scan for allied IFFs and track targets. Just don't try to ride the damn thing. I didn't think I'd have to explain that considering how small it is, but three crashes later, here we are...\n„\n~ Santiago")
    models.Creature.new(name='Snow Owl', name_tag='Owl', category='Birds', entity_id='Owl_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4b/Snow_Owl.png',
                        url='https://ark.fandom.com/wiki/Snow_Owl',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Owl/Owl_Character_BP.Owl_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bd/Dossier_Snow_Owl.png',
                        description="“\nSpecies\nBubo chinookus\nTime\nPost-Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nDiscovering Bubo chinookus was a pleasant surprise. Owls are remarkable creatures, but they're not the type that could survive an extinction level event on their own. Since it never strays from the patch of frozen tundra we encountered, I believe the Obelisk was the key to its survival.\n\nClearly a descendant of modern Strigdae, Bubo shares many traits with its smaller ancestors. For example, it excretes waste in the form of pellets, which make excellent fertilizer, and their large wings let them save energy during long, silent flights. They even hunt in the same way: by diving towards the ground to attack their prey with powerful talons.\n\nHowever, these talons also secrete a chemical with a high freezing point to slow down their prey, and they can even unleash this chemical in a wide cloud, temporarily freezing their foes.\nDomesticated\nWith its swift flying and frigid attacks, Bubo makes an excellent single-rider support mount or scout. The latter is helped by its tremendous vision, which it can share with its rider via its antenna. Not only does this make enemies easier to see, but Bubo can also spot Element veins with ease, even when they're underground.\n„\n~ Helena")
    models.Creature.new(name='Snow Owl Ghost', name_tag='Owl', category='Event Creatures',
                        entity_id='Ghost_Owl_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Snow_Owl_Ghost.png',
                        url='https://ark.fandom.com/wiki/Snow_Owl_Ghost',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Owl/Ghost_Owl_Character_BP.Ghost_Owl_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4f/Snow_Owl_Ghost_Image.jpg',
                        description=None)
    models.Creature.new(name='Velonasaur', name_tag='Velonasaur', category='Fantasy Creatures',
                        entity_id='Spindles_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Velonasaur.png',
                        url='https://ark.fandom.com/wiki/Velonasaur',
                        blueprint='"Blueprint\'/Game/Extinction/Dinos/Spindles/Spindles_Character_BP.Spindles_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Dossier_Velonasaur.png',
                        description="“\nSpecies\nVelonasaurus spinavultus\nTime\nPost-Holocene\nDiet\nCarnivore\nTemperament\nOmnivore\nWild\nVelonasaurus spinavultus dwells in the small desert found outside the abandoned city, which is particularly fitting, because it looks like it's growing several cacti right on its face.\n\nAs unfashionable as its facial fins might be, I recommend keeping a close eye on them. While said fins are folded inwards, Velonasaurus behaves like your average therapod, attacking with claws and teeth. However, when those fins are spread wide, Velonasaurus can rapidly fire a storm of spines at its prey. However, while in this state, its mobility is greatly hampered and it will eventually wear itself out.\n\nTherefore it sometimes prefers to unleash its spines in a single, deadly burst. By spinning around and firing a salvo of spines at the same time, Velonasaurus can defend itself from every angle at once.\nDomesticated\nGiven its versatility, Velonasaurus spinavultus makes an excellent single rider mount in most combat situations, but it's particularly effective when defending an entrenched position. It's like a living, breathing gatling gun. Just be careful when giving it a congratulatory hug or pat on the head. Getting spined by your own war steed would be a rather embarrassing way to go.\n„\n~ Helena")
    models.Creature.new(name='Alpha Corrupted Master Controller', name_tag=None, category='Bosses',
                        entity_id='VRMainBoss_Character_Hard_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Corrupted_Master_Controller.png',
                        url='https://ark.fandom.com/wiki/Alpha_Corrupted_Master_Controller',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/VRMainBoss/VRMainBoss_Character_Hard.VRMainBoss_Character_Hard\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Corrupted_Master_Controller_Image.jpg',
                        description=None)
    models.Creature.new(name='Alpha Moeder, Master of the Ocean', name_tag='EelBoss', category='Bosses',
                        entity_id='EelBoss_Character_BP_Hard_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bd/Moeder%2C_Master_of_the_Ocean.png',
                        url='https://ark.fandom.com/wiki/Alpha_Moeder,_Master_of_the_Ocean',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/EelBoss/EelBoss_Character_BP_Hard.EelBoss_Character_BP_Hard\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Genesis_17.jpg',
                        description=None)
    models.Creature.new(name='Alpha X-Triceratops', name_tag='Trike', category='Alpha Creatures',
                        entity_id='Volcano_Trike_Character_BP_Retrieve_Alpha_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
                        url='https://ark.fandom.com/wiki/Alpha_X-Triceratops',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Retrieve/Volcanic/Volcano_Trike_Character_BP_Retrieve_Alpha.Volcano_Trike_Character_BP_Retrieve_Alpha\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Triceratops.png',
                        description="“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena")
    models.Creature.new(name='Astrocetus', name_tag='Space Whale', category='Fantasy Creatures',
                        entity_id='SpaceWhale_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/69/Astrocetus.png',
                        url='https://ark.fandom.com/wiki/Astrocetus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/SpaceWhale/SpaceWhale_Character_BP.SpaceWhale_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Astrocetus_Image.jpg',
                        description=None)
    models.Creature.new(name='Beta Corrupted Master Controller', name_tag=None, category='Bosses',
                        entity_id='VRMainBoss_Character_Medium_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Corrupted_Master_Controller.png',
                        url='https://ark.fandom.com/wiki/Beta_Corrupted_Master_Controller',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/VRMainBoss/VRMainBoss_Character_Medium.VRMainBoss_Character_Medium\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Corrupted_Master_Controller_Image.jpg',
                        description=None)
    models.Creature.new(name='Beta Moeder, Master of the Ocean', name_tag='EelBoss', category='Bosses',
                        entity_id='EelBoss_Character_BP_Medium_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Corrupted_Master_Controller.png',
                        url='https://ark.fandom.com/wiki/Beta_Moeder,_Master_of_the_Ocean',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/EelBoss/EelBoss_Character_BP_Medium.EelBoss_Character_BP_Medium\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Corrupted_Master_Controller_Image.jpg',
                        description=None)
    models.Creature.new(name='Bloodstalker', name_tag='Bloodstalker', category='Fantasy Creatures',
                        entity_id='BogSpider_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1a/Bloodstalker.png',
                        url='https://ark.fandom.com/wiki/Bloodstalker',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BogSpider/BogSpider_Character_BP.BogSpider_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9b/Bloodstalker_Image.jpg',
                        description=None)
    models.Creature.new(name='Brute Araneo', name_tag='Spider', category='Brute Creatures',
                        entity_id='SpiderS_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b5/Brute_Araneo.png',
                        url='https://ark.fandom.com/wiki/Brute_Araneo',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Bog/SpiderS_Character_BP_Hunt.SpiderS_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Dossier_Araneo.png',
                        description=None)
    models.Creature.new(name='Brute Astrocetus', name_tag='Space Whale', category='Brute Creatures',
                        entity_id='SpaceWhale_Character_BP_Brute_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0c/Brute_Astrocetus.png',
                        url='https://ark.fandom.com/wiki/Brute_Astrocetus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Lunar/SpaceWhale_Character_BP_Brute.SpaceWhale_Character_BP_Brute\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Astrocetus_Image.jpg',
                        description=None)
    models.Creature.new(name='Brute Basilosaurus', name_tag='Basilosaurus', category='Brute Creatures',
                        entity_id='Basilosaurus_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/02/Brute_Basilosaurus.png',
                        url='https://ark.fandom.com/wiki/Brute_Basilosaurus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Basilosaurus_Character_BP_Hunt.Basilosaurus_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Dossier_Basilosaurus.png',
                        description=None)
    models.Creature.new(name='Brute Bloodstalker', name_tag='Bloodstalker', category='Brute Creatures',
                        entity_id='BogSpider_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/49/Brute_Bloodstalker.png',
                        url='https://ark.fandom.com/wiki/Brute_Bloodstalker',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Bog/BogSpider_Character_BP_Hunt.BogSpider_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9b/Bloodstalker_Image.jpg',
                        description=None)
    models.Creature.new(name='Brute Ferox', name_tag='Bigly', category='Brute Creatures',
                        entity_id='Shapeshifter_Large_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Brute_Ferox.png',
                        url='https://ark.fandom.com/wiki/Brute_Ferox',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Arctic/Shapeshifter_Large_Character_BP_Hunt.Shapeshifter_Large_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2b/Ferox_Image.jpg',
                        description=None)
    models.Creature.new(name='Brute Fire Wyvern', name_tag='Wyvern', category='Brute Creatures',
                        entity_id='Wyvern_Character_BP_Fire_GauntletBoss_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4f/Brute_Fire_Wyvern.png',
                        url='https://ark.fandom.com/wiki/Brute_Fire_Wyvern',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Gauntlet/Volcanic/Wyvern_Character_BP_Fire_GauntletBoss.Wyvern_Character_BP_Fire_GauntletBoss\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
                        description=None)
    models.Creature.new(name='Brute Leedsichthys', name_tag='Leedsichthys', category='Brute Creatures',
                        entity_id='Leedsichthys_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/63/Brute_Leedsichthys.png',
                        url='https://ark.fandom.com/wiki/Brute_Leedsichthys',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Leedsichthys_Character_BP_Hunt.Leedsichthys_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e9/Dossier_Leedsichthys.png',
                        description=None)
    models.Creature.new(name='Brute Magmasaur', name_tag='LavaLizard', category='Brute Creatures',
                        entity_id='Cherufe_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Brute_Magmasaur.png',
                        url='https://ark.fandom.com/wiki/Brute_Magmasaur',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Volcanic/Cherufe_Character_BP_Hunt.Cherufe_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Magmasaur_Image.jpg',
                        description=None)
    models.Creature.new(name='Brute Malfunctioned Tek Giganotosaurus', name_tag='Gigant', category='Brute Creatures',
                        entity_id='BionicGigant_Character_BP_Malfunctioned_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/96/Brute_Malfunctioned_Tek_Giganotosaurus.png',
                        url='https://ark.fandom.com/wiki/Brute_Malfunctioned_Tek_Giganotosaurus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Lunar/BionicGigant_Character_BP_Malfunctioned_Hunt.BionicGigant_Character_BP_Malfunctioned_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
                        description='“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena')
    models.Creature.new(name='Brute Malfunctioned Tek Rex', name_tag='Rex', category='Brute Creatures',
                        entity_id='BionicRex_Character_BP_Malfunctioned_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c8/Brute_Malfunctioned_Tek_Rex.png',
                        url='https://ark.fandom.com/wiki/Brute_Malfunctioned_Tek_Rex',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Lunar/BionicRex_Character_BP_Malfunctioned_Hunt.BionicRex_Character_BP_Malfunctioned_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
                        description='“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena')
    models.Creature.new(name='Brute Mammoth', name_tag='Mammoth', category='Brute Creatures',
                        entity_id='Mammoth_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Brute_Mammoth.png',
                        url='https://ark.fandom.com/wiki/Brute_Mammoth',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Arctic/Mammoth_Character_BP_Hunt.Mammoth_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0c/Dossier_Mammoth.png',
                        description=None)
    models.Creature.new(name='Brute Megaloceros', name_tag='Stag', category='Brute Creatures',
                        entity_id='Stag_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Brute_Megaloceros.png',
                        url='https://ark.fandom.com/wiki/Brute_Megaloceros',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Arctic/Stag_Character_BP_Hunt.Stag_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8c/Dossier_Megaloceros.png',
                        description=None)
    models.Creature.new(name='Brute Plesiosaur', name_tag='Plesiosaur', category='Brute Creatures',
                        entity_id='Plesiosaur_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/Brute_Plesiosaur.png',
                        url='https://ark.fandom.com/wiki/Brute_Plesiosaur',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Plesiosaur_Character_BP_Hunt.Plesiosaur_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Plesiosaur.png',
                        description=None)
    models.Creature.new(name='Brute Reaper King', name_tag='Xenomorph', category='Brute Creatures',
                        entity_id='Xenomorph_Character_BP_Male_InitialBuryOnly_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/61/Brute_Reaper_King.png',
                        url='https://ark.fandom.com/wiki/Brute_Reaper_King',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Lunar/Xenomorph_Character_BP_Male_InitialBuryOnly_Hunt.Xenomorph_Character_BP_Male_InitialBuryOnly_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description=None)
    models.Creature.new(name='Brute Sarco', name_tag='Sarco', category='Brute Creatures',
                        entity_id='Sarco_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4a/Brute_Sarco.png',
                        url='https://ark.fandom.com/wiki/Brute_Sarco',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Bog/Sarco_Character_BP_Hunt.Sarco_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/70/Dossier_Sarco.png',
                        description=None)
    models.Creature.new(name='Brute Seeker', name_tag='Seeker', category='Brute Creatures',
                        entity_id='Pteroteuthis_Char_BP_HuntFollower_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Brute_Seeker.png',
                        url='https://ark.fandom.com/wiki/Brute_Seeker',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Lunar/Pteroteuthis_Char_BP_HuntFollower.Pteroteuthis_Char_BP_HuntFollower\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/71/Dossier_Seeker.png',
                        description=None)
    models.Creature.new(name='Brute Tusoteuthis', name_tag='Tusoteuthis', category='Brute Creatures',
                        entity_id='Tusoteuthis_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c6/Brute_Tusoteuthis.png',
                        url='https://ark.fandom.com/wiki/Brute_Tusoteuthis',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Tusoteuthis_Character_BP_Hunt.Tusoteuthis_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Tusoteuthis.png',
                        description=None)
    models.Creature.new(name='Brute X-Allosaurus', name_tag='Allo', category='Brute Creatures',
                        entity_id='Volcano_Allo_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/80/Brute_X-Allosaurus.png',
                        url='https://ark.fandom.com/wiki/Brute_X-Allosaurus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Volcanic/Volcano_Allo_Character_BP_Hunt.Volcano_Allo_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Allosaurus.png',
                        description="“\nSpecies\nAllosaurus therotribus\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmaller but faster than Tyrannosaurus, larger but slower than Carnotaurus, Allosaurus therotribus is the island's resident pack-hunting theropod. While most aggressive theropods are relatively solitary creatures, Allosaurus lives in groups of 3. One Allosaurus is the alpha, while the others are its mates or a beta male. Like humans find value in forming a tribe, the Allosaurus has evolved to hunt in packs. Its saw-shaped teeth leave its prey bleeding and maimed, making escape difficult. Once an Allosaurus slows a creature with its cutting bite, the rest of its pack quickly closes in for the kill.\nDomesticated\nNot everyone thinks a tamed Allosaurus is ideal. Those who appreciate speed generally tame Carnotaurus, while those who value raw stopping power tame Tyrannosaurus. However, riders of Allosaurus tend to respect the utility of its Alpha pack status, which along with its bleed-inducing attacks and relative mobility, can effectively turn the tide of a combined arms battle.\n„\n~ Helena")
    models.Creature.new(name='Brute X-Megalodon', name_tag='Mega', category='Brute Creatures',
                        entity_id='Ocean_Megalodon_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/86/Brute_X-Megalodon.png',
                        url='https://ark.fandom.com/wiki/Brute_X-Megalodon',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Ocean_Megalodon_Character_BP_Hunt.Ocean_Megalodon_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Dossier_Megalodon.png',
                        description="“\nSpecies\nCarcharodon ultramegalodon\nTime\nMiocene-Pliocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWere it not restricted to the waters, Carcharodon ultramegalodon would be one of the most dangerous creatures on the island. As powerful and dangerous as the Tyrannosaurus is on land, Megalodon is near its equal in the water. In addition, it has a speed advantage over any non-aquatic creature when submerged. Megalodons need large quantities of food to sustain themselves, so they attack most creatures immediately on sight. Smaller fish are the sole exception I've seen; I believe this is because they cost more energy for Megalodons to catch than the predator would gain.\nDomesticated\nHaving access to the resources and treasures hidden deep within the ocean is near impossible without a domesticated sea creature. The Megalodon, though difficult to domesticate, proves to be very useful when exploring the deep sea. It's not the most efficient swimmer but it should be able to protect your cargo should you find yourself in a hostile encounter.\n„\n~ Helena")
    models.Creature.new(name='Brute X-Mosasaurus', name_tag='Mosasaur', category='Brute Creatures',
                        entity_id='Ocean_Mosa_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Brute_X-Mosasaurus.png',
                        url='https://ark.fandom.com/wiki/Brute_X-Mosasaurus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Ocean_Mosa_Character_BP_Hunt.Ocean_Mosa_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d5/Dossier_Mosasaurus.png',
                        description='“\nSpecies\nMosasaurus suspirita\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUntil recently, I believed the Megalodon to be the greatest of the ocean predators. Then I discovered Mosasaurus suspirita in the deeps. Not quite as fast, but much larger and stronger, the Mosasaurus rules the darkest waters of the Island. Growing up to 50 feet long, Mosasaurus is larger than almost every other aquatic creature I\'ve encountered thus far. Mosasaurus is a deep-sea marine lizard which spends all of its time far beneath the water\'s surface. It is without a doubt one of the most fearsome creatures of the Island, and can certainly be considered among the ocean\'s apex predators.\nDomesticated\nMosasaur has proven to be an excellent tame for the most advanced tribes. Due to its sheer size and power, you will often find tribes with bases and defenses built upon a Mosasaur\'s large "platform" saddle. Having one with you as an escort is probably one of the best oceanic defenses available!\n„\n~ Helena')
    models.Creature.new(name='Brute X-Raptor', name_tag='Raptor', category='Brute Creatures',
                        entity_id='Bog_Raptor_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/Brute_X-Raptor.png',
                        url='https://ark.fandom.com/wiki/Brute_X-Raptor',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Bog/Bog_Raptor_Character_BP_Hunt.Bog_Raptor_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
                        description='“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena')
    models.Creature.new(name='Brute X-Rex', name_tag='Rex', category='Brute Creatures',
                        entity_id='Volcano_Rex_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/df/Brute_X-Rex.png',
                        url='https://ark.fandom.com/wiki/Brute_X-Rex',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Volcanic/Volcano_Rex_Character_BP_Hunt.Volcano_Rex_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
                        description='“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena')
    models.Creature.new(name='Brute X-Rock Elemental', name_tag='RockElemental', category='Brute Creatures',
                        entity_id='Volcano_Golem_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fc/Brute_X-Rock_Elemental.png',
                        url='https://ark.fandom.com/wiki/Brute_X-Rock_Elemental',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Volcanic/Volcano_Golem_Character_BP_Hunt.Volcano_Golem_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Rock_Elemental.png',
                        description="“\nSpecies\nColossus petram\nTime\nUnknown\nDiet\nMinerals\nTemperament\nExtremely Territorial\nWild\nColossus petram is like no creature I have ever encountered. There is no biological or historical precedent for it. Its nearest relatives exist only in legend – mythical statues that could come to life like the Golem of Prague. That makes it all the more dangerous. What survivor could possibly expect a seemingly benign rock formation to suddenly spring to life and attack them? Fortunately, Colossus petram's massive size makes it quite slow, so I would advise most survivors to flee immediately if encountering it in the wild. Colossus petram survives by slowly absorbing nearby minerals while in its dormant state, which consequently means that its body contains a wealth of metal ingots. If undisturbed, it can maintain this hibernation ad infinitum, but it will viciously attack anyone who encroaches upon its territory. A solitary creature, Colossus petram lives alone, and will not even protect its own kind.\nDomesticated\nIf somehow tamed, Colossus petram could prove to be an invaluable asset, particularly in a siege. Only armor piercing rounds or explosives can harm it at all, and it will handily smash through stone structures.\n„\n~ Helena")
    models.Creature.new(name='Brute X-Spino', name_tag='Spino', category='Brute Creatures',
                        entity_id='Bog_Spino_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Brute_X-Spino.png',
                        url='https://ark.fandom.com/wiki/Brute_X-Spino',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Bog/Bog_Spino_Character_BP_Hunt.Bog_Spino_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Spino.png',
                        description="“\nSpecies\nSpinosaurus aquareliga\nTime\nEarly-Late Cretaceous\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nAmong the few carnivores on the Island that can match Tyrannosaurs in size, Spinosaurus aquareliga does not match its ferocity. Spinosaurus' four legs and large sail make it fairly swift on land and incredibly fast in the water. Its marvel is, arguably, the ability to change stances by going from quadruped to biped. The creature is visually distinguished by its spectacular sail. In my travels I have seen many different and brightly coloured sails, as every Spinosaurus appears to have a slightly different palette. The one comforting fact about Spinosaurus is that it seems more at home near water than away from it. Although the creature is more powerful, faster, agile, and insatiable while in water, it tends to become less hostile as it gets farther from it. On one occasion, I only escaped a Spinosaurus by getting far enough from its lake home to make it simply lose interest.\nDomesticated\nSpinosaurus is an incredibly well-rounded apex carnivore. Faster than a Tyrannosaurus in water and able to travel on land unlike a Megalodon, its all-terrain versatility may be unrivaled. Although its movement speed is slower in a biped stance, it gains considerable attacking strength and mobility in this form. For hunters who wish to have a well-rounded mount, Spinosaurus may be the ideal choice -- if they can acquire one.\n„\n~ Helena")
    models.Creature.new(name='Brute X-Yutyrannus', name_tag='Yutyrannus', category='Brute Creatures',
                        entity_id='Snow_Yutyrannus_Character_BP_Hunt_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/05/Brute_X-Yutyrannus.png',
                        url='https://ark.fandom.com/wiki/Brute_X-Yutyrannus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Arctic/Snow_Yutyrannus_Character_BP_Hunt.Snow_Yutyrannus_Character_BP_Hunt\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Dossier_Yutyrannus.png',
                        description='“\nSpecies\nYutyrannus saevus\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThe Yutyrannus saevus is believed to be related to the Tyrannosaurus rex, but it is noticeably different upon first glance. Feathered creatures are not necessarily viewed as dangerous predators in the same light as other theropods. However, the Yutyrannus strikes fear into even the Island\'s most skilled hunters. There are few wild predators that are able to pack-hunt alongside the generally hostile Carnotaurus, like the Yutyrannus does, with such ease. It is also the only creature I\'ve seen to consistently induce a state of panic in opponents with its roar. Upon hearing it, most creatures in the area will flee for safety.\nDomesticated\nA domesticated Yutyrannus can be a powerful offensive or defensive addition to war parties. With its mighty roar, it can induce fear in opposing creatures. Meanwhile, Yutyrannus can be trained to develop a confidence-boosting Battle-Cry which counteracts enemy attempts to induce fear, while also bolstering the resolve of allies, and may even draw wild Carnotaurus to its aid. These unique "leadership" qualities make the Yutyrannus a versatile, and at times, a necessary creature to have on your side during large-scale confrontations!\n„\n~ Helena')
    models.Creature.new(name='Corrupted Avatar', name_tag='?', category='Mammals', entity_id='Bot_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7a/Corrupted_Avatar_Helmet_Skin_%28Genesis_Part_1%29.png',
                        url='https://ark.fandom.com/wiki/Corrupted_Avatar',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/Bots/Bot_Character_BP.Bot_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fa/Corrupted_Avatar.png',
                        description=None)
    models.Creature.new(name='Eel Minion', name_tag=None, category='Fantasy Creatures',
                        entity_id='EelMinion_Character_BP_Easy_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a0/Electrophorus.png',
                        url='https://ark.fandom.com/wiki/Eel_Minion',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/EelBoss/EelMinion_Character_BP_Easy.EelMinion_Character_BP_Easy\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Dossier_Electrophorus.png',
                        description=None)
    models.Creature.new(name='Gamma Corrupted Master Controller', name_tag=None, category='Bosses',
                        entity_id='VRMainBoss_Character_Easy_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Corrupted_Master_Controller.png',
                        url='https://ark.fandom.com/wiki/Gamma_Corrupted_Master_Controller',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/VRMainBoss/VRMainBoss_Character_Easy.VRMainBoss_Character_Easy\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Corrupted_Master_Controller_Image.jpg',
                        description=None)
    models.Creature.new(name='Gamma Moeder, Master of the Ocean', name_tag='EelBoss', category='Bosses',
                        entity_id='EelBoss_Character_BP_Easy_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bd/Moeder%2C_Master_of_the_Ocean.png',
                        url='https://ark.fandom.com/wiki/Gamma_Moeder,_Master_of_the_Ocean',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/EelBoss/EelBoss_Character_BP_Easy.EelBoss_Character_BP_Easy\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Genesis_17.jpg',
                        description=None)
    models.Creature.new(name='Golden Striped Brute Megalodon', name_tag='Mega', category='Brute Creatures',
                        entity_id='Ocean_Megalodon_Character_BP_Retrieve_Brute_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9a/Golden_Striped_Brute_Megalodon.png',
                        url='https://ark.fandom.com/wiki/Golden_Striped_Brute_Megalodon',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Retrieve/Ocean/Ocean_Megalodon_Character_BP_Retrieve_Brute.Ocean_Megalodon_Character_BP_Retrieve_Brute\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ea/Golden_Striped_Megalodon_Image.jpg',
                        description=None)
    models.Creature.new(name='Golden Striped Megalodon', name_tag='Mega', category='X-Creatures',
                        entity_id='Ocean_Megalodon_Character_BP_Retrieve_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Golden_Striped_Megalodon.png',
                        url='https://ark.fandom.com/wiki/Golden_Striped_Megalodon',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Retrieve/Ocean/Ocean_Megalodon_Character_BP_Retrieve.Ocean_Megalodon_Character_BP_Retrieve\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ea/Golden_Striped_Megalodon_Image.jpg',
                        description=None)
    models.Creature.new(name='Ferox (Large)', name_tag='Bigly', category='Fantasy Creatures',
                        entity_id='Shapeshifter_Large_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Ferox.png',
                        url='https://ark.fandom.com/wiki/Ferox_(Large)',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/Shapeshifter/Shapeshifter_Large/Shapeshifter_Large_Character_BP.Shapeshifter_Large_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2b/Ferox_Image.jpg',
                        description=None)
    models.Creature.new(name='Ferox', name_tag='Gremlin', category='Fantasy Creatures',
                        entity_id='Shapeshifter_Small_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Ferox.png',
                        url='https://ark.fandom.com/wiki/Ferox',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/Shapeshifter/Shapeshifter_Small/Shapeshifter_Small_Character_BP.Shapeshifter_Small_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2b/Ferox_Image.jpg',
                        description=None)
    models.Creature.new(name='Injured Brute Reaper King', name_tag='Xenomorph', category='Brute Creatures',
                        entity_id='Xenomorph_Character_BP_Male_InitialBuryOnly_Brute_Retrieve_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/44/Injured_Brute_Reaper_King.png',
                        url='https://ark.fandom.com/wiki/Injured_Brute_Reaper_King',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Retrieve/Lunar/Xenomorph_Character_BP_Male_InitialBuryOnly_Brute_Retrieve.Xenomorph_Character_BP_Male_InitialBuryOnly_Brute_Retrieve\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description=None)
    models.Creature.new(name='Insect Swarm', name_tag='InsectSwarm', category='Fantasy Creatures',
                        entity_id='InsectSwarmChar_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a7/Insect_Swarm.png',
                        url='https://ark.fandom.com/wiki/Insect_Swarm',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/Swarms/InsectSwarmChar_BP.InsectSwarmChar_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Genesis_29.jpg',
                        description=None)
    models.Creature.new(name='Magmasaur', name_tag='LavaLizard', category='Fantasy Creatures',
                        entity_id='Cherufe_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/35/Magmasaur.png',
                        url='https://ark.fandom.com/wiki/Magmasaur',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/Cherufe/Cherufe_Character_BP.Cherufe_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Magmasaur_Image.jpg',
                        description=None)
    models.Creature.new(name='Malfunctioned Tek Giganotosaurus Gauntlet', name_tag='Gigant',
                        category='Malfunctioned Tek Creatures',
                        entity_id='BionicGigant_Character_BP_Malfunctioned_Gauntlet_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Giganotosaurus.png',
                        url='https://ark.fandom.com/wiki/Malfunctioned_Tek_Giganotosaurus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Gauntlet/Lunar/BionicGigant_Character_BP_Malfunctioned_Gauntlet.BionicGigant_Character_BP_Malfunctioned_Gauntlet\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
                        description='“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena')
    models.Creature.new(name='Malfunctioned Tek Giganotosaurus', name_tag='Gigant',
                        category='Malfunctioned Tek Creatures',
                        entity_id='BionicGigant_Character_BP_Malfunctioned_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Giganotosaurus.png',
                        url='https://ark.fandom.com/wiki/Malfunctioned_Tek_Giganotosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Giganotosaurus/BionicGigant_Character_BP_Malfunctioned.BionicGigant_Character_BP_Malfunctioned\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
                        description='“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena')
    models.Creature.new(name='Malfunctioned Tek Parasaur', name_tag='Para', category='Malfunctioned Tek Creatures',
                        entity_id='BionicPara_Character_BP_Malfunctioned_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Parasaur.png',
                        url='https://ark.fandom.com/wiki/Malfunctioned_Tek_Parasaur',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Para/BionicPara_Character_BP_Malfunctioned.BionicPara_Character_BP_Malfunctioned\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Dossier_Parasaur.png',
                        description="“\nSpecies\nParasaurolophus amphibio\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nParasaurolophus amphibio has one of the more interesting adaptations of any creature I've seen on the Island. Like all Parasaur, it has a signature crest on its head. Very docile at first, I've been able to approach the creature without disturbing it. If startled, however, the creature can vocalize a distress call to the surrounding area that warns of danger. Parasaurolophus appears to be low on the food chain and is hunted by everything, creatures and humans alike, which explains its skittish nature. It is a good source of meat and hide, if you can manage to keep up with it long enough to kill it.\nDomesticated\nDespite being what most tribes consider a relatively useless creature to tame, I once met an interesting woman who had tamed an entire herd of them. She informed me that many overlooked the creature's potential. She even graciously gifted me a fancy saddle to put on my own Parasaurolophus one day. As a relatively simple creature to domesticate, Parasaurolophus is commonly one of the first mounts a tribe will be able to acquire. Its ability to run relatively fast for lengthy intervals makes it a solid mode of medium-range transportation, though it has almost no ability to defend itself or its rider in a traditional sense. Smaller creatures, however, appear to be frightened by the horn of Parasaurolophus although it doesn't do much damage. It also has decent weight-bearing capabilities, which could prove useful for nomadic tribes as they work to establish a presence on the Island.\n„\n~ Helena")
    models.Creature.new(name='Malfunctioned Tek Quetzal', name_tag='Quetz', category='Malfunctioned Tek Creatures',
                        entity_id='BionicQuetz_Character_BP_Malfunctioned_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Mod_Primal_Fear_Tek_Quetzal_Icon_Image.png',
                        url='https://ark.fandom.com/wiki/Malfunctioned_Tek_Quetzal',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Quetzalcoatlus/BionicQuetz_Character_BP_Malfunctioned.BionicQuetz_Character_BP_Malfunctioned\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9d/Quetzal.png',
                        description="“\nSpecies\nQuetzalcoatlus conchapicem\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nFrom afar, it's hard to believe that Quetzalcoatlus is one of the largest avians on the island. It shares a similar silhouette with the Pteranodon, and nests near the absolute highest peaks. Upon closer inspection, though, Quetzalcoatlus is an enormous creature of tremendous power. I find it strange that such a large, imposing beast would be so skittish. Unlike other creatures of its size, it is more likely to flee than fight. I suppose the decision to flee from any trouble keeps the species alive on an island with so many dangerous predators. But then how does it eat enough to sustain its massive size?\nDomesticated\nTamed Quetzalcoatlus have a very specific role on the island. Too slow to be an efficient local transport, and too weak to be an effective warbird, the tribes I have encountered tend to employ it as a mass carrier. Quetzalcoatlus is primarily used by these masters of the skies to safely carry vast quantities of supplies, creatures and human cargo from one base to another without tiring.\n„\n~ Helena")
    models.Creature.new(name='Malfunctioned Tek Raptor', name_tag='Raptor', category='Malfunctioned Tek Creatures',
                        entity_id='BionicRaptor_Character_BP_Malfunctioned_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Mod_Primal_Fear_Tek_Raptor_Icon_Image.png',
                        url='https://ark.fandom.com/wiki/Malfunctioned_Tek_Raptor',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Raptor/BionicRaptor_Character_BP_Malfunctioned.BionicRaptor_Character_BP_Malfunctioned\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/45/Mod_Primal_Fear_Primal_Tek_Raptor.jpg',
                        description='“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena')
    models.Creature.new(name='Malfunctioned Tek Rex', name_tag='Rex', category='Malfunctioned Tek Creatures',
                        entity_id='BionicRex_Character_BP_Malfunctioned_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Rex.png',
                        url='https://ark.fandom.com/wiki/Malfunctioned_Tek_Rex',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Rex/BionicRex_Character_BP_Malfunctioned.BionicRex_Character_BP_Malfunctioned\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Tek_Rex_PaintRegion5.png',
                        description='“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena')
    models.Creature.new(name='Malfunctioned Tek Stegosaurus', name_tag='Stego', category='Malfunctioned Tek Creatures',
                        entity_id='BionicStego_Character_BP_Malfunctioned_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Stegosaurus.png',
                        url='https://ark.fandom.com/wiki/Malfunctioned_Tek_Stegosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Stego/BionicStego_Character_BP_Malfunctioned.BionicStego_Character_BP_Malfunctioned\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Dossier_Stegosaurus.png',
                        description="“\nSpecies\nStegosaurus regium\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nDocile\nWild\nStegosaurus regium has approximately 16 paired rows of plates along its back, flanked by another, smaller pair of 6 plates. This is contrary to the alternating rows on Stegosaurus fossils I've seen in museums. Not surprisingly, Stegosaurus uses the spines on its tail to defend itself. While not aggressive, Stegosaurus will come to the aid of another nearby Stegosaurus. This implies it to be a herd animal.\nDomesticated\nStegosaurus is commonly used as a safe way to transport large quantities of goods. And once you saddle one up, not even an Argentavis could knock you off that perch. A stegosaurus can be trained to flex its back plates for different purposes: hardened to shield it from attack, in a heavier alignment that deals crippling blows, or oriented more sharply to pierce armor. These various plate configurations also come in handy for stripping wood from trees, gathering thatch, or foraging for wild berries, respectively. Stegosaurus can knock back or impale with a whip of its spiky tail, keeping predators at bay or pinning them in place. Its spiked appendage also helps for gathering berries—go figure.\n„\n~ Helena")
    models.Creature.new(name='Malfunctioned Tek Triceratops', name_tag='Trike', category='Malfunctioned Tek Creatures',
                        entity_id='BionicTrike_Character_BP_Malfunctioned_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
                        url='https://ark.fandom.com/wiki/Malfunctioned_Tek_Triceratops',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Trike/BionicTrike_Character_BP_Malfunctioned.BionicTrike_Character_BP_Malfunctioned\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Mod_Primal_Fear_Primal_Tek_Trike.jpg',
                        description="“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena")
    models.Creature.new(name='Megachelon', name_tag='GiantTurtle', category='Fantasy Creatures',
                        entity_id='GiantTurtle_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a4/Megachelon.png',
                        url='https://ark.fandom.com/wiki/Megachelon',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/GiantTurtle/GiantTurtle_Character_BP.GiantTurtle_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/48/Genesis_3.jpg',
                        description=None)
    models.Creature.new(name='Parakeet Fish School', name_tag='Swarm', category='Fantasy Creatures',
                        entity_id='MicrobeSwarmChar_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c4/Parakeet_Fish_School.png',
                        url='https://ark.fandom.com/wiki/Parakeet_Fish_School',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/Swarms/MicrobeSwarmChar_BP.MicrobeSwarmChar_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b7/Parakeet_Fish_School_Image.jpg',
                        description=None)
    models.Creature.new(name='Reaper Prince', name_tag='Xenomorph', category='Fantasy Creatures',
                        entity_id='Xenomorph_Character_BP_Male_InitialBuryOnly_Adolescent_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
                        url='https://ark.fandom.com/wiki/Reaper_Prince',
                        blueprint='"Blueprint\'/Game/Aberration/Dinos/Nameless/Xenomorph_Character_BP_Male_InitialBuryOnly_Adolescent.Xenomorph_Character_BP_Male_InitialBuryOnly_Adolescent\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description="“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena")
    models.Creature.new(name='Tek Triceratops', name_tag='Trike', category='Tek Creatures',
                        entity_id='BionicTrike_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
                        url='https://ark.fandom.com/wiki/Tek_Triceratops',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Trike/BionicTrike_Character_BP.BionicTrike_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Mod_Primal_Fear_Primal_Tek_Trike.jpg',
                        description="“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena")
    models.Creature.new(name='X-Allosaurus', name_tag='Allo', category='X-Creatures',
                        entity_id='Volcano_Allo_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Allosaurus.png',
                        url='https://ark.fandom.com/wiki/X-Allosaurus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Volcano_Allosaurus/Volcano_Allo_Character_BP.Volcano_Allo_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Allosaurus.png',
                        description="“\nSpecies\nAllosaurus therotribus\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmaller but faster than Tyrannosaurus, larger but slower than Carnotaurus, Allosaurus therotribus is the island's resident pack-hunting theropod. While most aggressive theropods are relatively solitary creatures, Allosaurus lives in groups of 3. One Allosaurus is the alpha, while the others are its mates or a beta male. Like humans find value in forming a tribe, the Allosaurus has evolved to hunt in packs. Its saw-shaped teeth leave its prey bleeding and maimed, making escape difficult. Once an Allosaurus slows a creature with its cutting bite, the rest of its pack quickly closes in for the kill.\nDomesticated\nNot everyone thinks a tamed Allosaurus is ideal. Those who appreciate speed generally tame Carnotaurus, while those who value raw stopping power tame Tyrannosaurus. However, riders of Allosaurus tend to respect the utility of its Alpha pack status, which along with its bleed-inducing attacks and relative mobility, can effectively turn the tide of a combined arms battle.\n„\n~ Helena")
    models.Creature.new(name='X-Ankylosaurus', name_tag='Anky', category='X-Creatures',
                        entity_id='Volcano_Ankylo_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a7/Ankylosaurus.png',
                        url='https://ark.fandom.com/wiki/X-Ankylosaurus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Volcano_Ankylosaurus/Volcano_Ankylo_Character_BP.Volcano_Ankylo_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8e/Dossier_Ankylosaurus.png',
                        description="“\nSpecies\nAnkylosaurus crassacutis\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nDocile\nWild\nUnlike many of the herd animals on the Island, Ankylosaurus crassacutis tends to live in small family units. I believe they can afford to stick with smaller groups because of their incredibly thick skin, for which they're named. Despite not being among the largest of the Island's herbivores, Ankylosaurus is one of the more difficult creatures to take down. Its thick, armored skin seems to make it more than a match for several of the mid-sized predators that would otherwise hunt it. Reckless carnivores are just as likely to hurt themselves on Ankylosaurus' spikes, as they are to get hit by its tail.\nDomesticated\nWithout a doubt, the best trait of a trained Ankylosaurus is its enormously dense tail. This tail is powerful enough to quickly shatter the resource-laden rocks of the Island. One of the wealthier human tribes on the island utilizes a squad of Ankylosaurs in its mines and quarries. The creature's affinity for metal enables it to carry raw ore at an effectively reduced weight.\n„\n~ Helena")
    models.Creature.new(name='X-Argentavis', name_tag='Argent', category='X-Creatures',
                        entity_id='Snow_Argent_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Argentavis.png',
                        url='https://ark.fandom.com/wiki/X-Argentavis',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Snow_Argentavis/Snow_Argent_Character_BP.Snow_Argent_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Dossier_Argentavis.png',
                        description="“\nSpecies\nArgentavis atrocollum\nTime\nLate Miocene\nDiet\nCarrion-Feeder\nTemperament\nShort-Tempered\nWild\nLording over the skies across the Island, Argentavis atrocollum has few aerial rivals. It is a small consolation for the Island's other avian creatures, then, that Argentavis seems to have little interest in anything alive. Quite apart from what I would have guessed, Argentavis does not have the stooped neck typical of modern buzzards and vultures. I don't know if it adapted this stronger neck to deal with the predators on the Island, or if its lineage derives from before the stooped neck became common in carrion-eating birds. Whichever it meant to be, it has enabled Argentavis to carry smaller creatures with its beak.\nDomesticated\nArgentavis is actually slower than the Island's far more common Pteranodon, but it possesses significantly more stamina and can sustain flight for approximately three times as long. Its weighty stature, in comparison to the Pteranodon, allows it to utilize its talons to support the weight of an additional passenger. Considering its saddle doubles as a mobile crafting station, it makes Argentavis an excellent creature for traveling and hauling cargo over long distances.\n„\n~ Helena")
    models.Creature.new(name='X-Basilosaurus', name_tag='Basilosaurus', category='X-Creatures',
                        entity_id='Ocean_Basilosaurus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Basilosaurus.png',
                        url='https://ark.fandom.com/wiki/X-Basilosaurus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Ocean_Basilosaurus/Ocean_Basilosaurus_Character_BP.Ocean_Basilosaurus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Dossier_Basilosaurus.png',
                        description='“\nSpecies\nBasilosaurus solatiumfecit\nTime\nLate Eocene\nDiet\nPiscivore\nTemperament\nPassive\nWild\nOne of the stranger creatures in the waters surrounding the Island is Basilosaurus solatiumfecit. It\'s a powerful swimmer which has adapted to the shallows so remarkably well that it rapidly recovers from injuries when near the water\'s surface. Conversely, it\'s vulnerable to deep water pressure, which slowly causes it harm. Basilosaurus is usually closely followed by other predatory creatures, as its eating habits leave plenty of scraps for scavengers to consume. It is a gentle creature towards humans and happily laps up food directly from them. However, the creatures that trail the "Basi" tend to become dangerously enraged whenever this occurs, as it leaves no leftovers for them.\nDomesticated\nDespite the hassle of engaging with its ornery followers, many tribes still attempt to tame the Basilosaurus, as its mammalian, warm-blooded circulation provides a rider with perfect comfort from both heat and cold. Being apprehensive in nature, Basilosaurus is equipped with a defense mechanism that prevents it from being stunned or shocked. Alternatively, Basilosaurus is hunted (perhaps too vigorously) for its special blubber, which can be efficiently refined into gasoline!\n„\n~ Helena')
    models.Creature.new(name='X-Dunkleosteus', name_tag='Dunkle', category='X-Creatures',
                        entity_id='Ocean_Dunkle_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e5/Dunkleosteus.png',
                        url='https://ark.fandom.com/wiki/X-Dunkleosteus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Ocean_Dunkleosteus/Ocean_Dunkle_Character_BP.Ocean_Dunkle_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3d/Dossier_Dunkleosteus.png',
                        description="“\nSpecies\nDunkleosteus loricaruptor\nTime\nLate Devonian\nDiet\nCarnivore\nTemperament\nDocile\nWild\nDunkleosteus loricaruptor is a very strange creature. It is a fairly large fish, covered head to tail in armored plates, with incredibly powerful jaws. It tends to eat the Island's water-dwelling crustaceans trawling the seabed, as it is not fast enough to catch most of the smaller fish. Dunkleosteus is surprisingly combat-oriented for a fish. Its well-armored body protects it from many creatures, while its bite is strong enough to easily crush through chitinous shells.\nDomesticated\nDunkleosteus is an incredibly useful fish for coastal communities. Its powerful jaws make short work of the stone and oil formations found throughout the oceanic depths. While harvesting, Dunkleosteus can defend its rider from all but the largest threats in the waters. And once it is past its prime, the Dunkleosteus itself can be harvested for a fair amount of chitin.\n„\n~ Helena")
    models.Creature.new(name='X-Ichthyosaurus', name_tag='Dolphin', category='X-Creatures',
                        entity_id='Ocean_Dolphin_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/89/Ichthyosaurus.png',
                        url='https://ark.fandom.com/wiki/X-Ichthyosaurus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Ocean_Dolphin/Ocean_Dolphin_Character_BP.Ocean_Dolphin_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Dossier_Ichthyosaurus.png',
                        description='“\nSpecies\nIchthyosaurus curiosa\nTime\nLate Triassic - Early Jurassic\nDiet\nCarnivore\nTemperament\nCurious\nWild\nIchthyosaurus curiosa is a comparatively small carnivore found in the waters around the island. It is slightly larger than a human, but that’s still small compared to the leviathans roaming these waters. It seems to be very interested in any creature around its size, often approaching and following humans swimming through its waters. Despite its appearance, the Ichthyosaurus is neither a fish nor an ocean mammal. Like many creatures in the waters around the island, it is actually an aquatic reptile.\nDomesticated\nI can’t think of a better mount for someone starting to explore the island’s seas and waterways. Ichthyosaurus is comparatively fast swimmer, and even in the wild will cozy right up to you and try to figure out what you’re doing. Taming these is actually pretty easy, as they seem to love humans and will be fed and tamed without the use of violence.\n„\n~ Helena')
    models.Creature.new(name='X-Megalodon', name_tag='Mega', category='X-Creatures',
                        entity_id='Ocean_Megalodon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Megalodon.png',
                        url='https://ark.fandom.com/wiki/X-Megalodon',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Ocean_Megalodon/Ocean_Megalodon_Character_BP.Ocean_Megalodon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Dossier_Megalodon.png',
                        description="“\nSpecies\nCarcharodon ultramegalodon\nTime\nMiocene-Pliocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWere it not restricted to the waters, Carcharodon ultramegalodon would be one of the most dangerous creatures on the island. As powerful and dangerous as the Tyrannosaurus is on land, Megalodon is near its equal in the water. In addition, it has a speed advantage over any non-aquatic creature when submerged. Megalodons need large quantities of food to sustain themselves, so they attack most creatures immediately on sight. Smaller fish are the sole exception I've seen; I believe this is because they cost more energy for Megalodons to catch than the predator would gain.\nDomesticated\nHaving access to the resources and treasures hidden deep within the ocean is near impossible without a domesticated sea creature. The Megalodon, though difficult to domesticate, proves to be very useful when exploring the deep sea. It's not the most efficient swimmer but it should be able to protect your cargo should you find yourself in a hostile encounter.\n„\n~ Helena")
    models.Creature.new(name='X-Mosasaurus', name_tag='Mosasaur', category='X-Creatures',
                        entity_id='Ocean_Mosa_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Mosasaurus.png',
                        url='https://ark.fandom.com/wiki/X-Mosasaurus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Ocean_Mosasaurus/Ocean_Mosa_Character_BP.Ocean_Mosa_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d5/Dossier_Mosasaurus.png',
                        description='“\nSpecies\nMosasaurus suspirita\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUntil recently, I believed the Megalodon to be the greatest of the ocean predators. Then I discovered Mosasaurus suspirita in the deeps. Not quite as fast, but much larger and stronger, the Mosasaurus rules the darkest waters of the Island. Growing up to 50 feet long, Mosasaurus is larger than almost every other aquatic creature I\'ve encountered thus far. Mosasaurus is a deep-sea marine lizard which spends all of its time far beneath the water\'s surface. It is without a doubt one of the most fearsome creatures of the Island, and can certainly be considered among the ocean\'s apex predators.\nDomesticated\nMosasaur has proven to be an excellent tame for the most advanced tribes. Due to its sheer size and power, you will often find tribes with bases and defenses built upon a Mosasaur\'s large "platform" saddle. Having one with you as an escort is probably one of the best oceanic defenses available!\n„\n~ Helena')
    models.Creature.new(name='X-Otter', name_tag='Otter', category='X-Creatures', entity_id='Snow_Otter_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9f/Otter.png',
                        url='https://ark.fandom.com/wiki/X-Otter',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Snow_Otter/Snow_Otter_Character_BP.Snow_Otter_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Dossier_Otter.png',
                        description='“\nSpecies\nLutra peloso\nTime\nEarly Miocene\nDiet\nOmnivore\nTemperament\nFriendly\nWild\nFound along the Island’s many inland waterways, Lutra Peloso have become exceptionally adept at hunting and foraging. This species of Otter has to be particularly cunning because of its diminutive size, and fierce competition for its preferred food source: fish. It is not a creature that excels at combat, and would not naturally pose an intimidating threat to any predators. Finding packs of river Otters is simple enough: They are distinguished by their elongated bodies, bushy tails, and webbed feet. Their trusting and inquisitive nature ensures they are often hunted for their lustrous fur, but many prefer to tame them to become trusted companions.\nDomesticated\nThere are few creatures which provide the companionship that Lutra Peloso does. Rather than traveling beside you, it would prefer to comfortably rest on your back, providing insulation. Once domesticated, it can be told to harvest fish on demand, with a specific goal in mind from the fish that it consumes, the otter has a knack for foraging silica pearls, and can even yield a slight chance at finding black pearls within!\n„\n~ Helena')
    models.Creature.new(name='X-Paraceratherium', name_tag='Paracer', category='X-Creatures',
                        entity_id='Bog_Paracer_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e1/Paraceratherium.png',
                        url='https://ark.fandom.com/wiki/X-Paraceratherium',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/BogParaceratherium/Bog_Paracer_Character_BP.Bog_Paracer_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Paraceratherium.png',
                        description='“\nSpecies\nParaceratherium gigamicus\nTime\nOligocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nParaceratherium gigamicus is a massive, long-necked herbivore that inhabits some of the Island\'s grasslands. It resembles a gigantic horse/rhinoceros hybrid, but is over twice the size of either. Paraceratherium is a very peaceful and friendly creature. Barring some surprises yet in store for me, I can safely say that Paraceratherium is among the largest mammals on the Island. While its size means that Paraceratherium can provide an incredible amount of food, it also makes it dangerous when hunted.\nDomesticated\nA beast of burden second to the Brontosaurus, Paraceratherium is an excellent worker, and is sufficient in size to support a "platform" saddle upon which structures can be built. It is a naturally friendly animal, and is not afraid of humans. However, despite its normally calm demeanor, when it or its owner is provoked by aggression, the Paraceratherium can quickly become a real threat to the attacker and will use its girth to its advantage in combat.\n„\n~ Helena')
    models.Creature.new(name='X-Parasaur', name_tag='Para', category='X-Creatures', entity_id='Bog_Para_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Parasaur.png',
                        url='https://ark.fandom.com/wiki/X-Parasaur',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/BogPara/Bog_Para_Character_BP.Bog_Para_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Dossier_Parasaur.png',
                        description="“\nSpecies\nParasaurolophus amphibio\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nParasaurolophus amphibio has one of the more interesting adaptations of any creature I've seen on the Island. Like all Parasaur, it has a signature crest on its head. Very docile at first, I've been able to approach the creature without disturbing it. If startled, however, the creature can vocalize a distress call to the surrounding area that warns of danger. Parasaurolophus appears to be low on the food chain and is hunted by everything, creatures and humans alike, which explains its skittish nature. It is a good source of meat and hide, if you can manage to keep up with it long enough to kill it.\nDomesticated\nDespite being what most tribes consider a relatively useless creature to tame, I once met an interesting woman who had tamed an entire herd of them. She informed me that many overlooked the creature's potential. She even graciously gifted me a fancy saddle to put on my own Parasaurolophus one day. As a relatively simple creature to domesticate, Parasaurolophus is commonly one of the first mounts a tribe will be able to acquire. Its ability to run relatively fast for lengthy intervals makes it a solid mode of medium-range transportation, though it has almost no ability to defend itself or its rider in a traditional sense. Smaller creatures, however, appear to be frightened by the horn of Parasaurolophus although it doesn't do much damage. It also has decent weight-bearing capabilities, which could prove useful for nomadic tribes as they work to establish a presence on the Island.\n„\n~ Helena")
    models.Creature.new(name='X-Raptor', name_tag='Raptor', category='X-Creatures',
                        entity_id='Bog_Raptor_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/08/Raptor.png',
                        url='https://ark.fandom.com/wiki/X-Raptor',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Bog_Raptor/Bog_Raptor_Character_BP.Bog_Raptor_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
                        description='“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena')
    models.Creature.new(name='X-Rex', name_tag='Rex', category='X-Creatures', entity_id='Volcano_Rex_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Rex.png',
                        url='https://ark.fandom.com/wiki/X-Rex',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Volcano_Rex/Volcano_Rex_Character_BP.Volcano_Rex_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
                        description='“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena')
    models.Creature.new(name='X-Rock Elemental', name_tag='RockElemental', category='X-Creatures',
                        entity_id='Volcano_Golem_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f0/Rock_Elemental.png',
                        url='https://ark.fandom.com/wiki/X-Rock_Elemental',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Lava_Golem/Volcano_Golem_Character_BP.Volcano_Golem_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Rock_Elemental.png',
                        description="“\nSpecies\nColossus petram\nTime\nUnknown\nDiet\nMinerals\nTemperament\nExtremely Territorial\nWild\nColossus petram is like no creature I have ever encountered. There is no biological or historical precedent for it. Its nearest relatives exist only in legend – mythical statues that could come to life like the Golem of Prague. That makes it all the more dangerous. What survivor could possibly expect a seemingly benign rock formation to suddenly spring to life and attack them? Fortunately, Colossus petram's massive size makes it quite slow, so I would advise most survivors to flee immediately if encountering it in the wild. Colossus petram survives by slowly absorbing nearby minerals while in its dormant state, which consequently means that its body contains a wealth of metal ingots. If undisturbed, it can maintain this hibernation ad infinitum, but it will viciously attack anyone who encroaches upon its territory. A solitary creature, Colossus petram lives alone, and will not even protect its own kind.\nDomesticated\nIf somehow tamed, Colossus petram could prove to be an invaluable asset, particularly in a siege. Only armor piercing rounds or explosives can harm it at all, and it will handily smash through stone structures.\n„\n~ Helena")
    models.Creature.new(name='X-Sabertooth', name_tag='Sabertooth', category='X-Creatures',
                        entity_id='Snow_Saber_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a4/Sabertooth.png',
                        url='https://ark.fandom.com/wiki/X-Sabertooth',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Snow_Saber/Snow_Saber_Character_BP.Snow_Saber_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Dossier_Sabertooth.png',
                        description="“\nSpecies\nSmilodon brutalis\nTime\nEarly Pleistocene/Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmilodon brutalis is a solitary hunter, generally found in cold, lightly wooded areas. The Island's mountains are the perfect habitat, as the mammal's fur keeps it safe from the bitter temperature. While its huge fangs are excellent for delivering deathblows, the creature's claws can be just as deadly. Despite normally being a solitary creature, Smilodon brutalis are not opposed to hunting in small packs. In fact, they have to do this to take down larger prey such as Mammoths. Enough Sabertooths can take down a Carnotaurus, perhaps even a Tyrannosaurus. Either way, Smilodon brutalis should not be underestimated.\nDomesticated\nWhile not as fast as Raptors, there's no denying the Sabertooth's increased resilience and power. In addition, well-trained Sabertooth can be taught to use their claws to flay corpses. This may sound morbid, but it is among the best ways to quickly gather large quantities of hide from the giant beasts of the Island.\n„\n~ Helena")
    models.Creature.new(name='X-Sabertooth Salmon', name_tag='Salmon', category='X-Creatures',
                        entity_id='Lunar_Salmon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e0/Salmon.png',
                        url='https://ark.fandom.com/wiki/X-Sabertooth_Salmon',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Lunar_Salmon/Lunar_Salmon_Character_BP.Lunar_Salmon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0c/Dossier_Sabertooth_Salmon.png',
                        description='“\nSpecies\nOncorhynchus grexlamia\nTime\nLate Miocene - Mid Pleistocene\nDiet\nCarnivore\nTemperament\nEvasive, Aggressive when attacked\nWild\nFairly unremarkable by the Island\'s standards, Oncorhynchus grexlamia is a generally passive fish. Its main form of protection is swimming in a large school. Oncorhynchus does not like conflict, and generally swims away from anything larger than itself at very high speeds. Once provoked, however, Oncorhynchus becomes quite aggressive, along with its nearby brethren. It locks onto its prey with its long "saberteeth" and begins draining that creature\'s blood. This loss of blood is not too dangerous alone, but when a school of Oncorhynchus attack at once, their target quickly loses speed and stamina from blood loss, drowning if it cannot breath underwater.\nDomesticated\nLike many of the smaller fish found on or around the Island, Oncorhynchus cannot be tamed, but it is often herded and harvested for its resources. In particular, certain cuts of Oncorhynchus meat are considered to have superb quality, and are often referred to as "Prime Fish" used for specific high-end concoctions and taming the Island\'s many piscivorous creatures.\n„\n~ Helena')
    models.Creature.new(name='X-Spino', name_tag='Spino', category='X-Creatures', entity_id='Bog_Spino_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/03/Spino.png',
                        url='https://ark.fandom.com/wiki/X-Spino',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Bog_Spino/Bog_Spino_Character_BP.Bog_Spino_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Spino.png',
                        description="“\nSpecies\nSpinosaurus aquareliga\nTime\nEarly-Late Cretaceous\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nAmong the few carnivores on the Island that can match Tyrannosaurs in size, Spinosaurus aquareliga does not match its ferocity. Spinosaurus' four legs and large sail make it fairly swift on land and incredibly fast in the water. Its marvel is, arguably, the ability to change stances by going from quadruped to biped. The creature is visually distinguished by its spectacular sail. In my travels I have seen many different and brightly coloured sails, as every Spinosaurus appears to have a slightly different palette. The one comforting fact about Spinosaurus is that it seems more at home near water than away from it. Although the creature is more powerful, faster, agile, and insatiable while in water, it tends to become less hostile as it gets farther from it. On one occasion, I only escaped a Spinosaurus by getting far enough from its lake home to make it simply lose interest.\nDomesticated\nSpinosaurus is an incredibly well-rounded apex carnivore. Faster than a Tyrannosaurus in water and able to travel on land unlike a Megalodon, its all-terrain versatility may be unrivaled. Although its movement speed is slower in a biped stance, it gains considerable attacking strength and mobility in this form. For hunters who wish to have a well-rounded mount, Spinosaurus may be the ideal choice -- if they can acquire one.\n„\n~ Helena")
    models.Creature.new(name='X-Tapejara', name_tag='Tapejara', category='X-Creatures',
                        entity_id='Bog_Tapejara_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Tapejara.png',
                        url='https://ark.fandom.com/wiki/X-Tapejara',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Bog_Tapejara/Bog_Tapejara_Character_BP.Bog_Tapejara_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Tapejara.png',
                        description="“\nSpecies\nTapejara imperator\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nTapejara imperator is a marvel to watch in the wild. It has astonishing agility compared to the Island's other flyers thanks in large part to the rudder-like fin that extends from its snout to the back of its skull. Initially, I'd thought the fin was simply composed of keratin, but closer inspection has led me to believe that it is actually some kind of sensory organ. Not only does it decrease Tapejara's turning radius even at high speeds, but it apparently provides Tapejara with extra information to help it fly through the air with unparalleled grace. I've even seen Tapejara hover and strafe side-to-side in the air without moving forward at all. It's quite remarkable. The creature also makes effective use of razor-sharp claws to latch onto surfaces such as the trunks of tall trees, holding its position indefinitely.\nDomesticated\nWarlike tribes appear to consider Tapejara the equivalent of a versatile rotor aircraft, capable of rapid positional changes and aggressive agility. When domesticated the Tapejara is typically outfitted with a unique triple-rider saddle, enabling two passengers to wield handheld weaponry while the pilot takes the reins. When the Tapejara is latched onto a surface, both the passengers and pilot are able to make full use of their weapons together! Evidently what this skittering creature lacks in distance-stamina, constitution, and weight carrying capacity, it makes up for in maneuverability and combat versatility.\n„\n~ Helena")
    models.Creature.new(name='X-Triceratops', name_tag='Trike', category='X-Creatures',
                        entity_id='Volcano_Trike_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
                        url='https://ark.fandom.com/wiki/X-Triceratops',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Volcano_Trike/Volcano_Trike_Character_BP.Volcano_Trike_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Triceratops.png',
                        description="“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena")
    models.Creature.new(name='X-Woolly Rhino', name_tag='Rhino', category='X-Creatures',
                        entity_id='Snow_Rhino_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d4/Woolly_Rhinoceros.png',
                        url='https://ark.fandom.com/wiki/X-Woolly_Rhino',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Snow_WoollyRhino/Snow_Rhino_Character_BP.Snow_Rhino_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3b/Dossier_Woolly_Rhino.png',
                        description='“\nSpecies\nCoelodonta utiliserro\nTime\nLate Pliocene - Late Pleistocene\nDiet\nHerbivore\nTemperament\nFriendly\nWild\nCoelodonta utiliserro is a friendly herbivore, common to the tundra and grassland regions of the Island. It is a large and dangerous creature, though it seems fairly trusting of the fauna around it. Once attacked, Coelodonta begins charging towards its foe. It builds up momentum as it charges, and depending on its ultimate impact speed, the results can be terrifying. With enough room to charge, it can even skewer the largest creatures in just one gore! Despite how powerful Coelodonta are, many tribes still hunt them extensively due to their unique resources. Its horns can ground into a highly arousing powder, and its thick fur can support many insulating outfits, making the Coelodonta in high demand. Even less-advanced tribes use packs to hunt them down, though at significant peril.\nDomesticated\nWhen not being hunted for its horns, Coelodonta makes an impressive beast of burden. Its ability to take on far larger opponents provided sufficient charging room, as well as its sizeable load capacity, make it a solid addition to any trader party or gathering expedition.\n„\n~ Helena')
    models.Creature.new(name='X-Yutyrannus', name_tag='Yutyrannus', category='X-Creatures',
                        entity_id='Snow_Yutyrannus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b8/Yutyrannus.png',
                        url='https://ark.fandom.com/wiki/X-Yutyrannus',
                        blueprint='"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Snow_Yutyrannus/Snow_Yutyrannus_Character_BP.Snow_Yutyrannus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Dossier_Yutyrannus.png',
                        description='“\nSpecies\nYutyrannus saevus\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThe Yutyrannus saevus is believed to be related to the Tyrannosaurus rex, but it is noticeably different upon first glance. Feathered creatures are not necessarily viewed as dangerous predators in the same light as other theropods. However, the Yutyrannus strikes fear into even the Island\'s most skilled hunters. There are few wild predators that are able to pack-hunt alongside the generally hostile Carnotaurus, like the Yutyrannus does, with such ease. It is also the only creature I\'ve seen to consistently induce a state of panic in opponents with its roar. Upon hearing it, most creatures in the area will flee for safety.\nDomesticated\nA domesticated Yutyrannus can be a powerful offensive or defensive addition to war parties. With its mighty roar, it can induce fear in opposing creatures. Meanwhile, Yutyrannus can be trained to develop a confidence-boosting Battle-Cry which counteracts enemy attempts to induce fear, while also bolstering the resolve of allies, and may even draw wild Carnotaurus to its aid. These unique "leadership" qualities make the Yutyrannus a versatile, and at times, a necessary creature to have on your side during large-scale confrontations!\n„\n~ Helena')
    models.Creature.new(name='Astrodelphis', name_tag='Astrodelphis', category='Fantasy Creatures',
                        entity_id='SpaceDolphin_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/25/Astrodelphis.png',
                        url='https://ark.fandom.com/wiki/Astrodelphis',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/SpaceDolphin/SpaceDolphin_Character_BP.SpaceDolphin_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Astrodelphis_image.png',
                        description=None)
    models.Creature.new(name='Maewing', name_tag='Maewing', category='Fantasy Creatures',
                        entity_id='MilkGlider_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Maewing.png',
                        url='https://ark.fandom.com/wiki/Maewing',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/MilkGlider/MilkGlider_Character_BP.MilkGlider_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Maewing_image.png',
                        description=None)
    models.Creature.new(name='Noglin', name_tag='BrainSlug', category='Fantasy Creatures',
                        entity_id='BrainSlug_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/43/Noglin.png',
                        url='https://ark.fandom.com/wiki/Noglin',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BrainSlug/BrainSlug_Character_BP.BrainSlug_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/54/Noglin_image.png',
                        description=None)
    models.Creature.new(name='Shadowmane', name_tag='Lionfish Lion', category='Fantasy Creatures',
                        entity_id='LionfishLion_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e8/Shadowmane.png',
                        url='https://ark.fandom.com/wiki/Shadowmane',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/LionfishLion/LionfishLion_Character_BP.LionfishLion_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f2/Shadowmane_image.png',
                        description=None)
    models.Creature.new(name='Tek Stryder', name_tag='TekStrider', category='Mechanical Creatures',
                        entity_id='TekStrider_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/97/Tek_Stryder.png',
                        url='https://ark.fandom.com/wiki/Tek_Stryder',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/TekStrider/TekStrider_Character_BP.TekStrider_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Tek_Stryder_image.png',
                        description=None)
    models.Creature.new(name='Voidwyrm', name_tag='TekWyvern', category='Mechanical Creatures',
                        entity_id='TekWyvern_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4c/Voidwyrm.png',
                        url='https://ark.fandom.com/wiki/Voidwyrm',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/TekWyvern/TekWyvern_Character_BP.TekWyvern_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4f/Voidwyrm_image.png',
                        description=None)
    models.Creature.new(name='R-Allosaurus', name_tag='Allo', category='R-Creatures',
                        entity_id='Allo_Character_BP_Rockwell_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Allosaurus.png',
                        url='https://ark.fandom.com/wiki/R-Allosaurus',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Allo_Character_BP_Rockwell.Allo_Character_BP_Rockwell\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Allosaurus.png',
                        description="“\nSpecies\nAllosaurus therotribus\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmaller but faster than Tyrannosaurus, larger but slower than Carnotaurus, Allosaurus therotribus is the island's resident pack-hunting theropod. While most aggressive theropods are relatively solitary creatures, Allosaurus lives in groups of 3. One Allosaurus is the alpha, while the others are its mates or a beta male. Like humans find value in forming a tribe, the Allosaurus has evolved to hunt in packs. Its saw-shaped teeth leave its prey bleeding and maimed, making escape difficult. Once an Allosaurus slows a creature with its cutting bite, the rest of its pack quickly closes in for the kill.\nDomesticated\nNot everyone thinks a tamed Allosaurus is ideal. Those who appreciate speed generally tame Carnotaurus, while those who value raw stopping power tame Tyrannosaurus. However, riders of Allosaurus tend to respect the utility of its Alpha pack status, which along with its bleed-inducing attacks and relative mobility, can effectively turn the tide of a combined arms battle.\n„\n~ Helena")
    models.Creature.new(name='R-Carnotaurus', name_tag='Carno', category='R-Creatures',
                        entity_id='Carno_Character_BP_Rockwell_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Carnotaurus.png',
                        url='https://ark.fandom.com/wiki/R-Carnotaurus',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Carno_Character_BP_Rockwell.Carno_Character_BP_Rockwell\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Carnotaurus.png',
                        description="“\nSpecies\nCarnotaurus pressor\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nCarnotaurus pressor is a distinctive creature that falls between a medium and large predator. It lives primarily on flat, clear ground, where it can capitalize on its speed. Additionally, it seems to have no qualms about running away from larger predators instead of fighting. The horns of the Carnotaurus seem to be used more for fighting rivals than actual hunting. This doesn't mean the horns aren't dangerous, though. They can still eviscerate larger prey. Carnotaurus is one of the smaller and more compact of the large predators. If Tyrannosaurus is the “lion” of the Island, Carnotaurus would certainly be the “cheetah.” The real threat of a Carnotaurus is not being able to escape it once it has spotted you.\nDomesticated\nCarnotaurus fills a very specific role. Larger and almost as fast as a Raptor, smaller but much faster than a Rex. Were it not for the creature's extremely long down-time after sprinting, it might be among the most capably balanced mounts.\n„\n~ Helena")
    models.Creature.new(name='R-Daeodon', name_tag='Daeodon', category='R-Creatures',
                        entity_id='Daeodon_Character_BP_Eden_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Daeodon.png',
                        url='https://ark.fandom.com/wiki/R-Daeodon',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Daeodon_Character_BP_Eden.Daeodon_Character_BP_Eden\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a9/Dossier_Daeodon.png',
                        description='“\nSpecies\nDaeodon comedentis\nTime\nLate Oligocene\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nNice Daeodon comedentis is the largest known species of Entelodont, an omnivorous family of ancient mammals that are sometimes referred to as "Hell Pigs." Even though Daeodon has as many similarities to modern Hippopotamidae as it does to Suina, I\'ve found that to be a suitable nickname. Daeodon is as mean as it looks, and any survivor who wanders too close will find that out the hard way. As an omnivore with a voracious appetite, Daeodon scavenges, forages, and hunts to survive. It has little qualms when it comes to its diet, and that has helped it thrive on the Island\'s harsh tundra. Its temper hasn\'t hurt either, as many would be predators would rather seek out less vicious prey.\nDomesticated\nMany tribes have made excellent use of Daeodon packs within their war parties, not only because of its fierce nature, but due to its extraordinary ability to rapidly heal itself. I\'ve theorized that this healing factor is why it seems to have such a high metabolism, though what is particularly extraordinary is its capability to share this benefit with nearby creatures. I have even heard some survivors mention that the Daeodon also has a unique ability to root out Rare Mushrooms as well!\n„\n~ Helena')
    models.Creature.new(name='R-Dilophosaur', name_tag='Dilo', category='R-Creatures',
                        entity_id='Dilo_Character_BP_Rockwell_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c9/Dilophosaur.png',
                        url='https://ark.fandom.com/wiki/R-Dilophosaur',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Dilo_Character_BP_Rockwell.Dilo_Character_BP_Rockwell\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6c/Dossier_Dilophosaur.png',
                        description='“\nSpecies\nDilophosaurus sputatrix\nTime\nEarly Jurassic\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nDilophosaurus sputatrix is a strange creature. It stands at just over half the size of known Dilophosaurs and runs from aggressors as often as it fights them. Dilophosaurus sputatrix has a few traits not common in the Dilophosaurus genus. It has a very shrill call, and a decorative ridge of skin on its neck. I believe these are used to attract mates, as well as intimidate prey and would-be predators. Instead of attacking its prey outright, Dilophosaurus sputatrix spits venom to weaken and paralyze it before moving in for the kill.\nDomesticated\nBecause of their shrill cry and their ability to attack intruders from range, Dilophosaurus seem most suited as "guard dogs." Due to their small size, they are not suitable as mounts.\n„\n~ Helena')
    models.Creature.new(name='R-Dire Bear', name_tag='Direbear', category='R-Creatures',
                        entity_id='Direbear_Character_BP_Rockwell_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6f/Dire_Bear.png',
                        url='https://ark.fandom.com/wiki/R-Dire_Bear',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Direbear_Character_BP_Rockwell.Direbear_Character_BP_Rockwell\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/20/Dossier_Dire_Bear.png',
                        description="“\nSpecies\nArctodus dirus\nTime\nMid Pleistocene - Early Holocene\nDiet\nOmnivore\nTemperament\nTerritorial\nWild\nFound primarily among the Island's redwood regions, Arctodus dirus is an imposing creature. Many on the island have started calling it a Direbear, a name which is appropriate, both due to its enormity and its territorial nature. The Direbear ignores most non-hostile creatures while going about its daily routine of scavenging for meat and edible plant life... ...that is, until intruders enter the territory it considers its own, at which point the creature ferociously attacks. Most often, it is smartest to just run from an angry Direbear.\nDomesticated\nOnce tamed, the Direbear is a strong and reliable mount. It can carry vast quantities of goods, and can sprint for extremely long, nearly infinite periods. It is not the fastest creature from a hard stop, but after building up momentum, its sustained overland speed builds to among the best of the island. Of course, being able to feed a direbear both meat and plant life makes keeping one fairly convenient regardless of the environment. Arctodus has a fondness for honey and can harvest it without getting stung or destroying the hive. Perhaps more rewarding while you are riding it, those pesky bees will completely ignore you.\n„\n~ Helena")
    models.Creature.new(name='R-Direwolf', name_tag='Direwolf', category='R-Creatures',
                        entity_id='Direwolf_Character_BP_Eden_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/10/Direwolf.png',
                        url='https://ark.fandom.com/wiki/R-Direwolf',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Direwolf_Character_BP_Eden.Direwolf_Character_BP_Eden\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Direwolf.png',
                        description='“\nSpecies\nCanis maxdirus\nTime\nPleistocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThe best adjective to describe Canis maxdirus is "scary." This pack-animal is a cunning and brutal predator, capable of taking down prey of nearly any size. In addition to being a vicious hunter, it is the size of a small horse, meaning even the largest predators aren\'t necessarily safe from the packs. Unlike most creatures on the Island, Canis is a dedicated pack hunter, and rarely hunts alone. When in a pack, Canis are naturally spurred to fight for their lives with increased effectiveness, while the most experienced Canis will be designated “Alpha” and gain an even stronger enhancement! The species has an incredible affinity for teamwork.\nDomesticated\nObviously, Canis is a thrilling battle mount. It is fairly fast, very strong, and agile. It can leap almost as well as the Island\'s battle-cats. Riding a supercharged “Alpha” Canis into battle at the head of a bloodthirsty pack is a thrill for which most warriors would gladly proclaim: "today is a good day to die!" If utilized correctly, Canis can be a useful aid in your discovery efforts. It has developed a keen sense of smell that enables it to detect things that most creatures can\'t. I\'ve even seen them used to find creatures that are hidden beneath the surface.\n„\n~ Helena')
    models.Creature.new(name='R-Equus', name_tag='Equus', category='R-Creatures', entity_id='Equus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Equus.png',
                        url='https://ark.fandom.com/wiki/R-Equus',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Equus_Character_BP_Eden.Equus_Character_BP_Eden\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Dossier_Equus.png',
                        description="“\nSpecies\nEquus magnus\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nLoyal\nWild\nEquus magnus appears to be an ancestor of the modern horse. Based on its stripes, it may be the African variant of Equus giganteus, which appeared in North America during the Ice Age, but that is pure conjecture. Its behavior in the wild is similar to that of other wild members of the Equus genus - it sustains itself by grazing, while keeping safe from predators by living in herds and outrunning its attackers via superior speed and stamina.\nDomesticated\nHorse and man have long been partners in survival, and this remains true on the Island. In Equus, survivors will find a trusty steed or pack animal that can carry them swiftly across land. Taming an Equus has proven interesting, requiring carefully approaching the creature in the wild, mounting it, and then carefully soothing over time by feeding it vegetables. In fact, Equus' reliability has lead some survivors to construct special saddles for them. I even encountered a man who added extra saddle-pouches that doubled as mobile crafting stations for chemical supplies, foodstuffs, and other items. Although not as robust as what you might find within a village, this utility helped him live a nomadic, solitary lifestyle. Some survivors employ Equus to herd and wrangle other creatures with a specialized lasso. This tool is sometimes effective for self-defense as well, as Equus is limited in battle on its own...at least compared to aggressive prehistoric carnivores.\n„\n~ Helena")
    models.Creature.new(name='R-Gasbags', name_tag='GasBags', category='R-Creatures',
                        entity_id='GasBags_Character_BP_Eden_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Gasbags.png',
                        url='https://ark.fandom.com/wiki/R-Gasbags',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/GasBags_Character_BP_Eden.GasBags_Character_BP_Eden\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8c/Dossier_Gasbags.png',
                        description="“\nSpecies\nMopsechiniscus fluitobesus\nTime\nPost-Holocene\nDiet\nOmnivore\nTemperament\nPassive\nWild\nIt was always hypothesized that a member of the Tardigrada phylum would be the last species on Earth in the event of a global apocalypse, so in some ways, the existence of Mopsechiniscus fluitobesus is completely expected. Its size and method of travel, however? Less so.\n\nMopsechiniscus is slow and ineffective in a fight, so to survive, it tends to choose flight - literally. First, it inflates itself like a balloon, briefly slowing down and gaining durability. Then it launches itself into the air by expelling gas through a series of sphincters in its underbelly, which it also uses to slow its descent.\n\nYes, it's as...unusual as it sounds, but Mopsechiniscus makes the most of its inflatable nature. In addition to jumping, it can use its stored up gases to push back aggressors, or even float on water.\nDomesticated\nWhile a poor steed in battle, Mopsechiniscus is a fantastic beast of burden. The hairs on its back let a single rider steer it without a saddle, and it carries an incredible amount of cargo for its size. A small caravan of these could see us swimming in resources in no time.\n„\n~ Helena")
    models.Creature.new(name='R-Giganotosaurus', name_tag='Gigant', category='R-Creatures',
                        entity_id='Gigant_Character_BP_Rockwell_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Giganotosaurus.png',
                        url='https://ark.fandom.com/wiki/R-Giganotosaurus',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Gigant_Character_BP_Rockwell.Gigant_Character_BP_Rockwell\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
                        description='“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena')
    models.Creature.new(name='R-Megatherium', name_tag='Megatherium', category='R-Creatures',
                        entity_id='Megatherium_Character_BP_Eden_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Megatherium.png',
                        url='https://ark.fandom.com/wiki/R-Megatherium',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Megatherium_Character_BP_Eden.Megatherium_Character_BP_Eden\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9c/Dossier_Megatherium.png',
                        description="“\nSpecies\nMegatherium formipavor\nTime\nLate Pliocene - Early Holocene\nDiet\nOmnivore (primarily Herbivore)\nTemperament\nPassive, but aggressive to insects\nWild\nMegatherium formipavor is one of the larger mammals on the Island. This is most shocking because it is essentially a giant sloth...if you crossbred it with an elephant and a bear! Because of its size and girth, the Megatherium is uncommonly resistant to being knocked unconscious. Despite primarily being an herbivore, a typical Megatherium is very intent on consuming the Island's many insects. It is particularly adept at removing their insides without damaging much of the shell, maximizing extraction of chitin. The otherwise slow and peaceful Megatherium becomes faster and aggressive in the presence of these creatures.\nDomesticated\nMegatherium is an incredibly useful creature to tame, so long as you don't intend to fight other tribes. It's enormity, high resistance to torpor, and voracious attitude toward insects (and arachnids) makes it ideal for farming large quantities of chitin from the bugs of the Island, or simply defending against them.\n„\n~ Helena")
    models.Creature.new(name='R-Snow Owl', name_tag='Owl', category='R-Creatures', entity_id='Owl_Character_BP_Eden_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4b/Snow_Owl.png',
                        url='https://ark.fandom.com/wiki/R-Snow_Owl',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Owl_Character_BP_Eden.Owl_Character_BP_Eden\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bd/Dossier_Snow_Owl.png',
                        description="“\nSpecies\nBubo chinookus\nTime\nPost-Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nDiscovering Bubo chinookus was a pleasant surprise. Owls are remarkable creatures, but they're not the type that could survive an extinction level event on their own. Since it never strays from the patch of frozen tundra we encountered, I believe the Obelisk was the key to its survival.\n\nClearly a descendant of modern Strigdae, Bubo shares many traits with its smaller ancestors. For example, it excretes waste in the form of pellets, which make excellent fertilizer, and their large wings let them save energy during long, silent flights. They even hunt in the same way: by diving towards the ground to attack their prey with powerful talons.\n\nHowever, these talons also secrete a chemical with a high freezing point to slow down their prey, and they can even unleash this chemical in a wide cloud, temporarily freezing their foes.\nDomesticated\nWith its swift flying and frigid attacks, Bubo makes an excellent single-rider support mount or scout. The latter is helped by its tremendous vision, which it can share with its rider via its antenna. Not only does this make enemies easier to see, but Bubo can also spot Element veins with ease, even when they're underground.\n„\n~ Helena")
    models.Creature.new(name='R-Parasaur', name_tag='Para', category='R-Creatures',
                        entity_id='Para_Character_BP_Eden_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Parasaur.png',
                        url='https://ark.fandom.com/wiki/R-Parasaur',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Para_Character_BP_Eden.Para_Character_BP_Eden\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Dossier_Parasaur.png',
                        description="“\nSpecies\nParasaurolophus amphibio\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nParasaurolophus amphibio has one of the more interesting adaptations of any creature I've seen on the Island. Like all Parasaur, it has a signature crest on its head. Very docile at first, I've been able to approach the creature without disturbing it. If startled, however, the creature can vocalize a distress call to the surrounding area that warns of danger. Parasaurolophus appears to be low on the food chain and is hunted by everything, creatures and humans alike, which explains its skittish nature. It is a good source of meat and hide, if you can manage to keep up with it long enough to kill it.\nDomesticated\nDespite being what most tribes consider a relatively useless creature to tame, I once met an interesting woman who had tamed an entire herd of them. She informed me that many overlooked the creature's potential. She even graciously gifted me a fancy saddle to put on my own Parasaurolophus one day. As a relatively simple creature to domesticate, Parasaurolophus is commonly one of the first mounts a tribe will be able to acquire. Its ability to run relatively fast for lengthy intervals makes it a solid mode of medium-range transportation, though it has almost no ability to defend itself or its rider in a traditional sense. Smaller creatures, however, appear to be frightened by the horn of Parasaurolophus although it doesn't do much damage. It also has decent weight-bearing capabilities, which could prove useful for nomadic tribes as they work to establish a presence on the Island.\n„\n~ Helena")
    models.Creature.new(name='R-Procoptodon', name_tag='Kangaroo', category='R-Creatures',
                        entity_id='Procoptodon_Character_BP_Eden_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Procoptodon.png',
                        url='https://ark.fandom.com/wiki/R-Procoptodon',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Procoptodon_Character_BP_Eden.Procoptodon_Character_BP_Eden\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Dossier_Procoptodon.png',
                        description="“\nSpecies\nProcoptodon vivencurrus\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nReactive\nWild\nThe first marsupial I've encountered on the Island is the Procoptodon vivencurrus. Standing nearly three meters tall, it is among the largest jumping creatures I've heard of. It is a fairly peaceful herbivore that will immediately flee when aggressed upon. One of Procoptodon's most unique features is its pouch. Unlike many pouched marsupials, Procoptodon's pouch is relatively dry and has little in the way of sticky or oily fluids. I assume this is good for the Joey, but I have not figured out exactly why yet. Its other unique feature, powerful hind legs, can knock back aggression much larger in stature. Procoptodons show great precision when leaping as if they can accurately target the landing without fail. I've seen them effortlessly hop and land from heights that would flatten other creatures.\nDomesticated\nIt seems Procotopdon's knack for carrying things has increased its load-bearing capacity. Procoptodon's dry pouch makes it an excellent beast of burden that can carry far more than other creatures of its size. Additionally, it appears to provide an optimal environment for nourishing babies. So much that upon maturing, they have even more vigor.\n„\n~ Helena")
    models.Creature.new(name='R-Quetzal', name_tag='Quetz', category='R-Creatures',
                        entity_id='Quetz_Character_BP_Rockwell_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9d/Quetzal.png',
                        url='https://ark.fandom.com/wiki/R-Quetzal',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Quetz_Character_BP_Rockwell.Quetz_Character_BP_Rockwell\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2c/Dossier_Quetzal.png',
                        description="“\nSpecies\nQuetzalcoatlus conchapicem\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nFrom afar, it's hard to believe that Quetzalcoatlus is one of the largest avians on the island. It shares a similar silhouette with the Pteranodon, and nests near the absolute highest peaks. Upon closer inspection, though, Quetzalcoatlus is an enormous creature of tremendous power. I find it strange that such a large, imposing beast would be so skittish. Unlike other creatures of its size, it is more likely to flee than fight. I suppose the decision to flee from any trouble keeps the species alive on an island with so many dangerous predators. But then how does it eat enough to sustain its massive size?\nDomesticated\nTamed Quetzalcoatlus have a very specific role on the island. Too slow to be an efficient local transport, and too weak to be an effective warbird, the tribes I have encountered tend to employ it as a mass carrier. Quetzalcoatlus is primarily used by these masters of the skies to safely carry vast quantities of supplies, creatures and human cargo from one base to another without tiring.\n„\n~ Helena")
    models.Creature.new(name='R-Brontosaurus', name_tag='Bronto', category='R-Creatures',
                        entity_id='Sauropod_Character_BP_Rockwell_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/47/Brontosaurus.png',
                        url='https://ark.fandom.com/wiki/R-Brontosaurus',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Sauropod_Character_BP_Rockwell.Sauropod_Character_BP_Rockwell\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f7/Dossier_Brontosaurus.png',
                        description='“\nSpecies\nBrontosaurus lazarus\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nDocile\nWild\nAmong giant creatures I\'ve seen on the Island, Brontosaurus lazarus is larger than any sauropod I\'ve read about. In fact, the dinosaur is so massive that it serenely ignores most other creatures. I\'ve seen a pack of raptors tear apart small dinosaurs while Brontosaurus continues eating, seemingly oblivious to the hunting pack.\nDomesticated\nBecause of how docile it is, the Brontosaurus makes for an ideal pack animal. Peaceful tribes use it to carry incredible quantities of resources, while warring tribes use it to mobilize their army. Its size and strength make it one of the unique creatures on the Island that can support a "platform" saddle. Unfortunately, its enormity means that the process of taming a Brontosaurus can take a very long time. Some may think this is an Apatosaurus, Dreadnoughtus, Argentinosaurus, or some other sauropod, but this is a strange Island, and I\'m the one doing the research. I\'m convinced that this genus is Brontosaurus, and no one can tell me otherwise. My study, my rules.\n„\n~ Helena')
    models.Creature.new(name='R-Velonasaur', name_tag='Velonasaur', category='R-Creatures',
                        entity_id='Spindles_Character_BP_Rockwell_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Velonasaur.png',
                        url='https://ark.fandom.com/wiki/R-Velonasaur',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Spindles_Character_BP_Rockwell.Spindles_Character_BP_Rockwell\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Dossier_Velonasaur.png',
                        description="“\nSpecies\nVelonasaurus spinavultus\nTime\nPost-Holocene\nDiet\nCarnivore\nTemperament\nOmnivore\nWild\nVelonasaurus spinavultus dwells in the small desert found outside the abandoned city, which is particularly fitting, because it looks like it's growing several cacti right on its face.\n\nAs unfashionable as its facial fins might be, I recommend keeping a close eye on them. While said fins are folded inwards, Velonasaurus behaves like your average therapod, attacking with claws and teeth. However, when those fins are spread wide, Velonasaurus can rapidly fire a storm of spines at its prey. However, while in this state, its mobility is greatly hampered and it will eventually wear itself out.\n\nTherefore it sometimes prefers to unleash its spines in a single, deadly burst. By spinning around and firing a salvo of spines at the same time, Velonasaurus can defend itself from every angle at once.\nDomesticated\nGiven its versatility, Velonasaurus spinavultus makes an excellent single rider mount in most combat situations, but it's particularly effective when defending an entrenched position. It's like a living, breathing gatling gun. Just be careful when giving it a congratulatory hug or pat on the head. Getting spined by your own war steed would be a rather embarrassing way to go.\n„\n~ Helena")
    models.Creature.new(name='R-Thylacoleo', name_tag='Thylacoleo', category='R-Creatures',
                        entity_id='Thylacoleo_Character_BP_Eden_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/22/Thylacoleo.png',
                        url='https://ark.fandom.com/wiki/R-Thylacoleo',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Thylacoleo_Character_BP_Eden.Thylacoleo_Character_BP_Eden\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c9/Dossier_Thylacoleo.png',
                        description="“\nSpecies\nThylacoleo furtimorsus\nTime\nLate Pliocene - Late Pleistocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThylacoleo furtimorsus is a large, powerful marsupial that can often be found hunting around trees among the Island's redwoods. Its long claws and semi-opposable digits make it an apt climber, a quality that Thylacoleo uses to its advantage while hunting. It clambers up large trees and waits to ambush passing prey by pouncing upon them. When something that large jumps onto a target, the victim becomes stunned and doesn't stand much of a chance. Thylacoleo's most notable fighting quality is its powerful jaws. Once it bites its prey, it locks its jaw in an iron grip that can hold most smaller creatures in place. Thylacoleo then goes on to savage its prey with its sharp claws. If it needs to escape from a fight, Thylacoleo uses its muscular hind legs to jump back to safety among the trees.\nDomesticated\nThylacoleo is a moderately strong mount, and its ability to climb trees and jump long distances makes it useful for traversal. As such, developing tribes often tame it. Small raiding parties particularly favor Thylacoleo, as it is well suited to ambushes and unfair fights!\n„\n~ Helena")
    models.Creature.new(name='R-Carbonemys', name_tag='Turtle', category='R-Creatures',
                        entity_id='Turtle_Character_BP_Rockwell_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4c/Carbonemys.png',
                        url='https://ark.fandom.com/wiki/R-Carbonemys',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Turtle_Character_BP_Rockwell.Turtle_Character_BP_Rockwell\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Carbonemys.png',
                        description="“\nSpecies\nCarbonemys obibimus\nTime\nDanian\nDiet\nHerbivore\nTemperament\nDefensive\nWild\nCarbonemys obibimus is one of the least aggressive creatures on the Island. Were it not for the plethora of predators on the Island, I'm quite certain that it would spend its days basking in the sun, eating, or sleeping. Carbonemys leads a simple, solitary life. Nevertheless, it seems to be one of the most peaceful animals I have yet encountered. With its slow walking speed, the only things that keep it safe are its surprisingly fast swim speed, and its incredibly thick shell, which can absorb tremendous damage.\nDomesticated\nCarbonemys' swift swim rate, fairly high strength, superior shell defenses, and lack of real threat makes it an ideal armored mount for many survivors who shy away from violence. It can carry its rider to the ocean's resources at fairly high speed, and is not particularly dangerous to tame.\n„\n~ Helena")
    models.Creature.new(name='R-Reaper Queen', name_tag='Xenomorph', category='R-Creatures',
                        entity_id='Xenomorph_Character_BP_Female_Gen2_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
                        url='https://ark.fandom.com/wiki/R-Reaper_Queen',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Xenomorph_Character_BP_Female_Gen2.Xenomorph_Character_BP_Female_Gen2\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description="“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena")
    models.Creature.new(name='R-Reaper King', name_tag='Xenomorph', category='R-Creatures',
                        entity_id='Xenomorph_Character_BP_Male_Gen2_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
                        url='https://ark.fandom.com/wiki/R-Reaper_King',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Xenomorph_Character_BP_Male_Gen2.Xenomorph_Character_BP_Male_Gen2\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description="“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena")
    models.Creature.new(name='R-Reaper King (Tamed)', name_tag='Xenomorph', category='R-Creatures',
                        entity_id='Xenomorph_Character_BP_Male_Tamed_Gen2_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
                        url='https://ark.fandom.com/wiki/R-Reaper_King_(Tamed)',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Xenomorph_Character_BP_Male_Tamed_Gen2.Xenomorph_Character_BP_Male_Tamed_Gen2\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
                        description="“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena")
    models.Creature.new(name='Summoner', name_tag='Summoner', category='Fantasy Creatures',
                        entity_id='Summoner_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Summoner.png',
                        url='https://ark.fandom.com/wiki/Summoner',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/Summoner/Summoner_Character_BP.Summoner_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fc/Summoner_image.png',
                        description=None)
    models.Creature.new(name='Macrophage', name_tag='Macrophage', category='Fantasy Creatures',
                        entity_id='Macrophage_Swarm_Character_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0e/Macrophage.png',
                        url='https://ark.fandom.com/wiki/Macrophage',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/Macrophage/Macrophage_Swarm_Character.Macrophage_Swarm_Character\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0f/Macrophage_image.png',
                        description=None)
    models.Creature.new(name='Exo-Mek', name_tag='Exosuit', category='Vehicles', entity_id='Exosuit_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fc/Exo-Mek.png',
                        url='https://ark.fandom.com/wiki/Exo-Mek',
                        blueprint='"Blueprint\'/Game/Genesis2/Dinos/Exosuit/Exosuit_Character_BP.Exosuit_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/20/Exo-Mek_image.png',
                        description=None)
    models.Creature.new(name='Rockwell Prime', name_tag='RockwellPrime', category='Bosses',
                        entity_id='RockwellNode_Character_BP_Boss_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cc/Rockwell_Prime.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Prime',
                        blueprint='"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Dinos/RockwellNode_Character_BP_Boss.RockwellNode_Character_BP_Boss\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a6/Rockwell_Prime_in_arena.jpg',
                        description=None)
    models.Creature.new(name='Rockwell Prime (Alpha)', name_tag='RockwellPrime', category='Bosses',
                        entity_id='RockwellNode_Character_BP_Boss_Alpha_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cc/Rockwell_Prime.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Prime_(Alpha)',
                        blueprint='"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Alpha/RockwellNode_Character_BP_Boss_Alpha.RockwellNode_Character_BP_Boss_Alpha\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a6/Rockwell_Prime_in_arena.jpg',
                        description=None)
    models.Creature.new(name='Rockwell Prime (Beta)', name_tag='RockwellPrime', category='Bosses',
                        entity_id='RockwellNode_Character_BP_Boss_Beta_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cc/Rockwell_Prime.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Prime_(Beta)',
                        blueprint='"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Beta/RockwellNode_Character_BP_Boss_Beta.RockwellNode_Character_BP_Boss_Beta\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a6/Rockwell_Prime_in_arena.jpg',
                        description=None)
    models.Creature.new(name='Rockwell Prime (Gamma)', name_tag='RockwellPrime', category='Bosses',
                        entity_id='RockwellNode_Character_BP_Boss_Gamma_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cc/Rockwell_Prime.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Prime_(Gamma)',
                        blueprint='"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Gamma/RockwellNode_Character_BP_Boss_Gamma.RockwellNode_Character_BP_Boss_Gamma\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a6/Rockwell_Prime_in_arena.jpg',
                        description=None)
    models.Creature.new(name='Rockwell Node', name_tag='RockwellPrime', category='Bosses',
                        entity_id='RockwellNode_Character_BP_FinalFight_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/87/Rockwell_Node.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Node',
                        blueprint='"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Dinos/RockwellNode_Character_BP_FinalFight.RockwellNode_Character_BP_FinalFight\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Rockwell_Node.jpg',
                        description=None)
    models.Creature.new(name='Rockwell Node (Alpha)', name_tag='RockwellPrime', category='Bosses',
                        entity_id='RockwellNode_Character_BP_FinalFight_Alpha_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/87/Rockwell_Node.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Node_(Alpha)',
                        blueprint='"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Alpha/RockwellNode_Character_BP_FinalFight_Alpha.RockwellNode_Character_BP_FinalFight_Alpha\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Rockwell_Node.jpg',
                        description=None)
    models.Creature.new(name='Rockwell Node (Beta)', name_tag='RockwellPrime', category='Bosses',
                        entity_id='RockwellNode_Character_BP_FinalFight_Beta_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/87/Rockwell_Node.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Node_(Beta)',
                        blueprint='"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Beta/RockwellNode_Character_BP_FinalFight_Beta.RockwellNode_Character_BP_FinalFight_Beta\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Rockwell_Node.jpg',
                        description=None)
    models.Creature.new(name='Rockwell Node (Gamma)', name_tag='RockwellPrime', category='Bosses',
                        entity_id='RockwellNode_Character_BP_FinalFight_Gamma_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/87/Rockwell_Node.png',
                        url='https://ark.fandom.com/wiki/Rockwell_Node_(Gamma)',
                        blueprint='"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Gamma/RockwellNode_Character_BP_FinalFight_Gamma.RockwellNode_Character_BP_FinalFight_Gamma\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Rockwell_Node.jpg',
                        description=None)
    models.Creature.new(name='Achatina', name_tag='Achatina', category='Invertebrates',
                        entity_id='Achatina_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/18/Achatina.png',
                        url='https://ark.fandom.com/wiki/Achatina',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Achatina/Achatina_Character_BP.Achatina_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bc/Dossier_Achatina.png',
                        description='“\nSpecies\nAchatina limusegnis\nTime\nHolocene\nDiet\nHerbivore\nTemperament\nPassive\nWild\nFound mostly in marshes and jungles, Achatina limusegnis is a very slow, very non-threatening land mollusk. It might be the simplest creature on the Island to hunt, and while it only provides a small amount of meat and chitin, an easy meal is always of value on the Island. Unlike nearly every other creature on the Island, Achatina does not defecate normally. Instead, it secretes a thick, sticky substance. Achatina leaves trails of this slime, but the trails are so thin that they crumble to dust quickly.\nDomesticated\nThere is a very disgusting, but useful fact about Achatina that causes tribes to seek to tame them: its secretions are chemically similar to the "Cementing Paste" and "Organic Polymer" used by many tribes for building materials. Tamed Achatina naturally accumulates this slime over time, which can then be collected at the tribe\'s convenience. Legend has it that Achatina can be tamed with a special "cake" made from harvested crops & resources.\n„\n~ Helena')
    models.Creature.new(name='Allosaurus', name_tag='Allo', category='Dinosaurs', entity_id='Allo_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Allosaurus.png',
                        url='https://ark.fandom.com/wiki/Allosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Allosaurus/Allo_Character_BP.Allo_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Allosaurus.png',
                        description="“\nSpecies\nAllosaurus therotribus\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmaller but faster than Tyrannosaurus, larger but slower than Carnotaurus, Allosaurus therotribus is the island's resident pack-hunting theropod. While most aggressive theropods are relatively solitary creatures, Allosaurus lives in groups of 3. One Allosaurus is the alpha, while the others are its mates or a beta male. Like humans find value in forming a tribe, the Allosaurus has evolved to hunt in packs. Its saw-shaped teeth leave its prey bleeding and maimed, making escape difficult. Once an Allosaurus slows a creature with its cutting bite, the rest of its pack quickly closes in for the kill.\nDomesticated\nNot everyone thinks a tamed Allosaurus is ideal. Those who appreciate speed generally tame Carnotaurus, while those who value raw stopping power tame Tyrannosaurus. However, riders of Allosaurus tend to respect the utility of its Alpha pack status, which along with its bleed-inducing attacks and relative mobility, can effectively turn the tide of a combined arms battle.\n„\n~ Helena")
    models.Creature.new(name='Alpha Carno', name_tag='Elite Carno', category='Alpha Creatures',
                        entity_id='MegaCarno_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Alpha_Carnotaurus.png',
                        url='https://ark.fandom.com/wiki/Alpha_Carno',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Carno/MegaCarno_Character_BP.MegaCarno_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Alpha_Carnotaurus_Image.jpg',
                        description=None)
    models.Creature.new(name='Alpha Leedsichthys', name_tag='Leedsichthys', category='Alpha Creatures',
                        entity_id='Alpha_Leedsichthys_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Leedsichthys.png',
                        url='https://ark.fandom.com/wiki/Alpha_Leedsichthys',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Leedsichthys/Alpha_Leedsichthys_Character_BP.Alpha_Leedsichthys_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e9/Dossier_Leedsichthys.png',
                        description="“\nSpecies\nLeedsichthys conviviumbrosia\nTime\nMid-Jurassic\nDiet\nPiscivore\nTemperament\nDefensive\nWild\nLeedsichthys conviviumbrosia is probably the largest fish in the waters around the island. Its meat is also extremely succulent, a surprise given its size. It is often traded with the same value as Prime Meat, and colloquially called 'Prime Fish'. Of course, not all of Leedsichthys' meat is this high quality, but most of it is! While the demand for Leedsichthys meat is high, the fish is notoriously difficult to track and hunt. Between its large size, powerful attacks, incredible speed (when it turns to flee), and humankind's general ineptitude on open water, actually killing a Leedsichthys is one of the Island's more difficult tasks. The hunt for an extremely elusive breed of the fish, the fabled 'Great Albino' Leedsichthys has been known to drive otherwise-sensible men and women mad with obsession, as if all evil were visibly personified and made practically assailable in this one creature.\nDomesticated\nDespite its large size, and the fact that it may well be strong enough to carry heavy loads, Leedsichthys does not appear to be intelligent enough to tame. Nevertheless, some large tribes keep an enormous pen with a few Leedsichthys trapped inside for cultivating purposes, as bits of Prime Fish can be repeatedly scraped off the gargantuan beast without killing it!\n„\n~ Helena")
    models.Creature.new(name='Alpha Megalodon', name_tag='Elite Mega', category='Alpha Creatures',
                        entity_id='MegaMegalodon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Megalodon.png',
                        url='https://ark.fandom.com/wiki/Alpha_Megalodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Megalodon/MEgaMegalodon_Character_BP.MegaMegalodon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Dossier_Megalodon.png',
                        description="“\nSpecies\nCarcharodon ultramegalodon\nTime\nMiocene-Pliocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWere it not restricted to the waters, Carcharodon ultramegalodon would be one of the most dangerous creatures on the island. As powerful and dangerous as the Tyrannosaurus is on land, Megalodon is near its equal in the water. In addition, it has a speed advantage over any non-aquatic creature when submerged. Megalodons need large quantities of food to sustain themselves, so they attack most creatures immediately on sight. Smaller fish are the sole exception I've seen; I believe this is because they cost more energy for Megalodons to catch than the predator would gain.\nDomesticated\nHaving access to the resources and treasures hidden deep within the ocean is near impossible without a domesticated sea creature. The Megalodon, though difficult to domesticate, proves to be very useful when exploring the deep sea. It's not the most efficient swimmer but it should be able to protect your cargo should you find yourself in a hostile encounter.\n„\n~ Helena")
    models.Creature.new(name='Alpha Mosasaur', name_tag='Mosasaur', category='Alpha Creatures',
                        entity_id='Mosa_Character_BP_Mega_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dc/Alpha_Mosasaur.png',
                        url='https://ark.fandom.com/wiki/Alpha_Mosasaur',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Mosasaurus/Mosa_Character_BP_Mega.Mosa_Character_BP_Mega\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e3/Alpha_Mosasaur.jpg',
                        description=None)
    models.Creature.new(name='Alpha Raptor', name_tag='Elite Raptor', category='Alpha Creatures',
                        entity_id='MegaRaptor_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/08/Raptor.png',
                        url='https://ark.fandom.com/wiki/Alpha_Raptor',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Raptor/MegaRaptor_Character_BP.MegaRaptor_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
                        description='“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena')
    models.Creature.new(name='Alpha T-Rex', name_tag='Elite Rex', category='Alpha Creatures',
                        entity_id='MegaRex_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Rex.png',
                        url='https://ark.fandom.com/wiki/Alpha_T-Rex',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Rex/MegaRex_Character_BP.MegaRex_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
                        description='“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena')
    models.Creature.new(name='Alpha Tusoteuthis', name_tag='Tusoteuthis', category='Alpha Creatures',
                        entity_id='Mega_Tusoteuthis_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Tusoteuthis.png',
                        url='https://ark.fandom.com/wiki/Alpha_Tusoteuthis',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Tusoteuthis/Mega_Tusoteuthis_Character_BP.Mega_Tusoteuthis_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Tusoteuthis.png',
                        description="“\nSpecies\nTusoteuthis vampyrus\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nTusoteuthis vampyrus is a very aggressive water predator. Approximately 30 feet long, Tusoteuthis is a terror of the deep. Once it grabs its prey, it slowly crushes it into submission while using the talons on its tentacles to siphon and drink the victim's blood! Tusoteuthis is a terrifying opponent for several reasons. Firstly, its grab slowly renders its victim unconscious, so death isn't the only concern. Secondly, its vampiric blood drain instantly revitalizes it, even during combat. Finally, if Tusoteuthis is losing the fight, it sprays a cloud of ink into the surrounding water, blinding its attackers to cover a sneaky escape.\nDomesticated\nOne of the major benefits of taming Tusoteuthis is harvesting its ink. Unlike normal ink, Tusoteuthis' ink is very oily, and can even be refined into fuels such as gasoline. Between that and Tusoteuthis' distinctive capability to grab & carry large creatures underwater, it makes for an excellent aquatic tame, despite its slower speed.\n„\n~ Helena")
    models.Creature.new(name='Ammonite', name_tag='Ammonite', category='Invertebrates',
                        entity_id='Ammonite_Character_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8b/Ammonite.png',
                        url='https://ark.fandom.com/wiki/Ammonite',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Ammonite/Ammonite_Character.Ammonite_Character\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/52/Dossier_Ammonite.png',
                        description='“\nSpecies\nAmmonitina multiamicus\nTime\nLate Jurassic - Mid Cretaceous\nDiet\nBottom Feeder\nTemperament\nPassive\nWild\nUsually found in the deepest parts of the water around the island, Amonitina multiamicus has a strange relationship with the other creatures of the deep. It must do something beneficial for them since every nearby sea creature defends Ammonitina when it is attacked. What this distinct symbiosis is based on, alas, I have not yet discovered. Ammonitina has also made its way into the deeper parts of many underwater caves. Even within these caves, the creature will draw attention if assaulted, making harvesting its resource-rich shell a tricky proposition, depending on what other dangers may be lurking nearby.\nDomesticated\nLike many of the untameable ocean dwellers, Ammonitina still has enough utility to be a valuable hunting target. If a tribe is willing to risk the wrath of nearby would-be protectors, Ammonitina bile can be harvested from the innards of its corpse. This bile can then be worked over with other chemicals to produce powerful concoctions, the most notable being a mixture that causes creatures to become enraged and attack the source of the scent.\n„\n~ Helena')
    models.Creature.new(name='Anglerfish', name_tag='Angler', category='Fish', entity_id='Angler_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Anglerfish.png',
                        url='https://ark.fandom.com/wiki/Anglerfish',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Anglerfish/Angler_Character_BP.Angler_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0d/Dossier_Angler.png',
                        description="“\nSpecies\nMelanocetus anglerpescum\nTime\nEarly Cretaceous - Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWhether its size is caused by adaptation to the Island's other inhabitants, or by cross-breeding with another larger species, Melanocetus angerlpescum is the largest form of Anglerfish I've ever heard of. Typically found among the deepest, darkest expanses of the ocean, this creature preys on smaller fish while being an excellent source of food for larger predators. Melanocetus has an array of bioluminescent light pods at the end of stalks on its head. Like typical Anglerfish, it primarily uses these to attract smaller creatures and trick them into coming close enough for Melanocetus to consume the prey. This often makes wild Melanocetus itself relatively easy to spot among the briny depths.\nDomesticated\nExploring the depths of the ocean can be difficult. The cold, the lack of air, and the shocking absence of light combine to make travel very dangerous. A tamed Anglerfish can use the natural light at the end of its stalks to illuminate the depths, making exploration not only safer but more lucrative, as I've heard some survivors use this creature to harvest the silica pearls found throughout the ocean's depths!\n„\n~ Helena")
    models.Creature.new(name='Ankylosaurus', name_tag='Anky', category='Dinosaurs', entity_id='Ankylo_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a7/Ankylosaurus.png',
                        url='https://ark.fandom.com/wiki/Ankylosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Ankylo/Ankylo_Character_BP.Ankylo_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8e/Dossier_Ankylosaurus.png',
                        description="“\nSpecies\nAnkylosaurus crassacutis\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nDocile\nWild\nUnlike many of the herd animals on the Island, Ankylosaurus crassacutis tends to live in small family units. I believe they can afford to stick with smaller groups because of their incredibly thick skin, for which they're named. Despite not being among the largest of the Island's herbivores, Ankylosaurus is one of the more difficult creatures to take down. Its thick, armored skin seems to make it more than a match for several of the mid-sized predators that would otherwise hunt it. Reckless carnivores are just as likely to hurt themselves on Ankylosaurus' spikes, as they are to get hit by its tail.\nDomesticated\nWithout a doubt, the best trait of a trained Ankylosaurus is its enormously dense tail. This tail is powerful enough to quickly shatter the resource-laden rocks of the Island. One of the wealthier human tribes on the island utilizes a squad of Ankylosaurs in its mines and quarries. The creature's affinity for metal enables it to carry raw ore at an effectively reduced weight.\n„\n~ Helena")
    models.Creature.new(name='Araneo', name_tag='Spider', category='Invertebrates', entity_id='SpiderS_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Spider.png',
                        url='https://ark.fandom.com/wiki/Araneo',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Spider-Small/SpiderS_Character_BP.SpiderS_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Dossier_Araneo.png',
                        description="“\nSpecies\nAraneomorphus amalgotantibus\nTime\nNo equivalent, traits begin as far as Mesozoic Era\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nI don't know where to start with Araneomorphus amalgotantibus. It has so many of the nightmare inducing traits of spiders from among many family and genus. It fires webbing like a bola spider, it spits venom like a lynx spider. It has a poisonous bite like a myriad of spiders, and can see in the dark by sensing vibrations. And to top it off, Araneomorphus is larger than an adult human! If that wasn't enough, I'm convinced that some of the caves on the island have actually been dug by Araneomorphus, but this worries me. Either Araneomorphus is a colony-spider (like ants), or there is a much larger Araneomorphus somewhere on the island.\nDomesticated\nAs long as it is kept far from arachnophobics, domesticated Araneomorphus makes an excellent guardian creature for anyone wanting to avoid killing. Their strange web-spraying behavior is also quite helpful while hunting fast, fleeing prey. They are too small to be used as mounts, however...\n„\n~ Helena")
    models.Creature.new(name='Archaeopteryx', name_tag='Archa', category='Birds', entity_id='Archa_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8a/Archaeopteryx.png',
                        url='https://ark.fandom.com/wiki/Archaeopteryx',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Archaeopteryx/Archa_Character_BP.Archa_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f7/Dossier_Archaeopteryx.png',
                        description="“\nSpecies\nArchaeopteryx magnamilvum\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nFearful\nWild\nApproximately one meter long, the Archaeopteryx magnamilvum is a primarily tree-dwelling proto-bird. It avoids the ground as much as possible, preferring to stay in the safety of the tree-line, where few predators can reach it. I've not seen an Archaeopteryx outright fly yet, so it's possible that they cannot generate enough lift to do more than glide long distances between perches. I'm not sure how a creature so fearful of the ground can be such a picky eater, but Archaeopteryx only seems to consume certain rare insect matter. The most likely explanation is that it tends to nest in infested trees, stripping them bare of such food sources.\nDomesticated\nWhile not large enough to bear the full weight of an adult human, Archaeopteryx still has great utility. Despite the creature's inability to fly, its wings have sufficient strength to dramatically slow the rate of a person's descent, if that person holds onto Archaeopteryx while airborne. Taming Archaeopteryx can be somewhat troublesome, though, as it refuses to eat most common food sources, and glides to prospective safety at the first sign of any interloper.\n„\n~ Helena")
    models.Creature.new(name='Argentavis', name_tag='Argent', category='Birds', entity_id='Argent_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Argentavis.png',
                        url='https://ark.fandom.com/wiki/Argentavis',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Argentavis/Argent_Character_BP.Argent_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Dossier_Argentavis.png',
                        description="“\nSpecies\nArgentavis atrocollum\nTime\nLate Miocene\nDiet\nCarrion-Feeder\nTemperament\nShort-Tempered\nWild\nLording over the skies across the Island, Argentavis atrocollum has few aerial rivals. It is a small consolation for the Island's other avian creatures, then, that Argentavis seems to have little interest in anything alive. Quite apart from what I would have guessed, Argentavis does not have the stooped neck typical of modern buzzards and vultures. I don't know if it adapted this stronger neck to deal with the predators on the Island, or if its lineage derives from before the stooped neck became common in carrion-eating birds. Whichever it meant to be, it has enabled Argentavis to carry smaller creatures with its beak.\nDomesticated\nArgentavis is actually slower than the Island's far more common Pteranodon, but it possesses significantly more stamina and can sustain flight for approximately three times as long. Its weighty stature, in comparison to the Pteranodon, allows it to utilize its talons to support the weight of an additional passenger. Considering its saddle doubles as a mobile crafting station, it makes Argentavis an excellent creature for traveling and hauling cargo over long distances.\n„\n~ Helena")
    models.Creature.new(name='Arthropluera', name_tag='Arthro', category='Invertebrates',
                        entity_id='Arthro_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Arthropluera.png',
                        url='https://ark.fandom.com/wiki/Arthropluera',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Arthropluera/Arthro_Character_BP.Arthro_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Dossier_Arthropluera.png',
                        description="“\nSpecies\nArthropluera felsanguis\nTime\nEarly Permian\nDiet\nCarrion-Feeder\nTemperament\nAggressive\nWild\nThe fact that this creature exists is enough to give me nightmares. Like the island's other Arthropods, Arthropluera Felsanguis has become much larger than I might have believed possible. It's a very aggressive hunter, but prefers to eat meat after it has rotted for some time, and will voraciously seek out such delicacies.\nKnown Information\nArthropluera's blood has a very low pH, to the point that it can dissolve many materials. This acidic blood splashes back on anything that directly attacks it, weakening the durability of weapons and hurting attackers. Many creatures thusly refuse to prey on Arthropluera, fearing this unique defense. If that wasn't enough, Arthropluera also keeps a small reservoir of blood ready to spit at its prey.\nDomesticated\nLike most of the arthropods on the island, Arthropluera is simple minded and relatively easy to tame. It is an almost entirely military mount, useful mostly for attacking at a distance. Thanks to its unique defenses, whether hunting or warring, Arthropluera is generally safe from all but the largest of creatures.\n„\n~ Helena")
    models.Creature.new(name='Baryonyx', name_tag='Baryonyx', category='Dinosaurs', entity_id='Baryonyx_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c0/Baryonyx.png',
                        url='https://ark.fandom.com/wiki/Baryonyx',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Baryonyx/Baryonyx_Character_BP.Baryonyx_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Baryonyx.png',
                        description="“\nSpecies\nBaryonyx aquafulgur\nTime\nEarly Cretaceous\nDiet\nPiscivore\nTemperament\nPassive to land creatures, but aggressive to water-dwellers\nWild\nLike the Carnotaurus, Baryonyx aquafulguar is a large carnivore, but not large enough to rival the Island's apex predators. While not as powerful as some deep-sea predators or Spinosaurus, Baryonyx is an extremely fast swimmer who is still sufficiently nimble enough to threaten most creatures on the Island. And yet despite being a fast, dangerous dinosaur, Baryonyx almost exclusively consumes fish and other water-dwellers. The highly specific metabolism of Baryonyx seems to allow it to heal wounds almost preternaturally fast after feeding on nutritious fish meat. Perhaps this is why Baryonyx rarely attacks land animals?\nDomesticated\nBaryonyx's natural affinity for aquatic predation means that once tamed; it learns to kill ocean-dwellers even more efficiently. Between its speed and its power, Baryonyx makes an ideal choice for anyone interested in frequently moving between water and land travel, and who values speed and agility over raw strength.\n„\n~ Helena")
    models.Creature.new(name='Basilosaurus', name_tag='Basilosaurus', category='Mammals',
                        entity_id='Basilosaurus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Basilosaurus.png',
                        url='https://ark.fandom.com/wiki/Basilosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Basilosaurus/Basilosaurus_Character_BP.Basilosaurus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Dossier_Basilosaurus.png',
                        description='“\nSpecies\nBasilosaurus solatiumfecit\nTime\nLate Eocene\nDiet\nPiscivore\nTemperament\nPassive\nWild\nOne of the stranger creatures in the waters surrounding the Island is Basilosaurus solatiumfecit. It\'s a powerful swimmer which has adapted to the shallows so remarkably well that it rapidly recovers from injuries when near the water\'s surface. Conversely, it\'s vulnerable to deep water pressure, which slowly causes it harm. Basilosaurus is usually closely followed by other predatory creatures, as its eating habits leave plenty of scraps for scavengers to consume. It is a gentle creature towards humans and happily laps up food directly from them. However, the creatures that trail the "Basi" tend to become dangerously enraged whenever this occurs, as it leaves no leftovers for them.\nDomesticated\nDespite the hassle of engaging with its ornery followers, many tribes still attempt to tame the Basilosaurus, as its mammalian, warm-blooded circulation provides a rider with perfect comfort from both heat and cold. Being apprehensive in nature, Basilosaurus is equipped with a defense mechanism that prevents it from being stunned or shocked. Alternatively, Basilosaurus is hunted (perhaps too vigorously) for its special blubber, which can be efficiently refined into gasoline!\n„\n~ Helena')
    models.Creature.new(name='Beelzebufo', name_tag='Toad', category='Reptiles', entity_id='Toad_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f6/Beelzebufo.png',
                        url='https://ark.fandom.com/wiki/Beelzebufo',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Toad/Toad_Character_BP.Toad_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Dossier_Beelzebufo.png',
                        description="“\nSpecies\nBeelzebufo palucocus\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nLanguorous\nWild\nBeelzebufo palucocus is the largest frog I've ever seen. Almost impossibly large, it can actually fit a fully-grown human adult on its back, though just barely. This is a dangerous prospect, though, as secretions from Beelzebufo's skin and saliva have a narcotic effect on most creatures. Not surprisingly, Beelzebufo is adept at killing insects. Its lengthy tongue allows it to quickly grab prey from afar, killing most insects near instantly and quickly digesting them. It even combines the narcotic chemicals in its mouth with the insects' chitin to create a specialized sticky substance.\nDomesticated\nTamed Beelzebufo make for strange mounts. Strange mounts for strange people. Many tribes don't believe there's any reason to ride them, but some enjoy the ability to take large vertical hops up huge walls and cliffs. Regardless of how it is ridden, Beelzebufo is also employed for its ability to quickly cull insects, and convert them into always-useful cementing paste.\n„\n~ Helena")
    models.Creature.new(name='Bunny Dodo', name_tag='Dodo', category='Event Creatures', entity_id=None,
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fc/Dodo.png',
                        url='https://ark.fandom.com/wiki/Bunny_Dodo',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dodo/Dodo_Character_BP_Bunny.Dodo_Character_BP_Bunny\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Dossier_Dodo.png',
                        description='“\nSpecies\nRaphus replicare\nTime\nLate Holocene\nDiet\nHerbivore\nTemperament\nOblivious\nWild\nRaphus replicare (more commonly known as the Dodo Bird) is quite possibly the dumbest creature I\'ve ever seen in my life. It wanders around the beaches of the Island, pecking berries off bushes, and being eaten by all manner of carnivore. Without the Dodo, the whole Island\'s food chain would disintegrate. This subspecies of the Dodo has developed an unbelievably clever way to sustain itself: they mate constantly. I\'m fairly convinced that they reach full maturity within a week of being born. This is the only trait keeping them populous on the island.\nDomesticated\nWhile it can be done, there is almost no reason to domesticate a Raphus replicare. It cannot carry enough to be a beast of burden, it does not provide much food, and it\'s too stupid to show companionship. It could work as a last-ditch food source, though, so I suppose keeping some around for "lean times" has a certain logic.\n„\n~ Helena')
    models.Creature.new(name='Bunny Oviraptor', name_tag='Ovi', category='Event Creatures', entity_id=None,
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Oviraptor.png',
                        url='https://ark.fandom.com/wiki/Bunny_Oviraptor',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Oviraptor/BunnyOviraptor_Character_BP.BunnyOviraptor_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e8/Dossier_Oviraptor.png',
                        description="“\nSpecies\nOviraptor philodator\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nOviraptor philodator is a small-to-medium sized carnivore, common in the jungles and beaches of the Island. Despite being a carnivore, Oviraptor's main source of food is eggs, which it steals from nests. Unlike any other creature, Oviraptor seems to be able to surreptitiously steal these eggs, usually without attracting the attention of an irate mother. In an incredible feat of natural selection, Oviraptor seems to emit a chemical pheromone that affects many creatures as an aphrodisiac. Mated creatures are much more likely to…“create” new eggs while Oviraptor is around, which allows the Oviraptor to go about its business unperturbed.\nDomesticated\nToo small to fight or ride, Oviraptor is still one of the more commonly tamed creatures on the Island. Its pheromone ensures an increased stream of eggs from nearby mated wild creatures, for breeding, eating, or cooking kibble. Oviraptor will autonomously do the dirty work of stealing eggs from other tribes or wild dinos on your behalf, without attracting unwanted attention. They also make quite adorable sounds, so many children simply like to keep them around as rather strange companions.\n„\n~ Helena")
    models.Creature.new(name='Brontosaurus', name_tag='Bronto', category='Dinosaurs',
                        entity_id='Sauropod_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/47/Brontosaurus.png',
                        url='https://ark.fandom.com/wiki/Brontosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Sauropod/Sauropod_Character_BP.Sauropod_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f7/Dossier_Brontosaurus.png',
                        description='“\nSpecies\nBrontosaurus lazarus\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nDocile\nWild\nAmong giant creatures I\'ve seen on the Island, Brontosaurus lazarus is larger than any sauropod I\'ve read about. In fact, the dinosaur is so massive that it serenely ignores most other creatures. I\'ve seen a pack of raptors tear apart small dinosaurs while Brontosaurus continues eating, seemingly oblivious to the hunting pack.\nDomesticated\nBecause of how docile it is, the Brontosaurus makes for an ideal pack animal. Peaceful tribes use it to carry incredible quantities of resources, while warring tribes use it to mobilize their army. Its size and strength make it one of the unique creatures on the Island that can support a "platform" saddle. Unfortunately, its enormity means that the process of taming a Brontosaurus can take a very long time. Some may think this is an Apatosaurus, Dreadnoughtus, Argentinosaurus, or some other sauropod, but this is a strange Island, and I\'m the one doing the research. I\'m convinced that this genus is Brontosaurus, and no one can tell me otherwise. My study, my rules.\n„\n~ Helena')
    models.Creature.new(name='Broodmother Lysrix', name_tag=None, category='Bosses', entity_id='SpiderL_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/19/Broodmother.png',
                        url='https://ark.fandom.com/wiki/Broodmother_Lysrix',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Spider-Large/SpiderL_Character_BP.SpiderL_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Dossier_Broodmother.png',
                        description=None)
    models.Creature.new(name='Chalicotherium', name_tag='Chalicotherium', category='Mammals',
                        entity_id='Chalico_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Chalicotherium.png',
                        url='https://ark.fandom.com/wiki/Chalicotherium',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Chalicotherium/Chalico_Character_BP.Chalico_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/28/Dossier_Chalicotherium.png',
                        description='“\nSpecies\nChalicotherium obsidioequus\nTime\nLate Oligocene - Early Pliocene\nDiet\nHerbivore\nTemperament\nTerritorial\nWild\nFound in small numbers within the Island\'s colder regions, Chalicotherium obsidioequus is normally a peaceful herbivore that prefers to spend its days lazing about or playing with its family. It is very territorial, however, and the entire family, young and old, will turn against an encroaching creature at just the slightest provocation. A memorable scene to stumble upon is a group of Chalicotherium playing. One odd playtime activity for Chalicotherium is hurling large balls of snow or.. mud-rocks(?).. at each other. Smaller creatures in the area shy away from Chalicotherium during this exertion, for fear of being buried in snow or "gravel."\nDomesticated\nWhile many creatures are useful while attacking a fortress, Chalicotherium can be trained as mobile artillery. Its unique playtime habit becomes a rather devastating long-range assault tactic when it is given boulders to throw, rather than snowballs!\n„\n~ Helena')
    models.Creature.new(name='Carbonemys', name_tag='Turtle', category='Reptiles', entity_id='Turtle_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4c/Carbonemys.png',
                        url='https://ark.fandom.com/wiki/Carbonemys',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Turtle/Turtle_Character_BP.Turtle_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Carbonemys.png',
                        description="“\nSpecies\nCarbonemys obibimus\nTime\nDanian\nDiet\nHerbivore\nTemperament\nDefensive\nWild\nCarbonemys obibimus is one of the least aggressive creatures on the Island. Were it not for the plethora of predators on the Island, I'm quite certain that it would spend its days basking in the sun, eating, or sleeping. Carbonemys leads a simple, solitary life. Nevertheless, it seems to be one of the most peaceful animals I have yet encountered. With its slow walking speed, the only things that keep it safe are its surprisingly fast swim speed, and its incredibly thick shell, which can absorb tremendous damage.\nDomesticated\nCarbonemys' swift swim rate, fairly high strength, superior shell defenses, and lack of real threat makes it an ideal armored mount for many survivors who shy away from violence. It can carry its rider to the ocean's resources at fairly high speed, and is not particularly dangerous to tame.\n„\n~ Helena")
    models.Creature.new(name='Carnotaurus', name_tag='Carno', category='Dinosaurs', entity_id='Carno_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Carnotaurus.png',
                        url='https://ark.fandom.com/wiki/Carnotaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Carno/Carno_Character_BP.Carno_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Carnotaurus.png',
                        description="“\nSpecies\nCarnotaurus pressor\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nCarnotaurus pressor is a distinctive creature that falls between a medium and large predator. It lives primarily on flat, clear ground, where it can capitalize on its speed. Additionally, it seems to have no qualms about running away from larger predators instead of fighting. The horns of the Carnotaurus seem to be used more for fighting rivals than actual hunting. This doesn't mean the horns aren't dangerous, though. They can still eviscerate larger prey. Carnotaurus is one of the smaller and more compact of the large predators. If Tyrannosaurus is the “lion” of the Island, Carnotaurus would certainly be the “cheetah.” The real threat of a Carnotaurus is not being able to escape it once it has spotted you.\nDomesticated\nCarnotaurus fills a very specific role. Larger and almost as fast as a Raptor, smaller but much faster than a Rex. Were it not for the creature's extremely long down-time after sprinting, it might be among the most capably balanced mounts.\n„\n~ Helena")
    models.Creature.new(name='Castoroides', name_tag='Beaver', category='Mammals', entity_id='Beaver_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/af/Giant_Beaver.png',
                        url='https://ark.fandom.com/wiki/Castoroides',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Beaver/Beaver_Character_BP.Beaver_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/01/Dossier_Castoroides.png',
                        description="“\nSpecies\nCastoroides feliconcisor\nTime\nLate Pliocene - Late Pleistocene\nDiet\nHerbivore\nTemperament\nFriendly\nWild\nCastoroides is a large, mammalian herbivore that tends to live near water. Unlike other larger beaver species this one retains the chisel-shaped teeth of modern beavers. As is typical for beavers, they build dams as habitats, but the larger creatures on the island have a tendency to trample them. As a result, finding unsullied dams in the wild is quite rare. Castoroides itself doesn't seem to realize how dangerous the island is. I don't know if it's simply too dumb to notice the dangers, or if it just doesn't care...but Castoroides happily goes about its day playing in the water and gnawing on wood.\nDomesticated\nThe value of a tamed Castoroides is obvious from its physiology. The creature naturally gathers wood extremely efficiently, far more than most species on the island. It's not the strongest creature, so it can only carry limited amounts, but it is a natural lumberjack!\n„\n~ Helena")
    models.Creature.new(name='Cnidaria', name_tag='Cnidaria', category='Invertebrates',
                        entity_id='Cnidaria_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Cnidaria.png',
                        url='https://ark.fandom.com/wiki/Cnidaria',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Cnidaria/Cnidaria_Character_BP.Cnidaria_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Cnidaria.png',
                        description="“\nSpecies\nCnidaria omnimorph\nTime\nCambrian - Holocene\nDiet\nHerbivore\nTemperament\nPassive, but aggressive at close range\nWild\nCnidaria omnimorph is another example of a creature which should not exist. It has traits that seem derived from many types of jellyfish. It possesses the size and shape of large egg-yolk jellies, the powerful sting of certain box jellies, and the bioluminescence of deep-sea jellies. This all combines to make a dangerous creature that lights up the deepest reaches of the ocean. Cnidaria is not generally aggressive, because it lacks normal perceptive senses. It generally just floats along on the current until something gets close enough to sense, at which point it attacks. While its attacks are not directly powerful, its sting injects an incredibly strong and fast-acting sedative.\nDomesticated\nAs Cnidaria is barely more intelligent than a plant, there's no effective method to tame one. Most tribes kill Cnidaria on sight, then collect its reserve of powerful sedative, to use in technically advanced long-distance tranquilizers.\n„\n~ Helena")
    models.Creature.new(name='Coelacanth', name_tag='Coel', category='Fish', entity_id='Coel_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4b/Coelacanth.png',
                        url='https://ark.fandom.com/wiki/Coelacanth',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Coelacanth/Coel_Character_BP.Coel_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1b/Dossier_Coelacanth.png',
                        description="“\nSpecies\nCoelacanth nutritia\nTime\nCretaceous-Holocene\nDiet\nOmnivore?\nTemperament\nReactive\nWild\nCoelacanth nutritia is one of the few creatures on the Island with a relative which can be found back home. The Coelacanth thrive in the waters around the Island, as well as within rivers and lakes. Unlike most Coelacanths, Coelacanth nutritia meat contains less oil and urea. In fact, it is one of the healthier sources of meat I've yet found. Most Coelacanths are opportunistic feeders that eat anything smaller than itself, likely including baby water snakes, insect and plant life, and perhaps each other?\nDomesticated\nWhile their limited intelligence makes them unsuitable for taming, Coelacanths provide a viable source of meat for coastal or water-dwelling tribes. Many a day has been spent fishing by the water's edge, often with surprising results, as Coelacanths often have consumed discarded garbage that is sometimes of great value. Due to their small size, though, a larger tribe would require a significant number of Coelacanths to feed itself.\n„\n~ Helena")
    models.Creature.new(name='Compy', name_tag='Compy', category='Dinosaurs', entity_id='Compy_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Compy.png',
                        url='https://ark.fandom.com/wiki/Compy',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Compy/Compy_Character_BP.Compy_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bc/Dossier_Compy.png',
                        description='“\nSpecies\nCompsognathus curiosicarius\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nCurious\nWild\nOne of the smallest predators on the Island, Compsognathus curiosicarius can be seen as a pet, a pest, or a threat. While alone, Compsognathus is not dangerous or aggressive. In larger packs, however, it remembers its underlying carnivorous nature. After a group of Compsognathus grows to a certain size, their pack mentality always seems to embolden them to “attack.” For some reason, Compsognathus is not naturally afraid of humans. Rather, it seems to be quite curious about humans and their instruments of survival. They tend to be drawn toward humans out of this curiosity, and then call their pack mates to help explore their discovery. This usually leads to the aforementioned pack aggression, with dangerous results.\nDomesticated\nCompsognathus gain increasingly significant attack power and speed when in close proximity to other Compsognathus, as their pack aggression takes over their behavior. Additionally, their distress call carries quite far, rapidly alerting the tribe and its pets to danger more efficiently, and increasing the likelihood of forming a so-called "Compy Gang."\n„\n~ Helena')
    models.Creature.new(name='Daeodon', name_tag='Daeodon', category='Mammals', entity_id='Daeodon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Daeodon.png',
                        url='https://ark.fandom.com/wiki/Daeodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Daeodon/Daeodon_Character_BP.Daeodon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a9/Dossier_Daeodon.png',
                        description='“\nSpecies\nDaeodon comedentis\nTime\nLate Oligocene\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nNice Daeodon comedentis is the largest known species of Entelodont, an omnivorous family of ancient mammals that are sometimes referred to as "Hell Pigs." Even though Daeodon has as many similarities to modern Hippopotamidae as it does to Suina, I\'ve found that to be a suitable nickname. Daeodon is as mean as it looks, and any survivor who wanders too close will find that out the hard way. As an omnivore with a voracious appetite, Daeodon scavenges, forages, and hunts to survive. It has little qualms when it comes to its diet, and that has helped it thrive on the Island\'s harsh tundra. Its temper hasn\'t hurt either, as many would be predators would rather seek out less vicious prey.\nDomesticated\nMany tribes have made excellent use of Daeodon packs within their war parties, not only because of its fierce nature, but due to its extraordinary ability to rapidly heal itself. I\'ve theorized that this healing factor is why it seems to have such a high metabolism, though what is particularly extraordinary is its capability to share this benefit with nearby creatures. I have even heard some survivors mention that the Daeodon also has a unique ability to root out Rare Mushrooms as well!\n„\n~ Helena')
    models.Creature.new(name='Dilophosaur', name_tag='Dilo', category='Dinosaurs', entity_id='Dilo_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c9/Dilophosaur.png',
                        url='https://ark.fandom.com/wiki/Dilophosaur',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dilo/Dilo_Character_BP.Dilo_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6c/Dossier_Dilophosaur.png',
                        description='“\nSpecies\nDilophosaurus sputatrix\nTime\nEarly Jurassic\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nDilophosaurus sputatrix is a strange creature. It stands at just over half the size of known Dilophosaurs and runs from aggressors as often as it fights them. Dilophosaurus sputatrix has a few traits not common in the Dilophosaurus genus. It has a very shrill call, and a decorative ridge of skin on its neck. I believe these are used to attract mates, as well as intimidate prey and would-be predators. Instead of attacking its prey outright, Dilophosaurus sputatrix spits venom to weaken and paralyze it before moving in for the kill.\nDomesticated\nBecause of their shrill cry and their ability to attack intruders from range, Dilophosaurus seem most suited as "guard dogs." Due to their small size, they are not suitable as mounts.\n„\n~ Helena')
    models.Creature.new(name='Dimetrodon', name_tag='Dimetro', category='Dinosaurs', entity_id='Dimetro_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Dimetrodon.png',
                        url='https://ark.fandom.com/wiki/Dimetrodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dimetrodon/Dimetro_Character_BP.Dimetro_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8d/Dossier_Dimetrodon.png',
                        description="“\nSpecies\nDimetrodon calorector\nTime\nEarly Permian\nDiet\nCarnivore\nTemperament\nReactive\nWild\nDimetrodon calorector is a much calmer predator than most on the Island. Because it lives off smaller prey than humans, it generally ignores anything much larger than a Coelacanth. Dimetrodon is one of the few carnivores on the Island that could be classified as reasonably friendly in the wild. The sail on Dimetrodon's back is an especially fascinating thing. It can be angled to provide shade from the sun and allows Dimetrodon to disperse heat more quickly. The inner workings of the sail can also restrict blood flow in the creature to hold in excessive heat. Together, these two traits allow Dimetrodon to comfortably survive in any climate, though they are most commonly found in the swamplands which are rich in prey.\nDomesticated\nIf Dimetrodon was a bit larger, or didn't have that massive sail, it would make a decent mount. However, its main use to survivors is to utilize the sail's insulating capabilities. Just being near Dimetrodon gives excellent protection from both heat and cold, which has saved my life through more than one ice blizzard in the frozen northlands.\n„\n~ Helena")
    models.Creature.new(name='Dimorphodon', name_tag='Dimorph', category='Dinosaurs',
                        entity_id='Dimorph_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Dimorphodon.png',
                        url='https://ark.fandom.com/wiki/Dimorphodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dimorphodon/Dimorph_Character_BP.Dimorph_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/Dossier_Dimorphodon.png',
                        description="“\nSpecies\nDimorphodon equesica\nTime\nEarly Jurassic\nDiet\nCarnivore\nTemperament\nReactive\nWild\nDimorphodon equesica is another of the Island's Jekyll-and-Hyde creatures. It is normally passive, sometimes even friendly. When provoked, it becomes very aggressive, even against larger creatures it has no business fighting...often to its own fatal end. Dimorphodon can make short work of smaller opponents, however, due to its large (but lightweight) skull and teeth. Barely over a meter tall, Dimorphodon should be low on the food chain, but its incredible speed and surprisingly strong bite make it fairly dangerous, especially en masse as they tend to attack in groups. A flock of angry or hungry Dimorphodon can take down prey several times their size, so survivors should take care not to hunt near where a flock is gathered.\nDomesticated\nDimorphodon is one of the creatures on the Island that is easily domesticated for companionship, but its use in combat is also quite clear: It will hunt in large groups to seek out enemy dino riders directly, harassing them to no end, regardless of the might of their mount!\n„\n~ Helena")
    models.Creature.new(name='Diplocaulus', name_tag='Diplocaulus', category='Amphibians',
                        entity_id='Diplocaulus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Diplocaulus.png',
                        url='https://ark.fandom.com/wiki/Diplocaulus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Diplocaulus/Diplocaulus_Character_BP.Diplocaulus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/af/Dossier_Diplocaulus.png',
                        description="“\nSpecies\nDiplocaulus natatorinutrix\nTime\nPermian\nDiet\nPiscivore\nTemperament\nSkittish\nWild\nPresiding almost solely within the Island's swamps, Diplocaulus natatorinutrix is a small amphibian that primarily eats minor fish. It rounds out what I consider to be the middle-bottom of the ecosystem, feeding on the tinier non-insect creatures of the Island while itself being a common snack for the larger carnivores. Because so many creatures prey on it, Diplocaulus has become very skittish and often flees at the first sign of trouble. It uses its amphibious nature to escape into whichever environment its predator isn't native to. Diplocaulus' unique capability to retain vast quantities of oxygen allows it to effectively remain submerged for hours at a time, usually outlasting even other amphibious creatures that might otherwise prey upon it.\nDomesticated\nThere are only a few uses for tamed Diplocaulus. It is primarily kept for the (rather disgusting) practice of employing a Diplocaulus as an oxygen bag. Diplocaulus stores air in the bladders of its head, and divers can suck from these bladders to take deep breaths while submerged, supporting long-term underwater exploration without the use of external gear. Surprisingly, Diplocaulus is also extremely efficient when it comes to hunting Trilobites.\n„\n~ Helena")
    models.Creature.new(name='Diplodocus', name_tag='Diplo', category='Dinosaurs',
                        entity_id='Diplodocus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e6/Diplodocus.png',
                        url='https://ark.fandom.com/wiki/Diplodocus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Diplodocus/Diplodocus_Character_BP.Diplodocus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Dossier_Diplodocus.png',
                        description='“\nSpecies\nDiplodocus insulaprincep\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nNaive\nWild\nDespite being one of the Island\'s largest creatures, Diplodocus insulaprincep is among the Island\'s smaller sauropods. Instead of size and intelligence, Diplodocus developed faster maximum speed and greater endurance. When fully matured, it generally only reaches about half the size of the rather enormous Brontosaurus. Diplodocus is another creature whose continued survival on the Island confuses me. It\'s a very thick-headed and trusting animal, often to its fatal detriment. It never flees from predators until after they\'ve attacked it repeatedly, preferring instead to make numerous fruitless attempts at friendship. For some strange reason, Diplodocus trusts humans so much that it doesn\'t seem to fight back against them…ever!\nDomesticated\nDue to Diplodocus\' smaller frame, it cannot support the type of "platform" saddle that other large creatures can. To make up for this, many tribes instead use an eleven-seater passenger saddle which enables Diplodocus to safely transport ten additional riders. These passengers often use ranged weapons to protect the creature, or to attack nearby enemies while on the move!\n„\n~ Helena')
    models.Creature.new(name='Dire Bear', name_tag='Direbear', category='Mammals', entity_id='Direbear_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6f/Dire_Bear.png',
                        url='https://ark.fandom.com/wiki/Dire_Bear',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Direbear/Direbear_Character_BP.Direbear_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/20/Dossier_Dire_Bear.png',
                        description="“\nSpecies\nArctodus dirus\nTime\nMid Pleistocene - Early Holocene\nDiet\nOmnivore\nTemperament\nTerritorial\nWild\nFound primarily among the Island's redwood regions, Arctodus dirus is an imposing creature. Many on the island have started calling it a Direbear, a name which is appropriate, both due to its enormity and its territorial nature. The Direbear ignores most non-hostile creatures while going about its daily routine of scavenging for meat and edible plant life... ...that is, until intruders enter the territory it considers its own, at which point the creature ferociously attacks. Most often, it is smartest to just run from an angry Direbear.\nDomesticated\nOnce tamed, the Direbear is a strong and reliable mount. It can carry vast quantities of goods, and can sprint for extremely long, nearly infinite periods. It is not the fastest creature from a hard stop, but after building up momentum, its sustained overland speed builds to among the best of the island. Of course, being able to feed a direbear both meat and plant life makes keeping one fairly convenient regardless of the environment. Arctodus has a fondness for honey and can harvest it without getting stung or destroying the hive. Perhaps more rewarding while you are riding it, those pesky bees will completely ignore you.\n„\n~ Helena")
    models.Creature.new(name='Direwolf', name_tag='Direwolf', category='Mammals', entity_id='Direwolf_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/10/Direwolf.png',
                        url='https://ark.fandom.com/wiki/Direwolf',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Direwolf/Direwolf_Character_BP.Direwolf_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Direwolf.png',
                        description='“\nSpecies\nCanis maxdirus\nTime\nPleistocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThe best adjective to describe Canis maxdirus is "scary." This pack-animal is a cunning and brutal predator, capable of taking down prey of nearly any size. In addition to being a vicious hunter, it is the size of a small horse, meaning even the largest predators aren\'t necessarily safe from the packs. Unlike most creatures on the Island, Canis is a dedicated pack hunter, and rarely hunts alone. When in a pack, Canis are naturally spurred to fight for their lives with increased effectiveness, while the most experienced Canis will be designated “Alpha” and gain an even stronger enhancement! The species has an incredible affinity for teamwork.\nDomesticated\nObviously, Canis is a thrilling battle mount. It is fairly fast, very strong, and agile. It can leap almost as well as the Island\'s battle-cats. Riding a supercharged “Alpha” Canis into battle at the head of a bloodthirsty pack is a thrill for which most warriors would gladly proclaim: "today is a good day to die!" If utilized correctly, Canis can be a useful aid in your discovery efforts. It has developed a keen sense of smell that enables it to detect things that most creatures can\'t. I\'ve even seen them used to find creatures that are hidden beneath the surface.\n„\n~ Helena')
    models.Creature.new(name='Direwolf Ghost', name_tag='Direwolf', category='Event Creatures',
                        entity_id='Ghost_Direwolf_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Direwolf_Ghost.png',
                        url='https://ark.fandom.com/wiki/Direwolf_Ghost',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Direwolf/Ghost_Direwolf_Character_BP.Ghost_Direwolf_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Direwolf_Ghost_Image.jpg',
                        description=None)
    models.Creature.new(name='Dodo', name_tag='Dodo', category='Birds', entity_id='Dodo_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fc/Dodo.png',
                        url='https://ark.fandom.com/wiki/Dodo',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dodo/Dodo_Character_BP.Dodo_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Dossier_Dodo.png',
                        description='“\nSpecies\nRaphus replicare\nTime\nLate Holocene\nDiet\nHerbivore\nTemperament\nOblivious\nWild\nRaphus replicare (more commonly known as the Dodo Bird) is quite possibly the dumbest creature I\'ve ever seen in my life. It wanders around the beaches of the Island, pecking berries off bushes, and being eaten by all manner of carnivore. Without the Dodo, the whole Island\'s food chain would disintegrate. This subspecies of the Dodo has developed an unbelievably clever way to sustain itself: they mate constantly. I\'m fairly convinced that they reach full maturity within a week of being born. This is the only trait keeping them populous on the island.\nDomesticated\nWhile it can be done, there is almost no reason to domesticate a Raphus replicare. It cannot carry enough to be a beast of burden, it does not provide much food, and it\'s too stupid to show companionship. It could work as a last-ditch food source, though, so I suppose keeping some around for "lean times" has a certain logic.\n„\n~ Helena')
    models.Creature.new(name='DodoRex', name_tag='DodoRex', category='Event Creatures',
                        entity_id='DodoRex_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Rex.png',
                        url='https://ark.fandom.com/wiki/DodoRex',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/DodoRex/DodoRex_Character_BP.DodoRex_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
                        description='“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena')
    models.Creature.new(name='Doedicurus', name_tag='Doed', category='Mammals', entity_id='Doed_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8b/Doedicurus.png',
                        url='https://ark.fandom.com/wiki/Doedicurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Doedicurus/Doed_Character_BP.Doed_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d1/Dossier_Doedicurus.png',
                        description='“\nSpecies\nDoedicurus custosaxum\nTime\nPlestiocene – Holocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nDoedicurus custosaxum is one of the Island\'s non-aggressive herbivores, generally found in the mountains and grasslands. Large and well-armored, it has a supply of fat under its plates to keep it warm and fed in the cold. Doedicurus has adapted well to the dangers of the Island, perhaps even better than the Ankylosaurus. Doedicurus has two very different reactions to predators. Against smaller foes, it generally uses its spiked tail to inflict as much damage as possible. Against larger predators, however, it pulls its tail underneath itself to form a solid armored ball that is nearly impossible for creatures to pierce, from which it can actually "roll" away to relative safety!\nDomesticated\nDoedicurus is a highly prized work animal on the island. Its spiked tail is ideal for quickly shattering the large rocks, so Doedicurus is a very efficient quarry worker. In addition, its affinity for rocks has allowed it to carry stone at a reduced weight. In case their quarry gets raided, Doedicurus-riders have a very difficult-to-kill mount!\n„\n~ Helena')
    models.Creature.new(name='Dragon (Gamma)', name_tag=None, category='Bosses',
                        entity_id='Dragon_Character_BP_Boss_Easy_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c7/Dragon.png',
                        url='https://ark.fandom.com/wiki/Dragon_(Gamma)',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dragon/Dragon_Character_BP_Boss_Easy.Dragon_Character_BP_Boss_Easy\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/05/Dossier_Dragon.png',
                        description=None)
    models.Creature.new(name='Dragon (Beta)', name_tag=None, category='Bosses',
                        entity_id='Dragon_Character_BP_Boss_Medium_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c7/Dragon.png',
                        url='https://ark.fandom.com/wiki/Dragon_(Beta)',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dragon/Dragon_Character_BP_Boss_Medium.Dragon_Character_BP_Boss_Medium\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/05/Dossier_Dragon.png',
                        description=None)
    models.Creature.new(name='Dragon (Alpha)', name_tag=None, category='Bosses',
                        entity_id='Dragon_Character_BP_Boss_Hard_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c7/Dragon.png',
                        url='https://ark.fandom.com/wiki/Dragon_(Alpha)',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dragon/Dragon_Character_BP_Boss_Hard.Dragon_Character_BP_Boss_Hard\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/05/Dossier_Dragon.png',
                        description=None)
    models.Creature.new(name='Dung Beetle', name_tag='Bettle', category='Invertebrates',
                        entity_id='DungBeetle_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b4/Dung_Beetle.png',
                        url='https://ark.fandom.com/wiki/Dung_Beetle',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/DungBeetle/DungBeetle_Character_BP.DungBeetle_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Dossier_Dung_Beetle.png',
                        description="“\nSpecies\nScarabidae gigas\nTime\nHolocene\nDiet\nCoprophagic\nTemperament\nPassive\nWild\nWhat magic created the Scarabidae gigas, I cannot say. What I can say is that this creature is a perfect symbiont for advanced human tribes. Coprophagic, it eats mostly useless waste (feces). It metabolizes this waste into a more refined waste product, along with an oily byproduct. The oily byproduct is chemically the same as the oil found in the oceans around the island. Somehow, Scarabidae converts feces into oil. If that wasn't reason enough to worship the Scarabidae, the refined waste product is almost identical to fertilizer from a compost bin.\nDomesticated\nScarabidae makes me think humans have been on the island for a long time. Why else would a creature evolve to be such a perfect pet? Most tribes jealously protect their Scarabidae, whom are handily tamed with the skilled use of some well-handled feces. These wondrous little organic biofactories are truly a sustainable, green, eco-friendly source of resources for living off the land. Oil becomes gas, which is generator fuel. Fertilizer means crops, which is human fuel. The Scarabidae can power all aspects of island life!\n„\n~ Helena")
    models.Creature.new(name='Dunkleosteus', name_tag='Dunkle', category='Fish', entity_id='Dunkle_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e5/Dunkleosteus.png',
                        url='https://ark.fandom.com/wiki/Dunkleosteus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dunkleosteus/Dunkle_Character_BP.Dunkle_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3d/Dossier_Dunkleosteus.png',
                        description="“\nSpecies\nDunkleosteus loricaruptor\nTime\nLate Devonian\nDiet\nCarnivore\nTemperament\nDocile\nWild\nDunkleosteus loricaruptor is a very strange creature. It is a fairly large fish, covered head to tail in armored plates, with incredibly powerful jaws. It tends to eat the Island's water-dwelling crustaceans trawling the seabed, as it is not fast enough to catch most of the smaller fish. Dunkleosteus is surprisingly combat-oriented for a fish. Its well-armored body protects it from many creatures, while its bite is strong enough to easily crush through chitinous shells.\nDomesticated\nDunkleosteus is an incredibly useful fish for coastal communities. Its powerful jaws make short work of the stone and oil formations found throughout the oceanic depths. While harvesting, Dunkleosteus can defend its rider from all but the largest threats in the waters. And once it is past its prime, the Dunkleosteus itself can be harvested for a fair amount of chitin.\n„\n~ Helena")
    models.Creature.new(name='Electrophorus', name_tag='Eel', category='Fish', entity_id='Eel_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a0/Electrophorus.png',
                        url='https://ark.fandom.com/wiki/Electrophorus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Eel/Eel_Character_BP.Eel_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Dossier_Electrophorus.png',
                        description='“\nSpecies\nElectrophorus beluadomito\nTime\nHolocene\nDiet\nCarnivore\nTemperament\nReactive\nWild\nOccupying a space in the low-to-middle end of the food chain, Electrophorus beluadomito is a carnivorous swimmer that feeds mostly off of shellfish and small fish. Despite its common name, it is actually a very long Knifefish, and not an Eel. It does not provide much meat, so many predators simply leave it be. Unlike most predators, it does not use brute strength to bring down its prey, but instead releases an electrical charge around itself to knock its prey unconscious. Alone, this can take out a small creature. When attacking together, Electrophorus can even bring down the larger ocean lifeforms, and then feed as a group.\nDomesticated\nBy far, the most common use of Electrophorus is to subdue large ocean creatures. Knocking out a Plesiosaur or other giant deep-sea leviathan can be incredibly difficult... ...thus many tribes employ small schools of Electrophorus to shock them into submission!\n„\n~ Helena')
    models.Creature.new(name='Equus', name_tag='Equus', category='Mammals', entity_id='Equus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Equus.png',
                        url='https://ark.fandom.com/wiki/Equus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Equus/Equus_Character_BP.Equus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Dossier_Equus.png',
                        description="“\nSpecies\nEquus magnus\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nLoyal\nWild\nEquus magnus appears to be an ancestor of the modern horse. Based on its stripes, it may be the African variant of Equus giganteus, which appeared in North America during the Ice Age, but that is pure conjecture. Its behavior in the wild is similar to that of other wild members of the Equus genus - it sustains itself by grazing, while keeping safe from predators by living in herds and outrunning its attackers via superior speed and stamina.\nDomesticated\nHorse and man have long been partners in survival, and this remains true on the Island. In Equus, survivors will find a trusty steed or pack animal that can carry them swiftly across land. Taming an Equus has proven interesting, requiring carefully approaching the creature in the wild, mounting it, and then carefully soothing over time by feeding it vegetables. In fact, Equus' reliability has lead some survivors to construct special saddles for them. I even encountered a man who added extra saddle-pouches that doubled as mobile crafting stations for chemical supplies, foodstuffs, and other items. Although not as robust as what you might find within a village, this utility helped him live a nomadic, solitary lifestyle. Some survivors employ Equus to herd and wrangle other creatures with a specialized lasso. This tool is sometimes effective for self-defense as well, as Equus is limited in battle on its own...at least compared to aggressive prehistoric carnivores.\n„\n~ Helena")
    models.Creature.new(name='Unicorn', name_tag='Equus', category='Mammals', entity_id='Equus_Character_BP_Unicorn_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7e/Unicorn.png',
                        url='https://ark.fandom.com/wiki/Unicorn',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Equus/Equus_Character_BP_Unicorn.Equus_Character_BP_Unicorn\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/52/Equus-Unicorn.jpg',
                        description=None)
    models.Creature.new(name='Eurypterid', name_tag='Euryp', category='Invertebrates', entity_id='Euryp_Character_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Eurypterid.png',
                        url='https://ark.fandom.com/wiki/Eurypterid',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Eurypterid/Euryp_Character.Euryp_Character\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b9/Dossier_Eurypterid.png',
                        description="“\nSpecies\nJaekelopterus eurypterus\nTime\nSilurian\nDiet\nCarnivore\nTemperament\nAggressive if approached\nWild\nFound only in the deepest depths of the waters around the Island, Eurypterids are dangerous and adaptable arthropods. As likely to hunt as they are to scavenge, a Eurypterid rarely has difficulty finding food to keep itself nourished, even at the bottom of the ocean. An Eurypterid's threat comes not directly from its raw strength. Instead, it combines a hard defensive exoskeleton with debilitating poison to powerful effect. The sting of a Eurypterid increases torpor while reducing stamina, quickly rendering its opponent unable to defend itself.\nDomesticated\nWhile Eurypterids are not intelligent enough to be tamed, this doesn't mean they are without utility to tribes. They are a wonderful source of chitin, and their digestive tract often contains Silica pearls. They sometimes even have ingested incredibly rare Black Pearls, used by survivors for advanced manufacturing, making them among the most valuable creatures on the island.\n„\n~ Helena")
    models.Creature.new(name='Gallimimus', name_tag='Galli', category='Dinosaurs', entity_id='Galli_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/ce/Gallimimus.png',
                        url='https://ark.fandom.com/wiki/Gallimimus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Gallimimus/Galli_Character_BP.Galli_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f3/Dossier_Gallimimus.png',
                        description="“\nSpecies\nGallimimus evolvelox\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nWhen someone asks me what the fastest creatures on the island are, Gallimimus is always a contender. Unlike the Island's many armored animals, Gallimimus eschews strong defenses for the ability to outrun pretty much anything. A skittish herbivore, Gallimimus even looks nervous when eating in a peaceful, clear meadow. Having no real way to harm predators, it simply runs away and uses its agility to stay safe. I've even seen wild Gallimimus outrun speed-trained Utahraptors!\nDomesticated\nThere are two general camps on the use of tamed Gallimimus. One camp thinks that their inability to effectively harm hostile creatures, and their inability to harvest most resources, makes them primarily a burden to the tribe. The other camp thinks that their extreme speed and ability to jump long distances, is among the best for scouting and exploring. However, both camps agree that its ability to quickly transport multiple tribe members is uniquely beneficial.\n„\n~ Helena")
    models.Creature.new(name='Giant Bee', name_tag='Bee', category='Invertebrates', entity_id='Bee_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/45/Giant_Bee.png',
                        url='https://ark.fandom.com/wiki/Giant_Bee',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Bee/Bee_Character_BP.Bee_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Dossier_Giant_Bee.png',
                        description='“\nSpecies\nApis lithohermaea\nTime\nMiddle Miocene\nDiet\nHerbivore\nTemperament\nTerritorial\nWild\nIn the wild, Apis lithohermaea Drones never stray far from their nests, which they build high in the Island’s Redwood trees or on rocky cliffsides. Apis Drones can be seen swarming around the nest in groups, but to get a look at the Queen Apis, one would need to crack open the nest itself. Speaking from experience, this is not a pleasant task, as the untameable Apis Drones are quite territorial. I probably should have seen that one coming, in hindsight. Take caution: Apis stings will significantly weaken any creature which suffers them, and because its stinger is not barbed, Apis can sting multiple times without its stinger being ripped away.\nDomesticated\nA tamed Apis Queen will lay new drone eggs, and construct a nest that survivors can farm for honey, so long as they remember to wear specialized bee-keeping gear. Said honey is not only sweet and delicious, but laced with scents that land mammals find irresistible. Many hunters use it to bait their traps. Apis Drones will also follow their Queen into battle, so they can be used for self-defense in a pinch.\n„\n~ Helena')
    models.Creature.new(name='Giganotosaurus', name_tag='Gigant', category='Dinosaurs',
                        entity_id='Gigant_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Giganotosaurus.png',
                        url='https://ark.fandom.com/wiki/Giganotosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Giganotosaurus/Gigant_Character_BP.Gigant_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
                        description='“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena')
    models.Creature.new(name='Gigantopithecus', name_tag='Bigfoot', category='Mammals',
                        entity_id='Bigfoot_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Gigantopithecus.png',
                        url='https://ark.fandom.com/wiki/Gigantopithecus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Bigfoot/Bigfoot_Character_BP.Bigfoot_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Dossier_Gigantopithecus.png',
                        description="“\nSpecies\nGigantopithecus fibrarator\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nTerritorial\nWild\nGigantopithecus fibrarator is a strange creature. It is usually quite passive, but it has a very short temper when it comes to its own personal space. Once another creature gets close, this gentle giant quickly becomes a rampaging beast. Best to give them a wide berth. I have occasionally seen Gigantopithecus jumping to grab vines that it can traverse and swing on, but otherwise, it seems most happy to lay about, picking berries from plants lazily.\nDomesticated\nIn addition to being at home picking berries, a tamed Gigantopithecus can be taught to harvest the fibers found on many Island plants as well. It appears to be entirely content to pick at plants all day, eat the berries, and carrying fiber resources for its tribe. Playful once tamed, Gigantopithecus seems to enjoy throwing the creatures or riders it's carrying into the air. It probably feels that this activity is a game, but clever brigands can use this ‘game' to vault over walls and small cliffs.\n„\n~ Helena")
    models.Creature.new(name='Hesperornis', name_tag='Hesperornis', category='Birds',
                        entity_id='Hesperornis_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cf/Hesperornis.png',
                        url='https://ark.fandom.com/wiki/Hesperornis',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Hesperornis/Hesperornis_Character_BP.Hesperornis_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f8/Dossier_Hesperornis.png',
                        description='“\nSpecies\nHesperornis avenatantes\nTime\nLate Cretaceous\nDiet\nPiscivore\nTemperament\nPassive\nWild\nPossessing the appearance of a half-duck/half-dinosaur, Hesperornis is a medium-sized, fish-eating bird, common in the rivers and lakes of the island. It would be about two-thirds the height of a human if it stood tall, but it rarely does. Hesperornis spends most of its time gliding along the surface of the water, where it is much more maneuverable. Hesperornis is barely a threat to any land-dwelling creature, as its legs are too short for it to move around effectively, but it is surprisingly fast in the water. It can easily hunt down fish and other small water-dwelling creatures.\nDomesticated\nNot particularly useful for hunting, and not being affectionate, Hesperornis is primarily kept for the eggs it produces after consuming much fish. When rendered correctly, the eggs separate into two useful substances. One is a protein substance that is high in calories, and the other is an oily liquid that is effectively the same as the Oil found in the ocean!\n„\n~ Helena')
    models.Creature.new(name='Human (Male)', name_tag=None, category='Mammals', entity_id=None,
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6e/Human.png',
                        url='https://ark.fandom.com/wiki/Human_(Male)',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/PlayerPawnTest_Male.PlayerPawnTest_Male\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d0/HumansB.png',
                        description=None)
    models.Creature.new(name='Human (Female)', name_tag=None, category='Mammals', entity_id=None,
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6e/Human.png',
                        url='https://ark.fandom.com/wiki/Human_(Female)',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/PlayerPawnTest_Female.PlayerPawnTest_Female\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d0/HumansB.png',
                        description=None)
    models.Creature.new(name='Hyaenodon', name_tag='Hyaenodon', category='Mammals',
                        entity_id='Hyaenodon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Hyaenodon.png',
                        url='https://ark.fandom.com/wiki/Hyaenodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Hyaenodon/Hyaenodon_Character_BP.Hyaenodon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Hyaenodon.png',
                        description="“\nSpecies\nHyaenodon dirus\nTime\nLate Eocene - Early Miocene\nDiet\nCarnivore\nTemperament\nOpportunistic\nWild\nAmong the Island's most tenacious pack is Hyaenodon dirus, a carnivore most often found across the mountains and tundras in packs of 3 to 6. The Hyaenodon is a very intelligent predator. Before engaging, it determines if the payoff for a fight is worth the risk of injury. Hyaenodon often prefers not to fight unless there is already weakened prey or a fresh carcass nearby. This temperament changes quickly, though, near the presence of injured creatures. Hyaenodon quickly becomes very aggressive... ...and the pack attacks with ruthless abandon. With each vicious chomp of scavenged meat, the Hyaenodon rapidly recovers health and stamina.\nDomesticated\nDespite being too small to ride, Hyaenodon are still popular pets. Their intelligence means they train well, and their natural pack mentality makes them excellent hunting dogs. Their ability to quickly recover health by consuming raw flesh off the bone ensures they can take punishment yet continue to fight, and they can efficiently preserve meat in specially-crafted saddle-bags. A common (and terrifying) sight on the tundra is a rider on a Canis with a pack of Hyaenodon at its side, howls and jeers echoing through the night.\n„\n~ Helena")
    models.Creature.new(name='Ichthyornis', name_tag='Ichthyornis', category='Birds',
                        entity_id='Ichthyornis_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Ichthyornis.png',
                        url='https://ark.fandom.com/wiki/Ichthyornis',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Ichthyornis/Ichthyornis_Character_BP.Ichthyornis_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Dossier_Ichthyornis.png',
                        description="“\nSpecies\nIchthyornis piscoquus\nTime\nLate Cretaceous\nDiet\nPiscivore\nTemperament\nSkittish\nWild\nAmong the most vocal creatures on the Island, Ichthyornis piscoquus actually appears to be a relatively normal seagull. It primarily eats fish, and its distinctive cries can be heard echoing over across the Island's many beaches. As you might expect from a seagull, Ichthyornis will flee at the slightest provocation. Ichthyornis is a versatile and opportunistic hunter. Its primary form of attack is to dive into the top layers of water and impale its prey. However, since its food source can be unpredictable, Ichthyornis has developed a keen ability to steal food from unsuspecting travelers. Their affinity for shiny objects leads them to sometimes knock tools and weapons out of the hands of unsuspecting Survivors, but Ichthyornis is too small to actually fly off with them.\nDomesticated\nIchthyornis surprised me by being a very loyal and very social creature, once tamed. It likes to ride on its owner's shoulder, and bring that person treats (in the form of fish, of course) which its beak-grip enhances with extra healing vitamins. The personality of Ichthyornis reminds me of a housecat hauling a trophy prey back home, except it brings extra-healthy fish instead.\n„\n~ Helena")
    models.Creature.new(name='Ichthyosaurus', name_tag='Dolphin', category='Reptiles',
                        entity_id='Dolphin_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/89/Ichthyosaurus.png',
                        url='https://ark.fandom.com/wiki/Ichthyosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dolphin/Dolphin_Character_BP.Dolphin_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Dossier_Ichthyosaurus.png',
                        description='“\nSpecies\nIchthyosaurus curiosa\nTime\nLate Triassic - Early Jurassic\nDiet\nCarnivore\nTemperament\nCurious\nWild\nIchthyosaurus curiosa is a comparatively small carnivore found in the waters around the island. It is slightly larger than a human, but that’s still small compared to the leviathans roaming these waters. It seems to be very interested in any creature around its size, often approaching and following humans swimming through its waters. Despite its appearance, the Ichthyosaurus is neither a fish nor an ocean mammal. Like many creatures in the waters around the island, it is actually an aquatic reptile.\nDomesticated\nI can’t think of a better mount for someone starting to explore the island’s seas and waterways. Ichthyosaurus is comparatively fast swimmer, and even in the wild will cozy right up to you and try to figure out what you’re doing. Taming these is actually pretty easy, as they seem to love humans and will be fed and tamed without the use of violence.\n„\n~ Helena')
    models.Creature.new(name='Iguanodon', name_tag='Iguanodon', category='Dinosaurs',
                        entity_id='Iguanodon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/94/Iguanodon.png',
                        url='https://ark.fandom.com/wiki/Iguanodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Iguanodon/Iguanodon_Character_BP.Iguanodon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/54/Dossier_Iguanodon.png',
                        description="“\nSpecies\nIguanodon vicissitudinis\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nReactive\nWild\nOf the many creatures I've yet encountered on the Island, the Iguanodon vicissitudinis has the distinctly versatile capability of switching its primary method of locomotion according to its momentary needs. Primarily a rather lethargic bipedal herbivore native to the Island's many grasslands and forests, in situations where increased speed or maneuverability is called for, it will quickly shift its posture into quadrupedal stance and behave like a very different creature! While bipedal, it can employ rapid, stabbing attacks with its distinctive thumb spikes. In quadrupedal stance, conversely, it seems to have an endless supply of stamina, even while sprinting!\nDomesticated\nInterestingly, the Iguanodon's thumb spikes also provide it with the capability to pick seeds out of fruits, allowing a farmer to easily convert stacks of fruits into stacks of seed for planting. Combined with its highly effective fruit harvesting and substantial carry weight, the Iguanodon's excellent mobility in bipedal stance makes it an ideal field-hand that can also pull off a quick get-away or an agile defense when needed.\n„\n~ Helena")
    models.Creature.new(name='Kairuku', name_tag='Kairu', category='Birds', entity_id='Kairuku_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a3/Kairuku.png',
                        url='https://ark.fandom.com/wiki/Kairuku',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Kairuku/Kairuku_Character_BP.Kairuku_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1e/Dossier_Kairuku.png',
                        description='“\nSpecies\nKairuku waitaki\nTime\nLate Paleogene\nDiet\nPiscivore\nTemperament\nFriendly\nWild\nKairuku waitaki is an amazingly docile and friendly creature, to everything but fish. Honestly, I\'m not quite sure how Kairuku manages to stay populated across the Island\'s colder climes, with the many predators stalking these frozen lands. It is weak, and has only one small defensive trait: suspended in Kairuku blubber are small, dense particles that act as a light form of armor. Adding to Kairuku\'s problems, a clever survivor discovered that refining Kairuku blubber (concentrating the particles in it) can yield a natural form of the same Polymer utilized in advanced tribes\' manufacturing processes. This has caused many tribes to hunt Kairuku extensively, a practice colloquially known as "Kairu Clubbing."\nDomesticated\nThere is no reason to tame Kairuku for combat, since they are useless at it. Still, Kairuku are regularly tamed for their cuteness and friendly nature, and the fact that their bodies run extremely hot. Just standing near Kairuku can help keep a survivor stay warm through long, harsh nights on the icebergs.\n„\n~ Helena')
    models.Creature.new(name='Kaprosuchus', name_tag='Kaprosuchus', category='Reptiles',
                        entity_id='Kaprosuchus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/89/Kaprosuchus.png',
                        url='https://ark.fandom.com/wiki/Kaprosuchus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Kaprosuchus/Kaprosuchus_Character_BP.Kaprosuchus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e1/Dossier_Kaprosuchus.png',
                        description="“\nSpecies\nKaprosuchus paludentium\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nA smaller relative of the Sarcosuchus, Kaprosuchus paludentium is water-based carnivore primarily found lurking among the island's swamps. A naturally fast runner that is even faster in the water, it is a solitary hunter that picks off small-to-medium creatures, especially those isolated from their pack. When attacking, Kaprosuchus uses two main tactics. First, it patiently waits below the water surface and when the target is sufficiently close by, will perform a lateral jump that it uses to quickly close distance with its prey and drag it underwater. Secondly, its attacks the prey's vital areas specifically to drain its stamina. These two techniques effectively prevent most creatures from escaping Kaprosuchus once an assault has begun.\nDomesticated\nSurvivors are generally split about the usefulness of Kaprosuchus. Some love its speed both in and out of the water, essentially making it among the fastest small-sized, all-terrain mounts when travelling through the wetlands. Others do not like how relatively frail Kaprosuchus is, and do not think its high speed and ensnaring attacks make up for this shortcoming.\n„\n~ Helena")
    models.Creature.new(name='Kentrosaurus', name_tag='Kentro', category='Dinosaurs', entity_id='Kentro_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/20/Kentrosaurus.png',
                        url='https://ark.fandom.com/wiki/Kentrosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Kentrosaurus/Kentro_Character_BP.Kentro_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/47/Dossier_Kentrosaurus.png',
                        description='“\nSpecies\nKentrosaurus Aethiopicus\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nWhile Kentrosaurus aethiopicus is considerably smaller than its close relative, Stegosaurus regium, it is much more formidable in matters of self-defense. In fact, it is arguably the pound for pound champion of not only the Stegosaurus, but when encountered in close-knit fighting packs, ranks atop the Island\'s herbivorous dinosaurs in general. Thanks to its wickedly sharp defensive spikes, any creature that attacks Kentrosaurus is likely to be reversely wounded in turn, and it is capable of piercing even the thickest of hides and armors when it goes on the offensive. I have personally witnessed the Kentrosaurus fell much larger predators in a single such "impaling" maneuver! Underestimating Kentrosaurus can be a fatal mistake, particularly when it is in a herd. When travelling in numbers, Kentrosaurus seems to grow much more aggressive, increasing the range at which it will defend its territory.\nDomesticated\nSurvivors have seen little success in their attempts to ride Kentrosaurus, owing to its spikes and hot-headed temperament. However, a tamed herd of Kentrosaurus can effectively defend a compound and take on larger carnivores. Once impaled by its attack, the Kentrosaurus slams the attacker on the ground continuously, helping to turn the tide of a pitched battle!\n„\n~ Helena')
    models.Creature.new(name='Leech', name_tag='Leech', category='Invertebrates', entity_id='Leech_Character_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Leech.png',
                        url='https://ark.fandom.com/wiki/Leech',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Leech/Leech_Character.Leech_Character\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/ca/Dossier_Leech.png',
                        description='“\nSpecies\nHaementeria laetus\nTime\nHolocene\nDiet\nSanguinivore\nTemperament\nAggressive\nWild\nIt is difficult to be angry with Haementeria laetus, despite its rather terrible nature. The creature has practically no intelligence, and just attaches to any nearby living flesh in an attempt to drain that creature\'s blood. Removing Haementeria requires precision bladework, or access to an open flame. Both of these can be nearly as dangerous to the host as to the leech itself. Once Haementeria attaches to a host, it drains blood at a rapid pace, and the host experiences hunger, loss of health, and lowered stamina. Some Haementeria are also carriers for a dangerous disease I\'ve dubbed "Swamp Fever," which persists beyond the leech\'s own lifespan. Few creatures on the Island are transmitters for this disease, and it can ultimately be cured with a rare medicine.\nDomesticated\nWhile Haementeria is not intelligent enough to be tamed, it is always useful to keep a few around for antidotes and fishing lures. When processed properly, Haementeria venom can be made into a powerful antivenom!\n„\n~ Helena')
    models.Creature.new(name='Diseased Leech', name_tag='Leech', category='Invertebrates',
                        entity_id='Leech_Character_Diseased_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Leech.png',
                        url='https://ark.fandom.com/wiki/Diseased_Leech',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Leech/Leech_Character_Diseased.Leech_Character_Diseased\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/ca/Dossier_Leech.png',
                        description='“\nSpecies\nHaementeria laetus\nTime\nHolocene\nDiet\nSanguinivore\nTemperament\nAggressive\nWild\nIt is difficult to be angry with Haementeria laetus, despite its rather terrible nature. The creature has practically no intelligence, and just attaches to any nearby living flesh in an attempt to drain that creature\'s blood. Removing Haementeria requires precision bladework, or access to an open flame. Both of these can be nearly as dangerous to the host as to the leech itself. Once Haementeria attaches to a host, it drains blood at a rapid pace, and the host experiences hunger, loss of health, and lowered stamina. Some Haementeria are also carriers for a dangerous disease I\'ve dubbed "Swamp Fever," which persists beyond the leech\'s own lifespan. Few creatures on the Island are transmitters for this disease, and it can ultimately be cured with a rare medicine.\nDomesticated\nWhile Haementeria is not intelligent enough to be tamed, it is always useful to keep a few around for antidotes and fishing lures. When processed properly, Haementeria venom can be made into a powerful antivenom!\n„\n~ Helena')
    models.Creature.new(name='Leedsichthys', name_tag='Leedsichthys', category='Fish',
                        entity_id='Leedsichthys_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Leedsichthys.png',
                        url='https://ark.fandom.com/wiki/Leedsichthys',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Leedsichthys/Leedsichthys_Character_BP.Leedsichthys_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e9/Dossier_Leedsichthys.png',
                        description="“\nSpecies\nLeedsichthys conviviumbrosia\nTime\nMid-Jurassic\nDiet\nPiscivore\nTemperament\nDefensive\nWild\nLeedsichthys conviviumbrosia is probably the largest fish in the waters around the island. Its meat is also extremely succulent, a surprise given its size. It is often traded with the same value as Prime Meat, and colloquially called 'Prime Fish'. Of course, not all of Leedsichthys' meat is this high quality, but most of it is! While the demand for Leedsichthys meat is high, the fish is notoriously difficult to track and hunt. Between its large size, powerful attacks, incredible speed (when it turns to flee), and humankind's general ineptitude on open water, actually killing a Leedsichthys is one of the Island's more difficult tasks. The hunt for an extremely elusive breed of the fish, the fabled 'Great Albino' Leedsichthys has been known to drive otherwise-sensible men and women mad with obsession, as if all evil were visibly personified and made practically assailable in this one creature.\nDomesticated\nDespite its large size, and the fact that it may well be strong enough to carry heavy loads, Leedsichthys does not appear to be intelligent enough to tame. Nevertheless, some large tribes keep an enormous pen with a few Leedsichthys trapped inside for cultivating purposes, as bits of Prime Fish can be repeatedly scraped off the gargantuan beast without killing it!\n„\n~ Helena")
    models.Creature.new(name='Liopleurodon', name_tag='Liopleurodon', category='Reptiles',
                        entity_id='Liopleurodon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f8/Liopleurodon.png',
                        url='https://ark.fandom.com/wiki/Liopleurodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Liopleurodon/Liopleurodon_Character_BP.Liopleurodon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/45/Dossier_Liopleurodon.png',
                        description="“\nSpecies\nLiopleurodon magicus\nTime\nMid - Late Jurassic\nDiet\nSweet Tooth\nTemperament\nElusive\nWild\nLiopleurodon magicus is a mid-sized ocean creature, typically between 20 and 25 feet long. I've yet to directly encounter one myself, but from the tales other tribes have shared, it compares to no other on the Island. The rumors indicate that this beautiful creature has magical properties; however, the sightings are so rare it's hard to decipher old tribe's tales from the underlying truth. They say that Liopleurodon is an elusive creature that can harness its magical powers to retreat from predators or aggressors of any kind, but the Beekeeping tribes claim that their honey is so sweet, not even the Liopleurodon could resist!\nDomesticated\nLiopleurodon is rumored to bring good fortune to those adventurous enough to tame it. With the Liopleurodon by their side, tribes have apparently managed to obtain treasure beyond their wildest dreams. Supposedly, even after you've gained its favor, it remains incredibly aloof and will eventually use its abilities to escape even the strictest of captivity.\n„\n~ Helena")
    models.Creature.new(name='Lystrosaurus', name_tag='Lystro', category='Dinosaurs', entity_id='Lystro_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/93/Lystrosaurus.png',
                        url='https://ark.fandom.com/wiki/Lystrosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Lystrosaurus/Lystro_Character_BP.Lystro_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d1/Dossier_Lystrosaurus.png',
                        description="“\nSpecies\nLystrosaurus amicifidelis\nTime\nLate Permian - Early Triassic\nDiet\nHerbivore\nTemperament\nLoyal\nWild\nLystrosaurus amicifidelis is a small herbivore, common to much of the Island. Only about two feet long, it is not high on the food chain, and eats small plant life. The Island's poisonous insects seem to have little effect on Lystrosaurus. Despite being among the Island's tinier herbivores, Lystrosaurus is an incredibly resilient survivor. It recovers its torpor and health much faster than most creatures, which makes rendering a Lystrosaurus unconscious a rather difficult affair.\nDomesticated\nNot surprisingly, Lystrosaurus is an extremely loyal pet once tamed. It's a very fast learner, so it gains experience much more quickly than most other creatures. Additionally, its presence nearby appears to inspire allies, making them learn more rapidly as well. Thusly, Lystrosaurus is an excellent addition to any tribe's hunting party.\n„\n~ Helena")
    models.Creature.new(name='Mammoth', name_tag='Mammoth', category='Mammals', entity_id='Mammoth_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a5/Mammoth.png',
                        url='https://ark.fandom.com/wiki/Mammoth',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Mammoth/Mammoth_Character_BP.Mammoth_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0c/Dossier_Mammoth.png',
                        description="“\nSpecies\nMammuthus steincaput\nTime\nEarly Pliocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nSeeing the likes of Mammuthus steincaput alongside dinosaurs is still strange. This behemoth towers over many creatures on the Island, and doesnt seem to fear anything but the Tyrannosaurus. I've seen them stomp would-be predators out of their way. Mammoths can grab and throw things with their powerful trunks, and manage a fearsome trumpeting roar with them as well. At first, I wondered how herds of Mammoths were able to find enough plant life to graze on. But then I saw them sweeping up thatch and foliage with their tusks, and stomping branches out of trees. Mammoths generally thrive in colder areas and have a herd mentality. They must spend much of their time travelling between the mountains' cold summit and more lush base. And maybe their herds are why the summits are so barren.\nDomesticated\nMammuthus steincaput is a difficult beast to domesticate. Not because they are inherently stubborn, but because knocking one out to begin the taming process takes great effort. Once tamed, however, Mammoths are one of the only creatures on the island that can uproot trees without shattering them, and their trunks are strong enough to lift and carry survivors and other smaller creatures. Lately, survivors have been saddling up their mammoths to ride in tandem. The more clever riders have even been outfitting their mammoth saddles with war drums. It turns out that drum solos from mammothback can really boost your tribemates spirits.\n„\n~ Helena")
    models.Creature.new(name='Manta', name_tag='Manta', category='Fish', entity_id='Manta_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Manta.png',
                        url='https://ark.fandom.com/wiki/Manta',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Manta/Manta_Character_BP.Manta_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Manta.png',
                        description="“\nSpecies\nManta mobula\nTime\nEarly Oligocene - Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nHere is another example of a creature that seems to have evolved beyond its historical traits. Everything points to this being a saltwater ray, but Manta mobula has developed the ability to swim into the island's rivers and shallows, as well as through the open ocean. Perhaps there were originally two types of ray on the island before, but years of interbreeding combined their lineage. Normally docile, Manta mobula is a carnivore only in that it naturally consumes plankton. Fortunately, Manta mobula is usually not aggressive, unless encroached. Its tail is incredibly sharp, and can pierce through thick hide and armor with ease.\nDomesticated\nWhile not the fastest swimmer around the island, Manta mobula is among the deadliest of small ocean mounts. Tribes who value striking power over speed often keep large schools of Manta to ride. Its capability to briefly leap out of water provides it a showy tactic for avoiding combat as well. A quick jab through the heart of an unsuspecting survivor can easily take them by surprise! Thusly, many tribes use it as an escort for their slower cargo-carrying swimmers.\n„\n~ Helena")
    models.Creature.new(name='Megalania', name_tag='Megalania', category='Reptiles',
                        entity_id='Megalania_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/58/Megalania.png',
                        url='https://ark.fandom.com/wiki/Megalania',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Megalania/Megalania_Character_BP.Megalania_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c6/Dossier_Megalania.png',
                        description="“\nSpecies\nMegalania muruspede\nTime\nLate Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMegalania muruspede is among the largest creatures found throughout the Island's complicated cave networks. Reaching up to three meters long, it can traverse vertically up cave walls with little difficulty thanks to its powerful claws. Fortunately, Megalania's size means it is unlikely to sneak up on anyone. Unfortunately for spelunkers, it is an aggressive and dangerous creature nonetheless. Like other Varanidae, Megalania is a venomous creature. Its poison is slow-acting, but will drain the victim's effective strength and health until death unless cured by a rare antidote. That said, the Megalania's prey are usually ripped apart well before they succumb to the poison's long-term effects.\nDomesticated\nThe rare ability of Megalania to effortlessly climb sheer environmental walls makes it a highly sought-after mount. While it is by no means the fastest, strongest, or toughest mount, the manner in which it can effortlessly scale mountains, clamber up barricades, hide in trees or upside-down, ensures it will always have place in any tribe's stables!\n„\n~ Helena")
    models.Creature.new(name='Megaloceros', name_tag='Stag', category='Mammals', entity_id='Stag_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/69/Megaloceros.png',
                        url='https://ark.fandom.com/wiki/Megaloceros',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Stag/Stag_Character_BP.Stag_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8c/Dossier_Megaloceros.png',
                        description="“\nSpecies\nMegaloceros latuscoronam\nTime\nPliocene\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nMegaloceros latuscoronam is a very skittish herbivore, found mostly in the forests and mountains of the Island. Because of its large size, its fraught demeanor would be strange in any other place. But Megaloceros knows how fierce the predators of the island are, and that it is safer to flee from them than to risk its life in a fight. The antlers of Megaloceros are very large, and make for an excellent source of keratin. This, of course, makes it a valuable resource. Unfortunately, hunting Megaloceros is not easy because of their quick speed and ability to bound over most obstacles.\nDomesticated\nMegaloceros is jack-of-all-trades creature, and many who ride it value its versatility. It is decently powerful, and its resilience, speed, and ability to jump often come in handy. Finally, the male Megaloceros' charging horn attack tends to cause targets to “bleed,” decreasing their Health, Stamina, and Speed until healed!\n„\n~ Helena")
    models.Creature.new(name='Megalodon', name_tag='Mega', category='Fish', entity_id='Megalodon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Megalodon.png',
                        url='https://ark.fandom.com/wiki/Megalodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Megalodon/Megalodon_Character_BP.Megalodon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Dossier_Megalodon.png',
                        description="“\nSpecies\nCarcharodon ultramegalodon\nTime\nMiocene-Pliocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWere it not restricted to the waters, Carcharodon ultramegalodon would be one of the most dangerous creatures on the island. As powerful and dangerous as the Tyrannosaurus is on land, Megalodon is near its equal in the water. In addition, it has a speed advantage over any non-aquatic creature when submerged. Megalodons need large quantities of food to sustain themselves, so they attack most creatures immediately on sight. Smaller fish are the sole exception I've seen; I believe this is because they cost more energy for Megalodons to catch than the predator would gain.\nDomesticated\nHaving access to the resources and treasures hidden deep within the ocean is near impossible without a domesticated sea creature. The Megalodon, though difficult to domesticate, proves to be very useful when exploring the deep sea. It's not the most efficient swimmer but it should be able to protect your cargo should you find yourself in a hostile encounter.\n„\n~ Helena")
    models.Creature.new(name='Megalosaurus', name_tag='Megalosaurus', category='Dinosaurs',
                        entity_id='Megalosaurus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7e/Megalosaurus.png',
                        url='https://ark.fandom.com/wiki/Megalosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Megalosaurus/Megalosaurus_Character_BP.Megalosaurus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/19/Dossier_Megalosaurus.png',
                        description="“\nSpecies\nMegalosaurus noctedominus\nTime\nMid Jurassic\nDiet\nCarnivore\nTemperament\nNocturnally Aggressive\nWild\nMuch like the Island's other large theropods, Megalosaurus noctedominus is an aggressive cave carnivore that should not be taken lightly. Unlike most of the other theropods, it is a primarily nocturnal creature. As dawn approaches, Megalosaurus begins looking for a secluded place to spend the day sleeping in relative safety. Conversely, if disturbed during the day, Megalosaurus is significantly more sluggish. Either way, however, its primary combat tactic is to bite onto its target, then lock its jaw shut in an iron grip. Only larger creatures can hope to break free once Megalosaurus locks its jaw. The creature then proceeds to gnaw on its prey until death. It's a terrifying, grisly spectacle to watch, and a formidable tactic for a tribe to employ against more nimble opponents.\nDomesticated\nWhile Megalosaurus is not the most powerful theropod, it is still highly sought after by night-raiders. Due to its nocturnal nature, Megalosaurus becomes much more formidable at night, dodging attacks, conserving stamina, and attacking more accurately, to name a few of its enhanced talents.\n„\n~ Helena")
    models.Creature.new(name='Meganeura', name_tag='Dragonfly', category='Invertebrates',
                        entity_id='Dragonfly_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/81/Meganeura.png',
                        url='https://ark.fandom.com/wiki/Meganeura',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dragonfly/Dragonfly_Character_BP.Dragonfly_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c5/Dossier_Meganeura.png',
                        description="“\nSpecies\nMeganeura quatpenna\nTime\nLate Carboniferous\nDiet\nCarnivore\nTemperament\nReactive\nWild\nMeganeura quatpenna is an especially large species of dragonfly. Actually, it is a type of griffinfly, an extinct species of invertebrate that looked similar to dragonflies. Like most griffinflies, Meganeura is carnivorous, but it is typically not aggressive towards humans unless provoked or challenged for food. It lives primarily in the wetter, heavily wooded areas, such as the jungles. Meganeura is a natural predator of most of the smaller insects on the island. Though not often aggressive, Meganeura will not turn down a free meal. They quickly appear in large numbers to scavenge off the victims of Pulmonoscorpius, rendered unconscious and unable to defend themselves. Of course the insects do have to avoid the Pulmonoscorpius itself. I have noticed it is unwise to disturb a flock of feeding Meganeura.\nDomesticated\nThe size of the insects on the island confounds me. The way these creatures diffuse oxygen should limit their size but Meganeura (and other bugs) seem to be able to advance beyond this restraint. If there is more oxygen in the air this could explain Meganeura's growth.\n„\n~ Helena")
    models.Creature.new(name='Megapithecus', name_tag=None, category='Bosses', entity_id='Gorilla_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7d/Megapithecus.png',
                        url='https://ark.fandom.com/wiki/Megapithecus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Gorilla/Gorilla_Character_BP.Gorilla_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a9/Dossier_Megapithecus.png',
                        description=None)
    models.Creature.new(name='Megatherium', name_tag='Megatherium', category='Mammals',
                        entity_id='Megatherium_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Megatherium.png',
                        url='https://ark.fandom.com/wiki/Megatherium',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Megatherium/Megatherium_Character_BP.Megatherium_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9c/Dossier_Megatherium.png',
                        description="“\nSpecies\nMegatherium formipavor\nTime\nLate Pliocene - Early Holocene\nDiet\nOmnivore (primarily Herbivore)\nTemperament\nPassive, but aggressive to insects\nWild\nMegatherium formipavor is one of the larger mammals on the Island. This is most shocking because it is essentially a giant sloth...if you crossbred it with an elephant and a bear! Because of its size and girth, the Megatherium is uncommonly resistant to being knocked unconscious. Despite primarily being an herbivore, a typical Megatherium is very intent on consuming the Island's many insects. It is particularly adept at removing their insides without damaging much of the shell, maximizing extraction of chitin. The otherwise slow and peaceful Megatherium becomes faster and aggressive in the presence of these creatures.\nDomesticated\nMegatherium is an incredibly useful creature to tame, so long as you don't intend to fight other tribes. It's enormity, high resistance to torpor, and voracious attitude toward insects (and arachnids) makes it ideal for farming large quantities of chitin from the bugs of the Island, or simply defending against them.\n„\n~ Helena")
    models.Creature.new(name='Mesopithecus', name_tag='Monkey', category='Mammals', entity_id='Monkey_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c6/Mesopithecus.png',
                        url='https://ark.fandom.com/wiki/Mesopithecus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Monkey/Monkey_Character_BP.Monkey_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/Dossier_Mesopithecus.png',
                        description="“\nSpecies\nMesopithecus amicufur\nTime\nLate Miocene - Late Pliocene\nDiet\nOmnivore\nTemperament\nCurious\nWild\nMesopithecus amicufur is an omnivorous monkey species, primarily inhabiting the Island's jungles. It is smaller than a human, but can scurry about the same speed. It does not appear to be aggressive unlike its relative the Gigantopithecus, but is rather very shy towards humans likely due to their much larger size and lack of hairy exterior. Due to their skittish nature they can be difficult to tame. They can be hand-fed if you are patient, but stick too close to them for too long and they'll get spooked and run away.\nDomesticated\nA common pet, Mesopithecus is very easy to keep fed. It will eat nearly any fruit harvested on the island. Mesopithecus is most often used as a social companion, as it cannot carry enough to be a beast of burden, is not large enough to be ridden and is not particularly good for combat. It is, however, quite effective at vocally warning of incoming intruders and pelting them with copious amounts of tossed fecal matter. Nomadic tribes have also managed to teach Mesopithecus to open locked doors when pillaging.\n„\n~ Helena")
    models.Creature.new(name='Microraptor', name_tag='Microraptor', category='Dinosaurs',
                        entity_id='Microraptor_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/69/Microraptor.png',
                        url='https://ark.fandom.com/wiki/Microraptor',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Microraptor/Microraptor_Character_BP.Microraptor_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Dossier_Microraptor.png',
                        description="“\nSpecies\nMicroraptor gnarilongus\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMicroraptor Gnarilongus is one of the smallest non-avian dinosaurs on the Island. Incredibly fast for its size, Microraptor is a voracious carnivore. Aggressive towards anything regardless of size, Microraptor fancies itself an apex predator. It will attack humans on sight, especially if it's not alone. When hunting, Microraptor's speed is only one of its assets. While not quite capable of sustained flight, its wings allow it to stay aloft for several seconds while jumping. This allows Microraptor to attack its prey's vulnerable areas, as well as search for small river fish. Notable, the creature also tends to use this ability to knock oblivious humans off of their mounts.\nDomesticated\nWhile not a powerhouse against armed enemies, Microraptor is particularly suited to dismounting enemy riders. Microraptors natural tendency to attack weaker creatures means they can ignore the mount while attacking the rider with leaps of fury.\n„\n~ Helena")
    models.Creature.new(name='Mosasaurus', name_tag='Mosasaur', category='Reptiles', entity_id='Mosa_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Mosasaurus.png',
                        url='https://ark.fandom.com/wiki/Mosasaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Mosasaurus/Mosa_Character_BP.Mosa_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d5/Dossier_Mosasaurus.png',
                        description='“\nSpecies\nMosasaurus suspirita\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUntil recently, I believed the Megalodon to be the greatest of the ocean predators. Then I discovered Mosasaurus suspirita in the deeps. Not quite as fast, but much larger and stronger, the Mosasaurus rules the darkest waters of the Island. Growing up to 50 feet long, Mosasaurus is larger than almost every other aquatic creature I\'ve encountered thus far. Mosasaurus is a deep-sea marine lizard which spends all of its time far beneath the water\'s surface. It is without a doubt one of the most fearsome creatures of the Island, and can certainly be considered among the ocean\'s apex predators.\nDomesticated\nMosasaur has proven to be an excellent tame for the most advanced tribes. Due to its sheer size and power, you will often find tribes with bases and defenses built upon a Mosasaur\'s large "platform" saddle. Having one with you as an escort is probably one of the best oceanic defenses available!\n„\n~ Helena')
    models.Creature.new(name='Moschops', name_tag='Moschops', category='Dinosaurs', entity_id='Moschops_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e6/Moschops.png',
                        url='https://ark.fandom.com/wiki/Moschops',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Moschops/Moschops_Character_BP.Moschops_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dc/Dossier_Moschops.png',
                        description="“\nSpecies\nMoschops cibumutante\nTime\nMid Permian\nDiet\nOmnivore\nTemperament\nCowardly\nWild\nMoschops Cibumutante in the wild is a lazy, cowardly creature that typically lives in the Island's forests, primarily making its home among the great redwoods of the western regions. It survives by being extremely flexible in its eating habits and completely averse to fighting. It never starves, since it can eat just about anything. It runs at the slightest provocation but is still often preyed upon.\nDomesticated\nWhat makes Moschops particularly interesting is what it can be trained to do with its eating habits. With a versatile palate and tough teeth, Moschops can be tamed for a unique ability: over time it can be accurately taught exactly which things to gnaw, increasing the likelihood of harvesting the specific resource its master desires. For example, teach it to prioritize chewing Prime Meat, and Prime Meat will be easier to harvest from the flesh it consumes. Likewise for rare plants materials, and so forth! Just don't expect Moschops to protect you, though! Even after taming, it will quickly flee when enemies are nearby. Regardless of being fed well, increasing its strength, or how much affection, you shower on it, Moschops retains its inherent cowardly nature! Its lack of combat might deter the use of this companion but the ability to ride Moschops while making use of its diverse harvesting is a rare treat.\n„\n~ Helena")
    models.Creature.new(name='Onychonycteris', name_tag='Bat', category='Mammals', entity_id='Bat_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Onyc.png',
                        url='https://ark.fandom.com/wiki/Onychonycteris',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Bat/Bat_Character_BP.Bat_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/06/Dossier_Onyc.png',
                        description="“\nSpecies\nOnychonycteris specuncola\nTime\nEocene\nDiet\nOmnivore\nTemperament\nAggressive\nWild\nOnychonycteris specuncola is one of the few omnivores I've seen on the Island. They seem to live primarily off the mushrooms and moss within the caves, but they attack almost any non-insect on sight. They avoid Titanoboa whenever possible, which leads me to believe the snake to be a natural predator of Onychonycteris. While flying in the dark caves would be difficult for any creature, Onychonycteris' ability to use echolocation has allowed it to adapt perfectly. It can be found idly flying around the caves as often as it can be found hanging from bits of the cave ceilings.\nDomesticated\nNot large enough to be used as mounts, and not strong enough to carry much, Onychonycteris still function well as a guard animal. Whether protecting a vacant home or members of a tribe, their relatively vicious nature has its uses.\n„\n~ Helena")
    models.Creature.new(name='Otter', name_tag='Otter', category='Mammals', entity_id='Otter_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9f/Otter.png',
                        url='https://ark.fandom.com/wiki/Otter',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Otter/Otter_Character_BP.Otter_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Dossier_Otter.png',
                        description='“\nSpecies\nLutra peloso\nTime\nEarly Miocene\nDiet\nOmnivore\nTemperament\nFriendly\nWild\nFound along the Island’s many inland waterways, Lutra Peloso have become exceptionally adept at hunting and foraging. This species of Otter has to be particularly cunning because of its diminutive size, and fierce competition for its preferred food source: fish. It is not a creature that excels at combat, and would not naturally pose an intimidating threat to any predators. Finding packs of river Otters is simple enough: They are distinguished by their elongated bodies, bushy tails, and webbed feet. Their trusting and inquisitive nature ensures they are often hunted for their lustrous fur, but many prefer to tame them to become trusted companions.\nDomesticated\nThere are few creatures which provide the companionship that Lutra Peloso does. Rather than traveling beside you, it would prefer to comfortably rest on your back, providing insulation. Once domesticated, it can be told to harvest fish on demand, with a specific goal in mind from the fish that it consumes, the otter has a knack for foraging silica pearls, and can even yield a slight chance at finding black pearls within!\n„\n~ Helena')
    models.Creature.new(name='Oviraptor', name_tag='Ovi', category='Dinosaurs', entity_id='Oviraptor_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Oviraptor.png',
                        url='https://ark.fandom.com/wiki/Oviraptor',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Oviraptor/Oviraptor_Character_BP.Oviraptor_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e8/Dossier_Oviraptor.png',
                        description="“\nSpecies\nOviraptor philodator\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nOviraptor philodator is a small-to-medium sized carnivore, common in the jungles and beaches of the Island. Despite being a carnivore, Oviraptor's main source of food is eggs, which it steals from nests. Unlike any other creature, Oviraptor seems to be able to surreptitiously steal these eggs, usually without attracting the attention of an irate mother. In an incredible feat of natural selection, Oviraptor seems to emit a chemical pheromone that affects many creatures as an aphrodisiac. Mated creatures are much more likely to…“create” new eggs while Oviraptor is around, which allows the Oviraptor to go about its business unperturbed.\nDomesticated\nToo small to fight or ride, Oviraptor is still one of the more commonly tamed creatures on the Island. Its pheromone ensures an increased stream of eggs from nearby mated wild creatures, for breeding, eating, or cooking kibble. Oviraptor will autonomously do the dirty work of stealing eggs from other tribes or wild dinos on your behalf, without attracting unwanted attention. They also make quite adorable sounds, so many children simply like to keep them around as rather strange companions.\n„\n~ Helena")
    models.Creature.new(name='Ovis', name_tag='Sheep', category='Mammals', entity_id='Sheep_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Ovis.png',
                        url='https://ark.fandom.com/wiki/Ovis',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Sheep/Sheep_Character_BP.Sheep_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b7/Dossier_Ovis.png',
                        description='“\nSpecies\nOvis arcam\nTime\nCenozoic\nDiet\nHerbivore\nTemperament\nStupid\nWild\nSince arriving on the Island, I have encountered dozens of fascinating creatures whose behavior has never been studied or documented...and also sheep. Granted, Ovis arcam is quite different from the modern domesticated sheep - and even from wild sheep species such as Ovis orientalis. The unique markings on its face give it a striking appearance, and the males\' horns possess a unique shape that is unlike any other species in the Ovis genus. As one might expect, Ovis stands little chance against this Island\'s many predators. Like the Dodo, its continued survival in the face of these challenges is a mystery.\nDomesticated\nSome survivors have found herds of Ovis to be useful in farm life. Their wool can be repeatedly safely shorn with the proper tools, and cooked lamb chops are a popular dish among some tribes, as is their hyper-nutritious mutton. Every now and then, a survivor with a sense of humor will attempt to utilize Ovis as a mount, although the joke becomes significantly less funny once their slow Ovis is run-down by a pack of Raptors. One tribe has grown particularly attached to Ovis, perhaps uncomfortably so. I don\'t know the tribe\'s actual name, but I refer to them as "Sheep Lovers."\n„\n~ Helena')
    models.Creature.new(name='Pachy', name_tag='Pachy', category='Dinosaurs', entity_id='Pachy_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f8/Pachy.png',
                        url='https://ark.fandom.com/wiki/Pachy',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Pachy/Pachy_Character_BP.Pachy_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Dossier_Pachy.png',
                        description='“\nSpecies\nPachycephalosaurus leniproelia\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nPassive\nWild\nPachycephalosaurus is a bit of a conundrum. It is a very passive (even friendly) herbivore, common to much of the Island. At the same time, it is one of the most dangerous herbivores that I have yet encountered on the Island. Its charging headbutt is a display of sheer physical power, and can kill much more quickly than you might think. While Pachycephalosaurus is generally friendly, it has a short temper. Its fight-or-flight response always seems to choose "fight!" The Pachy becomes extremely aggressive once attacked. Additionally, it is an incredibly fast sprinter, so escaping from an enraged Pachy is very difficult.\nDomesticated\nPachycephalosaurus is an excellent battle-mount for those who want to ride a smaller, nimble combatant into the fray. Because of its particular musculature, it cannot effectively carry large quantities of resources. It can, however, move with brief magnificent bursts of speed, and its headbutt is simply devastating.\n„\n~ Helena')
    models.Creature.new(name='Pachyrhinosaurus', name_tag='Pachyrhinosaurus', category='Dinosaurs',
                        entity_id='Pachyrhino_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Pachyrhinosaurus.png',
                        url='https://ark.fandom.com/wiki/Pachyrhinosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Pachyrhinosaurus/Pachyrhino_Character_BP.Pachyrhino_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4c/Dossier_Pachyrhinosaurus.png',
                        description="“\nSpecies\nPachyrhinosaurus mitisaura\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nEvasive\nWild\nPachyrhinosaurus Mitisaura is a medium-sized herbivore, found almost everywhere but the Island's mountains. It is generally calm and ignores all other nearby creatures unless it is attacked. Pachyrhinosaurus possesses a particularly unique survival skill. When threatened, its massive nasal-boss releases a chemical into the air that calms other nearby creatures, making them less likely to attack it. Affected creatures are sometimes hungry enough to ignore the effect, and humans seem immune to it. Conversely, it can seemingly invert this phenomenon at will and coerce creatures into attacking it!\nDomesticated\nPachyrhinosaurus is an excellent starting mount for anyone new to taming. It is fairly easy to train, can carry enough to be a simple pack-animal, and is not as deadly as some of the larger herbivores. Additionally, Pachyrhinosaurus can release its unique chemical on command to protect itself and its rider from nearby predators, or draw attention if desired, making it a potential life saver in a pinch.\n„\n~ Helena")
    models.Creature.new(name='Paraceratherium', name_tag='Paracer', category='Mammals',
                        entity_id='Paracer_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e1/Paraceratherium.png',
                        url='https://ark.fandom.com/wiki/Paraceratherium',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Paraceratherium/Paracer_Character_BP.Paracer_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Paraceratherium.png',
                        description='“\nSpecies\nParaceratherium gigamicus\nTime\nOligocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nParaceratherium gigamicus is a massive, long-necked herbivore that inhabits some of the Island\'s grasslands. It resembles a gigantic horse/rhinoceros hybrid, but is over twice the size of either. Paraceratherium is a very peaceful and friendly creature. Barring some surprises yet in store for me, I can safely say that Paraceratherium is among the largest mammals on the Island. While its size means that Paraceratherium can provide an incredible amount of food, it also makes it dangerous when hunted.\nDomesticated\nA beast of burden second to the Brontosaurus, Paraceratherium is an excellent worker, and is sufficient in size to support a "platform" saddle upon which structures can be built. It is a naturally friendly animal, and is not afraid of humans. However, despite its normally calm demeanor, when it or its owner is provoked by aggression, the Paraceratherium can quickly become a real threat to the attacker and will use its girth to its advantage in combat.\n„\n~ Helena')
    models.Creature.new(name='Parasaurolophus', name_tag='Para', category='Dinosaurs', entity_id='Para_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Parasaur.png',
                        url='https://ark.fandom.com/wiki/Parasaurolophus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Para/Para_Character_BP.Para_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Dossier_Parasaur.png',
                        description="“\nSpecies\nParasaurolophus amphibio\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nParasaurolophus amphibio has one of the more interesting adaptations of any creature I've seen on the Island. Like all Parasaur, it has a signature crest on its head. Very docile at first, I've been able to approach the creature without disturbing it. If startled, however, the creature can vocalize a distress call to the surrounding area that warns of danger. Parasaurolophus appears to be low on the food chain and is hunted by everything, creatures and humans alike, which explains its skittish nature. It is a good source of meat and hide, if you can manage to keep up with it long enough to kill it.\nDomesticated\nDespite being what most tribes consider a relatively useless creature to tame, I once met an interesting woman who had tamed an entire herd of them. She informed me that many overlooked the creature's potential. She even graciously gifted me a fancy saddle to put on my own Parasaurolophus one day. As a relatively simple creature to domesticate, Parasaurolophus is commonly one of the first mounts a tribe will be able to acquire. Its ability to run relatively fast for lengthy intervals makes it a solid mode of medium-range transportation, though it has almost no ability to defend itself or its rider in a traditional sense. Smaller creatures, however, appear to be frightened by the horn of Parasaurolophus although it doesn't do much damage. It also has decent weight-bearing capabilities, which could prove useful for nomadic tribes as they work to establish a presence on the Island.\n„\n~ Helena")
    models.Creature.new(name='Pegomastax', name_tag='Pegomastax', category='Dinosaurs',
                        entity_id='Pegomastax_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Pegomastax.png',
                        url='https://ark.fandom.com/wiki/Pegomastax',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Pegomastax/Pegomastax_Character_BP.Pegomastax_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Pegomastax.png',
                        description="“\nSpecies\nPegomastax fructarator\nTime\nEarly Jurassic\nDiet\nHerbivore\nTemperament\nDefensive\nWild\nAmong the bottom of the island's dinosaur food chain is a small herbivore called Pegomastax fructarator. It is content to spend all day alone, gorging itself on far more food than you might reasonably expect for a creature of its tiny stature. Its beak appears perfectly evolved for collecting food from plants while avoiding the indigestible fibrous strands. Pegomastax is likely to ignore any nearby creature and continue foraging, unless it is attacked. At which point, it turns into a very aggressive (though rather unthreatening) opponent, shrieking and wooping far above its actual threat level. You would expect a creature this small and weak to live in flocks, but Pegomastax seems to be fairly solitary in nature.\nDomesticated\nWhile not pretty, and far too small to ride, tribes often keep Pegomastax around as a kind of farming aid. Its skill at scavenging means that it collects an extraordinary quantity of seeds and berries, while also handily gathering the rare Flowers, Mushrooms, and other ingredients necessary to cook up unusual concoctions.\n„\n~ Helena")
    models.Creature.new(name='Pelagornis', name_tag='Pela', category='Birds', entity_id='Pela_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7f/Pelagornis.png',
                        url='https://ark.fandom.com/wiki/Pelagornis',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Pelagornis/Pela_Character_BP.Pela_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Dossier_Pelagornis.png',
                        description="“\nSpecies\nPelagornis miocaenus\nTime\nEarly Miocene\nDiet\nPiscivore\nTemperament\nSkittish\nWild\nThe much-larger ancestor of water birds like the stork or pelican, Pelagornis miocaenus shares many traits with its modern-day brethren. However, it seems to spend far more time hunting for fish over the open deep-sea. In fact, I have rarely spotted a wild Pelagornis anywhere near the coasts of the main Island, as it prefers to rest its wings by paddling on the ocean's surface rather than waddling along the Island's beaches. Perhaps this behavior is a result of its survival instincts. The Early Miocene was a post-dinosaur epoch, after all, and Pelagornis would not be accustomed to such predators. Considering how quickly it flees from humans, one can hardly blame its caution.\nDomesticated\nBecause of its ability to fly, walk and surface-swim, a tamed Pelagornis is one of the Island's most versatile mounts, but this comes at a cost. The same webbed feet that allow Pelagornis to serenely maneuver along the ocean's surface prevent it from carrying prey off the ground, which may limit its appeal to some survivors.\n„\n~ Helena")
    models.Creature.new(name='Phiomia', name_tag='Phiomia', category='Mammals', entity_id='Phiomia_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Phiomia.png',
                        url='https://ark.fandom.com/wiki/Phiomia',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Phiomia/Phiomia_Character_BP.Phiomia_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Dossier_Phiomia.png',
                        description="“\nSpecies\nPhiomia ignavus\nTime\nLate Eocene - Early Oligocene\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nPhiomia ignavus is another of the Island's generally docile herd animals. They are small enough that almost any predator can bring them down but large enough to provide plenty of meat. Were it not for the protection of the herd and their instinct to run from any predator, these would almost certainly be hunted to extinction. Phiomia's tusks and trunk make it especially suited to scavenging plantlife from the ground. It uses its tusks to dig up loose plantlife, then uses its stubby trunk to scoop the foliage into its mouth. Adult Phiomia often dig up food for their young, and watching a baby Phiomia attempt to use its trunk can be quite amusing.\nDomesticated\nWhile it is completely possible to ride a Phiomia around, they are a meager choice. They work very well, however, as pack-mules. If you feed the Phiomia a stimberry, it serves as a laxative in the creature's digestive system. Knowing this, tribal communities often keep a herd of these as livestock to produce mass quantities of fertilizer.\n„\n~ Helena")
    models.Creature.new(name='Piranha', name_tag='Piranha', category='Fish', entity_id='Piranha_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/43/Piranha.png',
                        url='https://ark.fandom.com/wiki/Piranha',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Piranha/Piranha_Character_BP.Piranha_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b2/Dossier_Piranha.png',
                        description="“\nSpecies\nMegapiranha magnadmorsus\nTime\nLate Miocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMegapiranha magnadmorsus is carnivorous fish found fairly commonly in the rivers and ponds of the island. Its bite is incredibly powerful; I've even seen them break through the armored turtles of the island. Megapiranha has one of the strongest bites, pound-for-pound, of any creature on the island. When encountering a Megapiranha, be on the lookout for the rest of the school. No one Megapiranha is an overwhelming threat, but their tendency to swarm prey can make short work of much larger and stronger creatures. Any given Megapiranha is easy to kill, but killing the entire school can be a daunting task.\nDomesticated\nThe Megapiranha is highly territorial and does not respond favorably to visitors. Many have tried to pacify the hostile Megapiranha by herding them into a group with various lures. Unfortunately, none of this proved to be successful in attempting to domesticate the creature.\n„\n~ Helena")
    models.Creature.new(name='Plesiosaur', name_tag='Plesiosaur', category='Reptiles',
                        entity_id='Plesiosaur_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/43/Plesiosaur.png',
                        url='https://ark.fandom.com/wiki/Plesiosaur',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Plesiosaur/Plesiosaur_Character_BP.Plesiosaur_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Plesiosaur.png',
                        description='“\nSpecies\nElasmosaurus remuspissa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nElasmosaurus remuspissa is typically found in the deep oceans, and has a strange role in the oceanic food chain. It almost exclusively hunts the smaller creatures in the waters, leaving most even moderately large creatures alone. The sheer size of the Elasmosaurus means that the quantity of food it must eat to sustain itself is nothing short of enormous. Elasmosaurus is a formidable fighter. Aside from the Megalodon, I have only ever seen two creatures bring down an Elasmosaurus: a Mosasaurus, and human beings. Though I will admit, I have yet to thoroughly explore the staggeringly deep underwater caverns surrounding the Island.\nDomesticated\nMuch like the Brontosaurus on land, Elasmosaurus is an excellent way to transport large quantities of goods over water. These powerful creatures are in fact so large that they can be used as mobile water bases. Ambitious tribes sometimes build bunkers right onto the backs of Elasmosaurus instead of building cargo ships.\n„\n~ Helena')
    models.Creature.new(name='Procoptodon', name_tag='Kangaroo', category='Mammals',
                        entity_id='Procoptodon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Procoptodon.png',
                        url='https://ark.fandom.com/wiki/Procoptodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Procoptodon/Procoptodon_Character_BP.Procoptodon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Dossier_Procoptodon.png',
                        description="“\nSpecies\nProcoptodon vivencurrus\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nReactive\nWild\nThe first marsupial I've encountered on the Island is the Procoptodon vivencurrus. Standing nearly three meters tall, it is among the largest jumping creatures I've heard of. It is a fairly peaceful herbivore that will immediately flee when aggressed upon. One of Procoptodon's most unique features is its pouch. Unlike many pouched marsupials, Procoptodon's pouch is relatively dry and has little in the way of sticky or oily fluids. I assume this is good for the Joey, but I have not figured out exactly why yet. Its other unique feature, powerful hind legs, can knock back aggression much larger in stature. Procoptodons show great precision when leaping as if they can accurately target the landing without fail. I've seen them effortlessly hop and land from heights that would flatten other creatures.\nDomesticated\nIt seems Procotopdon's knack for carrying things has increased its load-bearing capacity. Procoptodon's dry pouch makes it an excellent beast of burden that can carry far more than other creatures of its size. Additionally, it appears to provide an optimal environment for nourishing babies. So much that upon maturing, they have even more vigor.\n„\n~ Helena")
    models.Creature.new(name='Pteranodon', name_tag='Ptera', category='Dinosaurs', entity_id='Ptero_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/22/Pteranodon.png',
                        url='https://ark.fandom.com/wiki/Pteranodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Ptero/Ptero_Character_BP.Ptero_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6e/Dossier_Pteranodon.png',
                        description="“\nSpecies\nPteranodon wyvernus\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nPteranodon wyvernus is a large pterosaur, capable of flying more quickly than any creature I have witnessed on this Island thus far. It seems to have relatively poor stamina in comparison to its quick speed, however, making frequent pit stops on the beaches before taking off again. While other humans I've seen on the Island still insist on calling it a Pterodactyl, this is inaccurate. Pteranodon wyvernus's poor fighting and defensive skills mean they are likely to scavenge any number of dead animals rather than engage in dangerous combat with other creatures. They also flee at the slightest sign of trouble. Because of this, they are one of the most common creatures to be found darting across the Island's skies.\nDomesticated\nPteranodons seem to be among most popular flying companions from what I have witnessed, possibly because they are relatively easy to tame with a slingshot or bow. Mounting a Pteranodon must be among the fastest and safest ways to get around the Island, but it doesn't provide any measure of secrecy in comparison to travel on land through the dense foliage.\n„\n~ Helena")
    models.Creature.new(name='Pulmonoscorpius', name_tag='Scorpion', category='Invertebrates',
                        entity_id='Scorpion_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ab/Scorpion.png',
                        url='https://ark.fandom.com/wiki/Pulmonoscorpius',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Scorpion/Scorpion_Character_BP.Scorpion_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Pulmonoscorpius.png',
                        description="“\nSpecies\nPulmonoscorpius gigantus\nTime\nLate Silurian\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nI'm not sure why, but the giant scorpions I've seen on the Island are far more disturbing than most of the dinosaurs. Rather than simply kill its prey, Pulmonoscorpius gigantus injects its victims with a tranquilizing poison, then eats its unconscious prey alive. This subspecies has a large pair of pincers that seem connected to the same toxin sacs as the tail. I've never seen another scorpion that has this adaptation, but I've never seen another scorpion that's larger than I am, either.\nDomesticated\nTrying to tame a monster like Pulmonoscorpius gigantus sounds like a crazy idea, but I suppose the ability to knock out a foe could come in handy. It could certainly make incapacitating some of the Island's other creatures much easier.\n„\n~ Helena")
    models.Creature.new(name='Purlovia', name_tag='Purlovia', category='Synapsids', entity_id='Purlovia_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c2/Purlovia.png',
                        url='https://ark.fandom.com/wiki/Purlovia',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Purlovia/Purlovia_Character_BP.Purlovia_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/df/Dossier_Purlovia.png',
                        description='“\nSpecies\nPurlovia maxima\nTime\nLate Permian\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nPurlovia Maxima perfectly embodies the element of surprise. Though Nanictidopids such as Purlovia were once thought to be herbivores, I discovered that this creature is, in fact, a patient hunter of the most intelligent sort. After burrowing beneath the jungle floor, Purlovia enters a state of hibernation and can go extended periods without any food. When some unfortunate creature eventually wanders by, Purlovia bursts forth from the ground, tearing into its prey with its large canines before the victim can react!\nDomesticated\nThough Purlovia is ill-suited to the life of a mount, its usefulness in staging an ambush or as a village guardian cannot be understated. With a tamed pack of Purlovia, one could assemble a literal organic minefield of deadly claws and teeth! However, any ambushes using Purlovia must be planned well in advance, as it will refuse to hibernate if it senses any threat nearby.\n„\n~ Helena')
    models.Creature.new(name='Quetzalcoatlus', name_tag='Quetz', category='Reptiles', entity_id='Quetz_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9d/Quetzal.png',
                        url='https://ark.fandom.com/wiki/Quetzalcoatlus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Quetzalcoatlus/Quetz_Character_BP.Quetz_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2c/Dossier_Quetzal.png',
                        description="“\nSpecies\nQuetzalcoatlus conchapicem\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nFrom afar, it's hard to believe that Quetzalcoatlus is one of the largest avians on the island. It shares a similar silhouette with the Pteranodon, and nests near the absolute highest peaks. Upon closer inspection, though, Quetzalcoatlus is an enormous creature of tremendous power. I find it strange that such a large, imposing beast would be so skittish. Unlike other creatures of its size, it is more likely to flee than fight. I suppose the decision to flee from any trouble keeps the species alive on an island with so many dangerous predators. But then how does it eat enough to sustain its massive size?\nDomesticated\nTamed Quetzalcoatlus have a very specific role on the island. Too slow to be an efficient local transport, and too weak to be an effective warbird, the tribes I have encountered tend to employ it as a mass carrier. Quetzalcoatlus is primarily used by these masters of the skies to safely carry vast quantities of supplies, creatures and human cargo from one base to another without tiring.\n„\n~ Helena")
    models.Creature.new(name='Raptor', name_tag='Raptor', category='Dinosaurs', entity_id='Raptor_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/08/Raptor.png',
                        url='https://ark.fandom.com/wiki/Raptor',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Raptor/Raptor_Character_BP.Raptor_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
                        description='“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena')
    models.Creature.new(name='Rex', name_tag='Rex', category='Dinosaurs', entity_id='Rex_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Rex.png',
                        url='https://ark.fandom.com/wiki/Rex',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Rex/Rex_Character_BP.Rex_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
                        description='“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena')
    models.Creature.new(name='Rex Ghost', name_tag='Rex', category='Event Creatures',
                        entity_id='Ghost_Rex_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/97/Rex_Ghost.png',
                        url='https://ark.fandom.com/wiki/Rex_Ghost',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Rex/Ghost_Rex_Character_BP.Ghost_Rex_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/12/Rex_Ghost_Image.jpg',
                        description=None)
    models.Creature.new(name='Sabertooth', name_tag='Sabertooth', category='Mammals', entity_id='Saber_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a4/Sabertooth.png',
                        url='https://ark.fandom.com/wiki/Sabertooth',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Saber/Saber_Character_BP.Saber_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Dossier_Sabertooth.png',
                        description="“\nSpecies\nSmilodon brutalis\nTime\nEarly Pleistocene/Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmilodon brutalis is a solitary hunter, generally found in cold, lightly wooded areas. The Island's mountains are the perfect habitat, as the mammal's fur keeps it safe from the bitter temperature. While its huge fangs are excellent for delivering deathblows, the creature's claws can be just as deadly. Despite normally being a solitary creature, Smilodon brutalis are not opposed to hunting in small packs. In fact, they have to do this to take down larger prey such as Mammoths. Enough Sabertooths can take down a Carnotaurus, perhaps even a Tyrannosaurus. Either way, Smilodon brutalis should not be underestimated.\nDomesticated\nWhile not as fast as Raptors, there's no denying the Sabertooth's increased resilience and power. In addition, well-trained Sabertooth can be taught to use their claws to flay corpses. This may sound morbid, but it is among the best ways to quickly gather large quantities of hide from the giant beasts of the Island.\n„\n~ Helena")
    models.Creature.new(name='Sabertooth Salmon', name_tag='Salmon', category='Fish', entity_id='Salmon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e0/Salmon.png',
                        url='https://ark.fandom.com/wiki/Sabertooth_Salmon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Salmon/Salmon_Character_BP.Salmon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0c/Dossier_Sabertooth_Salmon.png',
                        description='“\nSpecies\nOncorhynchus grexlamia\nTime\nLate Miocene - Mid Pleistocene\nDiet\nCarnivore\nTemperament\nEvasive, Aggressive when attacked\nWild\nFairly unremarkable by the Island\'s standards, Oncorhynchus grexlamia is a generally passive fish. Its main form of protection is swimming in a large school. Oncorhynchus does not like conflict, and generally swims away from anything larger than itself at very high speeds. Once provoked, however, Oncorhynchus becomes quite aggressive, along with its nearby brethren. It locks onto its prey with its long "saberteeth" and begins draining that creature\'s blood. This loss of blood is not too dangerous alone, but when a school of Oncorhynchus attack at once, their target quickly loses speed and stamina from blood loss, drowning if it cannot breath underwater.\nDomesticated\nLike many of the smaller fish found on or around the Island, Oncorhynchus cannot be tamed, but it is often herded and harvested for its resources. In particular, certain cuts of Oncorhynchus meat are considered to have superb quality, and are often referred to as "Prime Fish" used for specific high-end concoctions and taming the Island\'s many piscivorous creatures.\n„\n~ Helena')
    models.Creature.new(name='Sarco', name_tag='Sarco', category='Reptiles', entity_id='Sarco_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Sarco.png',
                        url='https://ark.fandom.com/wiki/Sarco',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Sarco/Sarco_Character_BP.Sarco_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/70/Dossier_Sarco.png',
                        description="“\nSpecies\nSarcosuchus excubitor\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nPatient\nWild\nAmong the Island's swamp-based threats, Sarcosuchus excubitor is a lot like what you might expect from a giant crocodile: a patient killing machine. It spends much of its days lazily waiting in the water for prey to walk near. That said, it is not opposed to scurrying onto land and pressing the issue when hungry. A good tactic for escaping many predators is to jump into the water, as most are slow swimmers. This is a bad tactic for escaping a Sarcosuchus, obviously, as they are actually faster in the water than they are on land. Whether in land or water, it utilizes a well-rounded arsenal of attacks to display its prowess as a hunter. If it desires to grab a predator and spin into a death roll, quickly lunge forward for a surprise attack, target a foe directly behind it, its able to do so with extreme ease.\nDomesticated\nSarcosuchus is a ferocious creature that even causes the fearless piranha to flee at the sight of it. Despite being river-dwelling creatures, Sarcosuchus seem quite at ease in the oceans. More than a few fishing communities use them as mounts simply to help fight off megaladons, or to gain better access to the resources found within the reefs.\n„\n~ Helena")
    models.Creature.new(name='Skeletal Bronto', name_tag='Bronto', category='Event Creatures',
                        entity_id='Bone_Sauropod_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/62/Skeletal_Brontosaurus.png',
                        url='https://ark.fandom.com/wiki/Skeletal_Bronto',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Sauropod/Bone_Sauropod_Character_BP.Bone_Sauropod_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/11/Skeletal_Bronto_Image.jpg',
                        description=None)
    models.Creature.new(name='Skeletal Carnotaurus', name_tag='Elite Carno', category='Event Creatures',
                        entity_id='Bone_MegaCarno_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Skeletal_Carnotaurus.png',
                        url='https://ark.fandom.com/wiki/Skeletal_Carnotaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Carno/Bone_MegaCarno_Character_BP.Bone_MegaCarno_Character_B\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/75/Skeletal_Carnotaurus_Image.jpg',
                        description=None)
    models.Creature.new(name='Skeletal Giganotosaurus', name_tag='Gigant', category='Event Creatures',
                        entity_id='Bone_Gigant_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/15/Skeletal_Giganotosaurus.png',
                        url='https://ark.fandom.com/wiki/Skeletal_Giganotosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Giganotosaurus/Bone_Gigant_Character_BP.Bone_Gigant_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Skeletal_Giganotosaurus_Image.jpg',
                        description=None)
    models.Creature.new(name='Skeletal Quetzal', name_tag='Quetz', category='Event Creatures',
                        entity_id='Bone_Quetz_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7a/Skeletal_Quetzal.png',
                        url='https://ark.fandom.com/wiki/Skeletal_Quetzal',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Quetzalcoatlus/Bone_Quetz_Character_BP.Bone_Quetz_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/81/Skeletal_Quetzal_Image.jpg',
                        description=None)
    models.Creature.new(name='Skeletal Raptor', name_tag='Bone Raptor', category='Event Creatures',
                        entity_id='Bone_MegaRaptor_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d5/Skeletal_Raptor.png',
                        url='https://ark.fandom.com/wiki/Skeletal_Raptor',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Raptor/Bone_MegaRaptor_Character_BP.Bone_MegaRaptor_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/25/Skeletal_Raptor_Image.jpg',
                        description=None)
    models.Creature.new(name='Skeletal Rex', name_tag='Bone Rex', category='Event Creatures',
                        entity_id='Bone_MegaRex_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/db/Skeletal_Rex.png',
                        url='https://ark.fandom.com/wiki/Skeletal_Rex',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Rex/Bone_MegaRex_Character_BP.Bone_MegaRex_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cb/Skeletal_Rex_Image.jpg',
                        description=None)
    models.Creature.new(name='Skeletal Stego', name_tag='Stego', category='Event Creatures',
                        entity_id='Bone_Stego_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1e/Skeletal_Stegosaurus.png',
                        url='https://ark.fandom.com/wiki/Skeletal_Stego',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Stego/Bone_Stego_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dc/Skeletal_Stego_Image.jpg',
                        description=None)
    models.Creature.new(name='Skeletal Trike', name_tag='Trike', category='Event Creatures',
                        entity_id='Bone_Trike_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ac/Skeletal_Triceratops.png',
                        url='https://ark.fandom.com/wiki/Skeletal_Trike',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Trike/Bone_Trike_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Skeletal_Trike_Image.jpg',
                        description=None)
    models.Creature.new(name='Spino', name_tag='Spino', category='Dinosaurs', entity_id='Spino_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/03/Spino.png',
                        url='https://ark.fandom.com/wiki/Spino',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Spino/Spino_Character_BP.Spino_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Spino.png',
                        description="“\nSpecies\nSpinosaurus aquareliga\nTime\nEarly-Late Cretaceous\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nAmong the few carnivores on the Island that can match Tyrannosaurs in size, Spinosaurus aquareliga does not match its ferocity. Spinosaurus' four legs and large sail make it fairly swift on land and incredibly fast in the water. Its marvel is, arguably, the ability to change stances by going from quadruped to biped. The creature is visually distinguished by its spectacular sail. In my travels I have seen many different and brightly coloured sails, as every Spinosaurus appears to have a slightly different palette. The one comforting fact about Spinosaurus is that it seems more at home near water than away from it. Although the creature is more powerful, faster, agile, and insatiable while in water, it tends to become less hostile as it gets farther from it. On one occasion, I only escaped a Spinosaurus by getting far enough from its lake home to make it simply lose interest.\nDomesticated\nSpinosaurus is an incredibly well-rounded apex carnivore. Faster than a Tyrannosaurus in water and able to travel on land unlike a Megalodon, its all-terrain versatility may be unrivaled. Although its movement speed is slower in a biped stance, it gains considerable attacking strength and mobility in this form. For hunters who wish to have a well-rounded mount, Spinosaurus may be the ideal choice -- if they can acquire one.\n„\n~ Helena")
    models.Creature.new(name='Stegosaurus', name_tag='Stego', category='Dinosaurs', entity_id='Stego_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Stegosaurus.png',
                        url='https://ark.fandom.com/wiki/Stegosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Stego/Stego_Character_BP.Stego_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Dossier_Stegosaurus.png',
                        description="“\nSpecies\nStegosaurus regium\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nDocile\nWild\nStegosaurus regium has approximately 16 paired rows of plates along its back, flanked by another, smaller pair of 6 plates. This is contrary to the alternating rows on Stegosaurus fossils I've seen in museums. Not surprisingly, Stegosaurus uses the spines on its tail to defend itself. While not aggressive, Stegosaurus will come to the aid of another nearby Stegosaurus. This implies it to be a herd animal.\nDomesticated\nStegosaurus is commonly used as a safe way to transport large quantities of goods. And once you saddle one up, not even an Argentavis could knock you off that perch. A stegosaurus can be trained to flex its back plates for different purposes: hardened to shield it from attack, in a heavier alignment that deals crippling blows, or oriented more sharply to pierce armor. These various plate configurations also come in handy for stripping wood from trees, gathering thatch, or foraging for wild berries, respectively. Stegosaurus can knock back or impale with a whip of its spiky tail, keeping predators at bay or pinning them in place. Its spiked appendage also helps for gathering berries—go figure.\n„\n~ Helena")
    models.Creature.new(name='Tapejara', name_tag='Tapejara', category='Reptiles', entity_id='Tapejara_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Tapejara.png',
                        url='https://ark.fandom.com/wiki/Tapejara',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Tapejara/Tapejara_Character_BP.Tapejara_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Tapejara.png',
                        description="“\nSpecies\nTapejara imperator\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nTapejara imperator is a marvel to watch in the wild. It has astonishing agility compared to the Island's other flyers thanks in large part to the rudder-like fin that extends from its snout to the back of its skull. Initially, I'd thought the fin was simply composed of keratin, but closer inspection has led me to believe that it is actually some kind of sensory organ. Not only does it decrease Tapejara's turning radius even at high speeds, but it apparently provides Tapejara with extra information to help it fly through the air with unparalleled grace. I've even seen Tapejara hover and strafe side-to-side in the air without moving forward at all. It's quite remarkable. The creature also makes effective use of razor-sharp claws to latch onto surfaces such as the trunks of tall trees, holding its position indefinitely.\nDomesticated\nWarlike tribes appear to consider Tapejara the equivalent of a versatile rotor aircraft, capable of rapid positional changes and aggressive agility. When domesticated the Tapejara is typically outfitted with a unique triple-rider saddle, enabling two passengers to wield handheld weaponry while the pilot takes the reins. When the Tapejara is latched onto a surface, both the passengers and pilot are able to make full use of their weapons together! Evidently what this skittering creature lacks in distance-stamina, constitution, and weight carrying capacity, it makes up for in maneuverability and combat versatility.\n„\n~ Helena")
    models.Creature.new(name='Tek Parasaur', name_tag='Para', category='Tek Creatures',
                        entity_id='BionicPara_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Parasaur.png',
                        url='https://ark.fandom.com/wiki/Tek_Parasaur',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Para/BionicPara_Character_BP.BionicPara_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/17/Tek_Parasaur_PaintRegion2.jpg',
                        description="“\nSpecies\nParasaurolophus amphibio\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nParasaurolophus amphibio has one of the more interesting adaptations of any creature I've seen on the Island. Like all Parasaur, it has a signature crest on its head. Very docile at first, I've been able to approach the creature without disturbing it. If startled, however, the creature can vocalize a distress call to the surrounding area that warns of danger. Parasaurolophus appears to be low on the food chain and is hunted by everything, creatures and humans alike, which explains its skittish nature. It is a good source of meat and hide, if you can manage to keep up with it long enough to kill it.\nDomesticated\nDespite being what most tribes consider a relatively useless creature to tame, I once met an interesting woman who had tamed an entire herd of them. She informed me that many overlooked the creature's potential. She even graciously gifted me a fancy saddle to put on my own Parasaurolophus one day. As a relatively simple creature to domesticate, Parasaurolophus is commonly one of the first mounts a tribe will be able to acquire. Its ability to run relatively fast for lengthy intervals makes it a solid mode of medium-range transportation, though it has almost no ability to defend itself or its rider in a traditional sense. Smaller creatures, however, appear to be frightened by the horn of Parasaurolophus although it doesn't do much damage. It also has decent weight-bearing capabilities, which could prove useful for nomadic tribes as they work to establish a presence on the Island.\n„\n~ Helena")
    models.Creature.new(name='Tek Quetzal', name_tag='Quetz', category='Tek Creatures',
                        entity_id='BionicQuetz_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Mod_Primal_Fear_Tek_Quetzal_Icon_Image.png',
                        url='https://ark.fandom.com/wiki/Tek_Quetzal',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Quetzalcoatlus/BionicQuetz_Character_BP.BionicQuetz_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Mod_Primal_Fear_Primal_Tek_Quetz.jpg',
                        description="“\nSpecies\nQuetzalcoatlus conchapicem\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nFrom afar, it's hard to believe that Quetzalcoatlus is one of the largest avians on the island. It shares a similar silhouette with the Pteranodon, and nests near the absolute highest peaks. Upon closer inspection, though, Quetzalcoatlus is an enormous creature of tremendous power. I find it strange that such a large, imposing beast would be so skittish. Unlike other creatures of its size, it is more likely to flee than fight. I suppose the decision to flee from any trouble keeps the species alive on an island with so many dangerous predators. But then how does it eat enough to sustain its massive size?\nDomesticated\nTamed Quetzalcoatlus have a very specific role on the island. Too slow to be an efficient local transport, and too weak to be an effective warbird, the tribes I have encountered tend to employ it as a mass carrier. Quetzalcoatlus is primarily used by these masters of the skies to safely carry vast quantities of supplies, creatures and human cargo from one base to another without tiring.\n„\n~ Helena")
    models.Creature.new(name='Tek Raptor', name_tag='Raptor', category='Tek Creatures',
                        entity_id='BionicRaptor_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Mod_Primal_Fear_Tek_Raptor_Icon_Image.png',
                        url='https://ark.fandom.com/wiki/Tek_Raptor',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Raptor/BionicRaptor_Character_BP.BionicRaptor_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/45/Mod_Primal_Fear_Primal_Tek_Raptor.jpg',
                        description='“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena')
    models.Creature.new(name='Tek Rex', name_tag='Rex', category='Tek Creatures', entity_id='BionicRex_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e3/Mod_Primal_Fear_Tek_Rex_Icon_Image.png',
                        url='https://ark.fandom.com/wiki/Tek_Rex',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Rex/BionicRex_Character_BP.BionicRex_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9d/Mod_Primal_Fear_Primal_Tek_Rex.jpg',
                        description='“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena')
    models.Creature.new(name='Tek Stegosaurus', name_tag='Stego', category='Tek Creatures',
                        entity_id='BionicStego_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/39/Mod_Primal_Fear_Tek_Stegosaurus_Icon_Image.png',
                        url='https://ark.fandom.com/wiki/Tek_Stegosaurus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Stego/BionicStego_Character_BP.BionicStego_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Mod_Primal_Fear_Primal_Tek_Stego.jpg',
                        description="“\nSpecies\nStegosaurus regium\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nDocile\nWild\nStegosaurus regium has approximately 16 paired rows of plates along its back, flanked by another, smaller pair of 6 plates. This is contrary to the alternating rows on Stegosaurus fossils I've seen in museums. Not surprisingly, Stegosaurus uses the spines on its tail to defend itself. While not aggressive, Stegosaurus will come to the aid of another nearby Stegosaurus. This implies it to be a herd animal.\nDomesticated\nStegosaurus is commonly used as a safe way to transport large quantities of goods. And once you saddle one up, not even an Argentavis could knock you off that perch. A stegosaurus can be trained to flex its back plates for different purposes: hardened to shield it from attack, in a heavier alignment that deals crippling blows, or oriented more sharply to pierce armor. These various plate configurations also come in handy for stripping wood from trees, gathering thatch, or foraging for wild berries, respectively. Stegosaurus can knock back or impale with a whip of its spiky tail, keeping predators at bay or pinning them in place. Its spiked appendage also helps for gathering berries—go figure.\n„\n~ Helena")
    models.Creature.new(name='Terror Bird', name_tag='TerrorBird', category='Birds',
                        entity_id='TerrorBird_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e3/Terror_Bird.png',
                        url='https://ark.fandom.com/wiki/Terror_Bird',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/TerrorBird/TerrorBird_Character_BP.TerrorBird_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Dossier_Terror_Bird.png',
                        description='“\nSpecies\nPhorusrhacidae rapidesultor\nTime\nLate Paleocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nRanging from eight to twelve feet tall, Phorusrhacidae rapidesultor is a highly aggressive avian that is just barely capable of very brief "flight." Instead, it uses its wings primarily for balance during its high-speed sprints. Phorusrhacidae flight is actually closer to an impressive sustained leap or glide that is assisted and lengthened by flapping its wings. Phorusrhacidae shows interesting traits related to theropods such as Utahraptor, Carnotaurus, and Tyrannosaurus. It has many similar traits, such as general shape and predator patterns, but its attacks tend towards lightning fast dashes and beak slashes.\nDomesticated\nPhorusrhacidae is an effective combat mount, particularly for harassing and scouting. Riders of Phorusrhacidae gain most of the benefits of a fast, mobile ground-based theropod, while also gaining some of the freedom of movement from a flyer...assuming the rider can coax Phorusrhacidae into staying in the air over a long leap.\n„\n~ Helena')
    models.Creature.new(name='Therizinosaur', name_tag='Therizinosaurus', category='Dinosaurs',
                        entity_id='Therizino_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Therizinosaur.png',
                        url='https://ark.fandom.com/wiki/Therizinosaur',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Therizinosaurus/Therizino_Character_BP.Therizino_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e7/Dossier_Therizinosaur.png',
                        description="“\nSpecies\nTherizinosaurus multiensis\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nAggressive\nWild\nI'm not entirely sure how Therizinosaurus multiensis stays populated on the Island. It is surprisingly slow for its size, and is a solitary predator (so no pack to back it up). I suppose the fact that its sheer power rivals Tyrannosaurus is the only thing that allows this very aggressive medium-sized predator to thrive. The claws of Therizinosaurus are some of the most versatile biological tools I've encountered, as adept at removing trees and foliage from Therizinosaurus' path as they are at piercing the thick shells and hide of the Island's most defensive creatures if backed into a fight.\nDomesticated\nA tamed Therizinosaurus is one of the most versatile mounts a survivor can have. It can be trained to use its claws brutally or delicately, allowing the rider to primarily harvest with enhanced efficiency the specific kinds of resources that he or she needs. And in combat, these same claws can pierce straight through the toughest armor. This flexibility more than makes up for its inability to carry the large loads of the Island's many herbivorous beasts of burden.\n„\n~ Helena")
    models.Creature.new(name='Thylacoleo', name_tag='Thylacoleo', category='Mammals',
                        entity_id='Thylacoleo_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/22/Thylacoleo.png',
                        url='https://ark.fandom.com/wiki/Thylacoleo',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Thylacoleo/Thylacoleo_Character_BP.Thylacoleo_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c9/Dossier_Thylacoleo.png',
                        description="“\nSpecies\nThylacoleo furtimorsus\nTime\nLate Pliocene - Late Pleistocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThylacoleo furtimorsus is a large, powerful marsupial that can often be found hunting around trees among the Island's redwoods. Its long claws and semi-opposable digits make it an apt climber, a quality that Thylacoleo uses to its advantage while hunting. It clambers up large trees and waits to ambush passing prey by pouncing upon them. When something that large jumps onto a target, the victim becomes stunned and doesn't stand much of a chance. Thylacoleo's most notable fighting quality is its powerful jaws. Once it bites its prey, it locks its jaw in an iron grip that can hold most smaller creatures in place. Thylacoleo then goes on to savage its prey with its sharp claws. If it needs to escape from a fight, Thylacoleo uses its muscular hind legs to jump back to safety among the trees.\nDomesticated\nThylacoleo is a moderately strong mount, and its ability to climb trees and jump long distances makes it useful for traversal. As such, developing tribes often tame it. Small raiding parties particularly favor Thylacoleo, as it is well suited to ambushes and unfair fights!\n„\n~ Helena")
    models.Creature.new(name='Titanoboa', name_tag='TitanBoa', category='Reptiles', entity_id='BoaFrill_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b6/Titanoboa.png',
                        url='https://ark.fandom.com/wiki/Titanoboa',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/BoaFrill/BoaFrill_Character_BP.BoaFrill_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/47/Dossier_Titanoboa.png',
                        description="“\nSpecies\nTitanoboa exornantur\nTime\nPaleocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nTypically found within the Island's caves, Titanoboa exornantur is an aggressive creature that prefers dark, rocky areas. This extremely large snake, while being a member of the Titanoboa family, does not constrict its prey as most boas do. I believe this adaptation comes from coexisting with giant insects. However, the Titanoboa's venomous bite is so potent that it is known to paralyze far larger creatures. Titanoboa has developed a strange coexistence with other creatures of the Island's caves. Being immune to knockout poisons, and being unable to pierce the thick chitin of the insects, the species have learned to coexist. They often hunt large prey together.\nDomesticated\nAs they appear immune to knockout poisons, Titanoboa exornantur is basically impossible to render unconscious. Because this crucial step can't be done, I'm convinced that Titanoboa are not tameable.\n„\n~ Helena")
    models.Creature.new(name='Titanomyrma Ground', name_tag='Ant', category='Invertebrates',
                        entity_id='Ant_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Titanomyrma.png',
                        url='https://ark.fandom.com/wiki/Titanomyrma',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Ant/Ant_Character_BP.Ant_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5e/Dossier_Titanomyrma.png',
                        description="“\nSpecies\nTitanomyrma parvagigan\nTime\nPaleogene\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nTitanomyrma is one of the smaller creatures on the Island; a frightening thought, when you realize it is the size of a dog. A hive-minded carnivore, Titanomyrma is aggressive on sight to humans and their creature companions. When attacked or threatened, it releases a chemical which alerts all other Titanomyrma in a large range to help fight the aggressor. While small, Titanomyrma remain a threat because of their bite. Titanomyrma mandibles produce a toxic venom that causes loss of stamina, preventing escape and increasing the chance of losing consciousness. I've seen two varieties of Titanomyrma: Drones and Soldiers. Drones are smaller, faster, and land-bound, with the intent to harvest for the colony. Soldiers are larger, slower, have wings, and they defend the colony. If Titanomyrma is akin to hive insects, there must be queens too, but I've yet to encounter such a variant.\nDomesticated\nBecause of its hive mentality, I've not seen any successfully tamed Titanomyrma on the Island yet. Fortunately for lone survivors, separated Titanomyrma can be easily picked off for a small supply of chitin among other natural resources.\n„\n~ Helena")
    models.Creature.new(name='Titanomyrma Air', name_tag='Ant', category='Invertebrates',
                        entity_id='FlyingAnt_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Titanomyrma.png',
                        url='https://ark.fandom.com/wiki/Titanomyrma',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Ant/FlyingAnt_Character_BP.FlyingAnt_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5e/Dossier_Titanomyrma.png',
                        description="“\nSpecies\nTitanomyrma parvagigan\nTime\nPaleogene\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nTitanomyrma is one of the smaller creatures on the Island; a frightening thought, when you realize it is the size of a dog. A hive-minded carnivore, Titanomyrma is aggressive on sight to humans and their creature companions. When attacked or threatened, it releases a chemical which alerts all other Titanomyrma in a large range to help fight the aggressor. While small, Titanomyrma remain a threat because of their bite. Titanomyrma mandibles produce a toxic venom that causes loss of stamina, preventing escape and increasing the chance of losing consciousness. I've seen two varieties of Titanomyrma: Drones and Soldiers. Drones are smaller, faster, and land-bound, with the intent to harvest for the colony. Soldiers are larger, slower, have wings, and they defend the colony. If Titanomyrma is akin to hive insects, there must be queens too, but I've yet to encounter such a variant.\nDomesticated\nBecause of its hive mentality, I've not seen any successfully tamed Titanomyrma on the Island yet. Fortunately for lone survivors, separated Titanomyrma can be easily picked off for a small supply of chitin among other natural resources.\n„\n~ Helena")
    models.Creature.new(name='Titanosaur', name_tag='Titan', category='Dinosaurs',
                        entity_id='Titanosaur_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e7/Titanosaur.png',
                        url='https://ark.fandom.com/wiki/Titanosaur',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/titanosaur/Titanosaur_Character_BP.Titanosaur_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9c/Dossier_Titanosaur.png',
                        description="“\nSpecies\nTitanosaurus vagacastrum\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nPassive, Unless Approached\nWild\nToday I witnessed an unforgettable sight: the extremely rare Titanosaurus vagacastrum. Essentially a walking mountain, it is an absolutely enormous Sauropod which has developed armored plates of bone protrusions all over its body. Between these plates and its unparalleled size, Titanosaurus is extremely difficult to put down. In addition, Titanosaurus seems outright immune to any sort of narcotic effects. They often inadvertently crush nearby creatures underfoot with every step they take. While most Sauropods ignore non-hostile creatures, Titanosaurs take issue with creatures invading its personal space. This is probably because they aggressively feed off any and all plants they can find. Titanosaurus eats constantly, which certainly helps recover health quickly, even after fighting off numerous carnivores such as Giganotosaurus.\nDomesticated\nIf ever a creature were too big, it would be Titanosaurus. You'll hardly see a Titanosaurus with just a saddle and a rider: its immense size can effectively carry a fortress, defensive emplacements, along with a small zoo. Although the Titanosaur can be domesticated, it's believed the process causes the creature to slowly starve to death from its subsequent refusal to eat.\n„\n~ Helena")
    models.Creature.new(name='Triceratops', name_tag='Trike', category='Dinosaurs', entity_id='Trike_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
                        url='https://ark.fandom.com/wiki/Triceratops',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Trike/Trike_Character_BP.Trike_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Triceratops.png',
                        description="“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena")
    models.Creature.new(name='Trilobite', name_tag='Trilobite', category='Invertebrates',
                        entity_id='Trilobite_Character_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2b/Trilobite.png',
                        url='https://ark.fandom.com/wiki/Trilobite',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Trilobite/Trilobite_Character.Trilobite_Character\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Dossier_Trilobite.png',
                        description="“\nSpecies\nTrilobite conchadurus\nTime\nEarly Cambrian-Late Permian\nDiet\nCarnivore\nTemperament\nDefensive\nWild\nLike most Trilobites, Trilobite conchadurus is an opportunistic carnivore that feeds on anything smaller than itself which it can get a hold of. A sluggish creature, the Trilobite's best defense is its incredibly hard shell. This seems to be a common adaptation for the slower creatures of the Island. Trilobite is not a very good source of food. The creature seems to be made mostly out of internal organs and its protective carapace. This is good for the trilobite, as both river and ocean predators are less likely to prey on it if there are better options around.\nDomesticated\nThe Trilobite does not seem to have enough intelligence to be tamed. This doesn't mean it has no use among resourceful survivors, however. Found along beaches and in the ocean's shallows, Trilobites are easily one of the best sources of oil, pearl and chitin on the Island, presuming one doesn't wish to venture into the dangerous caves.\n„\n~ Helena")
    models.Creature.new(name='Troodon', name_tag='Troodon', category='Dinosaurs', entity_id='Troodon_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e9/Troodon.png',
                        url='https://ark.fandom.com/wiki/Troodon',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Troodon/Troodon_Character_BP.Troodon_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c5/Dossier_Troodon.png',
                        description='“\nSpecies\nTroodon magnanimus\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nNocturnally Aggressive\nWild\nQuite possibly the most intelligent non-human creature on the Island, Troodon magnanimus is an incredibly fast learner. It understands meaningful experiences much faster than other creatures (including humans), and its social nature means it also teaches its packmates, making them smarter too! If Troodon\'s cleverness didn\'t make it formidable, then its tactics and biology would. It specifically pack-hunts at night when we are most vulnerable, and sees humans as its primary prey. This audacity is made especially dangerous due to its serrated fangs\' poison, which drains stamina from any creature, but outright paralyses humans. Thankfully, Troodon is fairly small. Were it larger, it might well have become the dominant creature of its ecosystem.\nDomesticated\nI thought Troodon simply could not be tamed, until I finally saw a lone survivor with one. She told me that she let "Troody" hunt a few of her tribe\'s smaller creatures for sport, and it eventually started following her everywhere. It seems that while Troodon is too intelligent to fall for the rote conditioning of "tranq-and-feed," it can instead gradually gain loyalty from a social approach that provides it with the opportunity to hunt. Ever since, I have wondered at the benefits which a pack of ultra-smart, bred-for-battle Troodon may bring to a tribe brave enough to earn the favor of these clever carnivores.\n„\n~ Helena')
    models.Creature.new(name='Turkey', name_tag=None, category='Event Creatures', entity_id='TurkeyBase_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b3/Turkey.png',
                        url='https://ark.fandom.com/wiki/Turkey',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dodo/TurkeyBase_Character_BP.TurkeyBase_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b8/Super_Turkey.jpg',
                        description=None)
    models.Creature.new(name='Super Turkey', name_tag=None, category='Event Creatures',
                        entity_id='Turkey_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b3/Turkey.png',
                        url='https://ark.fandom.com/wiki/Super_Turkey',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dodo/Turkey_Character_BP.Turkey_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b8/Super_Turkey.jpg',
                        description=None)
    models.Creature.new(name='Tusoteuthis', name_tag='Tusoteuthis', category='Invertebrates',
                        entity_id='Tusoteuthis_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Tusoteuthis.png',
                        url='https://ark.fandom.com/wiki/Tusoteuthis',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Tusoteuthis/Tusoteuthis_Character_BP.Tusoteuthis_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Tusoteuthis.png',
                        description="“\nSpecies\nTusoteuthis vampyrus\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nTusoteuthis vampyrus is a very aggressive water predator. Approximately 30 feet long, Tusoteuthis is a terror of the deep. Once it grabs its prey, it slowly crushes it into submission while using the talons on its tentacles to siphon and drink the victim's blood! Tusoteuthis is a terrifying opponent for several reasons. Firstly, its grab slowly renders its victim unconscious, so death isn't the only concern. Secondly, its vampiric blood drain instantly revitalizes it, even during combat. Finally, if Tusoteuthis is losing the fight, it sprays a cloud of ink into the surrounding water, blinding its attackers to cover a sneaky escape.\nDomesticated\nOne of the major benefits of taming Tusoteuthis is harvesting its ink. Unlike normal ink, Tusoteuthis' ink is very oily, and can even be refined into fuels such as gasoline. Between that and Tusoteuthis' distinctive capability to grab & carry large creatures underwater, it makes for an excellent aquatic tame, despite its slower speed.\n„\n~ Helena")
    models.Creature.new(name='Woolly Rhino', name_tag='Rhino', category='Mammals', entity_id='Rhino_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d4/Woolly_Rhinoceros.png',
                        url='https://ark.fandom.com/wiki/Woolly_Rhino',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/WoollyRhino/Rhino_Character_BP.Rhino_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3b/Dossier_Woolly_Rhino.png',
                        description='“\nSpecies\nCoelodonta utiliserro\nTime\nLate Pliocene - Late Pleistocene\nDiet\nHerbivore\nTemperament\nFriendly\nWild\nCoelodonta utiliserro is a friendly herbivore, common to the tundra and grassland regions of the Island. It is a large and dangerous creature, though it seems fairly trusting of the fauna around it. Once attacked, Coelodonta begins charging towards its foe. It builds up momentum as it charges, and depending on its ultimate impact speed, the results can be terrifying. With enough room to charge, it can even skewer the largest creatures in just one gore! Despite how powerful Coelodonta are, many tribes still hunt them extensively due to their unique resources. Its horns can ground into a highly arousing powder, and its thick fur can support many insulating outfits, making the Coelodonta in high demand. Even less-advanced tribes use packs to hunt them down, though at significant peril.\nDomesticated\nWhen not being hunted for its horns, Coelodonta makes an impressive beast of burden. Its ability to take on far larger opponents provided sufficient charging room, as well as its sizeable load capacity, make it a solid addition to any trader party or gathering expedition.\n„\n~ Helena')
    models.Creature.new(name='Yeti', name_tag='Bigfoot', category='Mammals', entity_id='Yeti_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7d/Yeti.png',
                        url='https://ark.fandom.com/wiki/Yeti',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Bigfoot/Yeti_Character_BP.Yeti_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e3/Yeti_promotional_image.jpg',
                        description=None)
    models.Creature.new(name='Yutyrannus', name_tag='Yutyrannus', category='Dinosaurs',
                        entity_id='Yutyrannus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b8/Yutyrannus.png',
                        url='https://ark.fandom.com/wiki/Yutyrannus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Yutyrannus/Yutyrannus_Character_BP.Yutyrannus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Dossier_Yutyrannus.png',
                        description='“\nSpecies\nYutyrannus saevus\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThe Yutyrannus saevus is believed to be related to the Tyrannosaurus rex, but it is noticeably different upon first glance. Feathered creatures are not necessarily viewed as dangerous predators in the same light as other theropods. However, the Yutyrannus strikes fear into even the Island\'s most skilled hunters. There are few wild predators that are able to pack-hunt alongside the generally hostile Carnotaurus, like the Yutyrannus does, with such ease. It is also the only creature I\'ve seen to consistently induce a state of panic in opponents with its roar. Upon hearing it, most creatures in the area will flee for safety.\nDomesticated\nA domesticated Yutyrannus can be a powerful offensive or defensive addition to war parties. With its mighty roar, it can induce fear in opposing creatures. Meanwhile, Yutyrannus can be trained to develop a confidence-boosting Battle-Cry which counteracts enemy attempts to induce fear, while also bolstering the resolve of allies, and may even draw wild Carnotaurus to its aid. These unique "leadership" qualities make the Yutyrannus a versatile, and at times, a necessary creature to have on your side during large-scale confrontations!\n„\n~ Helena')
    models.Creature.new(name='Zomdodo', name_tag='Dodo', category='Event Creatures',
                        entity_id='ZombieDodo_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Zomdodo.png',
                        url='https://ark.fandom.com/wiki/Zomdodo',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Dodo/ZombieDodo_Character_BP.ZombieDodo_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f0/Zomdodos.jpg',
                        description=None)
    models.Creature.new(name='Griffin', name_tag='Griffin', category='Fantasy Creatures',
                        entity_id='Griffin_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f8/Griffin.png',
                        url='https://ark.fandom.com/wiki/Griffin',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Griffin/Griffin_Character_BP.Griffin_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f0/Dossier_Griffin.png',
                        description="“\nSpecies\nGryphon magnificum\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nGryphon Magnificum is undoubtedly a sight to behold. Many ancient myths tell of various depictions of the Griffin over the ages, but what is never disputed is its majestic and mysterious nature. With the front half of an eagle and the back half of a lion, it is as if these two creatures somehow fused together to form a superior land and air predator. While one's first instinct might be to approach the creature and marvel at its beauty, that would be a very poor decision. Its range of attacks makes it one of the more versatile predators I've witnessed. If its presence alone isn't enough to intimidate potential hunters, it has the ability to dive from the sky to the ground with such force that it inflicts damage to anyone unfortunate enough to be below it, or carry its momentum back into a rapid uplift.\nDomesticated\nThe idea of pacifying such a beast is nothing to scoff at. Its highly independent nature and disinterest with interacting with humans combined with its power and strength make the Griffin a challenge to domesticate. However, there have been those who are fearless enough to attempt and succeed at this miraculous feat. Once tamed, riding atop a Griffin along with a tribemate passenger, dashing through the air at high speed, is a prize in and of itself.\n„\n~ Helena")
    models.Creature.new(name='Ice Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='Ragnarok_Wyvern_Override_Ice_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
                        url='https://ark.fandom.com/wiki/Ice_Wyvern',
                        blueprint='"Blueprint\'/Game/Mods/Ragnarok/Custom_Assets/Dinos/Wyvern/Ice_Wyvern/Ragnarok_Wyvern_Override_Ice.Ragnarok_Wyvern_Override_Ice\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
                        description="“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena")
    models.Creature.new(name='Alpha Fire Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='MegaWyvern_Character_BP_Fire_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
                        url='https://ark.fandom.com/wiki/Alpha_Fire_Wyvern',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Wyvern/MegaWyvern_Character_BP_Fire.MegaWyvern_Character_BP_Fire\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
                        description="“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena")
    models.Creature.new(name='Alpha Deathworm', name_tag='Deathworm', category='Invertebrates',
                        entity_id='MegaDeathworm_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/86/Deathworm.png',
                        url='https://ark.fandom.com/wiki/Alpha_Deathworm',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Deathworm/MegaDeathworm_Character_BP.MegaDeathworm_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a3/Dossier_Deathworm.png',
                        description='“\nSpecies\nKhorkoi arrakis\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nExtremely Territorial\nWild\nThe titanic Khorkoi arrakis is commonly called a "Death Worm" by the locals, though I\'m not certain that it is actually a worm. It shares some similarities to some segmented worms, namely the aquatic Eunice aphroditois, but it\'s biology doesn\'t seem consistent with other members of the annelid phylum. However, the "death" part of its name could not be more spot on. Khorkoi is without question the apex predator of this desert. It will devour anything that dares to set foot in the Endless Dunes, regardless of size or ferocity. Khorkoi spends most of its time burrowed beneath the desert sands, exploding to the surface only to devour its prey in a single bite. The only chance of surviving a Khorkoi attack is if its initial lunge misses, as it\'s momentarily immobile afterwards. Theoretically, that could provide a brief opportunity to escape its territory. I wouldn\'t count on such luck, though.\nDomesticated\nAttempting to tame Khorkoi will almost certainly result in failure and a very painful death. Any survivors in this desert should avoid Khorkoi territory at all costs.\n„\n~ Helena')
    models.Creature.new(name='Deathworm', name_tag='Deathworm', category='Invertebrates',
                        entity_id='Deathworm_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/86/Deathworm.png',
                        url='https://ark.fandom.com/wiki/Deathworm',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/DeathWorm/DeathWorm_Character_BP.DeathWorm_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a3/Dossier_Deathworm.png',
                        description='“\nSpecies\nKhorkoi arrakis\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nExtremely Territorial\nWild\nThe titanic Khorkoi arrakis is commonly called a "Death Worm" by the locals, though I\'m not certain that it is actually a worm. It shares some similarities to some segmented worms, namely the aquatic Eunice aphroditois, but it\'s biology doesn\'t seem consistent with other members of the annelid phylum. However, the "death" part of its name could not be more spot on. Khorkoi is without question the apex predator of this desert. It will devour anything that dares to set foot in the Endless Dunes, regardless of size or ferocity. Khorkoi spends most of its time burrowed beneath the desert sands, exploding to the surface only to devour its prey in a single bite. The only chance of surviving a Khorkoi attack is if its initial lunge misses, as it\'s momentarily immobile afterwards. Theoretically, that could provide a brief opportunity to escape its territory. I wouldn\'t count on such luck, though.\nDomesticated\nAttempting to tame Khorkoi will almost certainly result in failure and a very painful death. Any survivors in this desert should avoid Khorkoi territory at all costs.\n„\n~ Helena')
    models.Creature.new(name='Dodo Wyvern', name_tag='Wyvern', category='Event Creatures',
                        entity_id='DodoWyvern_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
                        url='https://ark.fandom.com/wiki/Dodo_Wyvern',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/DodoWyvern/DodoWyvern_Character_BP.DodoWyvern_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
                        description="“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena")
    models.Creature.new(name='Jerboa', name_tag='Jerboa', category='Mammals', entity_id='Jerboa_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7a/Jerboa.png',
                        url='https://ark.fandom.com/wiki/Jerboa',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Jerboa/Jerboa_Character_BP.Jerboa_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8c/Dossier_Jerboa.png',
                        description="“\nSpecies\nRenopila amplexus\nTime\nUnknown\nDiet\nHerbivore\nTemperament\nCowardly\nWild\nScientifically speaking, Renopila amplexus is an adorable little fuzzball and I just want to hug it forever. Unfortunately, being harmless and lovable is inadequate as a defense mechanism in this wasteland, and that means Renopila is at the bottom of the food chain. It's an easy meal for predators and survivors alike, the latter of whom also value its hide. The locals refer to Renopila as a Jerboa, but while it does look similar in some ways, it is clearly unrelated. The fact that it does not hop is a dead giveaway. In fact, while Renopila generally fits into the clade Glires, it seems to share traits with both rodents and lagomorphs.\nDomesticated\nIn addition to being the cutest little companion in the desert, hours of close study and/or cuddling have taught me that Renopila has an instinctive understanding of this land's weather patterns. When the weather is about to change, Renopila will suddenly start behaving differently, so taming Renopila does have practical uses that can justify its perch upon one's shoulder. Not that I need justification, but I'll take whatever excuse I can get.\n„\n~ Helena")
    models.Creature.new(name='Skeletal Jerboa', name_tag='Jerboa', category='Event Creatures',
                        entity_id='Bone_Jerboa_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Skeletal_Jerboa.png',
                        url='https://ark.fandom.com/wiki/Skeletal_Jerboa',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Jerboa/Bone_Jerboa_Character_BP.Bone_Jerboa_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3b/FearEvolved2_WerewolfMaskSkeletonJerboa.jpg',
                        description=None)
    models.Creature.new(name='Jug Bug', name_tag='Jugbug', category='Invertebrates',
                        entity_id='Jugbug_Character_BaseBP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Jug_Bug.png',
                        url='https://ark.fandom.com/wiki/Jug_Bug',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Jugbug/JugBug_Character_BaseBP.JugBug_Character_BaseBP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Dossier_Jug_Bug.png',
                        description="“\nSpecies\nScutinphora puteus\nTime\nHolocene\nDiet\nHerbivore\nTemperament\nPassive\nWild\nScutinphora puteus is a fast, flying insect that comes in two varieties, visually distinct only in the red or green markings on its exoskeleton. Biologically and behaviorally, they are practically the same. The only real difference between the two is the resource they gather in the expandable sacks on their backs. Scutinphora with green markings gather water, and Scutinphora with red markings gather oil. This unique ability makes Scutinphora a target for both the desert's natural predators and human survivors. Finding a green Scutinphora at the right time could prove to be life-saving, and survivors can use the oil produced by red Scutinphora for a wide variety of purposes.\nDomesticated\nLike many of the insects on the island, Scutinphora cannot be tamed. Beyond the resources obtained while hunting it, survivors will find no use for it.\n„\n~ Helena")
    models.Creature.new(name='Oil Jug Bug', name_tag='Jugbug', category='Invertebrates',
                        entity_id='Jugbug_Oil_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Jug_Bug.png',
                        url='https://ark.fandom.com/wiki/Oil_Jug_Bug',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Jugbug/Jugbug_Oil_Character_BP.Jugbug_Oil_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Dossier_Jug_Bug.png',
                        description="“\nSpecies\nScutinphora puteus\nTime\nHolocene\nDiet\nHerbivore\nTemperament\nPassive\nWild\nScutinphora puteus is a fast, flying insect that comes in two varieties, visually distinct only in the red or green markings on its exoskeleton. Biologically and behaviorally, they are practically the same. The only real difference between the two is the resource they gather in the expandable sacks on their backs. Scutinphora with green markings gather water, and Scutinphora with red markings gather oil. This unique ability makes Scutinphora a target for both the desert's natural predators and human survivors. Finding a green Scutinphora at the right time could prove to be life-saving, and survivors can use the oil produced by red Scutinphora for a wide variety of purposes.\nDomesticated\nLike many of the insects on the island, Scutinphora cannot be tamed. Beyond the resources obtained while hunting it, survivors will find no use for it.\n„\n~ Helena")
    models.Creature.new(name='Water Jug Bug', name_tag='Jugbug', category='Invertebrates',
                        entity_id='Jugbug_Water_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Jug_Bug.png',
                        url='https://ark.fandom.com/wiki/Water_Jug_Bug',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Jugbug/Jugbug_Water_Character_BP.Jugbug_Water_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Dossier_Jug_Bug.png',
                        description="“\nSpecies\nScutinphora puteus\nTime\nHolocene\nDiet\nHerbivore\nTemperament\nPassive\nWild\nScutinphora puteus is a fast, flying insect that comes in two varieties, visually distinct only in the red or green markings on its exoskeleton. Biologically and behaviorally, they are practically the same. The only real difference between the two is the resource they gather in the expandable sacks on their backs. Scutinphora with green markings gather water, and Scutinphora with red markings gather oil. This unique ability makes Scutinphora a target for both the desert's natural predators and human survivors. Finding a green Scutinphora at the right time could prove to be life-saving, and survivors can use the oil produced by red Scutinphora for a wide variety of purposes.\nDomesticated\nLike many of the insects on the island, Scutinphora cannot be tamed. Beyond the resources obtained while hunting it, survivors will find no use for it.\n„\n~ Helena")
    models.Creature.new(name='Lymantria', name_tag='Moth', category='Invertebrates', entity_id='Moth_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1d/Lymantria.png',
                        url='https://ark.fandom.com/wiki/Lymantria',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Moth/Moth_Character_BP.Moth_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e7/Dossier_Lymantria.png',
                        description="“\nSpecies\nLymantria sporarmis\nTime\nHolocene\nDiet\nHerbivore\nTemperament\nEvasive\nWild\nLike its smaller relatives, Lymantria sporarmis survives by draining plants and vegetables of their nutrients. Given the desolate nature of the region, that makes its options rather limited, but fortunately its relationship with the desert's plants is symbiotic. In addition to pollinating them, the spores it releases help nourish the harsh desert plants. When attacked, the slow-moving Lymantria immediately takes to the air and flies almost straight up while releasing spores. While the spores are nutritious to most plants, they are highly poisonous to most other organisms.\nDomesticated\nLymantria is occasionally used as a one man flying mount, but its ability to produce silk and spores is often considered more valuable due to its slow flight speed. Its silk can be weaved into heat-dispersing cloth, and its spores gathered for fertilizer or poison. Its saving grace as a mount is its ability to release spores mid flight, allowing it to act as a primitive bomber during sieges.\n„\n~ Helena")
    models.Creature.new(name='Manticore (Gamma)', name_tag='Manticore', category='Bosses',
                        entity_id='Manticore_Character_BP_Easy_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/03/Manticore.png',
                        url='https://ark.fandom.com/wiki/Manticore_(Gamma)',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Manticore/Manticore_Character_BP_Easy.Manticore_Character_BP_Easy\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ed/Dossier_Manticore.png',
                        description=None)
    models.Creature.new(name='Manticore (Beta)', name_tag='Manticore', category='Bosses',
                        entity_id='Manticore_Character_BP_Medium_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/03/Manticore.png',
                        url='https://ark.fandom.com/wiki/Manticore_(Beta)',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Manticore/Manticore_Character_BP_Medium.Manticore_Character_BP_Medium\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ed/Dossier_Manticore.png',
                        description=None)
    models.Creature.new(name='Manticore (Alpha)', name_tag='Manticore', category='Bosses',
                        entity_id='Manticore_Character_BP_Hard_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/03/Manticore.png',
                        url='https://ark.fandom.com/wiki/Manticore_(Alpha)',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Manticore/Manticore_Character_BP_Hard.Manticore_Character_BP_Hard\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ed/Dossier_Manticore.png',
                        description=None)
    models.Creature.new(name='Mantis', name_tag='Mantis', category='Invertebrates', entity_id='Mantis_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/48/Mantis.png',
                        url='https://ark.fandom.com/wiki/Mantis',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Mantis/Mantis_Character_BP.Mantis_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/80/Dossier_Mantis.png',
                        description='“\nSpecies\nEmpusa discipulus\nTime\nHolocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThe existence of a creature such as Empusa discipulus is both fascinating and frightening. Not only is Empusa the only recorded insect to have developed an opposable digit, allowing it to grip objects and use tools, but it possesses a level of intelligence that is unrivalled among non-human species. I have even found clear patterns in the sounds Empusa makes when communicating with its own kind, as though it is actually using some kind of dialect. I would love to study these interactions in depth, but observing Empusa up close is extremely dangerous. Its size, intelligence and ability to pounce on its prey from a great distance mean that one could be quickly swarmed and killed upon detection. Caution is recommended.\nDomesticated\nThough a dangerous task, successfully taming Empusa can prove highly beneficial. Its unique claws allow it to wield melee weapons like spears or pikes in battle, and use tools while harvesting resources. This makes it deadly as a mount or footsoldier and highly efficient as a gatherer.\n„\n~ Helena')
    models.Creature.new(name='Mantis Ghost', name_tag='Mantis', category='Event Creatures',
                        entity_id='Ghost_Mantis_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/11/Mantis_Ghost.png',
                        url='https://ark.fandom.com/wiki/Mantis_Ghost',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Mantis/Ghost_Mantis_Character_BP.Ghost_Mantis_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8a/Mantis_Ghost_Image.jpg',
                        description=None)
    models.Creature.new(name='Morellatops', name_tag='Camelsaurus', category='Dinosaurs',
                        entity_id='camelsaurus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/54/Morellatops.png',
                        url='https://ark.fandom.com/wiki/Morellatops',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Camelsaurus/camelsaurus_Character_BP.camelsaurus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6f/Dossier_Morellatops.png',
                        description="“\nSpecies\nMorellatops dromedarius\nTime\nEarly Cretaceous\nDiet\nHerbivore\nTemperament\nPassive\nWild\nMorellatops dromedarius seems to be to a relative of both the Morelladon and Ceratops genuses, which in itself is rather strange. On top of that, it has developed to ability to store water in its humps like a camel. This makes it a critical part of the desert's food chain, as it provides predators with both food and hydration.\nDomesticated\nWhen survivors discovered how to tap into the water in Morellatops' humps without harming it, the docile creature became the desert's essential pack animal. Not only can it carry a good amount of weight, but it can provide survivors with a large, mobile water source that can mean the difference between life and death on any given journey. Morellatops has limited options when it comes to self defense, so I would not recommend taking one into combat. However, so long as survivors don't forget to let Morellatops stop by a well every now and then, they will find the creature an invaluable companion.\n„\n~ Helena")
    models.Creature.new(name='Rock Elemental', name_tag='RockElemental', category='Fantasy Creatures',
                        entity_id='RockGolem_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f0/Rock_Elemental.png',
                        url='https://ark.fandom.com/wiki/Rock_Elemental',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/RockGolem/RockGolem_Character_BP.RockGolem_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Rock_Elemental.png',
                        description="“\nSpecies\nColossus petram\nTime\nUnknown\nDiet\nMinerals\nTemperament\nExtremely Territorial\nWild\nColossus petram is like no creature I have ever encountered. There is no biological or historical precedent for it. Its nearest relatives exist only in legend – mythical statues that could come to life like the Golem of Prague. That makes it all the more dangerous. What survivor could possibly expect a seemingly benign rock formation to suddenly spring to life and attack them? Fortunately, Colossus petram's massive size makes it quite slow, so I would advise most survivors to flee immediately if encountering it in the wild. Colossus petram survives by slowly absorbing nearby minerals while in its dormant state, which consequently means that its body contains a wealth of metal ingots. If undisturbed, it can maintain this hibernation ad infinitum, but it will viciously attack anyone who encroaches upon its territory. A solitary creature, Colossus petram lives alone, and will not even protect its own kind.\nDomesticated\nIf somehow tamed, Colossus petram could prove to be an invaluable asset, particularly in a siege. Only armor piercing rounds or explosives can harm it at all, and it will handily smash through stone structures.\n„\n~ Helena")
    models.Creature.new(name='Rubble Golem', name_tag='RockElemental', category='Fantasy Creatures',
                        entity_id='RubbleGolem_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f0/Rock_Elemental.png',
                        url='https://ark.fandom.com/wiki/Rubble_Golem',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/RockGolem/RubbleGolem_Character_BP.RubbleGolem_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Rock_Elemental.png',
                        description="“\nSpecies\nColossus petram\nTime\nUnknown\nDiet\nMinerals\nTemperament\nExtremely Territorial\nWild\nColossus petram is like no creature I have ever encountered. There is no biological or historical precedent for it. Its nearest relatives exist only in legend – mythical statues that could come to life like the Golem of Prague. That makes it all the more dangerous. What survivor could possibly expect a seemingly benign rock formation to suddenly spring to life and attack them? Fortunately, Colossus petram's massive size makes it quite slow, so I would advise most survivors to flee immediately if encountering it in the wild. Colossus petram survives by slowly absorbing nearby minerals while in its dormant state, which consequently means that its body contains a wealth of metal ingots. If undisturbed, it can maintain this hibernation ad infinitum, but it will viciously attack anyone who encroaches upon its territory. A solitary creature, Colossus petram lives alone, and will not even protect its own kind.\nDomesticated\nIf somehow tamed, Colossus petram could prove to be an invaluable asset, particularly in a siege. Only armor piercing rounds or explosives can harm it at all, and it will handily smash through stone structures.\n„\n~ Helena")
    models.Creature.new(name='Thorny Dragon', name_tag='SpineyLizard', category='Reptiles',
                        entity_id='SpineyLizard_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Thorny_Dragon.png',
                        url='https://ark.fandom.com/wiki/Thorny_Dragon',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/SpineyLizard/SpineyLizard_Character_BP.SpineyLizard_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/48/Dossier_Thorny_Dragon.png',
                        description="“\nSpecies\nMoloch sagittarius\nTime\nHolocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThough survivors have come to call these gargantuan reptiles Spiny Lizards, I believe that Moloch sagittarius' closest known relative is the Australian Thorny Devil (Moloch horridus). Besides the obvious gap in size, most of the differences between Moloch sagittarius and its smaller relative lie in its thorns. Instead of being permanent parts of its skin, Moloch sagittarius' thorns are more like spines or quills that can be removed and regrown. In fact, it is even capable of shooting these spines from its tail as a method of self defense, and examination of these projectiles has revealed that they are coated in a lethal poison.\nDomesticated\nDespite its dangerous spines, Moloch sagittarius has proven to be an excellent mount for indirect combat. Its ranged attacks can wreak havoc in a pitched battle, particularly if other creatures are taking the enemy's attention. Additionally, Moloch sagittarius is able to gather wood rather effectively, making it more than just an option for combat. Once saddled it can be used as a workbench, allowing for a mobile crafting station.\n„\n~ Helena")
    models.Creature.new(name='Vulture', name_tag='Vulture', category='Birds', entity_id='Vulture_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/01/Vulture.png',
                        url='https://ark.fandom.com/wiki/Vulture',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Vulture/Vulture_Character_BP.Vulture_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9b/Dossier_Vulture.png',
                        description='“\nSpecies\nTorgos arcam\nTime\nEarly Pleistocene\nDiet\nCarrion-Feeder\nTemperament\nDocile\nWild\nTorgos arcam appears to be a relative of Torgos tracheliotos and Torgos negevensis – commonly called lappet-faced vultures – which are native to the sands of the Sahara, Sahel, and Negev deserts. Like them, it is a carrion bird that feeds on the decaying corpses of other animals, and is only aggressive when defending its meal. As such, survivors should take note when they see groups of Torgos arcam circling above. It means that a wounded creature or a bloody battle may be somewhere below.\nDomesticated\nDespite its impressive wingspan, Torgos arcam is not suitable as a pack animal, and is surprisingly light. Some survivors have even been known to keep a tame Torgos arcam perched on their shoulder. Interestingly, Torgos arcam is capable of storing raw meat in a separate stomach where it will decay at a slower rate. Tribes could, in theory, utilize this feature to preserve meat for recipes.\n„\n~ Helena')
    models.Creature.new(name='Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='Wyvern_Character_BP_Base_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
                        url='https://ark.fandom.com/wiki/Wyvern',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Wyvern/Wyvern_Character_BP_Base.Wyvern_Character_BP_Base\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
                        description="“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena")
    models.Creature.new(name='Phoenix', name_tag='Phoenix', category='Fantasy Creatures',
                        entity_id='Phoenix_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Phoenix.png',
                        url='https://ark.fandom.com/wiki/Phoenix',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Phoenix/Phoenix_Character_BP.Phoenix_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bd/Dossier_Phoenix.png',
                        description='“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nFlame Eater\nTemperament\nElusive\nWild\nAmong the most mysterious of all flying creatures, much of what is known about the Phoenix exists in legends which have been told through generations. These myths have often changed through the passing of time but one constant is the belief that fire represents cleansing and renewal. The Phoenix embodies this process through its everlasting cycle of death and renewal! Extreme heat-waves in the desert seem to initiate the rise of the Phoenix, while the end of this so-called "Super Heat" precipitated the creature\'s reversion into ashes. While the Phoenix seems ambivalent to most wildlife, if provoked its ferocity is evident in its ability to set targets aflame with a single bite.\nDomesticated\nAttempting to pacify a Phoenix is, quite literally, playing with fire. The Phoenix must be continually set ablaze in order to be tamed. I\'ve seen many turned into dust and ash in the attempt. After it has been pacified, the Phoenix will regain its vitality when it is aflame! Although its compact size prevents the Phoenix from being ridden, its aggressive enflaming has proved to be invaluable in battle. Plus, it can quickly roast up tasty cooked meat and refine raw ores at any time, as a living furnace!\n„\n~ Helena')
    models.Creature.new(name='Fire Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='Wyvern_Character_BP_Fire_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
                        url='https://ark.fandom.com/wiki/Fire_Wyvern',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Wyvern/Wyvern_Character_BP_Fire.Wyvern_Character_BP_Fire\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
                        description="“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena")
    models.Creature.new(name='Lightning Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='Wyvern_Character_BP_Lightning_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
                        url='https://ark.fandom.com/wiki/Lightning_Wyvern',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Wyvern/Wyvern_Character_BP_Lightning.Wyvern_Character_BP_Lightning\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
                        description="“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena")
    models.Creature.new(name='Poison Wyvern', name_tag='Wyvern', category='Fantasy Creatures',
                        entity_id='Wyvern_Character_BP_Poison_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
                        url='https://ark.fandom.com/wiki/Poison_Wyvern',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Wyvern/Wyvern_Character_BP_Poison.Wyvern_Character_BP_Poison\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
                        description="“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena")
    models.Creature.new(name='Bone Fire Wyvern', name_tag='Wyvern', category='Event Creatures',
                        entity_id='Bone_MegaWyvern_Character_BP_Fire_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a7/Bone_Fire_Wyvern.png',
                        url='https://ark.fandom.com/wiki/Bone_Fire_Wyvern',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Wyvern/Bone_MegaWyvern_Character_BP_Fire.Bone_MegaWyvern_Character_BP_Fire\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1b/Bone_Fire_Wyvern_Image.jpg',
                        description=None)
    models.Creature.new(name='Zombie Fire Wyvern', name_tag='Wyvern', category='Event Creatures',
                        entity_id='Wyvern_Character_BP_ZombieFire_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/72/Zombie_Wyvern.png',
                        url='https://ark.fandom.com/wiki/Zombie_Fire_Wyvern',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Wyvern/Wyvern_Character_BP_ZombieFire.Wyvern_Character_BP_ZombieFire\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/30/FearEvolved2_ZombieWyvern.jpg',
                        description=None)
    models.Creature.new(name='Zombie Lightning Wyvern', name_tag='Wyvern', category='Event Creatures',
                        entity_id='Wyvern_Character_BP_ZombieLightning_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/72/Zombie_Wyvern.png',
                        url='https://ark.fandom.com/wiki/Zombie_Lightning_Wyvern',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Wyvern/Wyvern_Character_BP_ZombieLightning.Wyvern_Character_BP_ZombieLightning\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/30/FearEvolved2_ZombieWyvern.jpg',
                        description=None)
    models.Creature.new(name='Zombie Poison Wyvern', name_tag='Wyvern', category='Event Creatures',
                        entity_id='Wyvern_Character_BP_ZombiePoison_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/72/Zombie_Wyvern.png',
                        url='https://ark.fandom.com/wiki/Zombie_Poison_Wyvern',
                        blueprint='"Blueprint\'/Game/ScorchedEarth/Dinos/Wyvern/Wyvern_Character_BP_ZombiePoison.Wyvern_Character_BP_ZombiePoison\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/30/FearEvolved2_ZombieWyvern.jpg',
                        description=None)
    models.Creature.new(name='Chalk Golem', name_tag='RockElemental', category='Fantasy Creatures',
                        entity_id='ChalkGolem_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f0/Rock_Elemental.png',
                        url='https://ark.fandom.com/wiki/Chalk_Golem',
                        blueprint='"Blueprint\'/Game/Mods/Valguero/Assets/Dinos/RockGolem/ChalkGolem/ChalkGolem_Character_BP.ChalkGolem_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Rock_Elemental.png',
                        description="“\nSpecies\nColossus petram\nTime\nUnknown\nDiet\nMinerals\nTemperament\nExtremely Territorial\nWild\nColossus petram is like no creature I have ever encountered. There is no biological or historical precedent for it. Its nearest relatives exist only in legend – mythical statues that could come to life like the Golem of Prague. That makes it all the more dangerous. What survivor could possibly expect a seemingly benign rock formation to suddenly spring to life and attack them? Fortunately, Colossus petram's massive size makes it quite slow, so I would advise most survivors to flee immediately if encountering it in the wild. Colossus petram survives by slowly absorbing nearby minerals while in its dormant state, which consequently means that its body contains a wealth of metal ingots. If undisturbed, it can maintain this hibernation ad infinitum, but it will viciously attack anyone who encroaches upon its territory. A solitary creature, Colossus petram lives alone, and will not even protect its own kind.\nDomesticated\nIf somehow tamed, Colossus petram could prove to be an invaluable asset, particularly in a siege. Only armor piercing rounds or explosives can harm it at all, and it will handily smash through stone structures.\n„\n~ Helena")
    models.Creature.new(name='Deinonychus', name_tag='Deinonychus', category='Dinosaurs',
                        entity_id='Deinonychus_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4e/Deinonychus.png',
                        url='https://ark.fandom.com/wiki/Deinonychus',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/Raptor/Uberraptor/Deinonychus_Character_BP.Deinonychus_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ab/Dossier_Deinonychus.png',
                        description="“\nSpecies\nDeinonychus magna pede\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nBy the time you hear the scurrying claws of the Deinonychus, it's often too late. Superior hunters, they leap from a hiding place and pounce on their prey. The Deinonychus is an agile climber as well, jumping from wall ledge to wall ledge as it seeks high vantage points to lie in wait. A hungry Deinonychus tends to be fearless and will hunt prey much larger than itself, latching onto a dinosaur's back with its sickle-shaped claws, then starting to feed before its victim is even dead. While it likes its meat fresh, a Deinonychus isn't above scavenging a carcass if no other food is available.\nDomesticated\nRaising a Deinonychus in captivity requires an ample food supply, as they have a fast metabolism to match their high activity level. The Deinonychus is also fiercely territorial near nests with eggs, even if the eggs aren't its own. This makes breeding successive generations a hazardous process. Unless raised from eggs, they cannot be tamed; the hunter instinct of a wild Deinonychus is so strong that it reflexively pounces on a would-be master.\n„\n~ Helena")
    models.Creature.new(name='Ice Golem', name_tag='RockElemental', category='Fantasy Creatures',
                        entity_id='IceGolem_Character_BP_C',
                        small_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f0/Rock_Elemental.png',
                        url='https://ark.fandom.com/wiki/Ice_Golem',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/IceGolem/IceGolem_Character_BP.IceGolem_Character_BP\'"',
                        large_image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Rock_Elemental.png',
                        description="“\nSpecies\nColossus petram\nTime\nUnknown\nDiet\nMinerals\nTemperament\nExtremely Territorial\nWild\nColossus petram is like no creature I have ever encountered. There is no biological or historical precedent for it. Its nearest relatives exist only in legend – mythical statues that could come to life like the Golem of Prague. That makes it all the more dangerous. What survivor could possibly expect a seemingly benign rock formation to suddenly spring to life and attack them? Fortunately, Colossus petram's massive size makes it quite slow, so I would advise most survivors to flee immediately if encountering it in the wild. Colossus petram survives by slowly absorbing nearby minerals while in its dormant state, which consequently means that its body contains a wealth of metal ingots. If undisturbed, it can maintain this hibernation ad infinitum, but it will viciously attack anyone who encroaches upon its territory. A solitary creature, Colossus petram lives alone, and will not even protect its own kind.\nDomesticated\nIf somehow tamed, Colossus petram could prove to be an invaluable asset, particularly in a siege. Only armor piercing rounds or explosives can harm it at all, and it will handily smash through stone structures.\n„\n~ Helena")

    items = [item.to_json() for item in models.Creature.all()]
    print(items)


def seed():
    items = [
        {
            'name': 'Aberrant Achatina', 'name_tag': 'Achatina', 'entity_id': 'Achatina_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Achatina/Achatina_Character_BP_Aberrant.Achatina_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bc/Dossier_Achatina.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Achatina', 'id': 1, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/18/Achatina.png',
            'description': '“\nSpecies\nAchatina limusegnis\nTime\nHolocene\nDiet\nHerbivore\nTemperament\nPassive\nWild\nFound mostly in marshes and jungles, Achatina limusegnis is a very slow, very non-threatening land mollusk. It might be the simplest creature on the Island to hunt, and while it only provides a small amount of meat and chitin, an easy meal is always of value on the Island. Unlike nearly every other creature on the Island, Achatina does not defecate normally. Instead, it secretes a thick, sticky substance. Achatina leaves trails of this slime, but the trails are so thin that they crumble to dust quickly.\nDomesticated\nThere is a very disgusting, but useful fact about Achatina that causes tribes to seek to tame them: its secretions are chemically similar to the "Cementing Paste" and "Organic Polymer" used by many tribes for building materials. Tamed Achatina naturally accumulates this slime over time, which can then be collected at the tribe\'s convenience. Legend has it that Achatina can be tamed with a special "cake" made from harvested crops & resources.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Anglerfish', 'name_tag': 'Angler', 'entity_id': 'Angler_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Anglerfish/Angler_Character_BP_Aberrant.Angler_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0d/Dossier_Angler.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Anglerfish', 'id': 2, 'category': 'Fish',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Anglerfish.png',
            'description': "“\nSpecies\nMelanocetus anglerpescum\nTime\nEarly Cretaceous - Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWhether its size is caused by adaptation to the Island's other inhabitants, or by cross-breeding with another larger species, Melanocetus angerlpescum is the largest form of Anglerfish I've ever heard of. Typically found among the deepest, darkest expanses of the ocean, this creature preys on smaller fish while being an excellent source of food for larger predators. Melanocetus has an array of bioluminescent light pods at the end of stalks on its head. Like typical Anglerfish, it primarily uses these to attract smaller creatures and trick them into coming close enough for Melanocetus to consume the prey. This often makes wild Melanocetus itself relatively easy to spot among the briny depths.\nDomesticated\nExploring the depths of the ocean can be difficult. The cold, the lack of air, and the shocking absence of light combine to make travel very dangerous. A tamed Anglerfish can use the natural light at the end of its stalks to illuminate the depths, making exploration not only safer but more lucrative, as I've heard some survivors use this creature to harvest the silica pearls found throughout the ocean's depths!\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Ankylosaurus', 'name_tag': 'Anky', 'entity_id': 'Ankylo_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Ankylo/Ankylo_Character_BP_Aberrant.Ankylo_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8e/Dossier_Ankylosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Ankylosaurus', 'id': 3, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a7/Ankylosaurus.png',
            'description': "“\nSpecies\nAnkylosaurus crassacutis\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nDocile\nWild\nUnlike many of the herd animals on the Island, Ankylosaurus crassacutis tends to live in small family units. I believe they can afford to stick with smaller groups because of their incredibly thick skin, for which they're named. Despite not being among the largest of the Island's herbivores, Ankylosaurus is one of the more difficult creatures to take down. Its thick, armored skin seems to make it more than a match for several of the mid-sized predators that would otherwise hunt it. Reckless carnivores are just as likely to hurt themselves on Ankylosaurus' spikes, as they are to get hit by its tail.\nDomesticated\nWithout a doubt, the best trait of a trained Ankylosaurus is its enormously dense tail. This tail is powerful enough to quickly shatter the resource-laden rocks of the Island. One of the wealthier human tribes on the island utilizes a squad of Ankylosaurs in its mines and quarries. The creature's affinity for metal enables it to carry raw ore at an effectively reduced weight.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Araneo', 'name_tag': 'Spider', 'entity_id': 'SpiderS_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Spider-Small/SpiderS_Character_BP_Aberrant.SpiderS_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Dossier_Araneo.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Araneo', 'id': 4, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Spider.png',
            'description': "“\nSpecies\nAraneomorphus amalgotantibus\nTime\nNo equivalent, traits begin as far as Mesozoic Era\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nI don't know where to start with Araneomorphus amalgotantibus. It has so many of the nightmare inducing traits of spiders from among many family and genus. It fires webbing like a bola spider, it spits venom like a lynx spider. It has a poisonous bite like a myriad of spiders, and can see in the dark by sensing vibrations. And to top it off, Araneomorphus is larger than an adult human! If that wasn't enough, I'm convinced that some of the caves on the island have actually been dug by Araneomorphus, but this worries me. Either Araneomorphus is a colony-spider (like ants), or there is a much larger Araneomorphus somewhere on the island.\nDomesticated\nAs long as it is kept far from arachnophobics, domesticated Araneomorphus makes an excellent guardian creature for anyone wanting to avoid killing. Their strange web-spraying behavior is also quite helpful while hunting fast, fleeing prey. They are too small to be used as mounts, however...\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Arthropluera', 'name_tag': 'Arthro', 'entity_id': 'Arthro_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Arthropluera/Arthro_Character_BP_Aberrant.Arthro_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Dossier_Arthropluera.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Arthropluera', 'id': 5, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Arthropluera.png',
            'description': "“\nSpecies\nArthropluera felsanguis\nTime\nEarly Permian\nDiet\nCarrion-Feeder\nTemperament\nAggressive\nWild\nThe fact that this creature exists is enough to give me nightmares. Like the island's other Arthropods, Arthropluera Felsanguis has become much larger than I might have believed possible. It's a very aggressive hunter, but prefers to eat meat after it has rotted for some time, and will voraciously seek out such delicacies.\nKnown Information\nArthropluera's blood has a very low pH, to the point that it can dissolve many materials. This acidic blood splashes back on anything that directly attacks it, weakening the durability of weapons and hurting attackers. Many creatures thusly refuse to prey on Arthropluera, fearing this unique defense. If that wasn't enough, Arthropluera also keeps a small reservoir of blood ready to spit at its prey.\nDomesticated\nLike most of the arthropods on the island, Arthropluera is simple minded and relatively easy to tame. It is an almost entirely military mount, useful mostly for attacking at a distance. Thanks to its unique defenses, whether hunting or warring, Arthropluera is generally safe from all but the largest of creatures.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Baryonyx', 'name_tag': 'Baryonyx', 'entity_id': 'Baryonyx_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Baryonyx/Baryonyx_Character_BP_Aberrant.Baryonyx_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Baryonyx.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Baryonyx', 'id': 6, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c0/Baryonyx.png',
            'description': "“\nSpecies\nBaryonyx aquafulgur\nTime\nEarly Cretaceous\nDiet\nPiscivore\nTemperament\nPassive to land creatures, but aggressive to water-dwellers\nWild\nLike the Carnotaurus, Baryonyx aquafulguar is a large carnivore, but not large enough to rival the Island's apex predators. While not as powerful as some deep-sea predators or Spinosaurus, Baryonyx is an extremely fast swimmer who is still sufficiently nimble enough to threaten most creatures on the Island. And yet despite being a fast, dangerous dinosaur, Baryonyx almost exclusively consumes fish and other water-dwellers. The highly specific metabolism of Baryonyx seems to allow it to heal wounds almost preternaturally fast after feeding on nutritious fish meat. Perhaps this is why Baryonyx rarely attacks land animals?\nDomesticated\nBaryonyx's natural affinity for aquatic predation means that once tamed; it learns to kill ocean-dwellers even more efficiently. Between its speed and its power, Baryonyx makes an ideal choice for anyone interested in frequently moving between water and land travel, and who values speed and agility over raw strength.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Beelzebufo', 'name_tag': 'Toad', 'entity_id': 'Toad_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Toad/Toad_Character_BP_Aberrant.Toad_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Dossier_Beelzebufo.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Beelzebufo', 'id': 7, 'category': 'Reptiles',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f6/Beelzebufo.png',
            'description': "“\nSpecies\nBeelzebufo palucocus\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nLanguorous\nWild\nBeelzebufo palucocus is the largest frog I've ever seen. Almost impossibly large, it can actually fit a fully-grown human adult on its back, though just barely. This is a dangerous prospect, though, as secretions from Beelzebufo's skin and saliva have a narcotic effect on most creatures. Not surprisingly, Beelzebufo is adept at killing insects. Its lengthy tongue allows it to quickly grab prey from afar, killing most insects near instantly and quickly digesting them. It even combines the narcotic chemicals in its mouth with the insects' chitin to create a specialized sticky substance.\nDomesticated\nTamed Beelzebufo make for strange mounts. Strange mounts for strange people. Many tribes don't believe there's any reason to ride them, but some enjoy the ability to take large vertical hops up huge walls and cliffs. Regardless of how it is ridden, Beelzebufo is also employed for its ability to quickly cull insects, and convert them into always-useful cementing paste.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Carbonemys', 'name_tag': 'Turtle', 'entity_id': 'Turtle_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Turtle/Turtle_Character_BP_Aberrant.Turtle_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Carbonemys.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Carbonemys', 'id': 8, 'category': 'Reptiles',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4c/Carbonemys.png',
            'description': "“\nSpecies\nCarbonemys obibimus\nTime\nDanian\nDiet\nHerbivore\nTemperament\nDefensive\nWild\nCarbonemys obibimus is one of the least aggressive creatures on the Island. Were it not for the plethora of predators on the Island, I'm quite certain that it would spend its days basking in the sun, eating, or sleeping. Carbonemys leads a simple, solitary life. Nevertheless, it seems to be one of the most peaceful animals I have yet encountered. With its slow walking speed, the only things that keep it safe are its surprisingly fast swim speed, and its incredibly thick shell, which can absorb tremendous damage.\nDomesticated\nCarbonemys' swift swim rate, fairly high strength, superior shell defenses, and lack of real threat makes it an ideal armored mount for many survivors who shy away from violence. It can carry its rider to the ocean's resources at fairly high speed, and is not particularly dangerous to tame.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Carnotaurus', 'name_tag': 'Carno', 'entity_id': 'Carno_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Carno/Carno_Character_BP_Aberrant.Carno_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Carnotaurus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Carnotaurus', 'id': 9, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Carnotaurus.png',
            'description': "“\nSpecies\nCarnotaurus pressor\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nCarnotaurus pressor is a distinctive creature that falls between a medium and large predator. It lives primarily on flat, clear ground, where it can capitalize on its speed. Additionally, it seems to have no qualms about running away from larger predators instead of fighting. The horns of the Carnotaurus seem to be used more for fighting rivals than actual hunting. This doesn't mean the horns aren't dangerous, though. They can still eviscerate larger prey. Carnotaurus is one of the smaller and more compact of the large predators. If Tyrannosaurus is the “lion” of the Island, Carnotaurus would certainly be the “cheetah.” The real threat of a Carnotaurus is not being able to escape it once it has spotted you.\nDomesticated\nCarnotaurus fills a very specific role. Larger and almost as fast as a Raptor, smaller but much faster than a Rex. Were it not for the creature's extremely long down-time after sprinting, it might be among the most capably balanced mounts.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Cnidaria', 'name_tag': 'Cnidaria', 'entity_id': 'Cnidaria_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Cnidaria/Cnidaria_Character_BP_Aberrant.Cnidaria_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Cnidaria.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Cnidaria', 'id': 10, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Cnidaria.png',
            'description': "“\nSpecies\nCnidaria omnimorph\nTime\nCambrian - Holocene\nDiet\nHerbivore\nTemperament\nPassive, but aggressive at close range\nWild\nCnidaria omnimorph is another example of a creature which should not exist. It has traits that seem derived from many types of jellyfish. It possesses the size and shape of large egg-yolk jellies, the powerful sting of certain box jellies, and the bioluminescence of deep-sea jellies. This all combines to make a dangerous creature that lights up the deepest reaches of the ocean. Cnidaria is not generally aggressive, because it lacks normal perceptive senses. It generally just floats along on the current until something gets close enough to sense, at which point it attacks. While its attacks are not directly powerful, its sting injects an incredibly strong and fast-acting sedative.\nDomesticated\nAs Cnidaria is barely more intelligent than a plant, there's no effective method to tame one. Most tribes kill Cnidaria on sight, then collect its reserve of powerful sedative, to use in technically advanced long-distance tranquilizers.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Coelacanth', 'name_tag': 'Coel', 'entity_id': 'Coel_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Coelacanth/Coel_Character_BP_Aberrant.Coel_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1b/Dossier_Coelacanth.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Coelacanth', 'id': 11, 'category': 'Fish',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ef/Abberant_Coelacanth.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Aberrant Dimetrodon', 'name_tag': 'Dimetro', 'entity_id': 'Dimetro_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Dimetrodon/Dimetro_Character_BP_Aberrant.Dimetro_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8d/Dossier_Dimetrodon.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Dimetrodon', 'id': 12, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Dimetrodon.png',
            'description': "“\nSpecies\nDimetrodon calorector\nTime\nEarly Permian\nDiet\nCarnivore\nTemperament\nReactive\nWild\nDimetrodon calorector is a much calmer predator than most on the Island. Because it lives off smaller prey than humans, it generally ignores anything much larger than a Coelacanth. Dimetrodon is one of the few carnivores on the Island that could be classified as reasonably friendly in the wild. The sail on Dimetrodon's back is an especially fascinating thing. It can be angled to provide shade from the sun and allows Dimetrodon to disperse heat more quickly. The inner workings of the sail can also restrict blood flow in the creature to hold in excessive heat. Together, these two traits allow Dimetrodon to comfortably survive in any climate, though they are most commonly found in the swamplands which are rich in prey.\nDomesticated\nIf Dimetrodon was a bit larger, or didn't have that massive sail, it would make a decent mount. However, its main use to survivors is to utilize the sail's insulating capabilities. Just being near Dimetrodon gives excellent protection from both heat and cold, which has saved my life through more than one ice blizzard in the frozen northlands.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Dimorphodon', 'name_tag': 'Dimorph', 'entity_id': 'Dimorph_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Dimorphodon/Dimorph_Character_BP_Aberrant.Dimorph_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/Dossier_Dimorphodon.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Dimorphodon', 'id': 13, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Dimorphodon.png',
            'description': "“\nSpecies\nDimorphodon equesica\nTime\nEarly Jurassic\nDiet\nCarnivore\nTemperament\nReactive\nWild\nDimorphodon equesica is another of the Island's Jekyll-and-Hyde creatures. It is normally passive, sometimes even friendly. When provoked, it becomes very aggressive, even against larger creatures it has no business fighting...often to its own fatal end. Dimorphodon can make short work of smaller opponents, however, due to its large (but lightweight) skull and teeth. Barely over a meter tall, Dimorphodon should be low on the food chain, but its incredible speed and surprisingly strong bite make it fairly dangerous, especially en masse as they tend to attack in groups. A flock of angry or hungry Dimorphodon can take down prey several times their size, so survivors should take care not to hunt near where a flock is gathered.\nDomesticated\nDimorphodon is one of the creatures on the Island that is easily domesticated for companionship, but its use in combat is also quite clear: It will hunt in large groups to seek out enemy dino riders directly, harassing them to no end, regardless of the might of their mount!\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Diplocaulus', 'name_tag': 'Diplocaulus',
            'entity_id': 'Diplocaulus_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Diplocaulus/Diplocaulus_Character_BP_Aberrant.Diplocaulus_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/af/Dossier_Diplocaulus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Diplocaulus', 'id': 14,
            'category': 'Amphibians',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Diplocaulus.png',
            'description': "“\nSpecies\nDiplocaulus natatorinutrix\nTime\nPermian\nDiet\nPiscivore\nTemperament\nSkittish\nWild\nPresiding almost solely within the Island's swamps, Diplocaulus natatorinutrix is a small amphibian that primarily eats minor fish. It rounds out what I consider to be the middle-bottom of the ecosystem, feeding on the tinier non-insect creatures of the Island while itself being a common snack for the larger carnivores. Because so many creatures prey on it, Diplocaulus has become very skittish and often flees at the first sign of trouble. It uses its amphibious nature to escape into whichever environment its predator isn't native to. Diplocaulus' unique capability to retain vast quantities of oxygen allows it to effectively remain submerged for hours at a time, usually outlasting even other amphibious creatures that might otherwise prey upon it.\nDomesticated\nThere are only a few uses for tamed Diplocaulus. It is primarily kept for the (rather disgusting) practice of employing a Diplocaulus as an oxygen bag. Diplocaulus stores air in the bladders of its head, and divers can suck from these bladders to take deep breaths while submerged, supporting long-term underwater exploration without the use of external gear. Surprisingly, Diplocaulus is also extremely efficient when it comes to hunting Trilobites.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Diplodocus', 'name_tag': 'Diplo', 'entity_id': 'Diplodocus_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Diplodocus/Diplodocus_Character_BP_Aberrant.Diplodocus_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Dossier_Diplodocus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Diplodocus', 'id': 15, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e6/Diplodocus.png',
            'description': '“\nSpecies\nDiplodocus insulaprincep\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nNaive\nWild\nDespite being one of the Island\'s largest creatures, Diplodocus insulaprincep is among the Island\'s smaller sauropods. Instead of size and intelligence, Diplodocus developed faster maximum speed and greater endurance. When fully matured, it generally only reaches about half the size of the rather enormous Brontosaurus. Diplodocus is another creature whose continued survival on the Island confuses me. It\'s a very thick-headed and trusting animal, often to its fatal detriment. It never flees from predators until after they\'ve attacked it repeatedly, preferring instead to make numerous fruitless attempts at friendship. For some strange reason, Diplodocus trusts humans so much that it doesn\'t seem to fight back against them…ever!\nDomesticated\nDue to Diplodocus\' smaller frame, it cannot support the type of "platform" saddle that other large creatures can. To make up for this, many tribes instead use an eleven-seater passenger saddle which enables Diplodocus to safely transport ten additional riders. These passengers often use ranged weapons to protect the creature, or to attack nearby enemies while on the move!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Dire Bear', 'name_tag': 'Direbear', 'entity_id': 'Direbear_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Direbear/Direbear_Character_BP_Aberrant.Direbear_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/20/Dossier_Dire_Bear.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Dire_Bear', 'id': 16, 'category': 'Mammals',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6f/Dire_Bear.png',
            'description': "“\nSpecies\nArctodus dirus\nTime\nMid Pleistocene - Early Holocene\nDiet\nOmnivore\nTemperament\nTerritorial\nWild\nFound primarily among the Island's redwood regions, Arctodus dirus is an imposing creature. Many on the island have started calling it a Direbear, a name which is appropriate, both due to its enormity and its territorial nature. The Direbear ignores most non-hostile creatures while going about its daily routine of scavenging for meat and edible plant life... ...that is, until intruders enter the territory it considers its own, at which point the creature ferociously attacks. Most often, it is smartest to just run from an angry Direbear.\nDomesticated\nOnce tamed, the Direbear is a strong and reliable mount. It can carry vast quantities of goods, and can sprint for extremely long, nearly infinite periods. It is not the fastest creature from a hard stop, but after building up momentum, its sustained overland speed builds to among the best of the island. Of course, being able to feed a direbear both meat and plant life makes keeping one fairly convenient regardless of the environment. Arctodus has a fondness for honey and can harvest it without getting stung or destroying the hive. Perhaps more rewarding while you are riding it, those pesky bees will completely ignore you.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Dodo', 'name_tag': 'Dodo', 'entity_id': 'Dodo_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Dodo/Dodo_Character_BP_Aberrant.Dodo_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Dossier_Dodo.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Dodo', 'id': 17, 'category': 'Birds',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fc/Dodo.png',
            'description': '“\nSpecies\nRaphus replicare\nTime\nLate Holocene\nDiet\nHerbivore\nTemperament\nOblivious\nWild\nRaphus replicare (more commonly known as the Dodo Bird) is quite possibly the dumbest creature I\'ve ever seen in my life. It wanders around the beaches of the Island, pecking berries off bushes, and being eaten by all manner of carnivore. Without the Dodo, the whole Island\'s food chain would disintegrate. This subspecies of the Dodo has developed an unbelievably clever way to sustain itself: they mate constantly. I\'m fairly convinced that they reach full maturity within a week of being born. This is the only trait keeping them populous on the island.\nDomesticated\nWhile it can be done, there is almost no reason to domesticate a Raphus replicare. It cannot carry enough to be a beast of burden, it does not provide much food, and it\'s too stupid to show companionship. It could work as a last-ditch food source, though, so I suppose keeping some around for "lean times" has a certain logic.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Doedicurus', 'name_tag': 'Doed', 'entity_id': 'Doed_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Doedicurus/Doed_Character_BP_Aberrant.Doed_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d1/Dossier_Doedicurus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Doedicurus', 'id': 18, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8b/Doedicurus.png',
            'description': '“\nSpecies\nDoedicurus custosaxum\nTime\nPlestiocene – Holocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nDoedicurus custosaxum is one of the Island\'s non-aggressive herbivores, generally found in the mountains and grasslands. Large and well-armored, it has a supply of fat under its plates to keep it warm and fed in the cold. Doedicurus has adapted well to the dangers of the Island, perhaps even better than the Ankylosaurus. Doedicurus has two very different reactions to predators. Against smaller foes, it generally uses its spiked tail to inflict as much damage as possible. Against larger predators, however, it pulls its tail underneath itself to form a solid armored ball that is nearly impossible for creatures to pierce, from which it can actually "roll" away to relative safety!\nDomesticated\nDoedicurus is a highly prized work animal on the island. Its spiked tail is ideal for quickly shattering the large rocks, so Doedicurus is a very efficient quarry worker. In addition, its affinity for rocks has allowed it to carry stone at a reduced weight. In case their quarry gets raided, Doedicurus-riders have a very difficult-to-kill mount!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Dung Beetle', 'name_tag': 'Beetle', 'entity_id': 'DungBeetle_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/DungBeetle/DungBeetle_Character_BP_Aberrant.DungBeetle_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Dossier_Dung_Beetle.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Dung_Beetle', 'id': 19, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b4/Dung_Beetle.png',
            'description': "“\nSpecies\nScarabidae gigas\nTime\nHolocene\nDiet\nCoprophagic\nTemperament\nPassive\nWild\nWhat magic created the Scarabidae gigas, I cannot say. What I can say is that this creature is a perfect symbiont for advanced human tribes. Coprophagic, it eats mostly useless waste (feces). It metabolizes this waste into a more refined waste product, along with an oily byproduct. The oily byproduct is chemically the same as the oil found in the oceans around the island. Somehow, Scarabidae converts feces into oil. If that wasn't reason enough to worship the Scarabidae, the refined waste product is almost identical to fertilizer from a compost bin.\nDomesticated\nScarabidae makes me think humans have been on the island for a long time. Why else would a creature evolve to be such a perfect pet? Most tribes jealously protect their Scarabidae, whom are handily tamed with the skilled use of some well-handled feces. These wondrous little organic biofactories are truly a sustainable, green, eco-friendly source of resources for living off the land. Oil becomes gas, which is generator fuel. Fertilizer means crops, which is human fuel. The Scarabidae can power all aspects of island life!\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Electrophorus', 'name_tag': 'Eel', 'entity_id': 'Eel_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Eel/Eel_Character_BP_Aberrant.Eel_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Dossier_Electrophorus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Electrophorus', 'id': 20, 'category': 'Fish',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a0/Electrophorus.png',
            'description': '“\nSpecies\nElectrophorus beluadomito\nTime\nHolocene\nDiet\nCarnivore\nTemperament\nReactive\nWild\nOccupying a space in the low-to-middle end of the food chain, Electrophorus beluadomito is a carnivorous swimmer that feeds mostly off of shellfish and small fish. Despite its common name, it is actually a very long Knifefish, and not an Eel. It does not provide much meat, so many predators simply leave it be. Unlike most predators, it does not use brute strength to bring down its prey, but instead releases an electrical charge around itself to knock its prey unconscious. Alone, this can take out a small creature. When attacking together, Electrophorus can even bring down the larger ocean lifeforms, and then feed as a group.\nDomesticated\nBy far, the most common use of Electrophorus is to subdue large ocean creatures. Knocking out a Plesiosaur or other giant deep-sea leviathan can be incredibly difficult... ...thus many tribes employ small schools of Electrophorus to shock them into submission!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Equus', 'name_tag': 'Equus', 'entity_id': 'Equus_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Equus/Equus_Character_BP_Aberrant.Equus_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Dossier_Equus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Equus', 'id': 21, 'category': 'Mammals',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Equus.png',
            'description': "“\nSpecies\nEquus magnus\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nLoyal\nWild\nEquus magnus appears to be an ancestor of the modern horse. Based on its stripes, it may be the African variant of Equus giganteus, which appeared in North America during the Ice Age, but that is pure conjecture. Its behavior in the wild is similar to that of other wild members of the Equus genus - it sustains itself by grazing, while keeping safe from predators by living in herds and outrunning its attackers via superior speed and stamina.\nDomesticated\nHorse and man have long been partners in survival, and this remains true on the Island. In Equus, survivors will find a trusty steed or pack animal that can carry them swiftly across land. Taming an Equus has proven interesting, requiring carefully approaching the creature in the wild, mounting it, and then carefully soothing over time by feeding it vegetables. In fact, Equus' reliability has lead some survivors to construct special saddles for them. I even encountered a man who added extra saddle-pouches that doubled as mobile crafting stations for chemical supplies, foodstuffs, and other items. Although not as robust as what you might find within a village, this utility helped him live a nomadic, solitary lifestyle. Some survivors employ Equus to herd and wrangle other creatures with a specialized lasso. This tool is sometimes effective for self-defense as well, as Equus is limited in battle on its own...at least compared to aggressive prehistoric carnivores.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Gigantopithecus', 'name_tag': 'Bigfoot', 'entity_id': 'Bigfoot_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Bigfoot/Bigfoot_Character_BP_Aberrant.Bigfoot_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Dossier_Gigantopithecus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Gigantopithecus', 'id': 22, 'category': 'Mammals',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Gigantopithecus.png',
            'description': "“\nSpecies\nGigantopithecus fibrarator\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nTerritorial\nWild\nGigantopithecus fibrarator is a strange creature. It is usually quite passive, but it has a very short temper when it comes to its own personal space. Once another creature gets close, this gentle giant quickly becomes a rampaging beast. Best to give them a wide berth. I have occasionally seen Gigantopithecus jumping to grab vines that it can traverse and swing on, but otherwise, it seems most happy to lay about, picking berries from plants lazily.\nDomesticated\nIn addition to being at home picking berries, a tamed Gigantopithecus can be taught to harvest the fibers found on many Island plants as well. It appears to be entirely content to pick at plants all day, eat the berries, and carrying fiber resources for its tribe. Playful once tamed, Gigantopithecus seems to enjoy throwing the creatures or riders it's carrying into the air. It probably feels that this activity is a game, but clever brigands can use this ‘game' to vault over walls and small cliffs.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Iguanodon', 'name_tag': 'Iguanodon', 'entity_id': 'Iguanodon_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Iguanodon/Iguanodon_Character_BP_Aberrant.Iguanodon_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/54/Dossier_Iguanodon.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Iguanodon', 'id': 23, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/94/Iguanodon.png',
            'description': "“\nSpecies\nIguanodon vicissitudinis\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nReactive\nWild\nOf the many creatures I've yet encountered on the Island, the Iguanodon vicissitudinis has the distinctly versatile capability of switching its primary method of locomotion according to its momentary needs. Primarily a rather lethargic bipedal herbivore native to the Island's many grasslands and forests, in situations where increased speed or maneuverability is called for, it will quickly shift its posture into quadrupedal stance and behave like a very different creature! While bipedal, it can employ rapid, stabbing attacks with its distinctive thumb spikes. In quadrupedal stance, conversely, it seems to have an endless supply of stamina, even while sprinting!\nDomesticated\nInterestingly, the Iguanodon's thumb spikes also provide it with the capability to pick seeds out of fruits, allowing a farmer to easily convert stacks of fruits into stacks of seed for planting. Combined with its highly effective fruit harvesting and substantial carry weight, the Iguanodon's excellent mobility in bipedal stance makes it an ideal field-hand that can also pull off a quick get-away or an agile defense when needed.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Lystrosaurus', 'name_tag': 'Lystro', 'entity_id': 'Lystro_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Lystrosaurus/Lystro_Character_BP_Aberrant.Lystro_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d1/Dossier_Lystrosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Lystrosaurus', 'id': 24, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/93/Lystrosaurus.png',
            'description': "“\nSpecies\nLystrosaurus amicifidelis\nTime\nLate Permian - Early Triassic\nDiet\nHerbivore\nTemperament\nLoyal\nWild\nLystrosaurus amicifidelis is a small herbivore, common to much of the Island. Only about two feet long, it is not high on the food chain, and eats small plant life. The Island's poisonous insects seem to have little effect on Lystrosaurus. Despite being among the Island's tinier herbivores, Lystrosaurus is an incredibly resilient survivor. It recovers its torpor and health much faster than most creatures, which makes rendering a Lystrosaurus unconscious a rather difficult affair.\nDomesticated\nNot surprisingly, Lystrosaurus is an extremely loyal pet once tamed. It's a very fast learner, so it gains experience much more quickly than most other creatures. Additionally, its presence nearby appears to inspire allies, making them learn more rapidly as well. Thusly, Lystrosaurus is an excellent addition to any tribe's hunting party.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Manta', 'name_tag': 'Manta', 'entity_id': 'Manta_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Manta/Manta_Character_BP_Aberrant.Manta_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Manta.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Manta', 'id': 25, 'category': 'Fish',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Manta.png',
            'description': "“\nSpecies\nManta mobula\nTime\nEarly Oligocene - Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nHere is another example of a creature that seems to have evolved beyond its historical traits. Everything points to this being a saltwater ray, but Manta mobula has developed the ability to swim into the island's rivers and shallows, as well as through the open ocean. Perhaps there were originally two types of ray on the island before, but years of interbreeding combined their lineage. Normally docile, Manta mobula is a carnivore only in that it naturally consumes plankton. Fortunately, Manta mobula is usually not aggressive, unless encroached. Its tail is incredibly sharp, and can pierce through thick hide and armor with ease.\nDomesticated\nWhile not the fastest swimmer around the island, Manta mobula is among the deadliest of small ocean mounts. Tribes who value striking power over speed often keep large schools of Manta to ride. Its capability to briefly leap out of water provides it a showy tactic for avoiding combat as well. A quick jab through the heart of an unsuspecting survivor can easily take them by surprise! Thusly, many tribes use it as an escort for their slower cargo-carrying swimmers.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Megalania', 'name_tag': 'Megalania', 'entity_id': 'Megalania_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Megalania/Megalania_Character_BP_Aberrant.Megalania_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c6/Dossier_Megalania.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Megalania', 'id': 26, 'category': 'Reptiles',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/58/Megalania.png',
            'description': "“\nSpecies\nMegalania muruspede\nTime\nLate Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMegalania muruspede is among the largest creatures found throughout the Island's complicated cave networks. Reaching up to three meters long, it can traverse vertically up cave walls with little difficulty thanks to its powerful claws. Fortunately, Megalania's size means it is unlikely to sneak up on anyone. Unfortunately for spelunkers, it is an aggressive and dangerous creature nonetheless. Like other Varanidae, Megalania is a venomous creature. Its poison is slow-acting, but will drain the victim's effective strength and health until death unless cured by a rare antidote. That said, the Megalania's prey are usually ripped apart well before they succumb to the poison's long-term effects.\nDomesticated\nThe rare ability of Megalania to effortlessly climb sheer environmental walls makes it a highly sought-after mount. While it is by no means the fastest, strongest, or toughest mount, the manner in which it can effortlessly scale mountains, clamber up barricades, hide in trees or upside-down, ensures it will always have place in any tribe's stables!\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Megalosaurus', 'name_tag': 'Megalosaurus',
            'entity_id': 'Megalosaurus_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Megalosaurus/Megalosaurus_Character_BP_Aberrant.Megalosaurus_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/19/Dossier_Megalosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Megalosaurus', 'id': 27,
            'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7e/Megalosaurus.png',
            'description': "“\nSpecies\nMegalosaurus noctedominus\nTime\nMid Jurassic\nDiet\nCarnivore\nTemperament\nNocturnally Aggressive\nWild\nMuch like the Island's other large theropods, Megalosaurus noctedominus is an aggressive cave carnivore that should not be taken lightly. Unlike most of the other theropods, it is a primarily nocturnal creature. As dawn approaches, Megalosaurus begins looking for a secluded place to spend the day sleeping in relative safety. Conversely, if disturbed during the day, Megalosaurus is significantly more sluggish. Either way, however, its primary combat tactic is to bite onto its target, then lock its jaw shut in an iron grip. Only larger creatures can hope to break free once Megalosaurus locks its jaw. The creature then proceeds to gnaw on its prey until death. It's a terrifying, grisly spectacle to watch, and a formidable tactic for a tribe to employ against more nimble opponents.\nDomesticated\nWhile Megalosaurus is not the most powerful theropod, it is still highly sought after by night-raiders. Due to its nocturnal nature, Megalosaurus becomes much more formidable at night, dodging attacks, conserving stamina, and attacking more accurately, to name a few of its enhanced talents.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Meganeura', 'name_tag': 'Dragonfly', 'entity_id': 'Dragonfly_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Dragonfly/Dragonfly_Character_BP_Aberrant.Dragonfly_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c5/Dossier_Meganeura.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Meganeura', 'id': 28, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/81/Meganeura.png',
            'description': "“\nSpecies\nMeganeura quatpenna\nTime\nLate Carboniferous\nDiet\nCarnivore\nTemperament\nReactive\nWild\nMeganeura quatpenna is an especially large species of dragonfly. Actually, it is a type of griffinfly, an extinct species of invertebrate that looked similar to dragonflies. Like most griffinflies, Meganeura is carnivorous, but it is typically not aggressive towards humans unless provoked or challenged for food. It lives primarily in the wetter, heavily wooded areas, such as the jungles. Meganeura is a natural predator of most of the smaller insects on the island. Though not often aggressive, Meganeura will not turn down a free meal. They quickly appear in large numbers to scavenge off the victims of Pulmonoscorpius, rendered unconscious and unable to defend themselves. Of course the insects do have to avoid the Pulmonoscorpius itself. I have noticed it is unwise to disturb a flock of feeding Meganeura.\nDomesticated\nThe size of the insects on the island confounds me. The way these creatures diffuse oxygen should limit their size but Meganeura (and other bugs) seem to be able to advance beyond this restraint. If there is more oxygen in the air this could explain Meganeura's growth.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Moschops', 'name_tag': 'Moschops', 'entity_id': 'Moschops_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Moschops/Moschops_Character_BP_Aberrant.Moschops_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dc/Dossier_Moschops.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Moschops', 'id': 29, 'category': 'Synapsids',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e6/Moschops.png',
            'description': "“\nSpecies\nMoschops cibumutante\nTime\nMid Permian\nDiet\nOmnivore\nTemperament\nCowardly\nWild\nMoschops Cibumutante in the wild is a lazy, cowardly creature that typically lives in the Island's forests, primarily making its home among the great redwoods of the western regions. It survives by being extremely flexible in its eating habits and completely averse to fighting. It never starves, since it can eat just about anything. It runs at the slightest provocation but is still often preyed upon.\nDomesticated\nWhat makes Moschops particularly interesting is what it can be trained to do with its eating habits. With a versatile palate and tough teeth, Moschops can be tamed for a unique ability: over time it can be accurately taught exactly which things to gnaw, increasing the likelihood of harvesting the specific resource its master desires. For example, teach it to prioritize chewing Prime Meat, and Prime Meat will be easier to harvest from the flesh it consumes. Likewise for rare plants materials, and so forth! Just don't expect Moschops to protect you, though! Even after taming, it will quickly flee when enemies are nearby. Regardless of being fed well, increasing its strength, or how much affection, you shower on it, Moschops retains its inherent cowardly nature! Its lack of combat might deter the use of this companion but the ability to ride Moschops while making use of its diverse harvesting is a rare treat.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Otter', 'name_tag': 'Otter', 'entity_id': 'Otter_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Otter/Otter_Character_BP_Aberrant.Otter_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Dossier_Otter.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Otter', 'id': 30, 'category': 'Mammals',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9f/Otter.png',
            'description': '“\nSpecies\nLutra peloso\nTime\nEarly Miocene\nDiet\nOmnivore\nTemperament\nFriendly\nWild\nFound along the Island’s many inland waterways, Lutra Peloso have become exceptionally adept at hunting and foraging. This species of Otter has to be particularly cunning because of its diminutive size, and fierce competition for its preferred food source: fish. It is not a creature that excels at combat, and would not naturally pose an intimidating threat to any predators. Finding packs of river Otters is simple enough: They are distinguished by their elongated bodies, bushy tails, and webbed feet. Their trusting and inquisitive nature ensures they are often hunted for their lustrous fur, but many prefer to tame them to become trusted companions.\nDomesticated\nThere are few creatures which provide the companionship that Lutra Peloso does. Rather than traveling beside you, it would prefer to comfortably rest on your back, providing insulation. Once domesticated, it can be told to harvest fish on demand, with a specific goal in mind from the fish that it consumes, the otter has a knack for foraging silica pearls, and can even yield a slight chance at finding black pearls within!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Ovis', 'name_tag': 'Sheep', 'entity_id': 'Sheep_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Sheep/Sheep_Character_BP_Aberrant.Sheep_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b7/Dossier_Ovis.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Ovis', 'id': 31, 'category': 'Mammals',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Ovis.png',
            'description': '“\nSpecies\nOvis arcam\nTime\nCenozoic\nDiet\nHerbivore\nTemperament\nStupid\nWild\nSince arriving on the Island, I have encountered dozens of fascinating creatures whose behavior has never been studied or documented...and also sheep. Granted, Ovis arcam is quite different from the modern domesticated sheep - and even from wild sheep species such as Ovis orientalis. The unique markings on its face give it a striking appearance, and the males\' horns possess a unique shape that is unlike any other species in the Ovis genus. As one might expect, Ovis stands little chance against this Island\'s many predators. Like the Dodo, its continued survival in the face of these challenges is a mystery.\nDomesticated\nSome survivors have found herds of Ovis to be useful in farm life. Their wool can be repeatedly safely shorn with the proper tools, and cooked lamb chops are a popular dish among some tribes, as is their hyper-nutritious mutton. Every now and then, a survivor with a sense of humor will attempt to utilize Ovis as a mount, although the joke becomes significantly less funny once their slow Ovis is run-down by a pack of Raptors. One tribe has grown particularly attached to Ovis, perhaps uncomfortably so. I don\'t know the tribe\'s actual name, but I refer to them as "Sheep Lovers."\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Paraceratherium', 'name_tag': 'Paracer', 'entity_id': 'Paracer_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Paraceratherium/Paracer_Character_BP_Aberrant.Paracer_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Paraceratherium.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Paraceratherium', 'id': 32, 'category': 'Mammals',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e1/Paraceratherium.png',
            'description': '“\nSpecies\nParaceratherium gigamicus\nTime\nOligocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nParaceratherium gigamicus is a massive, long-necked herbivore that inhabits some of the Island\'s grasslands. It resembles a gigantic horse/rhinoceros hybrid, but is over twice the size of either. Paraceratherium is a very peaceful and friendly creature. Barring some surprises yet in store for me, I can safely say that Paraceratherium is among the largest mammals on the Island. While its size means that Paraceratherium can provide an incredible amount of food, it also makes it dangerous when hunted.\nDomesticated\nA beast of burden second to the Brontosaurus, Paraceratherium is an excellent worker, and is sufficient in size to support a "platform" saddle upon which structures can be built. It is a naturally friendly animal, and is not afraid of humans. However, despite its normally calm demeanor, when it or its owner is provoked by aggression, the Paraceratherium can quickly become a real threat to the attacker and will use its girth to its advantage in combat.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Parasaur', 'name_tag': 'Para', 'entity_id': 'Para_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Para/Para_Character_BP_Aberrant.Para_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Dossier_Parasaur.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Parasaur', 'id': 33, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Parasaur.png',
            'description': "“\nSpecies\nParasaurolophus amphibio\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nParasaurolophus amphibio has one of the more interesting adaptations of any creature I've seen on the Island. Like all Parasaur, it has a signature crest on its head. Very docile at first, I've been able to approach the creature without disturbing it. If startled, however, the creature can vocalize a distress call to the surrounding area that warns of danger. Parasaurolophus appears to be low on the food chain and is hunted by everything, creatures and humans alike, which explains its skittish nature. It is a good source of meat and hide, if you can manage to keep up with it long enough to kill it.\nDomesticated\nDespite being what most tribes consider a relatively useless creature to tame, I once met an interesting woman who had tamed an entire herd of them. She informed me that many overlooked the creature's potential. She even graciously gifted me a fancy saddle to put on my own Parasaurolophus one day. As a relatively simple creature to domesticate, Parasaurolophus is commonly one of the first mounts a tribe will be able to acquire. Its ability to run relatively fast for lengthy intervals makes it a solid mode of medium-range transportation, though it has almost no ability to defend itself or its rider in a traditional sense. Smaller creatures, however, appear to be frightened by the horn of Parasaurolophus although it doesn't do much damage. It also has decent weight-bearing capabilities, which could prove useful for nomadic tribes as they work to establish a presence on the Island.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Piranha', 'name_tag': 'Piranha', 'entity_id': 'Piranha_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Piranha/Piranha_Character_BP_Aberrant.Piranha_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b2/Dossier_Piranha.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Piranha', 'id': 34, 'category': 'Fish',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/43/Piranha.png',
            'description': "“\nSpecies\nMegapiranha magnadmorsus\nTime\nLate Miocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMegapiranha magnadmorsus is carnivorous fish found fairly commonly in the rivers and ponds of the island. Its bite is incredibly powerful; I've even seen them break through the armored turtles of the island. Megapiranha has one of the strongest bites, pound-for-pound, of any creature on the island. When encountering a Megapiranha, be on the lookout for the rest of the school. No one Megapiranha is an overwhelming threat, but their tendency to swarm prey can make short work of much larger and stronger creatures. Any given Megapiranha is easy to kill, but killing the entire school can be a daunting task.\nDomesticated\nThe Megapiranha is highly territorial and does not respond favorably to visitors. Many have tried to pacify the hostile Megapiranha by herding them into a group with various lures. Unfortunately, none of this proved to be successful in attempting to domesticate the creature.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Pulmonoscorpius', 'name_tag': 'Scorpion',
            'entity_id': 'Scorpion_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Scorpion/Scorpion_Character_BP_Aberrant.Scorpion_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Pulmonoscorpius.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Pulmonoscorpius', 'id': 35,
            'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ab/Scorpion.png',
            'description': "“\nSpecies\nPulmonoscorpius gigantus\nTime\nLate Silurian\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nI'm not sure why, but the giant scorpions I've seen on the Island are far more disturbing than most of the dinosaurs. Rather than simply kill its prey, Pulmonoscorpius gigantus injects its victims with a tranquilizing poison, then eats its unconscious prey alive. This subspecies has a large pair of pincers that seem connected to the same toxin sacs as the tail. I've never seen another scorpion that has this adaptation, but I've never seen another scorpion that's larger than I am, either.\nDomesticated\nTrying to tame a monster like Pulmonoscorpius gigantus sounds like a crazy idea, but I suppose the ability to knock out a foe could come in handy. It could certainly make incapacitating some of the Island's other creatures much easier.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Purlovia', 'name_tag': 'Purlovia', 'entity_id': 'Purlovia_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Purlovia/Purlovia_Character_BP_Aberrant.Purlovia_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/df/Dossier_Purlovia.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Purlovia', 'id': 36, 'category': 'Synapsids',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c2/Purlovia.png',
            'description': '“\nSpecies\nPurlovia maxima\nTime\nLate Permian\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nPurlovia Maxima perfectly embodies the element of surprise. Though Nanictidopids such as Purlovia were once thought to be herbivores, I discovered that this creature is, in fact, a patient hunter of the most intelligent sort. After burrowing beneath the jungle floor, Purlovia enters a state of hibernation and can go extended periods without any food. When some unfortunate creature eventually wanders by, Purlovia bursts forth from the ground, tearing into its prey with its large canines before the victim can react!\nDomesticated\nThough Purlovia is ill-suited to the life of a mount, its usefulness in staging an ambush or as a village guardian cannot be understated. With a tamed pack of Purlovia, one could assemble a literal organic minefield of deadly claws and teeth! However, any ambushes using Purlovia must be planned well in advance, as it will refuse to hibernate if it senses any threat nearby.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Raptor', 'name_tag': 'Raptor', 'entity_id': 'Raptor_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Raptor/Raptor_Character_BP_Aberrant.Raptor_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Raptor', 'id': 37, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/08/Raptor.png',
            'description': '“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Sabertooth Salmon', 'name_tag': 'Salmon', 'entity_id': 'Salmon_Character_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Salmon/Salmon_Character_Aberrant.Salmon_Character_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0c/Dossier_Sabertooth_Salmon.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Sabertooth_Salmon', 'id': 38, 'category': 'Fish',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e0/Salmon.png',
            'description': '“\nSpecies\nOncorhynchus grexlamia\nTime\nLate Miocene - Mid Pleistocene\nDiet\nCarnivore\nTemperament\nEvasive, Aggressive when attacked\nWild\nFairly unremarkable by the Island\'s standards, Oncorhynchus grexlamia is a generally passive fish. Its main form of protection is swimming in a large school. Oncorhynchus does not like conflict, and generally swims away from anything larger than itself at very high speeds. Once provoked, however, Oncorhynchus becomes quite aggressive, along with its nearby brethren. It locks onto its prey with its long "saberteeth" and begins draining that creature\'s blood. This loss of blood is not too dangerous alone, but when a school of Oncorhynchus attack at once, their target quickly loses speed and stamina from blood loss, drowning if it cannot breath underwater.\nDomesticated\nLike many of the smaller fish found on or around the Island, Oncorhynchus cannot be tamed, but it is often herded and harvested for its resources. In particular, certain cuts of Oncorhynchus meat are considered to have superb quality, and are often referred to as "Prime Fish" used for specific high-end concoctions and taming the Island\'s many piscivorous creatures.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Aberrant Sarco', 'name_tag': 'Sarco', 'entity_id': 'Sarco_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Sarco/Sarco_Character_BP_Aberrant.Sarco_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/70/Dossier_Sarco.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Sarco', 'id': 39, 'category': 'Reptiles',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Sarco.png',
            'description': "“\nSpecies\nSarcosuchus excubitor\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nPatient\nWild\nAmong the Island's swamp-based threats, Sarcosuchus excubitor is a lot like what you might expect from a giant crocodile: a patient killing machine. It spends much of its days lazily waiting in the water for prey to walk near. That said, it is not opposed to scurrying onto land and pressing the issue when hungry. A good tactic for escaping many predators is to jump into the water, as most are slow swimmers. This is a bad tactic for escaping a Sarcosuchus, obviously, as they are actually faster in the water than they are on land. Whether in land or water, it utilizes a well-rounded arsenal of attacks to display its prowess as a hunter. If it desires to grab a predator and spin into a death roll, quickly lunge forward for a surprise attack, target a foe directly behind it, its able to do so with extreme ease.\nDomesticated\nSarcosuchus is a ferocious creature that even causes the fearless piranha to flee at the sight of it. Despite being river-dwelling creatures, Sarcosuchus seem quite at ease in the oceans. More than a few fishing communities use them as mounts simply to help fight off megaladons, or to gain better access to the resources found within the reefs.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Spino', 'name_tag': 'Spino', 'entity_id': 'Spino_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Spino/Spino_Character_BP_Aberrant.Spino_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Spino.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Spino', 'id': 40, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/03/Spino.png',
            'description': "“\nSpecies\nSpinosaurus aquareliga\nTime\nEarly-Late Cretaceous\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nAmong the few carnivores on the Island that can match Tyrannosaurs in size, Spinosaurus aquareliga does not match its ferocity. Spinosaurus' four legs and large sail make it fairly swift on land and incredibly fast in the water. Its marvel is, arguably, the ability to change stances by going from quadruped to biped. The creature is visually distinguished by its spectacular sail. In my travels I have seen many different and brightly coloured sails, as every Spinosaurus appears to have a slightly different palette. The one comforting fact about Spinosaurus is that it seems more at home near water than away from it. Although the creature is more powerful, faster, agile, and insatiable while in water, it tends to become less hostile as it gets farther from it. On one occasion, I only escaped a Spinosaurus by getting far enough from its lake home to make it simply lose interest.\nDomesticated\nSpinosaurus is an incredibly well-rounded apex carnivore. Faster than a Tyrannosaurus in water and able to travel on land unlike a Megalodon, its all-terrain versatility may be unrivaled. Although its movement speed is slower in a biped stance, it gains considerable attacking strength and mobility in this form. For hunters who wish to have a well-rounded mount, Spinosaurus may be the ideal choice -- if they can acquire one.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Stegosaurus', 'name_tag': 'Stego', 'entity_id': 'Stego_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Stego/Stego_Character_BP_Aberrant.Stego_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Dossier_Stegosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Stegosaurus', 'id': 41, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Stegosaurus.png',
            'description': "“\nSpecies\nStegosaurus regium\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nDocile\nWild\nStegosaurus regium has approximately 16 paired rows of plates along its back, flanked by another, smaller pair of 6 plates. This is contrary to the alternating rows on Stegosaurus fossils I've seen in museums. Not surprisingly, Stegosaurus uses the spines on its tail to defend itself. While not aggressive, Stegosaurus will come to the aid of another nearby Stegosaurus. This implies it to be a herd animal.\nDomesticated\nStegosaurus is commonly used as a safe way to transport large quantities of goods. And once you saddle one up, not even an Argentavis could knock you off that perch. A stegosaurus can be trained to flex its back plates for different purposes: hardened to shield it from attack, in a heavier alignment that deals crippling blows, or oriented more sharply to pierce armor. These various plate configurations also come in handy for stripping wood from trees, gathering thatch, or foraging for wild berries, respectively. Stegosaurus can knock back or impale with a whip of its spiky tail, keeping predators at bay or pinning them in place. Its spiked appendage also helps for gathering berries—go figure.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Titanoboa', 'name_tag': 'Titanboa', 'entity_id': 'BoaFrill_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/BoaFrill/BoaFrill_Character_BP_Aberrant.BoaFrill_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/47/Dossier_Titanoboa.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Titanoboa', 'id': 42, 'category': 'Reptiles',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b6/Titanoboa.png',
            'description': "“\nSpecies\nTitanoboa exornantur\nTime\nPaleocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nTypically found within the Island's caves, Titanoboa exornantur is an aggressive creature that prefers dark, rocky areas. This extremely large snake, while being a member of the Titanoboa family, does not constrict its prey as most boas do. I believe this adaptation comes from coexisting with giant insects. However, the Titanoboa's venomous bite is so potent that it is known to paralyze far larger creatures. Titanoboa has developed a strange coexistence with other creatures of the Island's caves. Being immune to knockout poisons, and being unable to pierce the thick chitin of the insects, the species have learned to coexist. They often hunt large prey together.\nDomesticated\nAs they appear immune to knockout poisons, Titanoboa exornantur is basically impossible to render unconscious. Because this crucial step can't be done, I'm convinced that Titanoboa are not tameable.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Triceratops', 'name_tag': 'Trike', 'entity_id': 'Trike_Character_BP_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Trike/Trike_Character_BP_Aberrant.Trike_Character_BP_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Triceratops.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Triceratops', 'id': 43, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
            'description': "“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Aberrant Trilobite', 'name_tag': 'Trilobite', 'entity_id': 'Trilobite_Character_Aberrant_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Trilobite/Trilobite_Character_Aberrant.Trilobite_Character_Aberrant\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Dossier_Trilobite.png',
            'url': 'https://ark.fandom.com/wiki/Aberrant_Trilobite', 'id': 44, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2b/Trilobite.png',
            'description': "“\nSpecies\nTrilobite conchadurus\nTime\nEarly Cambrian-Late Permian\nDiet\nCarnivore\nTemperament\nDefensive\nWild\nLike most Trilobites, Trilobite conchadurus is an opportunistic carnivore that feeds on anything smaller than itself which it can get a hold of. A sluggish creature, the Trilobite's best defense is its incredibly hard shell. This seems to be a common adaptation for the slower creatures of the Island. Trilobite is not a very good source of food. The creature seems to be made mostly out of internal organs and its protective carapace. This is good for the trilobite, as both river and ocean predators are less likely to prey on it if there are better options around.\nDomesticated\nThe Trilobite does not seem to have enough intelligence to be tamed. This doesn't mean it has no use among resourceful survivors, however. Found along beaches and in the ocean's shallows, Trilobites are easily one of the best sources of oil, pearl and chitin on the Island, presuming one doesn't wish to venture into the dangerous caves.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Alpha Basilisk', 'name_tag': 'Elite Basilisk', 'entity_id': 'MegaBasilisk_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Basilisk/MegaBasilisk_Character_BP.MegaBasilisk_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Dossier_Basilisk.png',
            'url': 'https://ark.fandom.com/wiki/Alpha_Basilisk', 'id': 45, 'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Basilisk.png',
            'description': "“\nSpecies\nSerpens regulus\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMore than twice the size of wild Titanoboa exonantur, Serpens regulus is the largest and most lethal snake I've encountered. With a skull that's more draconic than serpentine, it possesses a powerful bite, made even deadlier by the potent venom dripping from its fangs. The unique shape of its skull allows Serpens to hunt in a way that other snakes cannot: by burrowing. Once underground, it simply waits for its victims to approach. Fortunately its forked tail is usually still visible, poking just aboveground.\nDomesticated\nMiraculously, survivors have not only managed to tame Serpens regulus, but ride it. Some can even stay seated while it lies in wait belowground, though I doubt it's a pleasant experience. While a wild Serpens can only be forced out of hiding by fire or explosives, once domesticated, it is easily trained to burrow or surface on command.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Alpha Karkinos', 'name_tag': 'Elite CaveCrab', 'entity_id': 'MegaCrab_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Crab/MegaCrab_Character_BP.MegaCrab_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/25/Dossier_Karkinos.png',
            'url': 'https://ark.fandom.com/wiki/Alpha_Karkinos', 'id': 46, 'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/40/Karkinos.png',
            'description': '“\nSpecies\nKarkinos versatus\nTime\nUnknown\nDiet\nOmnivore\nTemperament\nAggressive\nWild\nKarkinos Versatus is the giant cousin of modern crab species, with long, spindly limbs that remind me of the Japanese Spider Crab and a hard, stony shell. It is much more agile than its smaller brethren, but even more noticeable are its pincer claws. In an extraordinary display of dexterity, Karkinos is able to wield each claw independently and precisely. This allows it to trap multiple targets in its vice like grip, or hold an enemy in one claw while it smashes a second foe with the other.\nDomesticated\nMany survivors have found Karkinos to be an excellent war steed, as it can snatch enemy riders from their mounts, or grab and throw smaller creatures. However, its ability to leap to great heights and its swiftness relative to its size also make it useful in caravans.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Alpha Surface Reaper King', 'name_tag': 'Elite Xenomorph',
            'entity_id': 'MegaXenomorph_Character_BP_Male_Surface_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Nameless/MegaXenomorph_Character_BP_Male_Surface.MegaXenomorph_Character_BP_Male_Surface\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/Alpha_Surface_Reaper_King', 'id': 47,
            'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
            'description': "“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Basilisk', 'name_tag': 'Basilisk', 'entity_id': 'Basilisk_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Basilisk/Basilisk_Character_BP.Basilisk_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Dossier_Basilisk.png',
            'url': 'https://ark.fandom.com/wiki/Basilisk', 'id': 48, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Basilisk.png',
            'description': "“\nSpecies\nSerpens regulus\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nMore than twice the size of wild Titanoboa exonantur, Serpens regulus is the largest and most lethal snake I've encountered. With a skull that's more draconic than serpentine, it possesses a powerful bite, made even deadlier by the potent venom dripping from its fangs. The unique shape of its skull allows Serpens to hunt in a way that other snakes cannot: by burrowing. Once underground, it simply waits for its victims to approach. Fortunately its forked tail is usually still visible, poking just aboveground.\nDomesticated\nMiraculously, survivors have not only managed to tame Serpens regulus, but ride it. Some can even stay seated while it lies in wait belowground, though I doubt it's a pleasant experience. While a wild Serpens can only be forced out of hiding by fire or explosives, once domesticated, it is easily trained to burrow or surface on command.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Basilisk Ghost', 'name_tag': 'Basilisk', 'entity_id': 'Ghost_Basilisk_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Basilisk/Ghost_Basilisk_Character_BP.Ghost_Basilisk_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7f/Basilisk_Ghost_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Basilisk_Ghost', 'id': 49, 'category': 'Event Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1c/Basilisk_Ghost.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Bulbdog', 'name_tag': 'Pug', 'entity_id': 'LanternPug_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/LanternPug/LanternPug_Character_BP.LanternPug_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Dossier_Bulbdog.png',
            'url': 'https://ark.fandom.com/wiki/Bulbdog', 'id': 50, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1c/Bulbdog.png',
            'description': "“\nSpecies\nMicroluminis globulus\nTime\nUnknown\nDiet\nHerbivore\nTemperament\nPassive\nWild\nMicroluminis globulus is best described as a slobbering, roly-poly ball of affection. Just like its kin, it is completely harmless, despite its pronounced fangs. So if a survivor sees one running towards them, they should prepare to be licked, not bitten. Unfortunately, being so ugly that you're cute is not an effective means of self-defense, which lands it near the bottom of the food chain. Its Charge Light may intimidate some predators, but it attracts just as many.\nDomesticated\nWhile Microluminis globulus has skin reminiscent of lizards or amphibians, its behavior is incredibly similar to a common canine. This has made it a particularly popular choice as a companion and source of Charge Light, but remember - whatever shoulder you rest it on will be covered in drool within minutes.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Bulbdog Ghost', 'name_tag': 'Pug', 'entity_id': 'Ghost_LanternPug_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/LanternPug/Ghost_LanternPug_Character_BP.Ghost_LanternPug_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Bulbdog_Ghost_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Bulbdog_Ghost', 'id': 51, 'category': 'Event Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Bulbdog_Ghost.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Featherlight', 'name_tag': 'Lantern Bird', 'entity_id': 'LanternBird_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/LanternBird/LanternBird_Character_BP.LanternBird_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Dossier_Featherlight.png',
            'url': 'https://ark.fandom.com/wiki/Featherlight', 'id': 52, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c9/Featherlight.png',
            'description': "“\nSpecies\nMicroluminis alectryon\nTime\nUnknown\nDiet\nHerbivore\nTemperament\nPassive\nWild\nA floating beacon of light often found in the deepest pits of these caverns, Microluminis alectryon's appearance can seem almost heavenly. Its colorful plumage doesn't hurt either. Even without the charged light it emits, it would give any modern bird on Earth a run for its money in terms of pure spectacle. Although its feathery eyebrows might give one of the impression that it is related to owls, it is not a bird of prey. It is entirely docile, and shows no aggression towards survivors or other creatures.\nDomesticated\nMicroluminis alectryon's ability to fly and the ease with which it perches upon a survivor's shoulder has made it a favored pet among many. Some consider it the most refined of its glowing brethren, but I think they just want to look like a pirate. Not that I blame them...\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Glowbug', 'name_tag': 'Lightbug', 'entity_id': 'Lightbug_Character_BaseBP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Lightbug/Lightbug_Character_BaseBP.Lightbug_Character_BaseBP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Dossier_Glowbug.png',
            'url': 'https://ark.fandom.com/wiki/Glowbug', 'id': 53,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b3/Glowbug.png',
            'description': '“\nSpecies\nLampyridae sublimis\nTime\nMiocene\nDiet\nUnknown\nTemperament\nPassive\nWild\nThe Light Bug is believed to be a descendant of the Lampyridae insect family. Typically, an insect with its characteristics will flourish in areas with no known natural predators. However, I believe the Light Bug population is moderated by the amount of creatures that vie for its charged light source. Despite being the source of a prized resource, many tribes believe the Light Bug to be sacred and admire it for its illuminance and elegant patterns.\nDomesticated\nDomesticating a Light bug would be a complete waste of time. It is not known to have any useful utility or function. I imagine you could save on fuel by using them to light a settlement.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Glowtail', 'name_tag': 'Lantern Lizard', 'entity_id': 'LanternLizard_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/LanternLizard/LanternLizard_Character_BP.LanternLizard_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Dossier_Glowtail.png',
            'url': 'https://ark.fandom.com/wiki/Glowtail', 'id': 54, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c6/Glowtail.png',
            'description': "“\nSpecies\nMicroluminis psykhe\nTime\nUnknown\nDiet\nHerbivore\nTemperament\nPassive\nWild\nWith a body reminiscent of a gecko, fluttery wings and a natural stockpile of charge light, Microluminis psykhe has an unearthly, if oddly charming appearance. A curious creature by nature, it always gave me the impression that it was studying me as much as I was studying it. A favorite snack of many predators, this small lizard has no natural poisons, or any means of defending itself at all save for a swift retreat and its charge light. Survivors can approach it without fear.\nDomesticated\nAs a pet, Microluminis psykhe is happy to clamber up a survivor's shoulder and cling to it as though it never wants to leave. Evenly tempered and easy to care for after being tamed, it is a stalwart companion and an excellent source of charge light.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Karkinos', 'name_tag': 'CaveCrab', 'entity_id': 'Crab_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Crab/Crab_Character_BP.Crab_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/25/Dossier_Karkinos.png',
            'url': 'https://ark.fandom.com/wiki/Karkinos', 'id': 55,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/40/Karkinos.png',
            'description': '“\nSpecies\nKarkinos versatus\nTime\nUnknown\nDiet\nOmnivore\nTemperament\nAggressive\nWild\nKarkinos Versatus is the giant cousin of modern crab species, with long, spindly limbs that remind me of the Japanese Spider Crab and a hard, stony shell. It is much more agile than its smaller brethren, but even more noticeable are its pincer claws. In an extraordinary display of dexterity, Karkinos is able to wield each claw independently and precisely. This allows it to trap multiple targets in its vice like grip, or hold an enemy in one claw while it smashes a second foe with the other.\nDomesticated\nMany survivors have found Karkinos to be an excellent war steed, as it can snatch enemy riders from their mounts, or grab and throw smaller creatures. However, its ability to leap to great heights and its swiftness relative to its size also make it useful in caravans.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Lamprey', 'name_tag': 'Lamprey', 'entity_id': 'Lamprey_Character_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Lamprey/Lamprey_Character.Lamprey_Character\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1d/Dossier_Lamprey.png',
            'url': 'https://ark.fandom.com/wiki/Lamprey', 'id': 56, 'category': 'Fish',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2c/Lamprey.png',
            'description': "“\nSpecies\nXenomyzon luminosus\nTime\nHolocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nXenomyzon luminosus is one of the most poisonous aquatic species I've ever encountered. While its trademark glowing tail makes it easy to spot and identify, those luminescent glands are also where it produces and stores a debilitating poison. Xenomyzon has developed a particular fondness for blood, and whenever possible, it will attempt to latch onto human subjects. Once it does, it injects a poison for which there are only two cures: A specialized antidote or time. I would not recommend the latter.\nDomesticated\nWhile Xenomyzon cannot be brought to heel, some survivors have stored them in fish baskets for other uses. This keeps the subject alive and contained, but not properly tamed.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Nameless', 'name_tag': 'Chupacabra', 'entity_id': 'ChupaCabra_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/ChupaCabra/ChupaCabra_Character_BP.ChupaCabra_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a2/Dossier_Nameless.png',
            'url': 'https://ark.fandom.com/wiki/Nameless', 'id': 57, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Nameless.png',
            'description': "“\nWild\nThe origins of the Nameless remain a mystery, but wherever they came from, these vicious creatures are nothing to scoff at, as they are rarely found alone. Common Nameless act in a subservient role to their pack's alpha, and will quickly heed its call to battle. Though savage in nature, the Nameless are deceptively intelligent. When hurt, they burrow underground to recover and protect themselves from further damage. Fortunately, they are highly susceptible to damage and burns from charge based light sources, and exploiting this weakness can save a survivor's life.\nDomesticated\nAll attempts to pacify a Nameless have failed. Each one has an extremely powerful bond with its pack leader, and for survivors, it might as well be unbreakable.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Ravager', 'name_tag': 'CaveWolf', 'entity_id': 'CaveWolf_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/CaveWolf/CaveWolf_Character_BP.CaveWolf_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ae/Dossier_Ravager.png',
            'url': 'https://ark.fandom.com/wiki/Ravager', 'id': 58,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/ca/Ravager.png',
            'description': "“\nSpecies\nCanis barghest\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAnywhere else, Canis barghest's powerful muscles, wicked claws, and fearsome countenance would put it near the top of the food chain. Yet in these caves, this common, lupine predator resides somewhere in the middle. That said, it is an intelligent hunter with an exceptional ability to adapt. For example, it has learned to utilize the zip lines that survivors have built as a means of travel, all on its own. Remarkable!\nDomesticated\nThe strong legs of the Canis barghest make it an effective mount for many survivors, particularly for long distance travel. While other creatures outshine it when it comes to bursts of speed, its stamina and ability to climb across both natural vines and artificial zip lines makes it a highly versatile travelling companion.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Reaper King', 'name_tag': 'Xenomorph', 'entity_id': 'Xenomorph_Character_BP_Male_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Nameless/Xenomorph_Character_BP_Male.Xenomorph_Character_BP_Male\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/Reaper_King', 'id': 59, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
            'description': "“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Reaper King (Tamed)', 'name_tag': 'Xenomorph',
            'entity_id': 'Xenomorph_Character_BP_Male_Tamed_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Nameless/Xenomorph_Character_BP_Male_Tamed.Xenomorph_Character_BP_Male_Tamed\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/Reaper_King_(Tamed)', 'id': 60,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
            'description': "“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Reaper Queen', 'name_tag': 'Xenomorph', 'entity_id': 'Xenomorph_Character_BP_Female_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Nameless/Xenomorph_Character_BP_Female.Xenomorph_Character_BP_Female\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/Reaper_Queen', 'id': 61, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
            'description': "“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Rock Drake', 'name_tag': 'RockDrake', 'entity_id': 'RockDrake_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/RockDrake/RockDrake_Character_BP.RockDrake_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/26/Dossier_Rock_Drake.png',
            'url': 'https://ark.fandom.com/wiki/Rock_Drake', 'id': 62, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e5/Rock_Drake.png',
            'description': "“\nSpecies\nDraconis obscurum\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nDraconis obscurum is a magnificent example of a predator that has flawlessly adapted to its environment. It is surrounded by cavern walls, so it developed powerful claws with which to scale them and colorful plumage on its anterior limbs that let it glide from perch to perch. But most dangerous of all? Its active camouflage, which lets it fade into the shadows and stalk its prey undetected. It has even adapted to the Nameless and The Reapers. Draconis' feathers will raise in warning when they are near, and this massive elegant lizard seems to be the Reaper's only natural enemy.\nDomesticated\nWith its unparalleled mobility and undeniable power, Draconis obscurum is a highly sought after mount. Survivors who successfully bring one back from its nesting grounds will suddenly find these caverns much easier to traverse, and that their enemies have become their unsuspecting prey. Even its saddle and rider are affected by its active camouflage, so a Survivor's enemies will never see them coming.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Rockwell', 'name_tag': 'Rockwell', 'entity_id': 'Rockwell_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Boss/Rockwell/Rockwell_Character_BP.Rockwell_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
            'url': 'https://ark.fandom.com/wiki/Rockwell', 'id': 63,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell (Alpha)', 'name_tag': 'Rockwell', 'entity_id': 'Rockwell_Character_BP_Hard_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Boss/Rockwell/Rockwell_Character_BP_Hard.Rockwell_Character_BP_Hard\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
            'url': 'https://ark.fandom.com/wiki/Rockwell_(Alpha)', 'id': 64, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell (Beta)', 'name_tag': 'Rockwell', 'entity_id': 'Rockwell_Character_BP_Medium_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Boss/Rockwell/Rockwell_Character_BP_Medium.Rockwell_Character_BP_Medium\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
            'url': 'https://ark.fandom.com/wiki/Rockwell_(Beta)', 'id': 65, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell (Gamma)', 'name_tag': 'Rockwell', 'entity_id': 'Rockwell_Character_BP_Easy_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Boss/Rockwell/Rockwell_Character_BP_Easy.Rockwell_Character_BP_Easy\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
            'url': 'https://ark.fandom.com/wiki/Rockwell_(Gamma)', 'id': 66, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Tentacle', 'name_tag': 'RockwellTentacle',
            'entity_id': 'RockwellTentacle_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Boss/RockwellTentacle/RockwellTentacle_Character_BP.RockwellTentacle_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Tentacle', 'id': 67,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Tentacle (Alpha)', 'name_tag': 'RockwellTentacle',
            'entity_id': 'RockwellTentacle_Character_BP_Alpha_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Boss/RockwellTentacle/RockwellTentacle_Character_BP_Alpha.RockwellTentacle_Character_BP_Alpha\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Tentacle_(Alpha)', 'id': 68, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Tentacle (Beta)', 'name_tag': 'RockwellTentacle',
            'entity_id': 'RockwellTentacle_Character_BP_Beta_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Boss/RockwellTentacle/RockwellTentacle_Character_BP_Beta.RockwellTentacle_Character_BP_Beta\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Tentacle_(Beta)', 'id': 69, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Tentacle (Gamma)', 'name_tag': 'RockwellTentacle',
            'entity_id': 'RockwellTentacle_Character_BP_Gamma_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Boss/RockwellTentacle/RockwellTentacle_Character_BP_Gamma.RockwellTentacle_Character_BP_Gamma\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Dossier_Rockwell.png',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Tentacle_(Gamma)', 'id': 70, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Rockwell.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Roll Rat', 'name_tag': 'MoleRat', 'entity_id': 'MoleRat_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/MoleRat/MoleRat_Character_BP.MoleRat_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c2/Dossier_Roll_Rat.png',
            'url': 'https://ark.fandom.com/wiki/Roll_Rat', 'id': 71, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d9/Roll_Rat.png',
            'description': '“\nSpecies\nHeterocephalus magnus\nTime\nHolocene\nDiet\nHerbivore\nTemperament\nPassive\nWild\nBearing a strong resemblance to its relative, the Naked Mole Rat, Heterocephalus magnus is a gentle giant that digs for plants and fungi with its imposing front teeth. While foraging, it often uncovers precious resources inadvertently, but survivors should claim them with caution, as this triggers an aggressive response. When threatened, Heterocephalus rolls up into a ball to shield itself with the armored plates on its back, much like an armadillo. It then rolls around like an oversized bowling ball, smashing through rocks, walls, and hopefully its aggressor.\nDomesticated\nWhile hardly a ferocious war beast, Heterocephalus is an effective transport that can carry up to three passengers. In theory, it could also be siege weapon, as its rolling attack can dent even metal. Fortunately, most survivors use a special saddle that deploys a protective canopy when it starts spinning, which not only keeps them from getting squished, but provides extra protection to the rider and mount alike.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Seeker', 'name_tag': 'Seeker', 'entity_id': 'Pteroteuthis_Char_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Pteroteuthis/Pteroteuthis_Char_BP.Pteroteuthis_Char_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/71/Dossier_Seeker.png',
            'url': 'https://ark.fandom.com/wiki/Seeker', 'id': 72,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/54/Seeker.png',
            'description': "“\nSpecies\nChimaeram odiosus\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nA highly hostile predator with a pack mentality, Chimaeram Odiosus has a voracious appetite, and will quickly swarm anything that possesses its favorite delicacy: Charge. Fact, Charge light seems to be crucial to its survival. When in its presence, they are strong and aggressive, but without it, they are weaker and quicker to flee. Though distinct from any known species, Chimaeram's appearance is a hideous pastiche of bats and cephalopods, and as an unbiased professional, I have to say: I really hate these bloody things. Honestly.\nDomesticated\nFor better or worse, there is no known method of taming Chimaeram Odiosus. If one must confront these creatures, remember to do so away from any charged light sources, as an empowered Chimaeram swarm can punch well above its weight class.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Shinehorn', 'name_tag': 'Lantern Goat', 'entity_id': 'LanternGoat_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/LanternGoat/LanternGoat_Character_BP.LanternGoat_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/20/Dossier_Shinehorn.png',
            'url': 'https://ark.fandom.com/wiki/Shinehorn', 'id': 73, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/21/Shinehorn.png',
            'description': "“\nSpecies\nMicroluminis cerynitis\nTime\nUnknown\nDiet\nHerbivore\nTemperament\nPassive\nWild\nMost commonly found in the upper chambers of the caverns, Microluminis cerynitis is at once elegant and adorable. As with its relatives, it is entirely peaceful, and no threat to survivors. After closer study, by which I mean very scientific bouts of cuddling, I've found that it shares traits with both bovids and cervids. However in the soft glow of its charge light, Microluminis cerynitis always gave me the impression that were it larger, it would be right at home pulling Artemis' chariot.\nDomesticated\nAn exceptionally well-mannered and huggable companion, Microluminis cerynitis is an excellent choice of pet for any survivor. Whether it is providing a source of charged light from your shoulder or playfully bounding up beside you, its presence is sure to brighten up your day.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Surface Reaper King Ghost', 'name_tag': 'Xenomorph',
            'entity_id': 'Ghost_Xenomorph_Character_BP_Male_Surface_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Nameless/Ghost_Xenomorph_Character_BP_Male_Surface.Ghost_Xenomorph_Character_BP_Male_Surface\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e2/Surface_Reaper_King_Ghost_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Surface_Reaper_King_Ghost', 'id': 74,
            'category': 'Event Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b5/Surface_Reaper_King_Ghost.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Alpha Blood Crystal Wyvern', 'name_tag': 'Wyvern',
            'entity_id': 'CrystalWyvern_Character_BP_Mega_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/CrystalWyvern_Character_BP_Mega.CrystalWyvern_Character_BP_Mega\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Crystal_Wyvern_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Alpha_Blood_Crystal_Wyvern', 'id': 75, 'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/11/Crystal_Wyvern.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Blood Crystal Wyvern', 'name_tag': 'Wyvern', 'entity_id': 'CrystalWyvern_Character_BP_Blood_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/CrystalWyvern_Character_BP_Blood.CrystalWyvern_Character_BP_Blood\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Crystal_Wyvern_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Blood_Crystal_Wyvern', 'id': 76, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/11/Crystal_Wyvern.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Crystal Wyvern Queen (Gamma)', 'name_tag': 'Wyvern',
            'entity_id': 'CrystalWyvern_Character_BP_Boss_Easy_C',
            'blueprint': '"Blueprint\'/Game/Mods/CrystalIsles/Assets/Dinos/CIBoss/CrystalWyvern_Character_BP_Boss_Easy.CrystalWyvern_Character_BP_Boss_Easy\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ad/Crystal_Wyvern_Queen_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Crystal_Wyvern_Queen_(Gamma)',
            'id': 77, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Crystal_Wyvern_Queen.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Crystal Wyvern Queen (Beta)', 'name_tag': 'Wyvern',
            'entity_id': 'CrystalWyvern_Character_BP_Boss_Medium_C',
            'blueprint': '"Blueprint\'/Game/Mods/CrystalIsles/Assets/Dinos/CIBoss/CrystalWyvern_Character_BP_Boss_Medium.CrystalWyvern_Character_BP_Boss_Medium\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ad/Crystal_Wyvern_Queen_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Crystal_Wyvern_Queen_(Beta)', 'id': 78, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Crystal_Wyvern_Queen.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Crystal Wyvern Queen (Alpha)', 'name_tag': 'Wyvern',
            'entity_id': 'CrystalWyvern_Character_BP_Boss_Hard_C',
            'blueprint': '"Blueprint\'/Game/Mods/CrystalIsles/Assets/Dinos/CIBoss/CrystalWyvern_Character_BP_Boss_Hard.CrystalWyvern_Character_BP_Boss_Hard\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ad/Crystal_Wyvern_Queen_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Crystal_Wyvern_Queen_(Alpha)',
            'id': 79, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Crystal_Wyvern_Queen.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Ember Crystal Wyvern', 'name_tag': 'Wyvern', 'entity_id': 'CrystalWyvern_Character_BP_Ember_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/CrystalWyvern_Character_BP_Ember.CrystalWyvern_Character_BP_Ember\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Crystal_Wyvern_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Ember_Crystal_Wyvern', 'id': 80, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/11/Crystal_Wyvern.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Giant Worker Bee', 'name_tag': 'Bee', 'entity_id': 'HoneyBee_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Mods/CrystalIsles/Assets/Dinos/HoneyBee/HoneyBee_Character_BP.HoneyBee_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Dossier_Giant_Bee.png',
            'url': 'https://ark.fandom.com/wiki/Giant_Worker_Bee', 'id': 81, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/45/Giant_Bee.png',
            'description': '“\nSpecies\nApis lithohermaea\nTime\nMiddle Miocene\nDiet\nHerbivore\nTemperament\nTerritorial\nWild\nIn the wild, Apis lithohermaea Drones never stray far from their nests, which they build high in the Island’s Redwood trees or on rocky cliffsides. Apis Drones can be seen swarming around the nest in groups, but to get a look at the Queen Apis, one would need to crack open the nest itself. Speaking from experience, this is not a pleasant task, as the untameable Apis Drones are quite territorial. I probably should have seen that one coming, in hindsight. Take caution: Apis stings will significantly weaken any creature which suffers them, and because its stinger is not barbed, Apis can sting multiple times without its stinger being ripped away.\nDomesticated\nA tamed Apis Queen will lay new drone eggs, and construct a nest that survivors can farm for honey, so long as they remember to wear specialized bee-keeping gear. Said honey is not only sweet and delicious, but laced with scents that land mammals find irresistible. Many hunters use it to bait their traps. Apis Drones will also follow their Queen into battle, so they can be used for self-defense in a pinch.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Tropeognathus', 'name_tag': 'Tropeognathus', 'entity_id': 'Tropeognathus_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Tropeognathus/Tropeognathus_Character_BP.Tropeognathus_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8f/Dossier_Tropeognathus.png',
            'url': 'https://ark.fandom.com/wiki/Tropeognathus', 'id': 82, 'category': 'Reptiles',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/94/Tropeognathus.png',
            'description': "“\nSpecies\nTropeognathus mesembrinus\nTime\nCretaceous\nDiet\nPiscivore\nTemperament\nNeutral\nWild\nUp close, Tropeognathus mesembrinus is easily recognized by the keeled crests on its snout, but with wingspans of up to twenty-seven feet, you’re sure to spot it before then. These large wings are not only ideal for catching air currents over its ocean hunting grounds, but they also let Tropeognathus draft off of other flying creatures by flying behind them. While not the fastest flyer on the Isles, when combined with its remarkable stamina, this makes Tropeognathus well suited for long distance flight. Because it’s on the wing so much, Tropeognathus is best snared by those riding another flier. I've noticed the more clever tribespeople using chain bolas to capture them while airborne.\nDomesticated\nOnce tamed, Tropeognathus has proven quite useful to the people of the Isles beyond mere transportation. For example, its toothed beak can grind down many common goods to their base components, which is a great way to recycle items and gear! Well, so long as you have a rag handy to wipe off the spit... That bite is punishing enough to crack armor and grind through it over time, and Tropeognathus can blow away flora and fauna alike with a gust from its wings. Air-to-air combat is where this creature really shines, though. And with the right tools, some survivors have managed to fit them with a saddle-mounted flak cannon and jet engine for maximum lethality. Trust me, you haven't lived until you've ridden a jet-powered pterosaur into a dogfight. Saddle one up and see for yourself - you can be my wingman anytime!\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Tropical Crystal Wyvern', 'name_tag': 'Wyvern', 'entity_id': 'CrystalWyvern_Character_BP_WS_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/CrystalWyvern_Character_BP_WS.CrystalWyvern_Character_BP_WS\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Crystal_Wyvern_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Tropical_Crystal_Wyvern', 'id': 83, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/11/Crystal_Wyvern.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Alpha King Titan', 'name_tag': 'KingTitanAlpha', 'entity_id': 'KingKaiju_Character_BP_Alpha_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/KingKaiju/KingKaiju_Character_BP_Alpha.KingKaiju_Character_BP_Alpha\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Dossier_King_Titan.png',
            'url': 'https://ark.fandom.com/wiki/Alpha_King_Titan', 'id': 84, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/King_Titan.png',
            'description': '“\nThough he could scatter his foes with a single charge, roar or swipe of his tail, and call fire down from the sky itself, In the end you banished the King of Shadows. No matter how many corrupted beasts he summoned or how many weapons he rendered useless, he could not snuff you out - for you fought with the hopes of the human race on your shoulders, and its tenacity at your back.\n„',
            'color_id': None
        },
        {
            'name': 'Beta King Titan', 'name_tag': 'King Titan', 'entity_id': 'KingKaiju_Character_BP_Beta_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/KingKaiju/KingKaiju_Character_BP_Beta.KingKaiju_Character_BP_Beta\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Dossier_King_Titan.png',
            'url': 'https://ark.fandom.com/wiki/Beta_King_Titan', 'id': 85, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/King_Titan.png',
            'description': '“\nThough he could scatter his foes with a single charge, roar or swipe of his tail, and call fire down from the sky itself, In the end you banished the King of Shadows. No matter how many corrupted beasts he summoned or how many weapons he rendered useless, he could not snuff you out - for you fought with the hopes of the human race on your shoulders, and its tenacity at your back.\n„',
            'color_id': None
        },
        {
            'name': 'Corrupted Arthropluera', 'name_tag': 'Arthro Corrupt',
            'entity_id': 'Arthro_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Arthropluera/Arthro_Character_BP_Corrupt.Arthro_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Dossier_Arthropluera.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Arthropluera', 'id': 86,
            'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Arthropluera.png',
            'description': "“\nSpecies\nArthropluera felsanguis\nTime\nEarly Permian\nDiet\nCarrion-Feeder\nTemperament\nAggressive\nWild\nThe fact that this creature exists is enough to give me nightmares. Like the island's other Arthropods, Arthropluera Felsanguis has become much larger than I might have believed possible. It's a very aggressive hunter, but prefers to eat meat after it has rotted for some time, and will voraciously seek out such delicacies.\nKnown Information\nArthropluera's blood has a very low pH, to the point that it can dissolve many materials. This acidic blood splashes back on anything that directly attacks it, weakening the durability of weapons and hurting attackers. Many creatures thusly refuse to prey on Arthropluera, fearing this unique defense. If that wasn't enough, Arthropluera also keeps a small reservoir of blood ready to spit at its prey.\nDomesticated\nLike most of the arthropods on the island, Arthropluera is simple minded and relatively easy to tame. It is an almost entirely military mount, useful mostly for attacking at a distance. Thanks to its unique defenses, whether hunting or warring, Arthropluera is generally safe from all but the largest of creatures.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Corrupted Carnotaurus', 'name_tag': 'Carno Corrupt', 'entity_id': 'Carno_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Carno/Carno_Character_BP_Corrupt.Carno_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Carnotaurus.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Carnotaurus', 'id': 87, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Carnotaurus.png',
            'description': "“\nSpecies\nCarnotaurus pressor\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nCarnotaurus pressor is a distinctive creature that falls between a medium and large predator. It lives primarily on flat, clear ground, where it can capitalize on its speed. Additionally, it seems to have no qualms about running away from larger predators instead of fighting. The horns of the Carnotaurus seem to be used more for fighting rivals than actual hunting. This doesn't mean the horns aren't dangerous, though. They can still eviscerate larger prey. Carnotaurus is one of the smaller and more compact of the large predators. If Tyrannosaurus is the “lion” of the Island, Carnotaurus would certainly be the “cheetah.” The real threat of a Carnotaurus is not being able to escape it once it has spotted you.\nDomesticated\nCarnotaurus fills a very specific role. Larger and almost as fast as a Raptor, smaller but much faster than a Rex. Were it not for the creature's extremely long down-time after sprinting, it might be among the most capably balanced mounts.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Corrupted Chalicotherium', 'name_tag': 'Chalico', 'entity_id': 'Chalico_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Chalicotherium/Chalico_Character_BP_Corrupt.Chalico_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/28/Dossier_Chalicotherium.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Chalicotherium', 'id': 88, 'category': 'Mammals',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Chalicotherium.png',
            'description': '“\nSpecies\nChalicotherium obsidioequus\nTime\nLate Oligocene - Early Pliocene\nDiet\nHerbivore\nTemperament\nTerritorial\nWild\nFound in small numbers within the Island\'s colder regions, Chalicotherium obsidioequus is normally a peaceful herbivore that prefers to spend its days lazing about or playing with its family. It is very territorial, however, and the entire family, young and old, will turn against an encroaching creature at just the slightest provocation. A memorable scene to stumble upon is a group of Chalicotherium playing. One odd playtime activity for Chalicotherium is hurling large balls of snow or.. mud-rocks(?).. at each other. Smaller creatures in the area shy away from Chalicotherium during this exertion, for fear of being buried in snow or "gravel."\nDomesticated\nWhile many creatures are useful while attacking a fortress, Chalicotherium can be trained as mobile artillery. Its unique playtime habit becomes a rather devastating long-range assault tactic when it is given boulders to throw, rather than snowballs!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Corrupted Dilophosaur', 'name_tag': 'Dilo Corrupt', 'entity_id': 'Dilo_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Dilo/Dilo_Character_BP_Corrupt.Dilo_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6c/Dossier_Dilophosaur.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Dilophosaur', 'id': 89, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c9/Dilophosaur.png',
            'description': '“\nSpecies\nDilophosaurus sputatrix\nTime\nEarly Jurassic\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nDilophosaurus sputatrix is a strange creature. It stands at just over half the size of known Dilophosaurs and runs from aggressors as often as it fights them. Dilophosaurus sputatrix has a few traits not common in the Dilophosaurus genus. It has a very shrill call, and a decorative ridge of skin on its neck. I believe these are used to attract mates, as well as intimidate prey and would-be predators. Instead of attacking its prey outright, Dilophosaurus sputatrix spits venom to weaken and paralyze it before moving in for the kill.\nDomesticated\nBecause of their shrill cry and their ability to attack intruders from range, Dilophosaurus seem most suited as "guard dogs." Due to their small size, they are not suitable as mounts.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Corrupted Dimorphodon', 'name_tag': 'Dimorph Corrupt',
            'entity_id': 'Dimorph_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Dimorphodon/Dimorph_Character_BP_Corrupt.Dimorph_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/Dossier_Dimorphodon.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Dimorphodon', 'id': 90,
            'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Dimorphodon.png',
            'description': "“\nSpecies\nDimorphodon equesica\nTime\nEarly Jurassic\nDiet\nCarnivore\nTemperament\nReactive\nWild\nDimorphodon equesica is another of the Island's Jekyll-and-Hyde creatures. It is normally passive, sometimes even friendly. When provoked, it becomes very aggressive, even against larger creatures it has no business fighting...often to its own fatal end. Dimorphodon can make short work of smaller opponents, however, due to its large (but lightweight) skull and teeth. Barely over a meter tall, Dimorphodon should be low on the food chain, but its incredible speed and surprisingly strong bite make it fairly dangerous, especially en masse as they tend to attack in groups. A flock of angry or hungry Dimorphodon can take down prey several times their size, so survivors should take care not to hunt near where a flock is gathered.\nDomesticated\nDimorphodon is one of the creatures on the Island that is easily domesticated for companionship, but its use in combat is also quite clear: It will hunt in large groups to seek out enemy dino riders directly, harassing them to no end, regardless of the might of their mount!\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Corrupted Giganotosaurus', 'name_tag': 'Gigant Corrupt',
            'entity_id': 'Gigant_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Giganotosaurus/Gigant_Character_BP_Corrupt.Gigant_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Giganotosaurus',
            'id': 91, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Giganotosaurus.png',
            'description': '“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Corrupted Paraceratherium', 'name_tag': 'Paracer', 'entity_id': 'Paracer_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Paraceratherium/Paracer_Character_BP_Corrupt.Paracer_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Paraceratherium.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Paraceratherium', 'id': 92, 'category': 'Mammals',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e1/Paraceratherium.png',
            'description': '“\nSpecies\nParaceratherium gigamicus\nTime\nOligocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nParaceratherium gigamicus is a massive, long-necked herbivore that inhabits some of the Island\'s grasslands. It resembles a gigantic horse/rhinoceros hybrid, but is over twice the size of either. Paraceratherium is a very peaceful and friendly creature. Barring some surprises yet in store for me, I can safely say that Paraceratherium is among the largest mammals on the Island. While its size means that Paraceratherium can provide an incredible amount of food, it also makes it dangerous when hunted.\nDomesticated\nA beast of burden second to the Brontosaurus, Paraceratherium is an excellent worker, and is sufficient in size to support a "platform" saddle upon which structures can be built. It is a naturally friendly animal, and is not afraid of humans. However, despite its normally calm demeanor, when it or its owner is provoked by aggression, the Paraceratherium can quickly become a real threat to the attacker and will use its girth to its advantage in combat.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Corrupted Pteranodon', 'name_tag': 'Ptera Corrupt', 'entity_id': 'Ptero_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Ptero/Ptero_Character_BP_Corrupt.Ptero_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6e/Dossier_Pteranodon.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Pteranodon', 'id': 93, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/22/Pteranodon.png',
            'description': "“\nSpecies\nPteranodon wyvernus\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nPteranodon wyvernus is a large pterosaur, capable of flying more quickly than any creature I have witnessed on this Island thus far. It seems to have relatively poor stamina in comparison to its quick speed, however, making frequent pit stops on the beaches before taking off again. While other humans I've seen on the Island still insist on calling it a Pterodactyl, this is inaccurate. Pteranodon wyvernus's poor fighting and defensive skills mean they are likely to scavenge any number of dead animals rather than engage in dangerous combat with other creatures. They also flee at the slightest sign of trouble. Because of this, they are one of the most common creatures to be found darting across the Island's skies.\nDomesticated\nPteranodons seem to be among most popular flying companions from what I have witnessed, possibly because they are relatively easy to tame with a slingshot or bow. Mounting a Pteranodon must be among the fastest and safest ways to get around the Island, but it doesn't provide any measure of secrecy in comparison to travel on land through the dense foliage.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Corrupted Raptor', 'name_tag': 'Raptor Corrupt', 'entity_id': 'Raptor_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Raptor/Raptor_Character_BP_Corrupt.Raptor_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Raptor', 'id': 94, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/08/Raptor.png',
            'description': '“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Corrupted Reaper King', 'name_tag': 'Xenomorph Corrupt',
            'entity_id': 'Xenomorph_Character_BP_Male_Tamed_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Nameless/Xenomorph_Character_BP_Male_Tamed_Corrupt.Xenomorph_Character_BP_Male_Tamed_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Reaper_King', 'id': 95,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
            'description': "“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Corrupted Rex', 'name_tag': 'Rex Corrupt', 'entity_id': 'Rex_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Rex/Rex_Character_BP_Corrupt.Rex_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Rex', 'id': 96, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Rex.png',
            'description': '“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Corrupted Rock Drake', 'name_tag': 'RockDrake Corrupt',
            'entity_id': 'RockDrake_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/RockDrake/RockDrake_Character_BP_Corrupt.RockDrake_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/26/Dossier_Rock_Drake.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Rock_Drake', 'id': 97,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e5/Rock_Drake.png',
            'description': "“\nSpecies\nDraconis obscurum\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nDraconis obscurum is a magnificent example of a predator that has flawlessly adapted to its environment. It is surrounded by cavern walls, so it developed powerful claws with which to scale them and colorful plumage on its anterior limbs that let it glide from perch to perch. But most dangerous of all? Its active camouflage, which lets it fade into the shadows and stalk its prey undetected. It has even adapted to the Nameless and The Reapers. Draconis' feathers will raise in warning when they are near, and this massive elegant lizard seems to be the Reaper's only natural enemy.\nDomesticated\nWith its unparalleled mobility and undeniable power, Draconis obscurum is a highly sought after mount. Survivors who successfully bring one back from its nesting grounds will suddenly find these caverns much easier to traverse, and that their enemies have become their unsuspecting prey. Even its saddle and rider are affected by its active camouflage, so a Survivor's enemies will never see them coming.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Corrupted Spino', 'name_tag': 'Spino Corrupt', 'entity_id': 'Spino_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Spino/Spino_Character_BP_Corrupt.Spino_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Spino.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Spino', 'id': 98, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/03/Spino.png',
            'description': "“\nSpecies\nSpinosaurus aquareliga\nTime\nEarly-Late Cretaceous\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nAmong the few carnivores on the Island that can match Tyrannosaurs in size, Spinosaurus aquareliga does not match its ferocity. Spinosaurus' four legs and large sail make it fairly swift on land and incredibly fast in the water. Its marvel is, arguably, the ability to change stances by going from quadruped to biped. The creature is visually distinguished by its spectacular sail. In my travels I have seen many different and brightly coloured sails, as every Spinosaurus appears to have a slightly different palette. The one comforting fact about Spinosaurus is that it seems more at home near water than away from it. Although the creature is more powerful, faster, agile, and insatiable while in water, it tends to become less hostile as it gets farther from it. On one occasion, I only escaped a Spinosaurus by getting far enough from its lake home to make it simply lose interest.\nDomesticated\nSpinosaurus is an incredibly well-rounded apex carnivore. Faster than a Tyrannosaurus in water and able to travel on land unlike a Megalodon, its all-terrain versatility may be unrivaled. Although its movement speed is slower in a biped stance, it gains considerable attacking strength and mobility in this form. For hunters who wish to have a well-rounded mount, Spinosaurus may be the ideal choice -- if they can acquire one.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Corrupted Stegosaurus', 'name_tag': 'Stego Corrupt', 'entity_id': 'Stego_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Stego/Stego_Character_BP_Corrupt.Stego_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Dossier_Stegosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Stegosaurus', 'id': 99, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Stegosaurus.png',
            'description': "“\nSpecies\nStegosaurus regium\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nDocile\nWild\nStegosaurus regium has approximately 16 paired rows of plates along its back, flanked by another, smaller pair of 6 plates. This is contrary to the alternating rows on Stegosaurus fossils I've seen in museums. Not surprisingly, Stegosaurus uses the spines on its tail to defend itself. While not aggressive, Stegosaurus will come to the aid of another nearby Stegosaurus. This implies it to be a herd animal.\nDomesticated\nStegosaurus is commonly used as a safe way to transport large quantities of goods. And once you saddle one up, not even an Argentavis could knock you off that perch. A stegosaurus can be trained to flex its back plates for different purposes: hardened to shield it from attack, in a heavier alignment that deals crippling blows, or oriented more sharply to pierce armor. These various plate configurations also come in handy for stripping wood from trees, gathering thatch, or foraging for wild berries, respectively. Stegosaurus can knock back or impale with a whip of its spiky tail, keeping predators at bay or pinning them in place. Its spiked appendage also helps for gathering berries—go figure.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Corrupted Triceratops', 'name_tag': 'Trike', 'entity_id': 'Trike_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Trike/Trike_Character_BP_Corrupt.Trike_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Triceratops.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Triceratops', 'id': 100, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
            'description': "“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Corrupted Wyvern', 'name_tag': 'Wyvern', 'entity_id': 'Wyvern_Character_BP_Fire_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Wyvern/Wyvern_Character_BP_Fire_Corrupt.Wyvern_Character_BP_Fire_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Wyvern', 'id': 101, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
            'description': "“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Defense Unit', 'name_tag': 'EndTank', 'entity_id': 'Defender_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Tank/Defender_Character_BP.Defender_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6e/Defense_Unit_Promo_Image.png',
            'url': 'https://ark.fandom.com/wiki/Defense_Unit', 'id': 102,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/78/Defense_Unit.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Desert Titan', 'name_tag': 'DesertTitan', 'entity_id': 'DesertKaiju_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/DesertKaiju/DesertKaiju_Character_BP.DesertKaiju_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1a/Dossier_Desert_Titan.png',
            'url': 'https://ark.fandom.com/wiki/Desert_Titan', 'id': 103, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/49/Desert_Titan.png',
            'description': '“\nThe Lord of Sand and Sky has fallen, despite its swarms of protectors, the powerful swings of its mighty tail or the lightning it called from the sky. The soaring leviathan could not match the ingenuity of humanity, and especially not yours.\n„',
            'color_id': None
        },
        {
            'name': 'Desert Titan Flock', 'name_tag': 'Flock', 'entity_id': 'DesertKaiju_FirstFlockChar_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/DesertKaiju/DesertKaiju_FirstFlockChar_BP.DesertKaiju_FirstFlockChar_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1a/Dossier_Desert_Titan.png',
            'url': 'https://ark.fandom.com/wiki/Desert_Titan_Flock', 'id': 104, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/49/Desert_Titan.png',
            'description': '“\nThe Lord of Sand and Sky has fallen, despite its swarms of protectors, the powerful swings of its mighty tail or the lightning it called from the sky. The soaring leviathan could not match the ingenuity of humanity, and especially not yours.\n„',
            'color_id': None
        },
        {
            'name': 'Enforcer', 'name_tag': 'Enforcer', 'entity_id': 'Enforcer_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Enforcer/Enforcer_Character_BP.Enforcer_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Enforcer.png',
            'url': 'https://ark.fandom.com/wiki/Enforcer', 'id': 105,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e4/Enforcer.png',
            'description': "“\nModel Number\nAGV MQ-9X\nThreat Level\nHigh\nPrimary Function\nDirect combat\nField Manual 31-582\nField Observations\nWith its speed and teleportation capabilities, Autonomous Ground Vehicle MQ-9X is built to close gaps quickly and engage its targets in close quarters. Once in range, it uses refined Element claws with lethal force.\nMQ-9X was clearly designed for urban combat. Its claws and shock absorbers let it scale walls and drop down to street level from significant heights, and we've only seen it patrolling within the city limits. Possibly the remnant of an automated police force or defensive army.\nRecommendations: Isolate, and engage at range in wide open spaces. I've calculated its maximum teleportation distance as roughly 15 meters, so maintain that gap as long as possible\nPersonal Use\nEvery MQ-9X I've encountered is stuck on a defensive loop, and overriding its primary directive is impossible. However, if we're able to acquire an intact processing core from a hostile unit, with enough parts I could reverse engineer our own, more loyal model. Could be useful - the grooves on its back are suited for a rider, so we wouldn't even need to build saddles.\n„\n~ Santiago",
            'color_id': None
        },
        {
            'name': 'Enraged Corrupted Rex', 'name_tag': 'Elite Rex Corrupt',
            'entity_id': 'MegaRex_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Rex/MegaRex_Character_BP_Corrupt.MegaRex_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3f/Enraged_Corrupted_Rex_1.jpg',
            'url': 'https://ark.fandom.com/wiki/Enraged_Corrupted_Rex',
            'id': 106, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e6/Enraged_Corrupted_Rex.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Enraged Triceratops', 'name_tag': 'Trike', 'entity_id': 'MegaTrike_Character_BP_Corrupt_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Corrupt/Trike/MegaTrike_Character_BP_Corrupt.MegaTrike_Character_BP_Corrupt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/78/Enraged_Triceratops_1.jpg',
            'url': 'https://ark.fandom.com/wiki/Enraged_Triceratops', 'id': 107, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Enraged_Triceratops.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Forest Titan', 'name_tag': 'ForestTitan', 'entity_id': 'ForestKaiju_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/ForestKaiju/ForestKaiju_Character_BP.ForestKaiju_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1e/Dossier_Forest_Titan.png',
            'url': 'https://ark.fandom.com/wiki/Forest_Titan', 'id': 108, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/28/Forest_Titan.png',
            'description': '“\nSo succumbs the Lord of the Forest, the titan wreathed in green, who lashed out with root and vine to pin its foes to the ground or drag them to their doom. The forest itself rose to shield it, but even that could not save it. Not from you.\n„',
            'color_id': None
        },
        {
            'name': 'Forest Wyvern', 'name_tag': 'Wyvern', 'entity_id': 'Wyvern_Character_BP_Fire_Minion_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/ForestKaiju/Minion/Wyvern_Character_BP_Fire_Minion.Wyvern_Character_BP_Fire_Minion\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
            'url': 'https://ark.fandom.com/wiki/Forest_Wyvern', 'id': 109, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Wyvern.png',
            'description': "“\nSpecies\nDraconis vipera\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nLike its relative from the Island, the Draconis vipera that inhabit the aptly named Dragon Trenches are creatures straight out of European legend. Aside from size, the main difference between Draconis vipera and its larger cousin is that the former possesses only two legs, like an avian. Otherwise, it is quite similar, with armored scales, leathery wings and the ability to spew projectiles from a pair of glands inside its mouth. The nature of these projectiles is tied directly to the color of Draconis' scales. Some spit fire while others unleash poisonous acid or even bursts of bioelectricity.\nDomesticated\nI can imagine no flying mount more deadly than Draconis vipera. Its strength, toughness and ability rain death upon one's enemies makes it unmatched in combat. The few creatures that it cannot immediately overpower, it can outmaneuver. The ridges on its back form a natural saddle, to the point where many riders prefer to ride Draconis bareback. Curious indeed. However, Draconis vipera is too resilient to domesticate once it has become an adult. It must be raised from an egg if you wish to garner its loyalty.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Gacha', 'name_tag': 'Gacha', 'entity_id': 'Gacha_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Gacha/Gacha_Character_BP.Gacha_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Dossier_Gacha.png',
            'url': 'https://ark.fandom.com/wiki/Gacha', 'id': 110,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Gacha.png',
            'description': "“\nSpecies\nMacrodryadis crystallinus\nTime\nPost-Holocene\nDiet\nOmnivore\nTemperament\nDocile\nWild\nA gentle giant, Macrodryadis crystallinus spends its days foraging for food in the dense forest it calls home, though it rarely has to look very far. Thanks to its extraordinary digestive system, not only can Macrodryadis eat just about anything, but it can also turn a diet of scraps into a mountain of precious resources.\n\nInstead of producing excrement, Macrodryadis grows glittering crystals upon its back, which fall off when they reach their full size. Shattering these crystals can yield precious resources, as Macrodryadis is somehow able to transmute the materials it eats into something entirely different.\n\nOne of our pilots likened the process to the gachapon machines from his memories of growing up in Japan, and I guess the name stuck.\nDomesticated\nThough its crystals prevent Macrodryadis from wearing a traditional saddle, if its rider is willing to sit in a basket that hangs from Macrodryadis' neck, then they'll find its long claws are well suited for mining resources. Personally though, I'd keep one around just for the crystals. The free presents, the way they glow at night...totally worth the potential nausea from the basket saddle.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'GachaClaus', 'name_tag': 'Gacha', 'entity_id': 'Gacha_Claus_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Gacha/Gacha_Claus_Character_BP.Gacha_Claus_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/GachaClaus_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/GachaClaus', 'id': 111, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/86/GachaClaus.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Gamma King Titan', 'name_tag': 'King Titan', 'entity_id': 'KingKaiju_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/KingKaiju/KingKaiju_Character_BP.KingKaiju_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Dossier_King_Titan.png',
            'url': 'https://ark.fandom.com/wiki/Gamma_King_Titan', 'id': 112, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/King_Titan.png',
            'description': '“\nThough he could scatter his foes with a single charge, roar or swipe of his tail, and call fire down from the sky itself, In the end you banished the King of Shadows. No matter how many corrupted beasts he summoned or how many weapons he rendered useless, he could not snuff you out - for you fought with the hopes of the human race on your shoulders, and its tenacity at your back.\n„',
            'color_id': None
        },
        {
            'name': 'Gasbags', 'name_tag': 'GasBags', 'entity_id': 'GasBags_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/GasBag/GasBags_Character_BP.GasBags_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8c/Dossier_Gasbags.png',
            'url': 'https://ark.fandom.com/wiki/Gasbags', 'id': 113,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Gasbags.png',
            'description': "“\nSpecies\nMopsechiniscus fluitobesus\nTime\nPost-Holocene\nDiet\nOmnivore\nTemperament\nPassive\nWild\nIt was always hypothesized that a member of the Tardigrada phylum would be the last species on Earth in the event of a global apocalypse, so in some ways, the existence of Mopsechiniscus fluitobesus is completely expected. Its size and method of travel, however? Less so.\n\nMopsechiniscus is slow and ineffective in a fight, so to survive, it tends to choose flight - literally. First, it inflates itself like a balloon, briefly slowing down and gaining durability. Then it launches itself into the air by expelling gas through a series of sphincters in its underbelly, which it also uses to slow its descent.\n\nYes, it's as...unusual as it sounds, but Mopsechiniscus makes the most of its inflatable nature. In addition to jumping, it can use its stored up gases to push back aggressors, or even float on water.\nDomesticated\nWhile a poor steed in battle, Mopsechiniscus is a fantastic beast of burden. The hairs on its back let a single rider steer it without a saddle, and it carries an incredible amount of cargo for its size. A small caravan of these could see us swimming in resources in no time.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Ice Titan', 'name_tag': 'IceTitan', 'entity_id': 'IceKaiju_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/IceKaiju/IceKaiju_Character_BP.IceKaiju_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Dossier_Ice_Titan.png',
            'url': 'https://ark.fandom.com/wiki/Ice_Titan', 'id': 114, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dc/Ice_Titan.png',
            'description': '“\nThus ends the reign of the Lord of Winter. Its freezing breath, icy spears, and colossal leaps had felled so many, but on this day, the giant of wind and rime was brought low - all by your hand.\n„',
            'color_id': None
        },
        {
            'name': 'Managarmr', 'name_tag': 'Managarmr', 'entity_id': 'IceJumper_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/IceJumper/IceJumper_Character_BP.IceJumper_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/72/Dossier_Managarmr.png',
            'url': 'https://ark.fandom.com/wiki/Managarmr', 'id': 115,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e7/Managarmr.png',
            'description': '“\nSpecies\nDraconis auragelus\nTime\nPost-Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nDraconis auragelus appears to be directly related to the stealthy Draconis obscurum. Their stature, gait and ability to dive through the air are all similar. However, where Draconis obscurum scaled cavern walls to gain the high ground, Draconis auragelus takes a more bombastic approach.\n\nIn the middle of its hind feet, Draconis auragelus\' bones form a hollowed out cylindrical shape that acts as a combustion chamber, which it fills with an explosive gas. When ignited, this gas propels it upwards, letting it "jump" in the air multiple times. From there, it can create a smaller burn in said chambers to hover in place, or dive at its prey.\n\nLike the icy variant of Draconis vipera, Draconis auragelus can slow down its foes with its frigid breath - though it\'s able to take this one step further and freeze its prey solid. Perhaps that\'s because it\'s used to living in the tundra environment on the surface, as opposed to a desert.\nDomesticated\nAs a mount, Draconis auragelus can carry multiple adult humans without losing any of its impressive mobility, and its freezing breath makes it a good choice in combat. Whether you\'re looking to hunt, do battle or just travel with ease, it makes for an excellent companion.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Mega Mek', 'name_tag': 'MegaMek', 'entity_id': 'MegaMek_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Mek/MegaMek_Character_BP.MegaMek_Character_BP\'"',
            'large_image_url': 'https://cdnb.artstation.com/p/assets/covers/images/013/959/563/large/nathan-lange-mm-0007-layer-10.jpg',
            'url': 'https://ark.fandom.com/wiki/Mega_Mek', 'id': 116, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Mek.png',
            'description': "“\nModel Number\nRX-103 MEK\nHeight\n10.5 meters\nWeight\n48.3 tons\nTechnical Manual 9-978\nStandard Equipment\nOZ-13NV TEK Saber: Designed as the primary weapon, to better suit the skills of our top pilot candidates. Built more for cuts than stabs. Ideal for attacking in combinations.\nXBR-M-93R Plasma Pistol: Secondary weapon. Fires in three shot bursts.\nMS-06BR Boosters: Installed under the unit's feet. On activation, they let the unit hover in the air and move rapidly over short distances. Combine with ranged attacks for maximum effectiveness.\nHeat Gauge: Pilots should always monitor their unit's heat levels. Overheating will result in your unit being slow, vulnerable and soon after that? Scrap.\nCustom Equipment\nEach RX-103-MEK has a module slot for a specially designed weapon or tool that can be swapped out with ease. These are...\nG-01W Mek Siege Cannon Module: A high yield artillery cannon mounted on the unit's back. To handle the recoil, the unit must temporarily anchor itself to the ground, rendering it immobile while firing.\nG-02H Mek Rocket Launcher Module: An oversized missile battery that fires in sixteen round salvos, which spread out and then converge on the unit’s target. Especially effective against large, isolated targets.\nG-01S Mek Deployable Shield Module: Deploys a dome shaped energy barrier that protects the unit from incoming ranged attacks, while boosting its speed. Good for team or melee oriented pilots.\n„\n~ Santiago",
            'color_id': None
        },
        {
            'name': 'Mek', 'name_tag': 'Mek', 'entity_id': 'Mek_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Mek/Mek_Character_BP.Mek_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1e/Dossier_Mek.png',
            'url': 'https://ark.fandom.com/wiki/Mek', 'id': 117, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Mek.png',
            'description': "“\nModel Number\nRX-103 MEK\nHeight\n10.5 meters\nWeight\n48.3 tons\nTechnical Manual 9-978\nStandard Equipment\nOZ-13NV TEK Saber: Designed as the primary weapon, to better suit the skills of our top pilot candidates. Built more for cuts than stabs. Ideal for attacking in combinations.\nXBR-M-93R Plasma Pistol: Secondary weapon. Fires in three shot bursts.\nMS-06BR Boosters: Installed under the unit's feet. On activation, they let the unit hover in the air and move rapidly over short distances. Combine with ranged attacks for maximum effectiveness.\nHeat Gauge: Pilots should always monitor their unit's heat levels. Overheating will result in your unit being slow, vulnerable and soon after that? Scrap.\nCustom Equipment\nEach RX-103-MEK has a module slot for a specially designed weapon or tool that can be swapped out with ease. These are...\nG-01W Mek Siege Cannon Module: A high yield artillery cannon mounted on the unit's back. To handle the recoil, the unit must temporarily anchor itself to the ground, rendering it immobile while firing.\nG-02H Mek Rocket Launcher Module: An oversized missile battery that fires in sixteen round salvos, which spread out and then converge on the unit’s target. Especially effective against large, isolated targets.\nG-01S Mek Deployable Shield Module: Deploys a dome shaped energy barrier that protects the unit from incoming ranged attacks, while boosting its speed. Good for team or melee oriented pilots.\n„\n~ Santiago",
            'color_id': None
        },
        {
            'name': 'Scout', 'name_tag': 'Scout', 'entity_id': 'Scout_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Scout/Scout_Character_BP.Scout_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0d/Dossier_Scout.png',
            'url': 'https://ark.fandom.com/wiki/Scout', 'id': 118, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/69/Scout.png',
            'description': "“\nModel Number\nUAV RQ-7Y\nThreat Level\nLow\nPrimary Function\nReconnaissance\nField Manual 31-581\nField Observations\nBy itself, Unmanned Aerial Vehicle RQ-7Y is hardly a concern. Though many of them can be found monitoring the empty streets the abandoned city, they're not aggressive, and their offensive capabilities are limited. If attacked, they rely on bursts from their thrusters to either take evasive maneuvers or ram the aggressor, and they have no real armaments to speak of. This makes obtaining intact processing cores and spare parts a trivial matter, and as a result we've constructed a number of our own.\nPersonal Use\nShifting some of our resources to focus on RQ-7Y construction has been more than worth the investment. I managed to turn our TEK binoculars into a remote control system for them, and as a result our scouting teams have been able to cover more ground with far less risk. They simply deploy the RQ-7Y with a specialized grenade, then use its enhanced vision to scout ahead, scan for allied IFFs and track targets. Just don't try to ride the damn thing. I didn't think I'd have to explain that considering how small it is, but three crashes later, here we are...\n„\n~ Santiago",
            'color_id': None
        },
        {
            'name': 'Snow Owl', 'name_tag': 'Owl', 'entity_id': 'Owl_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Owl/Owl_Character_BP.Owl_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bd/Dossier_Snow_Owl.png',
            'url': 'https://ark.fandom.com/wiki/Snow_Owl', 'id': 119, 'category': 'Birds',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4b/Snow_Owl.png',
            'description': "“\nSpecies\nBubo chinookus\nTime\nPost-Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nDiscovering Bubo chinookus was a pleasant surprise. Owls are remarkable creatures, but they're not the type that could survive an extinction level event on their own. Since it never strays from the patch of frozen tundra we encountered, I believe the Obelisk was the key to its survival.\n\nClearly a descendant of modern Strigdae, Bubo shares many traits with its smaller ancestors. For example, it excretes waste in the form of pellets, which make excellent fertilizer, and their large wings let them save energy during long, silent flights. They even hunt in the same way: by diving towards the ground to attack their prey with powerful talons.\n\nHowever, these talons also secrete a chemical with a high freezing point to slow down their prey, and they can even unleash this chemical in a wide cloud, temporarily freezing their foes.\nDomesticated\nWith its swift flying and frigid attacks, Bubo makes an excellent single-rider support mount or scout. The latter is helped by its tremendous vision, which it can share with its rider via its antenna. Not only does this make enemies easier to see, but Bubo can also spot Element veins with ease, even when they're underground.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Snow Owl Ghost', 'name_tag': 'Owl', 'entity_id': 'Ghost_Owl_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Owl/Ghost_Owl_Character_BP.Ghost_Owl_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4f/Snow_Owl_Ghost_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Snow_Owl_Ghost', 'id': 120, 'category': 'Event Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Snow_Owl_Ghost.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Velonasaur', 'name_tag': 'Velonasaur', 'entity_id': 'Spindles_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Extinction/Dinos/Spindles/Spindles_Character_BP.Spindles_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Dossier_Velonasaur.png',
            'url': 'https://ark.fandom.com/wiki/Velonasaur', 'id': 121, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Velonasaur.png',
            'description': "“\nSpecies\nVelonasaurus spinavultus\nTime\nPost-Holocene\nDiet\nCarnivore\nTemperament\nOmnivore\nWild\nVelonasaurus spinavultus dwells in the small desert found outside the abandoned city, which is particularly fitting, because it looks like it's growing several cacti right on its face.\n\nAs unfashionable as its facial fins might be, I recommend keeping a close eye on them. While said fins are folded inwards, Velonasaurus behaves like your average therapod, attacking with claws and teeth. However, when those fins are spread wide, Velonasaurus can rapidly fire a storm of spines at its prey. However, while in this state, its mobility is greatly hampered and it will eventually wear itself out.\n\nTherefore it sometimes prefers to unleash its spines in a single, deadly burst. By spinning around and firing a salvo of spines at the same time, Velonasaurus can defend itself from every angle at once.\nDomesticated\nGiven its versatility, Velonasaurus spinavultus makes an excellent single rider mount in most combat situations, but it's particularly effective when defending an entrenched position. It's like a living, breathing gatling gun. Just be careful when giving it a congratulatory hug or pat on the head. Getting spined by your own war steed would be a rather embarrassing way to go.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Alpha Corrupted Master Controller', 'name_tag': None, 'entity_id': 'VRMainBoss_Character_Hard_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/VRMainBoss/VRMainBoss_Character_Hard.VRMainBoss_Character_Hard\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Corrupted_Master_Controller_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Alpha_Corrupted_Master_Controller', 'id': 122, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Corrupted_Master_Controller.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Alpha Moeder, Master of the Ocean', 'name_tag': 'EelBoss',
            'entity_id': 'EelBoss_Character_BP_Hard_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/EelBoss/EelBoss_Character_BP_Hard.EelBoss_Character_BP_Hard\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Genesis_17.jpg',
            'url': 'https://ark.fandom.com/wiki/Alpha_Moeder,_Master_of_the_Ocean', 'id': 123, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bd/Moeder%2C_Master_of_the_Ocean.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Alpha X-Triceratops', 'name_tag': 'Trike',
            'entity_id': 'Volcano_Trike_Character_BP_Retrieve_Alpha_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Retrieve/Volcanic/Volcano_Trike_Character_BP_Retrieve_Alpha.Volcano_Trike_Character_BP_Retrieve_Alpha\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Triceratops.png',
            'url': 'https://ark.fandom.com/wiki/Alpha_X-Triceratops',
            'id': 124, 'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
            'description': "“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Astrocetus', 'name_tag': 'Space Whale', 'entity_id': 'SpaceWhale_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/SpaceWhale/SpaceWhale_Character_BP.SpaceWhale_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Astrocetus_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Astrocetus', 'id': 125, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/69/Astrocetus.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Beta Corrupted Master Controller', 'name_tag': None,
            'entity_id': 'VRMainBoss_Character_Medium_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/VRMainBoss/VRMainBoss_Character_Medium.VRMainBoss_Character_Medium\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Corrupted_Master_Controller_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Beta_Corrupted_Master_Controller',
            'id': 126, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Corrupted_Master_Controller.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Beta Moeder, Master of the Ocean', 'name_tag': 'EelBoss',
            'entity_id': 'EelBoss_Character_BP_Medium_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/EelBoss/EelBoss_Character_BP_Medium.EelBoss_Character_BP_Medium\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Corrupted_Master_Controller_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Beta_Moeder,_Master_of_the_Ocean', 'id': 127, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Corrupted_Master_Controller.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Bloodstalker', 'name_tag': 'Bloodstalker', 'entity_id': 'BogSpider_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BogSpider/BogSpider_Character_BP.BogSpider_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9b/Bloodstalker_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Bloodstalker', 'id': 128, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1a/Bloodstalker.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Araneo', 'name_tag': 'Spider', 'entity_id': 'SpiderS_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Bog/SpiderS_Character_BP_Hunt.SpiderS_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Dossier_Araneo.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Araneo', 'id': 129, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b5/Brute_Araneo.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Astrocetus', 'name_tag': 'Space Whale', 'entity_id': 'SpaceWhale_Character_BP_Brute_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Lunar/SpaceWhale_Character_BP_Brute.SpaceWhale_Character_BP_Brute\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Astrocetus_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Brute_Astrocetus', 'id': 130, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0c/Brute_Astrocetus.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Basilosaurus', 'name_tag': 'Basilosaurus', 'entity_id': 'Basilosaurus_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Basilosaurus_Character_BP_Hunt.Basilosaurus_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Dossier_Basilosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Basilosaurus', 'id': 131, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/02/Brute_Basilosaurus.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Bloodstalker', 'name_tag': 'Bloodstalker', 'entity_id': 'BogSpider_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Bog/BogSpider_Character_BP_Hunt.BogSpider_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9b/Bloodstalker_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Brute_Bloodstalker', 'id': 132, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/49/Brute_Bloodstalker.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Ferox', 'name_tag': 'Bigly', 'entity_id': 'Shapeshifter_Large_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Arctic/Shapeshifter_Large_Character_BP_Hunt.Shapeshifter_Large_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2b/Ferox_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Brute_Ferox', 'id': 133, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Brute_Ferox.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Fire Wyvern', 'name_tag': 'Wyvern', 'entity_id': 'Wyvern_Character_BP_Fire_GauntletBoss_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Gauntlet/Volcanic/Wyvern_Character_BP_Fire_GauntletBoss.Wyvern_Character_BP_Fire_GauntletBoss\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/34/Dossier_Wyvern.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Fire_Wyvern', 'id': 134, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4f/Brute_Fire_Wyvern.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Leedsichthys', 'name_tag': 'Leedsichthys', 'entity_id': 'Leedsichthys_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Leedsichthys_Character_BP_Hunt.Leedsichthys_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e9/Dossier_Leedsichthys.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Leedsichthys', 'id': 135, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/63/Brute_Leedsichthys.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Magmasaur', 'name_tag': 'LavaLizard', 'entity_id': 'Cherufe_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Volcanic/Cherufe_Character_BP_Hunt.Cherufe_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Magmasaur_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Brute_Magmasaur', 'id': 136, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Brute_Magmasaur.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Malfunctioned Tek Giganotosaurus', 'name_tag': 'Gigant',
            'entity_id': 'BionicGigant_Character_BP_Malfunctioned_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Lunar/BionicGigant_Character_BP_Malfunctioned_Hunt.BionicGigant_Character_BP_Malfunctioned_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Malfunctioned_Tek_Giganotosaurus', 'id': 137,
            'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/96/Brute_Malfunctioned_Tek_Giganotosaurus.png',
            'description': '“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Brute Malfunctioned Tek Rex', 'name_tag': 'Rex',
            'entity_id': 'BionicRex_Character_BP_Malfunctioned_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Lunar/BionicRex_Character_BP_Malfunctioned_Hunt.BionicRex_Character_BP_Malfunctioned_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Malfunctioned_Tek_Rex', 'id': 138,
            'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c8/Brute_Malfunctioned_Tek_Rex.png',
            'description': '“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Brute Mammoth', 'name_tag': 'Mammoth', 'entity_id': 'Mammoth_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Arctic/Mammoth_Character_BP_Hunt.Mammoth_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0c/Dossier_Mammoth.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Mammoth', 'id': 139, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c1/Brute_Mammoth.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Megaloceros', 'name_tag': 'Stag', 'entity_id': 'Stag_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Arctic/Stag_Character_BP_Hunt.Stag_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8c/Dossier_Megaloceros.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Megaloceros', 'id': 140, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/74/Brute_Megaloceros.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Plesiosaur', 'name_tag': 'Plesiosaur', 'entity_id': 'Plesiosaur_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Plesiosaur_Character_BP_Hunt.Plesiosaur_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Plesiosaur.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Plesiosaur', 'id': 141, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/Brute_Plesiosaur.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Reaper King', 'name_tag': 'Xenomorph',
            'entity_id': 'Xenomorph_Character_BP_Male_InitialBuryOnly_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Lunar/Xenomorph_Character_BP_Male_InitialBuryOnly_Hunt.Xenomorph_Character_BP_Male_InitialBuryOnly_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Reaper_King',
            'id': 142, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/61/Brute_Reaper_King.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Sarco', 'name_tag': 'Sarco', 'entity_id': 'Sarco_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Bog/Sarco_Character_BP_Hunt.Sarco_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/70/Dossier_Sarco.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Sarco', 'id': 143, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4a/Brute_Sarco.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Seeker', 'name_tag': 'Seeker', 'entity_id': 'Pteroteuthis_Char_BP_HuntFollower_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Lunar/Pteroteuthis_Char_BP_HuntFollower.Pteroteuthis_Char_BP_HuntFollower\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/71/Dossier_Seeker.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Seeker', 'id': 144, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Brute_Seeker.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute Tusoteuthis', 'name_tag': 'Tusoteuthis', 'entity_id': 'Tusoteuthis_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Tusoteuthis_Character_BP_Hunt.Tusoteuthis_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Tusoteuthis.png',
            'url': 'https://ark.fandom.com/wiki/Brute_Tusoteuthis', 'id': 145, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c6/Brute_Tusoteuthis.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Brute X-Allosaurus', 'name_tag': 'Allo', 'entity_id': 'Volcano_Allo_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Volcanic/Volcano_Allo_Character_BP_Hunt.Volcano_Allo_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Allosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Brute_X-Allosaurus', 'id': 146, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/80/Brute_X-Allosaurus.png',
            'description': "“\nSpecies\nAllosaurus therotribus\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmaller but faster than Tyrannosaurus, larger but slower than Carnotaurus, Allosaurus therotribus is the island's resident pack-hunting theropod. While most aggressive theropods are relatively solitary creatures, Allosaurus lives in groups of 3. One Allosaurus is the alpha, while the others are its mates or a beta male. Like humans find value in forming a tribe, the Allosaurus has evolved to hunt in packs. Its saw-shaped teeth leave its prey bleeding and maimed, making escape difficult. Once an Allosaurus slows a creature with its cutting bite, the rest of its pack quickly closes in for the kill.\nDomesticated\nNot everyone thinks a tamed Allosaurus is ideal. Those who appreciate speed generally tame Carnotaurus, while those who value raw stopping power tame Tyrannosaurus. However, riders of Allosaurus tend to respect the utility of its Alpha pack status, which along with its bleed-inducing attacks and relative mobility, can effectively turn the tide of a combined arms battle.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Brute X-Megalodon', 'name_tag': 'Mega', 'entity_id': 'Ocean_Megalodon_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Ocean_Megalodon_Character_BP_Hunt.Ocean_Megalodon_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Dossier_Megalodon.png',
            'url': 'https://ark.fandom.com/wiki/Brute_X-Megalodon', 'id': 147, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/86/Brute_X-Megalodon.png',
            'description': "“\nSpecies\nCarcharodon ultramegalodon\nTime\nMiocene-Pliocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWere it not restricted to the waters, Carcharodon ultramegalodon would be one of the most dangerous creatures on the island. As powerful and dangerous as the Tyrannosaurus is on land, Megalodon is near its equal in the water. In addition, it has a speed advantage over any non-aquatic creature when submerged. Megalodons need large quantities of food to sustain themselves, so they attack most creatures immediately on sight. Smaller fish are the sole exception I've seen; I believe this is because they cost more energy for Megalodons to catch than the predator would gain.\nDomesticated\nHaving access to the resources and treasures hidden deep within the ocean is near impossible without a domesticated sea creature. The Megalodon, though difficult to domesticate, proves to be very useful when exploring the deep sea. It's not the most efficient swimmer but it should be able to protect your cargo should you find yourself in a hostile encounter.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Brute X-Mosasaurus', 'name_tag': 'Mosasaur', 'entity_id': 'Ocean_Mosa_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Ocean/Ocean_Mosa_Character_BP_Hunt.Ocean_Mosa_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d5/Dossier_Mosasaurus.png',
            'url': 'https://ark.fandom.com/wiki/Brute_X-Mosasaurus', 'id': 148, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Brute_X-Mosasaurus.png',
            'description': '“\nSpecies\nMosasaurus suspirita\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUntil recently, I believed the Megalodon to be the greatest of the ocean predators. Then I discovered Mosasaurus suspirita in the deeps. Not quite as fast, but much larger and stronger, the Mosasaurus rules the darkest waters of the Island. Growing up to 50 feet long, Mosasaurus is larger than almost every other aquatic creature I\'ve encountered thus far. Mosasaurus is a deep-sea marine lizard which spends all of its time far beneath the water\'s surface. It is without a doubt one of the most fearsome creatures of the Island, and can certainly be considered among the ocean\'s apex predators.\nDomesticated\nMosasaur has proven to be an excellent tame for the most advanced tribes. Due to its sheer size and power, you will often find tribes with bases and defenses built upon a Mosasaur\'s large "platform" saddle. Having one with you as an escort is probably one of the best oceanic defenses available!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Brute X-Raptor', 'name_tag': 'Raptor', 'entity_id': 'Bog_Raptor_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Bog/Bog_Raptor_Character_BP_Hunt.Bog_Raptor_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
            'url': 'https://ark.fandom.com/wiki/Brute_X-Raptor', 'id': 149, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/Brute_X-Raptor.png',
            'description': '“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Brute X-Rex', 'name_tag': 'Rex', 'entity_id': 'Volcano_Rex_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Volcanic/Volcano_Rex_Character_BP_Hunt.Volcano_Rex_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
            'url': 'https://ark.fandom.com/wiki/Brute_X-Rex', 'id': 150, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/df/Brute_X-Rex.png',
            'description': '“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Brute X-Rock Elemental', 'name_tag': 'RockElemental',
            'entity_id': 'Volcano_Golem_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Volcanic/Volcano_Golem_Character_BP_Hunt.Volcano_Golem_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Rock_Elemental.png',
            'url': 'https://ark.fandom.com/wiki/Brute_X-Rock_Elemental', 'id': 151,
            'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fc/Brute_X-Rock_Elemental.png',
            'description': "“\nSpecies\nColossus petram\nTime\nUnknown\nDiet\nMinerals\nTemperament\nExtremely Territorial\nWild\nColossus petram is like no creature I have ever encountered. There is no biological or historical precedent for it. Its nearest relatives exist only in legend – mythical statues that could come to life like the Golem of Prague. That makes it all the more dangerous. What survivor could possibly expect a seemingly benign rock formation to suddenly spring to life and attack them? Fortunately, Colossus petram's massive size makes it quite slow, so I would advise most survivors to flee immediately if encountering it in the wild. Colossus petram survives by slowly absorbing nearby minerals while in its dormant state, which consequently means that its body contains a wealth of metal ingots. If undisturbed, it can maintain this hibernation ad infinitum, but it will viciously attack anyone who encroaches upon its territory. A solitary creature, Colossus petram lives alone, and will not even protect its own kind.\nDomesticated\nIf somehow tamed, Colossus petram could prove to be an invaluable asset, particularly in a siege. Only armor piercing rounds or explosives can harm it at all, and it will handily smash through stone structures.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Brute X-Spino', 'name_tag': 'Spino', 'entity_id': 'Bog_Spino_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Bog/Bog_Spino_Character_BP_Hunt.Bog_Spino_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Spino.png',
            'url': 'https://ark.fandom.com/wiki/Brute_X-Spino', 'id': 152, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Brute_X-Spino.png',
            'description': "“\nSpecies\nSpinosaurus aquareliga\nTime\nEarly-Late Cretaceous\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nAmong the few carnivores on the Island that can match Tyrannosaurs in size, Spinosaurus aquareliga does not match its ferocity. Spinosaurus' four legs and large sail make it fairly swift on land and incredibly fast in the water. Its marvel is, arguably, the ability to change stances by going from quadruped to biped. The creature is visually distinguished by its spectacular sail. In my travels I have seen many different and brightly coloured sails, as every Spinosaurus appears to have a slightly different palette. The one comforting fact about Spinosaurus is that it seems more at home near water than away from it. Although the creature is more powerful, faster, agile, and insatiable while in water, it tends to become less hostile as it gets farther from it. On one occasion, I only escaped a Spinosaurus by getting far enough from its lake home to make it simply lose interest.\nDomesticated\nSpinosaurus is an incredibly well-rounded apex carnivore. Faster than a Tyrannosaurus in water and able to travel on land unlike a Megalodon, its all-terrain versatility may be unrivaled. Although its movement speed is slower in a biped stance, it gains considerable attacking strength and mobility in this form. For hunters who wish to have a well-rounded mount, Spinosaurus may be the ideal choice -- if they can acquire one.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Brute X-Yutyrannus', 'name_tag': 'Yutyrannus',
            'entity_id': 'Snow_Yutyrannus_Character_BP_Hunt_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Hunt/Arctic/Snow_Yutyrannus_Character_BP_Hunt.Snow_Yutyrannus_Character_BP_Hunt\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Dossier_Yutyrannus.png',
            'url': 'https://ark.fandom.com/wiki/Brute_X-Yutyrannus', 'id': 153,
            'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/05/Brute_X-Yutyrannus.png',
            'description': '“\nSpecies\nYutyrannus saevus\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThe Yutyrannus saevus is believed to be related to the Tyrannosaurus rex, but it is noticeably different upon first glance. Feathered creatures are not necessarily viewed as dangerous predators in the same light as other theropods. However, the Yutyrannus strikes fear into even the Island\'s most skilled hunters. There are few wild predators that are able to pack-hunt alongside the generally hostile Carnotaurus, like the Yutyrannus does, with such ease. It is also the only creature I\'ve seen to consistently induce a state of panic in opponents with its roar. Upon hearing it, most creatures in the area will flee for safety.\nDomesticated\nA domesticated Yutyrannus can be a powerful offensive or defensive addition to war parties. With its mighty roar, it can induce fear in opposing creatures. Meanwhile, Yutyrannus can be trained to develop a confidence-boosting Battle-Cry which counteracts enemy attempts to induce fear, while also bolstering the resolve of allies, and may even draw wild Carnotaurus to its aid. These unique "leadership" qualities make the Yutyrannus a versatile, and at times, a necessary creature to have on your side during large-scale confrontations!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Corrupted Avatar', 'name_tag': '?', 'entity_id': 'Bot_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/Bots/Bot_Character_BP.Bot_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fa/Corrupted_Avatar.png',
            'url': 'https://ark.fandom.com/wiki/Corrupted_Avatar', 'id': 154, 'category': 'Mammals',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7a/Corrupted_Avatar_Helmet_Skin_%28Genesis_Part_1%29.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Eel Minion', 'name_tag': None, 'entity_id': 'EelMinion_Character_BP_Easy_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/EelBoss/EelMinion_Character_BP_Easy.EelMinion_Character_BP_Easy\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Dossier_Electrophorus.png',
            'url': 'https://ark.fandom.com/wiki/Eel_Minion', 'id': 155, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a0/Electrophorus.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Gamma Corrupted Master Controller', 'name_tag': None, 'entity_id': 'VRMainBoss_Character_Easy_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/VRMainBoss/VRMainBoss_Character_Easy.VRMainBoss_Character_Easy\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Corrupted_Master_Controller_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Gamma_Corrupted_Master_Controller', 'id': 156, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Corrupted_Master_Controller.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Gamma Moeder, Master of the Ocean', 'name_tag': 'EelBoss',
            'entity_id': 'EelBoss_Character_BP_Easy_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/EelBoss/EelBoss_Character_BP_Easy.EelBoss_Character_BP_Easy\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b1/Genesis_17.jpg',
            'url': 'https://ark.fandom.com/wiki/Gamma_Moeder,_Master_of_the_Ocean', 'id': 157, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bd/Moeder%2C_Master_of_the_Ocean.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Golden Striped Brute Megalodon', 'name_tag': 'Mega',
            'entity_id': 'Ocean_Megalodon_Character_BP_Retrieve_Brute_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Retrieve/Ocean/Ocean_Megalodon_Character_BP_Retrieve_Brute.Ocean_Megalodon_Character_BP_Retrieve_Brute\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ea/Golden_Striped_Megalodon_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Golden_Striped_Brute_Megalodon',
            'id': 158, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9a/Golden_Striped_Brute_Megalodon.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Golden Striped Megalodon', 'name_tag': 'Mega',
            'entity_id': 'Ocean_Megalodon_Character_BP_Retrieve_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Retrieve/Ocean/Ocean_Megalodon_Character_BP_Retrieve.Ocean_Megalodon_Character_BP_Retrieve\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ea/Golden_Striped_Megalodon_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Golden_Striped_Megalodon', 'id': 159, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Golden_Striped_Megalodon.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Ferox (Large)', 'name_tag': 'Bigly', 'entity_id': 'Shapeshifter_Large_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/Shapeshifter/Shapeshifter_Large/Shapeshifter_Large_Character_BP.Shapeshifter_Large_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2b/Ferox_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Ferox_(Large)', 'id': 160, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Ferox.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Ferox', 'name_tag': 'Gremlin', 'entity_id': 'Shapeshifter_Small_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/Shapeshifter/Shapeshifter_Small/Shapeshifter_Small_Character_BP.Shapeshifter_Small_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2b/Ferox_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Ferox', 'id': 161, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Ferox.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Injured Brute Reaper King', 'name_tag': 'Xenomorph',
            'entity_id': 'Xenomorph_Character_BP_Male_InitialBuryOnly_Brute_Retrieve_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Retrieve/Lunar/Xenomorph_Character_BP_Male_InitialBuryOnly_Brute_Retrieve.Xenomorph_Character_BP_Male_InitialBuryOnly_Brute_Retrieve\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/Injured_Brute_Reaper_King',
            'id': 162, 'category': 'Brute Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/44/Injured_Brute_Reaper_King.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Insect Swarm', 'name_tag': 'InsectSwarm', 'entity_id': 'InsectSwarmChar_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/Swarms/InsectSwarmChar_BP.InsectSwarmChar_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Genesis_29.jpg',
            'url': 'https://ark.fandom.com/wiki/Insect_Swarm', 'id': 163, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a7/Insect_Swarm.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Magmasaur', 'name_tag': 'LavaLizard', 'entity_id': 'Cherufe_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/Cherufe/Cherufe_Character_BP.Cherufe_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Magmasaur_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Magmasaur', 'id': 164, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/35/Magmasaur.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Malfunctioned Tek Giganotosaurus Gauntlet', 'name_tag': 'Gigant',
            'entity_id': 'BionicGigant_Character_BP_Malfunctioned_Gauntlet_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/MissionVariants/Gauntlet/Lunar/BionicGigant_Character_BP_Malfunctioned_Gauntlet.BionicGigant_Character_BP_Malfunctioned_Gauntlet\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Malfunctioned_Tek_Giganotosaurus', 'id': 165,
            'category': 'Malfunctioned Tek Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Giganotosaurus.png',
            'description': '“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Malfunctioned Tek Giganotosaurus', 'name_tag': 'Gigant',
            'entity_id': 'BionicGigant_Character_BP_Malfunctioned_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Giganotosaurus/BionicGigant_Character_BP_Malfunctioned.BionicGigant_Character_BP_Malfunctioned\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Malfunctioned_Tek_Giganotosaurus', 'id': 166,
            'category': 'Malfunctioned Tek Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Giganotosaurus.png',
            'description': '“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Malfunctioned Tek Parasaur', 'name_tag': 'Para',
            'entity_id': 'BionicPara_Character_BP_Malfunctioned_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Para/BionicPara_Character_BP_Malfunctioned.BionicPara_Character_BP_Malfunctioned\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Dossier_Parasaur.png',
            'url': 'https://ark.fandom.com/wiki/Malfunctioned_Tek_Parasaur',
            'id': 167, 'category': 'Malfunctioned Tek Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Parasaur.png',
            'description': "“\nSpecies\nParasaurolophus amphibio\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nParasaurolophus amphibio has one of the more interesting adaptations of any creature I've seen on the Island. Like all Parasaur, it has a signature crest on its head. Very docile at first, I've been able to approach the creature without disturbing it. If startled, however, the creature can vocalize a distress call to the surrounding area that warns of danger. Parasaurolophus appears to be low on the food chain and is hunted by everything, creatures and humans alike, which explains its skittish nature. It is a good source of meat and hide, if you can manage to keep up with it long enough to kill it.\nDomesticated\nDespite being what most tribes consider a relatively useless creature to tame, I once met an interesting woman who had tamed an entire herd of them. She informed me that many overlooked the creature's potential. She even graciously gifted me a fancy saddle to put on my own Parasaurolophus one day. As a relatively simple creature to domesticate, Parasaurolophus is commonly one of the first mounts a tribe will be able to acquire. Its ability to run relatively fast for lengthy intervals makes it a solid mode of medium-range transportation, though it has almost no ability to defend itself or its rider in a traditional sense. Smaller creatures, however, appear to be frightened by the horn of Parasaurolophus although it doesn't do much damage. It also has decent weight-bearing capabilities, which could prove useful for nomadic tribes as they work to establish a presence on the Island.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Malfunctioned Tek Quetzal', 'name_tag': 'Quetz',
            'entity_id': 'BionicQuetz_Character_BP_Malfunctioned_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Quetzalcoatlus/BionicQuetz_Character_BP_Malfunctioned.BionicQuetz_Character_BP_Malfunctioned\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9d/Quetzal.png',
            'url': 'https://ark.fandom.com/wiki/Malfunctioned_Tek_Quetzal', 'id': 168,
            'category': 'Malfunctioned Tek Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Mod_Primal_Fear_Tek_Quetzal_Icon_Image.png',
            'description': "“\nSpecies\nQuetzalcoatlus conchapicem\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nFrom afar, it's hard to believe that Quetzalcoatlus is one of the largest avians on the island. It shares a similar silhouette with the Pteranodon, and nests near the absolute highest peaks. Upon closer inspection, though, Quetzalcoatlus is an enormous creature of tremendous power. I find it strange that such a large, imposing beast would be so skittish. Unlike other creatures of its size, it is more likely to flee than fight. I suppose the decision to flee from any trouble keeps the species alive on an island with so many dangerous predators. But then how does it eat enough to sustain its massive size?\nDomesticated\nTamed Quetzalcoatlus have a very specific role on the island. Too slow to be an efficient local transport, and too weak to be an effective warbird, the tribes I have encountered tend to employ it as a mass carrier. Quetzalcoatlus is primarily used by these masters of the skies to safely carry vast quantities of supplies, creatures and human cargo from one base to another without tiring.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Malfunctioned Tek Raptor', 'name_tag': 'Raptor',
            'entity_id': 'BionicRaptor_Character_BP_Malfunctioned_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Raptor/BionicRaptor_Character_BP_Malfunctioned.BionicRaptor_Character_BP_Malfunctioned\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/45/Mod_Primal_Fear_Primal_Tek_Raptor.jpg',
            'url': 'https://ark.fandom.com/wiki/Malfunctioned_Tek_Raptor', 'id': 169,
            'category': 'Malfunctioned Tek Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Mod_Primal_Fear_Tek_Raptor_Icon_Image.png',
            'description': '“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Malfunctioned Tek Rex', 'name_tag': 'Rex', 'entity_id': 'BionicRex_Character_BP_Malfunctioned_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Rex/BionicRex_Character_BP_Malfunctioned.BionicRex_Character_BP_Malfunctioned\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d8/Tek_Rex_PaintRegion5.png',
            'url': 'https://ark.fandom.com/wiki/Malfunctioned_Tek_Rex', 'id': 170,
            'category': 'Malfunctioned Tek Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Rex.png',
            'description': '“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Malfunctioned Tek Stegosaurus', 'name_tag': 'Stego',
            'entity_id': 'BionicStego_Character_BP_Malfunctioned_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Stego/BionicStego_Character_BP_Malfunctioned.BionicStego_Character_BP_Malfunctioned\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/16/Dossier_Stegosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Malfunctioned_Tek_Stegosaurus', 'id': 171,
            'category': 'Malfunctioned Tek Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Stegosaurus.png',
            'description': "“\nSpecies\nStegosaurus regium\nTime\nLate Jurassic\nDiet\nHerbivore\nTemperament\nDocile\nWild\nStegosaurus regium has approximately 16 paired rows of plates along its back, flanked by another, smaller pair of 6 plates. This is contrary to the alternating rows on Stegosaurus fossils I've seen in museums. Not surprisingly, Stegosaurus uses the spines on its tail to defend itself. While not aggressive, Stegosaurus will come to the aid of another nearby Stegosaurus. This implies it to be a herd animal.\nDomesticated\nStegosaurus is commonly used as a safe way to transport large quantities of goods. And once you saddle one up, not even an Argentavis could knock you off that perch. A stegosaurus can be trained to flex its back plates for different purposes: hardened to shield it from attack, in a heavier alignment that deals crippling blows, or oriented more sharply to pierce armor. These various plate configurations also come in handy for stripping wood from trees, gathering thatch, or foraging for wild berries, respectively. Stegosaurus can knock back or impale with a whip of its spiky tail, keeping predators at bay or pinning them in place. Its spiked appendage also helps for gathering berries—go figure.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Malfunctioned Tek Triceratops', 'name_tag': 'Trike',
            'entity_id': 'BionicTrike_Character_BP_Malfunctioned_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Trike/BionicTrike_Character_BP_Malfunctioned.BionicTrike_Character_BP_Malfunctioned\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Mod_Primal_Fear_Primal_Tek_Trike.jpg',
            'url': 'https://ark.fandom.com/wiki/Malfunctioned_Tek_Triceratops',
            'id': 172, 'category': 'Malfunctioned Tek Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
            'description': "“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Megachelon', 'name_tag': 'GiantTurtle', 'entity_id': 'GiantTurtle_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/GiantTurtle/GiantTurtle_Character_BP.GiantTurtle_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/48/Genesis_3.jpg',
            'url': 'https://ark.fandom.com/wiki/Megachelon', 'id': 173, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a4/Megachelon.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Parakeet Fish School', 'name_tag': 'Swarm', 'entity_id': 'MicrobeSwarmChar_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/Swarms/MicrobeSwarmChar_BP.MicrobeSwarmChar_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b7/Parakeet_Fish_School_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Parakeet_Fish_School', 'id': 174, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c4/Parakeet_Fish_School.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Reaper Prince', 'name_tag': 'Xenomorph',
            'entity_id': 'Xenomorph_Character_BP_Male_InitialBuryOnly_Adolescent_C',
            'blueprint': '"Blueprint\'/Game/Aberration/Dinos/Nameless/Xenomorph_Character_BP_Male_InitialBuryOnly_Adolescent.Xenomorph_Character_BP_Male_InitialBuryOnly_Adolescent\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/Reaper_Prince', 'id': 175,
            'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
            'description': "“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Tek Triceratops', 'name_tag': 'Trike', 'entity_id': 'BionicTrike_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Trike/BionicTrike_Character_BP.BionicTrike_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cd/Mod_Primal_Fear_Primal_Tek_Trike.jpg',
            'url': 'https://ark.fandom.com/wiki/Tek_Triceratops', 'id': 176, 'category': 'Tek Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
            'description': "“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Allosaurus', 'name_tag': 'Allo', 'entity_id': 'Volcano_Allo_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Volcano_Allosaurus/Volcano_Allo_Character_BP.Volcano_Allo_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Allosaurus.png',
            'url': 'https://ark.fandom.com/wiki/X-Allosaurus', 'id': 177, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Allosaurus.png',
            'description': "“\nSpecies\nAllosaurus therotribus\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmaller but faster than Tyrannosaurus, larger but slower than Carnotaurus, Allosaurus therotribus is the island's resident pack-hunting theropod. While most aggressive theropods are relatively solitary creatures, Allosaurus lives in groups of 3. One Allosaurus is the alpha, while the others are its mates or a beta male. Like humans find value in forming a tribe, the Allosaurus has evolved to hunt in packs. Its saw-shaped teeth leave its prey bleeding and maimed, making escape difficult. Once an Allosaurus slows a creature with its cutting bite, the rest of its pack quickly closes in for the kill.\nDomesticated\nNot everyone thinks a tamed Allosaurus is ideal. Those who appreciate speed generally tame Carnotaurus, while those who value raw stopping power tame Tyrannosaurus. However, riders of Allosaurus tend to respect the utility of its Alpha pack status, which along with its bleed-inducing attacks and relative mobility, can effectively turn the tide of a combined arms battle.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Ankylosaurus', 'name_tag': 'Anky', 'entity_id': 'Volcano_Ankylo_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Volcano_Ankylosaurus/Volcano_Ankylo_Character_BP.Volcano_Ankylo_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8e/Dossier_Ankylosaurus.png',
            'url': 'https://ark.fandom.com/wiki/X-Ankylosaurus', 'id': 178, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a7/Ankylosaurus.png',
            'description': "“\nSpecies\nAnkylosaurus crassacutis\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nDocile\nWild\nUnlike many of the herd animals on the Island, Ankylosaurus crassacutis tends to live in small family units. I believe they can afford to stick with smaller groups because of their incredibly thick skin, for which they're named. Despite not being among the largest of the Island's herbivores, Ankylosaurus is one of the more difficult creatures to take down. Its thick, armored skin seems to make it more than a match for several of the mid-sized predators that would otherwise hunt it. Reckless carnivores are just as likely to hurt themselves on Ankylosaurus' spikes, as they are to get hit by its tail.\nDomesticated\nWithout a doubt, the best trait of a trained Ankylosaurus is its enormously dense tail. This tail is powerful enough to quickly shatter the resource-laden rocks of the Island. One of the wealthier human tribes on the island utilizes a squad of Ankylosaurs in its mines and quarries. The creature's affinity for metal enables it to carry raw ore at an effectively reduced weight.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Argentavis', 'name_tag': 'Argent', 'entity_id': 'Snow_Argent_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Snow_Argentavis/Snow_Argent_Character_BP.Snow_Argent_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Dossier_Argentavis.png',
            'url': 'https://ark.fandom.com/wiki/X-Argentavis', 'id': 179, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Argentavis.png',
            'description': "“\nSpecies\nArgentavis atrocollum\nTime\nLate Miocene\nDiet\nCarrion-Feeder\nTemperament\nShort-Tempered\nWild\nLording over the skies across the Island, Argentavis atrocollum has few aerial rivals. It is a small consolation for the Island's other avian creatures, then, that Argentavis seems to have little interest in anything alive. Quite apart from what I would have guessed, Argentavis does not have the stooped neck typical of modern buzzards and vultures. I don't know if it adapted this stronger neck to deal with the predators on the Island, or if its lineage derives from before the stooped neck became common in carrion-eating birds. Whichever it meant to be, it has enabled Argentavis to carry smaller creatures with its beak.\nDomesticated\nArgentavis is actually slower than the Island's far more common Pteranodon, but it possesses significantly more stamina and can sustain flight for approximately three times as long. Its weighty stature, in comparison to the Pteranodon, allows it to utilize its talons to support the weight of an additional passenger. Considering its saddle doubles as a mobile crafting station, it makes Argentavis an excellent creature for traveling and hauling cargo over long distances.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Basilosaurus', 'name_tag': 'Basilosaurus', 'entity_id': 'Ocean_Basilosaurus_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Ocean_Basilosaurus/Ocean_Basilosaurus_Character_BP.Ocean_Basilosaurus_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Dossier_Basilosaurus.png',
            'url': 'https://ark.fandom.com/wiki/X-Basilosaurus', 'id': 180, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Basilosaurus.png',
            'description': '“\nSpecies\nBasilosaurus solatiumfecit\nTime\nLate Eocene\nDiet\nPiscivore\nTemperament\nPassive\nWild\nOne of the stranger creatures in the waters surrounding the Island is Basilosaurus solatiumfecit. It\'s a powerful swimmer which has adapted to the shallows so remarkably well that it rapidly recovers from injuries when near the water\'s surface. Conversely, it\'s vulnerable to deep water pressure, which slowly causes it harm. Basilosaurus is usually closely followed by other predatory creatures, as its eating habits leave plenty of scraps for scavengers to consume. It is a gentle creature towards humans and happily laps up food directly from them. However, the creatures that trail the "Basi" tend to become dangerously enraged whenever this occurs, as it leaves no leftovers for them.\nDomesticated\nDespite the hassle of engaging with its ornery followers, many tribes still attempt to tame the Basilosaurus, as its mammalian, warm-blooded circulation provides a rider with perfect comfort from both heat and cold. Being apprehensive in nature, Basilosaurus is equipped with a defense mechanism that prevents it from being stunned or shocked. Alternatively, Basilosaurus is hunted (perhaps too vigorously) for its special blubber, which can be efficiently refined into gasoline!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'X-Dunkleosteus', 'name_tag': 'Dunkle', 'entity_id': 'Ocean_Dunkle_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Ocean_Dunkleosteus/Ocean_Dunkle_Character_BP.Ocean_Dunkle_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3d/Dossier_Dunkleosteus.png',
            'url': 'https://ark.fandom.com/wiki/X-Dunkleosteus', 'id': 181, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e5/Dunkleosteus.png',
            'description': "“\nSpecies\nDunkleosteus loricaruptor\nTime\nLate Devonian\nDiet\nCarnivore\nTemperament\nDocile\nWild\nDunkleosteus loricaruptor is a very strange creature. It is a fairly large fish, covered head to tail in armored plates, with incredibly powerful jaws. It tends to eat the Island's water-dwelling crustaceans trawling the seabed, as it is not fast enough to catch most of the smaller fish. Dunkleosteus is surprisingly combat-oriented for a fish. Its well-armored body protects it from many creatures, while its bite is strong enough to easily crush through chitinous shells.\nDomesticated\nDunkleosteus is an incredibly useful fish for coastal communities. Its powerful jaws make short work of the stone and oil formations found throughout the oceanic depths. While harvesting, Dunkleosteus can defend its rider from all but the largest threats in the waters. And once it is past its prime, the Dunkleosteus itself can be harvested for a fair amount of chitin.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Ichthyosaurus', 'name_tag': 'Dolphin', 'entity_id': 'Ocean_Dolphin_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Ocean_Dolphin/Ocean_Dolphin_Character_BP.Ocean_Dolphin_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/79/Dossier_Ichthyosaurus.png',
            'url': 'https://ark.fandom.com/wiki/X-Ichthyosaurus', 'id': 182, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/89/Ichthyosaurus.png',
            'description': '“\nSpecies\nIchthyosaurus curiosa\nTime\nLate Triassic - Early Jurassic\nDiet\nCarnivore\nTemperament\nCurious\nWild\nIchthyosaurus curiosa is a comparatively small carnivore found in the waters around the island. It is slightly larger than a human, but that’s still small compared to the leviathans roaming these waters. It seems to be very interested in any creature around its size, often approaching and following humans swimming through its waters. Despite its appearance, the Ichthyosaurus is neither a fish nor an ocean mammal. Like many creatures in the waters around the island, it is actually an aquatic reptile.\nDomesticated\nI can’t think of a better mount for someone starting to explore the island’s seas and waterways. Ichthyosaurus is comparatively fast swimmer, and even in the wild will cozy right up to you and try to figure out what you’re doing. Taming these is actually pretty easy, as they seem to love humans and will be fed and tamed without the use of violence.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'X-Megalodon', 'name_tag': 'Mega', 'entity_id': 'Ocean_Megalodon_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Ocean_Megalodon/Ocean_Megalodon_Character_BP.Ocean_Megalodon_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Dossier_Megalodon.png',
            'url': 'https://ark.fandom.com/wiki/X-Megalodon', 'id': 183, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Megalodon.png',
            'description': "“\nSpecies\nCarcharodon ultramegalodon\nTime\nMiocene-Pliocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWere it not restricted to the waters, Carcharodon ultramegalodon would be one of the most dangerous creatures on the island. As powerful and dangerous as the Tyrannosaurus is on land, Megalodon is near its equal in the water. In addition, it has a speed advantage over any non-aquatic creature when submerged. Megalodons need large quantities of food to sustain themselves, so they attack most creatures immediately on sight. Smaller fish are the sole exception I've seen; I believe this is because they cost more energy for Megalodons to catch than the predator would gain.\nDomesticated\nHaving access to the resources and treasures hidden deep within the ocean is near impossible without a domesticated sea creature. The Megalodon, though difficult to domesticate, proves to be very useful when exploring the deep sea. It's not the most efficient swimmer but it should be able to protect your cargo should you find yourself in a hostile encounter.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Mosasaurus', 'name_tag': 'Mosasaur', 'entity_id': 'Ocean_Mosa_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Ocean_Mosasaurus/Ocean_Mosa_Character_BP.Ocean_Mosa_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d5/Dossier_Mosasaurus.png',
            'url': 'https://ark.fandom.com/wiki/X-Mosasaurus', 'id': 184, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Mosasaurus.png',
            'description': '“\nSpecies\nMosasaurus suspirita\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUntil recently, I believed the Megalodon to be the greatest of the ocean predators. Then I discovered Mosasaurus suspirita in the deeps. Not quite as fast, but much larger and stronger, the Mosasaurus rules the darkest waters of the Island. Growing up to 50 feet long, Mosasaurus is larger than almost every other aquatic creature I\'ve encountered thus far. Mosasaurus is a deep-sea marine lizard which spends all of its time far beneath the water\'s surface. It is without a doubt one of the most fearsome creatures of the Island, and can certainly be considered among the ocean\'s apex predators.\nDomesticated\nMosasaur has proven to be an excellent tame for the most advanced tribes. Due to its sheer size and power, you will often find tribes with bases and defenses built upon a Mosasaur\'s large "platform" saddle. Having one with you as an escort is probably one of the best oceanic defenses available!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'X-Otter', 'name_tag': 'Otter', 'entity_id': 'Snow_Otter_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Snow_Otter/Snow_Otter_Character_BP.Snow_Otter_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/82/Dossier_Otter.png',
            'url': 'https://ark.fandom.com/wiki/X-Otter', 'id': 185, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9f/Otter.png',
            'description': '“\nSpecies\nLutra peloso\nTime\nEarly Miocene\nDiet\nOmnivore\nTemperament\nFriendly\nWild\nFound along the Island’s many inland waterways, Lutra Peloso have become exceptionally adept at hunting and foraging. This species of Otter has to be particularly cunning because of its diminutive size, and fierce competition for its preferred food source: fish. It is not a creature that excels at combat, and would not naturally pose an intimidating threat to any predators. Finding packs of river Otters is simple enough: They are distinguished by their elongated bodies, bushy tails, and webbed feet. Their trusting and inquisitive nature ensures they are often hunted for their lustrous fur, but many prefer to tame them to become trusted companions.\nDomesticated\nThere are few creatures which provide the companionship that Lutra Peloso does. Rather than traveling beside you, it would prefer to comfortably rest on your back, providing insulation. Once domesticated, it can be told to harvest fish on demand, with a specific goal in mind from the fish that it consumes, the otter has a knack for foraging silica pearls, and can even yield a slight chance at finding black pearls within!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'X-Paraceratherium', 'name_tag': 'Paracer', 'entity_id': 'Bog_Paracer_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/BogParaceratherium/Bog_Paracer_Character_BP.Bog_Paracer_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Dossier_Paraceratherium.png',
            'url': 'https://ark.fandom.com/wiki/X-Paraceratherium', 'id': 186, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e1/Paraceratherium.png',
            'description': '“\nSpecies\nParaceratherium gigamicus\nTime\nOligocene\nDiet\nHerbivore\nTemperament\nDocile\nWild\nParaceratherium gigamicus is a massive, long-necked herbivore that inhabits some of the Island\'s grasslands. It resembles a gigantic horse/rhinoceros hybrid, but is over twice the size of either. Paraceratherium is a very peaceful and friendly creature. Barring some surprises yet in store for me, I can safely say that Paraceratherium is among the largest mammals on the Island. While its size means that Paraceratherium can provide an incredible amount of food, it also makes it dangerous when hunted.\nDomesticated\nA beast of burden second to the Brontosaurus, Paraceratherium is an excellent worker, and is sufficient in size to support a "platform" saddle upon which structures can be built. It is a naturally friendly animal, and is not afraid of humans. However, despite its normally calm demeanor, when it or its owner is provoked by aggression, the Paraceratherium can quickly become a real threat to the attacker and will use its girth to its advantage in combat.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'X-Parasaur', 'name_tag': 'Para', 'entity_id': 'Bog_Para_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/BogPara/Bog_Para_Character_BP.Bog_Para_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Dossier_Parasaur.png',
            'url': 'https://ark.fandom.com/wiki/X-Parasaur', 'id': 187, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Parasaur.png',
            'description': "“\nSpecies\nParasaurolophus amphibio\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nParasaurolophus amphibio has one of the more interesting adaptations of any creature I've seen on the Island. Like all Parasaur, it has a signature crest on its head. Very docile at first, I've been able to approach the creature without disturbing it. If startled, however, the creature can vocalize a distress call to the surrounding area that warns of danger. Parasaurolophus appears to be low on the food chain and is hunted by everything, creatures and humans alike, which explains its skittish nature. It is a good source of meat and hide, if you can manage to keep up with it long enough to kill it.\nDomesticated\nDespite being what most tribes consider a relatively useless creature to tame, I once met an interesting woman who had tamed an entire herd of them. She informed me that many overlooked the creature's potential. She even graciously gifted me a fancy saddle to put on my own Parasaurolophus one day. As a relatively simple creature to domesticate, Parasaurolophus is commonly one of the first mounts a tribe will be able to acquire. Its ability to run relatively fast for lengthy intervals makes it a solid mode of medium-range transportation, though it has almost no ability to defend itself or its rider in a traditional sense. Smaller creatures, however, appear to be frightened by the horn of Parasaurolophus although it doesn't do much damage. It also has decent weight-bearing capabilities, which could prove useful for nomadic tribes as they work to establish a presence on the Island.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Raptor', 'name_tag': 'Raptor', 'entity_id': 'Bog_Raptor_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Bog_Raptor/Bog_Raptor_Character_BP.Bog_Raptor_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
            'url': 'https://ark.fandom.com/wiki/X-Raptor', 'id': 188, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/08/Raptor.png',
            'description': '“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'X-Rex', 'name_tag': 'Rex', 'entity_id': 'Volcano_Rex_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Volcano_Rex/Volcano_Rex_Character_BP.Volcano_Rex_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
            'url': 'https://ark.fandom.com/wiki/X-Rex', 'id': 189, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Rex.png',
            'description': '“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'X-Rock Elemental', 'name_tag': 'RockElemental', 'entity_id': 'Volcano_Golem_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Lava_Golem/Volcano_Golem_Character_BP.Volcano_Golem_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Dossier_Rock_Elemental.png',
            'url': 'https://ark.fandom.com/wiki/X-Rock_Elemental', 'id': 190, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f0/Rock_Elemental.png',
            'description': "“\nSpecies\nColossus petram\nTime\nUnknown\nDiet\nMinerals\nTemperament\nExtremely Territorial\nWild\nColossus petram is like no creature I have ever encountered. There is no biological or historical precedent for it. Its nearest relatives exist only in legend – mythical statues that could come to life like the Golem of Prague. That makes it all the more dangerous. What survivor could possibly expect a seemingly benign rock formation to suddenly spring to life and attack them? Fortunately, Colossus petram's massive size makes it quite slow, so I would advise most survivors to flee immediately if encountering it in the wild. Colossus petram survives by slowly absorbing nearby minerals while in its dormant state, which consequently means that its body contains a wealth of metal ingots. If undisturbed, it can maintain this hibernation ad infinitum, but it will viciously attack anyone who encroaches upon its territory. A solitary creature, Colossus petram lives alone, and will not even protect its own kind.\nDomesticated\nIf somehow tamed, Colossus petram could prove to be an invaluable asset, particularly in a siege. Only armor piercing rounds or explosives can harm it at all, and it will handily smash through stone structures.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Sabertooth', 'name_tag': 'Sabertooth', 'entity_id': 'Snow_Saber_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Snow_Saber/Snow_Saber_Character_BP.Snow_Saber_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Dossier_Sabertooth.png',
            'url': 'https://ark.fandom.com/wiki/X-Sabertooth', 'id': 191, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a4/Sabertooth.png',
            'description': "“\nSpecies\nSmilodon brutalis\nTime\nEarly Pleistocene/Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmilodon brutalis is a solitary hunter, generally found in cold, lightly wooded areas. The Island's mountains are the perfect habitat, as the mammal's fur keeps it safe from the bitter temperature. While its huge fangs are excellent for delivering deathblows, the creature's claws can be just as deadly. Despite normally being a solitary creature, Smilodon brutalis are not opposed to hunting in small packs. In fact, they have to do this to take down larger prey such as Mammoths. Enough Sabertooths can take down a Carnotaurus, perhaps even a Tyrannosaurus. Either way, Smilodon brutalis should not be underestimated.\nDomesticated\nWhile not as fast as Raptors, there's no denying the Sabertooth's increased resilience and power. In addition, well-trained Sabertooth can be taught to use their claws to flay corpses. This may sound morbid, but it is among the best ways to quickly gather large quantities of hide from the giant beasts of the Island.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Sabertooth Salmon', 'name_tag': 'Salmon', 'entity_id': 'Lunar_Salmon_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Lunar_Salmon/Lunar_Salmon_Character_BP.Lunar_Salmon_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0c/Dossier_Sabertooth_Salmon.png',
            'url': 'https://ark.fandom.com/wiki/X-Sabertooth_Salmon', 'id': 192, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e0/Salmon.png',
            'description': '“\nSpecies\nOncorhynchus grexlamia\nTime\nLate Miocene - Mid Pleistocene\nDiet\nCarnivore\nTemperament\nEvasive, Aggressive when attacked\nWild\nFairly unremarkable by the Island\'s standards, Oncorhynchus grexlamia is a generally passive fish. Its main form of protection is swimming in a large school. Oncorhynchus does not like conflict, and generally swims away from anything larger than itself at very high speeds. Once provoked, however, Oncorhynchus becomes quite aggressive, along with its nearby brethren. It locks onto its prey with its long "saberteeth" and begins draining that creature\'s blood. This loss of blood is not too dangerous alone, but when a school of Oncorhynchus attack at once, their target quickly loses speed and stamina from blood loss, drowning if it cannot breath underwater.\nDomesticated\nLike many of the smaller fish found on or around the Island, Oncorhynchus cannot be tamed, but it is often herded and harvested for its resources. In particular, certain cuts of Oncorhynchus meat are considered to have superb quality, and are often referred to as "Prime Fish" used for specific high-end concoctions and taming the Island\'s many piscivorous creatures.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'X-Spino', 'name_tag': 'Spino', 'entity_id': 'Bog_Spino_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Bog_Spino/Bog_Spino_Character_BP.Bog_Spino_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/73/Dossier_Spino.png',
            'url': 'https://ark.fandom.com/wiki/X-Spino', 'id': 193, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/03/Spino.png',
            'description': "“\nSpecies\nSpinosaurus aquareliga\nTime\nEarly-Late Cretaceous\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nAmong the few carnivores on the Island that can match Tyrannosaurs in size, Spinosaurus aquareliga does not match its ferocity. Spinosaurus' four legs and large sail make it fairly swift on land and incredibly fast in the water. Its marvel is, arguably, the ability to change stances by going from quadruped to biped. The creature is visually distinguished by its spectacular sail. In my travels I have seen many different and brightly coloured sails, as every Spinosaurus appears to have a slightly different palette. The one comforting fact about Spinosaurus is that it seems more at home near water than away from it. Although the creature is more powerful, faster, agile, and insatiable while in water, it tends to become less hostile as it gets farther from it. On one occasion, I only escaped a Spinosaurus by getting far enough from its lake home to make it simply lose interest.\nDomesticated\nSpinosaurus is an incredibly well-rounded apex carnivore. Faster than a Tyrannosaurus in water and able to travel on land unlike a Megalodon, its all-terrain versatility may be unrivaled. Although its movement speed is slower in a biped stance, it gains considerable attacking strength and mobility in this form. For hunters who wish to have a well-rounded mount, Spinosaurus may be the ideal choice -- if they can acquire one.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Tapejara', 'name_tag': 'Tapejara', 'entity_id': 'Bog_Tapejara_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Bog_Tapejara/Bog_Tapejara_Character_BP.Bog_Tapejara_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Tapejara.png',
            'url': 'https://ark.fandom.com/wiki/X-Tapejara', 'id': 194, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Tapejara.png',
            'description': "“\nSpecies\nTapejara imperator\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nTapejara imperator is a marvel to watch in the wild. It has astonishing agility compared to the Island's other flyers thanks in large part to the rudder-like fin that extends from its snout to the back of its skull. Initially, I'd thought the fin was simply composed of keratin, but closer inspection has led me to believe that it is actually some kind of sensory organ. Not only does it decrease Tapejara's turning radius even at high speeds, but it apparently provides Tapejara with extra information to help it fly through the air with unparalleled grace. I've even seen Tapejara hover and strafe side-to-side in the air without moving forward at all. It's quite remarkable. The creature also makes effective use of razor-sharp claws to latch onto surfaces such as the trunks of tall trees, holding its position indefinitely.\nDomesticated\nWarlike tribes appear to consider Tapejara the equivalent of a versatile rotor aircraft, capable of rapid positional changes and aggressive agility. When domesticated the Tapejara is typically outfitted with a unique triple-rider saddle, enabling two passengers to wield handheld weaponry while the pilot takes the reins. When the Tapejara is latched onto a surface, both the passengers and pilot are able to make full use of their weapons together! Evidently what this skittering creature lacks in distance-stamina, constitution, and weight carrying capacity, it makes up for in maneuverability and combat versatility.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Triceratops', 'name_tag': 'Trike', 'entity_id': 'Volcano_Trike_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Volcano_Trike/Volcano_Trike_Character_BP.Volcano_Trike_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dd/Dossier_Triceratops.png',
            'url': 'https://ark.fandom.com/wiki/X-Triceratops', 'id': 195, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2d/Trike.png',
            'description': "“\nSpecies\nTriceratops styrax\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nShort-Tempered\nWild\nApparently a crossbreed of a Triceratops and Styracosaurus, Triceratops styrax has both the characteristic three-horned face of Triceratops and the prominent horned-ridge of Styracosaurus. Normally a very docile grazing animal, Triceratops becomes aggressive once angered. Triceratops will chase down would-be predators (and egg-stealers) with incredible prejudice. Running away from triceratops is harder than it seems due to its ability to charge and ram its target. I've seen Triceratops have an especially hostile reaction to the Tyrannosaurus, with herds attacking en masse. While not very fast, they are deadly in a group.\nDomesticated\nA common mount for those that ride dinosaurs, Triceratops doubles as pack animal and combat dinosaur. Triceratops' bony ridge works excellently as cover from frontal attack, and the dinosaur's charge is incredibly dangerous. It is largely protective of its kinds if its sense danger. In the presence of larger carnivores that appears as a threat, Triceratops becomes stronger and rallies the effort of its nearby species. It is also capable of harvesting a sizable amount of resources with its horns by shredding fruit from the leaves, making it a very useful work companion for smaller tribes.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'X-Woolly Rhino', 'name_tag': 'Rhino', 'entity_id': 'Snow_Rhino_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Snow_WoollyRhino/Snow_Rhino_Character_BP.Snow_Rhino_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3b/Dossier_Woolly_Rhino.png',
            'url': 'https://ark.fandom.com/wiki/X-Woolly_Rhino', 'id': 196, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d4/Woolly_Rhinoceros.png',
            'description': '“\nSpecies\nCoelodonta utiliserro\nTime\nLate Pliocene - Late Pleistocene\nDiet\nHerbivore\nTemperament\nFriendly\nWild\nCoelodonta utiliserro is a friendly herbivore, common to the tundra and grassland regions of the Island. It is a large and dangerous creature, though it seems fairly trusting of the fauna around it. Once attacked, Coelodonta begins charging towards its foe. It builds up momentum as it charges, and depending on its ultimate impact speed, the results can be terrifying. With enough room to charge, it can even skewer the largest creatures in just one gore! Despite how powerful Coelodonta are, many tribes still hunt them extensively due to their unique resources. Its horns can ground into a highly arousing powder, and its thick fur can support many insulating outfits, making the Coelodonta in high demand. Even less-advanced tribes use packs to hunt them down, though at significant peril.\nDomesticated\nWhen not being hunted for its horns, Coelodonta makes an impressive beast of burden. Its ability to take on far larger opponents provided sufficient charging room, as well as its sizeable load capacity, make it a solid addition to any trader party or gathering expedition.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'X-Yutyrannus', 'name_tag': 'Yutyrannus', 'entity_id': 'Snow_Yutyrannus_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis/Dinos/BiomeVariants/Snow_Yutyrannus/Snow_Yutyrannus_Character_BP.Snow_Yutyrannus_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Dossier_Yutyrannus.png',
            'url': 'https://ark.fandom.com/wiki/X-Yutyrannus', 'id': 197, 'category': 'X-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b8/Yutyrannus.png',
            'description': '“\nSpecies\nYutyrannus saevus\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThe Yutyrannus saevus is believed to be related to the Tyrannosaurus rex, but it is noticeably different upon first glance. Feathered creatures are not necessarily viewed as dangerous predators in the same light as other theropods. However, the Yutyrannus strikes fear into even the Island\'s most skilled hunters. There are few wild predators that are able to pack-hunt alongside the generally hostile Carnotaurus, like the Yutyrannus does, with such ease. It is also the only creature I\'ve seen to consistently induce a state of panic in opponents with its roar. Upon hearing it, most creatures in the area will flee for safety.\nDomesticated\nA domesticated Yutyrannus can be a powerful offensive or defensive addition to war parties. With its mighty roar, it can induce fear in opposing creatures. Meanwhile, Yutyrannus can be trained to develop a confidence-boosting Battle-Cry which counteracts enemy attempts to induce fear, while also bolstering the resolve of allies, and may even draw wild Carnotaurus to its aid. These unique "leadership" qualities make the Yutyrannus a versatile, and at times, a necessary creature to have on your side during large-scale confrontations!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Astrodelphis', 'name_tag': 'Astrodelphis', 'entity_id': 'SpaceDolphin_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/SpaceDolphin/SpaceDolphin_Character_BP.SpaceDolphin_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a8/Astrodelphis_image.png',
            'url': 'https://ark.fandom.com/wiki/Astrodelphis', 'id': 198, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/25/Astrodelphis.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Maewing', 'name_tag': 'Maewing', 'entity_id': 'MilkGlider_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/MilkGlider/MilkGlider_Character_BP.MilkGlider_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Maewing_image.png',
            'url': 'https://ark.fandom.com/wiki/Maewing', 'id': 199, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Maewing.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Noglin', 'name_tag': 'BrainSlug', 'entity_id': 'BrainSlug_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BrainSlug/BrainSlug_Character_BP.BrainSlug_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/54/Noglin_image.png',
            'url': 'https://ark.fandom.com/wiki/Noglin', 'id': 200, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/43/Noglin.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Shadowmane', 'name_tag': 'Lionfish Lion', 'entity_id': 'LionfishLion_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/LionfishLion/LionfishLion_Character_BP.LionfishLion_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f2/Shadowmane_image.png',
            'url': 'https://ark.fandom.com/wiki/Shadowmane', 'id': 201, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e8/Shadowmane.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Tek Stryder', 'name_tag': 'TekStrider', 'entity_id': 'TekStrider_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/TekStrider/TekStrider_Character_BP.TekStrider_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/31/Tek_Stryder_image.png',
            'url': 'https://ark.fandom.com/wiki/Tek_Stryder', 'id': 202, 'category': 'Mechanical Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/97/Tek_Stryder.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Voidwyrm', 'name_tag': 'TekWyvern', 'entity_id': 'TekWyvern_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/TekWyvern/TekWyvern_Character_BP.TekWyvern_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4f/Voidwyrm_image.png',
            'url': 'https://ark.fandom.com/wiki/Voidwyrm', 'id': 203, 'category': 'Mechanical Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4c/Voidwyrm.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'R-Allosaurus', 'name_tag': 'Allo', 'entity_id': 'Allo_Character_BP_Rockwell_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Allo_Character_BP_Rockwell.Allo_Character_BP_Rockwell\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Allosaurus.png',
            'url': 'https://ark.fandom.com/wiki/R-Allosaurus', 'id': 204, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Allosaurus.png',
            'description': "“\nSpecies\nAllosaurus therotribus\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmaller but faster than Tyrannosaurus, larger but slower than Carnotaurus, Allosaurus therotribus is the island's resident pack-hunting theropod. While most aggressive theropods are relatively solitary creatures, Allosaurus lives in groups of 3. One Allosaurus is the alpha, while the others are its mates or a beta male. Like humans find value in forming a tribe, the Allosaurus has evolved to hunt in packs. Its saw-shaped teeth leave its prey bleeding and maimed, making escape difficult. Once an Allosaurus slows a creature with its cutting bite, the rest of its pack quickly closes in for the kill.\nDomesticated\nNot everyone thinks a tamed Allosaurus is ideal. Those who appreciate speed generally tame Carnotaurus, while those who value raw stopping power tame Tyrannosaurus. However, riders of Allosaurus tend to respect the utility of its Alpha pack status, which along with its bleed-inducing attacks and relative mobility, can effectively turn the tide of a combined arms battle.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Carnotaurus', 'name_tag': 'Carno', 'entity_id': 'Carno_Character_BP_Rockwell_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Carno_Character_BP_Rockwell.Carno_Character_BP_Rockwell\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Carnotaurus.png',
            'url': 'https://ark.fandom.com/wiki/R-Carnotaurus', 'id': 205, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Carnotaurus.png',
            'description': "“\nSpecies\nCarnotaurus pressor\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nCarnotaurus pressor is a distinctive creature that falls between a medium and large predator. It lives primarily on flat, clear ground, where it can capitalize on its speed. Additionally, it seems to have no qualms about running away from larger predators instead of fighting. The horns of the Carnotaurus seem to be used more for fighting rivals than actual hunting. This doesn't mean the horns aren't dangerous, though. They can still eviscerate larger prey. Carnotaurus is one of the smaller and more compact of the large predators. If Tyrannosaurus is the “lion” of the Island, Carnotaurus would certainly be the “cheetah.” The real threat of a Carnotaurus is not being able to escape it once it has spotted you.\nDomesticated\nCarnotaurus fills a very specific role. Larger and almost as fast as a Raptor, smaller but much faster than a Rex. Were it not for the creature's extremely long down-time after sprinting, it might be among the most capably balanced mounts.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Daeodon', 'name_tag': 'Daeodon', 'entity_id': 'Daeodon_Character_BP_Eden_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Daeodon_Character_BP_Eden.Daeodon_Character_BP_Eden\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a9/Dossier_Daeodon.png',
            'url': 'https://ark.fandom.com/wiki/R-Daeodon', 'id': 206, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Daeodon.png',
            'description': '“\nSpecies\nDaeodon comedentis\nTime\nLate Oligocene\nDiet\nCarnivore\nTemperament\nTerritorial\nWild\nNice Daeodon comedentis is the largest known species of Entelodont, an omnivorous family of ancient mammals that are sometimes referred to as "Hell Pigs." Even though Daeodon has as many similarities to modern Hippopotamidae as it does to Suina, I\'ve found that to be a suitable nickname. Daeodon is as mean as it looks, and any survivor who wanders too close will find that out the hard way. As an omnivore with a voracious appetite, Daeodon scavenges, forages, and hunts to survive. It has little qualms when it comes to its diet, and that has helped it thrive on the Island\'s harsh tundra. Its temper hasn\'t hurt either, as many would be predators would rather seek out less vicious prey.\nDomesticated\nMany tribes have made excellent use of Daeodon packs within their war parties, not only because of its fierce nature, but due to its extraordinary ability to rapidly heal itself. I\'ve theorized that this healing factor is why it seems to have such a high metabolism, though what is particularly extraordinary is its capability to share this benefit with nearby creatures. I have even heard some survivors mention that the Daeodon also has a unique ability to root out Rare Mushrooms as well!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'R-Dilophosaur', 'name_tag': 'Dilo', 'entity_id': 'Dilo_Character_BP_Rockwell_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Dilo_Character_BP_Rockwell.Dilo_Character_BP_Rockwell\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6c/Dossier_Dilophosaur.png',
            'url': 'https://ark.fandom.com/wiki/R-Dilophosaur', 'id': 207, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c9/Dilophosaur.png',
            'description': '“\nSpecies\nDilophosaurus sputatrix\nTime\nEarly Jurassic\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nDilophosaurus sputatrix is a strange creature. It stands at just over half the size of known Dilophosaurs and runs from aggressors as often as it fights them. Dilophosaurus sputatrix has a few traits not common in the Dilophosaurus genus. It has a very shrill call, and a decorative ridge of skin on its neck. I believe these are used to attract mates, as well as intimidate prey and would-be predators. Instead of attacking its prey outright, Dilophosaurus sputatrix spits venom to weaken and paralyze it before moving in for the kill.\nDomesticated\nBecause of their shrill cry and their ability to attack intruders from range, Dilophosaurus seem most suited as "guard dogs." Due to their small size, they are not suitable as mounts.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'R-Dire Bear', 'name_tag': 'Direbear', 'entity_id': 'Direbear_Character_BP_Rockwell_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Direbear_Character_BP_Rockwell.Direbear_Character_BP_Rockwell\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/20/Dossier_Dire_Bear.png',
            'url': 'https://ark.fandom.com/wiki/R-Dire_Bear', 'id': 208, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6f/Dire_Bear.png',
            'description': "“\nSpecies\nArctodus dirus\nTime\nMid Pleistocene - Early Holocene\nDiet\nOmnivore\nTemperament\nTerritorial\nWild\nFound primarily among the Island's redwood regions, Arctodus dirus is an imposing creature. Many on the island have started calling it a Direbear, a name which is appropriate, both due to its enormity and its territorial nature. The Direbear ignores most non-hostile creatures while going about its daily routine of scavenging for meat and edible plant life... ...that is, until intruders enter the territory it considers its own, at which point the creature ferociously attacks. Most often, it is smartest to just run from an angry Direbear.\nDomesticated\nOnce tamed, the Direbear is a strong and reliable mount. It can carry vast quantities of goods, and can sprint for extremely long, nearly infinite periods. It is not the fastest creature from a hard stop, but after building up momentum, its sustained overland speed builds to among the best of the island. Of course, being able to feed a direbear both meat and plant life makes keeping one fairly convenient regardless of the environment. Arctodus has a fondness for honey and can harvest it without getting stung or destroying the hive. Perhaps more rewarding while you are riding it, those pesky bees will completely ignore you.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Direwolf', 'name_tag': 'Direwolf', 'entity_id': 'Direwolf_Character_BP_Eden_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Direwolf_Character_BP_Eden.Direwolf_Character_BP_Eden\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Direwolf.png',
            'url': 'https://ark.fandom.com/wiki/R-Direwolf', 'id': 209, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/10/Direwolf.png',
            'description': '“\nSpecies\nCanis maxdirus\nTime\nPleistocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThe best adjective to describe Canis maxdirus is "scary." This pack-animal is a cunning and brutal predator, capable of taking down prey of nearly any size. In addition to being a vicious hunter, it is the size of a small horse, meaning even the largest predators aren\'t necessarily safe from the packs. Unlike most creatures on the Island, Canis is a dedicated pack hunter, and rarely hunts alone. When in a pack, Canis are naturally spurred to fight for their lives with increased effectiveness, while the most experienced Canis will be designated “Alpha” and gain an even stronger enhancement! The species has an incredible affinity for teamwork.\nDomesticated\nObviously, Canis is a thrilling battle mount. It is fairly fast, very strong, and agile. It can leap almost as well as the Island\'s battle-cats. Riding a supercharged “Alpha” Canis into battle at the head of a bloodthirsty pack is a thrill for which most warriors would gladly proclaim: "today is a good day to die!" If utilized correctly, Canis can be a useful aid in your discovery efforts. It has developed a keen sense of smell that enables it to detect things that most creatures can\'t. I\'ve even seen them used to find creatures that are hidden beneath the surface.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'R-Equus', 'name_tag': 'Equus', 'entity_id': 'Equus_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Equus_Character_BP_Eden.Equus_Character_BP_Eden\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/85/Dossier_Equus.png',
            'url': 'https://ark.fandom.com/wiki/R-Equus', 'id': 210, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Equus.png',
            'description': "“\nSpecies\nEquus magnus\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nLoyal\nWild\nEquus magnus appears to be an ancestor of the modern horse. Based on its stripes, it may be the African variant of Equus giganteus, which appeared in North America during the Ice Age, but that is pure conjecture. Its behavior in the wild is similar to that of other wild members of the Equus genus - it sustains itself by grazing, while keeping safe from predators by living in herds and outrunning its attackers via superior speed and stamina.\nDomesticated\nHorse and man have long been partners in survival, and this remains true on the Island. In Equus, survivors will find a trusty steed or pack animal that can carry them swiftly across land. Taming an Equus has proven interesting, requiring carefully approaching the creature in the wild, mounting it, and then carefully soothing over time by feeding it vegetables. In fact, Equus' reliability has lead some survivors to construct special saddles for them. I even encountered a man who added extra saddle-pouches that doubled as mobile crafting stations for chemical supplies, foodstuffs, and other items. Although not as robust as what you might find within a village, this utility helped him live a nomadic, solitary lifestyle. Some survivors employ Equus to herd and wrangle other creatures with a specialized lasso. This tool is sometimes effective for self-defense as well, as Equus is limited in battle on its own...at least compared to aggressive prehistoric carnivores.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Gasbags', 'name_tag': 'GasBags', 'entity_id': 'GasBags_Character_BP_Eden_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/GasBags_Character_BP_Eden.GasBags_Character_BP_Eden\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8c/Dossier_Gasbags.png',
            'url': 'https://ark.fandom.com/wiki/R-Gasbags', 'id': 211, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Gasbags.png',
            'description': "“\nSpecies\nMopsechiniscus fluitobesus\nTime\nPost-Holocene\nDiet\nOmnivore\nTemperament\nPassive\nWild\nIt was always hypothesized that a member of the Tardigrada phylum would be the last species on Earth in the event of a global apocalypse, so in some ways, the existence of Mopsechiniscus fluitobesus is completely expected. Its size and method of travel, however? Less so.\n\nMopsechiniscus is slow and ineffective in a fight, so to survive, it tends to choose flight - literally. First, it inflates itself like a balloon, briefly slowing down and gaining durability. Then it launches itself into the air by expelling gas through a series of sphincters in its underbelly, which it also uses to slow its descent.\n\nYes, it's as...unusual as it sounds, but Mopsechiniscus makes the most of its inflatable nature. In addition to jumping, it can use its stored up gases to push back aggressors, or even float on water.\nDomesticated\nWhile a poor steed in battle, Mopsechiniscus is a fantastic beast of burden. The hairs on its back let a single rider steer it without a saddle, and it carries an incredible amount of cargo for its size. A small caravan of these could see us swimming in resources in no time.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Giganotosaurus', 'name_tag': 'Gigant', 'entity_id': 'Gigant_Character_BP_Rockwell_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Gigant_Character_BP_Rockwell.Gigant_Character_BP_Rockwell\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Dossier_Giganotosaurus.png',
            'url': 'https://ark.fandom.com/wiki/R-Giganotosaurus', 'id': 212, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Giganotosaurus.png',
            'description': '“\nSpecies\nGiganotosaurus furiosa\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAngry\nWild\nGiganotosaurus furiosa is an enormous predator, larger even than the Tyrannosaurus or Spinosaurus. Getting cornered or run down by a Giganotosaurus can mean certain death for nearly any creature! Fighting a Giganotosaurus directly is never a good idea, as its rage rapidly grows with every hit it takes. With this rage, it builds increasing reserves of energy to use, making its iron-jawed bites progressively more deadly and enhancing its stamina. Add to this the fact that its huge body also enables it to take a tremendous amount of punishment, and you have a creature that is generally better avoided or outsmarted than attacked head-on.\nDomesticated\nTaming Giganotosaurus is a dangerous prospect. Its rage reaction, even when tamed, can sometimes cause it to briefly turn on members of its own tribe. Indeed it may even throw off its rider if it has been sufficiently angered! And yet, the sheer size and immense power that the Giganotosaurus possesses means that some factions endeavor to tame it as a fear-inducing “Capital” beast of war, even at great risk!\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'R-Megatherium', 'name_tag': 'Megatherium', 'entity_id': 'Megatherium_Character_BP_Eden_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Megatherium_Character_BP_Eden.Megatherium_Character_BP_Eden\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9c/Dossier_Megatherium.png',
            'url': 'https://ark.fandom.com/wiki/R-Megatherium', 'id': 213, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Megatherium.png',
            'description': "“\nSpecies\nMegatherium formipavor\nTime\nLate Pliocene - Early Holocene\nDiet\nOmnivore (primarily Herbivore)\nTemperament\nPassive, but aggressive to insects\nWild\nMegatherium formipavor is one of the larger mammals on the Island. This is most shocking because it is essentially a giant sloth...if you crossbred it with an elephant and a bear! Because of its size and girth, the Megatherium is uncommonly resistant to being knocked unconscious. Despite primarily being an herbivore, a typical Megatherium is very intent on consuming the Island's many insects. It is particularly adept at removing their insides without damaging much of the shell, maximizing extraction of chitin. The otherwise slow and peaceful Megatherium becomes faster and aggressive in the presence of these creatures.\nDomesticated\nMegatherium is an incredibly useful creature to tame, so long as you don't intend to fight other tribes. It's enormity, high resistance to torpor, and voracious attitude toward insects (and arachnids) makes it ideal for farming large quantities of chitin from the bugs of the Island, or simply defending against them.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Snow Owl', 'name_tag': 'Owl', 'entity_id': 'Owl_Character_BP_Eden_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Owl_Character_BP_Eden.Owl_Character_BP_Eden\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bd/Dossier_Snow_Owl.png',
            'url': 'https://ark.fandom.com/wiki/R-Snow_Owl', 'id': 214, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4b/Snow_Owl.png',
            'description': "“\nSpecies\nBubo chinookus\nTime\nPost-Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nDiscovering Bubo chinookus was a pleasant surprise. Owls are remarkable creatures, but they're not the type that could survive an extinction level event on their own. Since it never strays from the patch of frozen tundra we encountered, I believe the Obelisk was the key to its survival.\n\nClearly a descendant of modern Strigdae, Bubo shares many traits with its smaller ancestors. For example, it excretes waste in the form of pellets, which make excellent fertilizer, and their large wings let them save energy during long, silent flights. They even hunt in the same way: by diving towards the ground to attack their prey with powerful talons.\n\nHowever, these talons also secrete a chemical with a high freezing point to slow down their prey, and they can even unleash this chemical in a wide cloud, temporarily freezing their foes.\nDomesticated\nWith its swift flying and frigid attacks, Bubo makes an excellent single-rider support mount or scout. The latter is helped by its tremendous vision, which it can share with its rider via its antenna. Not only does this make enemies easier to see, but Bubo can also spot Element veins with ease, even when they're underground.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Parasaur', 'name_tag': 'Para', 'entity_id': 'Para_Character_BP_Eden_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Para_Character_BP_Eden.Para_Character_BP_Eden\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Dossier_Parasaur.png',
            'url': 'https://ark.fandom.com/wiki/R-Parasaur', 'id': 215, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Parasaur.png',
            'description': "“\nSpecies\nParasaurolophus amphibio\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nSkittish\nWild\nParasaurolophus amphibio has one of the more interesting adaptations of any creature I've seen on the Island. Like all Parasaur, it has a signature crest on its head. Very docile at first, I've been able to approach the creature without disturbing it. If startled, however, the creature can vocalize a distress call to the surrounding area that warns of danger. Parasaurolophus appears to be low on the food chain and is hunted by everything, creatures and humans alike, which explains its skittish nature. It is a good source of meat and hide, if you can manage to keep up with it long enough to kill it.\nDomesticated\nDespite being what most tribes consider a relatively useless creature to tame, I once met an interesting woman who had tamed an entire herd of them. She informed me that many overlooked the creature's potential. She even graciously gifted me a fancy saddle to put on my own Parasaurolophus one day. As a relatively simple creature to domesticate, Parasaurolophus is commonly one of the first mounts a tribe will be able to acquire. Its ability to run relatively fast for lengthy intervals makes it a solid mode of medium-range transportation, though it has almost no ability to defend itself or its rider in a traditional sense. Smaller creatures, however, appear to be frightened by the horn of Parasaurolophus although it doesn't do much damage. It also has decent weight-bearing capabilities, which could prove useful for nomadic tribes as they work to establish a presence on the Island.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Procoptodon', 'name_tag': 'Kangaroo', 'entity_id': 'Procoptodon_Character_BP_Eden_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Procoptodon_Character_BP_Eden.Procoptodon_Character_BP_Eden\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5c/Dossier_Procoptodon.png',
            'url': 'https://ark.fandom.com/wiki/R-Procoptodon', 'id': 216, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Procoptodon.png',
            'description': "“\nSpecies\nProcoptodon vivencurrus\nTime\nPleistocene\nDiet\nHerbivore\nTemperament\nReactive\nWild\nThe first marsupial I've encountered on the Island is the Procoptodon vivencurrus. Standing nearly three meters tall, it is among the largest jumping creatures I've heard of. It is a fairly peaceful herbivore that will immediately flee when aggressed upon. One of Procoptodon's most unique features is its pouch. Unlike many pouched marsupials, Procoptodon's pouch is relatively dry and has little in the way of sticky or oily fluids. I assume this is good for the Joey, but I have not figured out exactly why yet. Its other unique feature, powerful hind legs, can knock back aggression much larger in stature. Procoptodons show great precision when leaping as if they can accurately target the landing without fail. I've seen them effortlessly hop and land from heights that would flatten other creatures.\nDomesticated\nIt seems Procotopdon's knack for carrying things has increased its load-bearing capacity. Procoptodon's dry pouch makes it an excellent beast of burden that can carry far more than other creatures of its size. Additionally, it appears to provide an optimal environment for nourishing babies. So much that upon maturing, they have even more vigor.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Quetzal', 'name_tag': 'Quetz', 'entity_id': 'Quetz_Character_BP_Rockwell_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Quetz_Character_BP_Rockwell.Quetz_Character_BP_Rockwell\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2c/Dossier_Quetzal.png',
            'url': 'https://ark.fandom.com/wiki/R-Quetzal', 'id': 217, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9d/Quetzal.png',
            'description': "“\nSpecies\nQuetzalcoatlus conchapicem\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nSkittish\nWild\nFrom afar, it's hard to believe that Quetzalcoatlus is one of the largest avians on the island. It shares a similar silhouette with the Pteranodon, and nests near the absolute highest peaks. Upon closer inspection, though, Quetzalcoatlus is an enormous creature of tremendous power. I find it strange that such a large, imposing beast would be so skittish. Unlike other creatures of its size, it is more likely to flee than fight. I suppose the decision to flee from any trouble keeps the species alive on an island with so many dangerous predators. But then how does it eat enough to sustain its massive size?\nDomesticated\nTamed Quetzalcoatlus have a very specific role on the island. Too slow to be an efficient local transport, and too weak to be an effective warbird, the tribes I have encountered tend to employ it as a mass carrier. Quetzalcoatlus is primarily used by these masters of the skies to safely carry vast quantities of supplies, creatures and human cargo from one base to another without tiring.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Brontosaurus', 'name_tag': 'Bronto', 'entity_id': 'Sauropod_Character_BP_Rockwell_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Sauropod_Character_BP_Rockwell.Sauropod_Character_BP_Rockwell\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f7/Dossier_Brontosaurus.png',
            'url': 'https://ark.fandom.com/wiki/R-Brontosaurus', 'id': 218, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/47/Brontosaurus.png',
            'description': '“\nSpecies\nBrontosaurus lazarus\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nDocile\nWild\nAmong giant creatures I\'ve seen on the Island, Brontosaurus lazarus is larger than any sauropod I\'ve read about. In fact, the dinosaur is so massive that it serenely ignores most other creatures. I\'ve seen a pack of raptors tear apart small dinosaurs while Brontosaurus continues eating, seemingly oblivious to the hunting pack.\nDomesticated\nBecause of how docile it is, the Brontosaurus makes for an ideal pack animal. Peaceful tribes use it to carry incredible quantities of resources, while warring tribes use it to mobilize their army. Its size and strength make it one of the unique creatures on the Island that can support a "platform" saddle. Unfortunately, its enormity means that the process of taming a Brontosaurus can take a very long time. Some may think this is an Apatosaurus, Dreadnoughtus, Argentinosaurus, or some other sauropod, but this is a strange Island, and I\'m the one doing the research. I\'m convinced that this genus is Brontosaurus, and no one can tell me otherwise. My study, my rules.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'R-Velonasaur', 'name_tag': 'Velonasaur', 'entity_id': 'Spindles_Character_BP_Rockwell_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Spindles_Character_BP_Rockwell.Spindles_Character_BP_Rockwell\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2a/Dossier_Velonasaur.png',
            'url': 'https://ark.fandom.com/wiki/R-Velonasaur', 'id': 219, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Velonasaur.png',
            'description': "“\nSpecies\nVelonasaurus spinavultus\nTime\nPost-Holocene\nDiet\nCarnivore\nTemperament\nOmnivore\nWild\nVelonasaurus spinavultus dwells in the small desert found outside the abandoned city, which is particularly fitting, because it looks like it's growing several cacti right on its face.\n\nAs unfashionable as its facial fins might be, I recommend keeping a close eye on them. While said fins are folded inwards, Velonasaurus behaves like your average therapod, attacking with claws and teeth. However, when those fins are spread wide, Velonasaurus can rapidly fire a storm of spines at its prey. However, while in this state, its mobility is greatly hampered and it will eventually wear itself out.\n\nTherefore it sometimes prefers to unleash its spines in a single, deadly burst. By spinning around and firing a salvo of spines at the same time, Velonasaurus can defend itself from every angle at once.\nDomesticated\nGiven its versatility, Velonasaurus spinavultus makes an excellent single rider mount in most combat situations, but it's particularly effective when defending an entrenched position. It's like a living, breathing gatling gun. Just be careful when giving it a congratulatory hug or pat on the head. Getting spined by your own war steed would be a rather embarrassing way to go.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Thylacoleo', 'name_tag': 'Thylacoleo', 'entity_id': 'Thylacoleo_Character_BP_Eden_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Thylacoleo_Character_BP_Eden.Thylacoleo_Character_BP_Eden\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c9/Dossier_Thylacoleo.png',
            'url': 'https://ark.fandom.com/wiki/R-Thylacoleo', 'id': 220, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/22/Thylacoleo.png',
            'description': "“\nSpecies\nThylacoleo furtimorsus\nTime\nLate Pliocene - Late Pleistocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nThylacoleo furtimorsus is a large, powerful marsupial that can often be found hunting around trees among the Island's redwoods. Its long claws and semi-opposable digits make it an apt climber, a quality that Thylacoleo uses to its advantage while hunting. It clambers up large trees and waits to ambush passing prey by pouncing upon them. When something that large jumps onto a target, the victim becomes stunned and doesn't stand much of a chance. Thylacoleo's most notable fighting quality is its powerful jaws. Once it bites its prey, it locks its jaw in an iron grip that can hold most smaller creatures in place. Thylacoleo then goes on to savage its prey with its sharp claws. If it needs to escape from a fight, Thylacoleo uses its muscular hind legs to jump back to safety among the trees.\nDomesticated\nThylacoleo is a moderately strong mount, and its ability to climb trees and jump long distances makes it useful for traversal. As such, developing tribes often tame it. Small raiding parties particularly favor Thylacoleo, as it is well suited to ambushes and unfair fights!\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Carbonemys', 'name_tag': 'Turtle', 'entity_id': 'Turtle_Character_BP_Rockwell_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Turtle_Character_BP_Rockwell.Turtle_Character_BP_Rockwell\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Carbonemys.png',
            'url': 'https://ark.fandom.com/wiki/R-Carbonemys', 'id': 221, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4c/Carbonemys.png',
            'description': "“\nSpecies\nCarbonemys obibimus\nTime\nDanian\nDiet\nHerbivore\nTemperament\nDefensive\nWild\nCarbonemys obibimus is one of the least aggressive creatures on the Island. Were it not for the plethora of predators on the Island, I'm quite certain that it would spend its days basking in the sun, eating, or sleeping. Carbonemys leads a simple, solitary life. Nevertheless, it seems to be one of the most peaceful animals I have yet encountered. With its slow walking speed, the only things that keep it safe are its surprisingly fast swim speed, and its incredibly thick shell, which can absorb tremendous damage.\nDomesticated\nCarbonemys' swift swim rate, fairly high strength, superior shell defenses, and lack of real threat makes it an ideal armored mount for many survivors who shy away from violence. It can carry its rider to the ocean's resources at fairly high speed, and is not particularly dangerous to tame.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Reaper Queen', 'name_tag': 'Xenomorph', 'entity_id': 'Xenomorph_Character_BP_Female_Gen2_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Xenomorph_Character_BP_Female_Gen2.Xenomorph_Character_BP_Female_Gen2\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/R-Reaper_Queen', 'id': 222, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
            'description': "“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Reaper King', 'name_tag': 'Xenomorph', 'entity_id': 'Xenomorph_Character_BP_Male_Gen2_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Xenomorph_Character_BP_Male_Gen2.Xenomorph_Character_BP_Male_Gen2\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/R-Reaper_King', 'id': 223, 'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
            'description': "“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'R-Reaper King (Tamed)', 'name_tag': 'Xenomorph',
            'entity_id': 'Xenomorph_Character_BP_Male_Tamed_Gen2_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/BiomeVariants/Xenomorph_Character_BP_Male_Tamed_Gen2.Xenomorph_Character_BP_Male_Tamed_Gen2\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Dossier_Reaper.png',
            'url': 'https://ark.fandom.com/wiki/R-Reaper_King_(Tamed)', 'id': 224,
            'category': 'R-Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Reaper.png',
            'description': "“\nSpecies\nUnknown\nTime\nUnknown\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nAt home in the cavern's deepest chambers, Reapers are towering, terrifying apex predators. Beyond overwhelming their prey with fangs and claws, Reapers can burrow underground to set an ambush and fire acidic projectiles from their tails. Yet it is their macabre method of reproduction that is their most frightening feature. Bizarrely, a female Reaper's tail doubles as a reproductive organ, but only when piercing human survivors. Once impregnated, the survivor carries the young Reaper until it bursts from their chest in a grotesque, disturbing spectacle.\nDomesticated\nIf impregnated by a female Reaper, I strongly urge that the survivor kill the embryo via exposure to radiation. However, there are rumors that Reapers might imprint themselves on a survivor who possesses a Reaper pheromone gland. This has led some mad survivors with dreams of riding on the back of a Reaper to try seeing the gestation period through to the end, but that is extremely dangerous, not to mention disgusting.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Summoner', 'name_tag': 'Summoner', 'entity_id': 'Summoner_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/Summoner/Summoner_Character_BP.Summoner_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fc/Summoner_image.png',
            'url': 'https://ark.fandom.com/wiki/Summoner', 'id': 225, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Summoner.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Macrophage', 'name_tag': 'Macrophage', 'entity_id': 'Macrophage_Swarm_Character_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/Macrophage/Macrophage_Swarm_Character.Macrophage_Swarm_Character\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0f/Macrophage_image.png',
            'url': 'https://ark.fandom.com/wiki/Macrophage', 'id': 226, 'category': 'Fantasy Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0e/Macrophage.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Exo-Mek', 'name_tag': 'Exosuit', 'entity_id': 'Exosuit_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Dinos/Exosuit/Exosuit_Character_BP.Exosuit_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/20/Exo-Mek_image.png',
            'url': 'https://ark.fandom.com/wiki/Exo-Mek', 'id': 227, 'category': 'Vehicles',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fc/Exo-Mek.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Prime', 'name_tag': 'RockwellPrime', 'entity_id': 'RockwellNode_Character_BP_Boss_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Dinos/RockwellNode_Character_BP_Boss.RockwellNode_Character_BP_Boss\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a6/Rockwell_Prime_in_arena.jpg',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Prime', 'id': 228, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cc/Rockwell_Prime.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Prime (Alpha)', 'name_tag': 'RockwellPrime',
            'entity_id': 'RockwellNode_Character_BP_Boss_Alpha_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Alpha/RockwellNode_Character_BP_Boss_Alpha.RockwellNode_Character_BP_Boss_Alpha\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a6/Rockwell_Prime_in_arena.jpg',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Prime_(Alpha)',
            'id': 229, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cc/Rockwell_Prime.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Prime (Beta)', 'name_tag': 'RockwellPrime',
            'entity_id': 'RockwellNode_Character_BP_Boss_Beta_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Beta/RockwellNode_Character_BP_Boss_Beta.RockwellNode_Character_BP_Boss_Beta\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a6/Rockwell_Prime_in_arena.jpg',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Prime_(Beta)', 'id': 230, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cc/Rockwell_Prime.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Prime (Gamma)', 'name_tag': 'RockwellPrime',
            'entity_id': 'RockwellNode_Character_BP_Boss_Gamma_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Gamma/RockwellNode_Character_BP_Boss_Gamma.RockwellNode_Character_BP_Boss_Gamma\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a6/Rockwell_Prime_in_arena.jpg',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Prime_(Gamma)',
            'id': 231, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/cc/Rockwell_Prime.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Node', 'name_tag': 'RockwellPrime',
            'entity_id': 'RockwellNode_Character_BP_FinalFight_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Dinos/RockwellNode_Character_BP_FinalFight.RockwellNode_Character_BP_FinalFight\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Rockwell_Node.jpg',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Node', 'id': 232, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/87/Rockwell_Node.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Node (Alpha)', 'name_tag': 'RockwellPrime',
            'entity_id': 'RockwellNode_Character_BP_FinalFight_Alpha_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Alpha/RockwellNode_Character_BP_FinalFight_Alpha.RockwellNode_Character_BP_FinalFight_Alpha\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Rockwell_Node.jpg',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Node_(Alpha)',
            'id': 233, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/87/Rockwell_Node.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Node (Beta)', 'name_tag': 'RockwellPrime',
            'entity_id': 'RockwellNode_Character_BP_FinalFight_Beta_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Beta/RockwellNode_Character_BP_FinalFight_Beta.RockwellNode_Character_BP_FinalFight_Beta\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Rockwell_Node.jpg',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Node_(Beta)', 'id': 234, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/87/Rockwell_Node.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Rockwell Node (Gamma)', 'name_tag': 'RockwellPrime',
            'entity_id': 'RockwellNode_Character_BP_FinalFight_Gamma_C',
            'blueprint': '"Blueprint\'/Game/Genesis2/Missions/ModularMission/FinalBattleAlt/Difficulties/Gamma/RockwellNode_Character_BP_FinalFight_Gamma.RockwellNode_Character_BP_FinalFight_Gamma\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/Rockwell_Node.jpg',
            'url': 'https://ark.fandom.com/wiki/Rockwell_Node_(Gamma)',
            'id': 235, 'category': 'Bosses',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/87/Rockwell_Node.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Achatina', 'name_tag': 'Achatina', 'entity_id': 'Achatina_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Achatina/Achatina_Character_BP.Achatina_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bc/Dossier_Achatina.png',
            'url': 'https://ark.fandom.com/wiki/Achatina', 'id': 236, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/18/Achatina.png',
            'description': '“\nSpecies\nAchatina limusegnis\nTime\nHolocene\nDiet\nHerbivore\nTemperament\nPassive\nWild\nFound mostly in marshes and jungles, Achatina limusegnis is a very slow, very non-threatening land mollusk. It might be the simplest creature on the Island to hunt, and while it only provides a small amount of meat and chitin, an easy meal is always of value on the Island. Unlike nearly every other creature on the Island, Achatina does not defecate normally. Instead, it secretes a thick, sticky substance. Achatina leaves trails of this slime, but the trails are so thin that they crumble to dust quickly.\nDomesticated\nThere is a very disgusting, but useful fact about Achatina that causes tribes to seek to tame them: its secretions are chemically similar to the "Cementing Paste" and "Organic Polymer" used by many tribes for building materials. Tamed Achatina naturally accumulates this slime over time, which can then be collected at the tribe\'s convenience. Legend has it that Achatina can be tamed with a special "cake" made from harvested crops & resources.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Allosaurus', 'name_tag': 'Allo', 'entity_id': 'Allo_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Allosaurus/Allo_Character_BP.Allo_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/da/Dossier_Allosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Allosaurus', 'id': 237, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Allosaurus.png',
            'description': "“\nSpecies\nAllosaurus therotribus\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nSmaller but faster than Tyrannosaurus, larger but slower than Carnotaurus, Allosaurus therotribus is the island's resident pack-hunting theropod. While most aggressive theropods are relatively solitary creatures, Allosaurus lives in groups of 3. One Allosaurus is the alpha, while the others are its mates or a beta male. Like humans find value in forming a tribe, the Allosaurus has evolved to hunt in packs. Its saw-shaped teeth leave its prey bleeding and maimed, making escape difficult. Once an Allosaurus slows a creature with its cutting bite, the rest of its pack quickly closes in for the kill.\nDomesticated\nNot everyone thinks a tamed Allosaurus is ideal. Those who appreciate speed generally tame Carnotaurus, while those who value raw stopping power tame Tyrannosaurus. However, riders of Allosaurus tend to respect the utility of its Alpha pack status, which along with its bleed-inducing attacks and relative mobility, can effectively turn the tide of a combined arms battle.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Alpha Carno', 'name_tag': 'Elite Carno', 'entity_id': 'MegaCarno_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Carno/MegaCarno_Character_BP.MegaCarno_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Alpha_Carnotaurus_Image.jpg',
            'url': 'https://ark.fandom.com/wiki/Alpha_Carno', 'id': 238, 'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Alpha_Carnotaurus.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Alpha Leedsichthys', 'name_tag': 'Leedsichthys',
            'entity_id': 'Alpha_Leedsichthys_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Leedsichthys/Alpha_Leedsichthys_Character_BP.Alpha_Leedsichthys_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e9/Dossier_Leedsichthys.png',
            'url': 'https://ark.fandom.com/wiki/Alpha_Leedsichthys',
            'id': 239, 'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Leedsichthys.png',
            'description': "“\nSpecies\nLeedsichthys conviviumbrosia\nTime\nMid-Jurassic\nDiet\nPiscivore\nTemperament\nDefensive\nWild\nLeedsichthys conviviumbrosia is probably the largest fish in the waters around the island. Its meat is also extremely succulent, a surprise given its size. It is often traded with the same value as Prime Meat, and colloquially called 'Prime Fish'. Of course, not all of Leedsichthys' meat is this high quality, but most of it is! While the demand for Leedsichthys meat is high, the fish is notoriously difficult to track and hunt. Between its large size, powerful attacks, incredible speed (when it turns to flee), and humankind's general ineptitude on open water, actually killing a Leedsichthys is one of the Island's more difficult tasks. The hunt for an extremely elusive breed of the fish, the fabled 'Great Albino' Leedsichthys has been known to drive otherwise-sensible men and women mad with obsession, as if all evil were visibly personified and made practically assailable in this one creature.\nDomesticated\nDespite its large size, and the fact that it may well be strong enough to carry heavy loads, Leedsichthys does not appear to be intelligent enough to tame. Nevertheless, some large tribes keep an enormous pen with a few Leedsichthys trapped inside for cultivating purposes, as bits of Prime Fish can be repeatedly scraped off the gargantuan beast without killing it!\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Alpha Megalodon', 'name_tag': 'Elite Mega', 'entity_id': 'MegaMegalodon_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Megalodon/MEgaMegalodon_Character_BP.MegaMegalodon_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Dossier_Megalodon.png',
            'url': 'https://ark.fandom.com/wiki/Alpha_Megalodon', 'id': 240, 'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Megalodon.png',
            'description': "“\nSpecies\nCarcharodon ultramegalodon\nTime\nMiocene-Pliocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWere it not restricted to the waters, Carcharodon ultramegalodon would be one of the most dangerous creatures on the island. As powerful and dangerous as the Tyrannosaurus is on land, Megalodon is near its equal in the water. In addition, it has a speed advantage over any non-aquatic creature when submerged. Megalodons need large quantities of food to sustain themselves, so they attack most creatures immediately on sight. Smaller fish are the sole exception I've seen; I believe this is because they cost more energy for Megalodons to catch than the predator would gain.\nDomesticated\nHaving access to the resources and treasures hidden deep within the ocean is near impossible without a domesticated sea creature. The Megalodon, though difficult to domesticate, proves to be very useful when exploring the deep sea. It's not the most efficient swimmer but it should be able to protect your cargo should you find yourself in a hostile encounter.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Alpha Mosasaur', 'name_tag': 'Mosasaur', 'entity_id': 'Mosa_Character_BP_Mega_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Mosasaurus/Mosa_Character_BP_Mega.Mosa_Character_BP_Mega\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e3/Alpha_Mosasaur.jpg',
            'url': 'https://ark.fandom.com/wiki/Alpha_Mosasaur', 'id': 241, 'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dc/Alpha_Mosasaur.png',
            'description': None, 'color_id': None
        },
        {
            'name': 'Alpha Raptor', 'name_tag': 'Elite Raptor', 'entity_id': 'MegaRaptor_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Raptor/MegaRaptor_Character_BP.MegaRaptor_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d2/Dossier_Raptor.png',
            'url': 'https://ark.fandom.com/wiki/Alpha_Raptor', 'id': 242, 'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/08/Raptor.png',
            'description': '“\nSpecies\nUtahraptor prime\nTime\nEarly Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nUtahraptor prime is an incredibly aggressive subspecies of Utahraptor found on the Island. It tends to travel in small hunting packs, attacking smaller prey with its sharp teeth and enlarged foreclaws. When hunting in packs, the pack leader can vocalize a signal that acts as a battle cry. Be prepared to run or fight if you hear the call of the Utahraptor! The pack will repeat the calls and attack with much greater intensity. One of the faster creatures on the island, Utahraptor often uses their pack numbers to their advantage by swarming around their prey before it can react. The large curved talon on the second toe of this sub-species seems particularly suited for dealing significant damage. Utahraptor prime usually kill its prey with numerous slashing and biting attacks in rapid sequence.\nDomesticated\nWhat the Utahraptor lacks in size, it makes up for in ingenuity. Rather than chase down smaller creatures, Utahraptor will pounce and pin its prey to the ground rather than chasing it around. Despite its normally aggressive nature, Utahraptors have become one of the primary combat mounts for roaming bands of raiders, as well as scouts for larger collectives. Those who ride Utahraptor claim they are difficult to tame, but then fiercely loyal. As a carnivore, once tamed they require a steady stream of meat to sustain.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Alpha T-Rex', 'name_tag': 'Elite Rex', 'entity_id': 'MegaRex_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Rex/MegaRex_Character_BP.MegaRex_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Dossier_Rex.png',
            'url': 'https://ark.fandom.com/wiki/Alpha_T-Rex', 'id': 243,
            'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5f/Rex.png',
            'description': '“\nSpecies\nTyrannosaurus dominum\nTime\nLate Cretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nArguably the deadliest creature on the Island, Tyrannosaurus dominum is a killing machine. Active mostly when hunting for food or defending its nest, a good plan is to avoid every Tyrannosaurus. It is pure power -- from its stomp to its tail. It is not able to intimidate every foe with its roar, but upon hearing it, it might scare the poop out of you - quite literally. Despite being a different sub-species of Tyrannosaurus, everyone I\'ve met still refers to them as a "Rex" or a "T-Rex". I\'ve long since stopped trying to convince anyone, especially the few who I\'ve encountered wearing Tyrannosaurus teeth as necklaces.\nDomesticated\nTaming a Tyrannosaurus is without a doubt the goal for any warlord or warring tribe. Tyrannosaurus is a fierce battle companion. There is a reason Tyrannosaurus is considered the king of dinosaurs (or in this genus, the "lord"). Any tribe that manages to tame one has almost nothing to fear.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Alpha Tusoteuthis', 'name_tag': 'Tusoteuthis', 'entity_id': 'Mega_Tusoteuthis_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Tusoteuthis/Mega_Tusoteuthis_Character_BP.Mega_Tusoteuthis_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Dossier_Tusoteuthis.png',
            'url': 'https://ark.fandom.com/wiki/Alpha_Tusoteuthis', 'id': 244, 'category': 'Alpha Creatures',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/37/Tusoteuthis.png',
            'description': "“\nSpecies\nTusoteuthis vampyrus\nTime\nCretaceous\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nTusoteuthis vampyrus is a very aggressive water predator. Approximately 30 feet long, Tusoteuthis is a terror of the deep. Once it grabs its prey, it slowly crushes it into submission while using the talons on its tentacles to siphon and drink the victim's blood! Tusoteuthis is a terrifying opponent for several reasons. Firstly, its grab slowly renders its victim unconscious, so death isn't the only concern. Secondly, its vampiric blood drain instantly revitalizes it, even during combat. Finally, if Tusoteuthis is losing the fight, it sprays a cloud of ink into the surrounding water, blinding its attackers to cover a sneaky escape.\nDomesticated\nOne of the major benefits of taming Tusoteuthis is harvesting its ink. Unlike normal ink, Tusoteuthis' ink is very oily, and can even be refined into fuels such as gasoline. Between that and Tusoteuthis' distinctive capability to grab & carry large creatures underwater, it makes for an excellent aquatic tame, despite its slower speed.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Ammonite', 'name_tag': 'Ammonite', 'entity_id': 'Ammonite_Character_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Ammonite/Ammonite_Character.Ammonite_Character\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/52/Dossier_Ammonite.png',
            'url': 'https://ark.fandom.com/wiki/Ammonite', 'id': 245, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8b/Ammonite.png',
            'description': '“\nSpecies\nAmmonitina multiamicus\nTime\nLate Jurassic - Mid Cretaceous\nDiet\nBottom Feeder\nTemperament\nPassive\nWild\nUsually found in the deepest parts of the water around the island, Amonitina multiamicus has a strange relationship with the other creatures of the deep. It must do something beneficial for them since every nearby sea creature defends Ammonitina when it is attacked. What this distinct symbiosis is based on, alas, I have not yet discovered. Ammonitina has also made its way into the deeper parts of many underwater caves. Even within these caves, the creature will draw attention if assaulted, making harvesting its resource-rich shell a tricky proposition, depending on what other dangers may be lurking nearby.\nDomesticated\nLike many of the untameable ocean dwellers, Ammonitina still has enough utility to be a valuable hunting target. If a tribe is willing to risk the wrath of nearby would-be protectors, Ammonitina bile can be harvested from the innards of its corpse. This bile can then be worked over with other chemicals to produce powerful concoctions, the most notable being a mixture that causes creatures to become enraged and attack the source of the scent.\n„\n~ Helena',
            'color_id': None
        },
        {
            'name': 'Anglerfish', 'name_tag': 'Angler', 'entity_id': 'Angler_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Anglerfish/Angler_Character_BP.Angler_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0d/Dossier_Angler.png',
            'url': 'https://ark.fandom.com/wiki/Anglerfish', 'id': 246, 'category': 'Fish',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Anglerfish.png',
            'description': "“\nSpecies\nMelanocetus anglerpescum\nTime\nEarly Cretaceous - Holocene\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nWhether its size is caused by adaptation to the Island's other inhabitants, or by cross-breeding with another larger species, Melanocetus angerlpescum is the largest form of Anglerfish I've ever heard of. Typically found among the deepest, darkest expanses of the ocean, this creature preys on smaller fish while being an excellent source of food for larger predators. Melanocetus has an array of bioluminescent light pods at the end of stalks on its head. Like typical Anglerfish, it primarily uses these to attract smaller creatures and trick them into coming close enough for Melanocetus to consume the prey. This often makes wild Melanocetus itself relatively easy to spot among the briny depths.\nDomesticated\nExploring the depths of the ocean can be difficult. The cold, the lack of air, and the shocking absence of light combine to make travel very dangerous. A tamed Anglerfish can use the natural light at the end of its stalks to illuminate the depths, making exploration not only safer but more lucrative, as I've heard some survivors use this creature to harvest the silica pearls found throughout the ocean's depths!\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Ankylosaurus', 'name_tag': 'Anky', 'entity_id': 'Ankylo_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Ankylo/Ankylo_Character_BP.Ankylo_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8e/Dossier_Ankylosaurus.png',
            'url': 'https://ark.fandom.com/wiki/Ankylosaurus', 'id': 247, 'category': 'Dinosaurs',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a7/Ankylosaurus.png',
            'description': "“\nSpecies\nAnkylosaurus crassacutis\nTime\nLate Cretaceous\nDiet\nHerbivore\nTemperament\nDocile\nWild\nUnlike many of the herd animals on the Island, Ankylosaurus crassacutis tends to live in small family units. I believe they can afford to stick with smaller groups because of their incredibly thick skin, for which they're named. Despite not being among the largest of the Island's herbivores, Ankylosaurus is one of the more difficult creatures to take down. Its thick, armored skin seems to make it more than a match for several of the mid-sized predators that would otherwise hunt it. Reckless carnivores are just as likely to hurt themselves on Ankylosaurus' spikes, as they are to get hit by its tail.\nDomesticated\nWithout a doubt, the best trait of a trained Ankylosaurus is its enormously dense tail. This tail is powerful enough to quickly shatter the resource-laden rocks of the Island. One of the wealthier human tribes on the island utilizes a squad of Ankylosaurs in its mines and quarries. The creature's affinity for metal enables it to carry raw ore at an effectively reduced weight.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Araneo', 'name_tag': 'Spider', 'entity_id': 'SpiderS_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Spider-Small/SpiderS_Character_BP.SpiderS_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Dossier_Araneo.png',
            'url': 'https://ark.fandom.com/wiki/Araneo', 'id': 248, 'category': 'Invertebrates',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/84/Spider.png',
            'description': "“\nSpecies\nAraneomorphus amalgotantibus\nTime\nNo equivalent, traits begin as far as Mesozoic Era\nDiet\nCarnivore\nTemperament\nAggressive\nWild\nI don't know where to start with Araneomorphus amalgotantibus. It has so many of the nightmare inducing traits of spiders from among many family and genus. It fires webbing like a bola spider, it spits venom like a lynx spider. It has a poisonous bite like a myriad of spiders, and can see in the dark by sensing vibrations. And to top it off, Araneomorphus is larger than an adult human! If that wasn't enough, I'm convinced that some of the caves on the island have actually been dug by Araneomorphus, but this worries me. Either Araneomorphus is a colony-spider (like ants), or there is a much larger Araneomorphus somewhere on the island.\nDomesticated\nAs long as it is kept far from arachnophobics, domesticated Araneomorphus makes an excellent guardian creature for anyone wanting to avoid killing. Their strange web-spraying behavior is also quite helpful while hunting fast, fleeing prey. They are too small to be used as mounts, however...\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Archaeopteryx', 'name_tag': 'Archa', 'entity_id': 'Archa_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Archaeopteryx/Archa_Character_BP.Archa_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f7/Dossier_Archaeopteryx.png',
            'url': 'https://ark.fandom.com/wiki/Archaeopteryx', 'id': 249, 'category': 'Birds',
            'small_image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8a/Archaeopteryx.png',
            'description': "“\nSpecies\nArchaeopteryx magnamilvum\nTime\nLate Jurassic\nDiet\nCarnivore\nTemperament\nFearful\nWild\nApproximately one meter long, the Archaeopteryx magnamilvum is a primarily tree-dwelling proto-bird. It avoids the ground as much as possible, preferring to stay in the safety of the tree-line, where few predators can reach it. I've not seen an Archaeopteryx outright fly yet, so it's possible that they cannot generate enough lift to do more than glide long distances between perches. I'm not sure how a creature so fearful of the ground can be such a picky eater, but Archaeopteryx only seems to consume certain rare insect matter. The most likely explanation is that it tends to nest in infested trees, stripping them bare of such food sources.\nDomesticated\nWhile not large enough to bear the full weight of an adult human, Archaeopteryx still has great utility. Despite the creature's inability to fly, its wings have sufficient strength to dramatically slow the rate of a person's descent, if that person holds onto Archaeopteryx while airborne. Taming Archaeopteryx can be somewhat troublesome, though, as it refuses to eat most common food sources, and glides to prospective safety at the first sign of any interloper.\n„\n~ Helena",
            'color_id': None
        },
        {
            'name': 'Argentavis', 'name_tag': 'Argent', 'entity_id': 'Argent_Character_BP_C',
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/Argentavis/Argent_Character_BP.Argent_Character_BP\'"',
            'large_image_url': 'https://static.wikia.nocookie.net/ark