from arkdata import models


def backup_seed():
    models.Artifact.new(id=157, name='Tyrannosaurus Arm', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Rex_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Rex.PrimalItemResource_ApexDrop_Rex\'"',
                        url='https://ark.fandom.com/wiki/Tyrannosaurus_Arm',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Tyrannosaurus_Arm.png')
    models.Artifact.new(id=158, name='Sauropod Vertebra', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Sauro_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Sauro.PrimalItemResource_ApexDrop_Sauro\'"',
                        url='https://ark.fandom.com/wiki/Sauropod_Vertebra',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Sauropod_Vertebra.png')
    models.Artifact.new(id=156, name='Megalodon Tooth', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Megalodon_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Megalodon.PrimalItemResource_ApexDrop_Megalodon\'"',
                        url='https://ark.fandom.com/wiki/Megalodon_Tooth',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6f/Megalodon_Tooth.png')
    models.Artifact.new(id=155, name='Argentavis Talon', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Argentavis_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Argentavis.PrimalItemResource_ApexDrop_Argentavis\'"',
                        url='https://ark.fandom.com/wiki/Argentavis_Talon',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Argentavis_Talon.png')
    models.Artifact.new(id=154, name='Artifact of the Strong', stack_size=1, class_name='PrimalItemArtifact_09_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_09.PrimalItemArtifact_09\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Strong',
                        description='Such power may be crucial when survival becomes a question of raw physical capability. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5b/Artifact_of_the_Strong.png')
    models.Artifact.new(id=151, name='Artifact of the Skylord', stack_size=1, class_name='PrimalItemArtifact_06_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_06.PrimalItemArtifact_06\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Skylord',
                        description='Mastery of the skies confers a distinct advantage over earthbound competition. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e4/Artifact_of_the_Skylord.png')
    models.Artifact.new(id=147, name='Artifact of the Pack', stack_size=1, class_name='PrimalItemArtifact_02_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_02.PrimalItemArtifact_02\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Pack',
                        description='Stronger than any lone creature, one may die but the pack will survive. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Artifact_of_the_Pack.png')
    models.Artifact.new(id=148, name='Artifact of the Massive', stack_size=1, class_name='PrimalItemArtifact_03_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_03.PrimalItemArtifact_03\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Massive',
                        description='Size alone can sometimes mean the difference between survival and oblivion. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c6/Artifact_of_the_Massive.png')
    models.Artifact.new(id=153, name='Artifact of the Immune', stack_size=1, class_name='PrimalItemArtifact_08_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_08.PrimalItemArtifact_08\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Immune',
                        description="With a mastery of one's equilibrium, no simple poison nor toxin can be a threat. Only one of these may be carried at a time by an organism.",
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/23/Artifact_of_the_Immune.png')
    models.Artifact.new(id=146, name='Artifact of the Hunter', stack_size=1, class_name='PrimalItemArtifact_01_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_01.PrimalItemArtifact_01\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Hunter',
                        description='With relentless determination, the hunter will never waver until it catches its prey. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Artifact_of_the_Hunter.png')
    models.Artifact.new(id=152, name='Artifact of the Devourer', stack_size=1,
                        class_name='PrimalItemArtifact_07_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_07.PrimalItemArtifact_07\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Devourer',
                        description='To consume is to become, and to become is to evolve. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Artifact_of_the_Devourer.png')
    models.Artifact.new(id=149, name='Artifact of the Devious', stack_size=1, class_name='PrimalItemArtifact_04_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_04.PrimalItemArtifact_04\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Devious',
                        description="With craft and cunning, to look out for one's self may be essential to survival. Only one of these may be carried at a time by an organism.",
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b4/Artifact_of_the_Devious.png')
    models.Artifact.new(id=150, name='Artifact of the Clever', stack_size=1, class_name='PrimalItemArtifact_05_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_05.PrimalItemArtifact_05\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Clever',
                        description="Wit and quick thinking may turn the odds in one's favor, even when nature has other plans. Only one of these may be carried at a time by an organism.",
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/80/Artifact_of_the_Clever.png')
    models.Artifact.new(id=133, name='Specimen Implant', stack_size=1, class_name='PrimalItem_StartingNote_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Notes/PrimalItem_StartingNote.PrimalItem_StartingNote\'"',
                        url='https://ark.fandom.com/wiki/Specimen_Implant',
                        description='A mysterious implant attached to your arm.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Specimen_Implant.png')
    models.Artifact.new(name='Artifact of the Brute', stack_size=1, class_name='PrimalItemArtifact_12_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_12.PrimalItemArtifact_12\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Brute',
                        description="Striking fear into the hearts of one's enemies may be a crucial component of survival. Only one of these may be carried at a time by an organism.",
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4b/Artifact_of_the_Brute.png')
    models.Artifact.new(name='Artifact of the Cunning', stack_size=1, class_name='PrimalItemArtifact_11_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_11.PrimalItemArtifact_11\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Cunning',
                        description="With craft and strategy, to outwit one's opponents may be essential to survival. Only one of these may be carried at a time by an organism.",
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Artifact_of_the_Cunning.png')
    models.Artifact.new(name='Artifact of the Lost', stack_size=1, class_name='PrimalItemArtifactAB_4_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactAB_4.PrimalItemArtifactAB_4\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Lost',
                        description='Found within the depths of Aberration. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/49/Artifact_of_the_Lost.png')
    models.Artifact.new(name='Artifact of the Gatekeeper ', stack_size=1, class_name='PrimalItemArtifactSE_01_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactSE_01.PrimalItemArtifactSE_01\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Gatekeeper_(Scorched_Earth)',
                        description='Found within the depths of the Scorched Earth. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Artifact_of_the_Gatekeeper_%28Scorched_Earth%29.png')
    models.Artifact.new(name='Artifact of the Crag ', stack_size=1, class_name='PrimalItemArtifactSE_02_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactSE_02.PrimalItemArtifactSE_02\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Crag_(Scorched_Earth)',
                        description='Found within the depths of the Scorched Earth. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Artifact_of_the_Crag_%28Scorched_Earth%29.png')
    models.Artifact.new(name='Artifact of the Destroyer ', stack_size=1, class_name='PrimalItemArtifactSE_03_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactSE_03.PrimalItemArtifactSE_03\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Destroyer_(Scorched_Earth)',
                        description='Found within the depths of the Scorched Earth. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e5/Artifact_of_the_Destroyer_%28Scorched_Earth%29.png')
    models.Artifact.new(name='Artifact of the Depths ', stack_size=1, class_name='PrimalItemArtifactAB_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactAB.PrimalItemArtifactAB\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Depths_(Aberration)',
                        description='Found within the depths of Aberration. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/Artifact_of_the_Depths_%28Aberration%29.png')
    models.Artifact.new(name='Artifact of the Shadows ', stack_size=1, class_name='PrimalItemArtifactAB_2_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactAB_2.PrimalItemArtifactAB_2\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Shadows_(Aberration)',
                        description='Found within the depths of Aberration. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Artifact_of_the_Shadows_%28Aberration%29.png')
    models.Artifact.new(name='Artifact of the Stalker ', stack_size=1, class_name='PrimalItemArtifactAB_3_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactAB_3.PrimalItemArtifactAB_3\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Stalker_(Aberration)',
                        description='Found within the depths of Aberration. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/53/Artifact_of_the_Stalker_%28Aberration%29.png')
    models.Artifact.new(name='Artifact of the Chaos', stack_size=1,
                        class_name='PrimalItemArtifact_Extinction_DesertKaiju_C',
                        blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_Extinction_DesertKaiju.PrimalItemArtifact_Extinction_DesertKaiju\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Chaos_(Extinction)',
                        description='Found within the Desert biome.  Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1b/Artifact_of_Chaos_%28Extinction%29.png')
    models.Artifact.new(name='Artifact of the Growth', stack_size=1,
                        class_name='PrimalItemArtifact_Extinction_ForestKaiju_C',
                        blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_Extinction_ForestKaiju.PrimalItemArtifact_Extinction_ForestKaiju\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Growth_(Extinction)',
                        description='Found within the Forest biome. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/eb/Artifact_of_Growth_%28Extinction%29.png')
    models.Artifact.new(name='Artifact of the Void', stack_size=1,
                        class_name='PrimalItemArtifact_Extinction_IceKaiju_C',
                        blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_Extinction_IceKaiju.PrimalItemArtifact_Extinction_IceKaiju\'"',
                        url='https://ark.fandom.com/wiki/Artifact_of_the_Void_(Extinction)',
                        description='Found within the Ice biome. Only one of these may be carried at a time by an organism.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/61/Artifact_of_the_Void_%28Extinction%29.png')
    models.Artifact.new(name='Allosaurus Brain', stack_size=100, class_name='PrimalItemResource_ApexDrop_Allo_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Allo.PrimalItemResource_ApexDrop_Allo\'"',
                        url='https://ark.fandom.com/wiki/Allosaurus_Brain',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/96/Allosaurus_Brain.png')
    models.Artifact.new(name='Alpha Basilisk Fang', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Basilisk_Alpha_C',
                        blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Basilisk_Alpha.PrimalItemResource_ApexDrop_Basilisk_Alpha\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Basilisk_Fang_(Aberration)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2e/Alpha_Basilisk_Fang_%28Aberration%29.png')
    models.Artifact.new(name='Alpha Carnotaurus Arm', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_AlphaCarno_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaCarno.PrimalItemResource_ApexDrop_AlphaCarno\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Carnotaurus_Arm', description=None,
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Alpha_Carnotaurus_Arm.png')
    models.Artifact.new(name='Alpha Crystal Talon', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_AlphaCrystalWyvern_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/Mega/PrimalItemResource_ApexDrop_AlphaCrystalWyvern.PrimalItemResource_ApexDrop_AlphaCrystalWyvern\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Crystal_Talon_(Crystal_Isles)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0e/Crystal_Talon_%28Crystal_Isles%29.png')
    models.Artifact.new(name='Alpha Karkinos Claw', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_CrabClaw_C',
                        blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_CrabClaw.PrimalItemResource_ApexDrop_CrabClaw\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Karkinos_Claw_(Aberration)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d1/Alpha_Karkinos_Claw_%28Aberration%29.png')
    models.Artifact.new(name='Alpha Leedsichthys Blubber', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_AlphaLeeds_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaLeeds.PrimalItemResource_ApexDrop_AlphaLeeds\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Leedsichthys_Blubber', description=None,
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3e/Alpha_Leedsichthys_Blubber.png')
    models.Artifact.new(name='Alpha Megalodon Fin', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_AlphaMegalodon_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaMegalodon.PrimalItemResource_ApexDrop_AlphaMegalodon\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Megalodon_Fin',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/05/Alpha_Megalodon_Fin.png')
    models.Artifact.new(name='Alpha Mosasaur Tooth', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_AlphaMosasaur_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaMosasaur.PrimalItemResource_ApexDrop_AlphaMosasaur\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Mosasaur_Tooth',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/99/Alpha_Mosasaur_Tooth.png')
    models.Artifact.new(name='Alpha Raptor Claw', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_AlphaRaptor_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaRaptor.PrimalItemResource_ApexDrop_AlphaRaptor\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Raptor_Claw',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/de/Alpha_Raptor_Claw.png')
    models.Artifact.new(name='Alpha Reaper King Barb', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_ReaperBarb_C',
                        blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_ReaperBarb.PrimalItemResource_ApexDrop_ReaperBarb\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Reaper_King_Barb_(Aberration)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/81/Alpha_Reaper_King_Barb_%28Aberration%29.png')
    models.Artifact.new(name='Alpha Tusoteuthis Eye', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_AlphaTuso_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaTuso.PrimalItemResource_ApexDrop_AlphaTuso\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Tusoteuthis_Eye',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bf/Alpha_Tusoteuthis_Eye.png')
    models.Artifact.new(name='Alpha Tyrannosaur Tooth', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_AlphaRex_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaRex.PrimalItemResource_ApexDrop_AlphaRex\'"',
                        url='https://ark.fandom.com/wiki/Alpha_Tyrannosaur_Tooth',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3c/Alpha_Tyrannosaur_Tooth.png')
    models.Artifact.new(name='Alpha X-Triceratops Skull', stack_size=1,
                        class_name='PrimalItemSkin_TrikeSkullHelmet_Retrieve_C',
                        blueprint='"Blueprint\'/Game/Genesis/Missions/Retrieve/RetrieveItems/TrikeSkull/PrimalItemSkin_TrikeSkullHelmet_Retrieve.PrimalItemSkin_TrikeSkullHelmet_Retrieve\'"',
                        url='https://ark.fandom.com/wiki/Alpha_X-Triceratops_Skull_(Genesis:_Part_1)',
                        description='A skull retrieved from a slain Alpha X-Triceratops. This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Alpha_X-Triceratops_Skull_%28Genesis_Part_1%29.png')
    models.Artifact.new(name='Basilisk Scale', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Basilisk_C',
                        blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Basilisk.PrimalItemResource_ApexDrop_Basilisk\'"',
                        url='https://ark.fandom.com/wiki/Basilisk_Scale_(Aberration)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8f/Basilisk_Scale_%28Aberration%29.png')
    models.Artifact.new(name='Basilosaurus Blubber', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Basilo_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Basilo.PrimalItemResource_ApexDrop_Basilo\'"',
                        url='https://ark.fandom.com/wiki/Basilosaurus_Blubber',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/98/Basilosaurus_Blubber.png')
    models.Artifact.new(name='Corrupt Heart', stack_size=100,
                        class_name='PrimalItemResource_RareDrop_CorruptHeart_C',
                        blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Resources/PrimalItemResource_RareDrop_CorruptHeart.PrimalItemResource_RareDrop_CorruptHeart\'"',
                        url='https://ark.fandom.com/wiki/Corrupt_Heart_(Extinction)',
                        description='A heart of a corrupted dinosaur.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/18/Corrupt_Heart_%28Extinction%29.png')
    models.Artifact.new(name='Crystal Talon', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_CrystalWyvern_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/PrimalItemResource_ApexDrop_CrystalWyvern.PrimalItemResource_ApexDrop_CrystalWyvern\'"',
                        url='https://ark.fandom.com/wiki/Crystal_Talon_(Crystal_Isles)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0e/Crystal_Talon_%28Crystal_Isles%29.png')
    models.Artifact.new(name='Fire Talon', stack_size=100, class_name='PrimalItemResource_ApexDrop_FireWyvern_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_FireWyvern.PrimalItemResource_ApexDrop_FireWyvern\'"',
                        url='https://ark.fandom.com/wiki/Fire_Talon_(Scorched_Earth)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Fire_Talon_%28Scorched_Earth%29.png')
    models.Artifact.new(name='Gasbags bladder', stack_size=100, class_name='PrimalItemResource_ApexDrop_GasBag_C',
                        blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_GasBag.PrimalItemResource_ApexDrop_GasBag\'"',
                        url='https://ark.fandom.com/wiki/Gasbags_bladder_(Extinction)',
                        description='An air bladder from a Gasbags',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a3/Gasbags_bladder_%28Extinction%29.png')
    models.Artifact.new(name='Giganotosaurus Heart', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Giga_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Giga.PrimalItemResource_ApexDrop_Giga\'"',
                        url='https://ark.fandom.com/wiki/Giganotosaurus_Heart',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/62/Giganotosaurus_Heart.png')
    models.Artifact.new(name='Golden Striped Megalodon Tooth', stack_size=1,
                        class_name='PrimalItemResource_RetrieveMegTooth_C',
                        blueprint='"Blueprint\'/Game/Genesis/Missions/Retrieve/RetrieveItems/MegTeeth/PrimalItemResource_RetrieveMegTooth.PrimalItemResource_RetrieveMegTooth\'"',
                        url='https://ark.fandom.com/wiki/Golden_Striped_Megalodon_Tooth_(Genesis:_Part_1)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6f/Megalodon_Tooth.png')
    models.Artifact.new(name='Lightning Talon', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_LightningWyvern_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_LightningWyvern.PrimalItemResource_ApexDrop_LightningWyvern\'"',
                        url='https://ark.fandom.com/wiki/Lightning_Talon_(Scorched_Earth)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Lightning_Talon_%28Scorched_Earth%29.png')
    models.Artifact.new(name='Megalania Toxin', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Megalania_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Megalania.PrimalItemResource_ApexDrop_Megalania\'"',
                        url='https://ark.fandom.com/wiki/Megalania_Toxin',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/Megalania_Toxin.png')
    models.Artifact.new(name='Poison Talon', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_PoisonWyvern_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_PoisonWyvern.PrimalItemResource_ApexDrop_PoisonWyvern\'"',
                        url='https://ark.fandom.com/wiki/Poison_Talon_(Scorched_Earth)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1d/Poison_Talon_%28Scorched_Earth%29.png')
    models.Artifact.new(name='Reaper King Pheromone Gland', stack_size=1,
                        class_name='PrimalItemResource_RetrieveReaperGland_C',
                        blueprint='"Blueprint\'/Game/Genesis/Missions/Retrieve/RetrieveItems/ReaperGland/PrimalItemResource_RetrieveReaperGland.PrimalItemResource_RetrieveReaperGland\'"',
                        url='https://ark.fandom.com/wiki/Reaper_King_Pheromone_Gland_(Genesis:_Part_1)',
                        description="Secretion gland extracted from a Reaper King. It doesn't appear to have the same properties as the gland of a Queen.",
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Reaper_Pheromone_Gland_%28Aberration%29.png')
    models.Artifact.new(name='Reaper Pheromone Gland', stack_size=100,
                        class_name='PrimalItemResource_XenomorphPheromoneGland_C',
                        blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_XenomorphPheromoneGland.PrimalItemResource_XenomorphPheromoneGland\'"',
                        url='https://ark.fandom.com/wiki/Reaper_Pheromone_Gland_(Aberration)',
                        description='Secretion gland extracted from a Reaper Queen. Perhaps it has some use...',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Reaper_Pheromone_Gland_%28Aberration%29.png')
    models.Artifact.new(name='Rock Drake Feather', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_RockDrake_C',
                        blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_RockDrake.PrimalItemResource_ApexDrop_RockDrake\'"',
                        url='https://ark.fandom.com/wiki/Rock_Drake_Feather_(Aberration)',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2e/Rock_Drake_Feather_%28Aberration%29.png')
    models.Artifact.new(name='Sarcosuchus Skin', stack_size=100, class_name='PrimalItemResource_ApexDrop_Sarco_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Sarco.PrimalItemResource_ApexDrop_Sarco\'"',
                        url='https://ark.fandom.com/wiki/Sarcosuchus_Skin',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c2/Sarcosuchus_Skin.png')
    models.Artifact.new(name='Spinosaurus Sail', stack_size=100, class_name='PrimalItemResource_ApexDrop_Spino_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Spino.PrimalItemResource_ApexDrop_Spino\'"',
                        url='https://ark.fandom.com/wiki/Spinosaurus_Sail',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Spinosaurus_Sail.png')
    models.Artifact.new(name='Therizino Claws', stack_size=100, class_name='PrimalItemResource_ApexDrop_Theriz_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Theriz.PrimalItemResource_ApexDrop_Theriz\'"',
                        url='https://ark.fandom.com/wiki/Therizino_Claws',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0a/Therizino_Claws.png')
    models.Artifact.new(name='Thylacoleo Hook-Claw', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Thylaco_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Thylaco.PrimalItemResource_ApexDrop_Thylaco\'"',
                        url='https://ark.fandom.com/wiki/Thylacoleo_Hook-Claw',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c8/Thylacoleo_Hook-Claw.png')
    models.Artifact.new(name='Titanoboa Venom', stack_size=100, class_name='PrimalItemResource_ApexDrop_Boa_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Boa.PrimalItemResource_ApexDrop_Boa\'"',
                        url='https://ark.fandom.com/wiki/Titanoboa_Venom',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Titanoboa_Venom.png')
    models.Artifact.new(name='Tusoteuthis Tentacle', stack_size=100,
                        class_name='PrimalItemResource_ApexDrop_Tuso_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Tuso.PrimalItemResource_ApexDrop_Tuso\'"',
                        url='https://ark.fandom.com/wiki/Tusoteuthis_Tentacle',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/10/Tusoteuthis_Tentacle.png')
    models.Artifact.new(name='Yutyrannus Lungs', stack_size=100, class_name='PrimalItemResource_ApexDrop_Yuty_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Yuty.PrimalItemResource_ApexDrop_Yuty\'"',
                        url='https://ark.fandom.com/wiki/Yutyrannus_Lungs',
                        description='This trophy proves your worth as a hunter.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ef/Yutyrannus_Lungs.png')
    models.Artifact.new(name='Mysterious Snow Globe', stack_size=1, class_name='PrimalItem_Bonus_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItem_Bonus.PrimalItem_Bonus\'"',
                        url='https://ark.fandom.com/wiki/Mysterious_Snow_Globe',
                        description='You cannot decipher the data within this Snow Globe until time has passed.',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ad/Mysterious_Snow_Globe.png')
    models.Artifact.new(name='Revealed Snow Globe', stack_size=1, class_name='PrimalItem_Bonus2_C',
                        blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItem_Bonus2.PrimalItem_Bonus2\'"',
                        url='https://ark.fandom.com/wiki/Revealed_Snow_Globe', description='STEAM DISCOUNT CODE:',
                        image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Revealed_Snow_Globe.png')

    items = [item.to_json() for item in models.Artifact.all()]
    print(items)


def seed():
    items = [
        {
            'class_name': 'PrimalItem_StartingNote_C', 'id': 133,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Notes/PrimalItem_StartingNote.PrimalItem_StartingNote\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/55/Specimen_Implant.png',
            'name': 'Specimen Implant', 'stack_size': 1, 'description': 'A mysterious implant attached to your arm.',
            'url': 'https://ark.fandom.com/wiki/Specimen_Implant'
        },
        {
            'class_name': 'PrimalItemArtifact_01_C', 'id': 146,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_01.PrimalItemArtifact_01\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Artifact_of_the_Hunter.png',
            'name': 'Artifact of the Hunter', 'stack_size': 1,
            'description': 'With relentless determination, the hunter will never waver until it catches its prey. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Hunter'
        },
        {
            'class_name': 'PrimalItemArtifact_02_C', 'id': 147,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_02.PrimalItemArtifact_02\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Artifact_of_the_Pack.png',
            'name': 'Artifact of the Pack', 'stack_size': 1,
            'description': 'Stronger than any lone creature, one may die but the pack will survive. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Pack'
        },
        {
            'class_name': 'PrimalItemArtifact_03_C', 'id': 148,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_03.PrimalItemArtifact_03\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c6/Artifact_of_the_Massive.png',
            'name': 'Artifact of the Massive', 'stack_size': 1,
            'description': 'Size alone can sometimes mean the difference between survival and oblivion. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Massive'
        },
        {
            'class_name': 'PrimalItemArtifact_04_C', 'id': 149,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_04.PrimalItemArtifact_04\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b4/Artifact_of_the_Devious.png',
            'name': 'Artifact of the Devious', 'stack_size': 1,
            'description': "With craft and cunning, to look out for one's self may be essential to survival. Only one of these may be carried at a time by an organism.",
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Devious'
        },
        {
            'class_name': 'PrimalItemArtifact_05_C', 'id': 150,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_05.PrimalItemArtifact_05\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/80/Artifact_of_the_Clever.png',
            'name': 'Artifact of the Clever', 'stack_size': 1,
            'description': "Wit and quick thinking may turn the odds in one's favor, even when nature has other plans. Only one of these may be carried at a time by an organism.",
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Clever'
        },
        {
            'class_name': 'PrimalItemArtifact_06_C', 'id': 151,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_06.PrimalItemArtifact_06\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e4/Artifact_of_the_Skylord.png',
            'name': 'Artifact of the Skylord', 'stack_size': 1,
            'description': 'Mastery of the skies confers a distinct advantage over earthbound competition. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Skylord'
        },
        {
            'class_name': 'PrimalItemArtifact_07_C', 'id': 152,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_07.PrimalItemArtifact_07\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7c/Artifact_of_the_Devourer.png',
            'name': 'Artifact of the Devourer', 'stack_size': 1,
            'description': 'To consume is to become, and to become is to evolve. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Devourer'
        },
        {
            'class_name': 'PrimalItemArtifact_08_C', 'id': 153,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_08.PrimalItemArtifact_08\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/23/Artifact_of_the_Immune.png',
            'name': 'Artifact of the Immune', 'stack_size': 1,
            'description': "With a mastery of one's equilibrium, no simple poison nor toxin can be a threat. Only one of these may be carried at a time by an organism.",
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Immune'
        },
        {
            'class_name': 'PrimalItemArtifact_09_C', 'id': 154,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_09.PrimalItemArtifact_09\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5b/Artifact_of_the_Strong.png',
            'name': 'Artifact of the Strong', 'stack_size': 1,
            'description': 'Such power may be crucial when survival becomes a question of raw physical capability. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Strong'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Argentavis_C', 'id': 155,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Argentavis.PrimalItemResource_ApexDrop_Argentavis\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Argentavis_Talon.png',
            'name': 'Argentavis Talon', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Argentavis_Talon'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Megalodon_C', 'id': 156,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Megalodon.PrimalItemResource_ApexDrop_Megalodon\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6f/Megalodon_Tooth.png',
            'name': 'Megalodon Tooth', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Megalodon_Tooth'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Rex_C', 'id': 157,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Rex.PrimalItemResource_ApexDrop_Rex\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Tyrannosaurus_Arm.png',
            'name': 'Tyrannosaurus Arm', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Tyrannosaurus_Arm'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Sauro_C', 'id': 158,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Sauro.PrimalItemResource_ApexDrop_Sauro\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Sauropod_Vertebra.png',
            'name': 'Sauropod Vertebra', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Sauropod_Vertebra'
        },
        {
            'class_name': 'PrimalItemArtifact_12_C', 'id': 159,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_12.PrimalItemArtifact_12\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/4b/Artifact_of_the_Brute.png',
            'name': 'Artifact of the Brute', 'stack_size': 1,
            'description': "Striking fear into the hearts of one's enemies may be a crucial component of survival. Only one of these may be carried at a time by an organism.",
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Brute'
        },
        {
            'class_name': 'PrimalItemArtifact_11_C', 'id': 160,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_11.PrimalItemArtifact_11\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/66/Artifact_of_the_Cunning.png',
            'name': 'Artifact of the Cunning', 'stack_size': 1,
            'description': "With craft and strategy, to outwit one's opponents may be essential to survival. Only one of these may be carried at a time by an organism.",
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Cunning'
        },
        {
            'class_name': 'PrimalItemArtifactAB_4_C', 'id': 161,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactAB_4.PrimalItemArtifactAB_4\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/49/Artifact_of_the_Lost.png',
            'name': 'Artifact of the Lost', 'stack_size': 1,
            'description': 'Found within the depths of Aberration. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Lost'
        },
        {
            'class_name': 'PrimalItemArtifactSE_01_C', 'id': 162,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactSE_01.PrimalItemArtifactSE_01\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Artifact_of_the_Gatekeeper_%28Scorched_Earth%29.png',
            'name': 'Artifact of the Gatekeeper ', 'stack_size': 1,
            'description': 'Found within the depths of the Scorched Earth. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Gatekeeper_(Scorched_Earth)'
        },
        {
            'class_name': 'PrimalItemArtifactSE_02_C', 'id': 163,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactSE_02.PrimalItemArtifactSE_02\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b0/Artifact_of_the_Crag_%28Scorched_Earth%29.png',
            'name': 'Artifact of the Crag ', 'stack_size': 1,
            'description': 'Found within the depths of the Scorched Earth. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Crag_(Scorched_Earth)'
        },
        {
            'class_name': 'PrimalItemArtifactSE_03_C', 'id': 164,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactSE_03.PrimalItemArtifactSE_03\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/e5/Artifact_of_the_Destroyer_%28Scorched_Earth%29.png',
            'name': 'Artifact of the Destroyer ', 'stack_size': 1,
            'description': 'Found within the depths of the Scorched Earth. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Destroyer_(Scorched_Earth)'
        },
        {
            'class_name': 'PrimalItemArtifactAB_C', 'id': 165,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactAB.PrimalItemArtifactAB\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/91/Artifact_of_the_Depths_%28Aberration%29.png',
            'name': 'Artifact of the Depths ', 'stack_size': 1,
            'description': 'Found within the depths of Aberration. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Depths_(Aberration)'
        },
        {
            'class_name': 'PrimalItemArtifactAB_2_C', 'id': 166,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactAB_2.PrimalItemArtifactAB_2\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/83/Artifact_of_the_Shadows_%28Aberration%29.png',
            'name': 'Artifact of the Shadows ', 'stack_size': 1,
            'description': 'Found within the depths of Aberration. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Shadows_(Aberration)'
        },
        {
            'class_name': 'PrimalItemArtifactAB_3_C', 'id': 167,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItemArtifactAB_3.PrimalItemArtifactAB_3\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/53/Artifact_of_the_Stalker_%28Aberration%29.png',
            'name': 'Artifact of the Stalker ', 'stack_size': 1,
            'description': 'Found within the depths of Aberration. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Stalker_(Aberration)'
        },
        {
            'class_name': 'PrimalItemArtifact_Extinction_DesertKaiju_C', 'id': 168,
            'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_Extinction_DesertKaiju.PrimalItemArtifact_Extinction_DesertKaiju\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1b/Artifact_of_Chaos_%28Extinction%29.png',
            'name': 'Artifact of the Chaos', 'stack_size': 1,
            'description': 'Found within the Desert biome.  Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Chaos_(Extinction)'
        },
        {
            'class_name': 'PrimalItemArtifact_Extinction_ForestKaiju_C', 'id': 169,
            'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_Extinction_ForestKaiju.PrimalItemArtifact_Extinction_ForestKaiju\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/eb/Artifact_of_Growth_%28Extinction%29.png',
            'name': 'Artifact of the Growth', 'stack_size': 1,
            'description': 'Found within the Forest biome. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Growth_(Extinction)'
        },
        {
            'class_name': 'PrimalItemArtifact_Extinction_IceKaiju_C', 'id': 170,
            'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Artifacts/PrimalItemArtifact_Extinction_IceKaiju.PrimalItemArtifact_Extinction_IceKaiju\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/61/Artifact_of_the_Void_%28Extinction%29.png',
            'name': 'Artifact of the Void', 'stack_size': 1,
            'description': 'Found within the Ice biome. Only one of these may be carried at a time by an organism.',
            'url': 'https://ark.fandom.com/wiki/Artifact_of_the_Void_(Extinction)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Allo_C', 'id': 171,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Allo.PrimalItemResource_ApexDrop_Allo\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/96/Allosaurus_Brain.png',
            'name': 'Allosaurus Brain', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Allosaurus_Brain'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Basilisk_Alpha_C', 'id': 172,
            'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Basilisk_Alpha.PrimalItemResource_ApexDrop_Basilisk_Alpha\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2e/Alpha_Basilisk_Fang_%28Aberration%29.png',
            'name': 'Alpha Basilisk Fang', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Alpha_Basilisk_Fang_(Aberration)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_AlphaCarno_C', 'id': 173,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaCarno.PrimalItemResource_ApexDrop_AlphaCarno\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Alpha_Carnotaurus_Arm.png',
            'name': 'Alpha Carnotaurus Arm', 'stack_size': 100, 'description': None,
            'url': 'https://ark.fandom.com/wiki/Alpha_Carnotaurus_Arm'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_AlphaCrystalWyvern_C', 'id': 174,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/Mega/PrimalItemResource_ApexDrop_AlphaCrystalWyvern.PrimalItemResource_ApexDrop_AlphaCrystalWyvern\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0e/Crystal_Talon_%28Crystal_Isles%29.png',
            'name': 'Alpha Crystal Talon', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Alpha_Crystal_Talon_(Crystal_Isles)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_CrabClaw_C', 'id': 175,
            'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_CrabClaw.PrimalItemResource_ApexDrop_CrabClaw\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d1/Alpha_Karkinos_Claw_%28Aberration%29.png',
            'name': 'Alpha Karkinos Claw', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Alpha_Karkinos_Claw_(Aberration)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_AlphaLeeds_C', 'id': 176,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaLeeds.PrimalItemResource_ApexDrop_AlphaLeeds\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3e/Alpha_Leedsichthys_Blubber.png',
            'name': 'Alpha Leedsichthys Blubber', 'stack_size': 100, 'description': None,
            'url': 'https://ark.fandom.com/wiki/Alpha_Leedsichthys_Blubber'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_AlphaMegalodon_C', 'id': 177,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaMegalodon.PrimalItemResource_ApexDrop_AlphaMegalodon\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/05/Alpha_Megalodon_Fin.png',
            'name': 'Alpha Megalodon Fin', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Alpha_Megalodon_Fin'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_AlphaMosasaur_C', 'id': 178,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaMosasaur.PrimalItemResource_ApexDrop_AlphaMosasaur\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/99/Alpha_Mosasaur_Tooth.png',
            'name': 'Alpha Mosasaur Tooth', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Alpha_Mosasaur_Tooth'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_AlphaRaptor_C', 'id': 179,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaRaptor.PrimalItemResource_ApexDrop_AlphaRaptor\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/de/Alpha_Raptor_Claw.png',
            'name': 'Alpha Raptor Claw', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Alpha_Raptor_Claw'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_ReaperBarb_C', 'id': 180,
            'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_ReaperBarb.PrimalItemResource_ApexDrop_ReaperBarb\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/81/Alpha_Reaper_King_Barb_%28Aberration%29.png',
            'name': 'Alpha Reaper King Barb', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Alpha_Reaper_King_Barb_(Aberration)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_AlphaTuso_C', 'id': 181,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaTuso.PrimalItemResource_ApexDrop_AlphaTuso\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bf/Alpha_Tusoteuthis_Eye.png',
            'name': 'Alpha Tusoteuthis Eye', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Alpha_Tusoteuthis_Eye'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_AlphaRex_C', 'id': 182,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_AlphaRex.PrimalItemResource_ApexDrop_AlphaRex\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3c/Alpha_Tyrannosaur_Tooth.png',
            'name': 'Alpha Tyrannosaur Tooth', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Alpha_Tyrannosaur_Tooth'
        },
        {
            'class_name': 'PrimalItemSkin_TrikeSkullHelmet_Retrieve_C', 'id': 183,
            'blueprint': '"Blueprint\'/Game/Genesis/Missions/Retrieve/RetrieveItems/TrikeSkull/PrimalItemSkin_TrikeSkullHelmet_Retrieve.PrimalItemSkin_TrikeSkullHelmet_Retrieve\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/65/Alpha_X-Triceratops_Skull_%28Genesis_Part_1%29.png',
            'name': 'Alpha X-Triceratops Skull', 'stack_size': 1,
            'description': 'A skull retrieved from a slain Alpha X-Triceratops. This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Alpha_X-Triceratops_Skull_(Genesis:_Part_1)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Basilisk_C', 'id': 184,
            'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Basilisk.PrimalItemResource_ApexDrop_Basilisk\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8f/Basilisk_Scale_%28Aberration%29.png',
            'name': 'Basilisk Scale', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Basilisk_Scale_(Aberration)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Basilo_C', 'id': 185,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Basilo.PrimalItemResource_ApexDrop_Basilo\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/98/Basilosaurus_Blubber.png',
            'name': 'Basilosaurus Blubber', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Basilosaurus_Blubber'
        },
        {
            'class_name': 'PrimalItemResource_RareDrop_CorruptHeart_C', 'id': 186,
            'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Resources/PrimalItemResource_RareDrop_CorruptHeart.PrimalItemResource_RareDrop_CorruptHeart\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/18/Corrupt_Heart_%28Extinction%29.png',
            'name': 'Corrupt Heart', 'stack_size': 100, 'description': 'A heart of a corrupted dinosaur.',
            'url': 'https://ark.fandom.com/wiki/Corrupt_Heart_(Extinction)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_CrystalWyvern_C', 'id': 187,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/Dinos/CrystalWyvern/PrimalItemResource_ApexDrop_CrystalWyvern.PrimalItemResource_ApexDrop_CrystalWyvern\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0e/Crystal_Talon_%28Crystal_Isles%29.png',
            'name': 'Crystal Talon', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Crystal_Talon_(Crystal_Isles)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_FireWyvern_C', 'id': 188,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_FireWyvern.PrimalItemResource_ApexDrop_FireWyvern\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Fire_Talon_%28Scorched_Earth%29.png',
            'name': 'Fire Talon', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Fire_Talon_(Scorched_Earth)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_GasBag_C', 'id': 189,
            'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_GasBag.PrimalItemResource_ApexDrop_GasBag\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a3/Gasbags_bladder_%28Extinction%29.png',
            'name': 'Gasbags bladder', 'stack_size': 100, 'description': 'An air bladder from a Gasbags',
            'url': 'https://ark.fandom.com/wiki/Gasbags_bladder_(Extinction)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Giga_C', 'id': 190,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Giga.PrimalItemResource_ApexDrop_Giga\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/62/Giganotosaurus_Heart.png',
            'name': 'Giganotosaurus Heart', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Giganotosaurus_Heart'
        },
        {
            'class_name': 'PrimalItemResource_RetrieveMegTooth_C', 'id': 191,
            'blueprint': '"Blueprint\'/Game/Genesis/Missions/Retrieve/RetrieveItems/MegTeeth/PrimalItemResource_RetrieveMegTooth.PrimalItemResource_RetrieveMegTooth\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6f/Megalodon_Tooth.png',
            'name': 'Golden Striped Megalodon Tooth', 'stack_size': 1,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Golden_Striped_Megalodon_Tooth_(Genesis:_Part_1)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_LightningWyvern_C', 'id': 192,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_LightningWyvern.PrimalItemResource_ApexDrop_LightningWyvern\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Lightning_Talon_%28Scorched_Earth%29.png',
            'name': 'Lightning Talon', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Lightning_Talon_(Scorched_Earth)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Megalania_C', 'id': 193,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Megalania.PrimalItemResource_ApexDrop_Megalania\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/Megalania_Toxin.png',
            'name': 'Megalania Toxin', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Megalania_Toxin'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_PoisonWyvern_C', 'id': 194,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_PoisonWyvern.PrimalItemResource_ApexDrop_PoisonWyvern\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1d/Poison_Talon_%28Scorched_Earth%29.png',
            'name': 'Poison Talon', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Poison_Talon_(Scorched_Earth)'
        },
        {
            'class_name': 'PrimalItemResource_RetrieveReaperGland_C', 'id': 195,
            'blueprint': '"Blueprint\'/Game/Genesis/Missions/Retrieve/RetrieveItems/ReaperGland/PrimalItemResource_RetrieveReaperGland.PrimalItemResource_RetrieveReaperGland\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Reaper_Pheromone_Gland_%28Aberration%29.png',
            'name': 'Reaper King Pheromone Gland', 'stack_size': 1,
            'description': "Secretion gland extracted from a Reaper King. It doesn't appear to have the same properties as the gland of a Queen.",
            'url': 'https://ark.fandom.com/wiki/Reaper_King_Pheromone_Gland_(Genesis:_Part_1)'
        },
        {
            'class_name': 'PrimalItemResource_XenomorphPheromoneGland_C', 'id': 196,
            'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_XenomorphPheromoneGland.PrimalItemResource_XenomorphPheromoneGland\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d3/Reaper_Pheromone_Gland_%28Aberration%29.png',
            'name': 'Reaper Pheromone Gland', 'stack_size': 100,
            'description': 'Secretion gland extracted from a Reaper Queen. Perhaps it has some use...',
            'url': 'https://ark.fandom.com/wiki/Reaper_Pheromone_Gland_(Aberration)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_RockDrake_C', 'id': 197,
            'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_RockDrake.PrimalItemResource_ApexDrop_RockDrake\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2e/Rock_Drake_Feather_%28Aberration%29.png',
            'name': 'Rock Drake Feather', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Rock_Drake_Feather_(Aberration)'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Sarco_C', 'id': 198,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Sarco.PrimalItemResource_ApexDrop_Sarco\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c2/Sarcosuchus_Skin.png',
            'name': 'Sarcosuchus Skin', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Sarcosuchus_Skin'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Spino_C', 'id': 199,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Spino.PrimalItemResource_ApexDrop_Spino\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6a/Spinosaurus_Sail.png',
            'name': 'Spinosaurus Sail', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Spinosaurus_Sail'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Theriz_C', 'id': 200,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Theriz.PrimalItemResource_ApexDrop_Theriz\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0a/Therizino_Claws.png',
            'name': 'Therizino Claws', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Therizino_Claws'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Thylaco_C', 'id': 201,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Thylaco.PrimalItemResource_ApexDrop_Thylaco\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c8/Thylacoleo_Hook-Claw.png',
            'name': 'Thylacoleo Hook-Claw', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Thylacoleo_Hook-Claw'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Boa_C', 'id': 202,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Boa.PrimalItemResource_ApexDrop_Boa\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Titanoboa_Venom.png',
            'name': 'Titanoboa Venom', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Titanoboa_Venom'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Tuso_C', 'id': 203,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Tuso.PrimalItemResource_ApexDrop_Tuso\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/10/Tusoteuthis_Tentacle.png',
            'name': 'Tusoteuthis Tentacle', 'stack_size': 100,
            'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Tusoteuthis_Tentacle'
        },
        {
            'class_name': 'PrimalItemResource_ApexDrop_Yuty_C', 'id': 204,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Resources/PrimalItemResource_ApexDrop_Yuty.PrimalItemResource_ApexDrop_Yuty\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ef/Yutyrannus_Lungs.png',
            'name': 'Yutyrannus Lungs', 'stack_size': 100, 'description': 'This trophy proves your worth as a hunter.',
            'url': 'https://ark.fandom.com/wiki/Yutyrannus_Lungs'
        },
        {
            'class_name': 'PrimalItem_Bonus_C', 'id': 205,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItem_Bonus.PrimalItem_Bonus\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ad/Mysterious_Snow_Globe.png',
            'name': 'Mysterious Snow Globe', 'stack_size': 1,
            'description': 'You cannot decipher the data within this Snow Globe until time has passed.',
            'url': 'https://ark.fandom.com/wiki/Mysterious_Snow_Globe'
        },
        {
            'class_name': 'PrimalItem_Bonus2_C', 'id': 206,
            'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Artifacts/PrimalItem_Bonus2.PrimalItem_Bonus2\'"',
            'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Revealed_Snow_Globe.png',
            'name': 'Revealed Snow Globe', 'stack_size': 1, 'description': 'STEAM DISCOUNT CODE:',
            'url': 'https://ark.fandom.com/wiki/Revealed_Snow_Globe'
        }
    ]
    models.Artifact.bulk_insert(items)
