from arkdata import models


def backup_seed():
    models.Armour.new(id=497, name='Tek Shoulder Cannon', stack_size=1,
                      class_name='PrimalItemArmor_ShoulderCannon_C',
                      blueprint='"Blueprint\'/Game/Genesis/Items/Armor/PrimalItemArmor_ShoulderCannon.PrimalItemArmor_ShoulderCannon\'"',
                      url='https://ark.fandom.com/wiki/Tek_Shoulder_Cannon_(Genesis:_Part_1)',
                      description='A shoulder mounted energy weapon with configurable targeting and firing modes. Equipping this requires learning its Tekgram.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5d/Tek_Shoulder_Cannon_%28Genesis_Part_1%29.png')
    models.Armour.new(id=445, name='Riot Helmet', stack_size=1, class_name='PrimalItemArmor_RiotHelmet_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Riot/PrimalItemArmor_RiotHelmet.PrimalItemArmor_RiotHelmet\'"',
                      url='https://ark.fandom.com/wiki/Riot_Helmet',
                      description='Provides heavy physical protection and reduced physical torpor, but provides almost no protection from the elements.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Riot_Helmet.png')
    models.Armour.new(id=444, name='Riot Boots', stack_size=1, class_name='PrimalItemArmor_RiotBoots_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Riot/PrimalItemArmor_RiotBoots.PrimalItemArmor_RiotBoots\'"',
                      url='https://ark.fandom.com/wiki/Riot_Boots',
                      description='Provides heavy physical protection and reduced physical torpor, but provides almost no protection from the elements.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Riot_Boots.png')
    models.Armour.new(id=443, name='Riot Gauntlets', stack_size=1, class_name='PrimalItemArmor_RiotGloves_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Riot/PrimalItemArmor_RiotGloves.PrimalItemArmor_RiotGloves\'"',
                      url='https://ark.fandom.com/wiki/Riot_Gauntlets',
                      description='Provides heavy physical protection and reduced physical torpor, but provides almost no protection from the elements.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d1/Riot_Gauntlets.png')
    models.Armour.new(id=442, name='Riot Chestpiece', stack_size=1, class_name='PrimalItemArmor_RiotShirt_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Riot/PrimalItemArmor_RiotShirt.PrimalItemArmor_RiotShirt\'"',
                      url='https://ark.fandom.com/wiki/Riot_Chestpiece',
                      description='Provides heavy physical protection and reduced physical torpor, but provides almost no protection from the elements.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Riot_Chestpiece.png')
    models.Armour.new(id=441, name='Riot Leggings', stack_size=1, class_name='PrimalItemArmor_RiotPants_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Riot/PrimalItemArmor_RiotPants.PrimalItemArmor_RiotPants\'"',
                      url='https://ark.fandom.com/wiki/Riot_Leggings',
                      description='Provides heavy physical protection and reduced physical torpor, but provides almost no protection from the elements.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ab/Riot_Leggings.png')
    models.Armour.new(id=428, name='Fur Gauntlets', stack_size=1, class_name='PrimalItemArmor_FurGloves_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Fur/PrimalItemArmor_FurGloves.PrimalItemArmor_FurGloves\'"',
                      url='https://ark.fandom.com/wiki/Fur_Gauntlets',
                      description='Provides significant physical protection. Also keeps your temperature up, so long as it stays dry.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c5/Fur_Gauntlets.png')
    models.Armour.new(id=427, name='Fur Boots', stack_size=1, class_name='PrimalItemArmor_FurBoots_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Fur/PrimalItemArmor_FurBoots.PrimalItemArmor_FurBoots\'"',
                      url='https://ark.fandom.com/wiki/Fur_Boots',
                      description='Provides significant physical protection. Also keeps your temperature up, so long as it stays dry.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/63/Fur_Boots.png')
    models.Armour.new(id=426, name='Fur Cap', stack_size=1, class_name='PrimalItemArmor_FurHelmet_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Fur/PrimalItemArmor_FurHelmet.PrimalItemArmor_FurHelmet\'"',
                      url='https://ark.fandom.com/wiki/Fur_Cap',
                      description='Provides significant physical protection. Also keeps your temperature up, so long as it stays dry.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fe/Fur_Cap.png')
    models.Armour.new(id=425, name='Fur Chestpiece', stack_size=1, class_name='PrimalItemArmor_FurShirt_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Fur/PrimalItemArmor_FurShirt.PrimalItemArmor_FurShirt\'"',
                      url='https://ark.fandom.com/wiki/Fur_Chestpiece',
                      description='Provides significant physical protection. Also keeps your temperature up, so long as it stays dry.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b3/Fur_Chestpiece.png')
    models.Armour.new(id=424, name='Fur Leggings', stack_size=1, class_name='PrimalItemArmor_FurPants_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Fur/PrimalItemArmor_FurPants.PrimalItemArmor_FurPants\'"',
                      url='https://ark.fandom.com/wiki/Fur_Leggings',
                      description='Provides significant physical protection. Also keeps your temperature up, so long as it stays dry.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9c/Fur_Leggings.png')
    models.Armour.new(id=385, name='SCUBA Flippers', stack_size=1, class_name='PrimalItemArmor_ScubaBoots_Flippers_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_ScubaBoots_Flippers.PrimalItemArmor_ScubaBoots_Flippers\'"',
                      url='https://ark.fandom.com/wiki/SCUBA_Flippers',
                      description='These flippers are firm, but flexible. Wearing them increases swim speed, but decreases walking speed.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/SCUBA_Flippers.png')
    models.Armour.new(id=384, name='SCUBA Mask', stack_size=1, class_name='PrimalItemArmor_ScubaHelmet_Goggles_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_ScubaHelmet_Goggles.PrimalItemArmor_ScubaHelmet_Goggles\'"',
                      url='https://ark.fandom.com/wiki/SCUBA_Mask',
                      description='Connects to a SCUBA Tank, allowing the wearer to breathe underwater for as long as the tank has oxygen.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/SCUBA_Mask.png')
    models.Armour.new(id=383, name='SCUBA Tank', stack_size=1, class_name='PrimalItemArmor_ScubaShirt_SuitWithTank_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_ScubaShirt_SuitWithTank.PrimalItemArmor_ScubaShirt_SuitWithTank\'"',
                      url='https://ark.fandom.com/wiki/SCUBA_Tank',
                      description="A tank that's filled with Oxygen. Used to temporarily breathe underwater.",
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a9/SCUBA_Tank.png')
    models.Armour.new(id=301, name="Heavy Miner's Helmet", stack_size=1,
                      class_name='PrimalItemArmor_MinersHelmet_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MinersHelmet.PrimalItemArmor_MinersHelmet\'"',
                      url='https://ark.fandom.com/wiki/Heavy_Miner%27s_Helmet',
                      description='Provides heavy physical protection, but makes the elements harder to endure. Comes with a built-in light source, which wears out over time.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9a/Heavy_Miner%27s_Helmet.png')
    models.Armour.new(id=222, name='Flak Gauntlets', stack_size=1, class_name='PrimalItemArmor_MetalGloves_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MetalGloves.PrimalItemArmor_MetalGloves\'"',
                      url='https://ark.fandom.com/wiki/Flak_Gauntlets',
                      description='Provides heavy physical protection, but makes the elements harder to endure.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f2/Flak_Gauntlets.png')
    models.Armour.new(id=221, name='Flak Boots', stack_size=1, class_name='PrimalItemArmor_MetalBoots_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MetalBoots.PrimalItemArmor_MetalBoots\'"',
                      url='https://ark.fandom.com/wiki/Flak_Boots',
                      description='Provides heavy physical protection, but makes the elements harder to endure.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Flak_Boots.png')
    models.Armour.new(id=220, name='Flak Helmet', stack_size=1, class_name='PrimalItemArmor_MetalHelmet_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MetalHelmet.PrimalItemArmor_MetalHelmet\'"',
                      url='https://ark.fandom.com/wiki/Flak_Helmet',
                      description='Provides heavy physical protection, but makes the elements harder to endure.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Flak_Helmet.png')
    models.Armour.new(id=219, name='Flak Chestpiece', stack_size=1, class_name='PrimalItemArmor_MetalShirt_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MetalShirt.PrimalItemArmor_MetalShirt\'"',
                      url='https://ark.fandom.com/wiki/Flak_Chestpiece',
                      description='Provides heavy physical protection, but makes the elements harder to endure.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bf/Flak_Chestpiece.png')
    models.Armour.new(id=218, name='Flak Leggings', stack_size=1, class_name='PrimalItemArmor_MetalPants_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MetalPants.PrimalItemArmor_MetalPants\'"',
                      url='https://ark.fandom.com/wiki/Flak_Leggings',
                      description='Provides heavy physical protection, but makes the elements harder to endure.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Flak_Leggings.png')
    models.Armour.new(id=184, name='Parachute', stack_size=20, class_name='PrimalItemConsumableBuff_Parachute_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/BaseBPs/PrimalItemConsumableBuff_Parachute.PrimalItemConsumableBuff_Parachute\'"',
                      url='https://ark.fandom.com/wiki/Parachute',
                      description='Use this while falling to slow your fall. Jump while parachuting to deactivate it.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/86/Parachute.png')
    models.Armour.new(id=31, name='Chitin Gauntlets', stack_size=1, class_name='PrimalItemArmor_ChitinGloves_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Chitin/PrimalItemArmor_ChitinGloves.PrimalItemArmor_ChitinGloves\'"',
                      url='https://ark.fandom.com/wiki/Chitin_Gauntlets',
                      description='Provides moderate physical protection, but can get a little warm.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b9/Chitin_Gauntlets.png')
    models.Armour.new(id=30, name='Chitin Boots', stack_size=1, class_name='PrimalItemArmor_ChitinBoots_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Chitin/PrimalItemArmor_ChitinBoots.PrimalItemArmor_ChitinBoots\'"',
                      url='https://ark.fandom.com/wiki/Chitin_Boots',
                      description='Provides moderate physical protection, but can get a little warm.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0d/Chitin_Boots.png')
    models.Armour.new(id=29, name='Chitin Helmet', stack_size=1, class_name='PrimalItemArmor_ChitinHelmet_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Chitin/PrimalItemArmor_ChitinHelmet.PrimalItemArmor_ChitinHelmet\'"',
                      url='https://ark.fandom.com/wiki/Chitin_Helmet',
                      description='Provides moderate physical protection, but can get a little warm.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Chitin_Helmet.png')
    models.Armour.new(id=28, name='Chitin Chestpiece', stack_size=1, class_name='PrimalItemArmor_ChitinShirt_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Chitin/PrimalItemArmor_ChitinShirt.PrimalItemArmor_ChitinShirt\'"',
                      url='https://ark.fandom.com/wiki/Chitin_Chestpiece',
                      description='Provides moderate physical protection, but can get a little warm.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f1/Chitin_Chestpiece.png')
    models.Armour.new(id=27, name='Chitin Leggings', stack_size=1, class_name='PrimalItemArmor_ChitinPants_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Chitin/PrimalItemArmor_ChitinPants.PrimalItemArmor_ChitinPants\'"',
                      url='https://ark.fandom.com/wiki/Chitin_Leggings',
                      description='Provides moderate physical protection, but can get a little warm.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Chitin_Leggings.png')
    models.Armour.new(id=26, name='Hide Gloves', stack_size=1, class_name='PrimalItemArmor_HideGloves_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Leather/PrimalItemArmor_HideGloves.PrimalItemArmor_HideGloves\'"',
                      url='https://ark.fandom.com/wiki/Hide_Gloves',
                      description='Keeps you warm while providing some physical protection.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/09/Hide_Gloves.png')
    models.Armour.new(id=25, name='Hide Boots', stack_size=1, class_name='PrimalItemArmor_HideBoots_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Leather/PrimalItemArmor_HideBoots.PrimalItemArmor_HideBoots\'"',
                      url='https://ark.fandom.com/wiki/Hide_Boots',
                      description='Keeps you warm while providing some physical protection.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Hide_Boots.png')
    models.Armour.new(id=24, name='Hide Hat', stack_size=1, class_name='PrimalItemArmor_HideHelmet_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Leather/PrimalItemArmor_HideHelmet.PrimalItemArmor_HideHelmet\'"',
                      url='https://ark.fandom.com/wiki/Hide_Hat',
                      description='Keeps you warm while providing some physical protection.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Hide_Hat.png')
    models.Armour.new(id=23, name='Hide Shirt', stack_size=1, class_name='PrimalItemArmor_HideShirt_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Leather/PrimalItemArmor_HideShirt.PrimalItemArmor_HideShirt\'"',
                      url='https://ark.fandom.com/wiki/Hide_Shirt',
                      description='Keeps you warm while providing some physical protection.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f3/Hide_Shirt.png')
    models.Armour.new(id=22, name='Hide Pants', stack_size=1, class_name='PrimalItemArmor_HidePants_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Leather/PrimalItemArmor_HidePants.PrimalItemArmor_HidePants\'"',
                      url='https://ark.fandom.com/wiki/Hide_Pants',
                      description='Keeps you warm while providing some physical protection',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/44/Hide_Pants.png')
    models.Armour.new(id=21, name='Cloth Gloves', stack_size=1, class_name='PrimalItemArmor_ClothGloves_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Cloth/PrimalItemArmor_ClothGloves.PrimalItemArmor_ClothGloves\'"',
                      url='https://ark.fandom.com/wiki/Cloth_Gloves',
                      description='Hide-padded gloves provide some protection from the heat and cold, but only minimal protection from injuries.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Cloth_Gloves.png')
    models.Armour.new(id=20, name='Cloth Boots', stack_size=1, class_name='PrimalItemArmor_ClothBoots_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Cloth/PrimalItemArmor_ClothBoots.PrimalItemArmor_ClothBoots\'"',
                      url='https://ark.fandom.com/wiki/Cloth_Boots',
                      description='Hide-soled shoes provide some protection from the heat and cold, but only minimal protection from injuries.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Cloth_Boots.png')
    models.Armour.new(id=19, name='Cloth Hat', stack_size=1, class_name='PrimalItemArmor_ClothHelmet_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Cloth/PrimalItemArmor_ClothHelmet.PrimalItemArmor_ClothHelmet\'"',
                      url='https://ark.fandom.com/wiki/Cloth_Hat',
                      description='Provides some protection from the heat and cold, but only minimal protection from injuries.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Cloth_Hat.png')
    models.Armour.new(id=18, name='Cloth Shirt', stack_size=1, class_name='PrimalItemArmor_ClothShirt_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Cloth/PrimalItemArmor_ClothShirt.PrimalItemArmor_ClothShirt\'"',
                      url='https://ark.fandom.com/wiki/Cloth_Shirt',
                      description='Provides some protection from the heat and cold, but only minimal protection from injuries.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f0/Cloth_Shirt.png')
    models.Armour.new(id=17, name='Cloth Pants', stack_size=1, class_name='PrimalItemArmor_ClothPants_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Cloth/PrimalItemArmor_ClothPants.PrimalItemArmor_ClothPants\'"',
                      url='https://ark.fandom.com/wiki/Cloth_Pants',
                      description='Provides some protection from the heat and cold, but only minimal protection from injuries.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/69/Cloth_Pants.png')
    models.Armour.new(name='Tek Boots', stack_size=1, class_name='PrimalItemArmor_TekBoots_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/TEK/PrimalItemArmor_TekBoots.PrimalItemArmor_TekBoots\'"',
                      url='https://ark.fandom.com/wiki/Tek_Boots',
                      description='Highly advanced boots capable of absorbing the impact of falling from high distances. Equipping requires learning this Tekgram.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1b/Tek_Boots.png')
    models.Armour.new(name='Tek Chestpiece', stack_size=1, class_name='PrimalItemArmor_TekShirt_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/TEK/PrimalItemArmor_TekShirt.PrimalItemArmor_TekShirt\'"',
                      url='https://ark.fandom.com/wiki/Tek_Chestpiece',
                      description='Highly advanced chestpiece with an integrated jetpack. Equipping requires learning this Tekgram.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/21/Tek_Chestpiece.png')
    models.Armour.new(name='Tek Gauntlets', stack_size=1, class_name='PrimalItemArmor_TekGloves_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/TEK/PrimalItemArmor_TekGloves.PrimalItemArmor_TekGloves\'"',
                      url='https://ark.fandom.com/wiki/Tek_Gauntlets',
                      description='Highly advanced gauntlets that allow the wearer to perform devastating punches. Equipping requires learning this Tekgram.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/21/Tek_Gauntlets.png')
    models.Armour.new(name='Tek Helmet', stack_size=1, class_name='PrimalItemArmor_TekHelmet_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/TEK/PrimalItemArmor_TekHelmet.PrimalItemArmor_TekHelmet\'"',
                      url='https://ark.fandom.com/wiki/Tek_Helmet',
                      description="Never get lost again with the Tek Helmets night vision. Also provides a targeting mode that reveals other characters' positions, and infinite oxygen while underwater. Equipping requires learning this Tekgram.",
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2e/Tek_Helmet.png')
    models.Armour.new(name='Tek Leggings', stack_size=1, class_name='PrimalItemArmor_TekPants_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/TEK/PrimalItemArmor_TekPants.PrimalItemArmor_TekPants\'"',
                      url='https://ark.fandom.com/wiki/Tek_Leggings',
                      description='Highly advanced leggings that allow for powerful forward movement. Equipping requires learning this Tekgram.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0d/Tek_Leggings.png')
    models.Armour.new(name='SCUBA Leggings', stack_size=1, class_name='PrimalItemArmor_ScubaPants_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_ScubaPants.PrimalItemArmor_ScubaPants\'"',
                      url='https://ark.fandom.com/wiki/SCUBA_Leggings',
                      description='Provides little defense, but tremendous hypothermal insulation, specifically when underwater.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7e/SCUBA_Leggings.png')
    models.Armour.new(name='Wooden Shield', stack_size=1, class_name='PrimalItemArmor_WoodShield_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Shields/PrimalItemArmor_WoodShield.PrimalItemArmor_WoodShield\'"',
                      url='https://ark.fandom.com/wiki/Wooden_Shield',
                      description='A wooden shield on a layer of leather. Absorbs damage from the front when activated.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/61/Wooden_Shield.png')
    models.Armour.new(name='Metal Shield', stack_size=1, class_name='PrimalItemArmor_MetalShield_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Shields/PrimalItemArmor_MetalShield.PrimalItemArmor_MetalShield\'"',
                      url='https://ark.fandom.com/wiki/Metal_Shield',
                      description='A metal shield on a layer of leather. Absorbs damage from the front when activated.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7e/Metal_Shield.png')
    models.Armour.new(name='Riot Shield', stack_size=1, class_name='PrimalItemArmor_TransparentRiotShield_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Shields/PrimalItemArmor_TransparentRiotShield.PrimalItemArmor_TransparentRiotShield\'"',
                      url='https://ark.fandom.com/wiki/Riot_Shield',
                      description='A metal-framed shield reinforced with polymer and crystal. Absorbs damage from the front when activated.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Riot_Shield.png')
    models.Armour.new(name='Tek Shield', stack_size=1, class_name='PrimalItemArmor_ShieldTek_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Shields/PrimalItemArmor_ShieldTek.PrimalItemArmor_ShieldTek\'"',
                      url='https://ark.fandom.com/wiki/Tek_Shield',
                      description='Absorbs damage from the front when activated. When infused with Element, reflects any blocked projectiles or bullets back at the shooter, at a cost of Element.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Tek_Shield_%28Ragnarok%29.png')
    models.Armour.new(name='Ghillie Boots', stack_size=1, class_name='PrimalItemArmor_GhillieBoots_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Ghillie/PrimalItemArmor_GhillieBoots.PrimalItemArmor_GhillieBoots\'"',
                      url='https://ark.fandom.com/wiki/Ghillie_Boots',
                      description='Strands of Organic Polymer cause this to disperse heat and keep you cool. Camouflage keeps you more hidden from enemy creatures. Provides moderate physical protection, but less than Chitin.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9b/Ghillie_Boots.png')
    models.Armour.new(name='Ghillie Chestpiece', stack_size=1, class_name='PrimalItemArmor_GhillieShirt_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Ghillie/PrimalItemArmor_GhillieShirt.PrimalItemArmor_GhillieShirt\'"',
                      url='https://ark.fandom.com/wiki/Ghillie_Chestpiece',
                      description='Strands of Organic Polymer cause this to disperse heat and keep you cool. Camouflage keeps you more hidden from enemy creatures. Provides moderate physical protection, but less than Chitin.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8b/Ghillie_Chestpiece.png')
    models.Armour.new(name='Ghillie Gauntlets', stack_size=1, class_name='PrimalItemArmor_GhillieGloves_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Ghillie/PrimalItemArmor_GhillieGloves.PrimalItemArmor_GhillieGloves\'"',
                      url='https://ark.fandom.com/wiki/Ghillie_Gauntlets',
                      description='Strands of Organic Polymer cause this to disperse heat and keep you cool. Camouflage keeps you more hidden from enemy creatures. Provides moderate physical protection, but less than Chitin.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bf/Ghillie_Gauntlets.png')
    models.Armour.new(name='Ghillie Leggings', stack_size=1, class_name='PrimalItemArmor_GhilliePants_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Ghillie/PrimalItemArmor_GhilliePants.PrimalItemArmor_GhilliePants\'"',
                      url='https://ark.fandom.com/wiki/Ghillie_Leggings',
                      description='Strands of Organic Polymer cause this to disperse heat and keep you cool. Camouflage keeps you more hidden from enemy creatures. Provides moderate physical protection, but less than Chitin.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1a/Ghillie_Leggings.png')
    models.Armour.new(name='Ghillie Mask', stack_size=1, class_name='PrimalItemArmor_GhillieHelmet_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Ghillie/PrimalItemArmor_GhillieHelmet.PrimalItemArmor_GhillieHelmet\'"',
                      url='https://ark.fandom.com/wiki/Ghillie_Mask',
                      description='Strands of Organic Polymer cause this to disperse heat and keep you cool. Camouflage keeps you more hidden from enemy creatures. Provides moderate physical protection, but less than Chitin.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f2/Ghillie_Mask.png')
    models.Armour.new(name='Gas Mask', stack_size=1, class_name='PrimalItemArmor_GasMask_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_GasMask.PrimalItemArmor_GasMask\'"',
                      url='https://ark.fandom.com/wiki/Gas_Mask',
                      description='Protects the wearer against various airborne poisons.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2e/Gas_Mask.png')
    models.Armour.new(name='Desert Cloth Boots', stack_size=1, class_name='PrimalItemArmor_DesertClothBoots_C',
                      blueprint='"Blueprint\'/Game/ScorchedEarth/Outfits/PrimalItemArmor_DesertClothBoots.PrimalItemArmor_DesertClothBoots\'"',
                      url='https://ark.fandom.com/wiki/Desert_Cloth_Boots_(Scorched_Earth)',
                      description='Hide-soled shoes provide some protection from the heat and cold, but only minimal protection from injuries.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/29/Desert_Cloth_Boots_%28Scorched_Earth%29.png')
    models.Armour.new(name='Desert Cloth Gloves', stack_size=1, class_name='PrimalItemArmor_DesertClothGloves_C',
                      blueprint='"Blueprint\'/Game/ScorchedEarth/Outfits/PrimalItemArmor_DesertClothGloves.PrimalItemArmor_DesertClothGloves\'"',
                      url='https://ark.fandom.com/wiki/Desert_Cloth_Gloves_(Scorched_Earth)',
                      description='Hide-padded gloves provide some protection from the heat and cold, but only minimal protection from injuries.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Desert_Cloth_Gloves_%28Scorched_Earth%29.png')
    models.Armour.new(name='Desert Goggles and Hat', stack_size=1,
                      class_name='PrimalItemArmor_DesertClothGogglesHelmet_C',
                      blueprint='"Blueprint\'/Game/ScorchedEarth/Outfits/PrimalItemArmor_DesertClothGogglesHelmet.PrimalItemArmor_DesertClothGogglesHelmet\'"',
                      url='https://ark.fandom.com/wiki/Desert_Goggles_and_Hat_(Scorched_Earth)',
                      description='You can see better during sandstorms. Provides some protection from the heat and cold, but only minimal protection from injuries.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/99/Desert_Goggles_and_Hat_%28Scorched_Earth%29.png')
    models.Armour.new(name='Desert Cloth Pants', stack_size=1, class_name='PrimalItemArmor_DesertClothPants_C',
                      blueprint='"Blueprint\'/Game/ScorchedEarth/Outfits/PrimalItemArmor_DesertClothPants.PrimalItemArmor_DesertClothPants\'"',
                      url='https://ark.fandom.com/wiki/Desert_Cloth_Pants_(Scorched_Earth)',
                      description='Provides some protection from the heat and cold, but only minimal protection from injuries.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c0/Desert_Cloth_Pants_%28Scorched_Earth%29.png')
    models.Armour.new(name='Desert Cloth Shirt', stack_size=1, class_name='PrimalItemArmor_DesertClothShirt_C',
                      blueprint='"Blueprint\'/Game/ScorchedEarth/Outfits/PrimalItemArmor_DesertClothShirt.PrimalItemArmor_DesertClothShirt\'"',
                      url='https://ark.fandom.com/wiki/Desert_Cloth_Shirt_(Scorched_Earth)',
                      description='Provides some protection from the heat and cold, but only minimal protection from injuries.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Desert_Cloth_Shirt_%28Scorched_Earth%29.png')
    models.Armour.new(name='Night Vision Goggles', stack_size=1, class_name='PrimalItemArmor_NightVisionGoggles_C',
                      blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_NightVisionGoggles.PrimalItemArmor_NightVisionGoggles\'"',
                      url='https://ark.fandom.com/wiki/Night_Vision_Goggles',
                      description='Effortlessly see in the dark, though beware blindingly bright light sources!',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Night_Vision_Goggles.png')
    models.Armour.new(name='Hazard Suit Boots', stack_size=1, class_name='PrimalItemArmor_HazardSuitBoots_C',
                      blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Items/Armor/HazardSuit/PrimalItemArmor_HazardSuitBoots.PrimalItemArmor_HazardSuitBoots\'"',
                      url='https://ark.fandom.com/wiki/Hazard_Suit_Boots_(Aberration)',
                      description='Boots made from a unique combination of materials that protect the wearer from environmental contaminants.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Hazard_Suit_Boots_%28Aberration%29.png')
    models.Armour.new(name='Hazard Suit Gloves', stack_size=1, class_name='PrimalItemArmor_HazardSuitGloves_C',
                      blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Items/Armor/HazardSuit/PrimalItemArmor_HazardSuitGloves.PrimalItemArmor_HazardSuitGloves\'"',
                      url='https://ark.fandom.com/wiki/Hazard_Suit_Gloves_(Aberration)',
                      description='Gloves made from a unique combination of materials that protect the wearer from environmental contaminants.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/18/Hazard_Suit_Gloves_%28Aberration%29.png')
    models.Armour.new(name='Hazard Suit Hat', stack_size=1, class_name='PrimalItemArmor_HazardSuitHelmet_C',
                      blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Items/Armor/HazardSuit/PrimalItemArmor_HazardSuitHelmet.PrimalItemArmor_HazardSuitHelmet\'"',
                      url='https://ark.fandom.com/wiki/Hazard_Suit_Hat_(Aberration)',
                      description='A helmet made from a unique combination of materials that protect the wearer from environmental contaminants.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/75/Hazard_Suit_Hat_%28Aberration%29.png')
    models.Armour.new(name='Hazard Suit Pants', stack_size=1, class_name='PrimalItemArmor_HazardSuitPants_C',
                      blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Items/Armor/HazardSuit/PrimalItemArmor_HazardSuitPants.PrimalItemArmor_HazardSuitPants\'"',
                      url='https://ark.fandom.com/wiki/Hazard_Suit_Pants_(Aberration)',
                      description='Pants made from a unique combination of materials that protect the wearer from environmental contaminants.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d0/Hazard_Suit_Pants_%28Aberration%29.png')
    models.Armour.new(name='Hazard Suit Shirt', stack_size=1, class_name='PrimalItemArmor_HazardSuitShirt_C',
                      blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Items/Armor/HazardSuit/PrimalItemArmor_HazardSuitShirt.PrimalItemArmor_HazardSuitShirt\'"',
                      url='https://ark.fandom.com/wiki/Hazard_Suit_Shirt_(Aberration)',
                      description='A shirt made from a unique combination of materials that protect the wearer from environmental contaminants.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Hazard_Suit_Shirt_%28Aberration%29.png')
    models.Armour.new(name='M.D.S.M.', stack_size=1, class_name='PrimalItemArmor_MekBackpack_Shield_C',
                      blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Saddle/PrimalItemArmor_MekBackpack_Shield.PrimalItemArmor_MekBackpack_Shield\'"',
                      url='https://ark.fandom.com/wiki/M.D.S.M._(Extinction)',
                      description='Mek Deployable Shield Module. Equip a Mek with this module to arm it with a large deployable dome shield. Unequipping reduces durability.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/ff/M.D.S.M._%28Extinction%29.png')
    models.Armour.new(name='M.O.M.I.', stack_size=1, class_name='PrimalItemArmor_MekTransformer_C',
                      blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Saddle/PrimalItemArmor_MekTransformer.PrimalItemArmor_MekTransformer\'"',
                      url='https://ark.fandom.com/wiki/M.O.M.I._(Extinction)',
                      description='MegaMek Operational Materialization Interface. Drag this to a Mek Module slot to enable forming the MegaMek! Requires three additional nearby Meks to transform. Will fail to operate unless in range of the Alpha King Titan.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2c/M.O.M.I._%28Extinction%29.png')
    models.Armour.new(name='M.R.L.M.', stack_size=1, class_name='PrimalItemArmor_MekBackpack_MissilePod_C',
                      blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Saddle/PrimalItemArmor_MekBackpack_MissilePod.PrimalItemArmor_MekBackpack_MissilePod\'"',
                      url='https://ark.fandom.com/wiki/M.R.L.M._(Extinction)',
                      description='Mek Rocket Launcher Module. Equip a Mek with this module to arm it with a wide reaching swarm-fire rocket launcher. Unequipping reduces durability. Requires Rocket Pods to fire.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3b/M.R.L.M._%28Extinction%29.png')
    models.Armour.new(name='M.S.C.M.', stack_size=1, class_name='PrimalItemArmor_MekBackpack_SiegeCannon_C',
                      blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Saddle/PrimalItemArmor_MekBackpack_SiegeCannon.PrimalItemArmor_MekBackpack_SiegeCannon\'"',
                      url='https://ark.fandom.com/wiki/M.S.C.M._(Extinction)',
                      description='Mek Siege Cannon Module. Equip a Mek with this module to arm it with a powerful long-range siege cannon. Unequipping reduces durability. Requires Cannon Shells to fire.',
                      image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/M.S.C.M._%28Extinction%29.png')

    items = [item.to_json() for item in models.Armour.all()]
    print(items)


def seed():
    items = [{'class_name': 'PrimalItemArmor_ClothPants_C', 'id': 17, 'description': 'Provides some protection from the heat and cold, but only minimal protection from injuries.', 'url': 'https://ark.fandom.com/wiki/Cloth_Pants', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Cloth/PrimalItemArmor_ClothPants.PrimalItemArmor_ClothPants\'"', 'name': 'Cloth Pants', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/69/Cloth_Pants.png'}, {'class_name': 'PrimalItemArmor_ClothShirt_C', 'id': 18, 'description': 'Provides some protection from the heat and cold, but only minimal protection from injuries.', 'url': 'https://ark.fandom.com/wiki/Cloth_Shirt', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Cloth/PrimalItemArmor_ClothShirt.PrimalItemArmor_ClothShirt\'"', 'name': 'Cloth Shirt', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f0/Cloth_Shirt.png'}, {'class_name': 'PrimalItemArmor_ClothHelmet_C', 'id': 19, 'description': 'Provides some protection from the heat and cold, but only minimal protection from injuries.', 'url': 'https://ark.fandom.com/wiki/Cloth_Hat', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Cloth/PrimalItemArmor_ClothHelmet.PrimalItemArmor_ClothHelmet\'"', 'name': 'Cloth Hat', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/Cloth_Hat.png'}, {'class_name': 'PrimalItemArmor_ClothBoots_C', 'id': 20, 'description': 'Hide-soled shoes provide some protection from the heat and cold, but only minimal protection from injuries.', 'url': 'https://ark.fandom.com/wiki/Cloth_Boots', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Cloth/PrimalItemArmor_ClothBoots.PrimalItemArmor_ClothBoots\'"', 'name': 'Cloth Boots', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/36/Cloth_Boots.png'}, {'class_name': 'PrimalItemArmor_ClothGloves_C', 'id': 21, 'description': 'Hide-padded gloves provide some protection from the heat and cold, but only minimal protection from injuries.', 'url': 'https://ark.fandom.com/wiki/Cloth_Gloves', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Cloth/PrimalItemArmor_ClothGloves.PrimalItemArmor_ClothGloves\'"', 'name': 'Cloth Gloves', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Cloth_Gloves.png'}, {'class_name': 'PrimalItemArmor_HidePants_C', 'id': 22, 'description': 'Keeps you warm while providing some physical protection', 'url': 'https://ark.fandom.com/wiki/Hide_Pants', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Leather/PrimalItemArmor_HidePants.PrimalItemArmor_HidePants\'"', 'name': 'Hide Pants', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/44/Hide_Pants.png'}, {'class_name': 'PrimalItemArmor_HideShirt_C', 'id': 23, 'description': 'Keeps you warm while providing some physical protection.', 'url': 'https://ark.fandom.com/wiki/Hide_Shirt', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Leather/PrimalItemArmor_HideShirt.PrimalItemArmor_HideShirt\'"', 'name': 'Hide Shirt', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f3/Hide_Shirt.png'}, {'class_name': 'PrimalItemArmor_HideHelmet_C', 'id': 24, 'description': 'Keeps you warm while providing some physical protection.', 'url': 'https://ark.fandom.com/wiki/Hide_Hat', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Leather/PrimalItemArmor_HideHelmet.PrimalItemArmor_HideHelmet\'"', 'name': 'Hide Hat', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Hide_Hat.png'}, {'class_name': 'PrimalItemArmor_HideBoots_C', 'id': 25, 'description': 'Keeps you warm while providing some physical protection.', 'url': 'https://ark.fandom.com/wiki/Hide_Boots', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Leather/PrimalItemArmor_HideBoots.PrimalItemArmor_HideBoots\'"', 'name': 'Hide Boots', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Hide_Boots.png'}, {'class_name': 'PrimalItemArmor_HideGloves_C', 'id': 26, 'description': 'Keeps you warm while providing some physical protection.', 'url': 'https://ark.fandom.com/wiki/Hide_Gloves', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Leather/PrimalItemArmor_HideGloves.PrimalItemArmor_HideGloves\'"', 'name': 'Hide Gloves', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/09/Hide_Gloves.png'}, {'class_name': 'PrimalItemArmor_ChitinPants_C', 'id': 27, 'description': 'Provides moderate physical protection, but can get a little warm.', 'url': 'https://ark.fandom.com/wiki/Chitin_Leggings', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Chitin/PrimalItemArmor_ChitinPants.PrimalItemArmor_ChitinPants\'"', 'name': 'Chitin Leggings', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Chitin_Leggings.png'}, {'class_name': 'PrimalItemArmor_ChitinShirt_C', 'id': 28, 'description': 'Provides moderate physical protection, but can get a little warm.', 'url': 'https://ark.fandom.com/wiki/Chitin_Chestpiece', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Chitin/PrimalItemArmor_ChitinShirt.PrimalItemArmor_ChitinShirt\'"', 'name': 'Chitin Chestpiece', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f1/Chitin_Chestpiece.png'}, {'class_name': 'PrimalItemArmor_ChitinHelmet_C', 'id': 29, 'description': 'Provides moderate physical protection, but can get a little warm.', 'url': 'https://ark.fandom.com/wiki/Chitin_Helmet', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Chitin/PrimalItemArmor_ChitinHelmet.PrimalItemArmor_ChitinHelmet\'"', 'name': 'Chitin Helmet', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7b/Chitin_Helmet.png'}, {'class_name': 'PrimalItemArmor_ChitinBoots_C', 'id': 30, 'description': 'Provides moderate physical protection, but can get a little warm.', 'url': 'https://ark.fandom.com/wiki/Chitin_Boots', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Chitin/PrimalItemArmor_ChitinBoots.PrimalItemArmor_ChitinBoots\'"', 'name': 'Chitin Boots', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0d/Chitin_Boots.png'}, {'class_name': 'PrimalItemArmor_ChitinGloves_C', 'id': 31, 'description': 'Provides moderate physical protection, but can get a little warm.', 'url': 'https://ark.fandom.com/wiki/Chitin_Gauntlets', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Chitin/PrimalItemArmor_ChitinGloves.PrimalItemArmor_ChitinGloves\'"', 'name': 'Chitin Gauntlets', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b9/Chitin_Gauntlets.png'}, {'class_name': 'PrimalItemConsumableBuff_Parachute_C', 'id': 184, 'description': 'Use this while falling to slow your fall. Jump while parachuting to deactivate it.', 'url': 'https://ark.fandom.com/wiki/Parachute', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Consumables/BaseBPs/PrimalItemConsumableBuff_Parachute.PrimalItemConsumableBuff_Parachute\'"', 'name': 'Parachute', 'stack_size': 20, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/86/Parachute.png'}, {'class_name': 'PrimalItemArmor_MetalPants_C', 'id': 218, 'description': 'Provides heavy physical protection, but makes the elements harder to endure.', 'url': 'https://ark.fandom.com/wiki/Flak_Leggings', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MetalPants.PrimalItemArmor_MetalPants\'"', 'name': 'Flak Leggings', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Flak_Leggings.png'}, {'class_name': 'PrimalItemArmor_MetalShirt_C', 'id': 219, 'description': 'Provides heavy physical protection, but makes the elements harder to endure.', 'url': 'https://ark.fandom.com/wiki/Flak_Chestpiece', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MetalShirt.PrimalItemArmor_MetalShirt\'"', 'name': 'Flak Chestpiece', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bf/Flak_Chestpiece.png'}, {'class_name': 'PrimalItemArmor_MetalHelmet_C', 'id': 220, 'description': 'Provides heavy physical protection, but makes the elements harder to endure.', 'url': 'https://ark.fandom.com/wiki/Flak_Helmet', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MetalHelmet.PrimalItemArmor_MetalHelmet\'"', 'name': 'Flak Helmet', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/Flak_Helmet.png'}, {'class_name': 'PrimalItemArmor_MetalBoots_C', 'id': 221, 'description': 'Provides heavy physical protection, but makes the elements harder to endure.', 'url': 'https://ark.fandom.com/wiki/Flak_Boots', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MetalBoots.PrimalItemArmor_MetalBoots\'"', 'name': 'Flak Boots', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/77/Flak_Boots.png'}, {'class_name': 'PrimalItemArmor_MetalGloves_C', 'id': 222, 'description': 'Provides heavy physical protection, but makes the elements harder to endure.', 'url': 'https://ark.fandom.com/wiki/Flak_Gauntlets', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MetalGloves.PrimalItemArmor_MetalGloves\'"', 'name': 'Flak Gauntlets', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f2/Flak_Gauntlets.png'}, {'class_name': 'PrimalItemArmor_MinersHelmet_C', 'id': 301, 'description': 'Provides heavy physical protection, but makes the elements harder to endure. Comes with a built-in light source, which wears out over time.', 'url': 'https://ark.fandom.com/wiki/Heavy_Miner%27s_Helmet', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Metal/PrimalItemArmor_MinersHelmet.PrimalItemArmor_MinersHelmet\'"', 'name': "Heavy Miner's Helmet", 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9a/Heavy_Miner%27s_Helmet.png'}, {'class_name': 'PrimalItemArmor_ScubaShirt_SuitWithTank_C', 'id': 383, 'description': "A tank that's filled with Oxygen. Used to temporarily breathe underwater.", 'url': 'https://ark.fandom.com/wiki/SCUBA_Tank', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_ScubaShirt_SuitWithTank.PrimalItemArmor_ScubaShirt_SuitWithTank\'"', 'name': 'SCUBA Tank', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a9/SCUBA_Tank.png'}, {'class_name': 'PrimalItemArmor_ScubaHelmet_Goggles_C', 'id': 384, 'description': 'Connects to a SCUBA Tank, allowing the wearer to breathe underwater for as long as the tank has oxygen.', 'url': 'https://ark.fandom.com/wiki/SCUBA_Mask', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_ScubaHelmet_Goggles.PrimalItemArmor_ScubaHelmet_Goggles\'"', 'name': 'SCUBA Mask', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/51/SCUBA_Mask.png'}, {'class_name': 'PrimalItemArmor_ScubaBoots_Flippers_C', 'id': 385, 'description': 'These flippers are firm, but flexible. Wearing them increases swim speed, but decreases walking speed.', 'url': 'https://ark.fandom.com/wiki/SCUBA_Flippers', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_ScubaBoots_Flippers.PrimalItemArmor_ScubaBoots_Flippers\'"', 'name': 'SCUBA Flippers', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/42/SCUBA_Flippers.png'}, {'class_name': 'PrimalItemArmor_FurPants_C', 'id': 424, 'description': 'Provides significant physical protection. Also keeps your temperature up, so long as it stays dry.', 'url': 'https://ark.fandom.com/wiki/Fur_Leggings', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Fur/PrimalItemArmor_FurPants.PrimalItemArmor_FurPants\'"', 'name': 'Fur Leggings', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9c/Fur_Leggings.png'}, {'class_name': 'PrimalItemArmor_FurShirt_C', 'id': 425, 'description': 'Provides significant physical protection. Also keeps your temperature up, so long as it stays dry.', 'url': 'https://ark.fandom.com/wiki/Fur_Chestpiece', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Fur/PrimalItemArmor_FurShirt.PrimalItemArmor_FurShirt\'"', 'name': 'Fur Chestpiece', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/b3/Fur_Chestpiece.png'}, {'class_name': 'PrimalItemArmor_FurHelmet_C', 'id': 426, 'description': 'Provides significant physical protection. Also keeps your temperature up, so long as it stays dry.', 'url': 'https://ark.fandom.com/wiki/Fur_Cap', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Fur/PrimalItemArmor_FurHelmet.PrimalItemArmor_FurHelmet\'"', 'name': 'Fur Cap', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fe/Fur_Cap.png'}, {'class_name': 'PrimalItemArmor_FurBoots_C', 'id': 427, 'description': 'Provides significant physical protection. Also keeps your temperature up, so long as it stays dry.', 'url': 'https://ark.fandom.com/wiki/Fur_Boots', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Fur/PrimalItemArmor_FurBoots.PrimalItemArmor_FurBoots\'"', 'name': 'Fur Boots', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/63/Fur_Boots.png'}, {'class_name': 'PrimalItemArmor_FurGloves_C', 'id': 428, 'description': 'Provides significant physical protection. Also keeps your temperature up, so long as it stays dry.', 'url': 'https://ark.fandom.com/wiki/Fur_Gauntlets', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Fur/PrimalItemArmor_FurGloves.PrimalItemArmor_FurGloves\'"', 'name': 'Fur Gauntlets', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c5/Fur_Gauntlets.png'}, {'class_name': 'PrimalItemArmor_RiotPants_C', 'id': 441, 'description': 'Provides heavy physical protection and reduced physical torpor, but provides almost no protection from the elements.', 'url': 'https://ark.fandom.com/wiki/Riot_Leggings', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Riot/PrimalItemArmor_RiotPants.PrimalItemArmor_RiotPants\'"', 'name': 'Riot Leggings', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/ab/Riot_Leggings.png'}, {'class_name': 'PrimalItemArmor_RiotShirt_C', 'id': 442, 'description': 'Provides heavy physical protection and reduced physical torpor, but provides almost no protection from the elements.', 'url': 'https://ark.fandom.com/wiki/Riot_Chestpiece', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Riot/PrimalItemArmor_RiotShirt.PrimalItemArmor_RiotShirt\'"', 'name': 'Riot Chestpiece', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Riot_Chestpiece.png'}, {'class_name': 'PrimalItemArmor_RiotGloves_C', 'id': 443, 'description': 'Provides heavy physical protection and reduced physical torpor, but provides almost no protection from the elements.', 'url': 'https://ark.fandom.com/wiki/Riot_Gauntlets', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Riot/PrimalItemArmor_RiotGloves.PrimalItemArmor_RiotGloves\'"', 'name': 'Riot Gauntlets', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d1/Riot_Gauntlets.png'}, {'class_name': 'PrimalItemArmor_RiotBoots_C', 'id': 444, 'description': 'Provides heavy physical protection and reduced physical torpor, but provides almost no protection from the elements.', 'url': 'https://ark.fandom.com/wiki/Riot_Boots', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Riot/PrimalItemArmor_RiotBoots.PrimalItemArmor_RiotBoots\'"', 'name': 'Riot Boots', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5a/Riot_Boots.png'}, {'class_name': 'PrimalItemArmor_RiotHelmet_C', 'id': 445, 'description': 'Provides heavy physical protection and reduced physical torpor, but provides almost no protection from the elements.', 'url': 'https://ark.fandom.com/wiki/Riot_Helmet', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Riot/PrimalItemArmor_RiotHelmet.PrimalItemArmor_RiotHelmet\'"', 'name': 'Riot Helmet', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3a/Riot_Helmet.png'}, {'class_name': 'PrimalItemArmor_ShoulderCannon_C', 'id': 497, 'description': 'A shoulder mounted energy weapon with configurable targeting and firing modes. Equipping this requires learning its Tekgram.', 'url': 'https://ark.fandom.com/wiki/Tek_Shoulder_Cannon_(Genesis:_Part_1)', 'blueprint': '"Blueprint\'/Game/Genesis/Items/Armor/PrimalItemArmor_ShoulderCannon.PrimalItemArmor_ShoulderCannon\'"', 'name': 'Tek Shoulder Cannon', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/5d/Tek_Shoulder_Cannon_%28Genesis_Part_1%29.png'}, {'class_name': 'PrimalItemArmor_TekBoots_C', 'id': 498, 'description': 'Highly advanced boots capable of absorbing the impact of falling from high distances. Equipping requires learning this Tekgram.', 'url': 'https://ark.fandom.com/wiki/Tek_Boots', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/TEK/PrimalItemArmor_TekBoots.PrimalItemArmor_TekBoots\'"', 'name': 'Tek Boots', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1b/Tek_Boots.png'}, {'class_name': 'PrimalItemArmor_TekShirt_C', 'id': 499, 'description': 'Highly advanced chestpiece with an integrated jetpack. Equipping requires learning this Tekgram.', 'url': 'https://ark.fandom.com/wiki/Tek_Chestpiece', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/TEK/PrimalItemArmor_TekShirt.PrimalItemArmor_TekShirt\'"', 'name': 'Tek Chestpiece', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/21/Tek_Chestpiece.png'}, {'class_name': 'PrimalItemArmor_TekGloves_C', 'id': 500, 'description': 'Highly advanced gauntlets that allow the wearer to perform devastating punches. Equipping requires learning this Tekgram.', 'url': 'https://ark.fandom.com/wiki/Tek_Gauntlets', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/TEK/PrimalItemArmor_TekGloves.PrimalItemArmor_TekGloves\'"', 'name': 'Tek Gauntlets', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/21/Tek_Gauntlets.png'}, {'class_name': 'PrimalItemArmor_TekHelmet_C', 'id': 501, 'description': "Never get lost again with the Tek Helmets night vision. Also provides a targeting mode that reveals other characters' positions, and infinite oxygen while underwater. Equipping requires learning this Tekgram.", 'url': 'https://ark.fandom.com/wiki/Tek_Helmet', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/TEK/PrimalItemArmor_TekHelmet.PrimalItemArmor_TekHelmet\'"', 'name': 'Tek Helmet', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2e/Tek_Helmet.png'}, {'class_name': 'PrimalItemArmor_TekPants_C', 'id': 502, 'description': 'Highly advanced leggings that allow for powerful forward movement. Equipping requires learning this Tekgram.', 'url': 'https://ark.fandom.com/wiki/Tek_Leggings', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/TEK/PrimalItemArmor_TekPants.PrimalItemArmor_TekPants\'"', 'name': 'Tek Leggings', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/0d/Tek_Leggings.png'}, {'class_name': 'PrimalItemArmor_ScubaPants_C', 'id': 503, 'description': 'Provides little defense, but tremendous hypothermal insulation, specifically when underwater.', 'url': 'https://ark.fandom.com/wiki/SCUBA_Leggings', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_ScubaPants.PrimalItemArmor_ScubaPants\'"', 'name': 'SCUBA Leggings', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7e/SCUBA_Leggings.png'}, {'class_name': 'PrimalItemArmor_WoodShield_C', 'id': 504, 'description': 'A wooden shield on a layer of leather. Absorbs damage from the front when activated.', 'url': 'https://ark.fandom.com/wiki/Wooden_Shield', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Shields/PrimalItemArmor_WoodShield.PrimalItemArmor_WoodShield\'"', 'name': 'Wooden Shield', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/61/Wooden_Shield.png'}, {'class_name': 'PrimalItemArmor_MetalShield_C', 'id': 505, 'description': 'A metal shield on a layer of leather. Absorbs damage from the front when activated.', 'url': 'https://ark.fandom.com/wiki/Metal_Shield', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Shields/PrimalItemArmor_MetalShield.PrimalItemArmor_MetalShield\'"', 'name': 'Metal Shield', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/7e/Metal_Shield.png'}, {'class_name': 'PrimalItemArmor_TransparentRiotShield_C', 'id': 506, 'description': 'A metal-framed shield reinforced with polymer and crystal. Absorbs damage from the front when activated.', 'url': 'https://ark.fandom.com/wiki/Riot_Shield', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Shields/PrimalItemArmor_TransparentRiotShield.PrimalItemArmor_TransparentRiotShield\'"', 'name': 'Riot Shield', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/07/Riot_Shield.png'}, {'class_name': 'PrimalItemArmor_ShieldTek_C', 'id': 507, 'description': 'Absorbs damage from the front when activated. When infused with Element, reflects any blocked projectiles or bullets back at the shooter, at a cost of Element.', 'url': 'https://ark.fandom.com/wiki/Tek_Shield', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Shields/PrimalItemArmor_ShieldTek.PrimalItemArmor_ShieldTek\'"', 'name': 'Tek Shield', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Tek_Shield_%28Ragnarok%29.png'}, {'class_name': 'PrimalItemArmor_GhillieBoots_C', 'id': 508, 'description': 'Strands of Organic Polymer cause this to disperse heat and keep you cool. Camouflage keeps you more hidden from enemy creatures. Provides moderate physical protection, but less than Chitin.', 'url': 'https://ark.fandom.com/wiki/Ghillie_Boots', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Ghillie/PrimalItemArmor_GhillieBoots.PrimalItemArmor_GhillieBoots\'"', 'name': 'Ghillie Boots', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9b/Ghillie_Boots.png'}, {'class_name': 'PrimalItemArmor_GhillieShirt_C', 'id': 509, 'description': 'Strands of Organic Polymer cause this to disperse heat and keep you cool. Camouflage keeps you more hidden from enemy creatures. Provides moderate physical protection, but less than Chitin.', 'url': 'https://ark.fandom.com/wiki/Ghillie_Chestpiece', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Ghillie/PrimalItemArmor_GhillieShirt.PrimalItemArmor_GhillieShirt\'"', 'name': 'Ghillie Chestpiece', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8b/Ghillie_Chestpiece.png'}, {'class_name': 'PrimalItemArmor_GhillieGloves_C', 'id': 510, 'description': 'Strands of Organic Polymer cause this to disperse heat and keep you cool. Camouflage keeps you more hidden from enemy creatures. Provides moderate physical protection, but less than Chitin.', 'url': 'https://ark.fandom.com/wiki/Ghillie_Gauntlets', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Ghillie/PrimalItemArmor_GhillieGloves.PrimalItemArmor_GhillieGloves\'"', 'name': 'Ghillie Gauntlets', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/b/bf/Ghillie_Gauntlets.png'}, {'class_name': 'PrimalItemArmor_GhilliePants_C', 'id': 511, 'description': 'Strands of Organic Polymer cause this to disperse heat and keep you cool. Camouflage keeps you more hidden from enemy creatures. Provides moderate physical protection, but less than Chitin.', 'url': 'https://ark.fandom.com/wiki/Ghillie_Leggings', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Ghillie/PrimalItemArmor_GhilliePants.PrimalItemArmor_GhilliePants\'"', 'name': 'Ghillie Leggings', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/1a/Ghillie_Leggings.png'}, {'class_name': 'PrimalItemArmor_GhillieHelmet_C', 'id': 512, 'description': 'Strands of Organic Polymer cause this to disperse heat and keep you cool. Camouflage keeps you more hidden from enemy creatures. Provides moderate physical protection, but less than Chitin.', 'url': 'https://ark.fandom.com/wiki/Ghillie_Mask', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/Ghillie/PrimalItemArmor_GhillieHelmet.PrimalItemArmor_GhillieHelmet\'"', 'name': 'Ghillie Mask', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f2/Ghillie_Mask.png'}, {'class_name': 'PrimalItemArmor_GasMask_C', 'id': 513, 'description': 'Protects the wearer against various airborne poisons.', 'url': 'https://ark.fandom.com/wiki/Gas_Mask', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_GasMask.PrimalItemArmor_GasMask\'"', 'name': 'Gas Mask', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2e/Gas_Mask.png'}, {'class_name': 'PrimalItemArmor_DesertClothBoots_C', 'id': 514, 'description': 'Hide-soled shoes provide some protection from the heat and cold, but only minimal protection from injuries.', 'url': 'https://ark.fandom.com/wiki/Desert_Cloth_Boots_(Scorched_Earth)', 'blueprint': '"Blueprint\'/Game/ScorchedEarth/Outfits/PrimalItemArmor_DesertClothBoots.PrimalItemArmor_DesertClothBoots\'"', 'name': 'Desert Cloth Boots', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/29/Desert_Cloth_Boots_%28Scorched_Earth%29.png'}, {'class_name': 'PrimalItemArmor_DesertClothGloves_C', 'id': 515, 'description': 'Hide-padded gloves provide some protection from the heat and cold, but only minimal protection from injuries.', 'url': 'https://ark.fandom.com/wiki/Desert_Cloth_Gloves_(Scorched_Earth)', 'blueprint': '"Blueprint\'/Game/ScorchedEarth/Outfits/PrimalItemArmor_DesertClothGloves.PrimalItemArmor_DesertClothGloves\'"', 'name': 'Desert Cloth Gloves', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/32/Desert_Cloth_Gloves_%28Scorched_Earth%29.png'}, {'class_name': 'PrimalItemArmor_DesertClothGogglesHelmet_C', 'id': 516, 'description': 'You can see better during sandstorms. Provides some protection from the heat and cold, but only minimal protection from injuries.', 'url': 'https://ark.fandom.com/wiki/Desert_Goggles_and_Hat_(Scorched_Earth)', 'blueprint': '"Blueprint\'/Game/ScorchedEarth/Outfits/PrimalItemArmor_DesertClothGogglesHelmet.PrimalItemArmor_DesertClothGogglesHelmet\'"', 'name': 'Desert Goggles and Hat', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/99/Desert_Goggles_and_Hat_%28Scorched_Earth%29.png'}, {'class_name': 'PrimalItemArmor_DesertClothPants_C', 'id': 517, 'description': 'Provides some protection from the heat and cold, but only minimal protection from injuries.', 'url': 'https://ark.fandom.com/wiki/Desert_Cloth_Pants_(Scorched_Earth)', 'blueprint': '"Blueprint\'/Game/ScorchedEarth/Outfits/PrimalItemArmor_DesertClothPants.PrimalItemArmor_DesertClothPants\'"', 'name': 'Desert Cloth Pants', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c0/Desert_Cloth_Pants_%28Scorched_Earth%29.png'}, {'class_name': 'PrimalItemArmor_DesertClothShirt_C', 'id': 518, 'description': 'Provides some protection from the heat and cold, but only minimal protection from injuries.', 'url': 'https://ark.fandom.com/wiki/Desert_Cloth_Shirt_(Scorched_Earth)', 'blueprint': '"Blueprint\'/Game/ScorchedEarth/Outfits/PrimalItemArmor_DesertClothShirt.PrimalItemArmor_DesertClothShirt\'"', 'name': 'Desert Cloth Shirt', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/41/Desert_Cloth_Shirt_%28Scorched_Earth%29.png'}, {'class_name': 'PrimalItemArmor_NightVisionGoggles_C', 'id': 519, 'description': 'Effortlessly see in the dark, though beware blindingly bright light sources!', 'url': 'https://ark.fandom.com/wiki/Night_Vision_Goggles', 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Items/Armor/SCUBA/PrimalItemArmor_NightVisionGoggles.PrimalItemArmor_NightVisionGoggles\'"', 'name': 'Night Vision Goggles', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2f/Night_Vision_Goggles.png'}, {'class_name': 'PrimalItemArmor_HazardSuitBoots_C', 'id': 520, 'description': 'Boots made from a unique combination of materials that protect the wearer from environmental contaminants.', 'url': 'https://ark.fandom.com/wiki/Hazard_Suit_Boots_(Aberration)', 'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Items/Armor/HazardSuit/PrimalItemArmor_HazardSuitBoots.PrimalItemArmor_HazardSuitBoots\'"', 'name': 'Hazard Suit Boots', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/67/Hazard_Suit_Boots_%28Aberration%29.png'}, {'class_name': 'PrimalItemArmor_HazardSuitGloves_C', 'id': 521, 'description': 'Gloves made from a unique combination of materials that protect the wearer from environmental contaminants.', 'url': 'https://ark.fandom.com/wiki/Hazard_Suit_Gloves_(Aberration)', 'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Items/Armor/HazardSuit/PrimalItemArmor_HazardSuitGloves.PrimalItemArmor_HazardSuitGloves\'"', 'name': 'Hazard Suit Gloves', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/18/Hazard_Suit_Gloves_%28Aberration%29.png'}, {'class_name': 'PrimalItemArmor_HazardSuitHelmet_C', 'id': 522, 'description': 'A helmet made from a unique combination of materials that protect the wearer from environmental contaminants.', 'url': 'https://ark.fandom.com/wiki/Hazard_Suit_Hat_(Aberration)', 'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Items/Armor/HazardSuit/PrimalItemArmor_HazardSuitHelmet.PrimalItemArmor_HazardSuitHelmet\'"', 'name': 'Hazard Suit Hat', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/7/75/Hazard_Suit_Hat_%28Aberration%29.png'}, {'class_name': 'PrimalItemArmor_HazardSuitPants_C', 'id': 523, 'description': 'Pants made from a unique combination of materials that protect the wearer from environmental contaminants.', 'url': 'https://ark.fandom.com/wiki/Hazard_Suit_Pants_(Aberration)', 'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Items/Armor/HazardSuit/PrimalItemArmor_HazardSuitPants.PrimalItemArmor_HazardSuitPants\'"', 'name': 'Hazard Suit Pants', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/d0/Hazard_Suit_Pants_%28Aberration%29.png'}, {'class_name': 'PrimalItemArmor_HazardSuitShirt_C', 'id': 524, 'description': 'A shirt made from a unique combination of materials that protect the wearer from environmental contaminants.', 'url': 'https://ark.fandom.com/wiki/Hazard_Suit_Shirt_(Aberration)', 'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Items/Armor/HazardSuit/PrimalItemArmor_HazardSuitShirt.PrimalItemArmor_HazardSuitShirt\'"', 'name': 'Hazard Suit Shirt', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/92/Hazard_Suit_Shirt_%28Aberration%29.png'}, {'class_name': 'PrimalItemArmor_MekBackpack_Shield_C', 'id': 525, 'description': 'Mek Deployable Shield Module. Equip a Mek with this module to arm it with a large deployable dome shield. Unequipping reduces durability.', 'url': 'https://ark.fandom.com/wiki/M.D.S.M._(Extinction)', 'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Saddle/PrimalItemArmor_MekBackpack_Shield.PrimalItemArmor_MekBackpack_Shield\'"', 'name': 'M.D.S.M.', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/ff/M.D.S.M._%28Extinction%29.png'}, {'class_name': 'PrimalItemArmor_MekTransformer_C', 'id': 526, 'description': 'MegaMek Operational Materialization Interface. Drag this to a Mek Module slot to enable forming the MegaMek! Requires three additional nearby Meks to transform. Will fail to operate unless in range of the Alpha King Titan.', 'url': 'https://ark.fandom.com/wiki/M.O.M.I._(Extinction)', 'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Saddle/PrimalItemArmor_MekTransformer.PrimalItemArmor_MekTransformer\'"', 'name': 'M.O.M.I.', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/2c/M.O.M.I._%28Extinction%29.png'}, {'class_name': 'PrimalItemArmor_MekBackpack_MissilePod_C', 'id': 527, 'description': 'Mek Rocket Launcher Module. Equip a Mek with this module to arm it with a wide reaching swarm-fire rocket launcher. Unequipping reduces durability. Requires Rocket Pods to fire.', 'url': 'https://ark.fandom.com/wiki/M.R.L.M._(Extinction)', 'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Saddle/PrimalItemArmor_MekBackpack_MissilePod.PrimalItemArmor_MekBackpack_MissilePod\'"', 'name': 'M.R.L.M.', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3b/M.R.L.M._%28Extinction%29.png'}, {'class_name': 'PrimalItemArmor_MekBackpack_SiegeCannon_C', 'id': 528, 'description': 'Mek Siege Cannon Module. Equip a Mek with this module to arm it with a powerful long-range siege cannon. Unequipping reduces durability. Requires Cannon Shells to fire.', 'url': 'https://ark.fandom.com/wiki/M.S.C.M._(Extinction)', 'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Items/Saddle/PrimalItemArmor_MekBackpack_SiegeCannon.PrimalItemArmor_MekBackpack_SiegeCannon\'"', 'name': 'M.S.C.M.', 'stack_size': 1, 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/ec/M.S.C.M._%28Extinction%29.png'}]
    models.Armour.bulk_insert(items)
