from arkdata import models


def backup_seed():
    models.Ammunition.new(id=369, name='Transponder Node', stack_size=100, class_name='PrimalItemTransGPSAmmo_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/Test/PrimalItemTransGPSAmmo.PrimalItemTransGPSAmmo\'"',
                          url='https://ark.fandom.com/wiki/Transponder_Node',
                          description='Can be attached to living Creatures to track their location.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Transponder_Node.png')
    models.Ammunition.new(id=70, name='Tranq Arrow', stack_size=100, class_name='PrimalItemAmmo_ArrowTranq_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_ArrowTranq.PrimalItemAmmo_ArrowTranq\'"',
                          url='https://ark.fandom.com/wiki/Tranq_Arrow',
                          description="Less deadly than other arrows, but rapidly increases the victim's torpidity.",
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8e/Tranq_Arrow.png')
    models.Ammunition.new(id=32, name='Stone Arrow', stack_size=100, class_name='PrimalItemAmmo_ArrowStone_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_ArrowStone.PrimalItemAmmo_ArrowStone\'"',
                          url='https://ark.fandom.com/wiki/Stone_Arrow',
                          description="A basic arrow with a flint arrowhead. If it doesn't break, you can recover your ammo.",
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/28/Stone_Arrow.png')
    models.Ammunition.new(id=264, name='Simple Shotgun Ammo', stack_size=100,
                          class_name='PrimalItemAmmo_SimpleShotgunBullet_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_SimpleShotgunBullet.PrimalItemAmmo_SimpleShotgunBullet\'"',
                          url='https://ark.fandom.com/wiki/Simple_Shotgun_Ammo',
                          description='A few simple bullets in a hide casing, used with forged shotguns.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/18/Simple_Shotgun_Ammo.png')
    models.Ammunition.new(id=143, name='Simple Rifle Ammo', stack_size=100,
                          class_name='PrimalItemAmmo_SimpleRifleBullet_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_SimpleRifleBullet.PrimalItemAmmo_SimpleRifleBullet\'"',
                          url='https://ark.fandom.com/wiki/Simple_Rifle_Ammo',
                          description='An odd bullet and casing, used with forged rifles.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a0/Simple_Rifle_Ammo.png')
    models.Ammunition.new(id=4, name='Simple Bullet', stack_size=100, class_name='PrimalItemAmmo_SimpleBullet_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_SimpleBullet.PrimalItemAmmo_SimpleBullet\'"',
                          url='https://ark.fandom.com/wiki/Simple_Bullet', description='Primarily used with forged handguns.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Simple_Bullet.png')
    models.Ammunition.new(id=243, name='Rocket Propelled Grenade', stack_size=100,
                          class_name='PrimalItemAmmo_Rocket_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_Rocket.PrimalItemAmmo_Rocket\'"',
                          url='https://ark.fandom.com/wiki/Rocket_Propelled_Grenade',
                          description='A small but powerful explosive, primarily used with rocket launchers.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Rocket_Propelled_Grenade.png')
    models.Ammunition.new(id=373, name='Metal Arrow', stack_size=100,
                          class_name='PrimalItemAmmo_CompoundBowArrow_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_CompoundBowArrow.PrimalItemAmmo_CompoundBowArrow\'"',
                          url='https://ark.fandom.com/wiki/Metal_Arrow', description='An armor-and-hide piercing metal arrow.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/12/Metal_Arrow.png')
    models.Ammunition.new(id=43, name='C4 Charge', stack_size=100, class_name='PrimalItemC4Ammo_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/Test/PrimalItemC4Ammo.PrimalItemC4Ammo\'"',
                          url='https://ark.fandom.com/wiki/C4_Charge',
                          description='This advanced explosive can annihilate structures.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/C4_Charge.png')
    models.Ammunition.new(id=242, name='Advanced Rifle Bullet', stack_size=100,
                          class_name='PrimalItemAmmo_AdvancedRifleBullet_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_AdvancedRifleBullet.PrimalItemAmmo_AdvancedRifleBullet\'"',
                          url='https://ark.fandom.com/wiki/Advanced_Rifle_Bullet',
                          description='Primarily used with fabricated rifles.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Advanced_Rifle_Bullet.png')
    models.Ammunition.new(id=241, name='Advanced Bullet', stack_size=100,
                          class_name='PrimalItemAmmo_AdvancedBullet_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_AdvancedBullet.PrimalItemAmmo_AdvancedBullet\'"',
                          url='https://ark.fandom.com/wiki/Advanced_Bullet',
                          description='A small-caliber modern bullet, primarily used with fabricated handguns.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3e/Advanced_Bullet.png')
    models.Ammunition.new(name='Advanced Sniper Bullet', stack_size=100,
                          class_name='PrimalItemAmmo_AdvancedSniperBullet_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_AdvancedSniperBullet.PrimalItemAmmo_AdvancedSniperBullet\'"',
                          url='https://ark.fandom.com/wiki/Advanced_Sniper_Bullet',
                          description='A high-caliber modern bullet, primarily used with fabricated sniper rifles',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6c/Advanced_Sniper_Bullet.png')
    models.Ammunition.new(name='Boulder', stack_size=100, class_name='PrimalItemAmmo_Boulder_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_Boulder.PrimalItemAmmo_Boulder\'"',
                          url='https://ark.fandom.com/wiki/Boulder',
                          description='Massive rock with metal spikes. Can only be used in a Catapult Turret.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/21/Boulder.png')
    models.Ammunition.new(name='Cannon Ball', stack_size=1, class_name='PrimalItemAmmo_CannonBall_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_CannonBall.PrimalItemAmmo_CannonBall\'"',
                          url='https://ark.fandom.com/wiki/Cannon_Ball',
                          description='A gigantic ball of heavy metal, capable of demolishing very strong structures.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Cannon_Ball.png')
    models.Ammunition.new(name='Cannon Shell', stack_size=1, class_name='PrimalItemAmmo_CannonShell_C',
                          blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Weapons/PrimalItemAmmo_CannonShell.PrimalItemAmmo_CannonShell\'"',
                          url='https://ark.fandom.com/wiki/Cannon_Shell_(Extinction)',
                          description='A large artillery shell. Used as ammunition for the Mek Siege Cannon Module.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6b/Cannon_Shell_%28Extinction%29.png')
    models.Ammunition.new(name='Explosive Arrow', stack_size=100, class_name='PrimalItemAmmo_ExplosiveArrow_C',
                          blueprint='"Blueprint\'/Game/Genesis2/Weapons/TekBow/PrimalItemAmmo_ExplosiveArrow.PrimalItemAmmo_ExplosiveArrow\'"',
                          url='https://ark.fandom.com/wiki/Explosive_Arrow_(Genesis:_Part_2)',
                          description='When infused with Element Shards, will 3-D print high velocity explosive arrows at a cost of Element Shards. Can also fire other arrow types.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/61/Tek_Bow_%28Genesis_Part_2%29.png')
    models.Ammunition.new(name='Flame Arrow', stack_size=100, class_name='PrimalItemAmmo_ArrowFlame_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_ArrowFlame.PrimalItemAmmo_ArrowFlame\'"',
                          url='https://ark.fandom.com/wiki/Flame_Arrow_(Scorched_Earth)',
                          description='Lights the target on fire, and can also light oil slicks.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dc/Flame_Arrow_%28Scorched_Earth%29.png')
    models.Ammunition.new(name='Flamethrower Ammo', stack_size=30, class_name='PrimalItemAmmo_Flamethrower_C',
                          blueprint='"Blueprint\'/Game/ScorchedEarth/WeaponFlamethrower/PrimalItemAmmo_Flamethrower.PrimalItemAmmo_Flamethrower\'"',
                          url='https://ark.fandom.com/wiki/Flamethrower_Ammo_(Scorched_Earth)',
                          description='Fuel for the Flamethrower.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Flamethrower_Ammo_%28Scorched_Earth%29.png')
    models.Ammunition.new(name='Grappling Hook', stack_size=10, class_name='PrimalItemAmmo_GrapplingHook_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_GrapplingHook.PrimalItemAmmo_GrapplingHook\'"',
                          url='https://ark.fandom.com/wiki/Grappling_Hook',
                          description='Apply on the Crossbow to grapple onto the environment & other creatures. Primary Fire to "Reel-In", Secondary Fire to "Reel-Out", Crouch to Detach, Jump + Reel-In to Vault-Jump!',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3d/Grappling_Hook.png')
    models.Ammunition.new(name='Jar of Pitch', stack_size=100, class_name='PrimalItemAmmo_Boulder_Fire_C',
                          blueprint='"Blueprint\'/Game/Genesis2/Weapons/FireBoulder/PrimalItemAmmo_Boulder_Fire.PrimalItemAmmo_Boulder_Fire\'"',
                          url='https://ark.fandom.com/wiki/Jar_of_Pitch_(Genesis:_Part_2)',
                          description='Lights the target on fire, and can also light oil slicks. Can be fired from a Ballista Turret or Catapult.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c8/Jar_of_Pitch_concept_art.jpg')
    models.Ammunition.new(name='Net Projectile', stack_size=100, class_name='PrimalItemAmmo_ArrowNet_C',
                          blueprint='"Blueprint\'/Game/Genesis2/Weapons/NetAmmo/PrimalItemAmmo_ArrowNet.PrimalItemAmmo_ArrowNet\'"',
                          url='https://ark.fandom.com/wiki/Net_Projectile_(Genesis:_Part_2)',
                          description='High-Speed projectile that unfurls to ensnare creatures in netting. Can only be fired from a Harpoon Launcher.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Net_Projectile_%28Genesis_Part_2%29.png')
    models.Ammunition.new(name='Pheromone Dart', stack_size=100, class_name='PrimalItemAmmo_AggroTranqDart_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_AggroTranqDart.PrimalItemAmmo_AggroTranqDart\'"',
                          url='https://ark.fandom.com/wiki/Pheromone_Dart',
                          description='A dart full of refined Ammonite chemicals, inject on a target to enrage nearby wild creatures. For use in a Longneck Rifle. Can not be used with attachments.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/54/Pheromone_Dart.png')
    models.Ammunition.new(name='Rocket Homing Missile', stack_size=100,
                          class_name='PrimalItemAmmo_RocketHomingMissile_C',
                          blueprint='"Blueprint\'/Game/ScorchedEarth/WeaponHomingMissile/PrimalItemAmmo_RocketHomingMissile.PrimalItemAmmo_RocketHomingMissile\'"',
                          url='https://ark.fandom.com/wiki/Rocket_Homing_Missile_(Scorched_Earth)',
                          description='Advanced projectile with trajectory auto-correction.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9f/Rocket_Homing_Missile_%28Scorched_Earth%29.png')
    models.Ammunition.new(name='Rocket Pod', stack_size=1, class_name='PrimalItemAmmo_RocketPod_C',
                          blueprint='"Blueprint\'/Game/Extinction/CoreBlueprints/Weapons/PrimalItemAmmo_RocketPod.PrimalItemAmmo_RocketPod\'"',
                          url='https://ark.fandom.com/wiki/Rocket_Pod_(Extinction)',
                          description='A pod containing 16 swarm-fire rockets. Used as ammunition for the Mek Rocket Launcher Module.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f9/Rocket_Pod_%28Extinction%29.png')
    models.Ammunition.new(name='Shocking Tranquilizer Dart', stack_size=100,
                          class_name='PrimalItemAmmo_RefinedTranqDart_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_RefinedTranqDart.PrimalItemAmmo_RefinedTranqDart\'"',
                          url='https://ark.fandom.com/wiki/Shocking_Tranquilizer_Dart',
                          description='A potent dart full of tranquilizing poison. For use in a Longneck Rifle. Can not be used with attachments.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Tranquilizer_Dart.png')
    models.Ammunition.new(name='Spear Bolt', stack_size=100, class_name='PrimalItemAmmo_BallistaArrow_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_BallistaArrow.PrimalItemAmmo_BallistaArrow\'"',
                          url='https://ark.fandom.com/wiki/Spear_Bolt',
                          description="A massive bolt with a cast iron arrowhead. Can only be used in a Ballista Turret or a Harpoon Gun. If it doesn't break, you can recover your ammo.",
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f9/Spear_Bolt.png')
    models.Ammunition.new(name='Tranquilizer Dart', stack_size=100, class_name='PrimalItemAmmo_TranqDart_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_TranqDart.PrimalItemAmmo_TranqDart\'"',
                          url='https://ark.fandom.com/wiki/Tranquilizer_Dart',
                          description='A potent dart full of tranquilizing poison. For use in a Longneck Rifle. Can not be used with attachments.',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Tranquilizer_Dart.png')
    models.Ammunition.new(name='Tranq Spear Bolt', stack_size=100, class_name='PrimalItemAmmo_TranqSpearBolt_C',
                          blueprint='"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_TranqSpearBolt.PrimalItemAmmo_TranqSpearBolt\'"',
                          url='https://ark.fandom.com/wiki/Tranq_Spear_Bolt',
                          description="A massive bolt with a tranq dart mounted on the front. Used as an underwater tranquilizer projectile with the Harpoon Gun. If it doesn't break, you can recover the spear bolt.",
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f1/Tranq_Spear_Bolt.png')
    models.Ammunition.new(name='Zip-Line Anchor', stack_size=100, class_name='PrimalItemAmmo_Zipline_C',
                          blueprint='"Blueprint\'/Game/Aberration/CoreBlueprints/Weapons/PrimalItemAmmo_Zipline.PrimalItemAmmo_Zipline\'"',
                          url='https://ark.fandom.com/wiki/Zip-Line_Anchor_(Aberration)',
                          description='Apply onto a Crossbow to fire Zip-Line anchor points. Use two anchor points to complete a Zip-Line, which you can then grab onto',
                          image_url='https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/eb/Zip-Line_Anchor_%28Aberration%29.png')

    items = [item.to_json() for item in models.Ammunition.all()]
    print(items)


def seed():
    items = [{'name': 'Simple Bullet', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_SimpleBullet.PrimalItemAmmo_SimpleBullet\'"', 'description': 'Primarily used with forged handguns.', 'url': 'https://ark.fandom.com/wiki/Simple_Bullet', 'id': 4, 'class_name': 'PrimalItemAmmo_SimpleBullet_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/88/Simple_Bullet.png'}, {'name': 'Stone Arrow', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_ArrowStone.PrimalItemAmmo_ArrowStone\'"', 'description': "A basic arrow with a flint arrowhead. If it doesn't break, you can recover your ammo.", 'url': 'https://ark.fandom.com/wiki/Stone_Arrow', 'id': 32, 'class_name': 'PrimalItemAmmo_ArrowStone_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/28/Stone_Arrow.png'}, {'name': 'C4 Charge', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/Test/PrimalItemC4Ammo.PrimalItemC4Ammo\'"', 'description': 'This advanced explosive can annihilate structures.', 'url': 'https://ark.fandom.com/wiki/C4_Charge', 'id': 43, 'class_name': 'PrimalItemC4Ammo_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/4/46/C4_Charge.png'}, {'name': 'Tranq Arrow', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_ArrowTranq.PrimalItemAmmo_ArrowTranq\'"', 'description': "Less deadly than other arrows, but rapidly increases the victim's torpidity.", 'url': 'https://ark.fandom.com/wiki/Tranq_Arrow', 'id': 70, 'class_name': 'PrimalItemAmmo_ArrowTranq_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/8/8e/Tranq_Arrow.png'}, {'name': 'Simple Rifle Ammo', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_SimpleRifleBullet.PrimalItemAmmo_SimpleRifleBullet\'"', 'description': 'An odd bullet and casing, used with forged rifles.', 'url': 'https://ark.fandom.com/wiki/Simple_Rifle_Ammo', 'id': 143, 'class_name': 'PrimalItemAmmo_SimpleRifleBullet_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/a/a0/Simple_Rifle_Ammo.png'}, {'name': 'Advanced Bullet', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_AdvancedBullet.PrimalItemAmmo_AdvancedBullet\'"', 'description': 'A small-caliber modern bullet, primarily used with fabricated handguns.', 'url': 'https://ark.fandom.com/wiki/Advanced_Bullet', 'id': 241, 'class_name': 'PrimalItemAmmo_AdvancedBullet_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3e/Advanced_Bullet.png'}, {'name': 'Advanced Rifle Bullet', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_AdvancedRifleBullet.PrimalItemAmmo_AdvancedRifleBullet\'"', 'description': 'Primarily used with fabricated rifles.', 'url': 'https://ark.fandom.com/wiki/Advanced_Rifle_Bullet', 'id': 242, 'class_name': 'PrimalItemAmmo_AdvancedRifleBullet_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/64/Advanced_Rifle_Bullet.png'}, {'name': 'Rocket Propelled Grenade', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_Rocket.PrimalItemAmmo_Rocket\'"', 'description': 'A small but powerful explosive, primarily used with rocket launchers.', 'url': 'https://ark.fandom.com/wiki/Rocket_Propelled_Grenade', 'id': 243, 'class_name': 'PrimalItemAmmo_Rocket_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9e/Rocket_Propelled_Grenade.png'}, {'name': 'Simple Shotgun Ammo', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_SimpleShotgunBullet.PrimalItemAmmo_SimpleShotgunBullet\'"', 'description': 'A few simple bullets in a hide casing, used with forged shotguns.', 'url': 'https://ark.fandom.com/wiki/Simple_Shotgun_Ammo', 'id': 264, 'class_name': 'PrimalItemAmmo_SimpleShotgunBullet_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/18/Simple_Shotgun_Ammo.png'}, {'name': 'Transponder Node', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/Test/PrimalItemTransGPSAmmo.PrimalItemTransGPSAmmo\'"', 'description': 'Can be attached to living Creatures to track their location.', 'url': 'https://ark.fandom.com/wiki/Transponder_Node', 'id': 369, 'class_name': 'PrimalItemTransGPSAmmo_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/59/Transponder_Node.png'}, {'name': 'Metal Arrow', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_CompoundBowArrow.PrimalItemAmmo_CompoundBowArrow\'"', 'description': 'An armor-and-hide piercing metal arrow.', 'url': 'https://ark.fandom.com/wiki/Metal_Arrow', 'id': 373, 'class_name': 'PrimalItemAmmo_CompoundBowArrow_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/1/12/Metal_Arrow.png'}, {'name': 'Advanced Sniper Bullet', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_AdvancedSniperBullet.PrimalItemAmmo_AdvancedSniperBullet\'"', 'description': 'A high-caliber modern bullet, primarily used with fabricated sniper rifles', 'url': 'https://ark.fandom.com/wiki/Advanced_Sniper_Bullet', 'id': 374, 'class_name': 'PrimalItemAmmo_AdvancedSniperBullet_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6c/Advanced_Sniper_Bullet.png'}, {'name': 'Boulder', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_Boulder.PrimalItemAmmo_Boulder\'"', 'description': 'Massive rock with metal spikes. Can only be used in a Catapult Turret.', 'url': 'https://ark.fandom.com/wiki/Boulder', 'id': 375, 'class_name': 'PrimalItemAmmo_Boulder_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/21/Boulder.png'}, {'name': 'Cannon Ball', 'stack_size': 1, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_CannonBall.PrimalItemAmmo_CannonBall\'"', 'description': 'A gigantic ball of heavy metal, capable of demolishing very strong structures.', 'url': 'https://ark.fandom.com/wiki/Cannon_Ball', 'id': 376, 'class_name': 'PrimalItemAmmo_CannonBall_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/fd/Cannon_Ball.png'}, {'name': 'Cannon Shell', 'stack_size': 1, 'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Weapons/PrimalItemAmmo_CannonShell.PrimalItemAmmo_CannonShell\'"', 'description': 'A large artillery shell. Used as ammunition for the Mek Siege Cannon Module.', 'url': 'https://ark.fandom.com/wiki/Cannon_Shell_(Extinction)', 'id': 377, 'class_name': 'PrimalItemAmmo_CannonShell_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/6b/Cannon_Shell_%28Extinction%29.png'}, {'name': 'Explosive Arrow', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/Genesis2/Weapons/TekBow/PrimalItemAmmo_ExplosiveArrow.PrimalItemAmmo_ExplosiveArrow\'"', 'description': 'When infused with Element Shards, will 3-D print high velocity explosive arrows at a cost of Element Shards. Can also fire other arrow types.', 'url': 'https://ark.fandom.com/wiki/Explosive_Arrow_(Genesis:_Part_2)', 'id': 378, 'class_name': 'PrimalItemAmmo_ExplosiveArrow_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/6/61/Tek_Bow_%28Genesis_Part_2%29.png'}, {'name': 'Flame Arrow', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_ArrowFlame.PrimalItemAmmo_ArrowFlame\'"', 'description': 'Lights the target on fire, and can also light oil slicks.', 'url': 'https://ark.fandom.com/wiki/Flame_Arrow_(Scorched_Earth)', 'id': 379, 'class_name': 'PrimalItemAmmo_ArrowFlame_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/d/dc/Flame_Arrow_%28Scorched_Earth%29.png'}, {'name': 'Flamethrower Ammo', 'stack_size': 30, 'blueprint': '"Blueprint\'/Game/ScorchedEarth/WeaponFlamethrower/PrimalItemAmmo_Flamethrower.PrimalItemAmmo_Flamethrower\'"', 'description': 'Fuel for the Flamethrower.', 'url': 'https://ark.fandom.com/wiki/Flamethrower_Ammo_(Scorched_Earth)', 'id': 380, 'class_name': 'PrimalItemAmmo_Flamethrower_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/0/00/Flamethrower_Ammo_%28Scorched_Earth%29.png'}, {'name': 'Grappling Hook', 'stack_size': 10, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_GrapplingHook.PrimalItemAmmo_GrapplingHook\'"', 'description': 'Apply on the Crossbow to grapple onto the environment & other creatures. Primary Fire to "Reel-In", Secondary Fire to "Reel-Out", Crouch to Detach, Jump + Reel-In to Vault-Jump!', 'url': 'https://ark.fandom.com/wiki/Grappling_Hook', 'id': 381, 'class_name': 'PrimalItemAmmo_GrapplingHook_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/3/3d/Grappling_Hook.png'}, {'name': 'Jar of Pitch', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/Genesis2/Weapons/FireBoulder/PrimalItemAmmo_Boulder_Fire.PrimalItemAmmo_Boulder_Fire\'"', 'description': 'Lights the target on fire, and can also light oil slicks. Can be fired from a Ballista Turret or Catapult.', 'url': 'https://ark.fandom.com/wiki/Jar_of_Pitch_(Genesis:_Part_2)', 'id': 382, 'class_name': 'PrimalItemAmmo_Boulder_Fire_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/c/c8/Jar_of_Pitch_concept_art.jpg'}, {'name': 'Net Projectile', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/Genesis2/Weapons/NetAmmo/PrimalItemAmmo_ArrowNet.PrimalItemAmmo_ArrowNet\'"', 'description': 'High-Speed projectile that unfurls to ensnare creatures in netting. Can only be fired from a Harpoon Launcher.', 'url': 'https://ark.fandom.com/wiki/Net_Projectile_(Genesis:_Part_2)', 'id': 383, 'class_name': 'PrimalItemAmmo_ArrowNet_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/2/27/Net_Projectile_%28Genesis_Part_2%29.png'}, {'name': 'Pheromone Dart', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_AggroTranqDart.PrimalItemAmmo_AggroTranqDart\'"', 'description': 'A dart full of refined Ammonite chemicals, inject on a target to enrage nearby wild creatures. For use in a Longneck Rifle. Can not be used with attachments.', 'url': 'https://ark.fandom.com/wiki/Pheromone_Dart', 'id': 384, 'class_name': 'PrimalItemAmmo_AggroTranqDart_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/54/Pheromone_Dart.png'}, {'name': 'Rocket Homing Missile', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/ScorchedEarth/WeaponHomingMissile/PrimalItemAmmo_RocketHomingMissile.PrimalItemAmmo_RocketHomingMissile\'"', 'description': 'Advanced projectile with trajectory auto-correction.', 'url': 'https://ark.fandom.com/wiki/Rocket_Homing_Missile_(Scorched_Earth)', 'id': 385, 'class_name': 'PrimalItemAmmo_RocketHomingMissile_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/9/9f/Rocket_Homing_Missile_%28Scorched_Earth%29.png'}, {'name': 'Rocket Pod', 'stack_size': 1, 'blueprint': '"Blueprint\'/Game/Extinction/CoreBlueprints/Weapons/PrimalItemAmmo_RocketPod.PrimalItemAmmo_RocketPod\'"', 'description': 'A pod containing 16 swarm-fire rockets. Used as ammunition for the Mek Rocket Launcher Module.', 'url': 'https://ark.fandom.com/wiki/Rocket_Pod_(Extinction)', 'id': 386, 'class_name': 'PrimalItemAmmo_RocketPod_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f9/Rocket_Pod_%28Extinction%29.png'}, {'name': 'Shocking Tranquilizer Dart', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_RefinedTranqDart.PrimalItemAmmo_RefinedTranqDart\'"', 'description': 'A potent dart full of tranquilizing poison. For use in a Longneck Rifle. Can not be used with attachments.', 'url': 'https://ark.fandom.com/wiki/Shocking_Tranquilizer_Dart', 'id': 387, 'class_name': 'PrimalItemAmmo_RefinedTranqDart_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Tranquilizer_Dart.png'}, {'name': 'Spear Bolt', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_BallistaArrow.PrimalItemAmmo_BallistaArrow\'"', 'description': "A massive bolt with a cast iron arrowhead. Can only be used in a Ballista Turret or a Harpoon Gun. If it doesn't break, you can recover your ammo.", 'url': 'https://ark.fandom.com/wiki/Spear_Bolt', 'id': 388, 'class_name': 'PrimalItemAmmo_BallistaArrow_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f9/Spear_Bolt.png'}, {'name': 'Tranquilizer Dart', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_TranqDart.PrimalItemAmmo_TranqDart\'"', 'description': 'A potent dart full of tranquilizing poison. For use in a Longneck Rifle. Can not be used with attachments.', 'url': 'https://ark.fandom.com/wiki/Tranquilizer_Dart', 'id': 389, 'class_name': 'PrimalItemAmmo_TranqDart_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/5/56/Tranquilizer_Dart.png'}, {'name': 'Tranq Spear Bolt', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/PrimalEarth/CoreBlueprints/Weapons/PrimalItemAmmo_TranqSpearBolt.PrimalItemAmmo_TranqSpearBolt\'"', 'description': "A massive bolt with a tranq dart mounted on the front. Used as an underwater tranquilizer projectile with the Harpoon Gun. If it doesn't break, you can recover the spear bolt.", 'url': 'https://ark.fandom.com/wiki/Tranq_Spear_Bolt', 'id': 390, 'class_name': 'PrimalItemAmmo_TranqSpearBolt_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/f/f1/Tranq_Spear_Bolt.png'}, {'name': 'Zip-Line Anchor', 'stack_size': 100, 'blueprint': '"Blueprint\'/Game/Aberration/CoreBlueprints/Weapons/PrimalItemAmmo_Zipline.PrimalItemAmmo_Zipline\'"', 'description': 'Apply onto a Crossbow to fire Zip-Line anchor points. Use two anchor points to complete a Zip-Line, which you can then grab onto', 'url': 'https://ark.fandom.com/wiki/Zip-Line_Anchor_(Aberration)', 'id': 391, 'class_name': 'PrimalItemAmmo_Zipline_C', 'image_url': 'https://static.wikia.nocookie.net/arksurvivalevolved_gamepedia/images/e/eb/Zip-Line_Anchor_%28Aberration%29.png'}]
    models.Ammunition.bulk_insert(items)
