"""Builtin Speckle object kit."""

from specklepy.objects.structural.analysis import (
    Model,
    ModelInfo,
    ModelSettings,
    ModelUnits,
)
from specklepy.objects.structural.axis import Axis
from specklepy.objects.structural.geometry import (
    Element1D,
    Element2D,
    Element3D,
    ElementType1D,
    ElementType2D,
    ElementType3D,
    Node,
    Restraint,
)
from specklepy.objects.structural.loading import (
    ActionType,
    BeamLoadType,
    CombinationType,
    FaceLoadType,
    Load,
    LoadAxisType,
    LoadBeam,
    LoadCase,
    LoadCombinations,
    LoadDirection,
    LoadDirection2D,
    LoadFace,
    LoadGravity,
    LoadNode,
    LoadType,
)
from specklepy.objects.structural.materials import (
    Concrete,
    MaterialType,
    Steel,
    StructuralMaterial,
    Timber,
)
from specklepy.objects.structural.properties import (
    BaseReferencePoint,
    MemberType,
    Property,
    Property1D,
    Property2D,
    Property3D,
    PropertyDamper,
    PropertyMass,
    PropertySpring,
    PropertyType2D,
    PropertyType3D,
    PropertyTypeDamper,
    PropertyTypeSpring,
    ReferenceSurface,
    ReferenceSurfaceEnum,
    SectionProfile,
    ShapeType,
    shapeType,
)
from specklepy.objects.structural.results import (
    Result,
    Result1D,
    Result2D,
    Result3D,
    ResultGlobal,
    ResultNode,
    ResultSet1D,
    ResultSet2D,
    ResultSet3D,
    ResultSetAll,
    ResultSetNode,
)

__all__ = [
    "Element1D",
    "Element2D",
    "Element3D",
    "ElementType1D",
    "ElementType2D",
    "ElementType3D",
    "Axis",
    "Node",
    "Restraint",
    "Load",
    "LoadType",
    "ActionType",
    "BeamLoadType",
    "FaceLoadType",
    "LoadDirection",
    "LoadDirection2D",
    "LoadAxisType",
    "CombinationType",
    "LoadBeam",
    "LoadCase",
    "LoadCombinations",
    "LoadFace",
    "LoadGravity",
    "LoadNode",
    "Model",
    "ModelInfo",
    "ModelSettings",
    "ModelUnits",
    "MaterialType",
    "Concrete",
    "StructuralMaterial",
    "Steel",
    "Timber",
    "Property",
    "Property1D",
    "Property2D",
    "Property3D",
    "PropertyDamper",
    "PropertyMass",
    "PropertySpring",
    "SectionProfile",
    "MemberType",
    "BaseReferencePoint",
    "ReferenceSurface",
    "PropertyType2D",
    "PropertyType3D",
    "ShapeType",
    "PropertyTypeSpring",
    "PropertyTypeDamper",
    "ReferenceSurfaceEnum",
    "shapeType",
    "Result",
    "Result1D",
    "ResultSet1D",
    "Result2D",
    "ResultSet2D",
    "Result3D",
    "ResultSet3D",
    "ResultGlobal",
    "ResultSetNode",
    "ResultNode",
    "ResultSetAll",
]
