# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: proto/resource/v1/resource.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class ResourceType(betterproto.Enum):
    Api = 0
    Function = 1
    Bucket = 2
    Queue = 3
    Topic = 4
    Schedule = 5
    Subscription = 6
    Collection = 7
    Policy = 8
    Secret = 9


class Action(betterproto.Enum):
    # Bucket Permissions: 0XX
    BucketFileList = 0
    BucketFileGet = 1
    BucketFilePut = 2
    BucketFileDelete = 3
    # Topic Permissions: 2XX
    TopicList = 200
    TopicDetail = 201
    TopicEventPublish = 202
    # Queue Permissions: 3XX
    QueueSend = 300
    QueueReceive = 301
    QueueList = 302
    QueueDetail = 303
    # Collection Permissions: 4XX
    CollectionDocumentRead = 400
    CollectionDocumentWrite = 401
    CollectionDocumentDelete = 402
    CollectionQuery = 403
    CollectionList = 404
    # Secret Permissions: 5XX
    SecretPut = 500
    SecretAccess = 501


@dataclass(eq=False, repr=False)
class PolicyResource(betterproto.Message):
    principals: List["Resource"] = betterproto.message_field(1)
    actions: List["Action"] = betterproto.enum_field(2)
    resources: List["Resource"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Resource(betterproto.Message):
    type: "ResourceType" = betterproto.enum_field(1)
    name: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ResourceDeclareRequest(betterproto.Message):
    resource: "Resource" = betterproto.message_field(1)
    policy: "PolicyResource" = betterproto.message_field(10, group="config")
    bucket: "BucketResource" = betterproto.message_field(11, group="config")
    queue: "QueueResource" = betterproto.message_field(12, group="config")
    topic: "TopicResource" = betterproto.message_field(13, group="config")
    collection: "CollectionResource" = betterproto.message_field(14, group="config")
    secret: "SecretResource" = betterproto.message_field(15, group="config")
    api: "ApiResource" = betterproto.message_field(16, group="config")


@dataclass(eq=False, repr=False)
class BucketResource(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class QueueResource(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class TopicResource(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class CollectionResource(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class SecretResource(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ApiSecurityDefinitionJwt(betterproto.Message):
    """protect your API with JWT authentication"""

    issuer: str = betterproto.string_field(1)
    audiences: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ApiSecurityDefinition(betterproto.Message):
    jwt: "ApiSecurityDefinitionJwt" = betterproto.message_field(1, group="definition")


@dataclass(eq=False, repr=False)
class ApiScopes(betterproto.Message):
    scopes: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ApiResource(betterproto.Message):
    # Security definitions for the api These may be used by registered routes and
    # operations on the API
    security_definitions: Dict[str, "ApiSecurityDefinition"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    # root level security for this api
    security: Dict[str, "ApiScopes"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


@dataclass(eq=False, repr=False)
class ResourceDeclareResponse(betterproto.Message):
    pass


class ResourceServiceStub(betterproto.ServiceStub):
    async def declare(
        self,
        *,
        resource: "Resource" = None,
        policy: "PolicyResource" = None,
        bucket: "BucketResource" = None,
        queue: "QueueResource" = None,
        topic: "TopicResource" = None,
        collection: "CollectionResource" = None,
        secret: "SecretResource" = None,
        api: "ApiResource" = None,
    ) -> "ResourceDeclareResponse":

        request = ResourceDeclareRequest()
        if resource is not None:
            request.resource = resource
        if policy is not None:
            request.policy = policy
        if bucket is not None:
            request.bucket = bucket
        if queue is not None:
            request.queue = queue
        if topic is not None:
            request.topic = topic
        if collection is not None:
            request.collection = collection
        if secret is not None:
            request.secret = secret
        if api is not None:
            request.api = api

        return await self._unary_unary(
            "/nitric.resource.v1.ResourceService/Declare",
            request,
            ResourceDeclareResponse,
        )


class ResourceServiceBase(ServiceBase):
    async def declare(
        self,
        resource: "Resource",
        policy: "PolicyResource",
        bucket: "BucketResource",
        queue: "QueueResource",
        topic: "TopicResource",
        collection: "CollectionResource",
        secret: "SecretResource",
        api: "ApiResource",
    ) -> "ResourceDeclareResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_declare(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "resource": request.resource,
            "policy": request.policy,
            "bucket": request.bucket,
            "queue": request.queue,
            "topic": request.topic,
            "collection": request.collection,
            "secret": request.secret,
            "api": request.api,
        }

        response = await self.declare(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/nitric.resource.v1.ResourceService/Declare": grpclib.const.Handler(
                self.__rpc_declare,
                grpclib.const.Cardinality.UNARY_UNARY,
                ResourceDeclareRequest,
                ResourceDeclareResponse,
            ),
        }
