"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FakeSourceAction = void 0;
const core_1 = require("@aws-cdk/core");
const codepipeline = require("../lib");
class FakeSourceAction {
    constructor(props) {
        this.actionProperties = {
            ...props,
            category: codepipeline.ActionCategory.SOURCE,
            provider: 'Fake',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 1, maxOutputs: 4 },
            outputs: [props.output, ...props.extraOutputs || []],
        };
        this.variables = {
            firstVariable: core_1.Lazy.stringValue({ produce: () => `#{${this.actionProperties.variablesNamespace}.FirstVariable}` }),
        };
    }
    bind(_scope, _stage, _options) {
        return {};
    }
    onStateChange(_name, _target, _options) {
        throw new Error('onStateChange() is not available on FakeSourceAction');
    }
}
exports.FakeSourceAction = FakeSourceAction;
//# sourceMappingURL=data:application/json;base64,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