"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FakeBuildAction = void 0;
const codepipeline = require("../lib");
class FakeBuildAction {
    constructor(props) {
        this.actionProperties = {
            ...props,
            category: codepipeline.ActionCategory.BUILD,
            provider: 'Fake',
            artifactBounds: { minInputs: 1, maxInputs: 3, minOutputs: 0, maxOutputs: 1 },
            inputs: [props.input, ...props.extraInputs || []],
            outputs: props.output ? [props.output] : undefined,
        };
        this.customConfigKey = props.customConfigKey;
    }
    bind(_scope, _stage, _options) {
        return {
            configuration: {
                CustomConfigKey: this.customConfigKey,
            },
        };
    }
    onStateChange(_name, _target, _options) {
        throw new Error('onStateChange() is not available on FakeBuildAction');
    }
}
exports.FakeBuildAction = FakeBuildAction;
//# sourceMappingURL=data:application/json;base64,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