"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FullActionDescriptor = void 0;
/**
 * This class is private to the aws-codepipeline package.
 */
class FullActionDescriptor {
    constructor(props) {
        this.action = props.action;
        const actionProperties = props.action.actionProperties;
        this.actionName = actionProperties.actionName;
        this.category = actionProperties.category;
        this.owner = actionProperties.owner || 'AWS';
        this.provider = actionProperties.provider;
        this.version = actionProperties.version || '1';
        this.runOrder = actionProperties.runOrder === undefined ? 1 : actionProperties.runOrder;
        this.artifactBounds = actionProperties.artifactBounds;
        this.namespace = actionProperties.variablesNamespace;
        this.inputs = deduplicateArtifacts(actionProperties.inputs);
        this.outputs = deduplicateArtifacts(actionProperties.outputs);
        this.region = props.actionRegion || actionProperties.region;
        this.role = actionProperties.role !== undefined ? actionProperties.role : props.actionRole;
        this.configuration = props.actionConfig.configuration;
    }
}
exports.FullActionDescriptor = FullActionDescriptor;
function deduplicateArtifacts(artifacts) {
    const ret = new Array();
    for (const artifact of artifacts || []) {
        if (artifact.artifactName) {
            if (ret.find(a => a.artifactName === artifact.artifactName)) {
                continue;
            }
        }
        else {
            if (ret.find(a => a === artifact)) {
                continue;
            }
        }
        ret.push(artifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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