"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketStage = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const base_1 = require("../common/base");
/**
 * Represents a stage where an instance of the API is deployed.
 * @resource AWS::ApiGatewayV2::Stage
 */
class WebSocketStage extends base_1.StageBase {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketStageProps(props);
        this.baseApi = props.webSocketApi;
        this.api = props.webSocketApi;
        this.stageName = this.physicalName;
        new apigatewayv2_generated_1.CfnStage(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
        });
        if (props.domainMapping) {
            this._addDomainMapping(props.domainMapping);
        }
    }
    /**
     * Import an existing stage into this CDK app.
     */
    static fromWebSocketStageAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketStageAttributes(attrs);
        class Import extends base_1.StageBase {
            constructor() {
                super(...arguments);
                this.baseApi = attrs.api;
                this.stageName = attrs.stageName;
                this.api = attrs.api;
            }
            get url() {
                throw new Error('url is not available for imported stages.');
            }
            get callbackUrl() {
                throw new Error('callback url is not available for imported stages.');
            }
        }
        return new Import(scope, id);
    }
    /**
     * The websocket URL to this stage.
     */
    get url() {
        const s = core_1.Stack.of(this);
        const urlPath = this.stageName;
        return `wss://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * The callback URL to this stage.
     */
    get callbackUrl() {
        const s = core_1.Stack.of(this);
        const urlPath = this.stageName;
        return `https://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * Grant access to the API Gateway management API for this WebSocket API Stage to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     */
    grantManagementApiAccess(identity) {
        const arn = core_1.Stack.of(this.api).formatArn({
            service: 'execute-api',
            resource: this.api.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/${this.stageName}/*/@connections/*`],
        });
    }
}
exports.WebSocketStage = WebSocketStage;
_a = JSII_RTTI_SYMBOL_1;
WebSocketStage[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.WebSocketStage", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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