"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketApi = exports.WebSocketApiKeySelectionExpression = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const base_1 = require("../common/base");
const route_1 = require("./route");
/**
 * Represents the currently available API Key Selection Expressions
 */
class WebSocketApiKeySelectionExpression {
    /**
     * @param customApiKeySelector The expression used by API Gateway
     */
    constructor(customApiKeySelector) {
        this.customApiKeySelector = customApiKeySelector;
    }
}
exports.WebSocketApiKeySelectionExpression = WebSocketApiKeySelectionExpression;
_a = JSII_RTTI_SYMBOL_1;
WebSocketApiKeySelectionExpression[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.WebSocketApiKeySelectionExpression", version: "1.152.0" };
/**
 * The API will extract the key value from the `x-api-key` header in the user request.
 */
WebSocketApiKeySelectionExpression.HEADER_X_API_KEY = new WebSocketApiKeySelectionExpression('$request.header.x-api-key');
/**
  * The API will extract the key value from the `usageIdentifierKey` attribute in the `context` map,
  * returned by the Lambda Authorizer.
  * See https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
  */
WebSocketApiKeySelectionExpression.AUTHORIZER_USAGE_IDENTIFIER_KEY = new WebSocketApiKeySelectionExpression('$context.authorizer.usageIdentifierKey');
/**
 * Create a new API Gateway WebSocket API endpoint.
 * @resource AWS::ApiGatewayV2::Api
 */
class WebSocketApi extends base_1.ApiBase {
    constructor(scope, id, props) {
        var _c, _d, _e;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketApiProps(props);
        this.webSocketApiName = (_c = props === null || props === void 0 ? void 0 : props.apiName) !== null && _c !== void 0 ? _c : id;
        const resource = new apigatewayv2_generated_1.CfnApi(this, 'Resource', {
            name: this.webSocketApiName,
            apiKeySelectionExpression: (_d = props === null || props === void 0 ? void 0 : props.apiKeySelectionExpression) === null || _d === void 0 ? void 0 : _d.customApiKeySelector,
            protocolType: 'WEBSOCKET',
            description: props === null || props === void 0 ? void 0 : props.description,
            routeSelectionExpression: (_e = props === null || props === void 0 ? void 0 : props.routeSelectionExpression) !== null && _e !== void 0 ? _e : '$request.body.action',
        });
        this.apiId = resource.ref;
        this.apiEndpoint = resource.attrApiEndpoint;
        if (props === null || props === void 0 ? void 0 : props.connectRouteOptions) {
            this.addRoute('$connect', props.connectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.disconnectRouteOptions) {
            this.addRoute('$disconnect', props.disconnectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.defaultRouteOptions) {
            this.addRoute('$default', props.defaultRouteOptions);
        }
    }
    /**
     * Import an existing WebSocket API into this CDK app.
     */
    static fromWebSocketApiAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketApiAttributes(attrs);
        class Import extends base_1.ApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.webSocketId;
                this.websocketApiId = attrs.webSocketId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported WebSocketApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Add a new route
     */
    addRoute(routeKey, options) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketRouteOptions(options);
        return new route_1.WebSocketRoute(this, `${routeKey}-Route`, {
            webSocketApi: this,
            routeKey,
            ...options,
        });
    }
    /**
     * Grant access to the API Gateway management API for this WebSocket API to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     */
    grantManageConnections(identity) {
        const arn = core_1.Stack.of(this).formatArn({
            service: 'execute-api',
            resource: this.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/*/*/@connections/*`],
        });
    }
}
exports.WebSocketApi = WebSocketApi;
_b = JSII_RTTI_SYMBOL_1;
WebSocketApi[_b] = { fqn: "@aws-cdk/aws-apigatewayv2.WebSocketApi", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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