"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRoute = exports.HttpRouteKey = exports.HttpMethod = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Supported HTTP methods
 */
var HttpMethod;
(function (HttpMethod) {
    /** HTTP ANY */
    HttpMethod["ANY"] = "ANY";
    /** HTTP DELETE */
    HttpMethod["DELETE"] = "DELETE";
    /** HTTP GET */
    HttpMethod["GET"] = "GET";
    /** HTTP HEAD */
    HttpMethod["HEAD"] = "HEAD";
    /** HTTP OPTIONS */
    HttpMethod["OPTIONS"] = "OPTIONS";
    /** HTTP PATCH */
    HttpMethod["PATCH"] = "PATCH";
    /** HTTP POST */
    HttpMethod["POST"] = "POST";
    /** HTTP PUT */
    HttpMethod["PUT"] = "PUT";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * HTTP route in APIGateway is a combination of the HTTP method and the path component.
 * This class models that combination.
 */
class HttpRouteKey {
    constructor(method, path) {
        this.method = method !== null && method !== void 0 ? method : HttpMethod.ANY;
        this.path = path;
        this.key = path ? `${method} ${path}` : '$default';
    }
    /**
     * Create a route key with the combination of the path and the method.
     * @param method default is 'ANY'
     */
    static with(path, method) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_HttpMethod(method);
        if (path !== '/' && (!path.startsWith('/') || path.endsWith('/'))) {
            throw new Error('A route path must always start with a "/" and not end with a "/"');
        }
        return new HttpRouteKey(method, path);
    }
}
exports.HttpRouteKey = HttpRouteKey;
_a = JSII_RTTI_SYMBOL_1;
HttpRouteKey[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpRouteKey", version: "1.152.0" };
/**
 * The catch-all route of the API, i.e., when no other routes match
 */
HttpRouteKey.DEFAULT = new HttpRouteKey();
/**
 * Supported Route Authorizer types
 */
var HttpRouteAuthorizationType;
(function (HttpRouteAuthorizationType) {
    /** AWS IAM */
    HttpRouteAuthorizationType["AWS_IAM"] = "AWS_IAM";
    /** JSON Web Tokens */
    HttpRouteAuthorizationType["JWT"] = "JWT";
    /** Lambda Authorizer */
    HttpRouteAuthorizationType["CUSTOM"] = "CUSTOM";
    /** No authorizer */
    HttpRouteAuthorizationType["NONE"] = "NONE";
})(HttpRouteAuthorizationType || (HttpRouteAuthorizationType = {}));
/**
 * Route class that creates the Route for API Gateway HTTP API
 * @resource AWS::ApiGatewayV2::Route
 */
class HttpRoute extends core_1.Resource {
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_HttpRouteProps(props);
        this.httpApi = props.httpApi;
        this.path = props.routeKey.path;
        this.method = props.routeKey.method;
        this.routeArn = this.produceRouteArn(props.routeKey.method);
        const config = props.integration._bindToRoute({
            route: this,
            scope: this,
        });
        this.authBindResult = (_c = props.authorizer) === null || _c === void 0 ? void 0 : _c.bind({
            route: this,
            scope: this.httpApi instanceof constructs_1.Construct ? this.httpApi : this,
        });
        if (this.authBindResult && !(this.authBindResult.authorizationType in HttpRouteAuthorizationType)) {
            throw new Error(`authorizationType should either be AWS_IAM, JWT, CUSTOM, or NONE but was '${this.authBindResult.authorizationType}'`);
        }
        let authorizationScopes = (_d = this.authBindResult) === null || _d === void 0 ? void 0 : _d.authorizationScopes;
        if (this.authBindResult && props.authorizationScopes) {
            authorizationScopes = Array.from(new Set([
                ...authorizationScopes !== null && authorizationScopes !== void 0 ? authorizationScopes : [],
                ...props.authorizationScopes,
            ]));
        }
        if ((authorizationScopes === null || authorizationScopes === void 0 ? void 0 : authorizationScopes.length) === 0) {
            authorizationScopes = undefined;
        }
        const routeProps = {
            apiId: props.httpApi.apiId,
            routeKey: props.routeKey.key,
            target: `integrations/${config.integrationId}`,
            authorizerId: (_e = this.authBindResult) === null || _e === void 0 ? void 0 : _e.authorizerId,
            authorizationType: (_g = (_f = this.authBindResult) === null || _f === void 0 ? void 0 : _f.authorizationType) !== null && _g !== void 0 ? _g : 'NONE',
            authorizationScopes,
        };
        const route = new apigatewayv2_generated_1.CfnRoute(this, 'Resource', routeProps);
        this.routeId = route.ref;
    }
    produceRouteArn(httpMethod) {
        var _c;
        const stage = '*';
        const iamHttpMethod = httpMethod === HttpMethod.ANY ? '*' : httpMethod;
        const path = (_c = this.path) !== null && _c !== void 0 ? _c : '/';
        // When the user has provided a path with path variables, we replace the
        // path variable and all that follows with a wildcard.
        const iamPath = path.replace(/\{.*?\}.*/, '*');
        return `arn:aws:execute-api:${this.stack.region}:${this.stack.account}:${this.httpApi.apiId}/${stage}/${iamHttpMethod}${iamPath}`;
    }
    grantInvoke(grantee, options = {}) {
        var _c;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_GrantInvokeOptions(options);
        if (!this.authBindResult || this.authBindResult.authorizationType !== HttpRouteAuthorizationType.AWS_IAM) {
            throw new Error('To use grantInvoke, you must use IAM authorization');
        }
        const httpMethods = Array.from(new Set((_c = options.httpMethods) !== null && _c !== void 0 ? _c : [this.method]));
        if (this.method !== HttpMethod.ANY && httpMethods.some(method => method !== this.method)) {
            throw new Error('This route does not support granting invoke for all requested http methods');
        }
        const resourceArns = httpMethods.map(httpMethod => {
            return this.produceRouteArn(httpMethod);
        });
        return iam.Grant.addToPrincipal({
            grantee,
            actions: ['execute-api:Invoke'],
            resourceArns: resourceArns,
        });
    }
}
exports.HttpRoute = HttpRoute;
_b = JSII_RTTI_SYMBOL_1;
HttpRoute[_b] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpRoute", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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