"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiMapping = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Create a new API mapping for API Gateway API endpoint.
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class ApiMapping extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_ApiMappingProps(props);
        // defaultStage is present in IHttpStage.
        // However, importing "http" or "websocket" must import "common", but creating dependencies
        // the other way will cause potential cycles.
        // So casting to 'any'
        let stage = (_b = props.stage) !== null && _b !== void 0 ? _b : props.api.defaultStage;
        if (!stage) {
            throw new Error('stage property must be specified');
        }
        if (props.apiMappingKey === '') {
            throw new Error('empty string for api mapping key not allowed');
        }
        const apiMappingProps = {
            apiId: props.api.apiId,
            domainName: props.domainName.name,
            stage: stage.stageName,
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new apigatewayv2_generated_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        // ensure the dependency on the provided stage
        this.node.addDependency(stage);
        this.apiMappingId = resource.ref;
        this.mappingKey = props.apiMappingKey;
        this.domainName = props.domainName;
    }
    /**
     * import from API ID
     */
    static fromApiMappingAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_ApiMappingAttributes(attrs);
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.ApiMapping = ApiMapping;
_a = JSII_RTTI_SYMBOL_1;
ApiMapping[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.ApiMapping", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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