/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import org.hl7.fhir.utilities.Utilities;

public class PackageInfo {
    private final String id;
    private final String version;
    private final String fhirVersion;
    private final String description;
    private final String url;
    private final String canonical;

    public PackageInfo(String id, String version, String fhirVersion, String description, String url, String canonical) {
        this(id, version, fhirVersion, description, url, canonical, null);
    }

    public PackageInfo(String id, String version, String fhirVersion, String description, String url, String canonical, String address) {
        this.id = id;
        this.version = version;
        this.fhirVersion = fhirVersion;
        this.description = description;
        this.url = url == null && id != null && version != null ? Utilities.pathURL(address, id, version) : url;
        this.canonical = canonical;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFhirVersion() {
        return this.fhirVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCanonical() {
        return this.canonical;
    }

    public String toString() {
        return this.id + "#" + (this.version == null ? "?pc-pi?" : this.version) + (this.fhirVersion == null ? "" : " (" + this.canonical + ") for FHIR " + this.fhirVersion) + (this.url == null ? "" : " @" + this.url) + (this.description == null ? "" : " '" + this.description + "'");
    }
}

