/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MessageheaderResponseRequest {
    ALWAYS,
    ONERROR,
    NEVER,
    ONSUCCESS,
    NULL;


    public static MessageheaderResponseRequest fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("always".equals(codeString)) {
            return ALWAYS;
        }
        if ("on-error".equals(codeString)) {
            return ONERROR;
        }
        if ("never".equals(codeString)) {
            return NEVER;
        }
        if ("on-success".equals(codeString)) {
            return ONSUCCESS;
        }
        throw new FHIRException("Unknown MessageheaderResponseRequest code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ALWAYS: {
                return "always";
            }
            case ONERROR: {
                return "on-error";
            }
            case NEVER: {
                return "never";
            }
            case ONSUCCESS: {
                return "on-success";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/messageheader-response-request";
    }

    public String getDefinition() {
        switch (this) {
            case ALWAYS: {
                return "initiator expects a response for this message.";
            }
            case ONERROR: {
                return "initiator expects a response only if in error.";
            }
            case NEVER: {
                return "initiator does not expect a response.";
            }
            case ONSUCCESS: {
                return "initiator expects a response only if successful.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ALWAYS: {
                return "Always";
            }
            case ONERROR: {
                return "Error/reject conditions only";
            }
            case NEVER: {
                return "Never";
            }
            case ONSUCCESS: {
                return "Successful completion only";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

