/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.hl7.fhir.utilities.Utilities;

public class MyURIResolver
implements URIResolver {
    private String path;
    private URIResolver alt;

    public MyURIResolver(String path, URIResolver alt) {
        this.path = path;
        this.alt = alt;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        try {
            if (href.startsWith("http://") || href.startsWith("https://")) {
                Source s2;
                if (this.alt != null && (s2 = this.alt.resolve(href, base)) != null) {
                    return s2;
                }
                return TransformerFactory.newInstance().getURIResolver().resolve(href, base);
            }
            return new StreamSource(new FileInputStream(href.contains(File.separator) ? href : Utilities.path(this.path, href)));
        }
        catch (FileNotFoundException e) {
            throw new TransformerException(e);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }
}

