/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3CalendarCycle {
    _CALENDARCYCLEONELETTER,
    CW,
    CY,
    D,
    DW,
    H,
    M,
    N,
    S,
    _CALENDARCYCLETWOLETTER,
    CD,
    CH,
    CM,
    CN,
    CS,
    DY,
    WY,
    WM,
    NULL;


    public static V3CalendarCycle fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("_CalendarCycleOneLetter".equals(codeString)) {
            return _CALENDARCYCLEONELETTER;
        }
        if ("CW".equals(codeString)) {
            return CW;
        }
        if ("CY".equals(codeString)) {
            return CY;
        }
        if ("D".equals(codeString)) {
            return D;
        }
        if ("DW".equals(codeString)) {
            return DW;
        }
        if ("H".equals(codeString)) {
            return H;
        }
        if ("M".equals(codeString)) {
            return M;
        }
        if ("N".equals(codeString)) {
            return N;
        }
        if ("S".equals(codeString)) {
            return S;
        }
        if ("_CalendarCycleTwoLetter".equals(codeString)) {
            return _CALENDARCYCLETWOLETTER;
        }
        if ("CD".equals(codeString)) {
            return CD;
        }
        if ("CH".equals(codeString)) {
            return CH;
        }
        if ("CM".equals(codeString)) {
            return CM;
        }
        if ("CN".equals(codeString)) {
            return CN;
        }
        if ("CS".equals(codeString)) {
            return CS;
        }
        if ("DY".equals(codeString)) {
            return DY;
        }
        if ("WY".equals(codeString)) {
            return WY;
        }
        if ("WM".equals(codeString)) {
            return WM;
        }
        throw new FHIRException("Unknown V3CalendarCycle code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _CALENDARCYCLEONELETTER: {
                return "_CalendarCycleOneLetter";
            }
            case CW: {
                return "CW";
            }
            case CY: {
                return "CY";
            }
            case D: {
                return "D";
            }
            case DW: {
                return "DW";
            }
            case H: {
                return "H";
            }
            case M: {
                return "M";
            }
            case N: {
                return "N";
            }
            case S: {
                return "S";
            }
            case _CALENDARCYCLETWOLETTER: {
                return "_CalendarCycleTwoLetter";
            }
            case CD: {
                return "CD";
            }
            case CH: {
                return "CH";
            }
            case CM: {
                return "CM";
            }
            case CN: {
                return "CN";
            }
            case CS: {
                return "CS";
            }
            case DY: {
                return "DY";
            }
            case WY: {
                return "WY";
            }
            case WM: {
                return "WM";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-CalendarCycle";
    }

    public String getDefinition() {
        switch (this) {
            case _CALENDARCYCLEONELETTER: {
                return "CalendarCycleOneLetter";
            }
            case CW: {
                return "week (continuous)";
            }
            case CY: {
                return "year";
            }
            case D: {
                return "day of the month";
            }
            case DW: {
                return "day of the week (begins with Monday)";
            }
            case H: {
                return "hour of the day";
            }
            case M: {
                return "month of the year";
            }
            case N: {
                return "minute of the hour";
            }
            case S: {
                return "second of the minute";
            }
            case _CALENDARCYCLETWOLETTER: {
                return "CalendarCycleTwoLetter";
            }
            case CD: {
                return "day (continuous)";
            }
            case CH: {
                return "hour (continuous)";
            }
            case CM: {
                return "month (continuous)";
            }
            case CN: {
                return "minute (continuous)";
            }
            case CS: {
                return "second (continuous)";
            }
            case DY: {
                return "day of the year";
            }
            case WY: {
                return "week of the year";
            }
            case WM: {
                return "The week with the month's first Thursday in it (analagous to the ISO 8601 definition for week of the year).";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _CALENDARCYCLEONELETTER: {
                return "CalendarCycleOneLetter";
            }
            case CW: {
                return "week (continuous)";
            }
            case CY: {
                return "year";
            }
            case D: {
                return "day of the month";
            }
            case DW: {
                return "day of the week (begins with Monday)";
            }
            case H: {
                return "hour of the day";
            }
            case M: {
                return "month of the year";
            }
            case N: {
                return "minute of the hour";
            }
            case S: {
                return "second of the minute";
            }
            case _CALENDARCYCLETWOLETTER: {
                return "CalendarCycleTwoLetter";
            }
            case CD: {
                return "day (continuous)";
            }
            case CH: {
                return "hour (continuous)";
            }
            case CM: {
                return "month (continuous)";
            }
            case CN: {
                return "minute (continuous)";
            }
            case CS: {
                return "second (continuous)";
            }
            case DY: {
                return "day of the year";
            }
            case WY: {
                return "week of the year";
            }
            case WM: {
                return "week of the month";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

