/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ReasonMedicationNotGivenCodes {
    A,
    B,
    C,
    D,
    NULL;


    public static ReasonMedicationNotGivenCodes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("a".equals(codeString)) {
            return A;
        }
        if ("b".equals(codeString)) {
            return B;
        }
        if ("c".equals(codeString)) {
            return C;
        }
        if ("d".equals(codeString)) {
            return D;
        }
        throw new FHIRException("Unknown ReasonMedicationNotGivenCodes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case A: {
                return "a";
            }
            case B: {
                return "b";
            }
            case C: {
                return "c";
            }
            case D: {
                return "d";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/reason-medication-not-given";
    }

    public String getDefinition() {
        switch (this) {
            case A: {
                return "No reason known.";
            }
            case B: {
                return "The patient was not available when the dose was scheduled.";
            }
            case C: {
                return "The patient was asleep when the dose was scheduled.";
            }
            case D: {
                return "The patient was given the medication and immediately vomited it back.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case A: {
                return "None";
            }
            case B: {
                return "Away";
            }
            case C: {
                return "Asleep";
            }
            case D: {
                return "Vomit";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

