/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.ctx;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.util.CoverageIgnore;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.ParserType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.r4.utils.INarrativeGenerator;
import org.hl7.fhir.r4.utils.validation.IResourceValidator;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public final class HapiWorkerContext
extends I18nBase
implements IWorkerContext {
    private final FhirContext myCtx;
    private final Cache<String, Resource> myFetchedResourceCache;
    private IValidationSupport myValidationSupport;
    private Parameters myExpansionProfile;
    private String myOverrideVersionNs;

    public HapiWorkerContext(FhirContext theCtx, IValidationSupport theValidationSupport) {
        Validate.notNull(theCtx, "theCtx must not be null", new Object[0]);
        Validate.notNull(theValidationSupport, "theValidationSupport must not be null", new Object[0]);
        this.myCtx = theCtx;
        this.myValidationSupport = theValidationSupport;
        long timeoutMillis = 10000L;
        if (System.getProperties().containsKey("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS")) {
            timeoutMillis = Long.parseLong(System.getProperty("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS"));
        }
        this.myFetchedResourceCache = Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).build();
        this.setValidationMessageLanguage(this.getLocale());
    }

    @Override
    public List<StructureDefinition> allStructures() {
        return this.myValidationSupport.fetchAllStructureDefinitions();
    }

    @Override
    public List<StructureDefinition> getStructures() {
        return this.allStructures();
    }

    @Override
    public CodeSystem fetchCodeSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return (CodeSystem)this.myValidationSupport.fetchCodeSystem(theSystem);
    }

    @Override
    public List<ConceptMap> findMapsForSource(String theUrl) {
        throw new UnsupportedOperationException(Msg.code(258));
    }

    @Override
    public String getAbbreviation(String theName) {
        throw new UnsupportedOperationException(Msg.code(259));
    }

    @Override
    public INarrativeGenerator getNarrativeGenerator(String thePrefix, String theBasePath) {
        throw new UnsupportedOperationException(Msg.code(260));
    }

    @Override
    public IParser getParser(ParserType theType) {
        throw new UnsupportedOperationException(Msg.code(261));
    }

    @Override
    public IParser getParser(String theType) {
        throw new UnsupportedOperationException(Msg.code(262));
    }

    @Override
    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ResourceType next : ResourceType.values()) {
            result.add(next.name());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public IParser newJsonParser() {
        throw new UnsupportedOperationException(Msg.code(263));
    }

    @Override
    public IResourceValidator newValidator() {
        throw new UnsupportedOperationException(Msg.code(264));
    }

    @Override
    public IParser newXmlParser() {
        throw new UnsupportedOperationException(Msg.code(265));
    }

    @Override
    public String oid2Uri(String theCode) {
        throw new UnsupportedOperationException(Msg.code(266));
    }

    @Override
    public boolean supportsSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return false;
        }
        return this.myValidationSupport.isCodeSystemSupported(new ValidationSupportContext(this.myValidationSupport), theSystem);
    }

    @Override
    public Set<String> typeTails() {
        return new HashSet<String>(Arrays.asList("Integer", "UnsignedInt", "PositiveInt", "Decimal", "DateTime", "Date", "Time", "Instant", "String", "Uri", "Oid", "Uuid", "Id", "Boolean", "Code", "Markdown", "Base64Binary", "Coding", "CodeableConcept", "Attachment", "Identifier", "Quantity", "SampledData", "Range", "Period", "Ratio", "HumanName", "Address", "ContactPoint", "Timing", "Reference", "Annotation", "Signature", "Meta"));
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, CodeableConcept theCode, ValueSet theVs) {
        for (Coding next : theCode.getCoding()) {
            IWorkerContext.ValidationResult retVal = this.validateCode(theOptions, next, theVs);
            if (!retVal.isOk()) continue;
            return retVal;
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, null);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, Coding theCode, ValueSet theVs) {
        String system = theCode.getSystem();
        String code = theCode.getCode();
        String display = theCode.getDisplay();
        return this.validateCode(theOptions, system, code, display, theVs);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = this.myValidationSupport.validateCode(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, null);
        if (result == null) {
            return null;
        }
        ValidationMessage.IssueSeverity severity = null;
        if (result.getSeverity() != null) {
            severity = ValidationMessage.IssueSeverity.fromCode(result.getSeverityCode());
        }
        CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent().setCode(result.getCode());
        return new IWorkerContext.ValidationResult(severity, result.getMessage(), definition);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String theDisplay, ValueSet.ConceptSetComponent theVsi) {
        throw new UnsupportedOperationException(Msg.code(267));
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String theDisplay, ValueSet theVs) {
        IValidationSupport.CodeValidationResult outcome = StringUtils.isNotBlank(theVs.getUrl()) ? this.myValidationSupport.validateCode(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, theVs.getUrl()) : this.myValidationSupport.validateCodeInValueSet(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, theVs);
        if (outcome != null && outcome.isOk()) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theCode);
            definition.setDisplay(outcome.getDisplay());
            return new IWorkerContext.ValidationResult(definition);
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown code[" + theCode + "] in system[" + Constants.codeSystemWithDefaultDescription(theSystem) + "]");
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String code, ValueSet vs) {
        ValidationOptions options = theOptions.guessSystem();
        return this.validateCode(options, null, code, null, vs);
    }

    @Override
    @CoverageIgnore
    public List<MetadataResource> allConformanceResources() {
        throw new UnsupportedOperationException(Msg.code(268));
    }

    @Override
    public void generateSnapshot(StructureDefinition p) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code(269));
    }

    @Override
    public Parameters getExpansionParameters() {
        return this.myExpansionProfile;
    }

    @Override
    public void setExpansionProfile(Parameters theExpParameters) {
        this.myExpansionProfile = theExpParameters;
    }

    @Override
    @CoverageIgnore
    public boolean hasCache() {
        throw new UnsupportedOperationException(Msg.code(270));
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet theSource, boolean theCacheOk, boolean theHierarchical) {
        throw new UnsupportedOperationException(Msg.code(271));
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent theInc, boolean theHierarchical) throws TerminologyServiceException {
        ValueSet input = new ValueSet();
        input.getCompose().addInclude(theInc);
        IValidationSupport.ValueSetExpansionOutcome output = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), null, input);
        return new ValueSetExpander.ValueSetExpansionOutcome((ValueSet)output.getValueSet(), output.getError(), null);
    }

    @Override
    public IWorkerContext.ILoggingService getLogger() {
        throw new UnsupportedOperationException(Msg.code(272));
    }

    @Override
    public void setLogger(IWorkerContext.ILoggingService theLogger) {
        throw new UnsupportedOperationException(Msg.code(273));
    }

    @Override
    public String getVersion() {
        return this.myCtx.getVersion().getVersion().getFhirVersionString();
    }

    @Override
    public UcumService getUcumService() {
        throw new UnsupportedOperationException(Msg.code(274));
    }

    @Override
    public void setUcumService(UcumService ucumService) {
        throw new UnsupportedOperationException(Msg.code(275));
    }

    @Override
    public boolean isNoTerminologyServer() {
        return false;
    }

    @Override
    public TranslationServices translator() {
        throw new UnsupportedOperationException(Msg.code(276));
    }

    @Override
    public List<StructureMap> listTransforms() {
        throw new UnsupportedOperationException(Msg.code(277));
    }

    @Override
    public StructureMap getTransform(String url) {
        throw new UnsupportedOperationException(Msg.code(278));
    }

    @Override
    public String getOverrideVersionNs() {
        return this.myOverrideVersionNs;
    }

    @Override
    public void setOverrideVersionNs(String value) {
        this.myOverrideVersionNs = value;
    }

    @Override
    public StructureDefinition fetchTypeDefinition(String typeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }

    @Override
    public String getLinkForUrl(String corePath, String url) {
        throw new UnsupportedOperationException(Msg.code(279));
    }

    @Override
    public List<String> getTypeNames() {
        throw new UnsupportedOperationException(Msg.code(280));
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri) {
        if (this.myValidationSupport == null) {
            return null;
        }
        Resource retVal = (Resource)this.myFetchedResourceCache.get((Object)theUri, t -> (Resource)this.myValidationSupport.fetchResource(theClass, theUri));
        return (T)retVal;
    }

    @Override
    public <T extends Resource> T fetchResourceWithException(Class<T> theClass, String theUri) throws FHIRException {
        T retVal = this.fetchResource(theClass, theUri);
        if (retVal == null) {
            throw new FHIRException(Msg.code(281) + "Could not find resource: " + theUri);
        }
        return retVal;
    }

    @Override
    public Resource fetchResourceById(String theType, String theUri) {
        throw new UnsupportedOperationException(Msg.code(282));
    }

    @Override
    public <T extends Resource> boolean hasResource(Class<T> theClass_, String theUri) {
        throw new UnsupportedOperationException(Msg.code(283));
    }

    @Override
    public void cacheResource(Resource theRes) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code(284));
    }

    @Override
    public Set<String> getResourceNamesAsSet() {
        return this.myCtx.getResourceTypes();
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent theBinding, boolean theCacheOk, boolean theHierarchical) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code(285));
    }

    public static ConceptValidationOptions convertConceptValidationOptions(ValidationOptions theOptions) {
        ConceptValidationOptions retVal = new ConceptValidationOptions();
        if (theOptions.isGuessSystem()) {
            retVal = retVal.setInferSystem(true);
        }
        return retVal;
    }
}

