/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ValidationOptions {
    private static ValidationOptions ourEmpty;
    private Set<String> myProfiles;

    public Set<String> getProfiles() {
        return this.myProfiles != null ? Collections.unmodifiableSet(this.myProfiles) : Collections.emptySet();
    }

    public ValidationOptions addProfile(String theProfileUri) {
        Validate.notBlank(theProfileUri);
        if (this.myProfiles == null) {
            this.myProfiles = new HashSet<String>();
        }
        this.myProfiles.add(theProfileUri);
        return this;
    }

    public ValidationOptions addProfileIfNotBlank(String theProfileUri) {
        if (StringUtils.isNotBlank(theProfileUri)) {
            return this.addProfile(theProfileUri);
        }
        return this;
    }

    public static ValidationOptions empty() {
        ValidationOptions retVal = ourEmpty;
        if (retVal == null) {
            retVal = new ValidationOptions();
            retVal.myProfiles = Collections.emptySet();
            ourEmpty = retVal;
        }
        return retVal;
    }
}

