/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.api;

import au.csiro.pathling.api.EncodeMapPartitionsFunc;
import au.csiro.pathling.encoders.FhirEncoders;
import au.csiro.pathling.support.FhirConversionSupport;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class PathlingContext {
    @Nonnull
    private final SparkSession sparkSession;
    @Nonnull
    private final FhirVersionEnum fhirVersion;
    @Nonnull
    private final FhirEncoders fhirEncoders;

    private PathlingContext(@Nonnull SparkSession sparkSession, @Nonnull FhirEncoders fhirEncoders) {
        this.sparkSession = sparkSession;
        this.fhirVersion = fhirEncoders.getFhirVersion();
        this.fhirEncoders = fhirEncoders;
    }

    public static PathlingContext create(@Nonnull SparkSession sparkSession, @Nonnull FhirEncoders fhirEncoders) {
        return new PathlingContext(sparkSession, fhirEncoders);
    }

    public static PathlingContext create(@Nonnull SparkSession sparkSession) {
        return new PathlingContext(sparkSession, FhirEncoders.forR4().getOrCreate());
    }

    public static PathlingContext create(@Nonnull SparkSession sparkSession, @Nullable String versionString, @Nullable Integer maxNestingLevel, @Nullable Boolean enableExtensions, @Nullable List<String> enabledOpenTypes) {
        FhirEncoders.Builder encoderBuilder;
        FhirEncoders.Builder builder = encoderBuilder = Objects.nonNull(versionString) ? FhirEncoders.forVersion(FhirVersionEnum.forVersionString(versionString)) : FhirEncoders.forR4();
        if (Objects.nonNull(maxNestingLevel)) {
            encoderBuilder = encoderBuilder.withMaxNestingLevel(maxNestingLevel);
        }
        if (Objects.nonNull(enableExtensions)) {
            encoderBuilder = encoderBuilder.withExtensionsEnabled(enableExtensions);
        }
        if (Objects.nonNull(enabledOpenTypes)) {
            encoderBuilder = encoderBuilder.withOpenTypes(enabledOpenTypes.stream().collect(Collectors.toUnmodifiableSet()));
        }
        return PathlingContext.create(sparkSession, encoderBuilder.getOrCreate());
    }

    @Nonnull
    public <T extends IBaseResource> Dataset<T> encode(@Nonnull Dataset<String> stringResources, @Nonnull Class<T> resourceClass, @Nonnull String inputMimeType) {
        return stringResources.mapPartitions(new EncodeResourceMapPartitionsFunc<T>(this.fhirVersion, inputMimeType, resourceClass), this.fhirEncoders.of(resourceClass));
    }

    @Nonnull
    public Dataset<Row> encode(@Nonnull Dataset<Row> stringResourcesDF, @Nonnull String resourceName, @Nonnull String inputMimeType, @Nullable String maybeColumnName) {
        Dataset stringResources = (Objects.nonNull(maybeColumnName) ? stringResourcesDF.select(maybeColumnName, new String[0]) : stringResourcesDF).as(Encoders.STRING());
        RuntimeResourceDefinition definition = FhirEncoders.contextFor(this.fhirVersion).getResourceDefinition(resourceName);
        return this.encode((Dataset<String>)stringResources, definition.getImplementingClass(), inputMimeType).toDF();
    }

    @Nonnull
    public Dataset<Row> encode(@Nonnull Dataset<Row> stringResourcesDF, @Nonnull String resourceName, @Nonnull String inputMimeType) {
        return this.encode(stringResourcesDF, resourceName, inputMimeType, null);
    }

    @Nonnull
    public Dataset<Row> encode(@Nonnull Dataset<Row> stringResourcesDF, @Nonnull String resourceName) {
        return this.encode(stringResourcesDF, resourceName, "application/fhir+json");
    }

    @Nonnull
    public <T extends IBaseResource> Dataset<T> encodeBundle(@Nonnull Dataset<String> stringBundles, @Nonnull Class<T> resourceClass, @Nonnull String inputMimeType) {
        return stringBundles.mapPartitions(new EncodeBundleMapPartitionsFunc<T>(this.fhirVersion, inputMimeType, resourceClass), this.fhirEncoders.of(resourceClass));
    }

    @Nonnull
    public Dataset<Row> encodeBundle(@Nonnull Dataset<Row> stringBundlesDF, @Nonnull String resourceName, @Nonnull String inputMimeType, @Nullable String maybeColumnName) {
        Dataset stringResources = (Objects.nonNull(maybeColumnName) ? stringBundlesDF.select(maybeColumnName, new String[0]) : stringBundlesDF).as(Encoders.STRING());
        RuntimeResourceDefinition definition = FhirEncoders.contextFor(this.fhirVersion).getResourceDefinition(resourceName);
        return this.encodeBundle((Dataset<String>)stringResources, definition.getImplementingClass(), inputMimeType).toDF();
    }

    @Nonnull
    public Dataset<Row> encodeBundle(@Nonnull Dataset<Row> stringBundlesDF, @Nonnull String resourceName, @Nonnull String inputMimeType) {
        return this.encodeBundle(stringBundlesDF, resourceName, inputMimeType, null);
    }

    @Nonnull
    public Dataset<Row> encodeBundle(@Nonnull Dataset<Row> stringBundlesDF, @Nonnull String resourceName) {
        return this.encodeBundle(stringBundlesDF, resourceName, "application/fhir+json");
    }

    static class EncodeBundleMapPartitionsFunc<T extends IBaseResource>
    extends EncodeMapPartitionsFunc<T> {
        private static final long serialVersionUID = -4264073360143318480L;

        EncodeBundleMapPartitionsFunc(FhirVersionEnum fhirVersion, String inputMimeType, Class<T> resourceClass) {
            super(fhirVersion, inputMimeType, resourceClass);
        }

        @Override
        @Nonnull
        protected Stream<IBaseResource> processResources(@Nonnull Stream<IBaseResource> resources) {
            FhirConversionSupport conversionSupport = FhirConversionSupport.supportFor(this.fhirVersion);
            return resources.flatMap(maybeBundle -> conversionSupport.extractEntryFromBundle((IBaseBundle)maybeBundle, this.resourceClass).stream());
        }
    }

    static class EncodeResourceMapPartitionsFunc<T extends IBaseResource>
    extends EncodeMapPartitionsFunc<T> {
        private static final long serialVersionUID = 6405663463302424287L;

        EncodeResourceMapPartitionsFunc(FhirVersionEnum fhirVersion, String inputMimeType, Class<T> resourceClass) {
            super(fhirVersion, inputMimeType, resourceClass);
        }

        @Override
        @Nonnull
        protected Stream<IBaseResource> processResources(@Nonnull Stream<IBaseResource> resources) {
            return resources.filter(this.resourceClass::isInstance);
        }
    }
}

