# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_utils.ipynb.

# %% auto 0
__all__ = ['make_tree', 'strip_ns']

# %% ../nbs/02_utils.ipynb 1
import xml.etree.ElementTree as ET
from io import StringIO

# %% ../nbs/02_utils.ipynb 3
def make_tree(response):
    """Make an `ElementTree` from the text of an XML `response`"""
    tree = ET.iterparse(StringIO(response.text))
    return tree

def strip_ns(tree): 
    """strip all the namespaces from `tree`"""
    for _, el in tree:
        _, _, el.tag = el.tag.rpartition('}') # strip ns#
    return tree
