"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transliterator = void 0;
const aws_lambda_event_sources_1 = require("@aws-cdk/aws-lambda-event-sources");
const aws_logs_1 = require("@aws-cdk/aws-logs");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const transliterator_1 = require("./transliterator");
class Transliterator extends core_1.Construct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const lambda = new transliterator_1.Transliterator(this, 'Default', {
            deadLetterQueueEnabled: true,
            description: 'Creates transliterated assemblies from jsii-enabled npm packages',
            logRetention: (_a = props.logRetention) !== null && _a !== void 0 ? _a : aws_logs_1.RetentionDays.TEN_YEARS,
            memorySize: 10240,
            retryAttempts: 2,
            timeout: core_1.Duration.minutes(15),
        });
        // The handler reads & writes to this bucket.
        props.bucket.grantReadWrite(lambda);
        // Creating the event chaining
        lambda.addEventSource(new aws_lambda_event_sources_1.S3EventSource(props.bucket, {
            events: [aws_s3_1.EventType.OBJECT_CREATED],
            filters: [{ prefix: 'packages/', suffix: '/package.tgz' }],
        }));
    }
}
exports.Transliterator = Transliterator;
//# sourceMappingURL=data:application/json;base64,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