import { RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { Queue } from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
export interface DiscoveryFunctionProps {
    /**
     * The queue to post package updated messages to
     */
    readonly queue: Queue;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
}
export declare class Discovery extends Construct {
    readonly bucket: IBucket;
    constructor(scope: Construct, id: string, props: DiscoveryFunctionProps);
}
