#!/usr/bin/env python3
"""
File:           setup.py
Description:    This file contains the setup required for distributing the
                package on PyPi.org.
License:        This file is licensed under the GNU LGPL V3 license by
                Okke van Eck (2020 - 2023). See the LICENSE file for the
                specifics.
"""

import os
from setuptools import setup
from pybind11.setup_helpers import Pybind11Extension, build_ext

__version__ = "0.2a20"

# Define core module extension.
ext_modules = [
    Pybind11Extension(
        "prospr_core",
        ["prospr/core/core_module.cpp"],
        define_macros=[("VERSION_INFO", __version__)],
        optional=os.environ.get("CIBUILDWHEEL", "0") != "1",
        language="c++",
    ),
]

setup(
    ext_modules=ext_modules,
    cmdclass={"build_ext": build_ext},
)
