"""added line templates

Peek Plugin Database Migration Script

Revision ID: ec97d31aebb0
Revises: a73574690197
Create Date: 2019-09-14 20:00:19.116158

"""

# revision identifiers, used by Alembic.
revision = "ec97d31aebb0"
down_revision = "a73574690197"
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "DispEdgeTemplate",
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("lineWidth", sa.Integer(), server_default="2", nullable=False),
        sa.Column("lineColorId", sa.Integer(), nullable=True),
        sa.Column("lineStyleId", sa.Integer(), nullable=True),
        sa.Column("startEndType", sa.Integer(), nullable=True),
        sa.Column("endEndType", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["id"], ["pl_diagram.DispBase.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(
            ["lineColorId"],
            ["pl_diagram.DispColor.id"],
        ),
        sa.ForeignKeyConstraint(
            ["lineStyleId"],
            ["pl_diagram.DispLineStyle.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("DispEdgeTemplate", schema="pl_diagram")
    # ### end Alembic commands ###
