"""Initial

Peek Plugin Database Migration Script

Revision ID: 7eed363f5df5
Revises: 
Create Date: 2017-07-13 23:07:17.930374

"""

# revision identifiers, used by Alembic.
from sqlalchemy import func
from sqlalchemy.dialects.mssql.base import MSDialect
from sqlalchemy.dialects.postgresql.base import PGDialect

revision = "7eed363f5df5"
down_revision = None
branch_labels = None
depends_on = None

from sqlalchemy.schema import Sequence, CreateSequence, DropSequence

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def isMssqlDialect():
    return isinstance(op.get_bind().engine.dialect, MSDialect)


def isPostGreSQLDialect():
    return isinstance(op.get_bind().engine.dialect, PGDialect)


def nextval(seqName):
    if isMssqlDialect():
        return sa.text('(NEXT VALUE FOR "pl_diagram"."%s")' % seqName)

    return sa.text("nextval('pl_diagram.\"%s\"')" % seqName)


def upgrade():
    op.execute(
        CreateSequence(Sequence("DispBase_id_seq", minvalue=0, schema="pl_diagram"))
    )
    op.execute(
        CreateSequence(
            Sequence("LiveDbDispLink_id_seq", minvalue=0, schema="pl_diagram")
        )
    )

    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "DispCompilerQueue",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("dispId", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id", "dispId"),
        schema="pl_diagram",
    )
    op.create_table(
        "ModelSet",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.Column("comment", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_ModelSet_name", "ModelSet", ["name"], unique=True, schema="pl_diagram"
    )
    op.create_table(
        "Setting",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_table(
        "DispColor",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.Column(
            "color", sa.String(length=20), server_default="orange", nullable=True
        ),
        sa.Column("altColor", sa.String(length=20), nullable=True),
        sa.Column("swapPeriod", sa.Float(), nullable=True),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("importHash", sa.String(length=100), nullable=True),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["pl_diagram.ModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispColor_importHash",
        "DispColor",
        ["importHash"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispColor_modelSetId",
        "DispColor",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "DispLayer",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.Column("order", sa.Integer(), server_default="0", nullable=False),
        sa.Column("selectable", sa.Boolean(), server_default="false", nullable=False),
        sa.Column("visible", sa.Boolean(), server_default="true", nullable=False),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("importHash", sa.String(length=100), nullable=True),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["pl_diagram.ModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispLayer_modelSetId",
        "DispLayer",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "DispLineStyle",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.Column(
            "backgroundFillDashSpace",
            sa.Boolean(),
            server_default="false",
            nullable=False,
        ),
        sa.Column("capStyle", sa.String(length=15), nullable=False),
        sa.Column("joinStyle", sa.String(length=15), nullable=False),
        sa.Column("dashPattern", sa.String(length=50), nullable=True),
        sa.Column("startArrowSize", sa.Integer(), nullable=True),
        sa.Column("endArrowSize", sa.Integer(), nullable=True),
        sa.Column("winStyle", sa.Integer(), nullable=False),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("importHash", sa.String(length=100), nullable=True),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["pl_diagram.ModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispLineStyle_importHash",
        "DispLineStyle",
        ["importHash"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispLineStyle_modelSetId",
        "DispLineStyle",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "DispTextStyle",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.Column(
            "fontName", sa.String(length=30), server_default="GillSans", nullable=False
        ),
        sa.Column("fontSize", sa.Integer(), server_default="9", nullable=False),
        sa.Column("fontStyle", sa.String(length=30), nullable=True),
        sa.Column("scalable", sa.Boolean(), server_default="true", nullable=False),
        sa.Column("scaleFactor", sa.Integer(), server_default="1", nullable=False),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("importHash", sa.String(length=100), nullable=True),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["pl_diagram.ModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispTextStyle_importHash",
        "DispTextStyle",
        ["importHash"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispTextStyle_modelSetId",
        "DispTextStyle",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "ModelConnType",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.Column("comment", sa.String(), nullable=True),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["pl_diagram.ModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idxConnTypeModelSetId",
        "ModelConnType",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "ModelCoordSet",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.Column("initialPanX", sa.Float(), server_default="0", nullable=False),
        sa.Column("initialPanY", sa.Float(), server_default="0", nullable=False),
        sa.Column("initialZoom", sa.Float(), server_default="0", nullable=False),
        sa.Column("enabled", sa.Boolean(), server_default="false", nullable=False),
        sa.Column("comment", sa.String(), nullable=True),
        sa.Column("importId1", sa.Integer(), nullable=True),
        sa.Column("importId2", sa.String(length=100), nullable=True),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["pl_diagram.ModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idxCoordModelSetId",
        "ModelCoordSet",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idxCoordSetImportId1",
        "ModelCoordSet",
        ["importId1"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idxCoordSetImportId2",
        "ModelCoordSet",
        ["importId2"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idxCoordSetModelName",
        "ModelCoordSet",
        ["modelSetId", "name"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_table(
        "ModelNodeType",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.Column("comment", sa.String(), nullable=True),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["pl_diagram.ModelSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idxNodeTypeModelSetId",
        "ModelNodeType",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "SettingProperty",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("settingId", sa.Integer(), nullable=False),
        sa.Column("key", sa.String(length=50), nullable=False),
        sa.Column("type", sa.String(length=16), nullable=True),
        sa.Column("int_value", sa.Integer(), nullable=True),
        sa.Column("char_value", sa.String(length=7500), nullable=True),
        sa.Column("boolean_value", sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(
            ["settingId"],
            ["pl_diagram.Setting.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_SettingProperty_settingId",
        "SettingProperty",
        ["settingId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "DispLevel",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.Column("order", sa.Integer(), server_default="0", nullable=False),
        sa.Column("minZoom", sa.Float(), nullable=True),
        sa.Column("maxZoom", sa.Float(), nullable=True),
        sa.Column("coordSetId", sa.Integer(), nullable=False),
        sa.Column("importHash", sa.String(length=100), nullable=True),
        sa.ForeignKeyConstraint(
            ["coordSetId"], ["pl_diagram.ModelCoordSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispLevel_coordSetId",
        "DispLevel",
        ["coordSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "GridKeyCompilerQueue",
        sa.Column("id", sa.Integer(), nullable=False, autoincrement=True),
        sa.Column("gridKey", sa.String(length=30), nullable=False),
        sa.Column("coordSetId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["coordSetId"], ["pl_diagram.ModelCoordSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id", "gridKey", "coordSetId"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_GKCompQueue_coordSetId_gridKey",
        "GridKeyCompilerQueue",
        ["coordSetId", "gridKey"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "GridKeyIndexCompiled",
        sa.Column("id", sa.Integer(), nullable=False, autoincrement=True),
        sa.Column("gridKey", sa.String(length=30), nullable=False),
        sa.Column("blobData", sa.LargeBinary(), nullable=False),
        sa.Column("lastUpdate", sa.String(length=50), nullable=False),
        sa.Column("coordSetId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["coordSetId"], ["pl_diagram.ModelCoordSet.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_GKIndexUpdate_coordSetId",
        "GridKeyIndexCompiled",
        ["coordSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_GKIndexUpdate_gridKey",
        "GridKeyIndexCompiled",
        ["gridKey"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_table(
        "ModelNode",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("propsJson", sa.String(length=500), nullable=True),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("importId1", sa.Integer(), nullable=True),
        sa.Column("importId2", sa.String(length=100), nullable=True),
        sa.Column("typeId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["pl_diagram.ModelSet.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(["typeId"], ["pl_diagram.ModelNodeType.id"]),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idxNodeImportId1",
        "ModelNode",
        ["importId1"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idxNodeImportId2",
        "ModelNode",
        ["importId2"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idxNodeModelSetId",
        "ModelNode",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idxNodeTypeId", "ModelNode", ["typeId"], unique=False, schema="pl_diagram"
    )
    op.create_table(
        "DispBase",
        sa.Column(
            "id",
            sa.Integer(),
            server_default=nextval("DispBase_id_seq"),
            nullable=False,
        ),
        sa.Column("type", sa.Integer(), nullable=False),
        sa.Column("coordSetId", sa.Integer(), nullable=False),
        sa.Column("layerId", sa.Integer(), nullable=True),
        sa.Column("levelId", sa.Integer(), nullable=True),
        sa.Column("dispJson", sa.String(length=200000), nullable=True),
        sa.Column("importUpdateDate", sa.DateTime(), nullable=True),
        sa.Column("importHash", sa.String(length=100), nullable=True),
        sa.Column("importGroupHash", sa.String(length=100), nullable=True),
        sa.ForeignKeyConstraint(
            ["coordSetId"], ["pl_diagram.ModelCoordSet.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(["layerId"], ["pl_diagram.DispLayer.id"]),
        sa.ForeignKeyConstraint(["levelId"], ["pl_diagram.DispLevel.id"]),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_Disp_coordSetId_",
        "DispBase",
        ["coordSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_Disp_importGroupHash",
        "DispBase",
        ["importGroupHash"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_Disp_importUpdateDate",
        "DispBase",
        ["importUpdateDate"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_Disp_layerId", "DispBase", ["layerId"], unique=False, schema="pl_diagram"
    )
    op.create_index(
        "idx_Disp_levelId", "DispBase", ["levelId"], unique=False, schema="pl_diagram"
    )
    op.create_table(
        "ModelConn",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("propsJson", sa.String(length=500), nullable=True),
        sa.Column("modelSetId", sa.Integer(), nullable=False),
        sa.Column("importId1", sa.Integer(), nullable=True),
        sa.Column("importId2", sa.String(length=100), nullable=True),
        sa.Column("typeId", sa.Integer(), nullable=False),
        sa.Column("srcId", sa.Integer(), nullable=False),
        sa.Column("dstId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["dstId"], ["pl_diagram.ModelNode.id"]),
        sa.ForeignKeyConstraint(
            ["modelSetId"], ["pl_diagram.ModelSet.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(["srcId"], ["pl_diagram.ModelNode.id"]),
        sa.ForeignKeyConstraint(["typeId"], ["pl_diagram.ModelConnType.id"]),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idxConnImportId1",
        "ModelConn",
        ["importId1"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idxConnImportId2",
        "ModelConn",
        ["importId2"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idxConnModelDstId", "ModelConn", ["dstId"], unique=False, schema="pl_diagram"
    )
    op.create_index(
        "idxConnModelSetId",
        "ModelConn",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idxConnModelSrcId", "ModelConn", ["srcId"], unique=False, schema="pl_diagram"
    )
    op.create_index(
        "idxConnModelTypeId", "ModelConn", ["typeId"], unique=False, schema="pl_diagram"
    )
    op.create_index(
        "idxConnSrcDst",
        "ModelConn",
        ["srcId", "dstId"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_table(
        "DispEllipse",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("xRadius", sa.Float(), server_default="10.0", nullable=False),
        sa.Column("yRadius", sa.Float(), server_default="10.0", nullable=False),
        sa.Column("rotation", sa.Float(), server_default="0", nullable=False),
        sa.Column("startAngle", sa.Float(), server_default="0", nullable=False),
        sa.Column("endAngle", sa.Float(), server_default="360", nullable=False),
        sa.Column("lineWidth", sa.Integer(), server_default="2", nullable=False),
        sa.Column("geomJson", sa.String(length=2000), nullable=False),
        sa.Column("fillColorId", sa.Integer(), nullable=True),
        sa.Column("lineColorId", sa.Integer(), nullable=True),
        sa.Column("lineStyleId", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["fillColorId"], ["pl_diagram.DispColor.id"]),
        sa.ForeignKeyConstraint(["id"], ["pl_diagram.DispBase.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["lineColorId"], ["pl_diagram.DispColor.id"]),
        sa.ForeignKeyConstraint(["lineStyleId"], ["pl_diagram.DispLineStyle.id"]),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispEllipse_fillColorId",
        "DispEllipse",
        ["fillColorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispEllipse_lineColorId",
        "DispEllipse",
        ["lineColorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispEllipse_lineStyleId",
        "DispEllipse",
        ["lineStyleId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "DispGroup",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.ForeignKeyConstraint(["id"], ["pl_diagram.DispBase.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
        schema="pl_diagram",
    )
    op.create_table(
        "DispPolygon",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("cornerRadius", sa.Float(), server_default="0", nullable=False),
        sa.Column("lineWidth", sa.Integer(), server_default="2", nullable=False),
        sa.Column("geomJson", sa.String(length=200000), nullable=False),
        sa.Column("fillColorId", sa.Integer(), nullable=True),
        sa.Column("fillDirection", sa.Integer(), nullable=True),
        sa.Column("fillPercent", sa.Float(), nullable=True),
        sa.Column("lineColorId", sa.Integer(), nullable=True),
        sa.Column("lineStyleId", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["fillColorId"], ["pl_diagram.DispColor.id"]),
        sa.ForeignKeyConstraint(["id"], ["pl_diagram.DispBase.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["lineColorId"], ["pl_diagram.DispColor.id"]),
        sa.ForeignKeyConstraint(["lineStyleId"], ["pl_diagram.DispLineStyle.id"]),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispPolygon_fillColorId",
        "DispPolygon",
        ["fillColorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispPolygon_lineColorId",
        "DispPolygon",
        ["lineColorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispPolygon_lineStyleId",
        "DispPolygon",
        ["lineStyleId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "DispPolyline",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("lineWidth", sa.Integer(), server_default="2", nullable=False),
        sa.Column("geomJson", sa.String(length=200000), nullable=False),
        sa.Column("lineColorId", sa.Integer(), nullable=True),
        sa.Column("lineStyleId", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["id"], ["pl_diagram.DispBase.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["lineColorId"], ["pl_diagram.DispColor.id"]),
        sa.ForeignKeyConstraint(["lineStyleId"], ["pl_diagram.DispLineStyle.id"]),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispPolyline_lineColorId",
        "DispPolyline",
        ["lineColorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispPolyline_lineStyleId",
        "DispPolyline",
        ["lineStyleId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "DispText",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("verticalAlign", sa.Integer(), server_default="-1", nullable=False),
        sa.Column("horizontalAlign", sa.Integer(), server_default="0", nullable=False),
        sa.Column("rotation", sa.Float(), server_default="0", nullable=False),
        sa.Column(
            "text",
            sa.String(length=1000),
            server_default="new text label",
            nullable=False,
        ),
        sa.Column("textFormat", sa.String(length=1000), nullable=True),
        sa.Column("geomJson", sa.String(length=2000), nullable=False),
        sa.Column("colorId", sa.Integer(), nullable=True),
        sa.Column("textStyleId", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["colorId"], ["pl_diagram.DispColor.id"]),
        sa.ForeignKeyConstraint(["id"], ["pl_diagram.DispBase.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["textStyleId"], ["pl_diagram.DispTextStyle.id"]),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispText_colorId",
        "DispText",
        ["colorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispText_styleId",
        "DispText",
        ["textStyleId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "GridKeyIndex",
        sa.Column("gridKey", sa.String(length=30), nullable=False),
        sa.Column("dispId", sa.Integer(), nullable=False),
        sa.Column("coordSetId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["coordSetId"], ["pl_diagram.ModelCoordSet.id"]),
        sa.ForeignKeyConstraint(
            ["dispId"], ["pl_diagram.DispBase.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("gridKey", "dispId"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_GridKeyIndex_coordSetId",
        "GridKeyIndex",
        ["coordSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_GridKeyIndex_dispId",
        "GridKeyIndex",
        ["dispId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_GridKeyIndex_gridKey",
        "GridKeyIndex",
        ["gridKey"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "LiveDbDispLink",
        sa.Column(
            "id",
            sa.Integer(),
            server_default=nextval("LiveDbDispLink_id_seq"),
            nullable=False,
        ),
        sa.Column("coordSetId", sa.Integer(), nullable=False),
        sa.Column("dispId", sa.Integer(), nullable=False),
        sa.Column("dispAttrName", sa.String(length=20), nullable=False),
        sa.Column("liveDbKey", sa.String(length=30), nullable=False),
        sa.Column("importKeyHash", sa.String(length=100), nullable=True),
        sa.Column("importGroupHash", sa.String(length=100), nullable=True),
        sa.Column("importDispHash", sa.String(length=100), nullable=True),
        sa.Column("propsJson", sa.String(length=500), nullable=True),
        sa.ForeignKeyConstraint(["coordSetId"], ["pl_diagram.ModelCoordSet.id"]),
        sa.ForeignKeyConstraint(
            ["dispId"], ["pl_diagram.DispBase.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_LiveDbDLink_DispKeyHash",
        "LiveDbDispLink",
        ["importKeyHash", "importDispHash", "dispAttrName"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_LiveDbDLink_coordSetId",
        "LiveDbDispLink",
        ["coordSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_LiveDbDLink_dispId",
        "LiveDbDispLink",
        ["dispId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_LiveDbDLink_dispId_attr",
        "LiveDbDispLink",
        ["dispId", "dispAttrName"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_LiveDbDLink_importGroupHash",
        "LiveDbDispLink",
        ["importGroupHash"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_LiveDbDLink_liveDbUpdate",
        "LiveDbDispLink",
        ["dispId", "liveDbKey"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_LiveDbDLink_liveKeyId",
        "LiveDbDispLink",
        ["liveDbKey"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "DispAction",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("propsJson", sa.String(length=500), nullable=True),
        sa.ForeignKeyConstraint(
            ["id"], ["pl_diagram.DispPolygon.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_table(
        "DispGroupItem",
        sa.Column("groupId", sa.Integer(), nullable=False),
        sa.Column("itemId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["groupId"], ["pl_diagram.DispGroup.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(["itemId"], ["pl_diagram.DispBase.id"]),
        sa.PrimaryKeyConstraint("groupId", "itemId"),
        schema="pl_diagram",
    )
    op.create_table(
        "DispGroupPointer",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("rotation", sa.Integer(), server_default="0", nullable=False),
        sa.Column("verticalScale", sa.Float(), server_default="1.0", nullable=False),
        sa.Column("horizontalScale", sa.Float(), server_default="1.0", nullable=False),
        sa.Column("geomJson", sa.String(length=2000), nullable=False),
        sa.Column("groupId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["groupId"], ["pl_diagram.DispGroup.id"]),
        sa.ForeignKeyConstraint(["id"], ["pl_diagram.DispBase.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idxDispGroupPointer_groupId",
        "DispGroupPointer",
        ["groupId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "DispPolylineConn",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("connId", sa.Integer(), nullable=False),
        sa.Column("propsJson", sa.String(length=500), nullable=True),
        sa.ForeignKeyConstraint(["connId"], ["pl_diagram.ModelConn.id"]),
        sa.ForeignKeyConstraint(
            ["id"], ["pl_diagram.DispPolyline.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idxConnCoordConnId",
        "DispPolylineConn",
        ["connId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_table(
        "DispGroupPointerNode",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("nodeId", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["id"], ["pl_diagram.DispGroupPointer.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(["nodeId"], ["pl_diagram.ModelNode.id"]),
        sa.PrimaryKeyConstraint("id"),
        schema="pl_diagram",
    )
    op.create_index(
        "idxNodeCoordNodeId",
        "DispGroupPointerNode",
        ["nodeId"],
        unique=False,
        schema="pl_diagram",
    )
    # ### end Alembic commands ###


def downgrade():
    raise NotImplementedError()
