"""Added overlay flag

Peek Plugin Database Migration Script

Revision ID: 3b41dec74e46
Revises: 97990b4ca6a1
Create Date: 2019-08-12 11:04:53.878245

"""

# revision identifiers, used by Alembic.
revision = "3b41dec74e46"
down_revision = "97990b4ca6a1"
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    op.add_column(
        "DispBase",
        sa.Column("overlay", sa.Boolean(), server_default="false", nullable=True),
        schema="pl_diagram",
    )

    op.execute(
        """
        UPDATE pl_diagram."DispBase"
        SET overlay=sq.val
        FROM (
                SELECT id, "importGroupHash" is null or "importGroupHash" like '%.ov' as val
                FROM pl_diagram."DispBase"
        ) AS sq
        WHERE pl_diagram."DispBase".id=sq.id
    """
    )

    op.alter_column(
        "DispBase", "overlay", type_=sa.Boolean(), nullable=False, schema="pl_diagram"
    )

    op.execute(
        """
        INSERT INTO pl_diagram."DispCompilerQueue"("dispId")
        SELECT id FROM pl_diagram."DispBase"
    """
    )


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("DispBase", "overlay", schema="pl_diagram")
    # ### end Alembic commands ###
