/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.function;

import java.util.List;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.Function;
import org.xmlpull.v1.builder.xpath.jaxen.FunctionCallException;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;

public class BooleanFunction
implements Function {
    public Object call(Context context, List args2) throws FunctionCallException {
        if (args2.size() == 1) {
            return BooleanFunction.evaluate(args2.get(0), context.getNavigator());
        }
        throw new FunctionCallException("boolean() requires one argument");
    }

    public static Boolean evaluate(Object obj, Navigator nav) {
        if (obj instanceof List) {
            List list = (List)obj;
            if (list.size() == 0) {
                return Boolean.FALSE;
            }
            obj = list.get(0);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            double d = ((Number)obj).doubleValue();
            if (d == 0.0 || d == Double.NaN) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (obj instanceof String) {
            return ((String)obj).length() > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return obj != null ? Boolean.TRUE : Boolean.FALSE;
    }
}

