/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.test.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.fhir.ucum.UcumEssenceService;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.context.SimpleWorkerContext;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.utilities.CSFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TestingUtilities {
    private static final boolean SHOW_DIFF = true;
    public static IWorkerContext fcontext;
    public static boolean silent;
    public static String fixedpath;
    public static String contentpath;

    public static IWorkerContext context() {
        if (fcontext == null) {
            try {
                FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager(true, 3);
                fcontext = SimpleWorkerContext.fromPackage(pcm.loadPackage("hl7.fhir.core", "4.0.0"));
                fcontext.setUcumService(new UcumEssenceService(TestingUtilities.resourceNameToFile("ucum", "ucum-essence.xml")));
                fcontext.setExpansionProfile(new Parameters());
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        return fcontext;
    }

    public static String home() {
        if (fixedpath != null) {
            return fixedpath;
        }
        String s2 = System.getenv("FHIR_HOME");
        if (!Utilities.noString(s2)) {
            return s2;
        }
        s2 = "C:\\work\\org.hl7.fhir\\build";
        if (new File(s2).exists()) {
            return s2;
        }
        throw new Error("FHIR Home directory not configured");
    }

    public static String content() throws IOException {
        if (contentpath != null) {
            return contentpath;
        }
        String s2 = "R:\\fhir\\publish";
        if (new File(s2).exists()) {
            return s2;
        }
        return Utilities.path(TestingUtilities.home(), "publish");
    }

    public static String us() {
        if (fixedpath != null) {
            return fixedpath;
        }
        String s2 = System.getenv("FHIR_HOME");
        if (!Utilities.noString(s2)) {
            return s2;
        }
        s2 = "C:\\work\\org.hl7.fhir.us";
        if (new File(s2).exists()) {
            return s2;
        }
        throw new Error("FHIR US directory not configured");
    }

    public static String checkXMLIsSame(InputStream f1, InputStream f2) throws Exception {
        String result = TestingUtilities.compareXml(f1, f2);
        return result;
    }

    public static String checkXMLIsSame(String f1, String f2) throws Exception {
        String result = TestingUtilities.compareXml(f1, f2);
        if (result != null) {
            String diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe");
            ArrayList<String> command = new ArrayList<String>();
            command.add("\"" + diff + "\" \"" + f1 + "\" \"" + f2 + "\"");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(new CSFile("c:\\temp"));
            builder.start();
        }
        return result;
    }

    private static String compareXml(InputStream f1, InputStream f2) throws Exception {
        return TestingUtilities.compareElements("", TestingUtilities.loadXml(f1).getDocumentElement(), TestingUtilities.loadXml(f2).getDocumentElement());
    }

    private static String compareXml(String f1, String f2) throws Exception {
        return TestingUtilities.compareElements("", TestingUtilities.loadXml(f1).getDocumentElement(), TestingUtilities.loadXml(f2).getDocumentElement());
    }

    private static String compareElements(String path, Element e1, Element e2) {
        if (!e1.getNamespaceURI().equals(e2.getNamespaceURI())) {
            return "Namespaces differ at " + path + ": " + e1.getNamespaceURI() + "/" + e2.getNamespaceURI();
        }
        if (!e1.getLocalName().equals(e2.getLocalName())) {
            return "Names differ at " + path + ": " + e1.getLocalName() + "/" + e2.getLocalName();
        }
        String s2 = TestingUtilities.compareAttributes(path = path + "/" + e1.getLocalName(), e1.getAttributes(), e2.getAttributes());
        if (!Utilities.noString(s2)) {
            return s2;
        }
        s2 = TestingUtilities.compareAttributes(path, e2.getAttributes(), e1.getAttributes());
        if (!Utilities.noString(s2)) {
            return s2;
        }
        Node c1 = e1.getFirstChild();
        Node c2 = e2.getFirstChild();
        c1 = TestingUtilities.skipBlankText(c1);
        c2 = TestingUtilities.skipBlankText(c2);
        while (c1 != null && c2 != null) {
            if (c1.getNodeType() != c2.getNodeType()) {
                return "node type mismatch in children of " + path + ": " + Integer.toString(e1.getNodeType()) + "/" + Integer.toString(e2.getNodeType());
            }
            if (c1.getNodeType() == 3) {
                if (!TestingUtilities.normalise(c1.getTextContent()).equals(TestingUtilities.normalise(c2.getTextContent()))) {
                    return "Text differs at " + path + ": " + TestingUtilities.normalise(c1.getTextContent()) + "/" + TestingUtilities.normalise(c2.getTextContent());
                }
            } else if (c1.getNodeType() == 1 && !Utilities.noString(s2 = TestingUtilities.compareElements(path, (Element)c1, (Element)c2))) {
                return s2;
            }
            c1 = TestingUtilities.skipBlankText(c1.getNextSibling());
            c2 = TestingUtilities.skipBlankText(c2.getNextSibling());
        }
        if (c1 != null) {
            return "node mismatch - more nodes in source in children of " + path;
        }
        if (c2 != null) {
            return "node mismatch - more nodes in target in children of " + path;
        }
        return null;
    }

    private static Object normalise(String text) {
        String result = text.trim().replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        while (result.contains("  ")) {
            result = result.replace("  ", " ");
        }
        return result;
    }

    private static String compareAttributes(String path, NamedNodeMap src, NamedNodeMap tgt) {
        for (int i = 0; i < src.getLength(); ++i) {
            byte[] b2;
            byte[] b1;
            Node sa = src.item(i);
            String sn = sa.getNodeName();
            if (sn.equals("xmlns") || sn.startsWith("xmlns:")) continue;
            Node ta = tgt.getNamedItem(sn);
            if (ta == null) {
                return "Attributes differ at " + path + ": missing attribute " + sn;
            }
            if (TestingUtilities.normalise(sa.getTextContent()).equals(TestingUtilities.normalise(ta.getTextContent())) || TestingUtilities.sameBytes(b1 = TestingUtilities.unBase64(sa.getTextContent()), b2 = TestingUtilities.unBase64(ta.getTextContent()))) continue;
            return "Attributes differ at " + path + ": value " + TestingUtilities.normalise(sa.getTextContent()) + "/" + TestingUtilities.normalise(ta.getTextContent());
        }
        return null;
    }

    private static boolean sameBytes(byte[] b1, byte[] b2) {
        if (b1.length == 0 || b2.length == 0) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] unBase64(String text) {
        return Base64.decodeBase64(text);
    }

    private static Node skipBlankText(Node node) {
        while (node != null && (node.getNodeType() == 3 && Utilities.isWhitespace(node.getTextContent()) || node.getNodeType() == 8)) {
            node = node.getNextSibling();
        }
        return node;
    }

    private static Document loadXml(String fn) throws Exception {
        return TestingUtilities.loadXml(new FileInputStream(fn));
    }

    private static Document loadXml(InputStream fn) throws Exception {
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
        factory2.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory2.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory2.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory2.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory2.setXIncludeAware(false);
        factory2.setExpandEntityReferences(false);
        factory2.setNamespaceAware(true);
        DocumentBuilder builder = factory2.newDocumentBuilder();
        return builder.parse(fn);
    }

    public static String checkJsonSrcIsSame(String s1, String s2) throws JsonSyntaxException, FileNotFoundException, IOException {
        return TestingUtilities.checkJsonSrcIsSame(s1, s2, true);
    }

    public static String checkJsonSrcIsSame(String s1, String s2, boolean showDiff) throws JsonSyntaxException, FileNotFoundException, IOException {
        String result = TestingUtilities.compareJsonSrc(s1, s2);
        if (result != null && showDiff) {
            String diff = null;
            if (System.getProperty("os.name").contains("Linux")) {
                diff = Utilities.path("/", "usr", "bin", "meld");
            } else if (Utilities.checkFile("WinMerge", Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge"), "\\WinMergeU.exe", null)) {
                diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe");
            } else if (Utilities.checkFile("WinMerge", Utilities.path(System.getenv("ProgramFiles(X86)"), "Meld"), "\\Meld.exe", null)) {
                diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "Meld", "Meld.exe");
            }
            if (diff == null || diff.isEmpty()) {
                return result;
            }
            ArrayList<String> command = new ArrayList<String>();
            String f1 = Utilities.path("[tmp]", "input" + s1.hashCode() + ".json");
            String f2 = Utilities.path("[tmp]", "output" + s2.hashCode() + ".json");
            TextFile.stringToFile(s1, f1);
            TextFile.stringToFile(s2, f2);
            command.add(diff);
            if (diff.toLowerCase().contains("meld")) {
                command.add("--newtab");
            }
            command.add(f1);
            command.add(f2);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(new CSFile(Utilities.path("[tmp]")));
            builder.start();
        }
        return result;
    }

    public static String checkJsonIsSame(String f1, String f2) throws JsonSyntaxException, FileNotFoundException, IOException {
        String result = TestingUtilities.compareJson(f1, f2);
        if (result != null) {
            String diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe");
            ArrayList<String> command = new ArrayList<String>();
            command.add("\"" + diff + "\" \"" + f1 + "\" \"" + f2 + "\"");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(new CSFile("c:\\temp"));
            builder.start();
        }
        return result;
    }

    private static String compareJsonSrc(String f1, String f2) throws JsonSyntaxException, FileNotFoundException, IOException {
        JsonObject o1 = (JsonObject)new JsonParser().parse(f1);
        JsonObject o2 = (JsonObject)new JsonParser().parse(f2);
        return TestingUtilities.compareObjects("", o1, o2);
    }

    private static String compareJson(String f1, String f2) throws JsonSyntaxException, FileNotFoundException, IOException {
        JsonObject o1 = (JsonObject)new JsonParser().parse(TextFile.fileToString(f1));
        JsonObject o2 = (JsonObject)new JsonParser().parse(TextFile.fileToString(f2));
        return TestingUtilities.compareObjects("", o1, o2);
    }

    private static String compareObjects(String path, JsonObject o1, JsonObject o2) {
        String n;
        for (Map.Entry en : o1.entrySet()) {
            n = (String)en.getKey();
            if (n.equals("fhir_comments")) continue;
            if (o2.has(n)) {
                String s2 = TestingUtilities.compareNodes(path + '.' + n, (JsonElement)en.getValue(), o2.get(n));
                if (Utilities.noString(s2)) continue;
                return s2;
            }
            return "properties differ at " + path + ": missing property " + n;
        }
        for (Map.Entry en : o2.entrySet()) {
            n = (String)en.getKey();
            if (n.equals("fhir_comments") || o1.has(n)) continue;
            return "properties differ at " + path + ": missing property " + n;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String compareNodes(String path, JsonElement n1, JsonElement n2) {
        if (n1.getClass() != n2.getClass()) {
            return "properties differ at " + path + ": type " + n1.getClass().getName() + "/" + n2.getClass().getName();
        }
        if (n1 instanceof JsonPrimitive) {
            JsonPrimitive p1 = (JsonPrimitive)n1;
            JsonPrimitive p2 = (JsonPrimitive)n2;
            if (p1.isBoolean() && p2.isBoolean()) {
                if (p1.getAsBoolean() == p2.getAsBoolean()) return null;
                return "boolean property values differ at " + path + ": type " + p1.getAsString() + "/" + p2.getAsString();
            }
            if (p1.isString() && p2.isString()) {
                String s1 = p1.getAsString();
                String s2 = p2.getAsString();
                if (s1.contains("<div") && s2.contains("<div") || s1.equals(s2) || TestingUtilities.sameBytes(TestingUtilities.unBase64(s1), TestingUtilities.unBase64(s2))) return null;
                return "string property values differ at " + path + ": type " + s1 + "/" + s2;
            }
            if (!p1.isNumber() || !p2.isNumber()) return "property types differ at " + path + ": type " + p1.getAsString() + "/" + p2.getAsString();
            if (p1.getAsString().equals(p2.getAsString())) return null;
            return "number property values differ at " + path + ": type " + p1.getAsString() + "/" + p2.getAsString();
        }
        if (n1 instanceof JsonObject) {
            String s2 = TestingUtilities.compareObjects(path, (JsonObject)n1, (JsonObject)n2);
            if (Utilities.noString(s2)) return null;
            return s2;
        }
        if (n1 instanceof JsonArray) {
            JsonArray a1 = (JsonArray)n1;
            JsonArray a2 = (JsonArray)n2;
            if (a1.size() != a2.size()) {
                return "array properties differ at " + path + ": count " + Integer.toString(a1.size()) + "/" + Integer.toString(a2.size());
            }
            for (int i = 0; i < a1.size(); ++i) {
                String s3 = TestingUtilities.compareNodes(path + "[" + Integer.toString(i) + "]", a1.get(i), a2.get(i));
                if (Utilities.noString(s3)) continue;
                return s3;
            }
            return null;
        } else {
            if (n1 instanceof JsonNull) return null;
            return "unhandled property " + n1.getClass().getName();
        }
    }

    public static String temp() {
        if (new File("c:\\temp").exists()) {
            return "c:\\temp";
        }
        return System.getProperty("java.io.tmpdir");
    }

    public static String checkTextIsSame(String s1, String s2) throws JsonSyntaxException, FileNotFoundException, IOException {
        return TestingUtilities.checkTextIsSame(s1, s2, true);
    }

    public static String checkTextIsSame(String s1, String s2, boolean showDiff) throws JsonSyntaxException, FileNotFoundException, IOException {
        String result = TestingUtilities.compareText(s1, s2);
        if (result != null && showDiff) {
            String diff = null;
            if (System.getProperty("os.name").contains("Linux")) {
                diff = Utilities.path("/", "usr", "bin", "meld");
            } else if (Utilities.checkFile("WinMerge", Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge"), "\\WinMergeU.exe", null)) {
                diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "WinMerge", "WinMergeU.exe");
            } else if (Utilities.checkFile("WinMerge", Utilities.path(System.getenv("ProgramFiles(X86)"), "Meld"), "\\Meld.exe", null)) {
                diff = Utilities.path(System.getenv("ProgramFiles(X86)"), "Meld", "Meld.exe");
            }
            if (diff == null || diff.isEmpty()) {
                return result;
            }
            ArrayList<String> command = new ArrayList<String>();
            String f1 = Utilities.path("[tmp]", "input" + s1.hashCode() + ".json");
            String f2 = Utilities.path("[tmp]", "output" + s2.hashCode() + ".json");
            TextFile.stringToFile(s1, f1);
            TextFile.stringToFile(s2, f2);
            command.add(diff);
            if (diff.toLowerCase().contains("meld")) {
                command.add("--newtab");
            }
            command.add(f1);
            command.add(f2);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(new CSFile(Utilities.path("[tmp]")));
            builder.start();
        }
        return result;
    }

    private static String compareText(String s1, String s2) {
        for (int i = 0; i < Integer.min(s1.length(), s2.length()); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return "Strings differ at character " + Integer.toString(i) + ": '" + s1.charAt(i) + "' vs '" + s2.charAt(i) + "'";
        }
        if (s1.length() != s2.length()) {
            return "Strings differ in length: " + Integer.toString(s1.length()) + " vs " + Integer.toString(s2.length()) + " but match to the end of the shortest";
        }
        return null;
    }

    public static String resourceNameToFile(String name) throws IOException {
        return Utilities.path(System.getProperty("user.dir"), "src", "test", "resources", name);
    }

    public static String resourceNameToFile(String subFolder, String name) throws IOException {
        return Utilities.path(System.getProperty("user.dir"), "src", "test", "resources", subFolder, name);
    }
}

