/*
 * Decompiled with CFR 0.152.
 */
package org.fhir.ucum;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fhir.ucum.BaseUnit;
import org.fhir.ucum.DefinedUnit;
import org.fhir.ucum.Prefix;
import org.fhir.ucum.Unit;

public class UcumModel
implements Serializable {
    private static final long serialVersionUID = 2263441561255569053L;
    private String version;
    private String revision;
    private Date revisionDate;
    private List<Prefix> prefixes = new ArrayList<Prefix>();
    private List<BaseUnit> baseUnits = new ArrayList<BaseUnit>();
    private List<DefinedUnit> definedUnits = new ArrayList<DefinedUnit>();

    public UcumModel(String version, String revision, Date revisionDate) {
        this.version = version;
        this.revision = revision;
        this.revisionDate = revisionDate;
    }

    public List<Prefix> getPrefixes() {
        return this.prefixes;
    }

    public List<BaseUnit> getBaseUnits() {
        return this.baseUnits;
    }

    public List<DefinedUnit> getDefinedUnits() {
        return this.definedUnits;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public Date getRevisionDate() {
        return this.revisionDate;
    }

    public void setRevisionDate(Date revisionDate) {
        this.revisionDate = revisionDate;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Unit getUnit(String code) {
        for (Unit unit : this.getBaseUnits()) {
            if (!unit.getCode().equals(code)) continue;
            return unit;
        }
        for (Unit unit : this.getDefinedUnits()) {
            if (!unit.getCode().equals(code)) continue;
            return unit;
        }
        return null;
    }

    public BaseUnit getBaseUnit(String code) {
        for (BaseUnit unit : this.getBaseUnits()) {
            if (!unit.getCode().equals(code)) continue;
            return unit;
        }
        return null;
    }
}

