/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SummaryEnumParameter
implements IParameter {
    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        if (theSourceClientArgument instanceof Collection) {
            ArrayList<String> values2 = new ArrayList<String>();
            for (SummaryEnum next : (Collection)theSourceClientArgument) {
                if (next == null) continue;
                values2.add(next.getCode());
            }
            theTargetQueryArguments.put("_summary", values2);
        } else {
            SummaryEnum ss = (SummaryEnum)((Object)theSourceClientArgument);
            if (ss != null) {
                theTargetQueryArguments.put("_summary", Collections.singletonList(ss.getCode()));
            }
        }
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException(Msg.code(1422) + "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is of type " + SummaryEnum.class + " but can not be a collection of collections");
        }
    }
}

