/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.client.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import org.hl7.fhir.instance.model.api.IBaseConformance;

public class ConformanceMethodBinding
extends BaseResourceReturningMethodBinding {
    public ConformanceMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod.getReturnType(), theMethod, theContext, theProvider);
        BaseResourceReturningMethodBinding.MethodReturnTypeEnum methodReturnType = this.getMethodReturnType();
        Class genericReturnType = (Class)theMethod.getGenericReturnType();
        if (methodReturnType != BaseResourceReturningMethodBinding.MethodReturnTypeEnum.RESOURCE || !IBaseConformance.class.isAssignableFrom(genericReturnType)) {
            throw new ConfigurationException(Msg.code(1426) + "Conformance resource provider method '" + theMethod.getName() + "' should return a Conformance resource class, returns: " + theMethod.getReturnType());
        }
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
    }

    @Override
    public HttpGetClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        HttpGetClientInvocation retVal = MethodUtil.createConformanceInvocation(this.getContext());
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
            }
        }
        return retVal;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.METADATA;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return null;
    }
}

