/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.utilities;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class Strings {
    private static final Pattern ALIAS_PATTERN = Pattern.compile("_[a-z0-9]{1,6}");

    @Nonnull
    public static String parentheses(@Nonnull String value) {
        return "(" + value + ")";
    }

    @Nonnull
    public static String unSingleQuote(@Nonnull String value) {
        return value.replaceAll("^'|'$", "");
    }

    @Nonnull
    public static String randomAlias() {
        int randomNumber = Math.abs(new Random().nextInt());
        return "_" + Integer.toString(randomNumber, 36);
    }

    public static boolean looksLikeAlias(@Nonnull CharSequence input) {
        Matcher matcher = ALIAS_PATTERN.matcher(input);
        return matcher.matches();
    }

    @Nonnull
    public static <T> List<T> parseCsvList(@Nonnull String csvList, @Nonnull Function<String, T> converter) {
        return Stream.of(csvList.split(",")).map(String::trim).filter(Predicate.not(String::isEmpty)).map(converter).collect(Collectors.toList());
    }
}

