/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.fhir.TerminologyServiceFactory;
import au.csiro.pathling.fhirpath.encoding.CodingEncoding;
import au.csiro.pathling.fhirpath.encoding.SimpleCodingsDecoders;
import au.csiro.pathling.fhirpath.function.memberof.MemberOfMapper;
import au.csiro.pathling.fhirpath.function.subsumes.SubsumesMapper;
import au.csiro.pathling.fhirpath.function.translate.TranslateMapper;
import au.csiro.pathling.sql.SqlExtensions;
import au.csiro.pathling.utilities.Preconditions;
import au.csiro.pathling.utilities.Strings;
import javax.annotation.Nonnull;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.hl7.fhir.r4.model.Enumerations;

public interface TerminologyFunctions {
    @Nonnull
    public static Dataset<Row> memberOf(@Nonnull Column codingArrayCol, @Nonnull String valueSetUri, @Nonnull Dataset<Row> dataset, @Nonnull String outputColumnName, @Nonnull TerminologyServiceFactory terminologyServiceFactory, @Nonnull String requestId) {
        MemberOfMapper mapper = new MemberOfMapper(requestId, terminologyServiceFactory, valueSetUri);
        return SqlExtensions.mapWithPartitionPreview(dataset, codingArrayCol, SimpleCodingsDecoders::decodeList, mapper, StructField.apply((String)outputColumnName, (DataType)DataTypes.BooleanType, (boolean)true, (Metadata)Metadata.empty()));
    }

    @Nonnull
    public static Dataset<Row> translate(@Nonnull Column codingArrayCol, @Nonnull String conceptMapUrl, boolean reverse, @Nonnull String equivalence, @Nonnull Dataset<Row> dataset, @Nonnull String outputColumnName, @Nonnull TerminologyServiceFactory terminologyServiceFactory, @Nonnull String requestId) {
        TranslateMapper mapper = new TranslateMapper(requestId, terminologyServiceFactory, conceptMapUrl, reverse, Strings.parseCsvList(equivalence, Preconditions.wrapInUserInputError(Enumerations.ConceptMapEquivalence::fromCode)));
        return SqlExtensions.mapWithPartitionPreview(dataset, codingArrayCol, SimpleCodingsDecoders::decodeList, mapper, StructField.apply((String)outputColumnName, (DataType)DataTypes.createArrayType((DataType)CodingEncoding.DATA_TYPE), (boolean)true, (Metadata)Metadata.empty()));
    }

    @Nonnull
    public static Dataset<Row> subsumes(@Nonnull Dataset<Row> idAndCodingSet, @Nonnull Column codingPairCol, @Nonnull String outputColumnName, boolean inverted, @Nonnull TerminologyServiceFactory terminologyServiceFactory, @Nonnull String requestId) {
        SubsumesMapper mapper = new SubsumesMapper(requestId, terminologyServiceFactory, inverted);
        return SqlExtensions.mapWithPartitionPreview(idAndCodingSet, codingPairCol, SimpleCodingsDecoders::decodeListPair, mapper, StructField.apply((String)outputColumnName, (DataType)DataTypes.BooleanType, (boolean)true, (Metadata)Metadata.empty()));
    }
}

