/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.fhirpath.encoding.SimpleCoding;
import au.csiro.pathling.terminology.ClosureMapping;
import au.csiro.pathling.terminology.ConceptTranslator;
import au.csiro.pathling.terminology.Relation;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.TranslateMapping;
import au.csiro.pathling.terminology.UUIDFactory;
import au.csiro.pathling.terminology.ValueSetMapping;
import au.csiro.pathling.utilities.Preconditions;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.param.UriParam;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTerminologyService
implements TerminologyService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTerminologyService.class);
    @Nonnull
    private final FhirContext fhirContext;
    @Nonnull
    private final TerminologyClient terminologyClient;
    @Nonnull
    private final UUIDFactory uuidFactory;

    public DefaultTerminologyService(@Nonnull FhirContext fhirContext, @Nonnull TerminologyClient terminologyClient, @Nonnull UUIDFactory uuidFactory) {
        this.fhirContext = fhirContext;
        this.terminologyClient = terminologyClient;
        this.uuidFactory = uuidFactory;
    }

    private boolean isValidCoding(@Nullable SimpleCoding coding) {
        return Objects.nonNull(coding) && coding.isDefined();
    }

    private boolean isKnownSystem(@Nonnull String codeSystem) {
        UriParam uri = new UriParam(codeSystem);
        List<CodeSystem> knownSystems = this.terminologyClient.searchCodeSystems(uri, new HashSet<String>(Collections.singletonList("id")));
        return knownSystems != null && !knownSystems.isEmpty();
    }

    @Nonnull
    private Stream<SimpleCoding> validCodings(@Nonnull Collection<SimpleCoding> codings) {
        return codings.stream().filter(this::isValidCoding);
    }

    @Nonnull
    private Stream<SimpleCoding> validAndKnownCodings(@Nonnull Collection<SimpleCoding> codings) {
        Set allCodeSystems = this.validCodings(codings).map(SimpleCoding::getSystem).collect(Collectors.toSet());
        Set knownCodeSystems = allCodeSystems.stream().filter(this::isKnownSystem).collect(Collectors.toSet());
        if (!knownCodeSystems.equals(allCodeSystems)) {
            HashSet unrecognizedCodeSystems = new HashSet(allCodeSystems);
            unrecognizedCodeSystems.removeAll(knownCodeSystems);
            log.warn("Terminology server does not recognize these coding systems: {}", (Object)unrecognizedCodeSystems);
        }
        return this.validCodings(codings).filter(coding -> knownCodeSystems.contains(coding.getSystem()));
    }

    @Override
    @Nonnull
    public ConceptTranslator translate(@Nonnull Collection<SimpleCoding> codings, @Nonnull String conceptMapUrl, boolean reverse, @Nonnull Collection<Enumerations.ConceptMapEquivalence> equivalences) {
        List<SimpleCoding> uniqueCodings = this.validCodings(codings).distinct().collect(Collectors.toUnmodifiableList());
        Set<Enumerations.ConceptMapEquivalence> uniqueEquivalences = equivalences.stream().collect(Collectors.toUnmodifiableSet());
        if (!uniqueCodings.isEmpty() && !uniqueEquivalences.isEmpty()) {
            Bundle translateBatch = TranslateMapping.toRequestBundle(uniqueCodings, conceptMapUrl, reverse);
            Bundle result = this.terminologyClient.batch(translateBatch);
            return TranslateMapping.fromResponseBundle(Preconditions.checkNotNull(result), uniqueCodings, uniqueEquivalences, this.fhirContext);
        }
        return ConceptTranslator.empty();
    }

    @Override
    @Nonnull
    public Relation getSubsumesRelation(@Nonnull Collection<SimpleCoding> systemAndCodes) {
        List<Coding> codings = this.validAndKnownCodings(systemAndCodes).distinct().map(SimpleCoding::toCoding).collect(Collectors.toUnmodifiableList());
        if (!codings.isEmpty()) {
            String closureName = this.uuidFactory.nextUUID().toString();
            log.info("Sending $closure request to terminology service with name '{}' and {} codings", (Object)closureName, (Object)codings.size());
            this.terminologyClient.initialiseClosure(new StringType(closureName));
            ConceptMap closureResponse = this.terminologyClient.closure(new StringType(closureName), codings);
            Preconditions.checkNotNull(closureResponse);
            return ClosureMapping.relationFromConceptMap(closureResponse);
        }
        return Relation.equality();
    }

    @Override
    @Nonnull
    public Set<SimpleCoding> intersect(@Nonnull String valueSetUri, @Nonnull Collection<SimpleCoding> systemAndCodes) {
        Set<SimpleCoding> expandedCodings;
        Set<SimpleCoding> codings = this.validAndKnownCodings(systemAndCodes).collect(Collectors.toSet());
        ValueSet intersection = ValueSetMapping.toIntersection(valueSetUri, codings);
        if (intersection.getCompose().getInclude().isEmpty()) {
            expandedCodings = Collections.emptySet();
        } else {
            log.info("Intersecting {} concepts with {} using terminology service", (Object)codings.size(), (Object)valueSetUri);
            ValueSet expansion = this.terminologyClient.expand(intersection, new IntegerType(codings.size()));
            expandedCodings = ValueSetMapping.codingSetFromExpansion(expansion);
        }
        return expandedCodings;
    }
}

