/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.library;

import au.csiro.pathling.fhirpath.encoding.CodingEncoding;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions;

public class TerminologyHelpers {
    public static final String SNOMED_URI = "http://snomed.info/sct";

    @Nonnull
    public static Column toCoding(@Nonnull Column codingColumn, @Nullable String system, @Nullable String version) {
        return CodingEncoding.toStruct(functions.lit(null), functions.lit((Object)system), functions.lit((Object)version), codingColumn, functions.lit(null), functions.lit(null));
    }

    @Nonnull
    public static Column toCoding(@Nonnull Column codingColumn, @Nullable String system) {
        return TerminologyHelpers.toCoding(codingColumn, system, null);
    }

    @Nonnull
    public static String toEclValueSet(@Nonnull String ecl) {
        String encodedEcl = URLEncoder.encode(ecl, StandardCharsets.UTF_8).replace("+", "%20");
        return "http://snomed.info/sct?fhir_vs=ecl/" + encodedEcl;
    }
}

