/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.library;

import au.csiro.pathling.config.TerminologyAuthConfiguration;
import au.csiro.pathling.encoders.FhirEncoders;
import au.csiro.pathling.fhir.DefaultTerminologyServiceFactory;
import au.csiro.pathling.fhir.TerminologyServiceFactory;
import au.csiro.pathling.library.EncodeMapPartitionsFunc;
import au.csiro.pathling.library.PathlingContextConfiguration;
import au.csiro.pathling.sql.SqlStrategy;
import au.csiro.pathling.support.FhirConversionSupport;
import au.csiro.pathling.terminology.TerminologyFunctions;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.MDC;

public class PathlingContext {
    public static final String DEFAULT_TERMINOLOGY_SERVER_URL = "https://tx.ontoserver.csiro.au/fhir";
    public static final int DEFAULT_TERMINOLOGY_SOCKET_TIMEOUT = 60000;
    public static final long DEFAULT_TOKEN_EXPIRY_TOLERANCE = 120L;
    @Nonnull
    private final SparkSession spark;
    @Nonnull
    private final FhirVersionEnum fhirVersion;
    @Nonnull
    private final FhirEncoders fhirEncoders;
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;

    private PathlingContext(@Nonnull SparkSession spark, @Nonnull FhirEncoders fhirEncoders, @Nonnull TerminologyServiceFactory terminologyServiceFactory) {
        this.spark = spark;
        this.fhirVersion = fhirEncoders.getFhirVersion();
        this.fhirEncoders = fhirEncoders;
        this.terminologyServiceFactory = terminologyServiceFactory;
        SqlStrategy.setup(spark);
    }

    @Nonnull
    public static PathlingContext create() {
        return PathlingContext.create(PathlingContextConfiguration.builder().build());
    }

    @Nonnull
    public static PathlingContext create(@Nonnull SparkSession spark) {
        return PathlingContext.create(spark, PathlingContextConfiguration.builder().build());
    }

    @Nonnull
    public static PathlingContext create(@Nonnull PathlingContextConfiguration configuration) {
        SparkSession spark = SparkSession.builder().getOrCreate();
        return PathlingContext.create(spark, configuration);
    }

    @Nonnull
    public static PathlingContext create(@Nonnull SparkSession spark, @Nonnull FhirEncoders fhirEncoders, @Nonnull TerminologyServiceFactory terminologyServiceFactory) {
        return new PathlingContext(spark, fhirEncoders, terminologyServiceFactory);
    }

    @Nonnull
    public static PathlingContext create(@Nonnull SparkSession sparkSession, @Nullable PathlingContextConfiguration configuration) {
        PathlingContextConfiguration c = configuration == null ? PathlingContextConfiguration.builder().build() : configuration;
        FhirEncoders.Builder encoderBuilder = PathlingContext.getEncoderBuilder(c);
        DefaultTerminologyServiceFactory terminologyServiceFactory = PathlingContext.getTerminologyServiceFactory(c);
        return PathlingContext.create(sparkSession, encoderBuilder.getOrCreate(), terminologyServiceFactory);
    }

    @Nonnull
    public <T extends IBaseResource> Dataset<T> encode(@Nonnull Dataset<String> stringResources, @Nonnull Class<T> resourceClass, @Nonnull String inputMimeType) {
        return stringResources.mapPartitions(new EncodeResourceMapPartitionsFunc<T>(this.fhirVersion, inputMimeType, resourceClass), this.fhirEncoders.of(resourceClass));
    }

    @Nonnull
    public Dataset<Row> encode(@Nonnull Dataset<Row> stringResourcesDF, @Nonnull String resourceName, @Nonnull String inputMimeType, @Nullable String maybeColumnName) {
        Dataset stringResources = (Objects.nonNull(maybeColumnName) ? stringResourcesDF.select(maybeColumnName, new String[0]) : stringResourcesDF).as(Encoders.STRING());
        RuntimeResourceDefinition definition = FhirEncoders.contextFor(this.fhirVersion).getResourceDefinition(resourceName);
        return this.encode((Dataset<String>)stringResources, definition.getImplementingClass(), inputMimeType).toDF();
    }

    @Nonnull
    public Dataset<Row> encode(@Nonnull Dataset<Row> stringResourcesDF, @Nonnull String resourceName, @Nonnull String inputMimeType) {
        return this.encode(stringResourcesDF, resourceName, inputMimeType, null);
    }

    @Nonnull
    public Dataset<Row> encode(@Nonnull Dataset<Row> stringResourcesDF, @Nonnull String resourceName) {
        return this.encode(stringResourcesDF, resourceName, "application/fhir+json");
    }

    @Nonnull
    public <T extends IBaseResource> Dataset<T> encodeBundle(@Nonnull Dataset<String> stringBundles, @Nonnull Class<T> resourceClass, @Nonnull String inputMimeType) {
        return stringBundles.mapPartitions(new EncodeBundleMapPartitionsFunc<T>(this.fhirVersion, inputMimeType, resourceClass), this.fhirEncoders.of(resourceClass));
    }

    @Nonnull
    public Dataset<Row> encodeBundle(@Nonnull Dataset<Row> stringBundlesDF, @Nonnull String resourceName, @Nonnull String inputMimeType, @Nullable String maybeColumnName) {
        Dataset stringResources = (Objects.nonNull(maybeColumnName) ? stringBundlesDF.select(maybeColumnName, new String[0]) : stringBundlesDF).as(Encoders.STRING());
        RuntimeResourceDefinition definition = FhirEncoders.contextFor(this.fhirVersion).getResourceDefinition(resourceName);
        return this.encodeBundle((Dataset<String>)stringResources, definition.getImplementingClass(), inputMimeType).toDF();
    }

    @Nonnull
    public Dataset<Row> encodeBundle(@Nonnull Dataset<Row> stringBundlesDF, @Nonnull String resourceName, @Nonnull String inputMimeType) {
        return this.encodeBundle(stringBundlesDF, resourceName, inputMimeType, null);
    }

    @Nonnull
    public Dataset<Row> encodeBundle(@Nonnull Dataset<Row> stringBundlesDF, @Nonnull String resourceName) {
        return this.encodeBundle(stringBundlesDF, resourceName, "application/fhir+json");
    }

    @Nonnull
    public Dataset<Row> memberOf(@Nonnull Dataset<Row> dataset, @Nonnull Column coding, @Nonnull String valueSetUri, @Nonnull String outputColumnName) {
        Column codingArrayCol = functions.when((Column)coding.isNotNull(), (Object)functions.array((Column[])new Column[]{coding})).otherwise((Object)functions.lit(null));
        return TerminologyFunctions.memberOf(codingArrayCol, valueSetUri, dataset, outputColumnName, this.terminologyServiceFactory, PathlingContext.getRequestId());
    }

    @Nonnull
    public Dataset<Row> translate(@Nonnull Dataset<Row> dataset, @Nonnull Column coding, @Nonnull String conceptMapUri, boolean reverse, @Nonnull String equivalence, @Nonnull String outputColumnName) {
        Column codingArrayCol = functions.when((Column)coding.isNotNull(), (Object)functions.array((Column[])new Column[]{coding})).otherwise((Object)functions.lit(null));
        Dataset<Row> translatedDataset = TerminologyFunctions.translate(codingArrayCol, conceptMapUri, reverse, equivalence, dataset, outputColumnName, this.terminologyServiceFactory, PathlingContext.getRequestId());
        return translatedDataset.withColumn(outputColumnName, functions.col((String)outputColumnName).apply((Object)0));
    }

    @Nonnull
    public Dataset<Row> subsumes(@Nonnull Dataset<Row> dataset, @Nonnull Column leftCoding, @Nonnull Column rightCoding, @Nonnull String outputColumnName) {
        Column fromArray = functions.array((Column[])new Column[]{leftCoding});
        Column toArray = functions.array((Column[])new Column[]{rightCoding});
        Column fromCodings = functions.when((Column)leftCoding.isNotNull(), (Object)fromArray).otherwise(null);
        Column toCodings = functions.when((Column)rightCoding.isNotNull(), (Object)toArray).otherwise(null);
        Dataset idAndCodingSet = dataset.withColumn("inputCodings", fromCodings).withColumn("argCodings", toCodings);
        Column codingPairCol = functions.struct((Column[])new Column[]{idAndCodingSet.col("inputCodings"), idAndCodingSet.col("argCodings")});
        return TerminologyFunctions.subsumes((Dataset<Row>)idAndCodingSet, codingPairCol, outputColumnName, false, this.terminologyServiceFactory, PathlingContext.getRequestId());
    }

    @Nonnull
    private static FhirEncoders.Builder getEncoderBuilder(@Nonnull PathlingContextConfiguration c) {
        FhirEncoders.Builder encoderBuilder;
        FhirEncoders.Builder builder = encoderBuilder = Objects.nonNull(c.getFhirVersion()) ? FhirEncoders.forVersion(FhirVersionEnum.forVersionString(c.getFhirVersion())) : FhirEncoders.forR4();
        if (Objects.nonNull(c.getMaxNestingLevel())) {
            encoderBuilder = encoderBuilder.withMaxNestingLevel(c.getMaxNestingLevel());
        }
        if (Objects.nonNull(c.getExtensionsEnabled())) {
            encoderBuilder = encoderBuilder.withExtensionsEnabled(c.getExtensionsEnabled());
        }
        if (Objects.nonNull(c.getOpenTypesEnabled())) {
            Set<String> openTypes = c.getOpenTypesEnabled().stream().collect(Collectors.toUnmodifiableSet());
            encoderBuilder = encoderBuilder.withOpenTypes(openTypes);
        }
        return encoderBuilder;
    }

    @Nonnull
    private static DefaultTerminologyServiceFactory getTerminologyServiceFactory(@Nonnull PathlingContextConfiguration c) {
        String resolvedTerminologyServerUrl = Objects.nonNull(c.getTerminologyServerUrl()) ? c.getTerminologyServerUrl() : DEFAULT_TERMINOLOGY_SERVER_URL;
        TerminologyAuthConfiguration authConfig = new TerminologyAuthConfiguration();
        if (Objects.nonNull(c.getTokenEndpoint()) && Objects.nonNull(c.getClientId()) && Objects.nonNull(c.getClientSecret())) {
            authConfig.setEnabled(true);
            authConfig.setTokenEndpoint(c.getTokenEndpoint());
            authConfig.setClientId(c.getClientId());
            authConfig.setClientSecret(c.getClientSecret());
            authConfig.setScope(c.getScope());
        }
        authConfig.setTokenExpiryTolerance(c.getTokenExpiryTolerance() != null ? (long)c.getTokenExpiryTolerance().intValue() : 120L);
        return new DefaultTerminologyServiceFactory(FhirContext.forR4(), resolvedTerminologyServerUrl, 60000, false, authConfig);
    }

    private static String getRequestId() {
        String requestId = UUID.randomUUID().toString();
        MDC.put("requestId", requestId);
        return requestId;
    }

    @Nonnull
    public SparkSession getSpark() {
        return this.spark;
    }

    @Nonnull
    public TerminologyServiceFactory getTerminologyServiceFactory() {
        return this.terminologyServiceFactory;
    }

    static class EncodeBundleMapPartitionsFunc<T extends IBaseResource>
    extends EncodeMapPartitionsFunc<T> {
        private static final long serialVersionUID = -4264073360143318480L;

        EncodeBundleMapPartitionsFunc(FhirVersionEnum fhirVersion, String inputMimeType, Class<T> resourceClass) {
            super(fhirVersion, inputMimeType, resourceClass);
        }

        @Override
        @Nonnull
        protected Stream<IBaseResource> processResources(@Nonnull Stream<IBaseResource> resources) {
            FhirConversionSupport conversionSupport = FhirConversionSupport.supportFor(this.fhirVersion);
            return resources.flatMap(maybeBundle -> conversionSupport.extractEntryFromBundle((IBaseBundle)maybeBundle, this.resourceClass).stream());
        }
    }

    static class EncodeResourceMapPartitionsFunc<T extends IBaseResource>
    extends EncodeMapPartitionsFunc<T> {
        private static final long serialVersionUID = 6405663463302424287L;

        EncodeResourceMapPartitionsFunc(FhirVersionEnum fhirVersion, String inputMimeType, Class<T> resourceClass) {
            super(fhirVersion, inputMimeType, resourceClass);
        }

        @Override
        @Nonnull
        protected Stream<IBaseResource> processResources(@Nonnull Stream<IBaseResource> resources) {
            return resources.filter(this.resourceClass::isInstance);
        }
    }
}

