/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.library;

import au.csiro.pathling.encoders.FhirEncoders;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.parser.IParser;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.hl7.fhir.instance.model.api.IBaseResource;

abstract class EncodeMapPartitionsFunc<T extends IBaseResource>
implements MapPartitionsFunction<String, T> {
    private static final long serialVersionUID = -189338116652852324L;
    protected FhirVersionEnum fhirVersion;
    protected final String inputMimeType;
    protected final Class<T> resourceClass;

    protected EncodeMapPartitionsFunc(FhirVersionEnum fhirVersion, String inputMimeType, Class<T> resourceClass) {
        this.fhirVersion = fhirVersion;
        this.inputMimeType = inputMimeType;
        this.resourceClass = resourceClass;
    }

    @Nonnull
    protected abstract Stream<IBaseResource> processResources(@Nonnull Stream<IBaseResource> var1);

    @Nonnull
    public Iterator<T> call(@Nonnull Iterator<String> iterator2) {
        IParser parser = this.createParser(this.inputMimeType);
        Iterable iterable = () -> iterator2;
        Stream<IBaseResource> parsedResources = StreamSupport.stream(iterable.spliterator(), false).map(parser::parseResource);
        return this.processResources(parsedResources).iterator();
    }

    @Nonnull
    protected IParser createParser(@Nonnull String mimeType) {
        FhirContext fhirContext = FhirEncoders.contextFor(this.fhirVersion);
        switch (mimeType) {
            case "application/fhir+json": {
                return fhirContext.newJsonParser();
            }
            case "application/fhir+xml": {
                return fhirContext.newXmlParser();
            }
        }
        throw new IllegalArgumentException("Cannot create FHIR parser for mime type: " + mimeType);
    }
}

