/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhirpath.literal;

import au.csiro.pathling.fhirpath.literal.StringLiteral;
import au.csiro.pathling.utilities.Strings;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.Coding;

public abstract class CodingLiteral {
    private static final String SPECIAL_CHARACTERS = "\\s'|\\r\\n\\t(),";
    private static final String COMPONENT_REGEX = String.format("('.*?(?<!\\\\)'|[^%s]*)", "\\s'|\\r\\n\\t(),");
    private static final Pattern CODING_PATTERN = Pattern.compile(String.format("%s\\|%s(?:\\|%s)?(?:\\|%s)?(?:\\|%s)?", COMPONENT_REGEX, COMPONENT_REGEX, COMPONENT_REGEX, COMPONENT_REGEX, COMPONENT_REGEX));
    private static final Pattern NEEDS_QUOTING = Pattern.compile(String.format("[%s]", "\\s'|\\r\\n\\t(),"));
    private static final Pattern NEEDS_UNQUOTING = Pattern.compile("^'(.*)'$");

    @Nonnull
    public static Coding fromString(@Nonnull CharSequence fhirPath) throws IllegalArgumentException {
        Matcher matcher = CODING_PATTERN.matcher(fhirPath);
        if (matcher.matches()) {
            Coding coding = new Coding(CodingLiteral.decodeComponent(matcher.group(1)), CodingLiteral.decodeComponent(matcher.group(2)), null);
            if (Objects.nonNull(matcher.group(3))) {
                coding.setVersion(CodingLiteral.decodeComponent(matcher.group(3)));
            }
            if (Objects.nonNull(matcher.group(4))) {
                coding.setDisplay(CodingLiteral.decodeComponent(matcher.group(4)));
            }
            if (Objects.nonNull(matcher.group(5)) && !matcher.group(5).isBlank()) {
                coding.setUserSelected(Boolean.parseBoolean(CodingLiteral.decodeComponent(matcher.group(5))));
            }
            return coding;
        }
        throw new IllegalArgumentException("Coding literal must be of form: <system>|<code>[|<version>][|<display>[|<userSelected>]]].");
    }

    @Nonnull
    public static String toLiteral(@Nonnull Coding coding) {
        int nonNullHead;
        String[] components = new String[]{coding.getSystem(), coding.getCode(), coding.getVersion(), coding.getDisplay(), coding.hasUserSelected() ? String.valueOf(coding.getUserSelected()) : null};
        for (nonNullHead = components.length; nonNullHead > 2 && components[nonNullHead - 1] == null; --nonNullHead) {
        }
        return Arrays.stream(components).limit(nonNullHead).map(CodingLiteral::encodeComponent).collect(Collectors.joining("|"));
    }

    @Nonnull
    private static String decodeComponent(@Nonnull String component) {
        Matcher matcher = NEEDS_UNQUOTING.matcher(component);
        if (matcher.matches()) {
            String result = Strings.unSingleQuote(component);
            return StringLiteral.unescapeFhirPathString(result);
        }
        return component;
    }

    @Nonnull
    private static String encodeComponent(@Nullable String component) {
        if (component == null) {
            return "";
        }
        Matcher matcher = NEEDS_QUOTING.matcher(component);
        if (matcher.find()) {
            String result = StringLiteral.escapeFhirPathString(component);
            return "'" + result + "'";
        }
        return component;
    }
}

