/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhirpath.function.memberof;

import au.csiro.pathling.fhir.TerminologyServiceFactory;
import au.csiro.pathling.fhirpath.encoding.SimpleCoding;
import au.csiro.pathling.sql.MapperWithPreview;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.utilities.Streams;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MemberOfMapper
implements MapperWithPreview<List<SimpleCoding>, Boolean, Set<SimpleCoding>> {
    private static final Logger log = LoggerFactory.getLogger(MemberOfMapper.class);
    private static final long serialVersionUID = 2879761794073649202L;
    @Nonnull
    private final String requestId;
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;
    @Nonnull
    private final String valueSetUri;

    public MemberOfMapper(@Nonnull String requestId, @Nonnull TerminologyServiceFactory terminologyServiceFactory, @Nonnull String valueSetUri) {
        this.requestId = requestId;
        this.terminologyServiceFactory = terminologyServiceFactory;
        this.valueSetUri = valueSetUri;
    }

    @Override
    @Nonnull
    public Set<SimpleCoding> preview(@Nonnull Iterator<List<SimpleCoding>> input) {
        MDC.put("requestId", this.requestId);
        Set<SimpleCoding> codings = Streams.streamOf(input).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        TerminologyService terminologyService = this.terminologyServiceFactory.buildService(log);
        return terminologyService.intersect(this.valueSetUri, codings);
    }

    @Override
    @Nullable
    public Boolean call(@Nullable List<SimpleCoding> input, @Nonnull Set<SimpleCoding> state) {
        return input != null ? Boolean.valueOf(!Collections.disjoint(state, input)) : null;
    }
}

