import terrascript.core as core


@core.resource(type="aws_emr_security_configuration", namespace="emr")
class SecurityConfiguration(core.Resource):
    """
    (Required) A JSON formatted Security Configuration
    """

    configuration: str | core.StringOut = core.attr(str)

    """
    Date the Security Configuration was created
    """
    creation_date: str | core.StringOut = core.attr(str, computed=True)

    """
    The ID of the EMR Security Configuration (Same as the `name`)
    """
    id: str | core.StringOut = core.attr(str, computed=True)

    """
    (Optional) The name of the EMR Security Configuration. By default generated by Terraform.
    """
    name: str | core.StringOut | None = core.attr(str, default=None, computed=True)

    """
    (Optional) Creates a unique name beginning with the specified
    """
    name_prefix: str | core.StringOut | None = core.attr(str, default=None)

    def __init__(
        self,
        resource_name: str,
        *,
        configuration: str | core.StringOut,
        name: str | core.StringOut | None = None,
        name_prefix: str | core.StringOut | None = None,
        depends_on: list[str] | core.ArrayOut[core.StringOut] | None = None,
        provider: str | core.StringOut | None = None,
        lifecycle: core.Lifecycle | None = None,
    ):
        super().__init__(
            name=resource_name,
            args=SecurityConfiguration.Args(
                configuration=configuration,
                name=name,
                name_prefix=name_prefix,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        configuration: str | core.StringOut = core.arg()

        name: str | core.StringOut | None = core.arg(default=None)

        name_prefix: str | core.StringOut | None = core.arg(default=None)
