from evm_asm.typing import Opcode

from .base import Fork


class Frontier(Fork):
    STOP = Opcode("STOP", 0, 0x00)
    ADD = Opcode("ADD", 3, 0x01)
    MUL = Opcode("MUL", 5, 0x02)
    SUB = Opcode("SUB", 3, 0x03)
    DIV = Opcode("DIV", 5, 0x04)
    SDIV = Opcode("SDIV", 5, 0x05)
    MOD = Opcode("MOD", 5, 0x06)
    SMOD = Opcode("SMOD", 5, 0x07)
    ADDMOD = Opcode("ADDMOD", 8, 0x08)
    MULMOD = Opcode("MULMOD", 8, 0x09)
    EXP = Opcode("EXP", 10, 0x0A)
    SIGNEXTEND = Opcode("SIGNEXTEND", 5, 0x0B)
    LT = Opcode("LT", 3, 0x10)
    GT = Opcode("GT", 3, 0x11)
    SLT = Opcode("SLT", 3, 0x12)
    SGT = Opcode("SGT", 3, 0x13)
    EQ = Opcode("EQ", 3, 0x14)
    ISZERO = Opcode("ISZERO", 3, 0x15)
    AND = Opcode("AND", 3, 0x16)
    OR = Opcode("OR", 3, 0x17)
    XOR = Opcode("XOR", 3, 0x18)
    NOT = Opcode("NOT", 3, 0x19)
    BYTE = Opcode("BYTE", 3, 0x1A)
    SHA3 = Opcode("SHA3", 30, 0x20)
    ADDRESS = Opcode("ADDRESS", 2, 0x30)
    BALANCE = Opcode("BALANCE", 20, 0x31)
    ORIGIN = Opcode("ORIGIN", 2, 0x32)
    CALLER = Opcode("CALLER", 2, 0x33)
    CALLVALUE = Opcode("CALLVALUE", 2, 0x34)
    CALLDATALOAD = Opcode("CALLDATALOAD", 3, 0x35)
    CALLDATASIZE = Opcode("CALLDATASIZE", 2, 0x36)
    CALLDATACOPY = Opcode("CALLDATACOPY", 3, 0x37)
    CODESIZE = Opcode("CODESIZE", 2, 0x38)
    CODECOPY = Opcode("CODECOPY", 3, 0x39)
    GASPRICE = Opcode("GASPRICE", 2, 0x3A)
    EXTCODESIZE = Opcode("EXTCODESIZE", 20, 0x3B)
    EXTCODECOPY = Opcode("EXTCODECOPY", 20, 0x3C)
    BLOCKHASH = Opcode("BLOCKHASH", 20, 0x40)
    COINBASE = Opcode("COINBASE", 2, 0x41)
    TIMESTAMP = Opcode("TIMESTAMP", 2, 0x42)
    NUMBER = Opcode("NUMBER", 2, 0x43)
    DIFFICULTY = Opcode("DIFFICULTY", 2, 0x44)
    GASLIMIT = Opcode("GASLIMIT", 2, 0x45)
    POP = Opcode("POP", 2, 0x50)
    MLOAD = Opcode("MLOAD", 3, 0x51)
    MSTORE = Opcode("MSTORE", 3, 0x52)
    MSTORE8 = Opcode("MSTORE8", 3, 0x53)
    SLOAD = Opcode("SLOAD", 50, 0x54)
    SSTORE = Opcode("SSTORE", 0, 0x55)
    JUMP = Opcode("JUMP", 8, 0x56)
    JUMPI = Opcode("JUMPI", 10, 0x57)
    PC = Opcode("PC", 2, 0x58)
    MSIZE = Opcode("MSIZE", 2, 0x59)
    GAS = Opcode("GAS", 2, 0x5A)
    JUMPDEST = Opcode("JUMPDEST", 1, 0x5B)
    PUSH1 = Opcode("PUSH1", 3, 0x60, input_size_bytes=1)
    PUSH2 = Opcode("PUSH2", 3, 0x61, input_size_bytes=2)
    PUSH3 = Opcode("PUSH3", 3, 0x62, input_size_bytes=3)
    PUSH4 = Opcode("PUSH4", 3, 0x63, input_size_bytes=4)
    PUSH5 = Opcode("PUSH5", 3, 0x64, input_size_bytes=5)
    PUSH6 = Opcode("PUSH6", 3, 0x65, input_size_bytes=6)
    PUSH7 = Opcode("PUSH7", 3, 0x66, input_size_bytes=7)
    PUSH8 = Opcode("PUSH8", 3, 0x67, input_size_bytes=8)
    PUSH9 = Opcode("PUSH9", 3, 0x68, input_size_bytes=9)
    PUSH10 = Opcode("PUSH10", 3, 0x69, input_size_bytes=10)
    PUSH11 = Opcode("PUSH11", 3, 0x6A, input_size_bytes=11)
    PUSH12 = Opcode("PUSH12", 3, 0x6B, input_size_bytes=12)
    PUSH13 = Opcode("PUSH13", 3, 0x6C, input_size_bytes=13)
    PUSH14 = Opcode("PUSH14", 3, 0x6D, input_size_bytes=14)
    PUSH15 = Opcode("PUSH15", 3, 0x6E, input_size_bytes=15)
    PUSH16 = Opcode("PUSH16", 3, 0x6F, input_size_bytes=16)
    PUSH17 = Opcode("PUSH17", 3, 0x70, input_size_bytes=17)
    PUSH18 = Opcode("PUSH18", 3, 0x71, input_size_bytes=18)
    PUSH19 = Opcode("PUSH19", 3, 0x72, input_size_bytes=19)
    PUSH20 = Opcode("PUSH20", 3, 0x73, input_size_bytes=20)
    PUSH21 = Opcode("PUSH21", 3, 0x74, input_size_bytes=21)
    PUSH22 = Opcode("PUSH22", 3, 0x75, input_size_bytes=22)
    PUSH23 = Opcode("PUSH23", 3, 0x76, input_size_bytes=23)
    PUSH24 = Opcode("PUSH24", 3, 0x77, input_size_bytes=24)
    PUSH25 = Opcode("PUSH25", 3, 0x78, input_size_bytes=25)
    PUSH26 = Opcode("PUSH26", 3, 0x79, input_size_bytes=26)
    PUSH27 = Opcode("PUSH27", 3, 0x7A, input_size_bytes=27)
    PUSH28 = Opcode("PUSH28", 3, 0x7B, input_size_bytes=28)
    PUSH29 = Opcode("PUSH29", 3, 0x7C, input_size_bytes=29)
    PUSH30 = Opcode("PUSH30", 3, 0x7D, input_size_bytes=30)
    PUSH31 = Opcode("PUSH31", 3, 0x7E, input_size_bytes=31)
    PUSH32 = Opcode("PUSH32", 3, 0x7F, input_size_bytes=32)
    DUP1 = Opcode("DUP1", 3, 0x80)
    DUP2 = Opcode("DUP2", 3, 0x81)
    DUP3 = Opcode("DUP3", 3, 0x82)
    DUP4 = Opcode("DUP4", 3, 0x83)
    DUP5 = Opcode("DUP5", 3, 0x84)
    DUP6 = Opcode("DUP6", 3, 0x85)
    DUP7 = Opcode("DUP7", 3, 0x86)
    DUP8 = Opcode("DUP8", 3, 0x87)
    DUP9 = Opcode("DUP9", 3, 0x88)
    DUP10 = Opcode("DUP10", 3, 0x89)
    DUP11 = Opcode("DUP11", 3, 0x8A)
    DUP12 = Opcode("DUP12", 3, 0x8B)
    DUP13 = Opcode("DUP13", 3, 0x8C)
    DUP14 = Opcode("DUP14", 3, 0x8D)
    DUP15 = Opcode("DUP15", 3, 0x8E)
    DUP16 = Opcode("DUP16", 3, 0x8F)
    SWAP1 = Opcode("SWAP1", 3, 0x90)
    SWAP2 = Opcode("SWAP2", 3, 0x91)
    SWAP3 = Opcode("SWAP3", 3, 0x92)
    SWAP4 = Opcode("SWAP4", 3, 0x93)
    SWAP5 = Opcode("SWAP5", 3, 0x94)
    SWAP6 = Opcode("SWAP6", 3, 0x95)
    SWAP7 = Opcode("SWAP7", 3, 0x96)
    SWAP8 = Opcode("SWAP8", 3, 0x97)
    SWAP9 = Opcode("SWAP9", 3, 0x98)
    SWAP10 = Opcode("SWAP10", 3, 0x99)
    SWAP11 = Opcode("SWAP11", 3, 0x9A)
    SWAP12 = Opcode("SWAP12", 3, 0x9B)
    SWAP13 = Opcode("SWAP13", 3, 0x9C)
    SWAP14 = Opcode("SWAP14", 3, 0x9D)
    SWAP15 = Opcode("SWAP15", 3, 0x9E)
    SWAP16 = Opcode("SWAP16", 3, 0x9F)
    LOG0 = Opcode("LOG0", 375, 0xA0)
    LOG1 = Opcode("LOG1", 375, 0xA1)
    LOG2 = Opcode("LOG2", 375, 0xA2)
    LOG3 = Opcode("LOG3", 375, 0xA3)
    LOG4 = Opcode("LOG4", 375, 0xA4)
    CREATE = Opcode("CREATE", 32000, 0xF0)
    CALL = Opcode("CALL", 40, 0xF1)
    CALLCODE = Opcode("CALLCODE", 40, 0xF2)
    RETURN = Opcode("RETURN", 0, 0xF3)
    SELFDESTRUCT = Opcode("SELFDESTRUCT", 0, 0xFF)
