# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['TeamMembership']


class TeamMembership(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a GitHub team membership resource.

        This resource allows you to add/remove users from teams in your organization. When applied,
        the user will be added to the team. If the user hasn't accepted their invitation to the
        organization, they won't be part of the team until they do. When
        destroyed, the user will be removed from the team.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        # Add a user to the organization
        membership_for_some_user = github.Membership("membershipForSomeUser",
            role="member",
            username="SomeUser")
        some_team = github.Team("someTeam", description="Some cool team")
        some_team_membership = github.TeamMembership("someTeamMembership",
            role="member",
            team_id=some_team.id,
            username="SomeUser")
        ```

        ## Import

        GitHub Team Membership can be imported using an ID made up of `teamid:username`, e.g.

        ```sh
         $ pulumi import github:index/teamMembership:TeamMembership member 1234567:someuser
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] role: The role of the user within the team.
               Must be one of `member` or `maintainer`. Defaults to `member`.
        :param pulumi.Input[str] team_id: The GitHub team id
        :param pulumi.Input[str] username: The user to add to the team.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['role'] = role
            if team_id is None and not opts.urn:
                raise TypeError("Missing required property 'team_id'")
            __props__['team_id'] = team_id
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__['username'] = username
            __props__['etag'] = None
        super(TeamMembership, __self__).__init__(
            'github:index/teamMembership:TeamMembership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            etag: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'TeamMembership':
        """
        Get an existing TeamMembership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] role: The role of the user within the team.
               Must be one of `member` or `maintainer`. Defaults to `member`.
        :param pulumi.Input[str] team_id: The GitHub team id
        :param pulumi.Input[str] username: The user to add to the team.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["etag"] = etag
        __props__["role"] = role
        __props__["team_id"] = team_id
        __props__["username"] = username
        return TeamMembership(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[str]]:
        """
        The role of the user within the team.
        Must be one of `member` or `maintainer`. Defaults to `member`.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The GitHub team id
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The user to add to the team.
        """
        return pulumi.get(self, "username")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

